% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F08.R
\name{F08}
\alias{F08}
\title{Schwefel Function (F08)}
\usage{
F08(x)
}
\arguments{
\item{x}{Numeric vector of input values.}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function with many local minima. The global minimum is
geometrically distant from the next best local minima, making this function
deceptive and challenging for optimization algorithms.
}
\details{
\strong{Formula:}
\deqn{f(x) = -\sum_{i=1}^{n} x_i \sin(\sqrt{|x_i|})}{
  f(x) = -sum(x_i * sin(sqrt(|x_i|)))}

\strong{Global minimum:} \eqn{f(420.9687, ..., 420.9687) \approx -418.9829 \times n}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: Yes
  \item Differentiable: Yes (except at x_i = 0)
  \item Default bounds: \eqn{[-500, 500]^n}
  \item Default dimensions: 50
}

The Schwefel function is deceptive in that the global minimum is
geometrically distant from the next best local minima. This tests an
algorithm's ability to escape local optima and explore widely.
}
\examples{
F08(c(420.9687, 420.9687))  # Returns approximately -837.97 (near global minimum)
F08(c(0, 0))                # Returns 0

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters.
}
