% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_and_sort.R
\name{complete_and_sort}
\alias{complete_and_sort}
\title{Complete matrices relative to one another and sort into same row, column order}
\usage{
complete_and_sort(
  a,
  b,
  fill = 0,
  margin = c(1, 2),
  roworder = NA,
  colorder = NA
)
}
\arguments{
\item{a}{The first matrix}

\item{b}{The second (optional) matrix.}

\item{fill}{rows and columns added to \code{a} and \code{b} will contain the value \code{fill} (a double).}

\item{margin}{Specifies the dimension(s) of \code{a} and \code{b} over which
completing and sorting will occur}

\item{roworder}{Specifies a custom ordering for rows of returned matrices.
Unspecified rows are dropped.}

\item{colorder}{Specifies a custom ordering for columns of returned matrices.
Unspecified columns are dropped.}
}
\value{
A named list containing completed and sorted versions of \code{a} and \code{b}.
}
\description{
Completes each matrix relative to each other, thereby assuring that
both matrices have same row and column names.
Missing rows and columns (relative to the other matrix)
are filled with \code{fill}.
Thereafter, rows and columns of the matrices are sorted
such that they are in the same order (by name).
To complete rows of \code{a} relative to columns of \code{b}
(and vice versa),
\code{\link[=transpose_byname]{transpose_byname()}} the \code{b} argument.
}
\details{
\code{margin} has nearly the same semantic meaning as in \code{\link[=apply]{apply()}}.
For rows only, give \code{1};
for columns only, give \code{2};
for both rows and columns, give \code{c(1,2)}, the default value.

If only \code{a} is specified, rows of \code{a} are completed and sorted
relative to columns of \code{a}.
If neither \code{a} nor \code{b} have dimnames,
\code{a} and \code{b} are returned unmodified.
If only one of \code{a} or \code{b} has dimnames, an error is thrown.
}
\examples{
m1 <- matrix(c(1:6), nrow=3, dimnames = list(c("r1", "r2", "r3"), c("c2", "c1")))
m2 <- matrix(c(7:12), ncol=3, dimnames = list(c("r3", "r4"), c("c2", "c3", "c4")))
complete_and_sort(m1)
complete_and_sort(m1, m2)
complete_and_sort(m1, m2, roworder = c("r3", "r2", "r1"))
complete_and_sort(m1, m2, colorder = c("c4", "c3")) # Drops un-specified columns
complete_and_sort(m1, m2, margin = 1)
complete_and_sort(m1, m2, margin = 2)
complete_and_sort(m1, t(m2))
complete_and_sort(m1, t(m2), margin = 1)
complete_and_sort(m1, t(m2), margin = 2)
v <- matrix(1:6, ncol=2, dimnames=list(c("r3", "r1", "r2"), c("c2", "c1")))
complete_and_sort(v, v)
# Also works with lists
complete_and_sort(list(m1,m1), list(m2,m2))
}
