% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extgp.R
\name{egpdist}
\alias{egpdist}
\alias{pegp}
\alias{degp}
\alias{qegp}
\alias{regp}
\title{Extended generalized Pareto distribution}
\usage{
pegp(
  q,
  scale,
  shape,
  kappa,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  lower.tail = TRUE,
  log.p = FALSE
)

degp(
  x,
  scale,
  shape,
  kappa,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  log = FALSE
)

qegp(
  p,
  scale,
  shape,
  kappa,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  lower.tail = TRUE,
  log.p = FALSE
)

regp(
  n,
  scale,
  shape,
  kappa,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist")
)
}
\arguments{
\item{scale}{scale parameter, strictly positive.}

\item{shape}{shape parameter.}

\item{kappa}{shape parameter for the tilting distribution.}

\item{model}{string giving the distribution of the model}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p, log}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{x, q}{vector of quantiles}

\item{p}{vector of probabilities}

\item{n}{scalar number of observations}
}
\description{
Density function, distribution function, quantile function and
random number generation for various extended generalized Pareto
distributions
}
\references{
Papastathopoulos, I. and J. Tawn (2013). Extended generalised Pareto models for tail estimation, \emph{Journal of Statistical Planning and Inference} \bold{143}(3), 131--143, <doi:10.1016/j.jspi.2012.07.001>.

Gamet, P. and Jalbert, J. (2022). A flexible extended generalized Pareto distribution for tail estimation. \emph{Environmetrics}, \bold{33}(6), <doi:10.1002/env.2744>.
}
