% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_conditional.R
\name{mid.conditional}
\alias{mid.conditional}
\title{Calculate MID Conditional Expectations}
\usage{
mid.conditional(
  object,
  variable,
  data = NULL,
  resolution = 100L,
  max.nsamples = 1000L,
  type = c("response", "link"),
  keep.effects = TRUE
)
}
\arguments{
\item{object}{a "mid" object.}

\item{variable}{a character string or expression specifying the single predictor variable for which to calculate ICE curves.}

\item{data}{a data frame containing the observations to be used for the ICE calculations. If not provided, data is automatically extracted based on the function call.}

\item{resolution}{an integer specifying the number of evaluation points for the \code{variable}'s range.}

\item{max.nsamples}{an integer specifying the maximum number of samples. If the number of observations exceeds this limit, the \code{data} is randomly sampled.}

\item{type}{the type of prediction to return. "response" (default) for the original scale or "link" for the scale of the linear predictor.}

\item{keep.effects}{logical. If \code{TRUE}, the effects of individual component functions are stored in the output object.}
}
\value{
\code{mid.conditional()} returns an object of class "mid.conditional". This is a list with the following components:
\item{observed}{a data frame of the original observations used, along with their predictions.}
\item{conditional}{a data frame of the hypothetical observations and their corresponding predictions.}
\item{values}{a vector of the sample points for the \code{variable} used in the ICE calculation}
}
\description{
\code{mid.conditional()} calculates the data required to draw Individual Conditional Expectation (ICE) curves from a fitted MID model.
ICE curves visualize how a single observation's prediction changes as a specified variable's value varies, while all other variable are held constant.
}
\details{
The function generates a set of hypothetical observations by creating copies of the original data and varying the specified \code{variable} across a range of sample points.
It then obtains a prediction for each of these hypothetical observations from the MID model. The returned object can be plotted to visualize the ICE curves.
}
\examples{
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, data = airquality, lambda = 1)

# Calculate the ICE values for a fitted MID model
ice <- mid.conditional(mid, variable = "Wind", data = airquality)
print(ice)
}
\seealso{
\code{\link{interpret}}, \code{\link{plot.mid.conditional}}, \code{\link{ggmid.mid.conditional}}
}
