# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

test_that("get_filename functions correctly", {
  # Setup test files
  csv_files <- mintyr_example(
    mintyr_examples(pattern = "\\.csv$")
  )
  
  # Test basic functionality
  test_that("basic functionality works", {
    # Test with default parameters (rm_extension = TRUE, rm_path = TRUE)
    result <- get_filename(csv_files)
    expect_type(result, "character")
    expect_false(any(grepl("/", result)))  # No path components
    expect_false(any(grepl("\\.", result)))  # No extensions
    
    # Verify results match expected pattern
    for (i in seq_along(result)) {
      expect_equal(
        result[i],
        sub("\\.[^.]*$", "", basename(csv_files[i]))
      )
    }
  })
  
  # Test different parameter combinations
  test_that("parameter combinations work correctly", {
    # Keep extension, remove path
    result1 <- get_filename(csv_files, rm_extension = FALSE, rm_path = TRUE)
    expect_true(all(grepl("\\.csv$", result1)))
    expect_false(any(grepl("/", result1)))
    
    # Keep path, remove extension
    result2 <- get_filename(csv_files, rm_extension = TRUE, rm_path = FALSE)
    expect_false(any(grepl("\\.csv$", result2)))
    expect_true(any(grepl("/", result2)))
    
    # Keep both path and extension
    expect_warning(
      result3 <- get_filename(csv_files, rm_extension = FALSE, rm_path = FALSE),
      "Setting both rm_extension=FALSE and rm_path=FALSE returns the original paths"
    )
    expect_equal(result3, csv_files)
  })
  
  # Test error handling
  test_that("error handling works correctly", {
    # Test missing parameter
    expect_error(
      get_filename(),
      "Parameter 'paths' cannot be empty"
    )
    
    # Test invalid input type
    expect_error(
      get_filename(123),
      "'paths' must be a character vector"
    )
    
    expect_error(
      get_filename(list("path")),
      "'paths' must be a character vector"
    )
  })
  
  # Test edge cases
  test_that("edge cases are handled correctly", {
    # Empty vector
    expect_equal(
      get_filename(character(0)),
      character(0)
    )
    
    # Single file
    single_file <- csv_files[1]
    result <- get_filename(single_file)
    expect_length(result, 1)
    expect_equal(
      result,
      sub("\\.[^.]*$", "", basename(single_file))
    )
    
    # Files without extensions
    no_ext_files <- sub("\\.csv$", "", csv_files)
    result <- get_filename(no_ext_files)
    expect_equal(
      result,
      basename(no_ext_files)
    )
    
    # Files with multiple extensions (e.g., "file.tar.gz")
    multi_ext_file <- c(
      "path/to/file.csv",
      "path/to/data.backup.csv"
    )
    result <- get_filename(multi_ext_file)
    expect_equal(
      result,
      c("file", "data.backup")
    )
  })
})
