% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.move.R
\name{df.move}
\alias{df.move}
\title{Move Variable(s) in a Data Frame}
\usage{
df.move(data, ..., before = NULL, after = NULL, first = TRUE, check = TRUE)
}
\arguments{
\item{data}{a data frame.}

\item{...}{an expression indicating the variable names in \code{data} to
move. Note that the operators \code{+}, \code{-}, \code{~}, \code{:}, \code{::}, and \code{!} can also be used to
select variables, see Details in the \code{\link{df.subset}}
function.}

\item{before}{a character string indicating a variable in \code{data}.
Variable(s) specified in \code{...} are moved to the left-hand
side of this variable.}

\item{after}{a character string indicating a variable in \code{data}.
Variable(s) specified in \code{...} are moved to the right-hand
side of this variable.}

\item{first}{logical: if \code{TRUE} (default), variable(s) specified in
\code{...} will be moved to the first position in 'data', if
\code{FALSE}, variable(s) specified in \code{...} will be moved
to the last position in 'data'.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns the data frame in \code{data} with columns in a different place.
}
\description{
This function moves variables to a different position in the data frame, i.e.,
changes the column positions in the data frame. By default, variables specified
in the first argument \code{...} are moved to the first position in the data
frame specified in the argument \code{data}.
}
\examples{
# Example 1: Move variables 'hp' and 'am' to the first position
df.move(mtcars, hp, am)

# Example 2: Move variables 'hp' and 'am' to the last position
df.move(mtcars, hp, am, first = FALSE)

# Example 3: Move variables 'hp' and 'am' to the left-hand side of 'disp'
df.move(mtcars, hp, am, before = "disp")

# Example 4: Move variables 'hp' and 'am' to the right-hand side of 'disp'
df.move(mtcars, hp, am, after = "disp")
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{df.check}}, \code{\link{df.duplicated}}, \code{\link{df.unique}},
\code{\link{df.head}}, \code{\link{df.tail}}, \code{\link{df.long}},
\code{\link{df.wide}}, \code{\link{df.merge}},
\code{\link{df.rbind}}, \code{\link{df.rename}}, \code{\link{df.sort}},
\code{\link{df.subset}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
