LONBGLSS <- function(y,e,X,g,w,z,k,max.steps,sparse, structure, iterations,burn.in=NULL){
  n = nrow(g)
  m = ncol(g)
  p = ncol(w)
  c = ncol(z)
  E = cbind(e,X)
  q = ncol(E)
  o = ncol(X)
  n1 = n/k
  hatAta=matrix(c(rep(1,n1*c)),nrow=c)
  hatBeta = rep(1,m)
  hatEta = rep(1,p)
  hatAlpha = rep(1,q)
  hatInvTauSq1=rep(1,m)
  hatInvTauSq21=rep(1,p)
  hatInvTauSq22=rep(1,m)
  hatPiEta=1/2
  hatPiBeta=1/2
  invSigAlpha0 = rep(10^-3,q)
  hatLambdaSqStar1=1
  hatLambdaSqStar2=1
  hatSigmaSq=1
  hatPhi1Sq= hatPhi2Sq=1
  a0=aStar=1
  b0=bStar=1
  alpha=1
  gamma=1
  alpha1=0
  gamma1=0
  mu0=mu1=1
  nu0=nu1=1
  debugging=FALSE

  progress = ifelse(debugging, 10^(floor(log10(max.steps))-1), 0)

  if (is.null(burn.in)) {
    BI <- 0
  } else if (burn.in >= 1) {
    BI <- as.integer(burn.in)
  } else {
    stop("burn.in must be NULL or a positive integer.")
  }

  if (iterations <= BI) {
    stop("iterations must be larger than burn.in.")
  }

  if(sparse){
    fit=switch (structure,
                "bi-level" = BGLSS(y,E,g,w,z,q,o,k,max.steps,hatAlpha,hatBeta,hatAta,hatEta,invSigAlpha0,hatInvTauSq1,hatInvTauSq22,hatPiBeta,hatPiEta,hatLambdaSqStar1
                                ,hatLambdaSqStar2,hatSigmaSq,hatPhi1Sq,hatPhi2Sq,a0,b0,aStar,bStar,alpha,gamma,alpha1,gamma1,mu0,mu1,nu0,nu1,progress),
                "individual" = BLSS(y,E,g,w,z,q,k,max.steps,hatAlpha,hatBeta,hatAta,hatEta,invSigAlpha0,hatInvTauSq1,hatInvTauSq21,hatPiBeta,hatPiEta,hatLambdaSqStar1
                                    ,hatLambdaSqStar2,hatSigmaSq,hatPhi1Sq,hatPhi2Sq,a0,b0,aStar,bStar,alpha,gamma,alpha1,gamma1,mu0,mu1,nu0,nu1,progress)
    )
  }else{
    fit=switch (structure,
                "bi-level" = BGL(y,E,g,w,q,o,k,max.steps,hatAlpha,hatBeta,hatEta,hatAta,z,invSigAlpha0,hatInvTauSq1,hatInvTauSq22,hatLambdaSqStar1
                              ,hatLambdaSqStar2,hatSigmaSq,a0,b0,aStar,bStar,hatPhi1Sq,hatPhi2Sq,alpha,gamma,alpha1,gamma1,progress),
                "individual" = BL(y,E,g,w,q,k,max.steps,hatAlpha,hatBeta,hatEta,hatAta,z,invSigAlpha0,hatInvTauSq1,hatInvTauSq21,hatLambdaSqStar1
                                  ,hatLambdaSqStar2,hatSigmaSq,a0,b0,aStar,bStar,hatPhi1Sq,hatPhi2Sq,alpha,gamma,alpha1,gamma1,progress)
    )
  }
  if (is.null(burn.in) || BI == 0) {
    out <- list(
      GS.gamma1 = fit$GS.alpha[, 1:(q-o)],
      GS.gamma0 = fit$GS.alpha[, -(1:(q-o))],
      GS.gamma2 = fit$GS.beta,
      GS.gamma3 = fit$GS.eta,
      GS.alpha  = fit$GS.ata
    )
  } else {
    burn_rows <- seq_len(BI)
    out <- list(
      GS.gamma1 = fit$GS.alpha[-burn_rows,1:(q-o)],
      GS.gamma0 = fit$GS.alpha[-burn_rows,-(1:(q-o))],
      GS.gamma2 = fit$GS.beta[-burn_rows,],
      GS.gamma3 = fit$GS.eta[-burn_rows,],
      GS.alpha  = fit$GS.ata[-burn_rows,]
    )
  }
  out
}
