% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm_tdiff_multivariate.r
\name{mm_tdiff_multivariate_general}
\alias{mm_tdiff_multivariate_general}
\title{Moment-Matching Approximation for General Multivariate t-Differences}
\usage{
mm_tdiff_multivariate_general(mu1, Sigma1, nu1, mu2, Sigma2, nu2)
}
\arguments{
\item{mu1}{Location vector of first distribution (length p)}

\item{Sigma1}{Scale matrix of first distribution (p x p, positive definite)}

\item{nu1}{Degrees of freedom of first distribution (must be > 4)}

\item{mu2}{Location vector of second distribution (length p)}

\item{Sigma2}{Scale matrix of second distribution (p x p, positive definite)}

\item{nu2}{Degrees of freedom of second distribution (must be > 4)}
}
\value{
An S3 object of class "mm_tdiff_multivariate_general" containing:
  \item{mu_diff}{Location vector of difference}
  \item{Sigma_star}{Scale matrix}
  \item{nu_star}{Degrees of freedom (scalar)}
  \item{method}{Character string "multivariate_general"}
}
\description{
Approximates the distribution of differences between two independent
multivariate t-distributed random vectors with arbitrary covariance
structure.
}
\details{
This function handles the general case where components may be correlated
within each multivariate t-distribution. The approximation uses a single
scalar degrees of freedom parameter to capture the overall tail behavior.

Note: For high dimensions with heterogeneous component behaviors,
consider using \code{\link{mm_tdiff_multivariate_independent}} instead.
}
\examples{
Sigma1 <- matrix(c(1, 0.3, 0.3, 1), 2, 2)
Sigma2 <- matrix(c(1.5, 0.5, 0.5, 1.2), 2, 2)
result <- mm_tdiff_multivariate_general(
  mu1 = c(0, 1), Sigma1 = Sigma1, nu1 = 10,
  mu2 = c(0, 0), Sigma2 = Sigma2, nu2 = 15
)
print(result)

}
