% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bca_ci.R
\name{bca_ci}
\alias{bca_ci}
\title{Bias-Corrected and Accelerated (BCa) Bootstrap Confidence Interval}
\usage{
bca_ci(x, R = 2000, conf = 0.95)
}
\arguments{
\item{x}{numeric vector of data.}

\item{R}{integer number of bootstrap replicates (default 2000).}

\item{conf}{numeric confidence level between 0 and 1 (default 0.95).}
}
\value{
A list with elements boot (object) and ci (matrix).
}
\description{
Computes BCa confidence interval for the mean using the boot package.
}
\examples{
set.seed(42)
x <- rnorm(50, mean = 5, sd = 2)
result <- bca_ci(x, R = 500)
result$ci

}
