% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{list_current_schemas}
\alias{list_current_schemas}
\title{List Schemas in the Current Database}
\usage{
list_current_schemas(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A \code{dbplyr} lazy tibble with columns:
\itemize{
\item \code{catalog_name} — the current database name.
\item \code{schema_name} — each schema within that database.
}
}
\description{
Returns a lazy tibble of all schemas in the \strong{current database} of the
connection. Queries \code{information_schema.schemata} and filters to the
current database (\code{catalog_name = current_database()}).
}
\details{
\itemize{
\item This function assumes the connection is valid (checked with
\code{validate_con()}).
\item Returns a \code{dbplyr} lazy table; use \code{collect()} to bring the result into R.
}
}
\seealso{
Other db-list: 
\code{\link{list_all_databases}()},
\code{\link{list_all_tables}()},
\code{\link{list_current_tables}()},
\code{\link{list_extensions}()},
\code{\link{list_fns}()},
\code{\link{list_setting}()},
\code{\link{list_shares}()}
}
\concept{db-list}
