% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesians.R
\name{as.mcmc.mtar}
\alias{as.mcmc.mtar}
\title{Coercion of \code{mtar} objects to \code{mcmc} objects}
\usage{
\method{as.mcmc}{mtar}(x, ...)
}
\arguments{
\item{x}{an object of class \code{mtar} obtained from a call to \code{mtar()}.}

\item{...}{additional arguments passed to specific coercion methods.}
}
\value{
A list of \code{mcmc} objects containing the posterior simulation draws
generated by the \code{mtar()} routine.
}
\description{
This method converts an object of class \code{mtar} into a list of
\code{mcmc} objects, each corresponding to a Markov chain produced during
Bayesian estimation.
}
\examples{
\donttest{
###### Example 1: Returns of the closing prices of three financial indexes
data(returns)
fit1 <- mtar(~ COLCAP + BOVESPA | SP500, data=returns, row.names=Date,
             subset={Date<="2016-03-14"}, dist="Student-t",
             ars=ars(nregim=3,p=c(1,1,2)), n.burnin=2000, n.sim=3000,
             n.thin=2)
fit1.mcmc <- coda::as.mcmc(fit1)
summary(fit1.mcmc)

###### Example 2: Rainfall and two river flows in Colombia
data(riverflows)
fit2 <- mtar(~ Bedon + LaPlata | Rainfall, data=riverflows, row.names=Date,
             subset={Date<="2009-04-04"}, dist="Laplace",
             ars=ars(nregim=3,p=5), n.burnin=2000, n.sim=3000, n.thin=2)
fit2.mcmc <- coda::as.mcmc(fit2)
summary(fit2.mcmc)

###### Example 3: Temperature, precipitation, and two river flows in Iceland
data(iceland.rf)
fit3 <- mtar(~ Jokulsa + Vatnsdalsa | Temperature | Precipitation,
             data=iceland.rf, subset={Date<="1974-12-21"}, row.names=Date,
             ars=ars(nregim=2,p=15,q=4,d=2), n.burnin=2000, n.sim=3000,
             n.thin=2, dist="Slash")
fit3.mcmc <- coda::as.mcmc(fit3)
summary(fit3.mcmc)
}
}
\seealso{
\code{\link[coda]{as.mcmc}}
}
