% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_int.R
\name{calc_growth}
\alias{calc_growth}
\title{Calculate von Bertalanffy length-at-age}
\usage{
calc_growth(
  Linf_s,
  K_s,
  t0_s,
  ns = length(Linf_s),
  nm = 4,
  ny = 20,
  a = seq(1, 10) - 1
)
}
\arguments{
\item{Linf_s}{Vector by stock \code{s} of asymptotic length}

\item{K_s}{Vector by stock \code{s} of the growth coefficient}

\item{t0_s}{Vector by \code{s} of the age at length zero.}

\item{ns}{Integer, number of stocks}

\item{nm}{Integer, number of seasons}

\item{ny}{Integer, number of years}

\item{a}{Integer vector of ages}
}
\value{
Array \verb{[y, m, a, s]}
}
\description{
Returns an array of length-at-age with seasonal dimension.
Useful for \linkS4class{MSAdata} inputs.
}
\examples{
len_ymas <- calc_growth(c(30, 40), c(0.4, 0.2), c(-1, -1))

# Calculate stock weight at age
a_s <- rep(1e-6, 2)
b_s <- c(3, 3.1)

ns <- length(a_s)
swt_ymas <- sapply(1:ns, function(s) {
  a_s[s]*len_ymas[, , , s]^b_s[s]
}, simplify = "array")
}
