% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composed_projector.R
\name{inverse_projection.composed_projector}
\alias{inverse_projection.composed_projector}
\title{Compute the Inverse Projection for a Composed Projector}
\usage{
\method{inverse_projection}{composed_projector}(x, ...)
}
\arguments{
\item{x}{A \code{composed_projector} object.}

\item{...}{Additional arguments passed to the underlying \code{inverse_projection} methods.}
}
\value{
A matrix representing the combined pseudo-inverse.
}
\description{
Calculates the pseudo-inverse of the composed projector, mapping from the
final output space back towards the original input space. This is computed
by multiplying the pseudo-inverses of the individual projector stages in
reverse order: \verb{V_k+ \%*\% ... \%*\% V_2+ \%*\% V_1+}.
}
\details{
Requires that each stage implements the \code{inverse_projection} method.
}
