% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc-generics.R
\name{inverse_transform}
\alias{inverse_transform}
\title{Inverse transform data using a fitted preprocessing pipeline}
\usage{
inverse_transform(object, X, ...)
}
\arguments{
\item{object}{A fitted preprocessing object}

\item{X}{A matrix or data frame of transformed data to reverse}

\item{...}{Additional arguments passed to methods}
}
\value{
The data matrix in original scale
}
\description{
Reverse the preprocessing transformation, converting transformed data
back to the original scale. The preprocessing object must have been
fitted before calling this function.
}
\examples{
# Inverse transform data back to original scale
X <- matrix(rnorm(100), 10, 10)
preproc <- center()
fitted_preproc <- fit(preproc, X)
X_transformed <- transform(fitted_preproc, X)
X_reconstructed <- inverse_transform(fitted_preproc, X_transformed)

# X and X_reconstructed should be approximately equal
all.equal(X, X_reconstructed)
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[=fit_transform]{fit_transform()}}, \code{\link[=transform]{transform()}}
}
