% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifier.R
\name{predict.rf_classifier}
\alias{predict.rf_classifier}
\title{Predict Class Labels using a Random Forest Classifier Object}
\usage{
\method{predict}{rf_classifier}(object, new_data, ncomp = NULL, colind = NULL, ...)
}
\arguments{
\item{object}{A fitted object of class \code{rf_classifier}.}

\item{new_data}{A numeric matrix or vector of new observations to classify. Rows are observations,
columns are variables matching the original data space used by the projector OR matching \code{colind} if provided.}

\item{ncomp}{Optional integer; the number of components to use from the projector for classification (default: all components used during classifier creation).}

\item{colind}{Optional numeric vector specifying column indices from the original data space.
If provided, \code{new_data} is projected using only these features (\code{partial_project}). This overrides any
\code{colind} stored default in the \code{object}. The resulting projection is compared against the
reference scores (\code{object$scores}) stored in the classifier.}

\item{...}{Extra arguments passed to \code{predict.randomForest}.}
}
\value{
A list containing:
\item{class}{Predicted class labels (typically factor) from the random forest model.}
\item{prob}{A numeric matrix of predicted class probabilities from the random forest model.}
}
\description{
Predicts class labels and probabilities for new data using a fitted \code{rf_classifier} object.
This method projects the \code{new_data} into the component space and then uses the stored
\code{randomForest} model to predict outcomes.
}
\seealso{
\code{\link{rf_classifier.projector}}, \code{\link[randomForest]{predict.randomForest}}

Other classifier predict: 
\code{\link{predict.classifier}()}
}
\concept{classifier predict}
