% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{reconstruct_new}
\alias{reconstruct_new}
\title{Reconstruct new data in a model's subspace}
\usage{
reconstruct_new(x, new_data, ...)
}
\arguments{
\item{x}{The fitted model object (e.g., \code{bi_projector}) that defines
a subspace or factorization.}

\item{new_data}{A numeric matrix (or data frame) of shape
\code{(n x p_full)} or possibly fewer columns if you allow partial reconstruction.}

\item{...}{Additional arguments passed to the specific \code{reconstruct_new} method
for the class of \code{x}.}
}
\value{
A numeric matrix (same number of rows as \code{new_data}, and typically
the same number of columns if you're reconstructing fully) representing the
rank-d approximation in the model's subspace.
}
\description{
This function takes a model (e.g., \code{projector} or \code{bi_projector}) and a new dataset,
and computes the rank-d approximation of the new data in the same subspace that
was defined by the model. In other words, we \strong{project} the new data into
the fitted subspace and then \strong{map it back} to the original dimensionality.
}
\details{
Similar to \code{\link{reconstruct}} but operates on an external \code{new_data}
rather than the original fitted data. Often used to see how well the model's
subspace explains unseen data.
}
\seealso{
\code{\link{reconstruct}} for reconstructing the original data in the model.

Other reconstruct: 
\code{\link{reconstruct}()}
}
\concept{reconstruct}
