% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes_filter.R
\name{genes_lowly_expressed}
\alias{genes_lowly_expressed}
\title{Select Lowly Expressed Genes}
\usage{
genes_lowly_expressed(phyex_set, threshold = 1)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{threshold}{Mean expression threshold (default: 1)}
}
\value{
Character vector of gene IDs with mean expression <= threshold
}
\description{
Select genes with mean expression below a specified threshold.
}
\details{
This function identifies genes with low mean expression levels, which
might be candidates for filtering or separate analysis.
}
\examples{
# Select genes with mean expression <= 1
low_expr_genes <- genes_lowly_expressed(example_phyex_set, threshold = 1)

}
