% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.nifti.R
\name{boxplot.nifti}
\alias{boxplot.nifti}
\alias{boxplot.anlz}
\title{Boxplot of Values in an Image}
\usage{
\method{boxplot}{nifti}(x, ..., mask)

\method{boxplot}{anlz}(x, ..., mask)
}
\arguments{
\item{x}{Object of class \code{nifti}}

\item{...}{Arguments passed to \code{\link{boxplot.default}}}

\item{mask}{object to subset the image.  If missing, then all 
values of the image are plotted.}
}
\value{
Output of \code{\link{boxplot}}
}
\description{
Computes the boxplot of values
of an image with the option for a mask.
}
\examples{
img = nifti(array(rnorm(10^3), dim = rep(10, 3)))
mask = img > 0
boxplot(img)
boxplot(img, mask = mask)
boxplot(as.anlz(img))
}
