% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_procrustes_loadings.R
\name{plot_procrustes_loadings}
\alias{plot_procrustes_loadings}
\title{Plot loadings with confidence bands from \code{procrustes_loadings()}}
\usage{
plot_procrustes_loadings(proc_loadings, pc_no = 1, loadings_confint = 0.9)
}
\arguments{
\item{proc_loadings}{a tibble, generated by \code{\link[=procrustes_loadings]{procrustes_loadings()}}}

\item{pc_no}{an integer indicating which PC to plot.}

\item{loadings_confint}{confidence limits for generated confidence intervals.
(default: 0.9 to match \code{pca_test()}).}
}
\value{
a \code{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Plot index loadings or loadings with
confidence intervals and null distributions generated by bootstrapping and
permutation followed by Procrustes rotation. This approach works when
PC loadings are unstable due to multiple PCs explaining similar amounts of
variance. This is an alternative to the use of bootstrapping without
Procrustes rotation (as in \code{\link[=pca_test]{pca_test()}}) and avoids the need for the use
of the \code{filter_boots} argument to \code{\link[=plot_loadings]{plot_loadings()}}.
}
\examples{
  proc_loadings <- procrustes_loadings(
    pca_data = onze_intercepts |> dplyr::select(-speaker),
    max_pcs = 3,
    index = TRUE,
    n = 10, # set this to at least 100 in actual use.
    scale = TRUE
   )

   plot_procrustes_loadings(proc_loadings, pc_no = 2)

}
