% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_oblicubes.R
\name{geom_oblicubes}
\alias{geom_oblicubes}
\title{Draw 2D/3D cubes with ggplot2}
\usage{
geom_oblicubes(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  angle = 45,
  scale = 0.5,
  xoffset = 0,
  yoffset = 0,
  zoffset = 0,
  light = darken_face,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Aesthetics, used to set an aesthetic to a fixed value.}

\item{angle}{Oblique projection angle.}

\item{scale}{Oblique projection foreshortening factor.
0.5 corresponds to the \dQuote{cabinet projection}.
1.0 corresponds to the \dQuote{cavalier projection}.
0.0 corresponds to a \dQuote{primary view orthographic projection}.}

\item{xoffset, yoffset, zoffset}{By default the x,y,z values are assumed to be the \strong{center} of the cube.
Use \code{xoffset}, \code{yoffset}, and/or \code{zoffset} to shift the x,y,z values a fixed amount.}

\item{light}{If \code{FALSE} don't perform a "light" effect.
Otherwise a function that takes two arguments:
the first \code{face} of the cube/cuboid face
(one of "top", "west", "east", "south", "north").
the second \code{col} of the fill color.
By default we use \code{\link[=darken_face]{darken_face()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}
}
\value{
A ggplot2 geom.
}
\description{
\code{geom_oblicubes()} creates a \code{ggplot2} geom that draws cubes.
}
\details{
\code{geom_oblicubes()} requires a fixed scale coordinate system with an aspect
ratio of 1 as provided by \code{ggplot2::coord_fixed()}.
}
\section{Aesthetics}{

\code{geom_oblicubes()} understands the following aesthetics (required aesthetics are in bold).
See \code{\link[=oblicubesGrob]{oblicubesGrob()}} for more details.
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{z}
\item \code{fill}
\item \code{colour}
\item \code{linetype}
\item \code{linewidth}
}
}

\examples{
if (require("ggplot2")) {
  data("volcano", package = "datasets")
  df <- xyz_heightmap(volcano, scale = 0.3, min = 1)
  g <- ggplot(df, aes(x, y, z = z, fill = raw)) +
         geom_oblicubes(light = FALSE) +
         coord_fixed() +
         scale_fill_gradientn(name = "Height (m)",
                              colours=terrain.colors(256)) +
         labs(x = "East (10m)", y = "North (10m)",
              title = "Maungawhau (`datasets::volcano`)")
  plot(g)
}
\donttest{
if (require("ggplot2")) {
  # Using `scale_fill_identity()` if using `xyz_heightmap()`'s `fill` column
  df <- xyz_heightmap(volcano, scale = 0.3, min = 1,
                      col = grDevices::heat.colors)
  g <- ggplot(df, aes(x, y, z = z, fill = fill)) +
         geom_oblicubes() +
         coord_fixed() +
         scale_fill_identity()
  plot(g)
}
}
if (require("ggplot2") && require("dplyr")) {
  # Note you probably should not do 3D bar charts...
  df <- as.data.frame(datasets::Titanic) \%>\%
          filter(Age == "Child", Freq > 0) \%>\%
          group_by(Sex, Survived, Class) \%>\%
          reframe(Freq = seq.int(sum(Freq)))
  g <- ggplot(df, aes(x = Survived, y = Freq, fill = Survived)) +
      facet_grid(cols = vars(Class, Sex)) +
      coord_fixed() +
      geom_oblicubes(yoffset = -0.5, zoffset = -0.5, angle = -45, scale = 0.7) +
      scale_fill_manual(values = c("Yes" = "lightblue", "No" = "red")) +
      scale_y_continuous(expand = expansion(), name = "") +
      scale_x_discrete(name = "", breaks = NULL) +
      labs(title = "Children on the Titanic (by ticket class)")
  plot(g)
}
}
\seealso{
\code{geom_oblicubes()} is a wrapper around \code{\link[=oblicubesGrob]{oblicubesGrob()}}.
}
