% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_normalize.R
\name{pqn_normalize}
\alias{pqn_normalize}
\title{Perform Probabilistic Quotient Normalization for intensities}
\usage{
pqn_normalize(data)
}
\arguments{
\item{data}{A data frame containing the sample data. The first column
should contain the sample identifiers, and the rest of the columns
contain the peaks to be normalized.}
}
\value{
A data frame with the first column as the sample identifiers and
the rest of the columns containing the normalized peak intensities.
}
\description{
Perform Probabilistic Quotient Normalization (PQN) for sample intensities.
The PQN method determines a dilution factor for each sample by comparing
the distribution of quotients between samples and a reference spectrum,
followed by sample normalization using this dilution factor.
The reference spectrum in this method is the median spectrum of all samples.
}
\examples{
# Load the CSV data
data_file <- system.file("extdata", "example2.csv", package = "omicsTools")
data <- readr::read_csv(data_file)

# Display the first few rows of the original data
print(head(data))

# Apply the pqn_normalize function
normalized_data <- pqn_normalize(data)

# Display the first few rows of the normalized data
print(head(normalized_data))

\donttest{
# Write the normalized data to a new CSV file
readr::write_csv(normalized_data, paste0(tempdir(), "/normalized_data.csv"))
}
}
\references{
Dieterle, F., Ross, A., Schlotterbeck, G., & Senn, H. (2006).
Probabilistic quotient normalization as robust method to account for dilution
of complex biological mixtures. Application in 1H NMR metabonomics.
Analytical chemistry, 78(13), 4281-4290.
}
\author{
Yaoxiang Li
}
