% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{apply_numfmt}
\alias{apply_numfmt}
\title{Format Values using OOXML (Spreadsheet) Number Format Codes}
\usage{
apply_numfmt(value, format_code)
}
\arguments{
\item{value}{A vector of values to format. Supports \code{numeric}, \code{Date},
\code{POSIXct}, \code{character} (ISO dates or times), \code{hms}, or \code{difftime}.}

\item{format_code}{A character vector of format strings (e.g., \code{"#,##0.00"},
\code{"yyyy-mm-dd"}, or \code{"[h]:mm:ss"}).}
}
\value{
A character vector of formatted strings.
}
\description{
This function emulates a spreadsheet formatting engine. It takes numeric,
date, or character values and applies an OOXML format code to produce
a formatted string. It supports standard number formatting, date/time,
elapsed durations, fractions, and conditional formatting sections.
}
\details{
The function splits the \code{format_code} into up to four sections separated
by semicolons (Positive; Negative; Zero; Text).

\itemize{
\item \bold{Date and Time:} Supports standard tokens (\code{yyyy}, \code{mm}, \code{dd},
\code{hh}, \code{ss}) and AM/PM toggles.
\item \bold{Durations:} Supports elapsed time tokens in square brackets,
such as \verb{[h]}, \verb{[m]}, and \verb{[s]}, calculating total units.
\item \bold{HMS Handling:} Character strings in "HH:MM:SS" format are
automatically coerced to a date-time object using a base date
to allow clock and duration formatting.
\item \bold{Numbers:} Supports thousands separators (\verb{,}), precision,
percentage conversion, and scientific notation (\verb{E+}).
\item \bold{Fractions:} Uses the Farey algorithm to approximate decimals
as fractions (e.g., \verb{?/?}, \verb{# ?/?}).
\item \bold{Conditionals:} Evaluates bracketed conditions like \verb{[<1000]}
to select the appropriate formatting section.
\item \bold{Literals:} Handles escaped characters (\verb{\\\\}), quoted
text (\code{"text"}), and the text placeholder (\code{@}).
}

Rounding is based on the R function \code{round()} and does not match spreadsheet
software behavior.
}
\examples{
# Numeric formatting
apply_numfmt(1234.5678, "#,##0.00") # "1,234.57"

# Date and Time
apply_numfmt("2025-01-05", "dddd, mmm dd") # "Sunday, Jan 05"
apply_numfmt("13:45:30", "hh:mm AM/PM")    # "01:45 PM"

# Durations
apply_numfmt("1900-01-12 08:17:47", "[h]:mm:ss") # "296:17:47"

# Fractions
apply_numfmt(1.75, "# ?/?") # "1 3/4"

}
