% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic_batch_api.R
\name{parse_anthropic_batch_output}
\alias{parse_anthropic_batch_output}
\title{Parse Anthropic Message Batch output into a tibble}
\usage{
parse_anthropic_batch_output(
  jsonl_path,
  tag_prefix = "<BETTER_SAMPLE>",
  tag_suffix = "</BETTER_SAMPLE>"
)
}
\arguments{
\item{jsonl_path}{Path to a \code{.jsonl} file produced by
\code{\link{anthropic_download_batch_results}}.}

\item{tag_prefix}{Prefix for the better-sample tag. Defaults to
\code{"<BETTER_SAMPLE>"}.}

\item{tag_suffix}{Suffix for the better-sample tag. Defaults to
\code{"</BETTER_SAMPLE>"}.}
}
\value{
A tibble with one row per result. The columns mirror
\code{\link{anthropic_compare_pair_live}} with batch-specific additions:

\describe{
\item{custom_id}{Batch custom ID (for example \code{"ANTH_S01_vs_S02"}).}
\item{ID1, ID2}{Sample IDs recovered from \code{custom_id}.}
\item{model}{Model name reported by Anthropic.}
\item{object_type}{Anthropic object type (for example \code{"message"}).}
\item{status_code}{HTTP-style status code (200 for succeeded results,
\code{NA} otherwise).}
\item{result_type}{One of \code{"succeeded"}, \code{"errored"},
\code{"canceled"}, \code{"expired"}.}
\item{error_message}{Error message for non-succeeded results,
otherwise NA.}
\item{thoughts}{Extended thinking text returned by Claude when reasoning
is enabled (for example when \code{reasoning = "enabled"}),
otherwise NA.}
\item{content}{Concatenated assistant text for succeeded results.}
\item{better_sample}{"SAMPLE_1", "SAMPLE_2", or NA.}
\item{better_id}{ID1 if SAMPLE_1 is chosen, ID2 if SAMPLE_2 is chosen,
otherwise NA.}
\item{prompt_tokens}{Prompt / input token count (if reported).}
\item{completion_tokens}{Completion / output token count (if reported).}
\item{total_tokens}{Total token count (reported or computed upstream).}
}
}
\description{
This function parses a \code{.jsonl} file produced by
\code{\link{anthropic_download_batch_results}}. Each line in the file
is a JSON object with at least:
}
\details{
\preformatted{
{
  "custom_id": "ANTH_S01_vs_S02",
  "result": {
    "type": "succeeded" | "errored" | "canceled" | "expired",
    "message": { ... }  # when type == "succeeded"
    "error":   { ... }  # when type == "errored" (optional)
  }
}
}

Results may be returned in any order. This function uses the
\code{custom_id} field to recover \code{ID1} and \code{ID2} and then
applies the same parsing logic as \code{\link{anthropic_compare_pair_live}},
including extraction of extended thinking blocks (when enabled) into
a separate \code{thoughts} column.
}
\examples{
\dontrun{
# Requires a completed Anthropic batch file
tbl <- parse_anthropic_batch_output("anthropic-results.jsonl")
}

}
