% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt_template.R
\name{set_prompt_template}
\alias{set_prompt_template}
\title{Get or set a prompt template for pairwise comparisons}
\usage{
set_prompt_template(template = NULL, file = NULL)
}
\arguments{
\item{template}{Optional character string containing a custom template.
If \code{NULL}, a default template is returned.}

\item{file}{Optional path to a text file containing a template.
Ignored if \code{template} is not \code{NULL}.}
}
\value{
A character string containing the prompt template.
}
\description{
This function returns a default prompt template that includes
placeholders for the trait name, trait description, and two
writing samples. Any custom template must contain the
placeholders \code{{TRAIT_NAME}}, \code{{TRAIT_DESCRIPTION}},
\code{{SAMPLE_1}}, and \code{{SAMPLE_2}}.
}
\details{
The default template is stored as a plain-text file in
\code{inst/templates/default.txt} and loaded at run time. This
makes it easy to inspect and modify the prompt text without
changing the R code.
}
\examples{
# Get the default template shipped with the package
tmpl <- set_prompt_template()
cat(substr(tmpl, 1, 200), "...\n")

# Use a custom template defined in-line
custom <- "
You are an expert writing assessor for {TRAIT_NAME}.

{TRAIT_NAME} is defined as {TRAIT_DESCRIPTION}.

Which of the samples below is better on {TRAIT_NAME}?

SAMPLE 1:
{SAMPLE_1}

SAMPLE 2:
{SAMPLE_2}

<BETTER_SAMPLE>SAMPLE_1</BETTER_SAMPLE> or
<BETTER_SAMPLE>SAMPLE_2</BETTER_SAMPLE>
"

tmpl2 <- set_prompt_template(template = custom)
cat(substr(tmpl2, 1, 120), "...\n")

}
