% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_linear_LiblineaR.R
\name{details_svm_linear_LiblineaR}
\alias{details_svm_linear_LiblineaR}
\title{Linear support vector machines (SVMs) via LiblineaR}
\description{
\code{\link[LiblineaR:LiblineaR]{LiblineaR::LiblineaR()}} fits a support vector machine model. For classification,
the model tries to maximize the width of the margin between classes.
For regression, the model optimizes a robust loss function that is only
affected by very large model residuals.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{cost}: Cost (type: double, default: 1.0)
\item \code{margin}: Insensitivity Margin (type: double, default: no default)
}

This engine fits models that are L2-regularized for L2-loss. In the
\code{\link[LiblineaR:LiblineaR]{LiblineaR::LiblineaR()}} documentation, these
are types 1 (classification) and 11 (regression).

Parsnip changes the default range for \code{cost} to \code{c(-10, 5)}.
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{svm_linear(
  cost = double(1),
  margin = double(1)
) |>  
  set_engine("LiblineaR") |> 
  set_mode("regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Support Vector Machine Model Specification (regression)
## 
## Main Arguments:
##   cost = double(1)
##   margin = double(1)
## 
## Computational engine: LiblineaR 
## 
## Model fit template:
## LiblineaR::LiblineaR(x = missing_arg(), y = missing_arg(), C = double(1), 
##     svr_eps = double(1), type = 11)
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{svm_linear(
  cost = double(1)
) |> 
  set_engine("LiblineaR") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Support Vector Machine Model Specification (classification)
## 
## Main Arguments:
##   cost = double(1)
## 
## Computational engine: LiblineaR 
## 
## Model fit template:
## LiblineaR::LiblineaR(x = missing_arg(), y = missing_arg(), C = double(1), 
##     type = 1)
}\if{html}{\out{</div>}}

The \code{margin} parameter does not apply to classification models.

Note that the \code{LiblineaR} engine does not produce class probabilities.
When optimizing the model using the tune package, the default metrics
require class probabilities. To use the \verb{tune_*()} functions, a metric
set must be passed as an argument that only contains metrics for hard
class predictions (e.g., accuracy).
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("svm_linear_predict") |>
  dplyr::filter(engine == "LiblineaR") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 4 x 2
##   mode           type   
##   <chr>          <chr>  
## 1 regression     numeric
## 2 regression     raw    
## 3 classification class  
## 4 classification raw
}\if{html}{\out{</div>}}
}

\subsection{Sparse Data}{

This model can utilize sparse data during model fitting and prediction.
Both sparse matrices such as dgCMatrix from the \code{Matrix} package and
sparse tibbles from the \code{sparsevctrs} package are supported. See
\link{sparse_data} for more information.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#svm-linear-LiblineaR}{examples}
for \code{svm_linear()} with the \code{"LiblineaR"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
