% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{pathling_read_delta}
\alias{pathling_read_delta}
\title{Create a data source from Delta tables}
\usage{
pathling_read_delta(pc, path)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{path}{The URI of the directory containing the Delta tables.}
}
\value{
A DataSource object that can be used to run queries against the data.
}
\description{
\code{pathling_read_delta()} creates a data source from a directory containing Delta tables.
Each table must be named according to the name of the resource type that it stores.
}
\examples{
\dontrun{
data_source <- pc \%>\% pathling_read_delta(pathling_examples("delta"))
data_source \%>\%
  ds_read("Patient") \%>\%
  sparklyr::sdf_nrow()
}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#delta-lake}{Pathling documentation - Reading Delta}

Other data source functions: 
\code{\link{pathling_read_bulk}()},
\code{\link{pathling_read_bundles}()},
\code{\link{pathling_read_datasets}()},
\code{\link{pathling_read_ndjson}()},
\code{\link{pathling_read_parquet}()},
\code{\link{pathling_read_tables}()}
}
\concept{data source functions}
