% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mscale_derivative}
\alias{mscale_derivative}
\title{Compute the Gradient and Hessian of the M-Scale Function}
\usage{
mscale_derivative(
  x,
  bdp = 0.25,
  order = 1,
  cc,
  opts = mscale_algorithm_options()
)
}
\arguments{
\item{x}{numeric values. Missing values are verbosely ignored.}

\item{bdp}{desired breakdown point (between 0 and 0.5).}

\item{order}{compute the gradient (\code{order=1}) or the gradient and the
Hessian (\code{order=2}).}

\item{cc}{cutoff value for the bisquare rho function.
By default, chosen to yield a consistent estimate for the
Normal distribution.}

\item{opts}{a list of options for the M-scale estimation algorithm,
see \code{\link[=mscale_algorithm_options]{mscale_algorithm_options()}} for details.}
}
\value{
a vector of derivatives of the M-scale function, one per element in \code{x}.
}
\description{
Compute the derivative (gradient) or the Hessian of the M-scale function
evaluated at the point \code{x}.
}
\keyword{internal}
