% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_somers.R
\name{r2_somers}
\alias{r2_somers}
\title{Somers' Dxy rank correlation for binary outcomes}
\usage{
r2_somers(model)
}
\arguments{
\item{model}{A logistic regression model.}
}
\value{
A named vector with the R2 value.
}
\description{
Calculates the Somers' Dxy rank correlation for logistic regression models.
}
\examples{
\donttest{
if (require("correlation") && require("Hmisc")) {
  model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
  r2_somers(model)
}
}

}
\references{
Somers, R. H. (1962). A new asymmetric measure of association for
ordinal variables. American Sociological Review. 27 (6).
}
