% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Minimise_elements_comb.R
\name{Minimise_elements_comb}
\alias{Minimise_elements_comb}
\title{Part of the steepest descent algorithm}
\usage{
Minimise_elements_comb(Fmat, place, S, cm, c1_num = c(1, 2, 3))
}
\arguments{
\item{Fmat}{The F matrix}

\item{place}{A vector of indices indicating which elements to adjust}

\item{S}{A matrix of samples (rows) and pigments (columns)}

\item{cm}{A vector of bounded weights for each pigment}

\item{c1_num}{A numeric vector (1, 2, or 3) indicating which scaler values to use}
}
\value{
A list containing the F matrix with updated ratios, the RMSE of new estimates,
and an updated C matrix of estimated group contribution.
}
\description{
Part of the steepest descent algorithm
}
\examples{
 Fmat <- as.matrix(phytoclass::Fm)
 S <- as.matrix(phytoclass::Sm)
 S_weights <- as.numeric(phytoclass:::Bounded_weights(S))
 place <- which(Fmat[, seq(ncol(Fmat) - 2)] > 0)

 # Get F_initial from NNLS_MF as done in Steepest_Descent
 F_initial <- phytoclass::NNLS_MF(Fmat, S, S_weights)

 # Run Minimise_elements_comb with c1_num = 3 (as in Steepest_Descent)
 result <- phytoclass:::Minimise_elements_comb(
   F_initial[[1]], place, S, S_weights, c1_num = 3
 )
}
\keyword{internal}
