% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_aux.R
\name{display_aux}
\alias{display_aux}
\title{Display available auxiliary tables}
\usage{
display_aux(
  version = NULL,
  ppp_version = NULL,
  release_version = NULL,
  api_version = "v1",
  format = c("rds", "json", "csv"),
  simplify = TRUE,
  server = NULL,
  assign_tb = TRUE
)
}
\arguments{
\item{version}{character: Data version. See \code{get_versions()}}

\item{ppp_version}{ppp year to be used}

\item{release_version}{date when the data was published in YYYYMMDD format}

\item{api_version}{character: API version}

\item{format}{character: Response format either of c("rds", "json", "csv")}

\item{simplify}{logical: If TRUE (the default) the response is returned as a
\code{tibble}}

\item{server}{character: Server. For WB internal use only}

\item{assign_tb}{logical: Whether to assign table to .pip env. Default is
TRUE}
}
\value{
invisible tibble with names of auxiliary tables
}
\description{
Display available auxiliary tables
}
\examples{
\dontrun{
display_aux()
}
}
