% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pix_url}
\alias{pix_url}
\title{Build PIX API URL (for debugging)}
\usage{
pix_url(
  endpoint,
  params = NULL,
  filter = NULL,
  select = NULL,
  orderby = NULL,
  top = NULL,
  skip = NULL,
  format = "json"
)
}
\arguments{
\item{endpoint}{Character string specifying the endpoint name.}

\item{params}{Named list of endpoint parameters. Each endpoint requires
different parameters:
\itemize{
\item ChavesPix: \code{list(Data = "YYYY-MM-DD")}
\item TransacoesPixPorMunicipio: \code{list(DataBase = "YYYYMM")}
\item EstatisticasTransacoesPix: \code{list(Database = "YYYYMM")}
\item EstatisticasFraudesPix: \code{list(Database = "YYYYMM")}
}}

\item{filter}{OData filter expression as a character string.}

\item{select}{Character vector of columns to select.}

\item{orderby}{OData orderby expression (e.g., "Column asc" or "Column desc").}

\item{top}{Integer; maximum number of records to return.}

\item{skip}{Integer; number of records to skip.}

\item{format}{Response format: "json" (default), "xml", "csv", or "html".}
}
\value{
Character string with the full API URL.
}
\description{
Builds and returns the URL that would be called by a PIX API function.
Useful for debugging and testing.
}
\examples{
# See what URL would be called for each endpoint
pix_url("ChavesPix", params = list(Data = "2025-12-01"), top = 10)
pix_url("EstatisticasTransacoesPix", params = list(Database = "202509"), top = 10)
pix_url("TransacoesPixPorMunicipio", params = list(DataBase = "202512"), top = 10)
}
