% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{rangeslider}
\alias{rangeslider}
\title{Add a range slider to the x-axis}
\usage{
rangeslider(p, start = NULL, end = NULL, ...)
}
\arguments{
\item{p}{plotly object.}

\item{start}{a start date/value.}

\item{end}{an end date/value.}

\item{...}{these arguments are documented here
\url{https://plotly.com/r/reference/#layout-xaxis-rangeslider}}
}
\description{
Add a range slider to the x-axis
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) withAutoprint(\{ # examplesIf}

plot_ly(x = time(USAccDeaths), y = USAccDeaths) \%>\% 
  add_lines() \%>\%
  rangeslider()
  
d <- tibble::tibble(
  time = seq(as.Date("2016-01-01"), as.Date("2016-08-31"), by = "days"),
  y = rnorm(seq_along(time))
 )
 
plot_ly(d, x = ~time, y = ~y) \%>\%
  add_lines() \%>\%
  rangeslider(d$time[5], d$time[50])
  
\dontshow{\}) # examplesIf}
}
\author{
Carson Sievert
}
