## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(poputils)
library(dplyr, warn.conflicts = FALSE)
tibble(original = c("5 to 9", "5_9", "05-09"),
       reformated = reformat_age(original))

## -----------------------------------------------------------------------------
df <- data.frame(age = c("5-9", "0-4", "15-19", "10-14"),
                 population = c(3, 7, 2, 4))
df
df |>
  arrange(age_lower(age))

## -----------------------------------------------------------------------------
library(ggplot2)
ggplot(df, aes(x = age_mid(age), y = population)) +
  geom_point()

## -----------------------------------------------------------------------------
tibble(age = age_labels("lt", max = 30),
       age_5 = combine_age(age, to = "five"),
       age_25plus = set_age_open(age, lower = 20))

## -----------------------------------------------------------------------------
reformat_sex(c("M", "F", "Diverse", "Fem"), except = "Diverse")

## -----------------------------------------------------------------------------
nzl_mort |>
  filter(year == 2022,
         gender == "Female") |>
  lifetab(mx = mx)  

## -----------------------------------------------------------------------------
nzl_mort |>
  lifeexp(mx = mx,
          by = c(gender, year))  

## -----------------------------------------------------------------------------
nzl_mort |>
  group_by(gender, year) |>
  lifeexp(mx = mx)

## -----------------------------------------------------------------------------
west_lifetab |>
  group_by(level, sex) |>
  lifeexp(qx = qx)

## -----------------------------------------------------------------------------
nzl_mort |>
  lifeexp(mx = mx,
          at = c(0, 65),
          by = c(gender, year))  

## -----------------------------------------------------------------------------
lin <- nzl_mort |>
  lifeexp(mx = mx,
          by = c(gender, year),
          infant = "linear",
          suffix = "lin")
ak <- nzl_mort |>
  lifeexp(mx = mx,
          sex = gender,
          by = year,
          infant = "AK", 
          suffix = "ak")
inner_join(lin, ak, by = c("year", "gender")) |>
  mutate(diff = ex.lin - ex.ak)

## -----------------------------------------------------------------------------
target_ex <- data.frame(sex = "Female", ex = 51.4)

west10 <- west_lifetab |>
  filter(level == 10) |>
  select(age, sex, lx)

ex_to_lifetab_brass(target = target_ex,
                    standard = west10)

## -----------------------------------------------------------------------------
irn_fert |>
  tfr(asfr = rate,
      by = c(area, time),
      denominator = 1000)      

## -----------------------------------------------------------------------------
library(rvec)
nzl_mort_rvec

## -----------------------------------------------------------------------------
library(rvec)
nzl_mort_rvec |>
  filter(year == 2022,
         gender == "Female") |>
  lifetab(mx = mx) |>
  select(age, qx, lx)

