% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.r
\name{sample_posterior_univariate}
\alias{sample_posterior_univariate}
\title{Sample from Posterior Distribution (Univariate)}
\usage{
sample_posterior_univariate(posterior, n_samples = 1000, marginal = FALSE)
}
\arguments{
\item{posterior}{Object of class "posterior_univariate" from posterior_univariate()}

\item{n_samples}{Number of samples to generate (default: 1000)}

\item{marginal}{Logical. If TRUE, samples only mu from t-distribution.
If FALSE, samples joint (mu, sigma2) from NIX distribution (default: FALSE)}
}
\value{
If marginal=FALSE, a matrix with columns "mu" and "sigma2".
If marginal=TRUE, a vector of mu samples.
}
\description{
Generates samples from the posterior distribution using the conjugate
representation. Can sample the joint distribution (mu, sigma2) or just
the marginal distribution of mu.
}
\examples{
# Generate data and compute posterior
historical <- rnorm(50, mean = 10, sd = 2)
current <- rnorm(30, mean = 10.5, sd = 2)
pp <- powerprior_univariate(historical, a0 = 0.5)
posterior <- posterior_univariate(pp, current)

# Sample from joint distribution
samples_joint <- sample_posterior_univariate(posterior, n_samples = 1000)

# Sample from marginal distribution of mu
samples_marginal <- sample_posterior_univariate(posterior, n_samples = 1000,
                                                 marginal = TRUE)

}
