dpweibull <-
function(x, rate = 1, alpha = 1, t = 0, log = FALSE) 
{
    if (length(t) != length(rate)) 
        stop("length of t must be equal to length of rate")
    if (length(t) != length(alpha)) 
        stop("length of t must be equal to length of alpha")
    if (!isTRUE(all.equal(0, t[1]))) 
        stop("first element of t should be 0")
    if (any(alpha<0)) 
        stop("alpha's should be positive values")
    if (is.unsorted(t)) 
        stop("t should be in increasing order")
    ind <- rowSums(outer(x, t, ">="))
    ret <- dexp(x^alpha[ind] - t[ind]^alpha[ind], rate[ind], log=log)
    mi <- min(length(t), max(ind))
    if (length(t) > 1) {
        dt <- t[-1]^alpha[-mi] - t[-mi]^alpha[-mi]
        if (log) {
            cs <- c(0, cumsum(pexp(dt, rate[-length(rate)], log.p = TRUE, 
                lower.tail = FALSE)))
            ret <- cs[ind] + ret+log(alpha[ind])+(alpha[ind]-1)*log(x)
        }
        else {
            cp <- c(1, cumprod(pexp(dt, rate[-length(rate)], 
                lower.tail = FALSE)))
            ret <- cp[ind] * ret * alpha[ind] * x^(alpha[ind]-1)
        }
    }
    ret
}
