% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meds.R
\name{medications-option}
\alias{medications-option}
\alias{set_medications}
\alias{get_medications}
\title{Set or get the \code{pregnancy.medications} option}
\usage{
set_medications(meds)

get_medications()
}
\arguments{
\item{meds}{Data frame containing medication schedule. Must have the following columns:
\itemize{
\item medication (character/factor): Name of the medication
\item format (character/factor): Format of the medication (e.g., pill, injection)
\item quantity (numeric): Number of units to take per day
\item start_date (Date or character string representing a date, e.g. "YYYY-MM-DD"): Date to start taking the medication
\item stop_date (Date or character string representing a date, e.g. "YYYY-MM-DD"): Final date on which the medication is taken
}

If NULL, will try to use the "pregnancy.medications" option. Required if option not set.}
}
\value{
Both functions invisibly return the current medications setting:
\itemize{
\item \code{\link[=get_medications]{get_medications()}} returns the current setting (a data frame) or NULL if not set
\item \code{\link[=set_medications]{set_medications()}} returns the medications data frame that was set
}
}
\description{
Functions to get and set the default medications data frame used in the \code{\link[=medications_remaining]{medications_remaining()}} function.
Settings persist for the current R session only, unless added to
.Rprofile. \code{set_medications()} sets the "pregnancy.medications" option and \code{get_medications()} retrieves it.
}
\examples{
# Store original setting (without messages)
original_medications <- getOption("pregnancy.medications")

# Set the option
set_medications(pregnancy::medications)

# Get the option
get_medications()

# Restore original setting (without messages)
options(pregnancy.medications = original_medications)

}
\seealso{
\itemize{
\item \code{\link[=medications_remaining]{medications_remaining()}}, \link{medications}
}
}
