% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_ps_match.R
\name{summary.PSRWE_DTA_MAT}
\alias{summary.PSRWE_DTA_MAT}
\title{Summarize PS estimation and matching results}
\usage{
\method{summary}{PSRWE_DTA_MAT}(object, ...)
}
\arguments{
\item{object}{A list of class \code{PSRWE_DTA_MAT} that is generated using
the \code{\link{psrwe_match}} function.}

\item{...}{Additional parameters.}
}
\value{
A list with columns:

\describe{

    \item{Summary}{A data frame with Stratum (defined by covariates), number
    of subjects in RWD, current study, number of subjects in control and
    treatment arms for RCT studies.}

    \item{Overall}{A data frame with the overall number of not-trimmed
    subjects
    in RWD, number of patients in the current study, number of subjects in
    control and treatment arms for RCT studies.}

    \item{N}{Vector of total number of total RWD patients, number of trimmed
    RWD patients, total number of current study patients, number of current
    control patients with less than \code{ratio} matched RWD subjects.}

    \item{ps_fml}{PS model.}

    \item{N_Match}{Number of current control subjects matched with
    \code{ratio}, 0 and other number of RWD subjects.}

    \item{ratio}{Matching ratio.}
}
}
\description{
Get number of subjects for each PS stratum.
}
