% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zstd_file_functions.R
\name{zstd_in}
\alias{zstd_in}
\alias{zstd_out}
\title{Zstd file substitution for input}
\usage{
zstd_in(FUN, ..., envir = parent.frame(), tmpfile = tempfile())

zstd_out(FUN, ..., envir = parent.frame(), tmpfile = tempfile())
}
\arguments{
\item{FUN}{Function to call.}

\item{...}{Arguments passed to \code{FUN}. The first named argument is treated as
the file path.}

\item{envir}{Environment for \code{FUN} evaluation.}

\item{tmpfile}{Temporary file path. If not supplied, a temp file is created
and removed on exit.}
}
\value{
The value returned by \code{FUN}.

The value returned by \code{FUN}, with its visibility preserved.
}
\description{
Substitutes a zstd compressed file for a regular input file. The zstd compressed
file is decompressed to the input \code{FUN}.

Substitutes a zstd compressed file for a regular output file. The output of \code{FUN} is
converted to a zstd compressed file at the target zstd file path.
}
\details{
This is a generic wrapper that works with any function that reads from a
file.

This is a generic wrapper that works with any function that writes to a file.
}
\examples{
if (requireNamespace("data.table", quietly = TRUE)) {
  zfile <- tempfile(fileext = ".csv.zst")
  zstd_out(data.table::fwrite, mtcars, file = zfile)
  dt <- zstd_in(data.table::fread, file = zfile)
  print(nrow(dt))
}
}
