// auto-generated by convert_xgboost_json.R
// Rscript convert_xgboost_json.R data/blockshuffle_xgboost_model.json ../../../src/io/xgboost_blockshuffle_model.h FALSE
#ifndef _QS2_XGBOOST_BLOCKSHUFFLE_MODEL_H
#define _QS2_XGBOOST_BLOCKSHUFFLE_MODEL_H
#include <array>
#include <memory>
#include <vector>
#include "io_common.h"


namespace XgboostBlockshuffleModel {

struct XgTree {
  struct XgNode {
    XgNode * left_child;
    XgNode * right_child;
    uint8_t split_idx;
    double split_cond;
  };
  static constexpr uint8_t NULL_FEATURE_IDX = 255;
  static constexpr uint16_t NULL_NODE_INDEX = 65535;
  std::unique_ptr<XgNode[]> nodes;
  // constructor takes initializer lists
  XgTree(const std::vector<double> & split_conditions,
         const std::vector<uint8_t> & split_indices,
         const std::vector<uint16_t> & left_children,
         const std::vector<uint16_t> & right_children) :
  nodes(MAKE_UNIQUE_BLOCK_CUSTOM(XgNode, split_conditions.size())) {
    for(size_t i = 0; i < split_conditions.size(); ++i) {
      nodes[i].split_idx = split_indices[i];
      nodes[i].split_cond = split_conditions[i];
      nodes[i].left_child = left_children[i] == NULL_NODE_INDEX ? nullptr : &nodes[left_children[i]];
      nodes[i].right_child = right_children[i] == NULL_NODE_INDEX ? nullptr : &nodes[right_children[i]];
    }
  }
  template <typename T> double predict(const T & features) const {
    static_assert(std::is_same<typename T::value_type, double>::value, "T::value_type must be double");
    XgNode * current_node = &nodes[0];
    while(true) {
      if(current_node->split_idx == NULL_FEATURE_IDX) {
        return current_node->split_cond;
      }
      if(features[current_node->split_idx] < current_node->split_cond) {
        current_node = current_node->left_child;
      } else {
        current_node = current_node->right_child;
      }
    }
  }
};

static constexpr float base_score = 5E-1;
static const std::array<XgTree, 193> XgForest = {
XgTree({31847.5,3189.5,9989,4554.5,9657,0.11320422,32161.5,106.5,6972,7066,7690,17302,27092,37,243.5,1797.5,6920,5816,4329.5,9595.5,10574,-0.054460604,-0.10569885,21629,30108.5,24233,31.5,103,4070.5,-0.19617637,6828.5,-0.13213454,5809.5,4869,4360.5,16325,8868.5,6480.5,4991.5,11217.5,21787,-0.023132186,-0.031615708,32313,-0.035938755,22,-0.08656581,90,100,62.5,37,2655,7192.5,-0.12139956,-0.15215935,-0.21063662,-0.15360972,7394.5,4786,8662,7482,0.110386066,-0.035083555,7018,14993.5,7095,9779,4938,6744.5,9079,-0.1058923,30440.5,27461,-0.046568297,29902,27,23.5,31.5,327.5,28.5,162,-0.17232831,81,-0.051200617,187.5,427,1292,3720,7417.5,3775,11104,4652.5,7209,5968,4127.5,3736,6245.5,7604.5,5628.5,8046,22462,14071.5,9219.5,8126,7409,10616.5,18685,9104.5,24455,8058,10938.5,9706,15995,17640,24921.5,29384.5,-0.036773767,-0.04566189,-0.027610928,0.022248747,-0.020710232,-0.027891165,-0.08057456,-0.1763932,-0.08137305,-0.03042697,-0.0224414,-0.06987247,-0.032587733,-0.071622945,-0.02946937,-0.20916592,-0.17527424,-0.123311035,-0.06739839,-0.17234717,-0.10887106,-0.03276875,-0.10163361,-0.06004718,-0.08338884,-0.020190423,-0.03783738,-0.11109523,-0.061429776,-0.051707406,-0.021073302,-0.079458505,-0.04256629,-0.09191802,-0.11875289,-0.1978901,-0.14598167,-0.01638533,-0.08475839,-0.11681979,-0.081107125,-0.021697894,-0.0962512,-0.0377144,-0.074209295,-0.017006557,-0.03538468,-0.10886251,-0.084829964,-0.091026604,-0.11049705,-0.124900796,-0.15412863,-0.066386946,-0.04576718,-0.099520996,-0.07818281,-0.14390782,-0.19827315,-0.1462453,-0.09905982,-0.10629272,-0.15084098,-0.13623063,-0.09170922,-0.052249044,-0.08249143,-0.038801502,-0.027004713,-0.11630682,-0.0978906,-0.15792,-0.10779705,-0.061232418,-0.113684155,-0.08737532,-0.07245259,-0.036603183,-0.03845313}, {5,5,0,4,6,255,3,4,4,5,3,3,6,6,5,3,2,4,4,2,4,255,255,4,2,0,5,0,3,255,4,255,3,6,5,0,5,3,3,0,5,255,255,5,255,2,255,2,6,5,2,2,0,255,255,255,255,2,0,4,4,255,255,4,4,2,6,5,5,3,255,2,4,255,4,0,3,4,0,0,6,255,0,255,5,5,5,4,2,4,0,5,3,4,5,2,5,2,6,4,3,6,2,0,5,6,0,4,0,5,5,5,3,3,5,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,65535,41,43,45,47,49,51,65535,53,65535,55,57,59,61,63,65,67,69,71,65535,65535,73,65535,75,65535,77,79,81,83,85,87,65535,65535,65535,65535,89,91,93,95,65535,65535,97,99,101,103,105,107,109,65535,111,113,65535,115,117,119,121,123,125,127,65535,129,65535,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,65535,42,44,46,48,50,52,65535,54,65535,56,58,60,62,64,66,68,70,72,65535,65535,74,65535,76,65535,78,80,82,84,86,88,65535,65535,65535,65535,90,92,94,96,65535,65535,98,100,102,104,106,108,110,65535,112,114,65535,116,118,120,122,124,126,128,65535,130,65535,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31847.5,3201.5,9989,6828.5,9657,0.10056212,21629,106.5,3583.5,7066,7590,-0.017515065,32161.5,51.5,243.5,5809.5,8980.5,5816,4329.5,4926.5,10601,17302,27092,24233,51.5,103,3660.5,-0.18974762,-0.13589472,-0.12231761,-0.17761466,4975.5,7482,21989,8467,10654,8250.5,11800,21787,-0.05048969,-0.09571626,-0.028538704,30000.5,27,-0.08112497,62,80.5,62.5,2138.5,2249.5,1888.5,3775,3970,4063,5040.5,0.020711906,0.09693093,5663.5,10771,-0.12429036,4926,-0.0890784,6564.5,9964,9160.5,29089.5,27461,29902,29879.5,37,57.5,33,96,110.5,76,-0.15767995,81,187.5,103,583,4975,1775.5,4017.5,3233.5,4954.5,543,4679,-0.10656875,3515.5,8668.5,9631.5,9393.5,7315,7894.5,-0.09387382,30719.5,-0.11388552,4662,9606,10511.5,9316.5,11480.5,10808,8910,12998,17640,24921.5,29100.5,29919.5,-0.033556357,-0.03185497,-0.030454377,-0.16091979,-0.016095761,-0.025085673,-0.16135733,-0.114182524,-0.067443945,-0.12320476,-0.022948185,-0.035000756,-0.022418497,-0.011430213,-0.067095965,-0.030519063,-0.18896781,-0.16398947,-0.039007004,-0.1180018,-0.030425498,-0.09014412,-0.028678894,-0.086415164,-0.17792086,-0.12656167,-0.11231428,-0.1029407,-0.0116868755,-0.021833746,-0.06751599,-0.026959268,-0.07655408,-0.018408358,-0.08337292,-0.057821523,0.00025571714,-0.076307625,-0.11014469,-0.13846307,-0.06999977,-0.112004474,-0.030469833,-0.05921596,-0.06891223,-0.044276964,-0.015417834,-0.02711683,-0.17715782,-0.11729246,-0.1046043,-0.13595779,-0.040552076,-0.12243598,-0.07067168,-0.03804755,-0.085925795,-0.1027089,-0.04466663,-0.08859554,-0.024235675,-0.031282254,-0.11090529,-0.08794524,-0.14279805,-0.097060874,-0.055049498,-0.103202164,-0.07847061,-0.0652324,-0.032979086,-0.03472675,-0.031527165,-0.033851977}, {5,5,0,4,6,255,4,4,7,5,7,255,3,4,5,3,6,4,4,7,4,3,6,0,5,0,4,255,255,255,255,6,4,3,7,6,4,7,5,255,255,255,0,5,255,4,0,5,0,7,3,4,0,5,7,255,255,6,0,255,5,255,5,0,3,4,4,4,6,4,6,7,0,6,4,255,0,5,3,4,0,5,3,0,5,0,7,255,6,6,0,3,7,6,255,0,255,3,4,3,4,6,6,7,5,3,5,4,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,65535,65535,65535,51,53,55,57,59,61,63,65,65535,65535,65535,67,69,65535,71,73,75,77,79,81,83,85,87,89,65535,65535,91,93,65535,95,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,65535,123,125,127,129,131,133,135,137,139,141,143,65535,145,147,149,151,153,155,65535,157,65535,159,161,163,165,167,169,171,173,175,177,179,181,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,65535,65535,65535,52,54,56,58,60,62,64,66,65535,65535,65535,68,70,65535,72,74,76,78,80,82,84,86,88,90,65535,65535,92,94,65535,96,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,65535,124,126,128,130,132,134,136,138,140,142,144,65535,146,148,150,152,154,156,65535,158,65535,160,162,164,166,168,170,172,174,176,178,180,182,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({32387,3568.5,10049.5,4752.5,9791.5,12.5,24456,50.5,7039.5,7690.5,7195,0.069085106,0.11554938,17.5,32501.5,37,432.5,1797.5,3241.5,6025.5,4731.5,9460.5,10835.5,21629,20364.5,-0.0743458,27092,30,41.5,94.5,1230.5,6.5,14.5,6244,8362,4935,7399,12.5,7770,4532.5,4894,10579.5,22437.5,20364.5,-0.020985331,-0.022040969,-0.04004402,17.5,30108.5,27,27,-0.13820888,27.5,49.5,384,722.5,1464.5,-0.13917993,-0.17189221,-0.10604222,2263.5,-0.1176507,13555,-0.10280905,6.5,2155,4902.5,9643.5,7661,0.065054685,0.11201995,7853.5,10639.5,3700,5980.5,11340.5,21833.5,10565,-0.08525844,30932.5,27249.5,-0.015716637,14.5,24671,24792.5,29902,29817,22,22,37,33.5,14.5,4.5,29.5,49,71,670,906.5,18.5,6809.5,2028.5,-0.11583221,-0.08801288,5.5,11.5,-0.13063507,12727.5,17.5,4180.5,6193,5804,5271,9058,7503,9093.5,7892.5,9152,5615,11096,-0.1430006,-0.10416559,-0.081341974,-0.06944004,-0.12070538,12.5,6729.5,19349,8844.5,4000,10196.5,15995,1.5,24809,-0.010850466,-0.0131307915,-0.021760767,-0.024741957,-0.033861917,-0.027485227,29100.5,29919.5,-0.030163964,-0.028583977,-0.03765708,-0.026822677,0.0037327018,-0.019484442,0.009625393,-0.020744078,-0.015598761,-0.054352295,-0.059899885,-0.03901363,-0.0036084715,-0.021390272,-0.038868796,-0.019979956,-0.067885846,-0.02368193,-0.081567466,-0.15918551,-0.03147072,-0.09236762,-0.030197611,-0.115269564,-0.023678107,0.019405833,-0.10990349,-0.027879992,-0.013230832,-0.06066633,-0.17658143,-0.16838537,-0.16666894,-0.19193046,-0.1675752,-0.108639896,-0.01589953,0.03676762,-0.0227143,-0.038664956,-0.07047501,-0.09032825,-0.035667434,-0.064396836,-0.09885161,-0.07223662,-0.0937864,-0.122114696,-0.08170598,-0.013972995,-0.075038634,-0.060868174,-0.012364918,-0.04298737,-0.079287276,-0.02046289,-0.028944978,-0.058699857,-0.021434998,-0.033539552,-0.14711018,-0.18203805,-0.122142315,-0.10653684,-0.043855455,-0.07664962,-0.058146086,-0.02322096,-0.07202202,-0.023755848,-0.09554287,-0.07841899,-0.12779275,-0.087461255,-0.039018277,-0.09298124,-0.0707683,-0.058205795,-0.029666264,-0.031215621,-0.028247615,-0.030403618}, {3,3,2,2,4,8,2,6,2,3,1,255,255,8,1,6,3,3,3,2,2,2,2,4,4,255,6,2,6,2,2,8,8,4,2,2,1,8,2,3,3,6,3,4,255,255,255,8,2,4,1,255,3,2,1,3,3,255,255,255,3,255,2,255,8,6,3,2,1,255,255,4,3,3,3,2,2,1,255,2,2,255,8,6,4,4,6,6,1,2,6,8,8,1,3,1,6,2,8,4,2,255,255,8,8,255,1,8,2,4,6,3,4,6,1,6,4,4,2,255,255,255,255,255,8,1,6,3,6,3,3,8,3,255,255,255,255,255,255,4,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,65535,65535,65535,83,85,87,89,65535,91,93,95,97,99,65535,65535,65535,101,65535,103,65535,105,107,109,111,113,65535,65535,115,117,119,121,123,125,127,65535,129,131,65535,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,65535,65535,171,173,65535,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,65535,65535,65535,65535,201,203,205,207,209,211,213,215,217,65535,65535,65535,65535,65535,65535,219,221,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,65535,65535,65535,84,86,88,90,65535,92,94,96,98,100,65535,65535,65535,102,65535,104,65535,106,108,110,112,114,65535,65535,116,118,120,122,124,126,128,65535,130,132,65535,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,65535,65535,172,174,65535,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,65535,65535,65535,65535,202,204,206,208,210,212,214,216,218,65535,65535,65535,65535,65535,65535,220,222,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31841.5,3189.5,9989,3728,9657,0.08010527,32413,57,6972,7223.5,7678.5,25808.5,25623,22,409.5,1607,3836.5,5949,4329.5,7585,10601,-0.07636573,-0.0476975,20364.5,32341,27,34.5,102.5,990,-0.14452422,6828.5,2174.5,11808,4975.5,4506,3310,7078.5,10569,6392,10025,21746,-0.015712608,24659.5,-0.04481437,26503.5,28.5,-0.020818222,30,32,54,338.5,8510.5,4781.5,4627.5,7809,-0.15827563,7767,-0.10350654,-0.14044613,3775,4902.5,8828,9706,0.07969355,0.040666655,5916,12068,6705.5,6494.5,12783,9656,11445.5,10867.5,30043.5,27461,-0.021086568,-0.023248816,-0.023251098,29719.5,-0.035486493,-0.02504897,28,32.5,31.5,41,27.5,98,105,543,1616,-0.073714554,1710.5,4975,-0.10162186,-0.088620104,-0.102668755,-0.14669716,1974.5,2347.5,3233.5,4449,540.5,4735,6265,4651.5,9536.5,9659.5,7715,9158.5,8861,7120.5,-0.07387207,6117,-0.02280989,-0.04838731,3984.5,5755,8824.5,23337.5,9255.5,-0.016767645,11217.5,-0.07373185,10294,12998,17777,31225,29660.5,29731,-0.024716571,-0.010603828,0.021269294,0.0043211877,-0.02014037,-0.08690887,-0.026086947,-0.0133256335,-0.053296324,-0.12918489,-0.02207191,-0.05154844,-0.064958766,-0.15019773,-0.02350942,-0.16178909,-0.027274657,-0.0056176777,-0.08467219,-0.04339273,-0.024262607,-0.06658853,-0.15464465,-0.12566438,-0.15048061,-0.15710081,-0.0058127115,-0.017130494,-0.059823353,-0.020998927,-0.06573721,-0.019823255,-0.07122771,-0.049367692,-0.08247521,-0.027507681,-0.13373886,-0.086054206,-0.06522558,-0.035795067,-0.081199884,-0.109098814,-0.017752454,-0.054124475,-0.07730461,-0.058595847,-0.033262342,-0.021589637,-0.08323471,-0.062260795,-0.02987961,-0.06431126,-0.13851933,-0.109017245,-0.1480782,-0.07989381,-0.077506274,-0.02728968,-0.101028375,-0.066968374,-0.05448525,-0.07853984,-0.020234784,-0.078570515,-0.08130653,-0.070509896,-0.11591357,-0.07873988,-0.054640085,-0.08342638,-0.05177648,-0.06339913,-0.02736932,-0.03018975,-0.025654495,-0.026920635}, {5,5,0,4,6,255,1,0,4,5,5,0,0,6,1,1,1,4,4,4,4,255,255,4,5,2,6,4,6,255,4,1,2,6,1,2,1,2,1,5,5,255,4,255,6,0,255,4,5,1,5,2,6,2,0,255,6,255,255,4,0,0,4,255,255,0,2,2,0,0,0,1,6,4,4,255,255,255,0,255,255,6,0,4,0,1,6,0,0,1,255,5,0,255,255,255,255,5,1,0,5,0,1,5,5,6,2,4,5,5,6,255,4,255,255,5,5,0,6,1,255,0,255,1,5,1,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,65535,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,73,65535,75,65535,77,79,65535,81,83,85,87,89,91,93,95,65535,97,65535,65535,99,101,103,105,65535,65535,107,109,111,113,115,117,119,121,123,125,65535,65535,65535,127,65535,65535,129,131,133,135,137,139,141,143,145,65535,147,149,65535,65535,65535,65535,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,65535,65535,181,183,185,187,189,65535,191,65535,193,195,197,199,201,203,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,65535,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,74,65535,76,65535,78,80,65535,82,84,86,88,90,92,94,96,65535,98,65535,65535,100,102,104,106,65535,65535,108,110,112,114,116,118,120,122,124,126,65535,65535,65535,128,65535,65535,130,132,134,136,138,140,142,144,146,65535,148,150,65535,65535,65535,65535,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,65535,65535,182,184,186,188,190,65535,192,65535,194,196,198,200,202,204,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31847.5,3201.5,9989,6994.5,9812,12.5,22965,57,3447.5,7690.5,7923,0.05280993,0.09457388,17.5,32161.5,20.5,394,3945.5,7139.5,5720.5,16774.5,4837,14018.5,19759,-0.03258984,25808.5,27594.5,28.5,26.5,75.5,3722.5,5.5,-0.09087455,9139,13059.5,3540,6872.5,8022.5,12.5,5139.5,6753,13556,21926,-0.013550485,15.5,-0.071711816,-0.04738916,17.5,30000.5,22,15.5,27,27,54,588.5,15.5,3594,9807.5,9852.5,4017.5,3652,1009.5,25798,18.5,3879.5,8853,5427,6263.5,14097,30719.5,0.09728713,7.5,10960.5,11184.5,9.5,11405.5,10127,30065,27218,-0.0077517848,-0.009664367,24663.5,24753.5,32313,-0.023604074,22,23.5,22,-0.016482715,20.5,-0.047732197,29.5,4.5,27.5,15.5,108.5,798.5,2068.5,366,1654,4142.5,8550.5,-0.12336787,2207,12.5,14.5,7411.5,-0.12802282,6671.5,7333.5,-0.04312283,-0.09339574,-0.055016108,221.5,4770.5,3188,4153.5,4101,6397,6947.5,6815.5,7973.5,7793,7935.5,4.5,0.05908042,0.044047993,-0.11148981,10227,-0.09858328,-0.054797005,4760,-0.061996073,12297,6059.5,5571.5,9111.5,-0.017470822,2.5,6494.5,14411,18918,3.5,-0.017614651,-0.019937089,-0.029198622,-0.022790583,-0.032102477,6.5,-0.033527914,-0.026664412,-0.019578783,-0.033067796,-0.02912422,-0.02149505,-0.021596922,0.0070274845,-0.018955676,-0.06300211,-0.003207408,-0.014057954,-0.04955075,-0.11806434,-0.028395584,-0.009315907,-0.029594501,-0.13463205,-0.019180933,-0.10098659,-0.0630961,-0.022293873,0.011924811,-0.022942286,-0.13107572,-0.083426006,-0.06588468,-0.0076881684,-0.16296755,-0.14794892,-0.13657981,-0.12988566,-0.13855273,-0.15263924,-0.09012029,-0.07748979,-0.05154388,-0.069883995,-0.07760362,-0.10147666,0.00439275,-0.010243128,-0.002419113,-0.021217417,0.014682429,-0.012438667,-0.07844069,-0.057779957,-0.017309535,-0.036630925,-0.08589022,-0.060501724,-0.09587904,-0.04081739,-0.00017176951,-0.022599284,-0.06741894,-0.04054648,-0.036893796,-0.019584453,-0.012875033,-0.05375355,-0.0069568567,-0.020436639,-0.046614785,-0.06695741,-0.0913228,-0.1424791,-0.07770046,-0.09834322,-0.0705118,-0.08712507,-0.07051966,-0.092054754,-0.021756962,-0.058152128,-0.055720635,-0.021288155,-0.052046627,-0.08013275,-0.05018576,-0.064319186,-0.10419716,-0.07072271,-0.03766237,-0.07469069,-0.04030922,-0.056339145,-0.025465146,-0.02452277}, {5,5,0,0,0,8,0,0,1,3,1,255,255,8,3,7,1,7,1,0,1,1,0,0,255,0,0,0,7,5,0,8,255,0,0,0,1,1,8,5,1,3,5,255,8,255,255,8,0,3,8,3,1,1,7,8,1,0,0,3,3,5,1,8,1,0,7,0,7,1,255,8,3,3,8,1,0,0,0,255,255,0,0,5,255,0,0,5,255,3,255,0,8,1,8,0,0,3,7,1,3,0,255,1,8,8,0,255,1,0,255,255,255,3,5,1,5,1,1,0,3,7,3,0,8,255,255,255,0,255,255,3,255,0,3,7,5,255,8,3,1,3,8,255,255,255,255,255,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,31,33,35,37,39,41,43,65535,45,47,49,51,53,55,57,65535,59,61,63,65,67,69,71,73,75,77,65535,79,65535,65535,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,127,129,131,133,135,137,139,141,65535,65535,143,145,147,65535,149,151,153,65535,155,65535,157,159,161,163,165,167,169,171,173,175,177,65535,179,181,183,185,65535,187,189,65535,65535,65535,191,193,195,197,199,201,203,205,207,209,211,213,65535,65535,65535,215,65535,65535,217,65535,219,221,223,225,65535,227,229,231,233,235,65535,65535,65535,65535,65535,237,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,32,34,36,38,40,42,44,65535,46,48,50,52,54,56,58,65535,60,62,64,66,68,70,72,74,76,78,65535,80,65535,65535,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,128,130,132,134,136,138,140,142,65535,65535,144,146,148,65535,150,152,154,65535,156,65535,158,160,162,164,166,168,170,172,174,176,178,65535,180,182,184,186,65535,188,190,65535,65535,65535,192,194,196,198,200,202,204,206,208,210,212,214,65535,65535,65535,216,65535,65535,218,65535,220,222,224,226,65535,228,230,232,234,236,65535,65535,65535,65535,65535,238,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({32387,3975.5,9988.5,6901,9812,14.5,22965,104.5,3284.5,7260,9558,7.5,0.09065086,17.5,31635,51.5,350.5,6916.5,8774.5,5813.5,4410.5,8653,8910,0.04454588,0.056225378,19759,19759,-0.05541448,27092,18.5,65,360,3893.5,4.5,-0.08700788,13.5,19950,4885,9706.5,12.5,10371.5,10070,15215,5021,10451,-0.012129354,14.5,-0.014573199,-0.03130336,17.5,29889.5,24233,595.5,80.5,35.5,35.5,3242,2249.5,1809,9807.5,9803.5,3818.5,-0.06647849,6.5,-0.07475903,19.5,4674,4670,8623.5,0.046326432,0.082732946,7054.5,9709.5,7590.5,6322.5,5085,32227.5,12268,11974,10998,21324,-0.0069844252,-0.008680302,24663.5,24818,32322.5,29998.5,22,-0.056882054,76.5,31.5,31,2125,84,19.5,5.5,109.5,545.5,195,1569.5,2425.5,6.5,5389,8550.5,-0.1087023,2105,12.5,-0.08354699,-0.07208463,3936.5,-0.11936542,5617,2383.5,2187,5600.5,5883.5,5392.5,3005,4707.5,4831,7889.5,10153,-0.015114675,9868.5,10030,3.5,6218.5,6321.5,10713,-0.082654305,-0.041754633,-0.08031573,11.5,10422.5,19028,7395.5,17.5,30589.5,2.5,-0.015592742,-0.017920455,24739,-0.019922994,-0.028395588,29707,-0.022118462,-0.020672215,-0.026183924,-0.017658457,-0.0127874585,-0.03989045,0.11550256,-0.011718933,-0.043137196,-0.10977703,-0.09445938,-0.00445515,-0.02588645,-0.11506771,-0.019277897,0.009876872,0.009904386,0.0022184418,-0.07152571,-0.1225093,-0.006737889,-0.052498706,-0.053238124,-0.13504146,-0.032633837,-0.067141846,0.00038153116,-0.02456653,-0.09558542,-0.1193187,-0.057712287,-0.07405477,-0.15021715,-0.13399959,-0.124484144,-0.11798679,-0.124668255,-0.13728678,-0.101776496,-0.08029609,-0.019065272,-0.008253334,0.019932916,-0.01614303,-0.0853256,-0.01610521,-0.031901352,-0.046821237,-0.051289648,-0.07226895,-0.034902837,-0.053792085,-0.09453072,-0.061678685,-0.065600745,-0.091060646,-0.012858306,-0.052257773,-0.010356933,-0.019054348,-0.043142065,-0.059215393,-0.05945756,-0.033857048,-0.009708407,-0.016023401,-0.05280135,-0.04548684,-0.06855254,-0.05642392,-0.019639753,-0.06824903,-0.014446653,-0.023476997,-0.10246666,-0.13465966,-0.090719186,-0.081198126,-0.0836687,-0.057668686,-0.047092833,-0.074814305,-0.016569467,-0.011770188,-0.057730198,-0.06672065,-0.033857264,-0.053240087,-0.027217874,-0.023038423,-0.022768315,-0.021950228}, {3,7,0,6,0,8,0,4,7,7,6,8,255,8,7,4,3,3,6,6,6,4,7,255,255,0,0,255,6,8,4,7,6,8,255,8,0,0,6,8,4,0,4,7,6,255,8,255,255,8,6,0,0,0,3,6,6,7,3,0,6,3,255,8,255,8,6,7,0,255,255,3,0,4,6,7,4,6,3,3,3,255,255,0,6,7,0,6,255,6,6,3,0,0,8,8,0,0,0,6,0,8,6,0,255,7,8,255,255,3,255,7,0,3,3,6,0,0,3,0,6,6,255,0,0,8,7,6,0,255,255,255,8,0,4,3,8,6,8,255,255,0,255,255,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,65535,65535,45,47,65535,49,51,53,55,57,59,65535,61,63,65,67,69,71,73,75,77,79,65535,81,65535,65535,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,109,65535,111,113,115,117,65535,65535,119,121,123,125,127,129,131,133,135,137,65535,65535,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,181,65535,65535,183,65535,185,187,189,191,193,195,197,199,201,203,205,65535,207,209,211,213,215,217,65535,65535,65535,219,221,223,225,227,229,231,65535,65535,233,65535,65535,235,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,65535,65535,46,48,65535,50,52,54,56,58,60,65535,62,64,66,68,70,72,74,76,78,80,65535,82,65535,65535,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,110,65535,112,114,116,118,65535,65535,120,122,124,126,128,130,132,134,136,138,65535,65535,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,182,65535,65535,184,65535,186,188,190,192,194,196,198,200,202,204,206,65535,208,210,212,214,216,218,65535,65535,65535,220,222,224,226,228,230,232,65535,65535,234,65535,65535,236,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30624,3201.5,10036,4189.5,9657,0.061945338,31923,106.5,7030,7394,7590,28613,21629,37,330,1905.5,3836.5,5949,4603,4926.5,10601,17095,31428,20364.5,27092,22,43,410,833.5,2468,4245,13358.5,6093,4803.5,4055.5,27148,8014,13815.5,9246.5,11800,19976,-0.02704939,-0.06288508,-0.035357606,-0.028562633,-0.010978796,-0.0066876537,23150.5,30227.5,22,470,62,283,404,231,1169.5,938,-0.11014213,3037,4307,7335,2208,-0.11961546,-0.06947943,-0.09721129,3786.5,7561,8407.5,7771.5,0.060725745,26701,8185,7889.5,4156.5,-0.11066798,4972.5,6400.5,9411,7473,30440.5,15323,-0.024571946,-0.016811064,32313,-0.018419383,24,27.5,27,-0.05130514,-0.10771078,83.5,322.5,40,134.5,5252.5,1410.5,458.5,475.5,831.5,6900,1282.5,-0.07926052,-0.056739796,-0.07026121,-0.05545157,-0.052144546,-0.06667867,-0.11550007,7800,29,4833,7246,4808.5,-0.064566106,-0.1276953,4893.5,6400,0.060096014,0.005476629,7392,8086.5,8200.5,9418,13736,-0.069924705,-0.064099565,-0.048926193,8182,9606,12664,9305.5,-0.05589511,23795.5,9573.5,13028,22533.5,27018.5,-0.02609477,30108.5,-0.026854161,-0.012660812,-0.019025745,-0.013902183,0.0017267474,-0.012829378,-0.039496403,-0.08573924,-0.017899293,-0.040771473,-0.008478603,-0.0008950581,-0.11273219,-0.021771455,-0.123964034,-0.077278756,-0.00027151775,0.004064785,-0.035981547,-0.07763862,-0.006458404,-0.022157287,0.0005486326,0.030519152,-0.09925326,-0.017444419,-0.005398305,-0.042199023,-0.07972488,-0.1113736,-0.035010505,-0.010120312,-0.03188023,-0.011353074,-0.041721404,-0.018433262,-0.0098995445,-0.036091324,-0.021978354,-0.046451654,-0.065876804,-0.037266333,-0.041519076,-0.01603367,-0.06910748,-0.05017826,-0.0032606528,-0.018193174,-0.05199143,-0.013298365,-0.10173037,-0.07157857,-0.059576828,-0.08311947,-0.017421333,-0.0734082,-0.03428206,-0.054408193,-0.045989428,-0.06479394,-0.015007972,-0.05848074,-0.067953,-0.051621582,-0.085960686,-0.05834178,-0.013157086,-0.032586377,-0.061106354,-0.047253884,-0.020198101,-0.019268095}, {5,5,2,4,6,255,1,4,4,5,7,2,4,6,5,5,1,4,4,7,4,1,7,4,6,2,7,1,4,7,1,4,1,2,5,5,7,6,4,7,1,255,255,255,255,255,255,6,6,6,2,4,1,4,6,1,5,255,1,7,6,5,255,255,255,2,1,4,4,255,1,2,6,5,255,5,5,4,2,2,7,255,255,5,255,4,1,1,255,255,2,6,4,5,6,1,4,2,4,2,6,255,255,255,255,255,255,255,4,1,5,7,6,255,255,2,1,255,255,1,4,2,7,1,255,255,255,2,4,6,1,255,6,7,1,4,6,255,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,65535,65535,65535,65535,65535,65535,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,107,65535,65535,65535,109,111,113,115,65535,117,119,121,123,65535,125,127,129,131,133,135,65535,65535,137,65535,139,141,143,65535,65535,145,147,149,151,153,155,157,159,161,163,165,65535,65535,65535,65535,65535,65535,65535,167,169,171,173,175,65535,65535,177,179,65535,65535,181,183,185,187,189,65535,65535,65535,191,193,195,197,65535,199,201,203,205,207,65535,209,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,65535,65535,65535,65535,65535,65535,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,108,65535,65535,65535,110,112,114,116,65535,118,120,122,124,65535,126,128,130,132,134,136,65535,65535,138,65535,140,142,144,65535,65535,146,148,150,152,154,156,158,160,162,164,166,65535,65535,65535,65535,65535,65535,65535,168,170,172,174,176,65535,65535,178,180,65535,65535,182,184,186,188,190,65535,65535,65535,192,194,196,198,65535,200,202,204,206,208,65535,210,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30567,3345.5,9989,4049,9657,12.5,31998.5,2227.5,6879.5,7202.5,7209,2.5,18.5,28489.5,25623,89,3508.5,1799,3913.5,5720.5,3994,4926.5,10300.5,0.028446902,0.038616966,0.06470769,0.08243345,3.5,4.5,17.5,32341,57,409.5,2530,3595,1253,14.5,5.5,10112.5,2064,4672.5,12.5,17985,8.5,6845.5,11800,3.5,-0.034025487,32366,1.5,31428,21582.5,24733,29759.5,26503.5,66.5,60,44,1157.5,18.5,244.5,14.5,3533.5,-0.12150879,6.5,4237,3900.5,9807.5,9803.5,-0.06466006,8.5,18.5,4505,6160,9631.5,2.5,0.0692514,8368,3896.5,4900,10817,8623.5,12143.5,6394.5,13538,12671,22498.5,-0.060463704,-0.039569113,-0.0118996855,-0.019490844,-0.033328094,-0.028083274,20553.5,24645,19759,24825,-0.032631397,-0.023131536,-0.015147835,29720.5,27,67,-0.09974214,59,105,644,18.5,15.5,2772.5,2706.5,596,12972.5,-0.06643702,-0.044715833,-0.045356996,9.5,-0.07323524,1330.5,-0.067110725,-0.049243644,2947,5455,2020.5,3328,2105,12.5,-0.062146332,-0.093275756,17.5,144.5,4883,6831,5.5,9003.5,9305.5,9345.5,0.025150264,0.040243797,5836,8941,495,2.5,-0.07901955,-0.06264237,-0.06269875,9528,-0.05305418,6849.5,15731,5.5,4992,9677,11164.5,5091,29678,1.5,30589.5,27167,-0.009067155,16,-0.012120916,-0.014366637,-0.0111311935,21679.5,-0.018893084,-0.016311612,29654.5,7.5,-0.020198587,-0.0047975066,-0.08018836,-0.015997617,-0.036866043,-0.006755404,-0.07809435,-0.011028121,-0.09687795,-0.01516652,-0.01852874,0.020000702,-0.073876046,-0.025677327,-0.0035171441,0.0073714154,0.05277575,-0.0007137128,-0.038192745,-0.0713868,-0.014758176,-0.073854595,-0.023128746,-0.035220448,-0.07427437,-0.10244639,-0.060749527,-0.04859302,-0.04071697,-0.05237115,-0.1256597,-0.10965496,-0.08890118,-0.059688743,-0.10045574,-0.09428251,-0.10098679,-0.11236582,-0.00560794,0.010399582,-0.0040725754,0.0591651,-0.04387767,-0.020202154,-0.023238609,-0.0112019535,-0.045858204,-0.036380693,-0.05661987,-0.07548238,-0.04099875,-0.018980052,-0.05091816,-0.07678224,-0.009974132,-0.0354763,-0.016664585,-0.010955303,-0.041511845,-0.06282805,-0.04679602,-0.038846932,-0.103940465,-0.065570176,-0.07269524,-0.06324244,-0.06144136,-0.0813064,-0.031119341,-0.047858793,-0.04721404,-0.017324662,-0.019209584,-0.04452773,-0.011975973,-0.020565344,-0.03241904,-0.04903003,-0.04803517,-0.06936731,-0.028713778,-0.03893354,-0.04819196,-0.056005754,-0.05746541,-0.04153441,-0.0054656654,-0.0067782896,-0.027608348,-0.022922637,-0.01791838,-0.019448562,-0.018269036,-0.017151786}, {5,1,0,0,6,8,1,7,0,1,7,8,8,0,0,0,0,1,7,0,0,7,0,255,255,255,255,8,8,8,5,0,1,6,7,5,8,8,0,6,7,8,0,8,5,7,8,255,5,8,7,6,6,6,6,6,0,6,6,8,5,8,5,255,8,7,5,0,6,255,8,8,7,0,0,8,255,5,7,1,0,0,1,0,5,7,1,255,255,255,255,255,255,6,6,0,6,255,255,255,6,6,7,255,1,1,7,8,8,1,7,0,6,255,255,255,8,255,5,255,255,7,0,1,1,7,8,255,255,8,6,1,7,8,0,6,6,255,255,6,7,5,8,255,255,255,1,255,1,6,8,1,6,6,0,0,8,6,0,255,8,255,255,255,0,255,255,6,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,65535,65535,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,123,125,65535,127,129,131,133,135,137,65535,139,141,143,145,147,149,151,153,155,157,65535,65535,65535,65535,65535,65535,159,161,163,165,65535,65535,65535,167,169,171,65535,173,175,177,179,181,183,185,187,189,65535,65535,65535,191,65535,193,65535,65535,195,197,199,201,203,205,65535,65535,207,209,211,213,215,217,219,221,65535,65535,223,225,227,229,65535,65535,65535,231,65535,233,235,237,239,241,243,245,247,249,251,253,65535,255,65535,65535,65535,257,65535,65535,259,261,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,65535,65535,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,124,126,65535,128,130,132,134,136,138,65535,140,142,144,146,148,150,152,154,156,158,65535,65535,65535,65535,65535,65535,160,162,164,166,65535,65535,65535,168,170,172,65535,174,176,178,180,182,184,186,188,190,65535,65535,65535,192,65535,194,65535,65535,196,198,200,202,204,206,65535,65535,208,210,212,214,216,218,220,222,65535,65535,224,226,228,230,65535,65535,65535,232,65535,234,236,238,240,242,244,246,248,250,252,254,65535,256,65535,65535,65535,258,65535,65535,260,262,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30567,3189.5,9989,3728,9691.5,12.5,31923,94.5,6828.5,7272.5,9476,6.5,15.5,28489.5,25623,49.5,336,1607,3836.5,5816,19010,10862,7497,0.027923599,0.03695945,0.050418824,0.06865293,17095,4.5,17.5,32341,26.5,50.5,410,942.5,6.5,14.5,6891,11808,4759,6433,7113,12.5,8911,13418,4853.5,10624.5,-0.021297753,-0.051588207,1.5,29747.5,21629,24743.5,4.5,30108.5,33.5,24,61.5,20.5,103.5,471.5,776.5,732.5,-0.069878675,-0.09660652,8113,2786,-0.064864986,5.5,6.5,-0.08479811,6063,7561,3846,4989,5708,7140,2.5,15.5,7108.5,17.5,11820,-0.02727272,10262.5,22360,11317,5.5,-0.011533829,-0.018452901,-0.032970663,-0.02841161,20364.5,24659.5,19759,24848.5,-0.012379854,29735.5,29384.5,4.5,22,53.5,0.022185517,46,146,29.5,62.5,597.5,74.5,108.5,20.5,-0.07640167,708.5,18.5,480,15.5,4.5,8445,2696.5,5225.5,9807.5,9800.5,-0.048329692,5192.5,17.5,6399.5,4786,7846,13.5,4932,8662,9623.5,9835,6892,7689,7353,0.019447189,0.035666022,0.051690727,0.07174138,7070.5,6751.5,4.5,9795.5,11730.5,8735,4266.5,12.5,6448,10925.5,-0.060539197,17.5,12572,20597.5,-0.008567114,15,-0.011031295,-0.012954289,-0.009746971,21679.5,-0.017399576,-0.014003356,-0.034425035,-0.022315225,26579,29466,-0.016182376,-0.015034172,-0.020533482,-0.015639827,-0.0005907029,-0.012803271,-0.007002593,-0.015638715,-0.09463412,-0.06185579,-0.013806037,-0.03204293,-0.0074160136,-0.018906804,-0.004667451,0.055060662,-0.08232722,-0.012299308,-0.03053239,-0.09234449,-0.020522093,0.033012982,-0.009019682,-0.04757843,-0.0040555405,0.042520247,-0.11795332,-0.08328457,-0.03945465,-0.0145056145,-0.055260498,-0.063040935,-0.041352052,-0.056322545,-0.061190218,-0.041929044,-0.040922303,-0.048419934,-0.10280533,-0.07980947,-0.08616671,-0.097400844,-0.04920459,-0.07115728,-0.012901196,0.0003498662,-0.03867502,-0.067602165,-0.005078728,-0.033162907,-0.0004774572,-0.018406322,-0.05629033,-0.043667603,-0.007651335,-0.035937753,-0.051962186,-0.070874594,-0.03559275,-0.055133134,-0.009411773,-0.042706773,-0.048958853,-0.029705634,0.0009780232,-0.058446765,-0.059124596,-0.014704788,-0.012903345,-0.044027742,-0.049765225,-0.03325444,-0.00730505,-0.012908037,-0.004976698,-0.006918908,-0.047149528,-0.034481656,-0.055556804,-0.07310619,-0.07421282,-0.050945837,-0.07701763,-0.097269736,-0.0682973,-0.060545363,-0.023869023,-0.040680937,-0.011583313,-0.0069753528,-0.048055228,-0.03501898,-0.047637433,-0.040815074,-0.004963604,-0.006677517,-0.025024394,-0.020490332,-0.013269394,-0.015406805,-0.019442366,-0.016315993}, {5,5,0,4,2,8,1,2,4,5,4,8,8,0,0,2,5,1,1,4,1,0,5,255,255,255,255,1,8,8,5,4,1,1,4,8,8,2,2,2,4,1,8,5,0,1,4,255,255,8,0,4,4,8,2,0,5,2,8,4,4,1,5,255,255,2,1,255,8,8,255,0,1,5,5,0,4,8,8,4,8,0,255,0,2,5,8,255,255,255,255,4,4,0,2,255,4,2,8,2,0,255,4,4,0,2,0,1,0,8,255,0,8,5,8,8,2,5,4,0,2,255,1,8,0,0,0,8,2,4,0,4,1,2,4,255,255,255,255,0,5,8,2,0,4,1,8,1,1,255,8,5,1,255,8,255,255,255,0,255,255,255,255,2,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,65535,65535,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,65535,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,65535,65535,115,117,65535,119,121,65535,123,125,127,129,131,133,135,137,139,141,143,65535,145,147,149,151,65535,65535,65535,65535,153,155,157,159,65535,161,163,165,167,169,65535,171,173,175,177,179,181,183,185,65535,187,189,191,193,195,197,199,201,203,205,65535,207,209,211,213,215,217,219,221,223,225,227,229,231,65535,65535,65535,65535,233,235,237,239,241,243,245,247,249,251,65535,253,255,257,65535,259,65535,65535,65535,261,65535,65535,65535,65535,263,265,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,65535,65535,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,65535,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,65535,65535,116,118,65535,120,122,65535,124,126,128,130,132,134,136,138,140,142,144,65535,146,148,150,152,65535,65535,65535,65535,154,156,158,160,65535,162,164,166,168,170,65535,172,174,176,178,180,182,184,186,65535,188,190,192,194,196,198,200,202,204,206,65535,208,210,212,214,216,218,220,222,224,226,228,230,232,65535,65535,65535,65535,234,236,238,240,242,244,246,248,250,252,65535,254,256,258,65535,260,65535,65535,65535,262,65535,65535,65535,65535,264,266,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31254,3424.5,9988.5,3899,9795.5,31913,31923,2134.5,6901,7260,7923,0.049276333,0.039589245,28325.5,25512,96,2783.5,1809,3376,5789.5,15451.5,9105,10579.5,-0.04809655,-0.021602716,18812,32373,51.5,409.5,11739,2690.5,651,4150,13626,-0.05741045,3108,9706.5,7274,20811.5,6772.5,4903,8653,19967,-0.0076527125,22155.5,-0.020267045,30000.5,26.5,51.5,44,1235,3597,11049.5,2728,3520.5,-0.03589653,1437.5,4617.5,2952.5,2170.5,-0.08944922,41.5,7576.5,4670,9422.5,4951.5,10615.5,0.033675913,0.04414622,5229.5,7778.5,11209.5,20717,10062,14584.5,28104,27218,-0.01107047,-0.012249444,29100.5,29879.5,40,34.5,61,97.5,105,644,1170.5,1157.5,2119.5,4137.5,-0.07630894,18788.5,-0.025776569,8062,-0.009360589,5640,-0.089839235,1511.5,-0.032018736,-0.043054573,8690,3413,-0.08532592,7811.5,26.5,4565,6065.5,7896,8695,9565,3005,-0.059796453,8499.5,2038,8132.5,12899,4971.5,5191,-0.029615685,-0.038111098,-0.052381296,5412,10645.5,16813.5,7233.5,8206.5,11613.5,32227.5,13020,14169.5,16035.5,31388,26503.5,29466,30211.5,-0.013386549,-0.016798412,0.0019448809,0.004712933,-0.012699151,-0.08865314,-0.029631166,-0.011759068,0.0029016521,-0.06272208,-0.01001784,-0.07998493,-0.007039619,-0.014149958,0.02085272,-0.013908202,-0.057075746,0.002629802,-0.019698555,-0.046934355,-0.011742628,-0.027666895,-0.052726563,-0.04132732,-0.054808307,-0.029362962,-0.042637084,-0.059397858,-0.07689766,-0.05563599,-0.03270698,-0.045723785,-0.0605778,-0.06140845,-0.080051854,-0.0033332058,-0.045859974,0.0024735248,-0.013561621,-0.018477743,-0.03153048,0.00036496026,-0.011214114,-0.043919403,-0.07009814,-0.035400983,-0.0108271185,-0.06344874,-0.04397929,-0.0056369076,-0.052557584,0.008287498,-0.038051013,-0.0046905386,-0.012053937,-0.042208683,-0.029095877,-0.04407968,-0.034341466,-0.045127608,-0.054553755,-0.078923054,-0.061885547,-0.06096345,-0.053435363,-0.03733211,-0.023306623,-0.023684727,-0.006341008,-0.031800967,-0.04815122,-0.02547665,-0.011437647,-0.048429113,-0.03625145,-0.051035512,-0.0366323,-0.06643322,-0.04258283,-0.0130398525,-0.049126152,-0.02325767,-0.03562226,-0.012147956,-0.013940275,-0.017470611,-0.014803466,-0.014696971,-0.012668922}, {3,7,0,6,0,1,1,1,6,7,1,255,255,0,0,0,6,3,7,6,1,4,6,255,255,6,7,0,1,0,7,1,6,6,255,0,6,3,7,1,7,4,1,255,0,255,0,4,1,6,0,4,1,4,6,255,7,0,7,1,255,0,1,7,4,0,4,255,255,7,1,6,4,0,3,0,0,255,255,4,6,0,6,0,4,1,7,1,6,6,1,255,3,255,0,255,0,255,7,255,255,0,7,255,0,0,3,0,0,6,6,0,255,6,3,6,3,7,1,255,255,255,1,4,7,4,3,1,4,6,1,7,0,6,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,31,33,35,37,39,41,65535,65535,43,45,47,49,51,53,55,57,59,65535,61,63,65,67,69,71,73,75,65535,77,65535,79,81,83,85,87,89,91,93,95,65535,97,99,101,103,65535,105,107,109,111,113,115,65535,65535,117,119,121,123,125,127,129,131,65535,65535,133,135,137,139,141,143,145,147,149,151,153,155,65535,157,65535,159,65535,161,65535,163,65535,65535,165,167,65535,169,171,173,175,177,179,181,183,65535,185,187,189,191,193,195,65535,65535,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,32,34,36,38,40,42,65535,65535,44,46,48,50,52,54,56,58,60,65535,62,64,66,68,70,72,74,76,65535,78,65535,80,82,84,86,88,90,92,94,96,65535,98,100,102,104,65535,106,108,110,112,114,116,65535,65535,118,120,122,124,126,128,130,132,65535,65535,134,136,138,140,142,144,146,148,150,152,154,156,65535,158,65535,160,65535,162,65535,164,65535,65535,166,168,65535,170,172,174,176,178,180,182,184,65535,186,188,190,192,194,196,65535,65535,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31356,3201.5,9989,3728,9657,12.5,30333,37,6972,7394,8910,6.5,15.5,25808.5,21629,73,512,1905.5,3719,5949,4682.5,4926.5,10601,0.022180416,0.030250419,0.041746028,0.056183785,-0.043084238,26242.5,20.5,26251,24233,18.5,495.5,987.5,2468,12.5,13884.5,-0.05133281,4869,7041.5,12.5,8014,5.5,9246.5,11800,2.5,-0.017721087,29718.5,20364.5,-0.019564087,17.5,32350,28.5,25523.5,480,185.5,137,1862.5,18.5,2190.5,6.5,6022,4.5,4004,2612,12.5,4224.5,6697.5,26.5,6334.5,2563.5,22406,6280.5,10771,14235,10474.5,7367.5,6400.5,6394.5,23795.5,19266.5,21926,-0.03239907,-0.018560447,16.5,15.5,24663.5,24792.5,3.5,30228.5,461.5,77.5,-0.042281967,-0.026111806,26.5,1652.5,0.08806782,0.0059363837,100.5,284,452.5,-0.12941606,1037.5,737.5,15.5,3201,-0.055763084,17.5,-0.03607392,-0.052537035,4242.5,4262.5,2489.5,-0.03338251,5.5,7997.5,-0.07154975,-0.087998696,3474.5,18.5,5804,6020.5,6472.5,4060.5,3206,9296,0.009536713,3.5,0.035757482,0.055005945,7008.5,7341.5,7889.5,11049,14493.5,-0.056693126,7211,4926,4972.5,13.5,6592.5,6.5,16254.5,9677,10948,-0.046033125,11563.5,1.5,28478.5,27461,-0.0063849646,-0.008867633,-0.0033835259,-0.0043812036,2.5,-0.010515996,24760,24971,-0.00791552,29733.5,12.5,10.5,-0.013972896,0.011366247,0.0034232126,-0.024935095,-0.013801276,-0.0025893569,0.007379307,-0.00023162398,-0.024921669,-0.06821452,-0.016955882,0.003114544,-0.08665989,-0.03905716,-0.0092827855,-0.00032662318,-0.015779262,0.04532176,-0.04902986,-0.016323797,-0.0074004307,-0.026310159,-0.081388876,-0.06975265,-0.04485994,-0.031321805,-0.05273632,-0.039445072,-0.030145949,-0.0417488,-0.08094133,-0.07173276,-0.04513371,-0.071024925,-0.0069518215,-0.029913051,-0.008313013,0.009272382,-0.020888664,-0.03171362,-0.0061164564,-0.022353679,-0.008756131,0.012113707,-0.040956445,-0.030320792,-0.09442773,-0.044904064,-0.033180643,-0.0026763917,0.017404249,0.028555244,0.00515262,-0.01231991,-0.04735836,-0.021379394,-0.0026372185,-0.009792478,-0.061643016,-0.040608782,-0.048532683,-0.028279651,-0.032688305,-0.047597315,-0.07484197,-0.047844477,-0.042329274,-0.033261172,0.002820573,-0.0041639498,-0.031056363,-0.055027246,-0.03816906,-0.049754977,-0.012372769,-0.048269883,-0.0112200705,-0.036528494,-0.008180673,-0.012898174,-0.03773267,-0.026265914,-0.012561108,-0.022214917,-0.0335263,-0.041184913,-0.04315199,-0.029305488,-0.011584382,-0.008359956,-0.017283784,-0.014257777,-0.012782956,-0.010935786,-0.024286103,-0.018970616,-0.013378072,-0.01278369,-0.012420222,-0.011337697}, {5,5,0,4,6,8,7,6,4,5,7,8,8,0,4,5,7,5,7,4,4,7,4,255,255,255,255,255,0,8,4,0,8,6,6,7,8,4,255,6,6,8,7,8,4,7,8,255,0,4,255,8,5,6,0,4,4,7,4,8,7,8,0,8,7,5,8,7,7,0,7,6,7,6,0,6,4,5,5,0,6,7,5,255,255,8,8,0,4,8,4,0,0,255,255,6,4,255,255,6,5,7,255,5,5,8,0,255,8,255,255,7,7,6,255,8,4,255,255,6,8,6,0,4,5,7,6,255,8,255,255,4,0,6,4,0,255,0,5,5,8,0,8,6,6,6,255,5,8,4,4,255,255,255,255,8,255,0,6,255,6,8,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,65535,65535,65535,65535,47,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,75,77,79,81,65535,83,85,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,65535,65535,151,153,155,157,159,161,163,165,65535,65535,167,169,65535,65535,171,173,175,65535,177,179,181,183,65535,185,65535,65535,187,189,191,65535,193,195,65535,65535,197,199,201,203,205,207,209,211,65535,213,65535,65535,215,217,219,221,223,65535,225,227,229,231,233,235,237,239,241,65535,243,245,247,249,65535,65535,65535,65535,251,65535,253,255,65535,257,259,261,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,65535,65535,65535,65535,48,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,76,78,80,82,65535,84,86,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,65535,65535,152,154,156,158,160,162,164,166,65535,65535,168,170,65535,65535,172,174,176,65535,178,180,182,184,65535,186,65535,65535,188,190,192,65535,194,196,65535,65535,198,200,202,204,206,208,210,212,65535,214,65535,65535,216,218,220,222,224,65535,226,228,230,232,234,236,238,240,242,65535,244,246,248,250,65535,65535,65535,65535,252,65535,254,256,65535,258,260,262,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({32387,3345.5,9988.5,4049,9657,3262.5,25473,36.5,7018,7202.5,7690,2823,0.04603245,21629,32501.5,28,643.5,2060,6891,5990.5,4018.5,8605,10574,0.020808524,0.036939666,-0.007130006,24534.5,-0.031140706,30108.5,3421.5,24,94.5,1241,4180,8802,-0.048204094,2132.5,2064,4496,2446.5,13609.5,12341,6404.5,10539,19513,24645.5,24755.5,28873,29817,28.5,0.012299008,0.018717764,868,50.5,601.5,1258,1898,2990,-0.061715394,4908,8686,-0.06992159,7811.5,1761,4885,8950.5,9438.5,0.02220582,3026.5,8211,6469,5273,-0.040056027,10817,9705.5,10211,9775.5,28092.5,23550,-0.009565249,-0.0078819115,-0.010587624,-0.009781335,26983.5,29493.5,30109.5,-0.010742851,22,24,625.5,930,67.5,44,150.5,538.5,1029.5,1204.5,998,2442.5,-0.058558654,-0.08573379,6168,-0.02507766,-0.027607301,10507.5,2655.5,13633,3678.5,3445.5,5145,4905.5,4008,6519.5,9642.5,11235.5,0.03591914,0.02673899,6873.5,7933.5,18111,25499,11191,7046.5,5489.5,11312.5,0.0008290852,10100,8533,14369,-0.0052697207,10472,13013,14196.5,19631,24242.5,-0.009664471,-0.011193144,29619.5,29381,-0.011859004,-0.010172047,-0.016267082,-0.011684428,-0.010218814,-0.0061475704,-0.0039947904,-0.039435126,0.009978506,0.012671429,-0.019652015,-0.05936432,0.0045374683,-0.0065108216,-0.06767031,-0.013270798,-0.08008315,-0.041289184,-0.0012099751,-0.011578559,0.023561813,0.01381391,0.0021875997,-0.042640388,-0.0012704926,-0.022585263,-0.038195144,-0.04310345,-0.041663002,-0.028941486,-0.06807055,-0.03748574,-0.06534945,-0.071944855,-0.037116,-0.0019648268,-0.007947268,0.010001092,-0.012357542,-0.00011872094,-0.027000044,-0.015222074,-0.042366713,-0.035264295,-0.04263458,-0.06929017,-0.029396946,-0.041138846,0.013151827,-0.029333306,-0.003453165,-0.023883985,-0.00073097437,-0.011229463,-0.0059495396,-0.026527667,-0.05569752,-0.036613293,-0.030273814,-0.037198666,-0.02206729,-0.03911343,-0.04116457,-0.04980137,-0.060261328,-0.038434282,-0.0508486,-0.041273773,-0.009723836,-0.031630382,-0.008289364,-0.019938065,-0.031735927,-0.046874654,-0.042042874,-0.029603718,-0.05551632,-0.03499734,0.004346211,-0.04598502,-0.0074060815,-0.027931336,-0.0143965855,-0.01000096,-0.015244469,-0.011963162}, {3,1,0,0,6,2,2,6,0,1,3,4,255,4,1,2,3,1,2,0,0,2,4,255,255,255,6,255,2,4,3,2,0,4,4,255,1,6,1,6,0,6,3,0,1,0,2,4,6,0,255,255,1,1,2,1,3,2,255,3,2,255,0,2,0,0,3,255,2,1,3,3,255,0,6,3,6,0,0,255,255,255,255,0,4,0,255,6,4,0,0,0,2,3,3,2,2,4,0,255,255,2,255,255,2,1,0,1,1,1,1,3,2,0,2,255,255,0,0,0,0,0,3,1,1,255,6,2,2,255,1,4,1,1,4,255,255,2,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,65535,65535,65535,45,65535,47,49,51,53,55,57,59,65535,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,65535,89,91,93,95,97,99,65535,101,103,65535,105,107,109,111,113,65535,115,117,119,121,65535,123,125,127,129,131,133,65535,65535,65535,65535,135,137,139,65535,141,143,145,147,149,151,153,155,157,159,161,163,65535,65535,165,65535,65535,167,169,171,173,175,177,179,181,183,185,187,65535,65535,189,191,193,195,197,199,201,203,65535,205,207,209,65535,211,213,215,217,219,65535,65535,221,223,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,65535,65535,65535,46,65535,48,50,52,54,56,58,60,65535,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,65535,90,92,94,96,98,100,65535,102,104,65535,106,108,110,112,114,65535,116,118,120,122,65535,124,126,128,130,132,134,65535,65535,65535,65535,136,138,140,65535,142,144,146,148,150,152,154,156,158,160,162,164,65535,65535,166,65535,65535,168,170,172,174,176,178,180,182,184,186,188,65535,65535,190,192,194,196,198,200,202,204,65535,206,208,210,65535,212,214,216,218,220,65535,65535,222,224,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30434,3189.5,9989,3250.5,9825,13.5,31378.5,94.5,7030,8501.5,7923,10.5,15.5,28489.5,25623,49.5,336,1905.5,3836.5,5991.5,5136.5,4837,10835.5,3060.5,0.029508872,0.03626084,0.049947344,17095,4.5,17.5,32341,26.5,50.5,410,2381.5,1253.5,15.5,18.5,4.5,4607,6494.5,14.5,8024.5,11.5,9105,10734.5,6.5,0.016805613,3216.5,-0.011452531,3.5,3.5,29805,21608.5,24659.5,3.5,29705.5,27,24,61.5,19.5,404,18.5,18.5,1043.5,-0.09635313,6.5,9976,3660.5,15.5,9855,-0.025425358,8740,5535.5,4508,8791.5,5656,8.5,0.05018517,4.5,10106.5,5139.5,7340.5,6772.5,6.5,7009.5,10816.5,19513,15214.5,0.025207937,0.01787667,-0.01816418,-0.037893325,31288.5,-0.011748175,-0.020193344,-0.016118102,19268.5,24743.5,19759,24848.5,-0.0051107206,29720,29645.5,29712.5,16.5,81.5,6.5,26,146,279,106.5,284.5,134.5,12.5,471.5,1451,632.5,1275,2943,2305.5,7515.5,1633.5,4621,-0.022426143,2177.5,2093.5,2573,9855,-0.059639186,-0.07184803,-0.033301745,10.5,3782.5,18.5,4423.5,5808.5,4506,3490.5,10176.5,6861,30719.5,0.02937144,6232,8971,5980.5,12575.5,4.5,12304.5,10076.5,-0.030401383,8065.5,7.5,10444,10356.5,9097,8309.5,4096.5,1.5,11572,1.5,11714.5,12572,-0.006489909,-0.009179417,-0.005396373,15.5,2.5,-0.008480701,-0.0062483074,21679.5,-0.01216829,-0.009566789,-0.023533745,-0.014779686,29384.5,29720.5,-0.008946894,3.5,-0.01412223,-0.009579472,-0.0018360891,-0.012701496,0.019981517,0.014955466,-0.00095741794,-0.00963438,-0.06484844,-0.03409196,-0.021318,-0.002664508,-0.009829417,0.008161785,-6.05236e-05,0.03464183,-0.057195276,0.006515769,-0.07579783,-0.06074011,-0.014982319,-0.051182706,0.036762998,-0.017856136,-0.0026419251,-0.022497686,-0.006896689,0.013939847,-0.09985825,-0.074942656,-0.038492516,-0.0067481524,-0.0435205,-0.057342198,-0.06491571,-0.04928784,-0.04050849,-0.01995173,-0.0028927096,-0.00040452924,-0.04116842,-0.028689623,-0.061359733,-0.05595347,-0.0491244,-0.06394083,-0.04131842,-0.05649182,-0.0049585765,-0.01278356,0.002029728,0.020798631,-0.0076951697,-0.028401146,-0.019761069,-0.010075073,-0.036487065,-0.02477744,-0.07200115,-0.039171986,-0.0068169744,-0.030185131,-0.031643953,-0.017885363,0.020605864,0.011757831,0.00032524107,0.010231809,-0.006430007,0.00017459609,-0.006646061,-0.029579764,-0.0059364014,-0.029900655,-0.040884342,-0.052641,-0.026791388,-0.03693549,-0.035222765,-0.06512108,-0.028296007,-0.036687694,-0.012025484,-0.027552966,-0.044889074,-0.029579377,-0.043928374,-0.026090419,-0.01887676,-0.0049051307,-0.022823824,-0.040291708,-0.008450028,-0.03782581,0.0052601714,-0.0074609267,-0.03143868,-0.024514614,-0.008037843,-0.021159835,-0.013801864,-0.040179826,-0.041943964,-0.030243436,-0.0022818814,-0.0038178582,-0.009209781,-0.0068863146,-0.019422596,-0.015132296,-0.009939635,-0.0109648155,-0.013423818,-0.01092968,-0.011599363,-0.010252873}, {5,5,0,4,0,8,1,2,4,1,1,8,8,0,0,2,5,5,1,0,0,1,2,2,255,255,255,1,8,8,5,4,1,1,4,5,8,8,8,2,1,8,0,8,4,5,8,255,4,255,8,8,0,2,4,8,2,2,5,2,8,4,8,8,5,255,8,2,4,8,2,255,0,0,5,4,2,8,255,8,1,5,5,1,8,2,1,1,0,255,255,255,255,0,255,255,255,0,4,0,2,255,4,2,2,8,0,8,2,4,4,4,0,5,8,4,2,0,1,2,5,0,1,1,255,5,5,5,2,255,255,255,8,2,8,4,2,1,1,4,2,1,255,4,1,2,4,8,0,0,255,2,8,4,5,1,4,2,8,1,8,1,5,255,255,255,8,8,255,255,0,255,255,255,255,2,0,255,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,65535,65535,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,65535,121,123,125,127,129,65535,131,133,135,137,139,141,65535,143,145,147,149,151,153,155,157,159,161,65535,65535,65535,65535,163,65535,65535,65535,165,167,169,171,65535,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,65535,217,219,221,223,65535,65535,65535,225,227,229,231,233,235,237,239,241,243,65535,245,247,249,251,253,255,257,65535,259,261,263,265,267,269,271,273,275,277,279,281,65535,65535,65535,283,285,65535,65535,287,65535,65535,65535,65535,289,291,65535,293,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,65535,65535,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,65535,122,124,126,128,130,65535,132,134,136,138,140,142,65535,144,146,148,150,152,154,156,158,160,162,65535,65535,65535,65535,164,65535,65535,65535,166,168,170,172,65535,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,65535,218,220,222,224,65535,65535,65535,226,228,230,232,234,236,238,240,242,244,65535,246,248,250,252,254,256,258,65535,260,262,264,266,268,270,272,274,276,278,280,282,65535,65535,65535,284,286,65535,65535,288,65535,65535,65535,65535,290,292,65535,294,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27582.5,3201.5,9989,6994.5,9657,11.5,31378.5,57,3447.5,8673.5,7690,2400.5,15.5,28727,25512,41.5,2068.5,4.5,7139.5,5721,4167.5,6283,10300.5,0.024805536,2752.5,0.03126667,0.04628679,22778,3.5,17.5,12370,45.5,5.5,15.5,2110,9803.5,9803.5,2377.5,10412.5,4904.5,3767,7451.5,8501.5,12416.5,9650.5,14938.5,6.5,0.022866976,2.5,0.008212793,1.5,31320.5,29818.5,21582.5,24733,-0.023370277,32313,22,-0.06881092,75.5,104.5,103.5,409.5,18.5,4969.5,8550.5,2.5,7.5,12.5,-0.06355839,11386,3756.5,651.5,3819,4751,4355,6894.5,9496,12.5,6988,20454.5,8282.5,12.5,9683.5,10542,10534,2.5,12468.5,15140,0.005833454,3170.5,0.0075877192,31068.5,30357,1.5,29687.5,29556.5,20553.5,24733,19759,24798,4.5,29720.5,28.5,59.5,41,104.5,49,18.5,33,340,103.5,2916.5,2356.5,2310.5,15.5,1.5,2643.5,2170,-0.044305094,-0.03823391,2604.5,2202,-0.05356127,-0.06254447,14.5,4.5,7333.5,8022,11.5,-0.043599453,18.5,5110,16.5,5356,5933.5,3790,7061.5,5590.5,4.5,-0.027500486,2257.5,0.038513515,5991.5,7607,10298,22860.5,3277.5,3680,4422,15093.5,8126,8900,4.5,12047.5,9663,1.5,-0.012713815,4225,29830.5,1.5,12944.5,12572,0.011756747,0.017774973,31735,30177,2.5,-0.0040694894,-0.004167572,-0.0077588237,-0.01211857,-0.016746055,29338.5,4.5,-0.00481272,14.5,2.5,-0.0077189184,-0.0053915395,21679.5,-0.010976563,24834,29262,-0.0140764555,29654.5,29729.5,-0.013615273,-0.008599421,0.0010678909,-0.010360255,0.011236033,0.020678187,-0.0026026655,0.0018376425,-0.00073327887,-0.0075709797,0.006814815,-0.0026624538,-0.011938511,-0.024746139,-0.05520928,-0.035513654,-0.013936496,-0.04071815,0.002856526,-0.04886858,-0.0040454017,0.012607241,0.0012843638,0.03970382,-0.036943,-0.023071297,0.011069767,-0.0068688216,-0.0743775,-0.054070037,-0.03817365,-0.06092597,-0.05688287,-0.04070623,-0.051911242,-0.04689475,-0.036273386,-0.029452479,-0.03051341,-0.05772127,0.01736778,0.006864514,-0.01629711,-0.0069974656,-0.009294099,-0.022241881,-0.0034544286,0.018729081,-0.028997425,-0.019428834,-0.006092125,0.0004716421,-0.0063456036,-0.019989965,-0.0017458324,-0.033913575,-0.009276286,0.009273531,-0.023579469,-0.03173202,0.0014409809,-0.018585881,0.009640899,0.00013782362,0.007813906,0.01776219,-0.011209206,-0.04433903,-0.0289724,-0.0034272224,-0.004501424,-0.010045052,-0.032995645,-0.019856138,-0.044050865,-0.028377656,-0.05095121,-0.039745126,-0.053307123,-0.04042738,-0.05300487,-0.06588755,-0.0066005806,0.0036905052,-0.028398454,-0.015157892,-0.05090527,-0.037674733,-0.028260514,-0.038466576,-0.012957633,-0.038022887,0.0031276636,-0.007908347,-0.016678749,-0.031428657,-0.02575472,-0.038512036,-0.011835339,-0.021800963,-0.014655053,-0.037120275,-0.037813798,-0.027501037,-0.04261514,-0.031781223,-0.038480505,-0.028281057,0.0008016795,-0.00057654735,-0.014552677,-0.010353381,-0.010245162,-0.014771498,-0.002101982,-0.001577909,-0.008413795,-0.0061188266,-0.017368464,-0.013599726,-0.010026385,-0.008463707,-0.0008485806,-0.0067563513,-0.0094158435,-0.010633552,-0.0081873005,-0.009317165}, {3,5,0,0,6,8,1,0,1,5,3,6,8,0,0,1,3,8,1,6,0,1,0,255,0,255,255,0,8,8,6,0,8,8,6,6,6,3,0,1,0,3,1,0,0,6,8,255,8,255,8,0,6,6,6,255,5,6,255,5,3,6,1,8,3,0,8,8,8,255,6,3,6,0,6,5,3,5,8,6,0,0,8,6,0,3,8,5,0,255,6,255,5,5,8,0,5,6,6,0,6,8,6,0,6,6,3,0,8,6,5,6,6,5,0,8,8,1,1,255,255,5,5,255,255,8,8,0,0,8,255,8,6,8,3,6,1,6,5,8,255,6,255,3,3,0,1,0,5,1,6,0,0,8,0,0,8,255,0,0,8,3,5,255,255,3,3,8,255,255,255,255,255,1,8,255,8,8,255,255,0,255,0,5,255,6,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,65535,65535,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,65535,91,93,95,97,99,65535,101,103,65535,105,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,163,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,65535,219,221,65535,65535,223,225,227,229,231,65535,233,235,237,239,241,243,245,247,249,65535,251,65535,253,255,257,259,261,263,265,267,269,271,273,275,277,279,65535,281,283,285,287,289,65535,65535,291,293,295,65535,65535,65535,65535,65535,297,299,65535,301,303,65535,65535,305,65535,307,309,65535,311,313,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,65535,65535,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,65535,92,94,96,98,100,65535,102,104,65535,106,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,164,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,65535,220,222,65535,65535,224,226,228,230,232,65535,234,236,238,240,242,244,246,248,250,65535,252,65535,254,256,258,260,262,264,266,268,270,272,274,276,278,280,65535,282,284,286,288,290,65535,65535,292,294,296,65535,65535,65535,65535,65535,298,300,65535,302,304,65535,65535,306,65535,308,310,65535,312,314,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30434,3201.5,9989,3063,9739,11.5,32366,37,7030,7394,9594,2987.5,15.5,26610.5,21629,28.5,467.5,1607,3836.5,6104.5,7008.5,10215.5,9483.5,7.5,3048.5,0.028501144,0.0417069,4.5,4.5,17.5,26758.5,22,18.5,523.5,944,2051,15.5,18.5,7,3819,9733,7212.5,7171.5,10025,10682,5696,10579.5,0.015574214,0.021939628,0.01512844,0.0077518425,-0.018330488,-0.033982296,1.5,29722.5,20364.5,20364.5,17.5,29713,4.5,19.5,27,595.5,198.5,5952.5,1037.5,940,-0.088278055,6.5,11271.5,4353,5.5,9801.5,-0.021734405,8740,18.5,4913,4316.5,9337.5,3413,7921,5737.5,20454.5,6804.5,10867.5,8603.5,18.5,10352.5,7.5,10729,2.5,-0.0034863483,31378.5,29704,27731,17170.5,15.5,-0.00491305,-0.016496345,24663.5,24753.5,29660.5,12.5,3.5,-0.012664999,26.5,22,32.5,30.5,27,32.5,106.5,216,793,798,651,18.5,2879.5,16.5,1293,1853.5,2848.5,-0.00057407754,3848,2932.5,9807.5,9800,9132.5,-0.058159884,-0.026765257,-0.045373883,3680.5,596.5,3771.5,4821,8662,9219,4826,9607,15.5,15.5,6145,17.5,7715,6933,11176,22860.5,17542.5,9066.5,17.5,-0.034036558,9453,10021.5,4.5,-0.0018493701,9789.5,12.5,10507.5,12887,11347,2.5,11508.5,30835.5,2.5,-0.0049545327,-0.020018427,-0.016041547,-0.017755201,-0.013348013,-0.0033323837,-0.0047095628,13.5,-0.0032905003,3.5,-0.0068733194,24745,24971,26342,29735.5,29619,29745.5,-0.010119838,-0.0062503815,-0.008531313,-0.00040494028,-0.0008770746,-0.0024835076,0.015228945,0.006274506,-0.012632194,-0.0008746261,0.011395688,-0.003132362,0.064094946,-0.02859783,-0.01490968,-0.047132924,0.06520756,-0.005284715,-0.05683717,-0.07466275,-0.009644515,-0.03432951,0.0072687888,-0.0057715154,0.008675024,0.06449684,-0.04125166,-0.06854695,-0.017075261,0.00016399121,-0.048658013,-0.03294962,-0.056616515,-0.03146301,-0.039802887,-0.030569896,0.0017577354,-0.011450323,-0.03627981,-0.022740701,-0.05758332,-0.03914888,-0.043859754,-0.051366158,-0.050652217,-0.046090882,-0.0069844173,0.006305796,-0.020817094,0.0155200185,-0.030745475,-0.019455457,-0.0032950845,-0.014372632,-0.02815846,-0.05290869,-0.021673402,-0.0061052823,-0.061038416,-0.026045803,-0.048696425,-0.03510606,0.018155314,0.03980187,0.0040000156,0.010864508,-0.0066553885,-0.018578319,-0.00052204303,-0.012106903,0.0019819885,-0.01790916,-0.032937225,-0.017575832,-0.008909629,-0.004638591,-0.030296296,-0.017412566,-0.0071576894,-0.034660336,-0.02016992,-0.033387993,-0.006033467,-0.00025730202,-0.04128851,-0.03246275,-0.011530164,-0.025187124,-0.0024697275,-0.0072058975,-0.018051026,-0.029082173,-0.038938027,-0.05417905,-0.033967048,-0.024123622,-0.03521001,-0.020043928,-0.03643752,-0.005127944,-0.011088812,-0.027913546,-0.02747461,-0.013467121,-0.021856746,-0.02610533,-0.006129149,-0.009165861,-0.0018961646,-0.0014236908,-0.0073426752,-0.0050831786,-0.0124336155,-0.00916005,-0.0087821735,-0.007040581,-0.012844928,-0.008438375,-0.011480152,-0.008671494,-0.007598571,-0.008839685,-0.0072369776,-0.007996826}, {5,5,0,4,6,8,5,6,4,5,0,0,8,4,4,0,5,1,1,4,4,4,1,8,6,255,255,8,8,8,4,6,8,4,4,0,8,8,8,0,4,6,1,5,1,5,6,255,255,255,255,255,255,8,4,4,4,8,0,8,8,1,0,5,6,5,5,255,8,6,0,8,6,255,0,8,1,5,6,0,5,0,0,4,6,5,8,0,8,0,8,255,1,0,1,0,8,255,255,0,0,0,8,8,255,0,0,0,5,1,6,4,4,4,0,6,8,0,8,1,5,1,255,6,1,0,6,6,255,255,255,1,0,5,6,4,4,5,6,8,8,4,8,4,1,5,1,6,0,8,255,0,5,8,255,0,8,0,5,1,8,1,4,8,255,255,255,255,255,255,255,8,255,8,255,6,6,0,4,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,65535,65535,65535,65535,65535,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,65535,119,121,123,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,163,165,167,169,171,65535,65535,173,175,177,179,181,65535,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,65535,217,219,221,223,225,65535,65535,65535,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,65535,265,267,269,65535,271,273,275,277,279,281,283,285,287,65535,65535,65535,65535,65535,65535,65535,289,65535,291,65535,293,295,297,299,301,303,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,65535,65535,65535,65535,65535,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,65535,120,122,124,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,164,166,168,170,172,65535,65535,174,176,178,180,182,65535,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,65535,218,220,222,224,226,65535,65535,65535,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,65535,266,268,270,65535,272,274,276,278,280,282,284,286,288,65535,65535,65535,65535,65535,65535,65535,290,65535,292,65535,294,296,298,300,302,304,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,7062,31028.5,1934,3550,6872.5,13028,94.5,3697.5,3804,9686,3288.5,31378.5,12.5,6.5,49.5,2262,18.5,7255.5,18.5,4.5,6397,15009,14.5,5969,10802,21582.5,11130,12102.5,19268.5,22497,20.5,53,15.5,1618,2066,1727.5,4000.5,5937,15.5,9794,7890,12218,9014.5,9296,10285.5,11567.5,6.5,2544,12.5,7296.5,8523,6178.5,18.5,26740,-0.040790852,2.5,-0.05019303,-0.04294431,1.5,2.5,12.5,28007.5,22,122,-0.05764941,52.5,1340.5,555.5,5906.5,15.5,6204,2790.5,736,2584,4356,6204.5,9538.5,11181,1994.5,9794,3304,-0.052333403,-0.031260323,11788.5,-0.035431456,-0.04556113,3847.5,9134.5,8601,6267,4.5,11.5,8.5,12932.5,31133,23411,2340,16.5,8,5670.5,16.5,7392,7011.5,7959.5,7320,28700,20553.5,20553.5,17.5,31905.5,-0.027559951,-0.034326654,18740.5,14993.5,1.5,28007.5,19268.5,19268.5,8.5,31827,22,15.5,23.5,153,61,113.5,336,6.5,575.5,2855,18.5,6299.5,3159.5,4350.5,2353.5,4325,12358.5,3925,0.065507255,1117.5,2293.5,3606.5,6646.5,4253.5,4802,5681.5,5267.5,15354,6056.5,16646.5,5.5,7767,17.5,-0.045811635,9112.5,-0.024414575,-0.011897832,-0.023284344,1899,6710.5,6.5,8490.5,6990,8801.5,7213,9628.5,5061,6.5,6462.5,11300.5,17495,5743.5,-0.013437535,-0.0059948694,2.5,3157.5,0.023531852,3203,0.028979678,0.018097991,0.028909579,0.03861698,7409.5,-0.0065195784,-0.016887188,-0.02526074,0.014459799,0.034283523,5.5,16.5,5427.5,7925,4113.5,9720.5,5462.5,1.5,10208.5,30207.5,-0.004088325,15.5,-0.005047733,-0.014154883,24645,24744.5,4.5,30227.5,-0.0145314215,-0.011620868,-0.025218144,18746,19254,19132,21989,4.5,20395,18892,20395,18770.5,-0.017232371,18952,29556.5,-0.0060041677,-0.011296815,0.0020182882,-0.008281855,-0.00058866054,0.012928831,-0.001912161,-0.037189722,-0.00764402,-0.038797215,-0.01432118,-0.0048843287,0.031669464,-0.042138774,-0.013917196,-0.035912614,-0.05637024,-0.022489527,-0.04225042,0.00083859416,-0.051798742,-7.823369e-05,0.026751313,-0.046042453,-0.021648774,-0.05040303,-0.02700742,-0.01016952,-0.029935224,0.0011424609,0.012417864,-0.02466741,-0.004622161,-0.030816397,0.0069255317,0.004455311,-0.0049811844,-0.03678859,0.01345482,0.009454119,0.043603018,-0.006469719,0.040763404,-0.028703189,0.0065820315,0.0013342164,-0.019295027,-0.018980004,-0.013622681,-0.0055223685,-0.034867134,0.006065258,-0.005061573,-0.018454678,-0.031528275,-0.01608478,-0.038221024,-0.001968793,-0.016801426,-0.06188343,-0.042012274,-0.025968421,-0.043975253,-0.0365909,-0.02915722,-0.04624898,-0.041673787,-0.040527344,-0.027876368,-0.020138951,-0.02843537,-0.021984827,-0.060074475,-0.016360674,-0.032309145,-0.021098336,-0.046169695,-0.01419148,0.0038049927,-0.035560843,-0.012458334,0.013863106,-0.0016805705,-0.022440799,-0.04284105,-0.013857379,-0.032562934,-0.029610861,-0.020259975,-0.028497294,-0.036724012,-0.03856066,-0.031813182,-0.049955867,-0.039399758,0.007506612,0.016043542,0.009288989,0.004634998,0.014864618,0.022944516,0.0048473678,-0.0010154117,0.0072631487,-0.0021733176,0.0058830758,0.015194856,-0.004983533,-0.033774298,-0.0008756312,-0.024084408,0.013590832,-0.0010363425,-0.01707596,-0.005227014,-0.035506714,-0.024597934,0.008519197,-0.0060951044,-0.02593712,-0.019220013,-0.010204024,-0.023237955,-0.0016865379,-0.0029689015,-0.00465864,-0.0060956553,-0.010591571,-0.00717716,-0.00391985,-0.011536139,-0.007774045,-0.006731855,-0.020875392,-0.018760204,-0.012893093,-0.0066844234,-0.016965508,-0.011005569,-0.017267196,-0.014678237,-0.0060433177,-0.009471485,-0.024107227,-0.03138859,-0.023490135,-0.020489264,-0.027467981,-0.03447626,-0.027168637,-0.024265124,-0.013535336,-0.019755462,-0.008147732,-0.011296726}, {7,6,2,1,7,6,1,2,2,1,2,6,1,8,8,2,7,8,1,8,8,1,6,8,6,6,6,5,1,7,1,5,2,8,1,6,5,7,6,8,2,6,6,2,6,2,5,8,6,8,7,7,5,8,6,255,8,255,255,8,8,8,1,1,6,255,1,6,1,6,8,1,5,7,1,1,7,2,1,7,2,7,255,255,2,255,255,5,2,5,5,8,8,8,5,1,1,6,8,8,2,8,7,2,6,2,2,6,6,8,7,255,255,5,1,8,1,7,7,8,1,2,8,5,7,2,5,5,8,2,6,8,6,7,2,5,5,1,1,255,7,7,2,5,2,7,1,5,2,7,1,8,6,8,255,6,255,255,255,1,5,8,6,7,1,1,6,5,8,1,6,6,7,255,255,8,6,255,6,255,255,255,255,1,255,255,255,255,255,8,8,5,5,5,7,1,8,7,6,255,8,255,255,6,6,8,6,255,255,255,5,1,1,7,8,5,5,5,5,255,6,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,65535,65535,113,115,117,119,121,123,65535,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,65535,157,65535,65535,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,65535,65535,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,65535,259,261,263,265,267,269,271,273,275,277,279,281,283,285,65535,287,65535,65535,65535,289,291,293,295,297,299,301,303,305,307,309,311,313,315,65535,65535,317,319,65535,321,65535,65535,65535,65535,323,65535,65535,65535,65535,65535,325,327,329,331,333,335,337,339,341,343,65535,345,65535,65535,347,349,351,353,65535,65535,65535,355,357,359,361,363,365,367,369,371,65535,373,375,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,65535,65535,114,116,118,120,122,124,65535,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,65535,158,65535,65535,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,65535,65535,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,65535,260,262,264,266,268,270,272,274,276,278,280,282,284,286,65535,288,65535,65535,65535,290,292,294,296,298,300,302,304,306,308,310,312,314,316,65535,65535,318,320,65535,322,65535,65535,65535,65535,324,65535,65535,65535,65535,65535,326,328,330,332,334,336,338,340,342,344,65535,346,65535,65535,348,350,352,354,65535,65535,65535,356,358,360,362,364,366,368,370,372,65535,374,376,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,7049,31028.5,1806,3564,10301,13759.5,96,3697.5,2170.5,9634.5,14489,31340.5,11020.5,22497,51.5,552.5,2085,3641.5,8287.5,7904,5683.5,11609,10639,3262.5,10208.5,24137,-0.04387589,27810,19130.5,28007.5,5965.5,38.5,651.5,1235,24485.5,2433.5,2794.5,7144,-0.040998455,2176,2591.5,13884.5,1564.5,9694.5,10513,11966.5,7369,20615,21407,0.027310912,21807,28725,17170.5,28734,-0.027510077,-0.035863105,15837,21850,13537,31580.5,20.5,-0.039995443,61,89,148.5,1447.5,722.5,976.5,2565,-0.03598863,4936.5,3556.5,3887.5,3419,4323.5,7195,-0.04637366,2240.5,-0.04202209,6420.5,2105,-0.043786064,-0.05764265,9065,5347,8881.5,9471,6285.5,19369.5,6241,5372.5,8169.5,9283,-0.0009909839,3096,3207.5,12139,28578.5,21165,31364.5,-0.0028107043,19759,26758.5,31905.5,17472,19978,18976,22245.5,-0.01033279,25574.5,-0.005694111,30052.5,3637.5,27,32.5,67.5,29.5,81,38,225.5,512,603,684.5,726.5,1476.5,2179.5,3567,-0.02303136,1898,2540.5,3073.5,4178,-0.022551745,3606.5,6074.5,3720,4226,5760.5,6978,8116,-0.034839895,-0.04345717,-0.03635379,7637.5,-0.0434828,2109.5,4451.5,4594,6577,6783.5,11813.5,9758,9271.5,9757,5236.5,6593,8394,-0.041923173,25554,-0.007824591,5319.5,7054.5,8175,9605,17111,13018.5,0.01702653,0.008236879,3251.5,0.0133031905,9548.5,9911.5,25908,25864,28185,18196,30426,19722,-0.0050531863,-0.0040652007,24833,-0.0063836845,29770.5,29705.5,-0.027108354,-0.02306485,28645.5,-0.014616298,19486,18769.5,-0.024679126,-0.037491713,23955.5,-0.023610095,30700.5,30266,-0.009278216,0.00756636,0.004474506,-0.0043275054,-0.05759368,-0.043273445,-0.013644906,-0.054432403,-0.011568419,-0.0019726118,0.007555581,0.025609193,-0.0031143941,-0.040880285,0.07989125,-0.02135869,-0.053797033,-0.01296286,-0.053783532,-0.08245426,0.0043087243,-0.031716723,0.03450923,0.005905255,0.0031951263,0.014222716,-0.032099593,-0.0054936544,0.009015716,-0.007220103,0.00090696535,-0.019868461,-0.0044059185,-0.0218681,0.0057249633,-0.004146893,0.0057037137,0.02302759,-0.031066451,-0.02680423,-0.01758453,-0.025514996,-0.027445653,-0.021506606,-0.012941601,0.0073161833,-0.013461411,-0.022785928,0.006587792,-0.0063144006,-0.04506233,-0.025328984,-0.026294539,-0.020127831,-0.022938812,-0.038164463,-0.027164696,-0.020017976,-0.043238983,-0.024123223,0.012046116,-0.014531222,-0.030619351,-0.013467691,-0.02611441,-0.034531534,-0.014848088,-0.022156592,-0.022755582,-0.0066315862,-0.03270206,-0.029614702,-0.021074884,-0.028908586,-0.005744384,-0.0204583,-0.019129897,-0.032935,-0.036777895,-0.021821657,-0.006890919,0.009842957,-0.023256196,-0.00849163,0.007900372,-0.0024128635,-0.014457688,-0.0037544407,-0.016666371,-0.023629628,-0.02837727,-0.021169603,0.022555012,0.015293488,-0.02832984,-0.021846859,-0.049222134,-0.02206477,-0.019291913,-0.014402802,-0.0014677716,-0.0075844214,-0.015723249,-0.029629527,0.009811948,-0.026384285,-0.008831842,-0.03875695,-0.028293008,-0.015271901,-0.006199602,-0.005688555,-0.008963867,-0.011497031,-0.0073896656,-0.0066910633,-0.024718327,-0.021615623,-0.019812038,-0.021674745,-0.019948494,-0.018129706,-0.016368598,-0.015325591,-0.008234859,-0.004712447,-0.008397825,-0.009805609}, {7,2,2,1,3,0,1,0,2,1,4,1,1,1,1,0,7,4,3,4,0,3,0,4,2,7,4,255,0,1,1,7,1,4,0,0,3,3,1,255,3,3,4,1,2,4,1,3,2,7,255,4,0,0,4,255,255,7,1,7,0,7,255,0,4,1,4,3,4,2,255,1,2,0,7,2,7,255,3,255,4,7,255,255,0,1,3,2,1,2,7,2,2,1,255,0,2,1,0,1,0,255,0,4,7,1,3,3,1,255,1,255,3,4,7,3,0,7,0,4,0,1,0,2,3,0,3,0,255,2,2,1,3,255,1,2,7,3,7,0,4,255,255,255,0,255,7,3,1,4,0,0,3,0,0,7,1,2,255,4,255,3,3,7,3,4,7,255,255,0,255,7,7,2,2,0,3,2,1,255,255,4,255,0,2,255,255,4,255,1,7,255,255,7,255,1,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,55,57,59,61,63,65,67,69,71,73,75,65535,77,79,81,83,85,87,89,91,93,95,65535,97,99,101,103,65535,65535,105,107,109,111,113,65535,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,65535,141,65535,143,145,65535,65535,147,149,151,153,155,157,159,161,163,165,65535,167,169,171,173,175,177,65535,179,181,183,185,187,189,191,65535,193,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,65535,227,229,231,233,65535,235,237,239,241,243,245,247,65535,65535,65535,249,65535,251,253,255,257,259,261,263,265,267,269,271,273,65535,275,65535,277,279,281,283,285,287,65535,65535,289,65535,291,293,295,297,299,301,303,305,65535,65535,307,65535,309,311,65535,65535,313,65535,315,317,65535,65535,319,65535,321,323,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,56,58,60,62,64,66,68,70,72,74,76,65535,78,80,82,84,86,88,90,92,94,96,65535,98,100,102,104,65535,65535,106,108,110,112,114,65535,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,65535,142,65535,144,146,65535,65535,148,150,152,154,156,158,160,162,164,166,65535,168,170,172,174,176,178,65535,180,182,184,186,188,190,192,65535,194,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,65535,228,230,232,234,65535,236,238,240,242,244,246,248,65535,65535,65535,250,65535,252,254,256,258,260,262,264,266,268,270,272,274,65535,276,65535,278,280,282,284,286,288,65535,65535,290,65535,292,294,296,298,300,302,304,306,65535,65535,308,65535,310,312,65535,65535,314,65535,316,318,65535,65535,320,65535,322,324,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({26707,3973,9989,7008,9791.5,3209.5,32366,104.5,3764.5,7260,8718,3159,0.025894374,28341.5,25993.5,31.5,330,1942,166,5373,10301,11287.5,15214.5,0.020112796,0.013889748,21880.5,22025.5,20364.5,30108.5,37,197.5,404.5,833.5,4674,7843,15937,8295,4958,5392.5,7054.5,8372.5,15488.5,18616.5,13556,12572,-8.5714765e-07,28117,0.00999443,29744.5,16907.5,19784,30326,30132,27,62,99,87,134.5,164,522.5,912,-0.056109786,-0.037725154,5966.5,13896.5,6916.5,25496.5,4962.5,4317,3723,5287.5,5331,5595.5,5051.5,8162.5,10957,12009.5,10645.5,10285.5,15407,21936.5,13531,10127,30133.5,18489.5,26025,30280,29683.5,30278,-0.0022483072,17224,-0.0031221567,24873,29555,-0.004856152,-0.0053334753,30224.5,32.5,25.5,32,83.5,126.5,-0.032396074,7665,581.5,228.5,216,513,3774,642.5,435,513.5,1171,7154,7666.5,2176,15900.5,5253.5,-0.001397633,-0.026894683,-0.011834942,2075,7263.5,9814.5,7652,268,4786.5,4927.5,4763.5,5788.5,6180,5733,7212,2808,7273.5,4428,9605,0.0028106752,11795.5,10206,11287,9471,11534,18873.5,17943.5,-0.016557837,-0.007651835,0.0030421503,-0.0032664102,11190,11830.5,12339.5,21455,22289,11094,19610,20832.5,27713.5,-0.014765525,26695.5,30943.5,-0.016453978,30747.5,22719.5,30852.5,-0.004614755,-0.0030981058,24277.5,-0.0050658933,29692.5,29713,30181,-0.005446009,-0.008435175,-0.004221998,0.0024632483,-0.006874472,-0.05150677,-0.031930696,-0.012626811,-0.03827967,0.0002640939,-0.0062645883,0.007258173,-0.0045295474,0.028002057,0.015670186,-0.03135999,-0.049465917,0.08302468,-0.0046096407,-0.037335984,-0.018268833,-0.04549555,-0.01806341,0.006042576,0.020967381,-0.07492312,0.0008718573,-0.05467806,-0.033503816,3.40815e-05,-0.014944925,-0.023612497,-0.034256306,-0.02045155,-0.025770465,-0.03798045,-0.034159437,-0.037753027,-0.04477158,0.0037156963,0.008351984,-0.033400178,-0.020591583,-0.0035671212,-0.012404031,-0.045240484,-0.02976895,-0.038916837,-0.02113114,-0.028421924,-0.0031087974,-0.019395294,-0.00957556,-0.0035655939,0.009213864,2.967795e-05,-0.015868276,-0.003994076,0.012041686,-0.01064724,-0.017989716,-0.018614218,-0.00044320413,-0.01919011,-0.0381761,-0.0053782235,0.0060180975,0.01716695,-0.023166617,0.016362114,3.8151793e-05,-0.013924584,-0.003390638,-0.0068609463,-0.012733872,-0.042455833,-0.026269767,-0.0011431541,-0.018790953,-0.012741499,-0.027928973,-0.018552003,-0.0257642,-0.030619165,-0.036473393,-0.02668477,-0.018533671,-0.011802555,-0.0049516037,-0.019022314,-0.035794683,0.002101178,-0.01205434,-0.027830133,-0.007929827,-0.025348201,-0.016820434,-0.03838618,-0.031811822,-0.036200073,-0.012351995,0.0010890602,-0.016835548,-0.022802744,-0.01608955,-0.023569113,-0.030125836,-0.025001222,-0.015850214,-0.010980616,-0.007782536,-0.011514355,-0.006264535,-0.009434422,-0.0078242365,-0.0051431525,-0.0055662855,-0.006178539,-0.004902516,-0.00722505,-0.0062739453,-0.006039047,-0.0074301073}, {5,7,0,2,4,2,5,4,3,7,5,0,255,4,4,5,5,5,7,2,0,7,0,255,255,3,0,4,2,4,0,4,4,4,4,0,4,7,0,3,3,2,7,3,5,255,5,255,4,0,3,4,2,2,4,2,4,5,2,4,5,255,255,4,2,0,0,5,5,2,7,4,7,2,2,0,3,4,3,3,7,7,0,4,2,0,7,0,5,255,2,255,4,0,255,255,2,7,5,3,2,7,255,0,0,0,4,4,0,3,5,7,2,2,4,3,4,0,255,255,255,5,2,2,2,3,7,3,3,3,2,5,7,0,7,2,3,255,0,2,0,2,4,2,4,255,255,255,255,5,0,4,2,2,7,0,4,3,255,3,5,255,7,7,7,255,255,4,255,2,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,65535,65535,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,65535,65535,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,65535,165,65535,167,169,65535,65535,171,173,175,177,179,181,65535,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,65535,65535,65535,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,65535,245,247,249,251,253,255,257,65535,65535,65535,65535,259,261,263,265,267,269,271,273,275,65535,277,279,65535,281,283,285,65535,65535,287,65535,289,291,293,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,65535,65535,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,65535,65535,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,65535,166,65535,168,170,65535,65535,172,174,176,178,180,182,65535,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,65535,65535,65535,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,65535,246,248,250,252,254,256,258,65535,65535,65535,65535,260,262,264,266,268,270,272,274,276,65535,278,280,65535,282,284,286,65535,65535,288,65535,290,292,294,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,7054,31028.5,34.5,3376,6902,13759.5,24233,463.5,4499,11714.5,8122,31340.5,11094,22497,30,30579.5,93,985.5,13626,-0.059180167,9927.5,8588,5969,7702,10301,26740,31898,27810,19252.5,28007.5,3252,868,-0.027211314,25705.5,44,550.5,76,1710.5,2170.5,3203.5,9623.5,7091,15011.5,30411,5670.5,3097.5,25596,-0.0027730041,14668.5,12862,29743.5,31956,-0.024868287,-0.03517824,-0.021943549,-0.028534133,20395,32071.5,25574.5,31580.5,22,0.009691882,625.5,22.5,-0.011223319,-0.017716361,67.5,68,411,1904.5,-0.04536405,3342.5,1184.5,2425.5,3166.5,7767,-0.035117973,-0.04150772,4575,10175.5,10532.5,19680,13245,14028,13289.5,-0.035334755,-0.0072008385,-0.015624351,1352,5094,3172.5,30804.5,6858,13723.5,7723,10692.5,24367.5,-0.00023458998,26897.5,30019,18133,20971,20003,15889.5,18952,-0.020739784,-0.0047038817,29556.5,22,22,27,-0.027255772,0.035131987,87.5,71.5,31,33,111.5,127,668.5,769,7992.5,1275,3829.5,1249.5,777,2435.5,4240.5,8115.5,-0.052209314,2027.5,9188,8991,9686,9690,11764,0.011025392,10954.5,11279.5,-0.02362179,13746.5,14124,-0.04081526,27277,8749,13280.5,-0.00023188426,-0.00728627,7801,7354,0.005666448,24106.5,3255.5,3216.5,8490.5,10291,5243.5,9242,7198.5,10734,9054,13119.5,17170.5,24735,-0.009165398,-0.007022358,29384.5,29885.5,18690,19292,30447.5,-0.03342035,31491,-0.0154407965,-0.021340339,21823.5,-0.007854561,24047.5,30437,30602,-0.008908126,0.0033835873,-0.0052004643,-0.002941016,0.007022664,1.2208434e-05,-0.0012660816,0.0088530285,-0.011263671,-0.04216053,-0.043335035,-0.018772008,-0.0011321595,-0.008851244,0.024313053,0.0031437867,-0.035379596,0.0063089603,-0.03624803,-0.046651024,-0.002057132,0.014859318,-0.02805981,0.010523388,0.001940788,0.01529277,-0.039380558,-0.0037510693,-0.020803569,0.007366357,-0.05269993,-0.025249327,0.012127478,-0.0027158856,-0.017013915,-0.009102682,-0.031859256,-0.034087222,-0.033187665,-0.014893559,-0.03548831,-0.03071382,-0.019662982,-0.04032062,-0.010943225,-0.022285752,-0.0323848,-0.023670306,-0.018230101,-0.03004995,0.0040658135,0.001094324,-0.008190057,-0.012264755,-0.028400091,-0.01785486,-0.019779606,-0.025043845,-0.030311674,-0.034593035,-0.017316885,-0.02182555,-0.010493766,0.0015491669,0.013459741,0.007256581,-0.0058045886,0.0056561213,0.012140441,0.016904825,0.018941646,0.025176246,0.012171078,0.019888684,-0.022517825,-0.0036799777,-0.0040356047,0.020006748,-0.027985549,-0.019531913,-0.012288083,-0.020619689,-0.016445499,-0.0045644734,-0.013246606,-0.025922263,-0.02510646,-0.015928583,-0.0074501536,-0.0140842935,-0.002658518,-0.004321316,-0.0051861005,-0.0046389718,-0.005230896,-0.0058886628,-0.0055955797,-0.0049397238,-0.020321002,-0.01799789,-0.01774682,-0.016164811,-0.024476701,-0.012639441,-0.019919883,-0.017530877,-0.014925912,-0.019947816,-0.012859757,-0.012123024,-0.006713482,-0.0031819784,-0.007263075,-0.008951529}, {7,6,2,6,7,6,1,0,5,5,6,7,1,7,1,2,1,2,6,6,255,1,5,6,0,0,6,0,0,7,1,5,1,255,0,7,7,6,5,1,5,0,2,6,0,2,0,5,255,6,6,0,7,255,255,255,255,5,0,1,0,0,255,0,5,255,255,0,1,6,6,255,0,0,0,5,6,255,255,1,0,0,1,2,0,6,255,255,255,0,0,6,1,2,5,5,1,6,255,7,2,1,1,5,5,6,255,255,5,2,5,1,255,255,5,6,7,0,1,7,6,1,0,1,1,7,7,6,1,6,255,7,0,0,2,0,2,255,0,0,255,0,6,255,2,1,5,255,255,7,7,255,1,2,2,7,0,0,0,5,0,7,1,0,2,255,255,2,6,7,5,0,255,0,255,255,5,255,5,1,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,49,51,53,55,57,59,61,63,65535,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,93,95,97,99,65535,65535,65535,65535,101,103,105,107,109,65535,111,113,65535,65535,115,117,119,121,65535,123,125,127,129,131,65535,65535,133,135,137,139,141,143,145,65535,65535,65535,147,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,65535,65535,179,181,183,185,65535,65535,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,223,225,227,229,65535,231,233,65535,235,237,65535,239,241,243,65535,65535,245,247,65535,249,251,253,255,257,259,261,263,265,267,269,271,273,65535,65535,275,277,279,281,283,65535,285,65535,65535,287,65535,289,291,293,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,50,52,54,56,58,60,62,64,65535,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,94,96,98,100,65535,65535,65535,65535,102,104,106,108,110,65535,112,114,65535,65535,116,118,120,122,65535,124,126,128,130,132,65535,65535,134,136,138,140,142,144,146,65535,65535,65535,148,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,65535,65535,180,182,184,186,65535,65535,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,224,226,228,230,65535,232,234,65535,236,238,65535,240,242,244,65535,65535,246,248,65535,250,252,254,256,258,260,262,264,266,268,270,272,274,65535,65535,276,278,280,282,284,65535,286,65535,65535,288,65535,290,292,294,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,7071,31028.5,15.5,3566.5,6902,13759.5,2119.5,3641.5,18.5,11714.5,8017,31340.5,12.5,5.5,94.5,3996,722.5,2284,15.5,9794,6397,6.5,5969,14.5,10466.5,22154.5,11094,17491.5,1.5,22497,49.5,2421,2236,3759.5,683.5,726.5,1452,5814,2490.5,9855,3244.5,12417.5,8739.5,9684.5,6220,5772.5,11,6519,8134,6506.5,7054.5,5962,20.5,28814,31959,7.5,11206.5,-0.023053778,19237,19783.5,12.5,28007.5,38.5,53,1363,5906.5,2249.5,2175.5,6839,6403,32.5,1675.5,0.07463705,18.5,7100.5,1752,6865,6301.5,7.5,11.5,2168.5,-0.03055024,2168.5,3302,-0.036779534,-0.02554929,4109.5,4529.5,9296,7.5,14643,7351.5,6530,11917.5,7409.5,-0.021121403,15.5,7985.5,11.5,-0.003740398,18.5,9667.5,8510.5,8162.5,10343,28700,20553.5,-0.009445218,17.5,29709,-0.018954543,-0.027298404,31589.5,-0.022940265,-0.035936438,-0.03165953,19519.5,18806.5,2.5,2.5,19133.5,22245.5,8.5,31827,38,29,-0.041928355,52.5,933.5,6.5,2883,1364.5,1.5,2388,6.5,2490.5,4.5,-0.010948791,7319.5,9160,240,201.5,742,2668,1444,3861,-0.045316245,-0.030801136,1657.5,-0.018371241,1566.5,11210.5,7645.5,9160,9803.5,9855,2449.5,9831,8443.5,17.5,8443.5,7875,-0.02204222,-0.015231867,14.5,7044,12.5,5495.5,10451.5,9616.5,10659,9548.5,5876.5,4908.5,5464.5,6856.5,12.5,10578,15731,28318,0.0011434675,-0.003010823,4.5,7216.5,5.5,6.5,30719.5,13404.5,0.022872234,14564,8092.5,-0.00082553126,9151,8620.5,8327,9997,7.5,1.5,18999.5,17330,16.5,16,24733,24819,29678.5,29712.5,-0.011852566,2.5,17186,-0.0040127584,-0.005286562,19891.5,19390,18315,29570,29831,14783.5,8.5,19133.5,-0.03305384,-0.0107348375,25574.5,29570,-0.003946908,-0.004619469,-0.04455654,-0.0043132617,0.008169461,-0.012747715,-0.004869819,-0.025556216,0.0070654578,-0.021487808,-0.04196413,0.0071884813,-0.0058162245,-0.014951154,-0.030998975,0.007717032,-0.0036890313,-0.032927148,-0.006319797,0.0065750317,0.012041312,-0.009265486,-0.0006271337,-0.018384619,-0.025291784,-0.007223493,-0.012991443,-0.025016902,-0.0016189478,-0.00076099887,0.02686373,-0.011148045,-0.0013177518,-0.029802749,-0.0033520206,-0.057513725,-0.035340205,-0.006347137,0.0027111657,0.01570974,-0.0014007387,-0.023559682,-0.032932557,0.013347584,-0.010103335,0.0021244,-0.008063819,-0.013451946,-0.0069794967,-0.027315766,-0.005784816,-0.03604283,-0.022281958,-0.025365997,-0.034575943,-0.031590097,-0.022506138,-0.025971016,-0.035429083,-0.021817785,-0.035681076,-0.02069945,-0.014747545,-0.02956149,-0.040157612,-0.02055719,-0.027877629,-0.022154795,-0.011172403,-0.012617156,0.004129355,-0.023614591,-0.04134974,-0.013453334,-0.02234688,-0.020472033,0.000639897,0.017142868,-0.008504409,-0.018503914,-0.0045756097,-0.020989357,-0.010759598,-0.005689826,-0.015905783,-0.018354058,-0.008914339,-0.016147114,-0.025094235,-0.010795756,-0.017240912,-0.02776421,-0.036842644,-0.017893655,-0.024697755,-0.022458171,-0.02822778,-0.0076894634,-0.021371393,0.009153747,0.00061027816,0.016401378,0.0018623812,-0.0047739833,-0.010005859,0.010523667,0.00019256125,0.007935194,0.0044258377,-0.0005209831,0.015995098,0.020929253,0.032924097,0.011979916,0.007592145,-0.022702543,0.004456108,-0.0012674184,-0.012344993,0.003527979,-0.007797245,-0.012685398,-0.0027302492,-0.013520342,-0.022181729,0.009116924,-0.0045239,-0.012700075,-0.019265106,-0.022346772,-0.004685498,-0.002223634,-0.0046170927,-0.00017101351,-0.00096617825,-0.003101118,-0.0041981307,-0.007140573,-0.0048650685,-0.005389058,-0.0075608487,-0.003769227,-0.0050405427,-0.01481803,-0.019621463,-0.005074063,-0.006971893,0.0018737655,-0.0018365899,-0.010147054,-0.0059311977,-0.013469969,-0.0115357125,-0.005562627,-0.0024261929,-0.008739472,-0.0049250363,-0.019854002,-0.01583876,-0.012337189,-0.014574848,-0.01901115,-0.017072285,-0.013162448,-0.018960446,-0.009375819,-0.007275825}, {7,6,2,8,7,6,1,1,2,8,6,7,1,8,8,2,2,3,3,8,2,1,8,6,8,6,6,7,3,8,1,2,7,3,3,2,3,7,6,1,2,7,1,6,2,7,3,8,6,2,2,3,1,8,6,2,8,3,255,1,3,8,1,3,2,6,6,2,2,6,7,6,2,255,8,2,7,1,7,8,8,7,255,7,3,255,255,3,7,6,8,6,3,7,1,1,255,8,1,8,255,8,1,7,2,7,2,6,255,8,2,255,255,2,255,255,255,3,7,8,8,1,1,8,1,2,1,255,3,7,8,6,3,8,7,8,3,8,255,2,1,1,3,1,2,1,1,255,255,7,255,1,1,1,1,6,2,3,2,6,8,6,6,255,255,8,7,8,1,1,6,6,1,7,1,1,7,8,2,6,2,255,255,8,1,8,8,1,1,255,7,1,255,1,6,6,3,8,8,3,3,8,8,6,2,2,2,255,8,1,255,255,1,3,1,1,1,7,8,1,255,255,1,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,141,143,65535,145,147,149,151,153,155,157,159,65535,161,163,65535,65535,165,167,169,171,173,175,177,179,181,65535,183,185,187,65535,189,191,193,195,197,199,201,65535,203,205,65535,65535,207,65535,65535,65535,209,211,213,215,217,219,221,223,225,227,65535,229,231,233,235,237,239,241,243,245,247,65535,249,251,253,255,257,259,261,263,65535,65535,265,65535,267,269,271,273,275,277,279,281,283,285,287,289,65535,65535,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,65535,65535,323,325,327,329,331,333,65535,335,337,65535,339,341,343,345,347,349,351,353,355,357,359,361,363,365,65535,367,369,65535,65535,371,373,375,377,379,381,383,385,65535,65535,387,389,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,142,144,65535,146,148,150,152,154,156,158,160,65535,162,164,65535,65535,166,168,170,172,174,176,178,180,182,65535,184,186,188,65535,190,192,194,196,198,200,202,65535,204,206,65535,65535,208,65535,65535,65535,210,212,214,216,218,220,222,224,226,228,65535,230,232,234,236,238,240,242,244,246,248,65535,250,252,254,256,258,260,262,264,65535,65535,266,65535,268,270,272,274,276,278,280,282,284,286,288,290,65535,65535,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,65535,65535,324,326,328,330,332,334,65535,336,338,65535,340,342,344,346,348,350,352,354,356,358,360,362,364,366,65535,368,370,65535,65535,372,374,376,378,380,382,384,386,65535,65535,388,390,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30452.5,3768,9989,4208,9743.5,14.5,32366,17.5,3635.5,7690.5,9706,8.5,18.5,26610.5,25939.5,2370.5,409.5,3256.5,6265,4799,10301,17232,15214.5,3178.5,29881.5,0.020999702,0.029229289,5.5,3.5,17.5,4.5,102.5,7402.5,457.5,3325,6.5,7030,12.5,4180.5,4933.5,7394,3294.5,10614.5,7.5,9322.5,13556,11.5,0.0018885707,3216,0.008528842,3001.5,-0.012638685,17.5,1.5,29722.5,21629,21629,29110,29713,83.5,118.5,2554.5,7526,150,793,2826,1654,-0.025980998,-0.045322143,1905.5,18.5,3251,4052.5,1564.5,15.5,4007.5,16.5,6078,5148,14.5,7743.5,9797.5,10630.5,10645.5,11609,0.014643537,12.5,10900.5,1.5,16661,12572,0.010286766,3247,0.016656589,0.011492453,-0.021905383,-0.015269491,30481.5,29744,5.5,29844,20364.5,24697,20364.5,24758,1.5,2.5,29660.5,29745.5,51.5,92.5,29.5,293,2416,4869.5,4013,9500.5,137.5,209.5,21.5,-0.030259624,18.5,5040,2262,3151,6.5,14.5,17.5,9741.5,4.5,4.5,3948,4507.5,-0.036295652,4381.5,4,11372,18.5,4081,7247.5,5260,5574.5,7208,17.5,5536.5,3146,18.5,8610.5,9000,8.5,11336.5,3.5,11828.5,4.5,11609,8603.5,9380,0.0050503695,-0.00091856794,10977,14274,0.015366033,11776.5,1.5,2.5,30133.5,16661,28687.5,0.007040364,0.0041570584,0.00086578884,-0.0045852144,29774.5,-0.0065587754,-0.010391692,-0.010573808,5.5,17170.5,15,21044.5,24702,-0.0030996639,-0.012700562,24761.5,24867,28073,-0.004110964,30000.5,29902,29695.5,29735.5,29619.5,30000.5,-0.0024653797,-0.010386003,0.021316482,0.04108467,0.017937226,-0.031562753,0.008132423,-0.019257432,-0.00030702524,0.008169488,-0.010820071,0.0013092979,-0.0261337,-0.019348668,0.0015228585,-0.016554268,-0.004325153,-0.025154386,0.059458967,0.0035697003,-0.0241291,-0.016094634,-0.0030783897,0.015899282,-0.011731456,-0.0037595516,-0.028042337,-0.049040698,0.0014867352,-0.01497463,-0.01783946,-0.029339751,-0.02127344,-0.012913302,-0.02550125,-0.018171674,-0.024921428,-0.03311148,-0.017825697,-0.028181732,-0.012178088,-0.018626807,-0.009831245,-0.020991685,-0.0024453115,-0.011360998,-0.025346508,-0.017316561,-0.0073700375,-0.014744068,-0.0039023315,-0.028731389,-0.003112801,0.0072191767,-0.023632083,-0.010954443,0.009731343,0.0006563984,0.043371726,0.0140964305,-0.006982803,-0.0146029135,-0.013175181,-0.0305796,0.0031478845,0.033409618,-0.0010204522,-0.009246579,0.004851788,0.012695429,0.019960077,0.028476043,0.012783765,-0.004818793,-0.007827831,-0.0027482267,-0.025143458,-0.014471339,-0.0031291917,-0.008757711,-0.021748792,-0.03618852,-0.00036680253,-0.014831379,-0.0262624,-0.009815457,-0.0071265483,-0.016620291,-0.018649431,-0.010018609,-0.02470835,-0.016181072,-0.0052600102,-0.011506311,-0.0039674556,0.0031330788,-0.012376295,-0.02406839,0.0070475005,-0.02843444,-0.0054964507,-0.010619136,-0.019181723,-0.030118812,-0.032599654,-0.014097258,-0.00017825814,0.004900529,0.00039492684,-0.0017227154,-0.0050034556,-0.007441412,-0.0019695822,-0.0028752084,-0.00018574492,-0.0009923546,-0.005194433,-0.0022981113,-0.0028547521,-0.0035716032,-0.00736603,-0.0054407916,-0.0049862633,-0.0037816395,-0.0016759742,-0.0035006267,-0.006039091,-0.0050173537,-0.0053314827,-0.004437993,-0.00458103,-0.0036130608,-0.0068544927,-0.0042885276,-0.0025923445,-0.003580747,-0.004757732,-0.0040503046}, {5,5,0,4,4,8,5,8,3,3,5,8,8,4,4,3,1,0,4,0,0,3,0,4,3,255,255,8,8,8,8,0,0,0,0,8,4,8,1,1,1,0,1,8,1,3,8,255,4,255,0,255,8,8,4,4,4,0,0,1,1,4,1,1,4,3,1,255,255,5,8,1,3,1,8,0,8,0,4,8,3,1,3,4,0,255,8,1,8,4,5,255,4,255,255,255,255,1,0,8,3,4,4,4,0,8,8,0,0,0,0,4,0,5,3,1,0,0,0,8,255,8,3,4,4,8,8,8,4,8,8,3,3,255,3,8,0,8,0,4,4,5,3,8,3,0,8,5,3,8,0,8,0,8,0,5,3,255,255,4,4,255,0,8,8,4,4,3,255,255,255,255,4,255,255,255,8,0,8,0,0,255,255,4,4,4,255,0,4,4,4,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,65535,91,65535,93,65535,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,65535,65535,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,157,159,161,163,165,65535,167,65535,65535,65535,65535,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,65535,215,217,219,221,223,225,227,229,231,233,235,237,65535,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,65535,65535,285,287,65535,289,291,293,295,297,299,65535,65535,65535,65535,301,65535,65535,65535,303,305,307,309,311,65535,65535,313,315,317,65535,319,321,323,325,327,329,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,65535,92,65535,94,65535,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,65535,65535,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,158,160,162,164,166,65535,168,65535,65535,65535,65535,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,65535,216,218,220,222,224,226,228,230,232,234,236,238,65535,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,65535,65535,286,288,65535,290,292,294,296,298,300,65535,65535,65535,65535,302,65535,65535,65535,304,306,308,310,312,65535,65535,314,316,318,65535,320,322,324,326,328,330,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27582.5,3345.5,9989,3849,9691.5,30719.5,31378.5,1444,3425,6872.5,11004.5,2914,3178.5,28552.5,25435.5,1801,2137.5,1253,1693.5,6189,6505.5,17005,10624.5,2752.5,0.02103894,30444.5,3292.5,31068.5,25702.5,24137,30228.5,104.5,1526.5,1538.5,2399.5,2210,13633,-0.04135248,9852,4885,9419.5,5251.5,10006.5,15217.5,29146.5,12213.5,13837,0.016706184,29813,0.007833036,0.004683887,0.0129799945,0.007991127,25771.5,30177,0.015574618,30278,24494,24983,26896,29542,31.5,239.5,2943,-0.003111491,1211,2270.5,10345.5,6773.5,1546.5,-0.013081155,2869,3203.5,9068,10386.5,1621.5,4551.5,4603.5,6686.5,2397.5,7056.5,8185,10907.5,8176,11663,20321,8830.5,11769,6272,10798.5,21082,0.008049983,0.011351492,25572.5,27385,-0.016635185,26604.5,29826,30561.5,17170.5,-0.0010741506,24148.5,-0.003157949,-0.000605039,31521,-0.0021019084,30334.5,129,121.5,228.5,522.5,1649,894,788.5,0.024146019,8882.5,3151.5,2461,2463.5,3282.5,-0.045150585,-0.04580942,-0.033494603,3266.5,8586.5,-0.025886485,-0.032280177,6663.5,6275.5,-0.046423383,-0.016872669,1214,4582.5,4173,5891.5,8853,5697.5,0.025237951,0.0033851345,0.00045446932,5585,6921.5,5897,7398,8210.5,10796.5,10034,11624,8350.5,18873.5,15925,0.016855527,9797,0.002969724,-0.007539065,10963.5,10384,6406.5,11451,11573,13813.5,18167,19308.5,-0.021633413,-0.011777907,29311,-0.032430004,-0.012387703,-0.008037864,29189.5,30234,30564,29752,-0.0018200678,21629,-0.0024257228,24753.5,29749.5,29650.5,29859.5,30054.5,-0.00566078,-0.02846062,-0.0008024857,0.00996511,-0.015887033,-0.031818345,0.0061377627,-0.0113984635,-0.03771698,-0.06912688,0.012053947,-0.053994495,0.021281017,0.004225961,0.00023110355,-0.019238688,0.012526055,0.00017202638,-0.019321559,-0.0137112755,-0.0017891147,0.00031416767,0.002693679,-0.0074357027,-0.023137644,-0.04066206,-0.01320093,-0.020775553,-0.019202977,-0.014438544,-0.0026839427,-0.01016591,-0.0034684383,0.016897248,-0.0054797437,0.0048425104,-0.0024248923,0.01394659,-0.009956052,-0.004347483,-0.014823933,-0.027738517,-0.009215378,-0.015020548,0.022341602,0.011578723,0.012010808,-0.00095753296,-0.0027212405,0.0017494882,-0.012974854,-0.0026919523,-0.0057621463,-0.019731626,-0.009648949,-0.0015616798,0.008644129,-0.0013012359,-0.015668822,-0.020900792,0.02011167,-0.008433534,-0.017839024,-0.024819938,-0.037072055,-0.011350828,0.0002872958,0.006043693,0.0127246445,-0.0016773485,-0.0023886305,0.0015321792,-0.0035838229,0.00081752305,-0.0034749836,-0.014398823,-0.00033328365,-0.013834782,-0.025744,-0.01596971,-0.0025982775,-0.024094058,-0.013395309,-0.009518341,-0.026880482,-0.019230356,-0.005931368,-0.0038420379,3.1922176e-05,-0.0038282431,-0.005185316,-0.0038562242,-0.008400596,-0.006467357,-0.0025437,-0.003155239,-0.003727248,-0.003462591,-0.011164425,-0.00587858,-0.00391277,-0.0043329555,-0.004748591,-0.0032908083,-0.0028866946,-0.0034314007}, {3,1,0,0,2,1,1,5,5,1,3,0,4,2,0,4,0,5,1,0,0,5,4,0,255,5,0,5,0,4,4,4,1,4,1,1,0,255,4,0,3,4,5,2,4,2,2,255,5,255,255,255,255,4,3,255,5,2,0,5,2,5,5,2,255,3,1,2,4,1,255,1,5,4,4,4,2,1,1,4,1,2,1,3,5,5,3,3,0,1,4,255,255,2,4,255,4,2,5,0,255,2,255,255,3,255,4,2,1,0,4,2,1,2,255,4,1,2,0,0,255,255,255,5,0,255,255,4,2,255,255,5,2,3,2,0,3,255,255,255,3,2,0,1,3,3,5,0,3,2,2,255,1,255,255,2,0,4,3,5,3,5,5,255,255,3,255,255,255,3,3,1,0,255,4,255,4,0,4,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,77,79,81,83,85,87,89,65535,91,65535,65535,65535,65535,93,95,65535,97,99,101,103,105,107,109,111,65535,113,115,117,119,121,65535,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,65535,163,165,65535,167,169,171,173,65535,175,65535,65535,177,65535,179,181,183,185,187,189,191,193,65535,195,197,199,201,203,65535,65535,65535,205,207,65535,65535,209,211,65535,65535,213,215,217,219,221,223,65535,65535,65535,225,227,229,231,233,235,237,239,241,243,245,65535,247,65535,65535,249,251,253,255,257,259,261,263,65535,65535,265,65535,65535,65535,267,269,271,273,65535,275,65535,277,279,281,283,285,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,78,80,82,84,86,88,90,65535,92,65535,65535,65535,65535,94,96,65535,98,100,102,104,106,108,110,112,65535,114,116,118,120,122,65535,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,65535,164,166,65535,168,170,172,174,65535,176,65535,65535,178,65535,180,182,184,186,188,190,192,194,65535,196,198,200,202,204,65535,65535,65535,206,208,65535,65535,210,212,65535,65535,214,216,218,220,222,224,65535,65535,65535,226,228,230,232,234,236,238,240,242,244,246,65535,248,65535,65535,250,252,254,256,258,260,262,264,65535,65535,266,65535,65535,65535,268,270,272,274,65535,276,65535,278,280,282,284,286,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,7054,31028.5,2223,3681.5,6902,14701,2410.5,5723.5,5069,11714.5,3262.5,32366,11094,22585,100.5,1210.5,5449.5,6009,1946,12253.5,6407.5,6255,27148,5969,10544,26740,32013,12581.5,19268.5,29659,28.5,125.5,3644,1489,3803,7969.5,4213.5,10097,3287,7767,-0.010298841,-0.016909376,9014.5,9686,4324.5,12261,2906.5,2864,4276,4051,7054.5,12848,21582.5,30108.5,-0.019976664,-0.024754835,12170.5,-0.02221874,16970,21694.5,24130.5,30273.5,36,76.5,26.5,133.5,1230,0.010979839,7292,2471.5,2129.5,3947,5452,6491,3524.5,6994.5,5446.5,9889,1465.5,-0.03786732,2978,9132.5,4157,4693,9204,10772,12845,6381.5,15733.5,14620.5,2445,0.018652739,-0.0015525847,2873,0.003112532,7290,3501.5,6543,8310.5,7963.5,10335.5,9483,23934.5,25019.5,30326,29817,-0.020328445,-0.017120088,32049.5,20395,18879,20583.5,23579,18974.5,30277,32206,22,61,72.5,103,0.0048940927,1144,137,336,-0.03181398,915,-0.030632436,-0.0223088,-0.04525245,2783.5,1600,2468.5,4373,4237.5,0.025011275,5667.5,5265.5,0.010558931,6392.5,4076.5,9845,6273,4020.5,5415.5,0.0041753585,12527,-0.0272703,-0.022203118,7952,3629.5,2025.5,9855,4109.5,4631,9552.5,5148.5,7321.5,9742,9263,6544.5,-0.0034489334,4055.5,27763,10495.5,12889.5,-0.021584293,-0.007307605,0.0024111948,0.016204096,0.010266435,3115,31728.5,-0.004843757,-0.00805911,2489.5,-0.0049503255,-0.0015849455,7039.5,7011.5,8620.5,8336,8569.5,14491.5,10624.5,21749.5,15405.5,18812,0.0007556819,24711.5,26109,30329,30169.5,30340,29912,18808,17101.5,16762.5,21473.5,17384.5,20728,-0.01066721,-0.015635986,-0.008794937,-0.008286769,-0.0041090706,21161,-0.0022616896,-0.00411709,-0.0029042356,30393,-0.005477175,0.0004566495,-0.034886938,-0.008424371,0.0008094281,-0.014237692,0.008808247,0.02016457,-0.026126055,-0.043823045,0.10025736,0.03052393,-0.018762663,-0.004794813,-0.059667803,-0.043660287,-0.011375984,-0.020145085,-0.002770426,0.008401204,-0.018303296,-0.00025560285,-0.0058070063,-0.015563123,0.00037870108,-0.008104126,-0.0008901893,0.01173171,-0.014068444,-0.03423729,-0.019876776,-0.014014581,-0.010347014,-0.019297106,-0.006814686,0.0016793823,-0.007234869,0.01939294,-0.031972963,-0.0015189117,0.017419579,-0.021003606,0.0013109472,-0.00038880293,-0.0037998117,-0.020624217,-0.019370848,-0.012169881,-0.015663994,-0.02464862,-0.019150179,-0.021753902,-0.01414582,-0.008980061,-0.005344273,-0.009672314,-0.02662603,-0.015318969,-0.009297028,-0.017009668,-0.02150879,-0.008645406,0.012290695,-0.015253245,-0.017230099,-0.009436877,0.0006839239,-0.0101302285,-0.017910542,-0.011388307,-0.022336023,-0.0260856,-0.0134646,-0.019238219,-0.018374596,-0.012107692,0.018255109,0.011098535,0.0069850306,0.012059146,0.0053330297,0.0022307634,0.00888675,0.003734693,-0.018869488,-0.004408758,-0.0013998679,-0.011459961,0.0064153,-0.017955018,-0.012220991,-0.0023310024,-0.0062066684,0.0025378137,-0.0057475953,-0.019604858,-0.023025889,-0.006414301,-0.00428581,-0.008770651,-0.001644147,-0.0024329533,-0.0029597203,-0.0032538474,-0.002882025,-0.0022488409,-0.0038841069,-0.002217965,-0.0019806249,-0.0027298,-0.0038164258,-0.0023319682,-0.0029897587,-0.003257243,-0.02277773,-0.012616019,-0.011381266,-0.014569017,-0.013615404,-0.01160214,-0.015814848,-0.025055686,-0.013877547,-0.0114073865,-0.009385006,-0.010947993,-0.014985466,-0.0074794753,-0.0042334604,-0.006194388}, {7,6,2,5,7,6,3,4,6,3,6,6,5,7,3,6,5,5,7,7,2,7,5,5,6,4,6,4,7,7,7,7,7,6,7,4,2,7,5,5,6,255,255,2,2,7,3,4,4,2,2,3,6,6,2,255,255,3,255,5,5,3,3,6,3,2,7,2,255,4,6,6,5,5,7,7,6,4,4,3,255,7,6,5,3,4,6,4,7,6,3,4,255,255,2,255,3,2,5,7,3,5,7,2,6,4,6,255,255,6,5,3,3,7,6,5,2,4,6,2,5,255,2,6,5,255,3,255,255,255,4,4,7,4,2,255,6,6,255,4,7,5,2,4,5,255,4,255,255,2,7,7,2,3,5,2,7,6,6,3,5,255,5,2,2,4,255,255,255,255,255,4,3,255,255,2,255,255,2,2,6,5,7,2,4,4,6,6,255,2,4,6,6,2,6,3,3,7,3,3,7,255,255,255,255,255,7,255,255,255,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,65535,65535,83,85,87,89,91,93,95,97,99,101,103,105,65535,65535,107,65535,109,111,113,115,117,119,121,123,125,65535,127,129,131,133,135,137,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,165,167,169,65535,65535,171,65535,173,175,177,179,181,183,185,187,189,191,193,65535,65535,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,223,65535,225,65535,65535,65535,227,229,231,233,235,65535,237,239,65535,241,243,245,247,249,251,65535,253,65535,65535,255,257,259,261,263,265,267,269,271,273,275,277,65535,279,281,283,285,65535,65535,65535,65535,65535,287,289,65535,65535,291,65535,65535,293,295,297,299,301,303,305,307,309,311,65535,313,315,317,319,321,323,325,327,329,331,333,335,65535,65535,65535,65535,65535,337,65535,65535,65535,339,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,65535,65535,84,86,88,90,92,94,96,98,100,102,104,106,65535,65535,108,65535,110,112,114,116,118,120,122,124,126,65535,128,130,132,134,136,138,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,166,168,170,65535,65535,172,65535,174,176,178,180,182,184,186,188,190,192,194,65535,65535,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,224,65535,226,65535,65535,65535,228,230,232,234,236,65535,238,240,65535,242,244,246,248,250,252,65535,254,65535,65535,256,258,260,262,264,266,268,270,272,274,276,278,65535,280,282,284,286,65535,65535,65535,65535,65535,288,290,65535,65535,292,65535,65535,294,296,298,300,302,304,306,308,310,312,65535,314,316,318,320,322,324,326,328,330,332,334,336,65535,65535,65535,65535,65535,338,65535,65535,65535,340,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,6294.5,31028.5,1444,3683,6902,14701,94.5,2085,3376,9686,3576,32366,11094,22585,44,129,504.5,5998,4499,3652,7034.5,11740.5,20918,5969,10301,26740,32059.5,12628,30278,29659,48,42,106.5,516.5,5191,1061.5,2119.5,5850,13626,-0.044719312,6837.5,11419,9015.5,5493,10416.5,12261,3203,2723.5,15718,6825.5,7274,12862,19784,30210,-0.017570823,-0.022357225,-0.017345656,-0.020204974,16967,19294,18952,30277,30,128,33,57,61,74.5,205,530,1623,109,1585,1153,1553,1835.5,8079.5,6827,2614.5,3203.5,6437,3638,-0.027426505,-0.018498825,7001.5,10510,6414.5,9027,5100.5,11801,11331.5,29728,3163.5,0.014361503,0.018199382,3262.5,5595,-0.00886905,6486.5,7270,5051.5,8075,9425,10956,0.00052380847,24367.5,29720.5,30063.5,-0.017035058,17036.5,16762.5,21823.5,-0.003705776,20993,30273.5,30924.5,28.5,43.5,28.5,-0.028064812,47.5,36.5,69,79,78,330.5,173.5,26.5,127.5,268.5,1164.5,1268.5,0.016852021,5971.5,-0.038015243,-0.02073142,1012,0.030245563,3307.5,1941.5,2554.5,2544.5,1696,5637,5819.5,6040,5874.5,6958.5,10872.5,8001.5,-0.021104679,-0.026582045,-0.008496287,7274.5,4751,-0.0091482,4628.5,0.011861621,10538,6608,0.012986109,0.0014076978,10704.5,8862.5,4473,9624.5,11136,6539.5,8030,15046.5,14620.5,5154.5,2509,0.0034295113,3232.5,0.005934112,-0.003338917,-0.0018391755,0.002134545,-0.00567962,6765.5,7550,3187,8920,7619,7611.5,10447.5,12156,14915.5,12838,17170.5,25019.5,29654.5,29744.5,30058.5,29907,-0.013916162,26417.5,-0.0123302555,14095.5,19021,22365,-0.012511599,31997.5,30105,30289,30405,31465,-0.005816773,-0.0029227284,0.006031,-0.0054023676,-0.008179381,0.0005255181,-0.0069770734,0.0016479762,-0.02023695,-0.002173635,0.0027648748,0.0099323755,0.00039700355,-0.009413639,-0.031495985,-0.021532452,0.035764158,-0.0008918137,-0.02061591,0.0017273711,0.010468751,-0.026552228,0.0020415033,0.050756004,-0.01166778,0.004746539,-0.028967483,-0.048708346,0.00078764325,-0.0199631,-0.0018512876,0.005185402,0.015944203,-0.0113867875,-0.007860022,0.004312006,0.021340264,0.006951695,0.0007980399,0.019149978,-0.008491169,0.0031394444,-0.022974672,-0.012053233,-0.006923891,-0.013800661,0.0013786528,0.021014674,-0.0014895406,-0.012497154,-0.00088727253,-0.022687161,0.023100374,-0.006887504,-0.018871939,-0.024190491,-0.007780666,-0.018440528,-0.0131082265,-0.009486639,-0.016996322,-0.013330459,-0.012786579,-0.008653885,0.009542171,0.0058139423,0.0012041557,0.00025962963,-0.027684892,-0.013008396,-0.006982227,-0.022400254,-0.01833273,-0.009257956,-0.01873838,-0.014706181,-0.009537145,-0.0031823309,-0.01846469,-0.009493798,-0.011916219,-0.023380442,-0.014693903,-0.018561801,-0.006560474,8.587466e-05,-0.008690752,-0.017084092,0.004960918,0.008074208,0.011270912,0.016206872,0.009078103,0.0062245615,0.0034029929,0.002610023,0.013156503,-0.003698691,-0.013443219,-0.0026739691,-0.024544796,0.009503505,-0.030777296,-0.0025694924,-0.029343938,-0.0071337516,-0.024667598,-0.012720197,-0.0045174877,-0.013608436,-0.0016469889,-0.0077640647,-0.0014613225,-0.0023161143,-0.0029260942,-0.002495391,-0.0032852807,-0.0041038897,-0.0025222907,-0.0033839957,-0.0016577918,-0.0022752953,-0.0022799799,-0.0029933464,-0.015937496,-0.011848439,-0.013366833,-0.010525321,-0.009997068,-0.008498591,-0.014640316,-0.024131663,-0.011581677,-0.007363714,-0.001117355,-0.0022153442,-0.0048093568,-0.0030298398,-0.003940183,-0.005402615,-0.0026351225,-0.0036078126}, {7,6,2,5,7,6,3,2,0,7,2,2,5,7,3,7,3,0,5,5,7,3,0,7,6,0,6,0,7,0,7,0,0,0,2,6,2,6,6,6,255,6,0,5,5,0,3,2,6,0,5,3,6,3,0,255,255,255,255,7,3,6,5,2,6,0,2,3,3,0,3,5,0,7,0,5,5,5,0,3,5,6,7,255,255,3,5,0,2,5,6,6,0,2,255,255,6,0,255,6,0,2,7,3,3,255,6,6,2,255,5,7,5,255,7,3,7,0,2,7,255,6,0,0,0,0,6,6,6,0,3,0,6,255,5,255,255,0,255,5,3,0,5,7,5,6,2,7,0,0,2,255,255,255,2,3,255,7,255,0,6,255,255,0,3,3,6,6,5,6,6,3,7,6,255,6,255,255,255,255,255,6,2,5,0,6,3,0,3,2,3,0,6,6,6,6,6,255,0,255,5,5,3,255,0,3,3,3,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,65535,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,65535,65535,65535,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,65535,157,159,161,163,165,167,169,171,173,65535,65535,175,177,65535,179,181,183,185,187,189,65535,191,193,195,65535,197,199,201,65535,203,205,207,209,211,213,65535,215,217,219,221,223,225,227,229,231,233,235,237,65535,239,65535,65535,241,65535,243,245,247,249,251,253,255,257,259,261,263,265,65535,65535,65535,267,269,65535,271,65535,273,275,65535,65535,277,279,281,283,285,287,289,291,293,295,297,65535,299,65535,65535,65535,65535,65535,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,65535,333,65535,335,337,339,65535,341,343,345,347,349,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,65535,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,65535,65535,65535,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,65535,158,160,162,164,166,168,170,172,174,65535,65535,176,178,65535,180,182,184,186,188,190,65535,192,194,196,65535,198,200,202,65535,204,206,208,210,212,214,65535,216,218,220,222,224,226,228,230,232,234,236,238,65535,240,65535,65535,242,65535,244,246,248,250,252,254,256,258,260,262,264,266,65535,65535,65535,268,270,65535,272,65535,274,276,65535,65535,278,280,282,284,286,288,290,292,294,296,298,65535,300,65535,65535,65535,65535,65535,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,65535,334,65535,336,338,340,65535,342,344,346,348,350,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7315,6294.5,31340.5,15.5,3683,8068.5,7.5,2359,3706,18.5,6.5,8098,10995.5,18100.5,16970,107.5,5797,722.5,4456.5,15.5,9803.5,4037.5,11300.5,7019.5,8309,5732.5,10544,16286,2.5,14.5,22498.5,52.5,6463,3.5,6925,520.5,669.5,4157.5,6808.5,2558,9740,3244.5,-0.02365902,803,6301.5,7034.5,5806.5,5913.5,9169,9378.5,16.5,5372.5,7954,17.5,31197.5,31853,16987,1.5,19703,11239.5,19122.5,16.5,27643.5,49.5,100,1168.5,2410,4789.5,4512,3328.5,6092.5,129,1036,18.5,1463.5,5132,6959,5588.5,0.020695983,7.5,4.5,17.5,3368,9103.5,6817.5,0.0015973687,2489.5,6517,4.5,9579.5,5365,12.5,13.5,5679,7374.5,9641,6986,9846,8454.5,4.5,8610.5,4262.5,5456.5,10454.5,7733.5,4.5,6406.5,1.5,17.5,4.5,12968.5,28777,1.5,19266.5,19700,4.5,4.5,-0.018692972,12581.5,-0.022961207,-0.014181013,18622,18490,11.5,29963.5,26.5,94.5,177,0.02763669,432.5,6.5,11632.5,1875.5,4330.5,5531,2725,3255,6159,5975,3.5,0.019315688,33.5,334,1321.5,334.5,2597,637.5,1392.5,1750.5,1886.5,1680.5,4837,9972,5457.5,5608.5,9803.5,9808.5,2010.5,8.5,3244.5,9166,-0.019217566,-0.015327497,8531.5,-0.01537845,5590.5,6585.5,-0.024264315,6806.5,5473.5,5674,10378.5,9207.5,9568.5,11092.5,5432.5,7394,5079,6411,6404.5,5702,4403,5415,-0.0031845707,7022.5,4.5,15.5,-0.014747905,9785,8548,-0.015345233,7043.5,-0.01629306,8652.5,8610.5,0.003615999,0.00083585485,4394.5,7940,7385.5,7115,7880.5,0.022013554,9060.5,15708,2.5,15.5,2365.5,7440,11537.5,13571,24534.5,24719.5,2.5,5.5,2.5,-0.020767005,-0.012983317,2.5,17892.5,4.5,32238,22398.5,19794.5,21395,19358,19572.5,29899.5,29674.5,12170.5,19122.5,23563.5,12.5,-0.0139204115,19294,23786,23948,29566,30605,-0.004759347,0.0003478806,-0.007101472,-0.033028018,0.0034649696,-0.006543243,-0.018351106,-9.4564995e-05,-0.010858532,-0.026499657,-0.002005357,-0.01485639,-0.019364286,-0.010086962,0.0010561267,-0.008661977,0.0071036564,-0.0017504782,0.0050599384,-0.0018667107,-0.009609258,-0.004323615,-0.028972402,-0.018200217,-0.00694675,-0.015059327,0.006770361,0.0009445624,0.0028444442,-0.005436039,0.01838701,-0.005182437,-0.018306531,-0.005169355,-0.0143811405,-0.042036023,0.005209566,0.014678463,0.042065497,0.09388593,0.0018365793,-0.042517178,0.02257193,0.008018244,-0.02473061,-0.004853088,-0.0041783075,-0.000102662925,0.012776235,0.037251227,0.00022250591,-0.015978342,-0.009450548,-0.024726152,-0.002614976,-0.009453162,-0.023177274,-0.011813401,-0.013764011,-0.02175549,-0.036519196,-0.007471531,-0.014065695,-0.01874294,-0.011625438,-0.0051036156,-0.009107498,-0.0018288158,-0.017307159,-0.024864974,8.692356e-05,-0.0054714694,-0.0021900847,-0.014364056,-0.013195731,-0.008153333,-0.005324959,0.008659624,0.0007302523,-0.020139342,-0.0128578665,-0.005458612,-0.010708275,-0.0013389554,-0.0082816025,0.012338097,-0.012653354,0.0006032589,0.009371272,0.0048245294,-0.022751687,-0.010511172,-0.01402448,-0.022478374,-0.025875492,-0.016274897,-0.008183992,-0.012589692,-0.022114305,-0.0143977525,-0.0013193962,-0.02724727,0.0156484,-0.011901997,-0.016874814,-0.026634647,0.012235055,0.0022199552,0.0066614556,0.017779259,-0.0002475929,-0.0051833205,-0.045681443,-0.030654386,0.0023524065,-0.0029377704,0.001915922,-0.0005639855,-0.0021844942,-0.0061157914,0.0039334674,-0.007857148,-0.024443509,-0.008342125,0.0005821785,-0.009624267,0.029401237,0.006194847,-0.014842756,-0.033588994,0.011531317,-0.010047696,-0.0065410077,-0.011529097,0.0036054314,-5.255097e-05,-0.0037015614,-0.0014448481,-0.0050434074,-0.0022049237,0.010673809,0.002377563,-0.008822869,0.005960371,-0.01599393,-0.006451186,-7.873747e-05,-0.0029563084,-0.00789582,-0.0028008295,-0.0058158413,-0.011664904,-0.00035902235,-0.005229629,-0.0111755,-0.0145066595,-0.006049425,-0.010500225,-0.0022003888,-0.004260956,-0.006628266,-0.008331452,-0.0028767388,-0.0013687795,0.0024356793,0.00065198453,-0.004750533,1.2177967e-05,-0.00066442427,-0.0021327625,-0.006228621,-0.004556068,-0.007729908,-0.006190835,-0.0036923185,-0.00047066598,-0.005663587,-0.0031259449,-0.015520259,-0.011728578,-0.018225675,-0.011864936,-0.010853165,-0.0031884543,-0.008731152,-0.009964938,-0.012416156,-0.011371484,-0.0075462693,-0.006801091,-0.008602849,-0.007717281,-0.00459881,-0.0019200946,-0.0049627377,-0.0042434195}, {7,6,4,8,7,6,8,7,0,8,8,4,3,3,3,0,6,3,6,8,6,3,6,3,7,4,4,3,8,8,7,3,0,8,7,4,6,3,7,3,4,7,255,3,4,3,3,3,0,4,8,3,4,8,3,4,7,8,7,7,7,8,3,0,0,6,6,7,0,3,0,3,0,8,4,4,0,4,255,8,8,8,7,6,0,255,3,7,8,6,4,8,8,0,7,3,6,0,3,8,7,3,4,3,7,8,4,8,8,8,3,0,8,7,7,8,8,255,7,255,255,7,7,8,3,4,4,3,255,3,8,0,7,6,7,6,7,4,7,8,255,4,6,7,7,0,7,4,4,7,7,7,0,4,3,6,0,7,8,7,4,255,255,4,255,0,6,255,4,7,4,0,4,6,6,0,6,3,7,7,7,0,3,255,0,8,8,255,0,4,255,3,255,7,7,255,255,0,0,0,3,3,255,0,4,8,8,4,4,7,4,6,6,8,8,8,255,255,8,3,8,4,3,3,7,3,3,7,7,3,7,3,8,255,3,7,7,3,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,65535,155,157,159,161,163,165,65535,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,65535,229,65535,65535,231,233,235,237,239,241,243,65535,245,247,249,251,253,255,257,259,261,263,265,65535,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,65535,65535,307,65535,309,311,65535,313,315,317,319,321,323,325,327,329,331,333,335,337,339,341,65535,343,345,347,65535,349,351,65535,353,65535,355,357,65535,65535,359,361,363,365,367,65535,369,371,373,375,377,379,381,383,385,387,389,391,393,65535,65535,395,397,399,401,403,405,407,409,411,413,415,417,419,421,423,65535,425,427,429,431,433,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,65535,156,158,160,162,164,166,65535,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,65535,230,65535,65535,232,234,236,238,240,242,244,65535,246,248,250,252,254,256,258,260,262,264,266,65535,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,65535,65535,308,65535,310,312,65535,314,316,318,320,322,324,326,328,330,332,334,336,338,340,342,65535,344,346,348,65535,350,352,65535,354,65535,356,358,65535,65535,360,362,364,366,368,65535,370,372,374,376,378,380,382,384,386,388,390,392,394,65535,65535,396,398,400,402,404,406,408,410,412,414,416,418,420,422,424,65535,426,428,430,432,434,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,7077,31028.5,15.5,4494,5823.5,6.5,2000.5,3744,437,9686,3465.5,31340.5,18950.5,13759.5,1501,3697.5,529,8169,0.0082864715,3546,5392.5,17.5,12.5,6.5,10544,31352.5,13619.5,1.5,13.5,22497,89,6.5,2113,4485.5,457,18.5,5530.5,7751,3.5,8991,5235.5,6783.5,10214.5,9278,695,13599.5,6261,5744,11217.5,28725,0.0046157124,28771.5,31858,1.5,31748,3.5,11186.5,25511,16.5,28007.5,40,457,544,12.5,47,2416.5,3872,7.5,123.5,1046,1555.5,336.5,5509.5,3791.5,6821.5,10532.5,9798.5,9794,12.5,6.5,7684,-0.003594332,5417,9623.5,4.5,11624,10353,5898,9265.5,2.5,17.5,18.5,1.5,6513.5,5704,8017.5,7381.5,12266,28839.5,20042.5,17.5,13.5,4.5,11242.5,30520.5,4.5,-0.0034774437,19351.5,19031,18691,-0.01525827,-0.012714545,-0.013415607,15.5,18360.5,18360.5,11.5,31580.5,33,4.5,651.5,1259,-0.040307876,2.5,3777.5,711.5,7.5,1686,7.5,16755,4057,4797,4554,5536.5,190.5,205,472,-0.025924433,1912,2279,81,642.5,4609.5,0.036562465,476.5,6189,7532,0.0043970994,5454.5,5518.5,2038.5,10881,7.5,11.5,4.5,2238,4.5,9232.5,0.020640835,0.010474362,8082,1.5,9363.5,5201.5,5350.5,6.5,6426.5,11966.5,7048,7848,11935,6433,0.015732875,6.5,1.5,3100,2807,20.5,15.5,0.02181968,4703,5421.5,-0.017667057,7589,5503.5,5682.5,0.02283079,3295,8573,6838,9508.5,9008,1.5,14875.5,30001,29441.5,21608.5,24678.5,2.5,29466,2.5,-0.0011103995,2.5,2.5,-0.004299115,18466.5,2.5,18133,18623,22164.5,17707,32510.5,19487,24654.5,-0.016862813,-0.020632891,18971,12.5,18971,21850,24097,24068.5,-0.0020589423,30192,-0.0014079277,-0.007385166,0.012108954,0.0012664947,-0.012284337,-0.032009624,0.0030645707,-0.013760127,-0.017071242,-0.0031425112,-0.041172583,-0.020132415,-0.03446992,-0.012876379,-0.0050496734,-0.014013256,-0.007647512,0.007759325,-0.011751223,-0.030950999,-0.00063603715,-0.02220138,-0.0042709275,-0.014798398,-0.0077762464,-0.0020870464,-0.012375472,0.00082338596,-0.004571754,-0.010885426,-0.001737571,-0.014089462,0.0362339,0.0037914973,-0.014329039,-0.027202887,-0.0023319093,-0.028523454,0.010022608,-0.0014404363,0.0055355104,0.053274155,0.039775,0.009821896,-0.013910144,-0.0048324303,-0.018722448,0.0187989,-0.011749166,-0.019601522,0.02168834,0.005303006,-0.0018027332,-0.016918482,-0.0018882847,0.0026752076,-0.032199994,-0.020534147,-0.0022169722,-0.008385082,-0.017337097,-0.01267577,-0.0138404695,-0.020501468,-0.008400458,-0.014449901,-0.015856963,-0.0037946817,0.0018580196,-0.010162699,-0.038470935,-0.018775929,-0.007890051,0.00350618,0.004417349,-0.020248855,-0.0048371623,0.0059053167,-0.0031981624,-0.01299788,-0.009274373,-0.020552713,0.0016643166,-0.012569091,-0.00953406,-0.0039231307,-0.012960188,-0.008431035,-0.0004016525,-0.0087830415,-0.016269663,-0.0058605815,-0.013075331,-0.023270996,-0.011532093,-0.015856013,0.011563304,0.006904097,-6.4879925e-05,-0.009047458,0.0048544067,0.0013082027,0.0032060102,0.010280206,-0.0025588165,0.0048445426,0.010911741,0.015397146,0.0043476615,0.01259912,0.0018493368,0.012522115,0.0043915543,-0.012047618,-0.0029127107,0.0014572755,-0.0071044574,-0.02049586,0.0061009987,-0.0030700404,-0.010572595,-0.0029727973,-0.02193907,-0.0012222346,-0.0028474347,-0.0124742305,-0.021006456,-0.03464274,0.0005444325,-0.008202694,-0.007023044,0.005793994,-0.004515696,-0.014979059,0.0070654373,-0.0024827893,0.00023902967,-0.001967916,-0.006731941,-0.0030308815,-0.0034993717,-0.0028906304,-0.0036799926,-0.0023261283,-0.005266895,-0.010076484,-0.010579088,-0.015095124,-0.006911715,-0.011301625,-0.0023853607,-0.0014067091,-0.0051704696,-0.0059795827,-0.007961145,-0.0068706125,0.00011626793,-0.0016864401,0.0022980426,0.0004606024,-0.0027824761,-0.0056531173,-0.0041659498,-0.0020679792,-0.006358263,-0.007951977,-0.004555041,-0.002383048,-0.01041932,-0.009088877,-0.0077170576,-0.009152768,-0.012699115,-0.011272697,-0.010560533,-0.018374808,-0.006577442,-0.0058147907,-0.0076924786,-0.006789826,-0.0033964508,-0.004158997}, {7,2,2,8,1,4,8,1,4,7,2,2,1,1,1,0,2,1,1,255,7,0,8,8,8,4,1,7,8,8,1,0,8,0,1,0,8,7,0,8,0,1,0,2,4,2,7,0,4,0,0,255,2,2,8,2,8,7,0,8,1,1,7,7,8,7,1,7,8,1,4,7,7,7,2,2,1,2,2,8,8,2,255,1,0,8,0,2,7,7,8,8,8,8,1,4,7,1,1,2,1,8,8,8,1,4,8,255,7,7,7,255,255,255,8,1,1,8,0,0,8,4,2,255,8,4,7,8,0,8,0,2,7,1,7,2,0,1,255,4,7,2,0,4,255,1,1,0,255,7,7,1,0,8,8,8,1,8,0,255,255,2,8,0,7,1,8,1,1,1,4,4,7,255,8,8,4,0,8,8,255,2,1,255,0,4,0,255,1,7,2,2,4,8,7,4,2,2,2,8,4,8,255,8,8,255,7,8,1,7,7,7,4,1,1,255,255,7,8,7,1,7,7,255,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,65535,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,65535,209,211,213,65535,65535,65535,215,217,219,221,223,225,227,229,231,65535,233,235,237,239,241,243,245,247,249,251,253,255,257,259,65535,261,263,265,267,269,65535,271,273,275,65535,277,279,281,283,285,287,289,291,293,295,65535,65535,297,299,301,303,305,307,309,311,313,315,317,319,65535,321,323,325,327,329,331,65535,333,335,65535,337,339,341,65535,343,345,347,349,351,353,355,357,359,361,363,365,367,369,65535,371,373,65535,375,377,379,381,383,385,387,389,391,65535,65535,393,395,397,399,401,403,65535,405,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,65535,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,65535,210,212,214,65535,65535,65535,216,218,220,222,224,226,228,230,232,65535,234,236,238,240,242,244,246,248,250,252,254,256,258,260,65535,262,264,266,268,270,65535,272,274,276,65535,278,280,282,284,286,288,290,292,294,296,65535,65535,298,300,302,304,306,308,310,312,314,316,318,320,65535,322,324,326,328,330,332,65535,334,336,65535,338,340,342,65535,344,346,348,350,352,354,356,358,360,362,364,366,368,370,65535,372,374,65535,376,378,380,382,384,386,388,390,392,65535,65535,394,396,398,400,402,404,65535,406,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6984.5,6377.5,31022.5,1861,3622.5,8185,16942,1159.5,2007,2207,9427,7442,10792.5,16970,19370,380.5,1841,1925,5868,3239.5,7860,9652,11235.5,5566.5,7379,14113.5,10543,11063,17235,18133,23806,323,956.5,544,1958,1190,1245,2560,6070,7065.5,-0.03129346,4229.5,8507,6864,9690,6494,18562.5,7511.5,9093.5,6051.5,8370.5,8653,17005,12218.5,31340.5,-0.016337378,11020.5,-0.0075259483,27728,20358.5,19882.5,26906,29570,123,180,633.5,998,1679.5,1235.5,0.021669382,4002,0.0115867015,0.029638493,1776.5,1676.5,4987,5834,5992.5,7619,6919,3522,4037,8455,8908,10729.5,6298.5,6267,6000.5,11466.5,0.0021947287,9419.5,13451.5,0.010586443,4916.5,7994,5148,9956,5381.5,8133,7762,11141.5,10873.5,8801.5,9536,22089.5,10384,13706.5,13263.5,28812.5,-0.016547656,12687,-0.012336299,-0.010096471,18014,-0.0121266665,18160,19225,-0.012715302,18539,24158,30192,107.5,26.5,898,391.5,86,262.5,980,1083.5,1170.5,-0.04079854,1202.5,589.5,2270.5,-0.022539463,-0.010748859,0.0031834182,3182,2152,2470,2360,4995,6168.5,6376.5,11489,7909.5,6556.5,-0.010623618,1488.5,9727,-0.021760518,7732.5,-0.019205263,6577.5,-0.0026950329,2499.5,-0.03800861,7030.5,11800.5,5984.5,8309.5,4616.5,9250.5,-0.023147637,-0.018673515,11193.5,3292.5,0.027190447,0.020909574,6997,16398.5,2626,5147,7308.5,8169,7435,7050,7650.5,12480.5,7620.5,7608,7273,-0.001132015,7053,8230,-0.030767504,7838,6793.5,7704.5,9923.5,7001.5,9410,26579,0.025164042,9158,7534.5,10244,-0.014350091,-0.0046968907,10475.5,12889.5,29743.5,29493.5,12102.5,-0.015833601,18570,18656.5,31640,19476,19852,19528.5,20270.5,19976,-0.0052183736,25574.5,30079,29556.5,-0.0022942126,-0.015078974,-0.0071887984,0.013137675,-0.023499032,-0.040612,-0.0015580712,-0.019942489,-0.011041076,0.011772498,0.006668504,-0.011696983,0.01265904,0.026930133,-0.008649322,0.014445192,-0.039415214,-0.020998752,-0.009622635,0.0074664736,0.0054393522,-0.016565584,-0.00470601,0.0030260885,0.010993682,0.014518066,-0.015508479,0.0063975938,-0.019151343,-0.008944207,0.00031897504,0.0026126674,-0.002078092,0.0012431158,-0.0048599965,-0.017473644,-0.0067469277,-0.010351552,-0.027876819,-0.0012331783,-0.00410708,0.005998887,-0.008310308,0.006816938,-0.01978791,-0.036058266,-0.01419487,-0.01675578,-0.010419463,-0.0026074548,0.003799149,0.0024226473,-0.015297055,-0.018072398,-0.0035249006,-0.012367823,-0.017161768,-0.013636467,-0.006900798,0.009810901,-0.022172092,-0.010418564,-0.010197828,-0.0061375387,-0.0033047588,0.011561344,-0.010136361,-0.0019585735,-0.030102456,-0.012604645,-0.015742235,-0.008994172,0.0011505773,-0.006157742,0.0073109786,-0.0046321573,0.020543098,0.008650253,0.012695401,0.003247469,-0.0091738235,-0.0010496326,-0.015020593,0.008588304,-0.016760034,-0.005298972,-0.0028700097,0.011122826,-0.01989862,0.0017256135,0.00018713625,0.0052894927,0.010007698,0.00571145,-0.011321503,-0.026631007,0.005935495,0.014855109,-0.043466207,0.004725099,-0.000119370656,0.0030585297,-0.012583447,-0.027881866,-0.005416112,-0.01697622,0.013661529,0.0033087917,0.018345185,-0.009910818,-0.0037556763,0.0030088534,-0.009046573,-0.005478607,0.009732643,0.0006375811,0.0068372535,-0.0010124557,0.0044527543,0.0018789707,-0.0049580806,-0.015648505,-0.0021984244,-0.0061122472,-0.0019127055,0.0021670312,-0.003639992,-0.0023700902,-0.013297922,-0.010980557,-0.007406585,-0.008836033,-0.010485051,-0.00855077,-0.0068628765,-0.0051443274,-0.0077249655,-0.008738733,-0.0059831156,-0.0075566145,-0.0030585867,-0.004998675,-0.007858402,-0.0049345107,-0.0052873488,-0.0064804177,-0.004506742,-0.0064167716,-0.0016969258,-0.0022439554,-0.001009952,-0.003451754}, {1,0,2,3,1,2,5,2,2,1,3,3,3,3,3,1,5,3,4,5,0,0,2,3,5,1,2,5,3,1,1,0,3,3,4,0,5,3,5,4,255,3,0,0,0,0,3,5,1,4,4,4,5,4,1,255,1,255,4,5,5,0,1,1,3,0,2,2,2,255,5,255,255,0,4,0,0,5,4,2,3,3,2,2,0,1,1,1,0,255,2,3,255,3,0,4,4,4,2,1,5,0,4,3,0,0,5,4,4,255,5,255,255,1,255,1,3,255,5,5,1,0,4,4,0,2,2,3,3,2,255,0,3,5,255,255,255,0,5,2,3,1,1,4,2,5,1,255,5,0,255,2,255,0,255,1,255,4,0,1,5,5,2,255,255,0,3,255,255,0,0,2,3,1,1,1,2,5,1,2,0,1,255,0,3,255,1,5,5,1,1,3,0,255,3,4,2,255,255,4,5,0,4,1,255,3,3,0,1,1,1,1,1,255,1,1,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,65535,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,109,65535,111,113,115,117,119,121,123,125,127,129,131,65535,133,65535,65535,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,65535,167,169,65535,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,65535,203,65535,65535,205,65535,207,209,65535,211,213,215,217,219,221,223,225,227,229,231,233,65535,235,237,239,65535,65535,65535,241,243,245,247,249,251,253,255,257,259,65535,261,263,65535,265,65535,267,65535,269,65535,271,273,275,277,279,281,65535,65535,283,285,65535,65535,287,289,291,293,295,297,299,301,303,305,307,309,311,65535,313,315,65535,317,319,321,323,325,327,329,65535,331,333,335,65535,65535,337,339,341,343,345,65535,347,349,351,353,355,357,359,361,65535,363,365,367,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,65535,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,110,65535,112,114,116,118,120,122,124,126,128,130,132,65535,134,65535,65535,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,65535,168,170,65535,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,65535,204,65535,65535,206,65535,208,210,65535,212,214,216,218,220,222,224,226,228,230,232,234,65535,236,238,240,65535,65535,65535,242,244,246,248,250,252,254,256,258,260,65535,262,264,65535,266,65535,268,65535,270,65535,272,274,276,278,280,282,65535,65535,284,286,65535,65535,288,290,292,294,296,298,300,302,304,306,308,310,312,65535,314,316,65535,318,320,322,324,326,328,330,65535,332,334,336,65535,65535,338,340,342,344,346,65535,348,350,352,354,356,358,360,362,65535,364,366,368,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7315,7062,31340.5,56.5,3608.5,8068.5,16970,36.5,591,14770,16438.5,8098,10440,25928,19703,36.5,88,609,942,2561.5,16386,3022.5,12261,7019.5,8409,6268.5,10624.5,-0.02765446,32158.5,30503,24041.5,30,136.5,25.5,0.025645947,125.5,7218.5,709.5,6364.5,3513.5,8122,-0.014926607,-0.019832054,1446,9634.5,14028,22698,5913.5,9169,7591.5,8268.5,7973.5,7742.5,11217.5,18987.5,18128.5,11095,-0.012899089,18622,22571,27643.5,3421.5,25020,150.5,-0.014860471,38.5,53,112.5,133.5,1447.5,8135,512,1171,1737.5,5941.5,10605,9031.5,3050,9653.5,-0.008929227,3803,9617.5,10734.5,12378.5,27672,-0.010378189,-0.0022449342,2808,7042,8070,7480.5,-0.016575739,-0.035015,9378.5,8610.5,3457.5,6245,8887.5,8641,8281.5,12802.5,12620,20448,31858,-0.008676867,-0.015188358,12581.5,23563.5,19572.5,21389,31520.5,32021.5,30676,22,0.007590511,35,31565.5,-0.033854976,-0.018334387,-0.0051611853,-0.0014683417,36.5,62,51.5,740.5,137,184.5,467,2421,-0.0075444304,8779.5,38.5,3328,1116.5,-0.007872882,1733.5,2066,6777,5826,9308,-0.01673781,-0.01923407,-0.03155162,6883.5,7835,7122,11001,-0.025483433,-0.012662363,6055.5,0.014505776,5786,11300.5,-0.01663015,-0.025018236,27285,-0.016631082,316,5318,6774.5,7442.5,9420.5,0.025971754,-0.012549314,9606,7054.5,7557.5,7995.5,9528,-0.004577862,-0.031974405,5535.5,5141.5,7043,5859,7960,18074.5,0.018557701,12214,-0.020248292,-0.008981216,12553,19320.5,18776,15971.5,-0.010142988,32068,12170.5,-0.014683942,13442.5,-0.001278636,27527.5,23811,18860,21606,-0.0041577313,24348,-0.007266899,24529,30400,30772,-0.0044315653,-0.0016746366,0.006705792,0.00064350804,-0.018314209,-0.0066351653,0.011267317,0.008154986,0.0002537438,0.003140738,-0.0063836137,0.0026423198,-0.017729597,-0.039570685,0.08103556,0.018497586,-0.014858316,0.0035172359,-0.024144445,-0.010653202,-0.06085887,-0.03304137,-0.0037677574,-0.0023801874,-0.0037263713,0.0071644126,-0.008784426,-0.022176383,0.007886331,0.017671375,-0.0025069753,-0.014818649,0.009640487,-0.0037287313,-0.00011729893,0.0128308255,-0.0031682902,-0.015372972,-0.013531084,-0.011404888,-0.0057566604,-0.00029596974,-0.012177679,-0.0065880227,-0.02235216,-0.014243528,-0.008118603,-0.011806722,-0.007361123,-0.004028065,-0.00570266,-0.010496935,-0.004733236,-0.0085580265,-0.013686593,-0.008871569,0.002396286,-0.004717427,0.014096587,0.0011062527,-0.0121101765,-0.0014693781,-0.011533809,-0.022437556,0.0029332421,0.0077168876,-0.00078941183,-0.015173459,-0.015574058,-0.02753436,-0.00813423,0.00055100105,0.0008218134,0.0022178127,-0.003417388,-4.1464224e-05,-6.247832e-05,0.009974635,-0.016960384,-0.0015207103,0.0055139703,0.008728777,-0.018806396,-0.006288163,-0.01298424,-0.024901396,-0.008170075,0.007448627,-0.0003552102,-0.00324713,-0.0149263805,0.0013396072,-0.017806778,0.005491599,0.020067448,-0.022345204,-0.007757012,-0.0023120176,-0.012770501,-0.008876355,-0.013372229,-0.009559188,-0.011165741,-0.007696559,-0.009052846,-0.0066460194,-0.005117172,-0.009230925,-0.0074294806,-0.005368309,-0.010983747,-0.0065685557,-0.0050410493,-0.0040421835,-0.0043570586,-0.0035703797,-0.0023969347,-0.0013060643,-0.0040402412,-0.0019643202}, {7,6,4,6,7,6,3,7,7,6,6,4,3,0,7,6,4,6,4,7,0,4,3,3,4,0,4,255,0,2,3,2,2,2,255,7,4,4,7,3,6,255,255,0,4,0,4,3,0,7,7,7,7,0,2,7,7,255,7,7,3,4,2,0,255,0,2,6,7,4,0,4,2,7,6,6,4,3,0,255,3,4,6,0,4,255,255,0,4,0,7,255,255,4,7,0,4,2,4,6,2,3,2,2,255,255,7,3,3,7,2,0,3,6,255,0,3,255,255,255,255,4,0,7,4,6,7,3,4,255,0,0,7,7,255,6,6,7,4,4,255,255,255,2,6,2,6,255,255,3,255,3,6,255,255,0,255,2,3,2,6,3,255,255,2,2,6,0,0,255,255,0,0,2,3,3,7,255,2,255,255,2,4,3,3,255,0,3,255,7,255,0,3,3,7,255,7,255,3,3,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,55,57,59,61,63,65,65535,67,69,71,73,75,77,65535,65535,79,81,83,85,87,89,91,93,95,97,99,101,103,105,65535,107,109,111,113,115,117,65535,119,121,123,125,127,129,131,133,135,137,139,141,143,145,65535,147,149,151,153,155,65535,65535,157,159,161,163,65535,65535,165,167,169,171,173,175,177,179,181,183,185,65535,65535,187,189,191,193,195,197,199,201,65535,203,205,65535,65535,65535,65535,207,209,211,213,215,217,219,221,65535,223,225,227,229,65535,231,233,235,237,239,65535,65535,65535,241,243,245,247,65535,65535,249,65535,251,253,65535,65535,255,65535,257,259,261,263,265,65535,65535,267,269,271,273,275,65535,65535,277,279,281,283,285,287,65535,289,65535,65535,291,293,295,297,65535,299,301,65535,303,65535,305,307,309,311,65535,313,65535,315,317,319,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,56,58,60,62,64,66,65535,68,70,72,74,76,78,65535,65535,80,82,84,86,88,90,92,94,96,98,100,102,104,106,65535,108,110,112,114,116,118,65535,120,122,124,126,128,130,132,134,136,138,140,142,144,146,65535,148,150,152,154,156,65535,65535,158,160,162,164,65535,65535,166,168,170,172,174,176,178,180,182,184,186,65535,65535,188,190,192,194,196,198,200,202,65535,204,206,65535,65535,65535,65535,208,210,212,214,216,218,220,222,65535,224,226,228,230,65535,232,234,236,238,240,65535,65535,65535,242,244,246,248,65535,65535,250,65535,252,254,65535,65535,256,65535,258,260,262,264,266,65535,65535,268,270,272,274,276,65535,65535,278,280,282,284,286,288,65535,290,65535,65535,292,294,296,298,65535,300,302,65535,304,65535,306,308,310,312,65535,314,65535,316,318,320,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7260,7077,31028.5,14.5,3827,10301,7.5,2220.5,3744,24.5,8979.5,1.5,16189.5,2.5,15803.5,228.5,4992.5,737.5,1844,10.5,18.5,5392.5,6.5,7812.5,25596,19746,18839.5,19137,19268.5,12.5,22755,115.5,108.5,4406,6.5,712.5,831.5,3999,5430,0.012793322,0.0061069094,15.5,9741.5,6618,6783.5,4.5,4586.5,7823.5,6783,11136.5,12.5,28315,20317,19418.5,16746,14068.5,1.5,14783.5,4.5,11278,12827.5,15.5,27962,107.5,121.5,33,179,5179,5189.5,1.5,5589.5,214,1385.5,20.5,1455,-0.02664699,2468,5171,9147,8507,9794,2172.5,10977,7500.5,13.5,7774,7926.5,10563,10334,8774.5,9623.5,8497.5,10629.5,-0.030610157,8075.5,10291,13197,6.5,18.5,12471.5,28113,0.02445927,15.5,1.5,17938,24891.5,17111.5,31976,1.5,32510.5,18964,31589.5,4.5,21948,18770.5,-0.011340787,12687,15.5,31484.5,30152,30152,13537,31580.5,53,232.5,69.5,390.5,333,40,4.5,1540.5,2202.5,4610.5,10277,6311,4579,5910.5,5153,9671.5,160.5,1924.5,302.5,804,18.5,0.07549528,1402,1863,16.5,-0.0058086095,4615,5486,4551.5,11455,5.5,12.5,17.5,14879,8293.5,7780.5,2483.5,11512.5,0.018317264,5091,5086,7990,5627.5,9574.5,6376,6859.5,9595.5,11780.5,9263,11609,9710,9265,9363.5,9690,7636,5728.5,8516.5,0.008771709,-0.008026347,8800.5,17.5,12.5,8793,13.5,2766.5,2997.5,19239.5,3185.5,11340,15635,22978.5,29425,26598.5,25656,0.012340924,15781,19863.5,19334,20369,22876,24447,23729.5,-0.0035335706,12774,18602,32052.5,32165.5,21732,-0.0033419863,21694.5,-0.0022323716,11077.5,30679.5,16723.5,21284.5,3.5,-0.0055394336,5.5,-0.007884819,-0.009939953,-0.013038769,-0.016047707,-0.008898839,-0.011944417,27928.5,21823.5,27928.5,21823.5,-0.0016635295,12.5,15.5,29556.5,-0.00402043,0.0026534118,-0.012230015,-0.024412714,-0.013761035,0.0115297595,0.03937874,0.006575377,-0.00534042,-0.02071205,0.0060932846,0.01732244,-0.032518007,-0.0217532,-0.00735113,-0.017187146,0.0058684913,-0.0036282584,-0.00526411,0.010041182,-0.01318537,-0.00085513404,-0.0046906974,-0.009947176,0.015290891,0.007972789,0.0031584834,-0.005971964,0.005980773,-0.002924279,-0.011149606,0.0010618377,-0.00048650755,0.019339746,-0.0067423894,0.012567385,-0.022382116,-0.014467229,-0.03987127,-0.009327885,0.0060928534,0.024385152,0.0014783617,-0.04628964,0.015139869,0.0035907421,-0.018105706,-0.0132159665,-0.011707731,-0.0030288955,-0.0014806776,0.00661861,0.0021673206,-0.012702274,0.0061428957,0.0013491316,-0.017647972,-0.010414931,-0.009063738,-0.013915936,-0.0058658244,-0.002144437,-0.01133415,-0.014833013,-0.011913662,-0.02406659,-0.005072393,-0.010794889,-0.016614148,-0.012572455,-0.020630827,-0.015816538,0.011756343,0.0062110065,-0.01337899,-0.0017860912,0.005174162,-0.0023285598,-0.008400876,-0.020460457,-0.00901326,-0.0029091884,0.005639447,-0.007829937,-0.0054887184,-0.016821828,-0.0009773275,-0.015690453,0.0022083276,-0.0046141883,-0.009121916,0.0066637844,-0.0019182658,-0.007779289,-0.0023711969,-0.015303549,-0.029675713,-0.014298752,-0.008470129,5.813165e-05,-0.016473498,-0.009241854,0.012327731,0.024477024,0.0002661642,0.009690281,-0.003337973,-0.017668575,0.015202551,0.0036281103,-0.0021469058,0.00040363634,0.02369751,0.009985011,-0.006627681,-0.015516563,-0.0049701147,-0.008616702,-0.0063737743,-0.0011164743,0.007812388,0.0028741104,0.0069010654,0.011213407,0.020661928,0.011617707,-0.0075895786,-0.01506299,-0.0016556879,-0.006889173,-0.022142243,-0.0055904347,-0.02975933,-0.015035177,0.004865616,0.011444788,0.005376814,-0.0017161643,-0.0049411813,-0.024985136,-0.004402712,0.00041303813,-0.01807197,-0.006801255,0.029102132,0.020467533,0.013134243,9.332931e-05,0.026344612,0.008629016,-0.0074157915,-0.0019292256,-0.0058008926,-0.008325952,-0.0013596987,0.0012359923,-0.003565322,-0.00255613,-0.0007433106,-0.0016073118,0.003392533,0.0014692191,0.00034278168,-0.0008784742,-0.009995582,-0.007781185,-0.0051376573,-0.003397783,-0.0068558543,-0.005060771,-0.002334187,-0.004572252,-0.0009906162,-0.0017924467,-0.002924433,-0.0037197832,-0.008042275,-0.010613234,-0.0063754627,-0.01190871,-0.010110444,-0.012930179,-0.008334945,-0.013088365,-0.00499369,-0.0057257954,-0.0014307513,-0.000842529,-0.0016943635,-0.0031708207}, {7,2,2,8,5,0,8,5,4,7,4,8,5,8,5,0,5,5,5,8,8,0,8,0,5,7,4,7,7,8,5,0,4,4,8,4,4,0,7,255,255,8,4,4,0,8,5,4,5,4,8,4,0,7,7,7,8,7,8,7,7,8,5,0,2,7,5,2,2,8,7,2,0,8,2,255,7,5,5,0,2,5,0,2,8,2,0,4,4,0,0,7,5,255,0,0,4,8,8,4,2,255,8,8,4,4,5,4,8,4,5,2,8,7,5,255,5,8,2,0,0,7,0,5,2,7,4,2,4,8,4,4,7,0,4,2,7,0,0,2,0,7,7,8,255,2,4,8,255,4,2,2,0,8,8,8,2,4,4,5,0,255,5,0,2,0,2,7,7,2,4,2,0,4,0,0,0,2,2,4,255,255,5,8,8,0,8,2,4,7,4,4,0,2,2,2,0,255,4,5,5,0,2,0,4,255,5,5,0,4,5,255,5,255,5,4,5,7,8,255,8,255,255,255,255,255,255,0,5,0,5,255,8,8,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,65535,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,65535,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,65535,181,183,185,187,189,191,193,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,65535,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,65535,277,279,281,65535,283,285,287,289,291,293,295,297,299,301,303,305,65535,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,337,339,341,65535,65535,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,65535,373,375,377,379,381,383,385,65535,387,389,391,393,395,65535,397,65535,399,401,403,405,407,65535,409,65535,65535,65535,65535,65535,65535,411,413,415,417,65535,419,421,423,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,65535,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,65535,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,65535,182,184,186,188,190,192,194,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,65535,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,65535,278,280,282,65535,284,286,288,290,292,294,296,298,300,302,304,306,65535,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,340,342,65535,65535,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,65535,374,376,378,380,382,384,386,65535,388,390,392,394,396,65535,398,65535,400,402,404,406,408,65535,410,65535,65535,65535,65535,65535,65535,412,414,416,418,65535,420,422,424,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31254,6189,21608.5,15.5,4610,9988.5,31262.5,2433.5,3169,8045.5,6.5,11.5,19.5,28343,5.5,1383.5,5094.5,742,1695.5,12.5,18.5,7823.5,15288,3262.5,18.5,17439,-0.0063319006,26174,4.5,32331,32136.5,678,1399.5,5678,6.5,632.5,586,3911,2007,2562.5,2948,3117,7792,7885.5,11451.5,7394,17823.5,3181.5,0.0047668107,3237,0.015250427,13.5,15.5,-0.013337441,-0.0068558217,0.005404514,16.5,4.5,29099,29741.5,30210,505,1360,3985.5,6.5,3801,4.5,5655.5,5721,281.5,472,18.5,5573.5,843.5,1541,18.5,6620,5.5,4.5,1466.5,14.5,-0.02946799,6087,9089,4305,1.5,6578,11624,1.5,9438.5,13520,21651,21348.5,3001.5,5.5,0.0072436132,0.012719639,0.00042253893,-0.0006264847,14.5,16.5,28853.5,-0.0037426695,0.0043296157,-0.0022545506,4.5,29705.5,16.5,-0.0038662197,25920.5,15.5,150.5,431,1332.5,893,4.5,803,2.5,2020.5,6681,2.5,4619.5,12.5,5713.5,6360,5321.5,6987.5,273.5,18.5,667.5,458.5,67.5,3624.5,852,3374,-0.011253137,3683.5,21.5,1651.5,722,0.03379103,5655.5,7517,7031,7068.5,2433,6749.5,-0.018825334,8635.5,6086.5,6749.5,15.5,5.5,6657.5,0.0056535862,9746.5,4392,5663,6860,6790,8902,10699.5,17770.5,21789,11035,6867,11333,13591,13478.5,15979.5,15696,18970.5,14070.5,0.004121038,-0.0013682478,-0.0076384433,-0.00077450083,0.0016917977,0.0021251242,0.0006862577,0.0012726993,-0.0030846624,-0.0021806282,24771.5,24734,29719.5,29712.5,-0.0023041223,-0.003238786,17.5,29705.5,30063.5,30063.5,-0.00602385,0.007237678,-0.020089397,-0.0090913605,0.006264077,0.023701152,0.0047433837,-0.005446849,-0.012731328,-0.02591284,0.015814336,-0.01827333,-0.01070531,0.0038318185,0.0021576022,-0.020010073,0.001606658,-0.0050994484,-0.009299668,-0.0023573805,-0.008081408,-0.0008723602,-0.013803938,-0.007051804,0.008452369,0.003293842,-0.0072535463,0.003594333,0.0032728077,-0.004990743,-0.0067670355,-0.002890638,-0.00038254887,-0.009733587,0.007315761,0.026465956,-0.0211355,-0.009387909,-0.042414926,-0.023771506,-0.007961793,0.007957957,0.046265017,-0.012095484,0.026137326,0.0030166344,0.012633443,0.032186493,-0.031684067,-0.049907796,-0.009321039,0.0035766885,-0.014259219,-0.024029998,-0.009705444,0.0041901898,-0.0018022227,-0.0068128826,-0.010163063,0.0081851045,-0.0106075695,-0.022059878,-0.01850993,-0.0066840523,-0.024134154,-0.0018877173,-0.0149473045,-0.009121576,-0.0079415385,-0.012770644,-0.007469999,-0.0037883956,-0.0016732485,0.0008787615,-0.00993085,-0.0075964876,0.004068022,-0.002191908,-0.0019725992,-0.011341941,-0.010672239,-0.014987617,-0.038181644,-0.010732501,-0.00094904966,0.01061426,-0.004690209,0.0020830233,-0.006243666,0.0045241956,-0.018760152,-0.0062322496,-0.004799323,0.0008606988,-0.009175844,-0.0028225544,0.008668936,0.0010982165,0.0004939981,-0.0026968594,-0.010983595,-0.006521807,0.01004506,-0.0033006587,-0.00247152,0.0058183293,-0.0065276655,-0.015233832,-0.0126606515,-0.025196016,-0.008788644,0.0059840526,-0.00797278,0.011219255,-0.010106051,-0.0057538706,-0.0017543411,-0.00132366,4.6263303e-05,-0.0012693747,-0.0031022334,-0.0019998776,-0.0005873015,-0.0023460372,-0.00078685547,-0.0025360505,-0.0019350464,-0.0014751229,-0.00075961906,-0.0013198487,-0.00022622904,-0.0007516335}, {3,0,2,8,1,0,1,3,6,0,8,8,8,0,8,2,3,1,3,8,8,2,2,2,8,0,255,2,8,3,1,3,3,2,8,0,6,6,2,3,1,6,2,6,3,1,6,2,255,2,255,8,8,255,255,255,8,8,6,0,0,2,6,6,8,2,8,1,6,1,1,8,1,2,3,8,1,8,8,3,8,255,3,6,1,8,3,0,8,3,3,0,6,0,8,255,255,255,255,8,8,1,255,255,255,8,2,8,255,2,8,3,3,6,2,8,3,8,2,6,8,3,8,6,1,0,6,0,8,0,3,6,1,1,2,255,6,8,3,0,255,1,3,6,0,1,6,255,6,6,6,8,8,6,255,0,1,1,0,2,1,2,6,0,2,0,2,2,2,1,6,2,1,255,255,255,255,255,255,255,255,255,255,2,6,0,2,255,255,8,2,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,95,65535,97,99,65535,65535,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,65535,151,153,155,157,159,161,163,165,167,169,171,173,175,65535,65535,65535,65535,177,179,181,65535,65535,65535,183,185,187,65535,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,65535,241,243,245,247,65535,249,251,253,255,257,259,65535,261,263,265,267,269,271,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,309,311,313,315,65535,65535,317,319,321,323,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,96,65535,98,100,65535,65535,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,65535,152,154,156,158,160,162,164,166,168,170,172,174,176,65535,65535,65535,65535,178,180,182,65535,65535,65535,184,186,188,65535,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,65535,242,244,246,248,65535,250,252,254,256,258,260,65535,262,264,266,268,270,272,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,310,312,314,316,65535,65535,318,320,322,324,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({24223.5,8179.5,19639.5,4971,6408,24140.5,30665.5,213.5,4796,8104,9812,3292.5,0.01662046,29203,21629,160.5,183,3522,9043.5,4622,19952,8783,24675.5,3192,28264.5,25946.5,31585.5,21679.5,28932,111,165.5,26.5,217.5,24106.5,7206,5427,7937.5,5089,5808,3525,0.0126137985,5879,10018,25671,24513.5,30385,3259,-0.0062330137,17170.5,18938.5,26208,29754.5,28007.5,0.000853744,-3.5182256e-05,29795,29835.5,81.5,114.5,0.07152396,65,62,302.5,0.0629344,520.5,2838.5,2445,5119,-0.0035745509,5397.5,7441.5,7162,9086.5,4481.5,5196.5,27277,5808.5,30493.5,8250,2258,8198,6540.5,10106.5,11161.5,20812.5,28031.5,28055.5,29097,3159,0.010877612,0.002852408,0.001197623,0.0003360864,22994.5,27932,26007,27328,30747.5,28396,25648,30192,29836.5,0.006304265,25936.5,29650.5,88,334.5,203.5,39.5,282,183,-0.015441099,0.0070481114,912.5,-0.02168459,271.5,474,0.0026127265,3208.5,2952,0.0019608866,4724.5,4656,8349,0.020781385,5921,5498,6812,7902.5,-0.018412994,10516,4174.5,9570.5,7708,4275.5,5123.5,27763,6048.5,7967.5,2704.5,0.00030788028,0.003968892,5154.5,329,7826.5,7228.5,10631.5,6998.5,6699.5,20615,11613,15488.5,11739,0.024579769,0.009568045,0.019139027,0.01132589,-0.00848818,29705.5,0.0027580971,3114,0.0025315697,0.0013029643,0.015670495,0.0023981114,26181.5,31332.5,22985.5,26189.5,25997.5,-0.022391593,29578,29224.5,29096.5,29779.5,15002,-0.00757453,30446.5,30852.5,29745,0.0022555634,-0.0122560365,28252.5,29706,29707,-0.0016531259,-0.013329081,0.012787551,0.0022098788,-0.00870588,-0.017560584,-0.01477015,0.016119992,-0.018706053,-0.00860373,0.0055341446,0.015784612,-0.015897762,0.005458026,-0.0023770994,0.00945293,-0.019088302,-0.0043186503,-0.0017364019,-0.0031368067,0.010646768,0.007100355,0.019145645,0.010961857,0.006260878,0.00953298,0.0006386522,-0.0047873296,-0.0010966093,-0.009190969,0.0076336823,-0.0016519096,0.006737154,0.016393973,0.0011481586,0.004730755,-0.0022205256,0.0006872801,-0.008861984,-0.0039852816,-0.019756276,-0.009280266,0.0015407816,8.394218e-06,-0.0063426304,-0.0038429915,-0.002164925,-0.0071837953,-0.011260919,-0.015156619,-0.01923838,-0.009587556,-0.0066719386,-0.023082642,-0.016907707,-0.006413092,-0.0028456382,-0.0068679014,0.004236316,-0.0026461957,0.010368159,0.006431932,-0.014833309,-0.030846402,-0.005526086,0.0045647332,0.016180946,-0.019265905,-0.013019082,-0.0005501288,-0.008649866,0.004720082,-0.0010591135,-0.005465787,-0.004754123,-0.008199795,-0.0006715941,-0.00454233,0.0008731615,0.004010055,0.010626469,0.005602965,-0.0028135374,0.000257945,-0.013192137,-0.006554392,-0.008327333,-0.015168771,0.003242575,0.000577387,-0.009663693,-0.014356461,-0.0024547833,-0.00387659,-0.0005350786,-0.0022274961,0.0028498638,-0.00017813075,0.0009549739,0.004366795,-0.0007308034,-0.0028736363,-0.0014954228,-0.0005478728,-0.0023484835,-0.0015409546,0.00022138328,0.0005732339,-0.0021101232,-0.0067220735,-0.0014886121,-0.0008121226,-0.0033870523,-0.0014508526}, {5,2,2,1,7,4,1,2,0,1,0,0,255,4,4,2,5,2,1,1,5,2,1,0,1,7,2,0,5,2,2,7,4,1,4,7,0,5,1,7,255,4,4,7,2,1,4,255,0,1,5,4,1,255,255,0,7,5,2,255,4,5,1,255,4,2,4,2,255,7,7,7,1,5,5,2,7,1,1,0,4,7,1,5,0,0,0,5,0,255,255,255,255,0,5,2,4,7,1,5,1,2,255,4,4,4,7,0,1,0,2,255,255,0,255,1,5,255,2,0,255,0,0,0,255,1,5,4,2,255,1,5,2,0,1,7,2,1,5,5,255,255,7,5,7,7,1,5,7,2,4,2,5,255,255,255,255,255,0,255,4,255,255,255,255,4,5,0,0,2,255,5,1,0,0,7,255,7,7,0,255,255,7,2,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,83,85,87,89,65535,91,93,95,97,99,65535,65535,101,103,105,107,65535,109,111,113,65535,115,117,119,121,65535,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,65535,65535,65535,163,165,167,169,171,173,175,177,179,65535,181,183,185,187,189,191,193,195,65535,65535,197,65535,199,201,65535,203,205,65535,207,209,211,65535,213,215,217,219,65535,221,223,225,227,229,231,233,235,237,239,65535,65535,241,243,245,247,249,251,253,255,257,259,261,65535,65535,65535,65535,65535,263,65535,265,65535,65535,65535,65535,267,269,271,273,275,65535,277,279,281,283,285,65535,287,289,291,65535,65535,293,295,297,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,84,86,88,90,65535,92,94,96,98,100,65535,65535,102,104,106,108,65535,110,112,114,65535,116,118,120,122,65535,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,65535,65535,65535,164,166,168,170,172,174,176,178,180,65535,182,184,186,188,190,192,194,196,65535,65535,198,65535,200,202,65535,204,206,65535,208,210,212,65535,214,216,218,220,65535,222,224,226,228,230,232,234,236,238,240,65535,65535,242,244,246,248,250,252,254,256,258,260,262,65535,65535,65535,65535,65535,264,65535,266,65535,65535,65535,65535,268,270,272,274,276,65535,278,280,282,284,286,65535,288,290,292,65535,65535,294,296,298,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7315,6294.5,31436.5,6021,3546,8068.5,18255.5,56.5,8348.5,9270.5,11283,8098,10822,30235,22976.5,103,512,5681,6185.5,3166.5,13626,7384,7135.5,3787,9894,5451.5,10076.5,17782,12827.5,31012,28007.5,106,415.5,500.5,1029.5,5360,6645,6928,8579,2544,3026,2862.5,15900.5,9694.5,7236.5,9726.5,5974.5,33.5,5372.5,10408.5,7451,5629,7953,8733.5,18489.5,-0.02231284,-0.012786559,31858,18293,19722,18490,18952,30602,22,-0.024469422,0.02052952,759.5,127.5,301,779.5,1287,5425.5,5197.5,7069.5,6186.5,0.01478364,5412,8163.5,3701,7330.5,2667.5,7320,3405,11001,10686,3035,15633,6575.5,9290,6334,9895,11780.5,12519,-0.013765412,9637,0.00957047,5355.5,4806.5,5550,8548,-0.012267237,0.004124613,10553.5,12358.5,0.019507613,9872,8307.5,8034,13329,13561,20183.5,11255.5,12102.5,32043,13970,-0.010251909,-0.007230176,21702,21447,-0.0004843744,24129.5,29556.5,-0.0027602778,22,27,-0.002728102,5876.5,111,133.5,120,183.5,2798.5,882,2256,1924.5,6945.5,5584.5,5268.5,5663.5,6149,7733.5,7029.5,7780,8181.5,9942,-0.006900651,6996,25225.5,6914.5,2893.5,2123,7646,5243.5,8981.5,-0.031075964,2984.5,3458,2486.5,12225.5,9811.5,3203.5,-0.0115734385,14943,-0.008972849,-0.015172628,6384.5,9468.5,10868,9622.5,6454.5,7121.5,7183,8415,0.009528029,9390,6678.5,0.0011294414,16327,6254.5,-0.0086646,6598.5,2309,5924,-0.025816644,6465.5,-0.03348076,-0.02146132,8612,7825.5,15414,-0.011567257,9984,9207.5,8861.5,10025.5,7047,9618,8662.5,13946.5,18838.5,21452.5,17814,14608,-0.0057929605,-0.009205252,32013,12710.5,-0.004919048,18150,12963,19860.5,30578,-0.016833618,19469,21606,22458,23781.5,30437,30079,-0.0031879426,-4.530999e-06,0.006920299,-0.0008391725,0.0073380144,0.0055323103,-0.0030716672,-0.012742653,0.04889038,0.0023586282,-0.01759474,-0.011217999,-0.0339698,-0.018754482,0.0038095103,-0.0098278085,0.022904405,0.007100464,-0.007945449,-0.02382818,0.008594302,-0.0034159743,0.00552111,0.0008844404,0.00053496024,-0.012619427,0.0051218746,0.013357157,0.0196652,0.013720606,-0.002329185,-0.016301591,0.003507955,-0.017665561,0.0026963993,0.0071584634,0.016470553,0.008844784,-0.006697666,-0.0008885409,0.0098091215,0.002523062,0.00162017,-0.00047969221,-0.010457019,-0.0043263407,-0.013369307,-0.025384247,-0.008472014,-0.0030144323,-0.009119355,-0.011388986,-0.004156113,0.00092685997,-0.009475022,-0.0037148192,-0.015454776,-0.020589711,-0.011617437,-0.00601388,-0.008655257,-0.013777323,-0.0076343315,-0.0037444145,-0.012072576,-0.007839081,-0.004489243,-0.0013226521,-0.0033380163,-0.0069570257,-0.008037976,-0.009746141,-0.0037581683,0.007840252,-0.010385445,0.012182933,-0.0006294044,-0.008848502,-0.013643599,-0.006165541,-0.008599847,0.003096415,-0.0130384965,-0.023969775,-0.0059214034,-0.03000077,0.014512275,-0.0028399203,0.004193125,0.0067658066,0.0023258408,0.0029936498,-0.0036735449,-0.008162647,-0.0011983663,0.0042368355,0.0047743926,-0.0019584496,0.007620944,0.0038674367,0.028183067,0.008903473,-0.0038881542,0.0025781975,0.0009636471,-0.0031925316,-0.0040599415,0.0001124825,0.00068571366,-0.0093704015,-0.018981403,-0.0016094627,0.018498259,-0.0024339152,0.0074292305,-0.0036989686,-0.010347778,-0.0036869578,0.004425385,0.0013764071,0.007201849,0.0044014785,0.0023958778,-0.0006194404,0.0031310362,0.0059501063,-0.0010803626,-0.011063835,-0.013741058,0.003698666,-0.012115695,0.016322864,-0.0067620645,-0.001489718,-0.009366344,-0.011079498,-0.006485998,-0.009617728,-0.006848695,-0.005241851,-0.008340744,-0.0062375735,-0.0048899543,-0.0021028626,-0.0061324826,-0.004424473,-0.0042800736,-0.003477345,-0.011037341,-0.004059992,-0.004230013,-0.0031006623,-0.0020610609,-0.002663667,-0.00080523326,0.0003306817,-0.00049345527,-0.0017474743}, {7,6,4,5,7,6,1,6,4,6,1,4,7,2,1,5,7,7,2,5,6,5,2,1,5,5,6,5,7,2,1,4,4,6,2,6,7,1,5,5,7,1,4,6,6,4,5,2,2,1,2,4,4,2,2,255,255,2,7,1,7,6,5,4,255,255,1,7,5,1,5,7,1,2,1,255,7,5,6,6,5,6,7,6,4,5,6,5,2,7,1,1,4,255,6,255,4,2,2,4,255,255,5,2,255,2,7,2,1,1,6,5,1,4,1,255,255,1,7,255,7,5,255,6,1,255,1,2,7,5,1,6,1,6,4,2,1,7,6,4,4,7,2,1,1,255,1,4,1,1,1,6,1,4,255,1,1,7,2,2,1,255,2,255,255,5,6,6,2,1,1,7,2,255,4,6,255,1,7,255,5,2,4,255,2,255,255,7,6,6,255,6,6,4,5,1,6,4,1,6,1,6,7,255,255,4,1,255,1,1,7,6,255,5,7,7,1,1,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,65535,111,113,115,117,119,121,123,65535,65535,125,127,129,131,133,135,137,139,141,65535,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,65535,177,65535,179,181,183,185,65535,65535,187,189,65535,191,193,195,197,199,201,203,205,207,209,65535,65535,211,213,65535,215,217,65535,219,221,65535,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,65535,261,263,265,267,269,271,273,275,65535,277,279,281,283,285,287,65535,289,65535,65535,291,293,295,297,299,301,303,305,65535,307,309,65535,311,313,65535,315,317,319,65535,321,65535,65535,323,325,327,65535,329,331,333,335,337,339,341,343,345,347,349,351,65535,65535,353,355,65535,357,359,361,363,65535,365,367,369,371,373,375,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,65535,112,114,116,118,120,122,124,65535,65535,126,128,130,132,134,136,138,140,142,65535,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,65535,178,65535,180,182,184,186,65535,65535,188,190,65535,192,194,196,198,200,202,204,206,208,210,65535,65535,212,214,65535,216,218,65535,220,222,65535,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,65535,262,264,266,268,270,272,274,276,65535,278,280,282,284,286,288,65535,290,65535,65535,292,294,296,298,300,302,304,306,65535,308,310,65535,312,314,65535,316,318,320,65535,322,65535,65535,324,326,328,65535,330,332,334,336,338,340,342,344,346,348,350,352,65535,65535,354,356,65535,358,360,362,364,65535,366,368,370,372,374,376,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3783,2783.5,5871,1159,1458.5,4512,7260,1034.5,2023,1822,4356,613,5589.5,1811.5,31166.5,409.5,843,1173.5,5581.5,-0.047890775,651,1607,5134.5,913,4469.5,4996,5588,1056.5,9686,6902,18133,252.5,454,2225,1699,784,52.5,4001.5,5364,2832.5,9466.5,3500.5,4208,-0.020241031,5410.5,-0.017633313,0.005128444,5351.5,0.014346897,5229,5617.5,5770,5814.5,986.5,219,7215,4455.5,7591,31770.5,13619.5,22497,323,106,443,497,1051.5,-0.034867886,1733.5,1427.5,0.005793058,1152,2628.5,1353,1603,4805.5,4817,11386,-0.022528632,0.02196858,943.5,-0.0097018555,3017.5,-0.0064472253,6541,4808,4730.5,3865,2447,5758,5774.5,5356,5166.5,7681.5,6007,0.004173299,5792.5,-0.019652208,-0.009240589,-0.0013963272,-0.021906985,-0.03292514,9363.5,7713.5,3967.5,10034,4051,6496,27166.5,30165,11094,30357.5,22245.5,29570,83.5,1065,24.5,198,421.5,0.030730182,1299.5,6914.5,-0.02906531,1270,785.5,-0.023538943,8825.5,1398,831.5,0.012105787,131,0.007467558,1166,2281.5,1910.5,2323.5,-0.039503764,-0.0022471983,0.024279607,0.009790417,5526,-0.013436066,-0.024894074,-0.017758548,-0.028568333,-0.019856958,3980,3668,5065,6860,0.0036796909,0.014608972,3841.5,3680,-0.0135018965,4323,5709.5,86.5,5293,-0.0023616878,4753.5,0.00017565118,6224,5427,0.019164247,9737.5,5592,5196.5,8749,0.017147794,7183,9621,-0.013514908,-0.020146111,3936,3979,9720,11609,3501.5,3527.5,7550,8643.5,10301,14155,32370.5,21808,31898,11186.5,19018,17982.5,19252.5,-0.014466128,18952,30079,-0.0024776617,0.011275744,-0.011844146,-0.024366183,-0.008286702,0.012692662,-0.0141983945,-0.006339626,0.012668759,0.008580352,-0.033468083,0.0039336504,0.0038036157,-0.0031752062,-0.0072463863,-0.016163008,-4.3047945e-05,-0.009667031,-0.009081812,-0.0022159822,0.008810227,0.000610095,0.015164685,0.026065076,-0.011314374,-0.0020249432,-0.0030717913,0.004696404,0.013005892,0.0024963822,-0.023503728,-0.008700448,-0.0036334747,0.0039912774,-0.013003488,0.0018693209,-0.0051994906,0.001313114,-0.015776401,-0.0077943774,-0.01531745,-0.007970598,-0.005546307,-0.0075585702,0.0023519443,-0.003512134,-0.003948039,-0.014074445,0.005559613,8.45707e-06,0.009029528,0.0031095834,-0.0029788367,0.0045532393,-0.00429868,-0.008759434,0.007540047,0.016636332,0.012378304,0.025669068,0.0005893729,-0.011306122,0.005133922,0.0017194098,-0.018006323,-0.03159011,-0.008683281,-0.004861464,-0.004196459,0.0071893404,-0.0033395377,-0.014478105,0.0062380596,-0.002832022,-0.0036687893,-0.0060502193,0.0053133997,-0.0012995953,-0.007330429,0.003500788,-0.0039211893,-0.006651687,0.002768517,-0.0011731078,0.009518934,0.004427255,1.6234082e-05,-0.002652638,0.0023392842,0.0012894621,-0.0011297254,-0.0031583027,-0.0137367295,-0.000664104,-0.010609463,-0.018688893,-0.0035694249,-0.0017633749,-0.00683399,-0.009926792,-0.0057226433,-0.0076798224,-0.008225726,-0.006147457,-0.0056421943,-0.0044432003,-0.0042670085,-0.0034046322,-0.0003972151,-0.0026873844,-5.8128837e-05,-0.0012897936}, {7,6,6,7,7,0,7,6,0,0,1,2,7,0,2,1,7,6,1,255,1,4,0,0,0,1,4,2,2,6,1,2,0,6,4,2,0,2,0,0,0,0,4,255,0,255,255,7,255,7,6,6,6,0,0,7,7,0,4,7,1,0,6,0,1,6,255,6,6,255,6,6,7,1,4,0,4,255,255,7,255,7,255,6,2,2,2,4,7,6,0,1,1,7,255,6,255,255,255,255,255,0,0,7,2,2,6,0,2,7,4,1,1,1,4,7,7,0,255,0,0,255,6,1,255,0,2,4,255,2,255,0,6,2,7,255,255,255,255,0,255,255,255,255,255,4,1,4,2,255,255,6,7,255,6,2,0,4,255,0,255,2,7,255,0,6,0,1,255,1,0,255,255,7,7,1,0,2,0,2,0,0,1,6,1,0,7,7,7,7,255,6,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,65535,65535,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,65535,123,125,65535,127,129,131,133,135,137,139,65535,65535,141,65535,143,65535,145,147,149,151,153,155,157,159,161,163,165,65535,167,65535,65535,65535,65535,65535,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,65535,203,205,65535,207,209,65535,211,213,215,65535,217,65535,219,221,223,225,65535,65535,65535,65535,227,65535,65535,65535,65535,65535,229,231,233,235,65535,65535,237,239,65535,241,243,245,247,65535,249,65535,251,253,65535,255,257,259,261,65535,263,265,65535,65535,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,65535,301,303,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,65535,65535,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,65535,124,126,65535,128,130,132,134,136,138,140,65535,65535,142,65535,144,65535,146,148,150,152,154,156,158,160,162,164,166,65535,168,65535,65535,65535,65535,65535,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,65535,204,206,65535,208,210,65535,212,214,216,65535,218,65535,220,222,224,226,65535,65535,65535,65535,228,65535,65535,65535,65535,65535,230,232,234,236,65535,65535,238,240,65535,242,244,246,248,65535,250,65535,252,254,65535,256,258,260,262,65535,264,266,65535,65535,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,65535,302,304,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4799.5,6992,5871,51.5,4991.5,5375.5,32366,22,4987.5,7808,2034,9081.5,5671.5,9887.5,21582.5,3466,27,33.5,4765.5,7608.5,9132.5,-0.016439458,4342,5188,11740.5,6546.5,5869,9000,7135.5,19268.5,29384.5,22,0.0106438985,30,26.5,522,722.5,13232.5,5350.5,3807.5,2603,8275.5,10861.5,3532.5,12167.5,3561.5,5297.5,7994.5,12900.5,5479,5663.5,8368,6674,5493.5,9010,6930.5,11004.5,18812,24164,25920.5,29410.5,22,28.5,30.5,32.5,29.5,123.5,306,728,601.5,1161.5,5212.5,25650,-0.009600532,-0.01404349,3166.5,7644,2063.5,4735.5,4023.5,8318.5,10817.5,11573,20492,10614.5,8575.5,-0.015943762,358.5,5241.5,5068,-0.030331412,7855,5169.5,-0.0018526958,-0.0023852414,5944,5264.5,5421.5,-0.018434664,7180,-0.006784208,7069.5,-0.020331098,343.5,6060.5,0.017842926,7034.5,7244.5,6990,18074.5,21348.5,17398.5,-0.0005583735,21679.5,0.0034849395,24919.5,28879.5,29593.5,29381,22,59,-0.009946148,33.5,22,0.003287255,0.011209923,0.0071258033,72,82.5,25.5,50,102,380.5,0.015892906,1475,150.5,3752,1208.5,2801.5,3511.5,5268.5,-0.01936877,-0.0064025335,1516.5,5972.5,2771,7166.5,-0.00708417,-0.010733699,2861,0.009910887,3631,4526,-0.020483708,4476,4473,10846,8641.5,14095,-0.0025816646,-0.0048768017,4208.5,11797,-0.008956283,9945,-0.020877702,4946,5032.5,4481,0.00880791,8087,-0.0021134864,-0.0011276292,0.00064704014,5217.5,4686,0.023275716,5376.5,7456,7507.5,6754.5,5700.5,0.017556373,-0.0029390815,0.013010412,-0.020299366,12342,7722,8584.5,10091,11064.5,5458.5,6823,10926.5,0.018367974,10699.5,23849,19206,14503.5,0.00070553477,0.0010546421,0.0018539866,0.00069757475,25251.5,25045,24903,-0.00023855931,-0.003460933,29678.5,-0.0042003808,29536.5,-0.0038452942,0.0011347871,0.008673044,-8.159462e-05,0.0021311708,-0.0050249733,0.0010924852,-0.0006324298,-0.0020870203,0.0024415778,-0.017018616,-0.024696179,0.008506752,0.00062988297,0.0070242123,0.0014726304,0.0011447922,0.0068893316,-0.00448451,-0.0087814545,0.006825534,0.0022601301,-0.006301681,0.004083573,-0.012853898,0.020887055,0.0069506504,0.021831062,-0.0017225901,-0.0051793135,0.0028172322,0.010798268,-0.017344235,0.0004858498,-0.007720168,-0.005010971,-0.0053306576,-0.013083535,0.000604402,-0.005464656,0.006940541,0.0018521363,0.0024765406,-0.0029689854,-0.007906269,-0.0136419255,0.0005528747,-0.006369068,-0.009831502,-0.01599436,-0.005874134,-0.00056392315,-0.0022881057,0.0021175814,-0.0040927585,-0.010522415,-0.0053699794,-0.008622101,0.0015322657,-0.0022506115,0.0047973245,-0.0016172484,0.00012353451,-0.0055670156,0.0019564796,-0.0015827811,0.01186821,0.004588539,0.0054439357,-0.004712993,0.025429595,0.011313732,-0.0018441565,-0.00019924568,0.004425116,-0.0049349074,-0.0041355193,-0.01239049,-0.024470093,-0.041947234,0.013912015,0.0009283851,-0.018068299,0.0016164583,0.010896675,0.0033225429,-0.00017942509,-0.012488818,-0.018023213,0.004574384,-0.0034067587,-0.01198164,-0.015477841,-0.0026147286,0.00022258061,-0.0021923017,-0.0023677591,0.0032757092,-0.0059281983,0.0014880592,0.010018154,0.006886305,-0.006928774,-0.0041700727,0.011511124,-0.000718428,-0.0034321852,0.0075917765,-0.0061476654,-0.002892865,-0.00069748424,-0.0016305695,-0.0005763532,-0.00024690758,-0.0014728395,-0.00095616747,0.0007905664,-0.0035683622,-0.00039306094,-0.0012613367}, {7,6,6,0,3,2,5,6,5,6,7,0,6,0,6,5,7,6,7,6,6,255,7,2,0,5,7,3,2,0,2,5,255,2,3,0,3,0,2,7,3,0,0,7,0,5,3,5,0,0,6,2,0,5,3,2,3,6,0,2,6,2,0,0,0,2,3,0,0,2,2,5,0,255,255,5,2,7,5,7,0,0,2,0,2,0,255,0,6,0,255,5,6,255,255,3,7,7,255,2,255,2,255,0,6,255,7,6,2,7,6,0,255,0,255,2,2,2,0,0,2,255,0,0,255,255,255,6,5,5,0,2,0,255,0,3,6,3,6,7,5,255,255,7,0,5,0,255,255,3,255,7,7,255,7,3,0,2,6,255,255,5,0,255,0,255,0,7,2,255,0,255,255,255,6,0,255,3,0,0,3,6,255,255,255,255,6,3,3,2,6,7,2,0,255,2,2,2,7,255,255,255,255,0,0,6,255,255,2,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,65535,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,65535,65535,143,145,147,149,151,153,155,157,159,161,163,65535,165,167,169,65535,171,173,65535,65535,175,177,179,65535,181,65535,183,65535,185,187,65535,189,191,193,195,197,199,65535,201,65535,203,205,207,209,211,213,65535,215,217,65535,65535,65535,219,221,223,225,227,229,65535,231,233,235,237,239,241,243,65535,65535,245,247,249,251,65535,65535,253,65535,255,257,65535,259,261,263,265,267,65535,65535,269,271,65535,273,65535,275,277,279,65535,281,65535,65535,65535,283,285,65535,287,289,291,293,295,65535,65535,65535,65535,297,299,301,303,305,307,309,311,65535,313,315,317,319,65535,65535,65535,65535,321,323,325,65535,65535,327,65535,329,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,65535,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,65535,65535,144,146,148,150,152,154,156,158,160,162,164,65535,166,168,170,65535,172,174,65535,65535,176,178,180,65535,182,65535,184,65535,186,188,65535,190,192,194,196,198,200,65535,202,65535,204,206,208,210,212,214,65535,216,218,65535,65535,65535,220,222,224,226,228,230,65535,232,234,236,238,240,242,244,65535,65535,246,248,250,252,65535,65535,254,65535,256,258,65535,260,262,264,266,268,65535,65535,270,272,65535,274,65535,276,278,280,65535,282,65535,65535,65535,284,286,65535,288,290,292,294,296,65535,65535,65535,65535,298,300,302,304,306,308,310,312,65535,314,316,318,320,65535,65535,65535,65535,322,324,326,65535,65535,328,65535,330,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4864.5,15.5,6.5,67.5,3256.5,6080,32020.5,6472.5,4606,722.5,10832,5419.5,1.5,15106.5,3292.5,5148.5,5.5,1905.5,7.5,334,20.5,1257,27333,4909.5,5589,6828.5,17823.5,10192,17823.5,18.5,18.5,101.5,-0.022908384,0.016334167,10.5,1435.5,2425.5,7437,4767.5,113.5,1636.5,1315.5,658,3368,18.5,27285,-0.017667428,2116,8541.5,5493.5,7080.5,6934.5,7935,12902.5,21348.5,5096,15636,13714.5,21348.5,3287.5,0.011790914,24671,21629,93,102.5,0.007493825,0.0012596528,427,1260.5,3206.5,2448,7221,12161.5,5841.5,12.5,32.5,139,1561.5,3911,1248.5,1655,302,1248.5,582.5,5695,2206.5,4009,19739.5,0.00046789352,7197,4964,6982,6126.5,5757.5,4947,5993,6088,6253,7980,7999.5,11403.5,5843.5,6253,18161,21630.5,7023.5,4961.5,13674,25523.5,12929.5,21651,12624,20358,11.5,0.007405163,21629,26740,20.5,29707,6.5,29.5,-0.0055592447,6.5,409,1583,4.5,1917.5,4.5,3915,-0.025899649,5291,5830,3626,2.5,12282,5137,4634,5060.5,26512.5,930,566.5,0.037803356,198.5,500.5,0.02291882,159.5,4181,516.5,-0.021866573,1189.5,1139,0.027023682,803,980,1145,-0.012204982,2993,-0.0135756135,19.5,2057.5,9786,2453,8827.5,11800.5,-0.016525073,0.011098561,-0.00031505886,2532.5,5442,5476.5,5042.5,1.5,-0.01416483,5104,17134.5,-0.0008753645,-0.024188843,5746,5722,0.01954609,0.0059941863,0.0026334955,0.010940683,7233.5,-0.02619185,7855,0.0024389427,9169.5,20444,3870.5,5117,14109,12620,13620,20643,13957,20358,5898,7115.5,8847,9583.5,15.5,12620,16988.5,-0.00044344133,16275,12407,16284.5,15891,12.5,18999.5,13135.5,14220.5,2865.5,27873.5,16106.5,21044.5,17.5,30227.5,-0.0070445896,-0.0039496403,29669.5,29725.5,0.0019118314,-0.0021713737,-0.0008694,-0.01378985,0.0019650075,0.006446391,-0.00471216,-0.01422011,0.0016828316,-0.009331728,-0.0052628075,-0.021771261,0.0029179193,-0.00943901,0.010114996,0.0021411744,-0.0016567268,-0.012238826,-0.003515939,-0.006048415,0.0070372964,0.00017382063,0.0025041522,-0.003928646,-0.0106923925,-0.0035234918,0.008951375,-0.0003546643,-0.004203316,0.003270302,0.0022580293,-0.0036692047,-0.0037318286,-0.007917508,-0.0068664164,-0.013547855,0.0021863207,0.024216475,-0.00023504601,-0.013294744,0.0012491349,0.025543675,-0.0030971174,-0.01293425,-0.0033522048,-0.025282605,0.009432941,-0.007005489,-0.009677547,0.0031008308,0.025017196,0.009529465,-0.006830856,0.007915825,0.071131244,0.03883516,-0.0033598468,0.032358874,-0.03366057,0.011403187,-0.03963377,-0.022579435,0.003342342,-0.002454045,-0.0018765962,-0.007511069,0.00058109977,-0.0034467955,0.012092609,-0.000656655,-0.0040299497,-0.0074559688,-0.011302561,-0.008859716,-0.0054189027,-0.030113969,0.013146641,-0.0018258824,0.0146096945,0.007821484,0.0055193924,-0.0038659535,0.009920678,0.002693305,0.00074274134,-0.014532137,0.0014225433,-0.0049205576,0.0112097785,0.0026728862,0.00014069937,-0.014247297,0.010829403,-0.00966769,0.01887559,0.011359568,0.0032181316,-0.00649484,0.009795115,0.0009732386,-0.0016252398,0.005118766,-0.00974599,-0.0011342738,0.001630679,0.007080962,-0.0066339113,-0.013050544,0.004295233,0.020165928,-0.017153507,0.0041333768,-0.013062808,-0.019456578,0.007855184,-0.00086343515,0.0002306813,0.008893627,-0.019044628,-0.001706804,0.003514592,-0.009617404,-0.0029808718,-0.004857538,-0.0026039917,0.0011703321,0.0066424864,-0.009125385,-0.016915714,-0.0050954744,-0.012658387,-0.0058160857,-0.0017378686,0.0026366357,-0.009553263,-0.018480152,-0.015489903,0.013629361,-0.0011994557,-0.012467234,0.010206741,-0.011623985,0.00085119315,0.016967032,-0.007310133,-0.003922177,0.002547259,-0.0021089795,0.00022714344,0.0044342116,0.003325158,0.0012998801,-0.0013828225,0.00056913716,-0.00026515327,-0.0016381936,-0.0011063083,-0.00040360625,-0.0012792643,-0.0030836973,-3.8234615e-05,-0.0007201668}, {3,8,8,0,0,4,5,4,5,3,6,5,8,4,0,6,8,5,8,6,8,5,4,6,4,5,6,3,6,8,8,3,255,255,8,4,0,6,3,6,6,0,6,6,8,0,255,4,3,4,0,4,4,0,6,4,0,6,6,4,255,6,4,6,6,255,255,5,5,5,0,4,0,4,8,6,6,6,6,0,0,6,0,5,0,3,6,6,255,0,5,0,0,5,0,0,5,0,3,6,5,6,3,5,6,0,6,0,0,6,0,5,4,8,255,4,6,8,4,8,0,255,8,4,6,8,0,8,4,255,0,5,3,8,0,4,5,5,4,0,0,255,5,3,255,0,6,0,255,5,4,255,4,3,6,255,6,255,8,3,4,4,6,0,255,255,255,6,0,6,5,8,255,4,5,255,255,6,3,255,255,255,255,6,255,5,255,4,0,6,0,0,3,5,4,3,4,0,0,4,6,8,3,6,255,4,0,3,3,8,3,5,5,0,3,6,0,8,6,255,255,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65535,65535,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,65535,115,117,119,121,65535,65535,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,65535,215,217,219,221,223,225,65535,227,229,231,233,235,237,239,65535,241,243,245,247,249,251,253,255,257,259,261,65535,263,265,65535,267,269,271,65535,273,275,65535,277,279,281,65535,283,65535,285,287,289,291,293,295,65535,65535,65535,297,299,301,303,305,65535,307,309,65535,65535,311,313,65535,65535,65535,65535,315,65535,317,65535,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,65535,353,355,357,359,361,363,365,367,369,371,373,375,377,379,65535,65535,381,383,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,65535,65535,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,65535,116,118,120,122,65535,65535,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,65535,216,218,220,222,224,226,65535,228,230,232,234,236,238,240,65535,242,244,246,248,250,252,254,256,258,260,262,65535,264,266,65535,268,270,272,65535,274,276,65535,278,280,282,65535,284,65535,286,288,290,292,294,296,65535,65535,65535,298,300,302,304,306,65535,308,310,65535,65535,312,314,65535,65535,65535,65535,316,65535,318,65535,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,65535,354,356,358,360,362,364,366,368,370,372,374,376,378,380,65535,65535,382,384,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4802,13.5,7.5,4686.5,7983,5710,32387,67.5,12990.5,2940.5,2314.5,5764.5,6232.5,4862,9988.5,50,79.5,4.5,4326.5,722.5,1349,2168.5,9044,4962.5,1.5,5561.5,11588.5,18.5,15631,12.5,17.5,27,22.5,5.5,204,7073.5,4762,12657.5,4.5,583.5,20.5,943.5,1644.5,8245,18.5,2988,9283.5,5295.5,5482.5,8574.5,226,8340.5,7722,7706.5,1.5,5607,4644,10192,17823.5,30719.5,18.5,24733,24730.5,63.5,59.5,-0.028780267,26.5,40.5,183,194.5,183,6377,1.5,4693.5,4875,-0.02537859,5.5,9265.5,6564,409.5,743.5,5017.5,895,-0.0020510596,3684,3992.5,4506,8072.5,2042.5,17.5,9909.5,2500.5,8375.5,4288,10729,4142,5648.5,5205,4951.5,7049.5,12788,0.008656235,5812.5,5930,1.5,5674.5,6827,4969,3.5,32188.5,11639,4834,16.5,4073,7084,9756.5,13621,8095.5,21348.5,0.0033910645,-0.0008307402,0.007164459,2997,24764,25486.5,19759,29718.5,22,7.5,6.5,62.5,58,54.5,109.5,126.5,106.5,291,65.5,0.05561868,3.5,546.5,6464,-0.01837059,7469.5,5805.5,0.00957977,4892.5,-0.0040040757,9.5,-0.0019815254,-0.0075292857,6553,27525,0.0020557404,6.5,242,30,1924,677,18.5,6034,516,1264.5,-0.033706676,18.5,1651.5,18.5,2269.5,4192.5,-0.0056259423,7273.5,-0.02167582,8984,9909.5,2313,9272.5,-0.009937137,1472,2080,3486,9607.5,-0.01684243,-0.029635316,2487,15.5,4.5,5148.5,4.5,0.00050771533,0.01977043,5436,1.5,5232.5,5773,-0.011513977,5336,11187,5141,12379,5199,7224,0.010976172,9000.5,5061.5,5814.5,-0.011124391,7660.5,2.5,5570,11344,8375,24580,29144.5,18034,18831.5,5090.5,-0.01355916,11.5,0.011315401,19332,722,3632.5,0.006068888,9825.5,15090,12990.5,12361,7748,21651,18523.5,14411.5,0.008443572,0.01354411,19759,-0.00072044216,16.5,30210,0.0020374123,18.5,29660.5,29745.5,-0.0009342994,-0.003583471,-0.0031622031,-0.008344947,0.012041134,0.0018516785,-0.00460774,0.0037346445,-0.028012047,-0.0032534383,0.0031165907,-0.0014982551,-0.03225738,-0.019042326,-0.012288653,-0.019732824,-0.012976621,-0.005331093,-0.022367856,-0.010987916,-0.0022578945,0.015603623,-0.024420131,-0.014340217,0.0026272417,-0.006012018,0.002364727,-0.008120461,0.011266585,0.0040244996,0.00085141056,0.004898178,-0.009279344,-0.0013858833,-0.008720369,-0.014378778,-0.009844693,-0.0025291075,0.01224219,0.0013463817,0.0007533296,-0.005002547,-0.00088536786,0.015282092,0.024975408,0.0032031857,-0.007571678,-0.026343888,0.0033593017,-0.017231992,0.0031391599,0.010719764,-0.006113542,-0.00060706976,-0.0006229018,0.045745235,-0.008246825,0.012022835,-0.011071434,-0.018267386,-0.034033857,-0.0036727854,-0.0028854609,-0.0062951744,0.016136112,-0.00031842722,0.002444117,-0.009299457,-0.001051532,-0.0006699746,0.00010360123,-0.01171231,-0.0016034152,-0.010459716,0.0050838236,-0.0013017622,-0.0065759174,-0.0041800374,-0.012218346,-0.0050735064,-0.01673628,-0.009317764,-0.00074253365,-0.007263654,0.0057911365,-0.0023878317,-0.012531369,-0.0027200198,-0.013807157,-0.009277835,0.0033625439,-0.0004744251,-0.0029473729,-0.0076819398,0.0073731663,0.0038609267,0.011345547,0.005601061,0.019416578,0.009445176,0.0010731024,0.006978792,-0.0021312647,0.007982744,0.0055608884,0.010704869,0.0061690393,-0.00030623595,-0.0016416105,-0.015910178,0.0029051814,-0.001160579,0.01038402,-0.001630961,0.025811834,0.011781621,0.0060713524,0.00062254973,0.0028977764,-0.02182681,0.007014648,-0.0071555576,0.025964558,0.0006735976,-0.011389943,-0.0009440834,0.010603317,0.0002809582,-0.005257592,0.0010770223,0.00034654856,-0.004195686,0.0030423894,0.0135950735,-0.0009528922,-0.0020774044,0.0013525047,0.012296944,-0.0040558972,-0.00060961116,-0.0020383873,0.0040962244,-0.00034020012,0.003212303,0.0046040895,0.015233359,0.013302783,0.030463198,0.0012754308,-0.0047963443,-0.0022331274,-0.015022998,-0.004537854,-0.012032314,-0.0011690714,0.006949713,0.003635766,-0.009808702,-0.003996534,0.0032770447,-0.015440389,-0.0028870709,0.0053478386,-0.02485177,-0.0067805,-0.0032726463,-0.00021005239,0.0013094983,-0.0003347038,0.00039350823,-0.00094746717,-0.00038610937,-0.0072315396,-0.0033486,-0.0008361443,-0.0024805623,-2.2186487e-05,-0.0005371772}, {7,8,8,1,6,0,3,0,0,6,3,7,6,6,0,0,1,8,6,3,7,7,0,6,8,3,1,8,0,8,8,6,7,8,0,1,7,1,8,6,8,7,1,6,8,1,0,7,6,7,3,0,3,0,8,7,0,3,6,1,8,6,0,3,6,255,1,1,3,0,1,3,8,1,3,255,8,6,6,1,7,0,1,255,6,6,7,6,3,8,6,1,6,1,6,6,7,7,0,6,7,255,3,1,8,6,0,1,8,1,3,6,8,6,3,6,1,7,6,255,255,255,6,0,6,0,0,6,8,8,3,0,0,6,3,6,3,6,255,8,0,1,255,3,3,255,1,255,8,255,255,3,0,255,8,7,6,6,3,8,1,0,1,255,8,7,8,0,6,255,0,255,6,6,7,0,255,1,7,3,6,255,255,3,8,8,7,8,255,255,7,8,7,6,255,3,1,1,7,3,1,255,1,7,6,255,0,8,3,3,1,7,0,7,0,3,255,8,255,7,0,3,255,3,6,0,0,7,0,7,7,255,255,0,255,8,0,255,8,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,131,133,135,137,139,141,143,145,147,65535,149,151,153,155,157,159,161,65535,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,65535,65535,65535,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,65535,263,265,267,65535,269,271,65535,273,65535,275,65535,65535,277,279,65535,281,283,285,287,289,291,293,295,297,65535,299,301,303,305,307,65535,309,65535,311,313,315,317,65535,319,321,323,325,65535,65535,327,329,331,333,335,65535,65535,337,339,341,343,65535,345,347,349,351,353,355,65535,357,359,361,65535,363,365,367,369,371,373,375,377,379,381,65535,383,65535,385,387,389,65535,391,393,395,397,399,401,403,405,65535,65535,407,65535,409,411,65535,413,415,417,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,132,134,136,138,140,142,144,146,148,65535,150,152,154,156,158,160,162,65535,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,65535,65535,65535,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,65535,264,266,268,65535,270,272,65535,274,65535,276,65535,65535,278,280,65535,282,284,286,288,290,292,294,296,298,65535,300,302,304,306,308,65535,310,65535,312,314,316,318,65535,320,322,324,326,65535,65535,328,330,332,334,336,65535,65535,338,340,342,344,65535,346,348,350,352,354,356,65535,358,360,362,65535,364,366,368,370,372,374,376,378,380,382,65535,384,65535,386,388,390,65535,392,394,396,398,400,402,404,406,65535,65535,408,65535,410,412,65535,414,416,418,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4864.5,5861.5,5067,34.5,765,7023.5,30787,480,1806,773.5,1469.5,5898,7115.5,10986,16970,28.5,337.5,1501,1537.5,103,7679.5,6957.5,2285,4923.5,5326,-0.014685421,1001.5,8077,12625.5,24079.5,19303.5,22,27,0.009177941,0.0069420114,1235.5,711.5,1192.5,4926,0.01066495,986.5,0.00831383,1683.5,1505,8291,1796.5,3836.5,6119.5,5176.5,0.027177561,8470.5,7936,9244,4821,8117,18034,17823.5,-0.015024423,32158.5,30612.5,23587.5,26.5,26.5,32.5,33.5,803.5,1790.5,681,1720.5,488.5,1829.5,2434.5,5620.5,440.5,0.002495974,0.0052203676,0.0029765754,-0.02307144,-0.0133805815,3634,2640,0.00018083896,0.011890535,3549,10851.5,4539.5,5426.5,5486.5,6447,6332,6916.5,-0.0143064475,7945.5,8174.5,7874,7502,2521,8144,9539,16464,21567.5,13919.5,20073.5,11023.5,15285,17235,19292.5,19803.5,24612.5,22,-0.009480054,34,0.0018973692,0.009701895,0.0053227004,461.5,389.5,186,1733.5,961.5,1242.5,1734,-0.035501115,1809.5,1963,3471.5,1078.5,-0.0022227867,3288,1571,3314.5,5532,3642.5,-0.0038587821,-0.0011339518,111,1455.5,5906.5,8494.5,1510.5,3077.5,5482,13499.5,-0.037396442,4568,0.0048768735,-0.0005106782,0.01619226,0.0081057595,5216.5,415.5,7256,6519.5,0.0014179036,0.003747889,-0.0008617216,31408.5,3999.5,8081,-0.0029128613,-0.008010591,9196.5,7529.5,7400,7857,8486,6568,6055.5,18661,14213.5,14389,0.019194309,19657.5,15149,18444,17519.5,19720,-0.0021609992,32367,12102.5,-0.00946337,-0.003375385,27728,26417.5,-0.007014435,19031,18118,22995.5,29899.5,-0.0028580416,0.002380819,-0.00038329037,-0.002715945,0.0004086842,0.0048805717,-0.018027937,0.011307082,-0.0035726756,0.003034318,-0.0054270993,-0.02971888,0.006556794,0.014075008,0.0047974978,0.0023141156,-0.0144384205,-0.03251461,-0.003845483,0.0032494992,-0.017255306,-0.0058000213,0.011657892,0.0010097563,-0.012920568,0.004088832,0.018690608,0.01256557,-0.013126445,0.004445834,-0.008002337,-0.0028263023,0.0029905252,0.012142614,-3.46853e-05,-0.0031460722,0.00064691185,-0.002118288,-0.0072157905,-0.004424812,-0.003991525,-0.00916494,-0.009642712,-0.017668858,-0.0071403706,-0.004518194,-0.014872208,-0.005993737,-0.0030450814,0.00052770873,-0.008716243,-0.004860007,-0.011749915,-0.0053068753,-0.0082062455,0.0037618172,0.0037024647,-9.893651e-05,-0.010743647,0.00694296,0.013638322,0.008356549,-0.010647972,-0.002606101,0.005963299,0.0026826698,-0.0029788378,0.00058306474,0.0072675156,-0.0065776967,-0.009517768,0.00057907664,-0.0101415925,-0.028045151,-0.0014347391,0.003382381,-0.012721749,-0.001063933,-0.0038252452,-0.01675609,-0.0050028143,0.00080334133,-0.0036778399,0.008378439,-0.00031598474,0.0058929785,-0.005599243,-0.0010046255,-0.0014479811,0.008628155,-0.0025290668,0.018730523,-0.015441447,-0.0005116392,0.016019328,-0.011231914,0.0085211815,-0.0012725502,-0.0055315956,-0.004314426,-0.0068937726,-0.0048783566,-0.007885731,-0.004912761,-0.005412207,-0.0030301397,-0.0025478092,-0.0009099794,-0.0068403604,-0.0023877278,-0.002796699,-0.0014393098,-0.00087829697,-0.00039567673}, {3,6,4,6,3,0,6,4,1,1,1,0,0,1,3,0,3,0,4,1,6,4,0,7,3,255,4,0,3,0,1,6,1,255,255,1,7,4,1,255,0,255,0,0,6,0,7,1,7,255,3,0,6,6,4,7,6,255,0,4,7,0,0,0,6,0,3,7,6,6,3,0,1,1,255,255,255,255,255,0,7,255,255,3,6,6,0,1,6,3,0,255,3,3,0,0,1,3,4,4,0,7,6,1,1,3,1,1,1,0,255,3,255,255,255,0,3,1,6,3,0,3,255,0,6,1,6,255,0,6,4,1,3,255,255,0,1,0,4,3,1,1,0,255,0,255,255,255,255,7,4,1,0,255,255,255,3,4,0,255,255,3,0,6,0,0,4,3,3,4,7,255,7,6,7,7,4,255,6,1,255,255,4,0,255,7,7,1,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65535,65535,65,67,69,71,65535,73,65535,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,65535,65535,65535,65535,65535,135,137,65535,65535,139,141,143,145,147,149,151,153,65535,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,65535,191,65535,65535,65535,193,195,197,199,201,203,205,65535,207,209,211,213,65535,215,217,219,221,223,65535,65535,225,227,229,231,233,235,237,239,65535,241,65535,65535,65535,65535,243,245,247,249,65535,65535,65535,251,253,255,65535,65535,257,259,261,263,265,267,269,271,273,275,65535,277,279,281,283,285,65535,287,289,65535,65535,291,293,65535,295,297,299,301,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,65535,65535,66,68,70,72,65535,74,65535,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,65535,65535,65535,65535,65535,136,138,65535,65535,140,142,144,146,148,150,152,154,65535,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,65535,192,65535,65535,65535,194,196,198,200,202,204,206,65535,208,210,212,214,65535,216,218,220,222,224,65535,65535,226,228,230,232,234,236,238,240,65535,242,65535,65535,65535,65535,244,246,248,250,65535,65535,65535,252,254,256,65535,65535,258,260,262,264,266,268,270,272,274,276,65535,278,280,282,284,286,65535,288,290,65535,65535,292,294,65535,296,298,300,302,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4799.5,4201,6078,1681.5,3440.5,7219.5,23836.5,2388.5,1726.5,1458.5,4458.5,5943.5,8269,9692,21055.5,585.5,2002,2221,131,1251.5,3419,4953.5,4532.5,5903,5997,5679,12052.5,6132,24225.5,26437.5,30208.5,125.5,592.5,1127,879.5,1436,-0.0032222543,-0.016888373,2425.5,9372.5,-0.012597184,3482.5,-0.012595612,2895.5,2762.5,4529.5,5163.5,5658,7541,0.023222337,5977,5790.5,5800,5496.5,10612.5,6279,10375.5,25671,22223,21085.5,16632,28719.5,30241.5,112.5,133.5,5521,1382.5,-0.041925088,-0.024310553,679.5,4928.5,0.026495157,0.015819235,2386,6717,-0.008076605,-0.0050706207,3457.5,2413.5,3759,3765,7992,4709,4875,-0.023781164,4568.5,5314,5413,6291,5910.5,-0.0030750462,0.01169905,0.0036814802,5444.5,7667.5,-0.028951196,5978,5490.5,7583,4773,12824,-0.02058596,-0.014715405,5550,6848.5,11584,19134,28031.5,-0.0032716617,0.022521304,0.016175402,11603,0.001557756,27961,26897.5,0.0054322947,30121.5,43,125,137,182.5,2310,284.5,1275,821,-0.013385236,3639,3929,-0.020231673,2328,0.017758923,5046.5,12896,13626,0.0052475594,8186.5,5904,-0.0030532724,-0.00040868003,-0.015050932,6967.5,7702.5,10195.5,4856.5,4451.5,8967.5,-0.002050927,-0.008349105,-0.011177703,0.016493319,4429.5,543,8239,6787,5858.5,-0.009953885,-0.017167892,4964,0.008826993,0.006314739,9023,8082,-0.015997449,7669.5,-0.013444557,6687,7484.5,-0.019259036,-0.008732705,5384,14542.5,6337.5,6859.5,6316.5,5774,16861,10905,0.02464742,-0.0070189782,0.014938088,29607.5,0.005308585,0.009464128,26096,29638.5,22021.5,26926.5,28516.5,30234,-0.0019043228,0.003560512,-0.005682275,-0.011533717,0.053558726,0.013425114,-0.0060772616,0.0043751076,-0.0115908785,-0.029366314,-0.015285169,-0.0018406447,0.0022349865,0.011945018,0.0043023354,-0.0034253546,0.018762298,0.0056230794,-0.007320337,-0.014778239,0.0037849674,-0.011998226,-0.0013955135,-0.010583389,0.002449722,-0.01599842,-0.004230012,-0.00605641,-0.008918248,-0.01731256,-0.009097519,-0.004668188,-0.0047225123,-0.009578659,-0.007702579,-0.013372731,-0.0047658305,0.0003470195,-0.00093407836,0.008702392,-0.0022728757,0.0065043606,-0.011930367,-0.0071381712,-0.012910402,-0.0032298544,-0.0050030868,0.001889719,0.006834621,-0.002357001,-0.004337235,-0.019483898,0.002143811,0.008533681,-0.0069363373,-0.0319446,-0.0011465341,0.005366256,-0.005485015,-0.010402796,-0.00167298,0.0009391475,0.02286189,0.00853574,0.011433472,0.0011119526,-0.0015590672,-0.002582029,-0.001049301,0.00074376754,0.024733199,0.0007819081,-0.008065048,-0.0010109143,0.00020477995,0.017659044,0.0069637843,0.00024871706,-0.00266832,-0.0055109416,0.0001188892,-0.0023007034,0.008386957,0.0049450677,-0.0076488885,0.0019237966,-0.016117943,-0.010318756,-0.004193172,-0.0011782107,0.0052119237,5.099874e-05,-0.009528664,6.753498e-07,0.0031861966,-0.0006990709}, {7,6,0,7,7,6,3,6,6,7,7,0,7,6,1,6,0,7,2,7,7,0,7,0,3,1,6,0,1,6,7,7,7,1,7,6,255,255,0,0,255,3,255,3,3,7,0,1,2,255,0,2,1,0,3,1,3,7,3,0,1,0,7,6,7,0,0,255,255,7,2,255,255,0,1,255,255,3,7,0,7,0,6,1,255,0,0,3,1,0,255,255,255,1,6,255,0,0,3,0,2,255,255,3,1,7,1,0,255,255,255,1,255,7,7,255,3,7,6,6,7,0,7,1,6,255,0,6,255,0,255,3,0,6,255,0,2,255,255,255,2,0,0,2,7,6,255,255,255,255,6,0,2,3,0,255,255,3,255,255,3,7,255,3,255,2,6,255,255,0,2,0,2,0,6,6,6,255,255,255,1,255,255,2,7,1,3,0,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,65535,73,75,65535,77,65535,79,81,83,85,87,89,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,65535,65535,125,127,65535,65535,129,131,65535,65535,133,135,137,139,141,143,145,65535,147,149,151,153,155,65535,65535,65535,157,159,65535,161,163,165,167,169,65535,65535,171,173,175,177,179,65535,65535,65535,181,65535,183,185,65535,187,189,191,193,195,197,199,201,203,65535,205,207,65535,209,65535,211,213,215,65535,217,219,65535,65535,65535,221,223,225,227,229,231,65535,65535,65535,65535,233,235,237,239,241,65535,65535,243,65535,65535,245,247,65535,249,65535,251,253,65535,65535,255,257,259,261,263,265,267,269,65535,65535,65535,271,65535,65535,273,275,277,279,281,283,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,65535,74,76,65535,78,65535,80,82,84,86,88,90,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,65535,65535,126,128,65535,65535,130,132,65535,65535,134,136,138,140,142,144,146,65535,148,150,152,154,156,65535,65535,65535,158,160,65535,162,164,166,168,170,65535,65535,172,174,176,178,180,65535,65535,65535,182,65535,184,186,65535,188,190,192,194,196,198,200,202,204,65535,206,208,65535,210,65535,212,214,216,65535,218,220,65535,65535,65535,222,224,226,228,230,232,65535,65535,65535,65535,234,236,238,240,242,65535,65535,244,65535,65535,246,248,65535,250,65535,252,254,65535,65535,256,258,260,262,264,266,268,270,65535,65535,65535,272,65535,65535,274,276,278,280,282,284,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3767,2864,3782.5,1720.5,2585,688.5,30208.5,411,2030,3900.5,1968,5083.5,803,9692,28576.5,125.5,486,1726,2349.5,1365,2390,2918.5,5389,484.5,4471.5,5476,6799,8930.5,9380.5,-0.011119962,28898.5,100.5,133.5,4000.5,916.5,1470,2264.5,2269.5,4680.5,-0.033077233,3750.5,-0.0030353644,-0.009082649,550,4258.5,12651.5,1905.5,-0.0080786515,178,201.5,252,264.5,0.010143205,4728.5,2852.5,8741.5,11579.5,17693,21348.5,0.0072638923,30241.5,43,25,137,258.5,341.5,350.5,981,883,650.5,0.014673049,2224.5,1774,2667,4049.5,3229.5,5381.5,-0.018256793,-0.022882706,-0.013921792,2794.5,1651.5,3287,4530.5,-0.014291515,8347,4863.5,34,0.0093312515,-0.024586888,-0.013566663,244.5,4802.5,1305.5,0.0015349328,27901.5,6672,-0.0066047125,7934,5850,8343,7011.5,-0.019315336,28360,22013.5,19383.5,14004,0.005317421,18812,33.5,62,0.006170639,76.5,0.04959237,131,284,262.5,422.5,340.5,364,523.5,1942.5,1160,780,769.5,0.016400255,0.023080291,-0.002378377,1629,-0.0065436475,2160.5,3290.5,2421,3933,-0.032971572,237.5,842,-0.028425485,6276.5,0.004993672,0.016554674,3452,1909,1312.5,9107,4164.5,7495,5185.5,2307.5,3549,10538,0.002568441,0.0039454573,0.008455898,579.5,-0.0017930608,694.5,933.5,0.003979,3488.5,3292.5,3775,0.0009271116,2757,0.0011214811,6293.5,9361.5,6334,10067,5421,8421,9357.5,14370.5,0.010285664,0.004484636,16680,12949.5,10219,23190,17398.5,25664,0.0009224677,-0.0030326967,0.0022768865,0.008680119,-0.021321945,-0.0071984353,0.008756898,0.023674568,-0.004658516,0.00975288,0.05538539,0.0073934756,-0.007981598,-0.024505688,-0.027955202,-0.012449554,0.004034999,-3.8542315e-05,-0.002088502,-0.003506053,-0.0007341285,0.010394028,0.020492284,0.006811674,-0.00062222703,0.0075942436,-0.012750402,-0.003545705,0.015032254,0.008064007,0.0020796126,-0.0035492696,-0.004961603,0.002396861,0.006001673,0.0007131658,-0.012529387,-0.000114901064,-0.0036547512,0.0057619265,-0.0014538752,-0.007267551,-0.009718756,0.0008477196,-0.020633208,-0.012792039,-0.0067550377,-0.010261146,-0.011474597,-0.0045179585,-0.017563881,-0.010174043,-0.0017412018,-0.0091647515,0.003799986,-0.0031626483,-0.009882159,-0.005242321,-0.008078805,-0.011369041,-0.0035711296,-0.0064682127,0.00084673165,-0.0030185718,-0.0019658345,-0.00012663045,-0.00065681787,-0.016425679,0.0051982747,0.008417225,0.0024272178,-0.00039128476,0.0036394354,-0.0032250118,0.007818572,0.0032595594,-0.0032564048,-0.002086994,-0.0013523843,0.0014762952,-0.0022162206,-0.00031956966,-0.0027084197,-0.028061254,-0.0017016142,-0.012323192,-0.0015234553,0.006336201,-0.019422134,0.0007931903,-0.0029839738,-0.015222584,-0.02318477,-0.005502855,-0.0009030128,-0.013345109,-0.002139602,0.013994935,0.0017613814,-0.005766886,-0.007189174,-0.0014267167,0.001224392,0.0017662175,-0.0003846587,-0.00072322454}, {7,6,2,7,0,0,7,6,6,6,7,6,3,6,5,7,7,0,7,7,0,0,6,2,5,0,6,7,3,255,5,6,7,5,6,0,7,7,2,255,6,255,255,3,6,0,5,255,0,0,0,3,255,6,2,7,0,5,6,255,7,7,3,6,7,5,3,7,2,0,255,3,6,6,3,7,2,255,255,255,0,7,5,5,255,0,3,0,255,255,255,2,5,0,255,3,0,255,6,6,3,0,255,6,5,2,7,255,6,6,0,255,0,255,7,5,7,7,7,7,6,2,0,0,7,255,255,255,6,255,0,5,0,5,255,2,0,255,3,255,255,0,7,5,2,3,2,2,3,3,0,255,255,255,2,255,2,0,255,3,0,2,255,0,255,5,0,2,0,0,5,3,7,255,255,3,7,7,6,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,65535,59,61,63,65,67,69,71,73,75,65535,77,65535,65535,79,81,83,85,65535,87,89,91,93,65535,95,97,99,101,103,105,65535,107,109,111,113,115,117,119,121,123,125,65535,127,129,131,133,135,137,65535,65535,65535,139,141,143,145,65535,147,149,151,65535,65535,65535,153,155,157,65535,159,161,65535,163,165,167,169,65535,171,173,175,177,65535,179,181,183,65535,185,65535,187,189,191,193,195,197,199,201,203,205,207,65535,65535,65535,209,65535,211,213,215,217,65535,219,221,65535,223,65535,65535,225,227,229,231,233,235,237,239,241,243,65535,65535,65535,245,65535,247,249,65535,251,253,255,65535,257,65535,259,261,263,265,267,269,271,273,65535,65535,275,277,279,281,283,285,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,65535,60,62,64,66,68,70,72,74,76,65535,78,65535,65535,80,82,84,86,65535,88,90,92,94,65535,96,98,100,102,104,106,65535,108,110,112,114,116,118,120,122,124,126,65535,128,130,132,134,136,138,65535,65535,65535,140,142,144,146,65535,148,150,152,65535,65535,65535,154,156,158,65535,160,162,65535,164,166,168,170,65535,172,174,176,178,65535,180,182,184,65535,186,65535,188,190,192,194,196,198,200,202,204,206,208,65535,65535,65535,210,65535,212,214,216,218,65535,220,222,65535,224,65535,65535,226,228,230,232,234,236,238,240,242,244,65535,65535,65535,246,65535,248,250,65535,252,254,256,65535,258,65535,260,262,264,266,268,270,272,274,65535,65535,276,278,280,282,284,286,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5.5,4470.5,32387,9803.5,7733,9756.5,9988.5,5271.5,4.5,1.5,6255,15.5,12.5,12.5,23861,722.5,1598,2126,4092.5,9207.5,5365,5456.5,6512.5,3759.5,3813,6813,3620.5,2783.5,18.5,19.5,30946,102.5,2.5,1443,6829.5,0.013672347,3644.5,2473.5,3388.5,11486.5,9954.5,5680,7551,4430,4.5,9442.5,6765,228.5,3805,805.5,10375.5,8.5,30830.5,15.5,15631,0.0023481068,3001.5,3193,3086.5,19759,-0.0038160135,-0.004177363,30323.5,37.5,621.5,3487,4.5,0.0014213576,1.5,5063.5,0.00875789,3329.5,14493.5,-0.0068830843,13737.5,0.004927048,-0.0002951694,4781.5,-0.0032762946,-0.011080762,9247,5206,4981,5569,7580.5,9994,4541,11382.5,10576.5,9218,4.5,6577.5,1.5,129,12.5,6277.5,4566.5,409,7497.5,18.5,10978.5,5889,10722.5,17823.5,18564.5,3543.5,8665,13703,13814.5,0.0016126856,-0.003229544,3175,0.0026391593,0.007823544,0.012558254,18812,15.5,29650.5,30001.5,74,62,411,695.5,2146,5536,2448.5,5074,-0.025606824,8465.5,2071.5,1988.5,2.5,11847.5,5982.5,0.0070570777,2617,-0.0027571868,-0.0019769042,8287.5,0.0027193518,5309.5,5266,989,6481,8343,5221.5,7937,5985,7761.5,4.5,-0.009639765,0.01347812,1.5,8666,6563.5,9698.5,-0.007942545,0.011857159,3.5,10274.5,10274.5,6569,10596.5,32327,7312.5,126.5,344.5,7068.5,2107.5,6.5,3780.5,2958,7.5,134.5,662,18.5,2777,1397.5,4054,18.5,18.5,11691.5,11501,5761,6255,13528,26229.5,30504,8.5,10861.5,-0.004847152,-0.0141735915,18.5,10584,12620,17856,16506.5,2783.5,0.008030525,13.5,-0.000706971,0.0016956646,0.0010138022,29493.5,29707,30544,15.5,0.0008267195,-0.026779894,0.013189405,0.001445703,-0.007327664,-0.014548071,0.0024963557,-0.012150526,0.00056250126,-0.013403326,0.005492127,-0.0023777932,0.013112823,0.0013885832,-0.0017513616,0.005854694,-0.012581428,-0.020139882,0.0037196905,-0.0035744484,-0.015362482,-0.006761716,0.0032303338,0.0058918186,0.015087952,0.0030030345,0.0014893377,-0.003214835,-0.0030312033,0.0005416905,0.010865138,0.002973156,0.0057359478,0.009056366,0.0035902963,0.012488293,0.006898345,0.0007221228,0.0010091563,-0.0029405262,0.011230381,0.0043022926,-0.00043882398,0.005312349,-0.0035174687,0.0032945462,0.00916701,-0.0050102146,0.02049412,0.004488548,-0.0010265252,-0.008718283,-0.0014643789,0.00345471,-0.002714413,-0.011150069,-0.005946358,-0.00066254626,0.0012751268,0.016656581,0.029902829,0.016496604,-0.009340282,0.0065944046,0.017426623,0.0035270804,-0.003401132,0.02122636,-0.014124276,-0.002643406,0.0031656933,-0.0012244602,0.004720192,-0.00032494983,-0.0017967703,-0.018827526,0.025443245,0.0025353704,-0.008053247,-0.0024879612,0.00020222641,-0.0024855963,-0.002061495,0.004123915,-0.010859466,-0.0015451543,-0.00071469066,-0.005907819,-0.00012926204,-0.0024158086,0.000554347,0.01519371,-0.0027056828,-0.013993471,0.0040285066,0.012378379,-0.015215049,-7.8482764e-05,-0.005981767,0.00054492615,0.0014082295,-0.0027504335,0.0016388582,0.004262361,-0.004461933,-0.0072835223,-0.00403789,-0.0004328255,0.0014854022,-0.0050073704,-0.0041767335,-0.008461419,-0.0045695514,0.00023930697,-0.00086617935,-0.008921331,0.0013043005,-0.0038541013,-0.0045668846,-0.0024043012,-0.0009354918,-0.001777974,-0.008560645,-0.012361839,-0.0046721855,-0.0071855746,-0.0014975341,-0.005833334,0.0043262034,-0.007184452,-0.0070673907,0.0038333887,-0.013093305,-0.0028558488,0.0061969957,0.004151774,0.0007669251,0.00029867006,-0.0005248413,-4.4952826e-06,-0.0021332006,-0.00042523872,0.0010314864,0.0004006406,-0.00018925066,0.00023524354}, {8,5,3,6,4,6,0,4,8,8,5,8,8,8,0,5,5,3,3,6,3,3,5,3,6,3,3,6,8,8,5,0,8,5,3,255,5,5,5,3,6,0,4,3,8,4,5,0,3,3,3,8,0,8,0,255,0,0,6,0,255,255,4,3,3,6,8,255,8,6,255,5,0,255,6,255,255,5,255,255,3,5,6,5,0,4,5,0,0,4,8,5,8,3,8,0,3,4,0,8,4,5,6,6,5,5,4,0,3,255,255,6,255,255,255,6,8,4,0,4,6,6,5,6,0,3,3,255,0,5,3,8,6,0,255,5,255,255,0,255,5,0,3,4,0,4,5,6,3,8,255,255,8,6,3,0,255,255,8,4,4,5,0,3,5,3,4,0,4,8,3,4,8,5,3,8,5,0,0,8,8,4,4,5,5,5,5,4,8,0,255,255,8,0,3,5,4,6,255,8,255,255,255,4,4,4,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,109,111,113,115,65535,65535,117,119,121,123,125,65535,127,129,65535,131,133,65535,135,65535,65535,137,65535,65535,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,65535,197,65535,65535,65535,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,65535,235,65535,65535,237,65535,239,241,243,245,247,249,251,253,255,257,65535,65535,259,261,263,265,65535,65535,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,65535,65535,331,333,335,337,339,341,65535,343,65535,65535,65535,345,347,349,351,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,110,112,114,116,65535,65535,118,120,122,124,126,65535,128,130,65535,132,134,65535,136,65535,65535,138,65535,65535,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,65535,198,65535,65535,65535,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,65535,236,65535,65535,238,65535,240,242,244,246,248,250,252,254,256,258,65535,65535,260,262,264,266,65535,65535,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,65535,65535,332,334,336,338,340,342,65535,344,65535,65535,65535,346,348,350,352,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4.5,2372,372,7057.5,3673,129,236.5,722.5,1341.5,2445,4464.5,998,326,12.5,32020.5,99,2.5,8733,2013.5,6891,3911,4360.5,5365,101.5,18.5,266.5,17,6.5,17.5,892.5,31132.5,32.5,525.5,1604,2538.5,1040.5,-0.0040993243,1.5,2127.5,6994,9109,3329.5,10830,3959,4537,5282,6569.5,83.5,22.5,1377.5,1449,683,105.5,370,0.04179188,564.5,349,231,204,819.5,1753,11.5,17.5,27.5,132,505,590.5,1134,2888.5,1580,3889.5,0.007984094,0.0037089915,-0.023334948,1474.5,2343.5,9800.5,488,0.010577789,2.5,0.0024623224,5526.5,3188,6693.5,0.0083050765,6296,4332.5,2.5,4428.5,4454,10022.5,5623,6572,116.5,0.02091691,14.5,27,1124.5,190,0.062316712,52.5,204,18.5,13,359.5,0.0242076,0.013792607,-0.012880713,-0.006599597,158,-0.025107611,158,-0.013841654,564,180.5,235,20.5,12.5,2479,19239.5,18.5,24705,24711.5,38.5,37,61.5,2.5,129,1.5,497.5,747,1239,1250.5,4440,4001.5,1175.5,2091.5,3009,-0.007828332,-0.003083161,3.5,7790,-0.0071131787,1.5,2236,0.010064308,4748.5,-0.021214915,-0.011489542,3552.5,2715.5,3734.5,3508.5,3503.5,-0.006783264,5131,2.5,11839.5,4580,-0.013359073,-0.008694591,0.005770663,-0.006496813,4882.5,4764,5287,0.0027208559,5722,9516,0.019293083,32413,12.5,32.5,114,186.5,-0.028565004,74.5,9.5,22,0.012696146,11.5,-0.0076480107,0.011995257,170.5,19.5,57,690.5,-0.020392595,-0.007647215,153.5,0.008734874,-0.017895965,-0.01299617,-0.008461134,-0.004181838,-0.00832219,178.5,-0.001956838,0.0010381452,137.5,282,1584,1292.5,1287,3123,731.5,8264.5,-0.0036074375,27504,23411,0.007333915,3109.5,29384.5,19346,29705.5,0.00020331182,-0.005091845,-0.0015430283,-0.018394582,0.011952763,0.0025703611,-0.012774956,-0.0011772765,-0.013182776,-0.0011394569,-0.0058515253,-0.016393239,-6.439466e-05,0.0077554,-0.010312768,-0.0035380248,0.0033900917,-0.012321588,0.018378653,0.0063725323,-0.017115615,0.005419001,0.0020200892,-0.012537695,0.01611745,-0.00029064904,-0.00069074176,0.02819627,-0.0012252475,0.004021287,-0.014248279,-0.009361793,0.02642478,0.0064650723,-0.00295098,-0.011686942,0.0018147074,0.0067240656,-0.00073973165,-0.007413264,-0.0024243975,0.00714923,0.0077099386,0.003009618,0.0010965526,0.004421394,0.01701074,0.007611307,-0.005112242,0.0018299429,-0.0009937311,-0.0069101597,-0.0038002282,0.00068586663,0.003733322,0.015381353,-0.0039305133,0.00026303343,-0.0032299769,0.0042580487,0.008508853,0.0029961152,0.002985436,0.011687456,0.004320378,-0.008090912,-0.005402099,0.004871511,0.0007828881,-0.00088594895,-0.0016966107,0.0005464951,-0.016820585,-0.004362983,0.006968503,-0.005837041,0.0045876997,0.009363638,0.002904784,-0.006165262,-0.004183823,-0.008443448,-0.007638036,0.0027902492,0.0057932893,0.0013939854,0.012629113,0.044534683,0.0048730783,0.02587691,0.008706694,0.0019733836,-0.0009824702,-0.010950061,0.0046762596,-0.0018172277,-0.00066741166,-0.005343484,0.050378233,0.0017523814,-0.016650101,-0.0013149449,0.0060425657,-0.0036090568,0.07084743,0.04396897,-0.013650179,-0.004009775,0.0015308446,-0.0053746453,0.011376966,0.0008891444,-0.001007773,-0.0021048842,0.0017795799,-0.0007681976,0.0064084344,0.0019413651,-0.0010630175,0.0011175569,-5.7279754e-05,-0.0005715241,0.0029475999,-0.0042214454,-0.00072055997,-9.205145e-05}, {8,7,2,2,5,3,3,5,7,3,5,1,3,8,5,2,8,2,7,2,1,5,3,1,8,2,8,8,8,2,1,3,3,2,1,7,255,8,7,7,2,5,2,7,3,3,1,1,7,7,1,7,7,1,255,2,7,5,3,3,3,8,8,1,1,2,5,1,1,3,3,255,255,255,1,5,2,5,255,8,255,2,1,7,255,2,7,8,5,7,1,5,1,2,255,8,7,1,5,255,2,1,8,8,2,255,255,255,255,5,255,5,255,2,5,5,8,8,2,7,8,2,2,7,2,7,8,3,8,7,7,2,1,2,2,7,2,3,255,255,8,2,255,8,7,255,7,255,255,1,3,7,7,7,255,2,8,2,7,255,255,255,255,1,7,1,255,1,3,255,1,8,3,1,1,255,3,8,2,255,8,255,255,1,8,1,5,255,255,5,255,255,255,255,255,255,3,255,255,1,3,5,7,5,2,7,2,255,3,1,255,2,2,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,65535,65535,65535,139,141,143,145,65535,147,65535,149,151,153,65535,155,157,159,161,163,165,167,169,171,65535,173,175,177,179,65535,181,183,185,187,189,65535,65535,65535,65535,191,65535,193,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,65535,65535,245,247,65535,249,251,65535,253,65535,65535,255,257,259,261,263,65535,265,267,269,271,65535,65535,65535,65535,273,275,277,65535,279,281,65535,283,285,287,289,291,65535,293,295,297,65535,299,65535,65535,301,303,305,307,65535,65535,309,65535,65535,65535,65535,65535,65535,311,65535,65535,313,315,317,319,321,323,325,327,65535,329,331,65535,333,335,337,339,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,65535,65535,65535,140,142,144,146,65535,148,65535,150,152,154,65535,156,158,160,162,164,166,168,170,172,65535,174,176,178,180,65535,182,184,186,188,190,65535,65535,65535,65535,192,65535,194,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,65535,65535,246,248,65535,250,252,65535,254,65535,65535,256,258,260,262,264,65535,266,268,270,272,65535,65535,65535,65535,274,276,278,65535,280,282,65535,284,286,288,290,292,65535,294,296,298,65535,300,65535,65535,302,304,306,308,65535,65535,310,65535,65535,65535,65535,65535,65535,312,65535,65535,314,316,318,320,322,324,326,328,65535,330,332,65535,334,336,338,340,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6919.5,12.5,2.5,2359,10423.5,31938,6853,63.5,5732,3744,5771,24845.5,3287.5,18.5,30787,25.5,6.5,1.5,10432,17.5,18.5,10977,10068,7916,1.5,-0.0074772784,29645,8926,7143.5,7052,12.5,35.5,62,2.5,6438,5080,5531,4501.5,4.5,204,3804.5,2171.5,7130,4524,3932.5,-0.015656253,12633,1.5,11620.5,27392.5,28645.5,29863.5,29725.5,6817.5,-0.017244501,2095.5,-0.0037410476,7891.5,27166.5,18539,22571,30,-0.01627747,3.5,95.5,8550.5,7323,1203,7.5,10016.5,5530.5,5199,6035,2861.5,6509.5,4493,6322,158,486,542,0.027939046,8443.5,4522,1635,7711.5,3437.5,4886,15.5,5727.5,6556,24675,8305,7951,11989,21851.5,25824.5,31310.5,27811.5,30868,29102,1.5,29723.5,30210.5,15.5,0.010942375,0.023527427,5577,6942,19.5,29517.5,14019,23629,5.5,16959,27921,26.5,6.5,46,56,75,7.5,7137,7484,778,2168.5,486,1191,9208,9746.5,5511,0.009553784,5261,0.004087115,2208.5,4982.5,5587,7310.5,7599.5,3222,6482,6126.5,1.5,6814,4843,12013.5,60,15.5,1579.5,1733.5,812,30,17.5,9091.5,9822,7198,-0.01668659,3813,6407.5,6985,-0.011092051,3044,0.0075402632,0.0021576085,3326,11800.5,18.5,-0.019388461,12025,15.5,15402.5,0.0056406665,7580.5,10627.5,5914.5,8143,6768,22788,1.5,19240.5,0.014651762,0.023295656,30338,30277,0.0028151197,-0.007873013,30375.5,0.0011513574,24739,29606,7.706295e-05,-6.344367e-06,29707,0.0005735824,30317,1.5,7195,7680,6367.5,6561.5,6927,7096,6905.5,0.0066417516,13832,20286.5,28005,22838.5,-0.01136434,8.5,18611.5,8.5,15.5,16.5,15.5,30277,-0.0018742165,-0.0037125845,0.011536129,0.0075463178,0.004044481,0.012615656,0.0030561257,-0.0024111255,-0.002014968,-0.016487971,0.0008100817,0.004272678,-0.0057538874,-0.016307713,0.012900861,-0.002479387,-0.004749074,0.0047368915,-0.0020327915,-0.0076232734,-0.0054523656,0.0049239667,-0.00031335006,-0.016996311,0.0018013802,-0.008252582,-5.0741375e-05,-0.004605105,0.004898585,-0.0021533945,0.006866943,0.016533405,0.0069532855,-0.0010563232,-0.002526547,0.0038061352,-0.00401698,0.0021053918,-0.023111505,-0.0041397917,-0.005091028,0.0024749322,-0.012014284,-0.004853849,-0.0014960474,0.029671509,0.0011208222,-0.0062117665,0.0006174315,0.0060852687,0.006680723,-0.00021163932,-0.002003487,-0.006295921,0.0050472803,-0.0017489393,-0.0014384314,0.0020742563,0.009512107,0.014908418,-0.0035338632,-0.014801099,0.0032654048,-0.0016978557,0.0007854447,-0.008909411,0.03776936,0.0041043493,-0.002496241,0.0023573409,-0.01611571,-0.0067562894,0.0012075709,-0.0059656454,-0.002795595,-8.5143656e-05,0.0017812547,-0.003039585,0.010582882,-0.010712983,-0.008304832,-0.00025867397,-0.0033273895,-0.0075030103,-0.010253272,-0.0053155622,-0.0086699575,-0.004056838,-0.009445948,-0.012683372,-0.0012159297,-0.0054043466,-0.0021975802,-0.0069115297,0.0014710965,-0.0021169966,0.008234954,0.016716762,-0.009386716,0.008124096,0.0034957414,-0.005005874,0.007971196,0.0015700739,-0.010105626,0.0034973547,-0.008848487,0.0018055801,0.008605278,0.00024993857,-0.00013207732,0.0029928107,0.009255026,0.0034288696,0.0007783943,2.1529797e-05,0.010330943,0.004702588,-0.0009974027,-0.000107233354,-0.0016339002,-0.0005693121,-0.0022618303,-0.0010709434,-0.0022099835,-0.0006588451,-0.0013905369,-0.0007247811,-0.0014801151,0.0016295396,0.0010006955,0.0067235283,0.009133159,-0.0036439497,0.019972427,0.008339531,-0.011686331,-0.0027260107,-0.016249942,-0.02762412,5.0490762e-05,-0.0029487626,-0.00060774497,-0.0021119888,-0.0032717406,0.01824511,-0.0026206125,-0.02102725,0.017235251,-6.966766e-05,-0.0015008453,-0.0027150118,-0.001154938,0.00034767212,-0.0006390488,-0.0012995044,-0.004093414,-0.00631177,-0.00236926,-0.003710057,-0.0021784434,-0.0013160993,0.00030952133,-0.00024792482}, {7,8,8,5,6,5,6,0,6,4,7,7,4,8,6,7,8,8,4,8,8,0,0,0,8,255,4,4,4,6,8,4,6,8,4,7,7,7,8,0,5,7,5,5,7,255,4,8,7,0,6,6,0,6,255,0,255,7,0,5,7,4,255,8,5,0,6,6,8,5,7,6,0,5,5,5,5,0,7,0,255,6,5,0,4,0,5,8,7,7,4,4,7,4,6,4,0,7,0,4,8,0,0,8,255,255,4,6,8,6,7,0,8,5,5,0,8,7,4,4,8,0,6,7,7,7,0,0,0,0,255,6,255,4,7,4,5,0,7,5,6,8,6,7,4,6,8,4,6,4,6,8,4,6,4,255,6,7,0,255,5,255,255,5,0,8,255,0,8,4,255,0,7,4,6,5,0,8,7,255,255,5,5,255,255,5,255,0,4,255,255,4,255,4,8,5,7,6,6,6,4,6,255,7,7,6,6,255,8,7,8,8,8,8,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,65535,105,65535,107,109,111,113,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,65535,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,65535,245,65535,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,65535,291,293,295,65535,297,65535,65535,299,301,303,65535,305,307,309,65535,311,313,315,317,319,321,323,325,65535,65535,327,329,65535,65535,331,65535,333,335,65535,65535,337,65535,339,341,343,345,347,349,351,353,355,65535,357,359,361,363,65535,365,367,369,371,373,375,377,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,65535,106,65535,108,110,112,114,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,65535,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,65535,246,65535,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,65535,292,294,296,65535,298,65535,65535,300,302,304,65535,306,308,310,65535,312,314,316,318,320,322,324,326,65535,65535,328,330,65535,65535,332,65535,334,336,65535,65535,338,65535,340,342,344,346,348,350,352,354,356,65535,358,360,362,364,65535,366,368,370,372,374,376,378,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2616,209.5,3590,114.5,180,2889.5,31193.5,137.5,39.5,2915.5,217.5,436.5,7672.5,10986,18707,109.5,33.5,41.5,165.5,181.5,7665,0.04467112,520.5,0.00076964474,901.5,3301,4435,9058.5,13122.5,30717.5,19132,102,183,39.5,61,58.5,194.5,143.5,183,537.5,190.5,0.0084942,25496.5,279,517,0.014709708,1938.5,29.5,6787.5,-0.012079611,6184.5,1987,10982,14011,14063,18759.5,17110,17227.5,19844,20.5,91.5,0.018671049,524,1405.5,284.5,12118,1129,-0.018421564,33.5,0.004495488,-0.0021096687,119.5,0.037723422,173,386,26.5,589,0.0023905905,878.5,18457.5,-7.870007e-05,186,415,529.5,1963.5,0.00031135214,0.009239287,1201.5,44.5,3916.5,3903.5,0.0071617975,2052,739.5,9093.5,9361,-0.020196851,10653.5,16579,27929,18831.5,-0.0072427876,20484,11039,19477,19015.5,19881.5,19313.5,19849.5,22,22.5,46.5,83.5,237,0.007653383,0.0145016555,0.0076386514,-0.00237231,1212,65.5,-0.0011660864,79.5,-0.018955367,-0.0054310276,-0.014803096,0.019700995,431,0.0043314598,-0.00069065765,0.017439483,0.0068528326,62,347,-8.9333815e-05,861.5,-0.008521192,-0.003226208,8541,-0.007929581,211,221.5,466,485.5,-0.038819183,301,1477.5,1043.5,0.007295672,0.0050284583,-0.015566962,3146.5,4608,0.002871787,-0.0018505832,0.0010214561,9188.5,9782,9287.5,5965.5,9082,8707.5,6340.5,6392,10604,8237,11596,19829.5,13823.5,14823.5,10899.5,20652,-0.0040803845,-0.0017135857,31644,12687,32488.5,23406.5,-0.0027752195,-0.003957866,19509,18771.5,19703.5,19593,-0.010134861,22498.5,-0.002686266,-0.0006649048,0.008749048,0.0008351248,-0.011469955,-0.022497127,0.009486323,-0.0062931515,-0.0033558495,0.0051411334,0.0037964575,0.00230826,-0.026526326,-0.0062985294,0.0047486383,-0.0062162066,0.007452423,0.017425308,-0.010817995,0.003754271,-0.0060156975,-0.009730685,-0.0074464097,-0.004069328,-0.0016149767,-0.00350981,0.0018828687,0.00954993,-0.002675101,-0.009410891,0.01740969,0.010101489,-0.0012343122,0.012100252,-0.0039791246,-0.010749961,-0.0015314267,0.0044659,-0.012659082,-0.002567902,0.0011363891,-0.00084449176,0.0070185713,0.011316577,-0.0049507176,-0.007925072,-0.004208584,-0.0016998881,-0.0012049704,0.005915762,-0.002737821,-0.010310734,-0.0005240886,-0.028458983,0.0026803925,-0.0008140861,-0.0042239525,-0.010099599,-0.0027633032,-0.0011375103,0.0021507146,0.00024815922,0.00020920251,-0.009043737,0.001593863,0.025558565,-0.009154923,0.00059625454,0.00045583752,-0.0035535346,-0.021126525,-0.0035187725,0.0022983567,-0.006444478,0.012949663,-0.00034301716,-0.006046385,-0.004420282,-0.0024748126,-0.004304429,-0.0025780627,-0.0016534126,-0.0036530786,0.0014499155,-0.0015023265,-0.0026658075,0.00268842,0.0008880465,-0.0012468024,-0.0019056656,0.00169738,5.0798513e-05,-0.0014367242,-0.00062448205}, {7,2,4,2,5,7,0,0,1,2,4,0,0,1,7,5,4,7,2,7,0,255,4,255,2,4,1,0,1,2,1,4,4,2,4,0,5,2,2,4,7,255,0,5,5,255,4,2,2,255,2,1,1,0,1,1,1,5,1,7,0,255,4,0,0,0,4,255,7,255,255,2,255,0,0,7,2,255,0,0,255,7,4,4,4,255,255,0,2,5,0,255,4,2,1,0,255,0,0,0,0,255,1,7,1,1,7,5,1,0,7,0,2,5,255,255,255,255,0,2,255,4,255,255,255,255,0,255,255,255,255,5,2,255,2,255,255,0,255,5,5,7,4,255,5,1,5,255,255,255,4,0,255,255,255,0,0,7,7,1,0,7,1,5,7,1,0,5,7,2,0,255,255,0,5,4,1,255,255,7,1,1,5,255,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,65535,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,83,65535,85,87,89,65535,91,93,95,97,99,101,103,105,107,109,111,65535,113,115,117,119,121,65535,123,65535,65535,125,65535,127,129,131,133,65535,135,137,65535,139,141,143,145,65535,65535,147,149,151,153,65535,155,157,159,161,65535,163,165,167,169,65535,171,173,175,177,179,181,183,185,187,189,191,193,65535,65535,65535,65535,195,197,65535,199,65535,65535,65535,65535,201,65535,65535,65535,65535,203,205,65535,207,65535,65535,209,65535,211,213,215,217,65535,219,221,223,65535,65535,65535,225,227,65535,65535,65535,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,65535,65535,261,263,265,267,65535,65535,269,271,273,275,65535,277,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,65535,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,84,65535,86,88,90,65535,92,94,96,98,100,102,104,106,108,110,112,65535,114,116,118,120,122,65535,124,65535,65535,126,65535,128,130,132,134,65535,136,138,65535,140,142,144,146,65535,65535,148,150,152,154,65535,156,158,160,162,65535,164,166,168,170,65535,172,174,176,178,180,182,184,186,188,190,192,194,65535,65535,65535,65535,196,198,65535,200,65535,65535,65535,65535,202,65535,65535,65535,65535,204,206,65535,208,65535,65535,210,65535,212,214,216,218,65535,220,222,224,65535,65535,65535,226,228,65535,65535,65535,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,65535,65535,262,264,266,268,65535,65535,270,272,274,276,65535,278,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,4022.5,31129,9803,6080,10956,18118,5318.5,4.5,5550.5,6287,15.5,11456.5,15.5,12.5,552.5,5067,13052.5,2573,4742.5,5751,6978,5937.5,561.5,8076.5,11616.5,3292.5,12687,16286,19177,22899.5,104.5,2.5,1978,10669.5,9878,2.5,10666,13358,5284.5,5176.5,5741.5,7169.5,5971,2.5,6363,5079.5,118,2106,3744,15059,14065,11812.5,13599.5,27166.5,12042.5,16286,12687,16926,18145.5,8.5,17.5,29659,137.5,119,1.5,4.5,5.5,2092.5,8223.5,-0.013322021,0.0113839125,2869.5,11615,3434.5,2251.5,-0.006131517,3541,27578.5,1137,0.012481943,8759.5,6740.5,-0.020610364,4.5,5840.5,0.016590536,6174.5,6765.5,0.0049048183,0.00075916765,0.015240508,4468.5,4049,17642,60.5,216,12.5,2202.5,1307.5,6975,10006.5,11172,15.5,11290,15.5,13087.5,15.5,15.5,20847,14422,8.5,12.5,12856,30238,12170.5,-0.008580859,18596,17929.5,9.5,29476,18770.5,18719,20728,18564.5,15.5,29556.5,63,28,33.5,348.5,1444,3687.5,3992,1269.5,7099.5,1494.5,8397.5,2009,2.5,3303.5,2.5,4066,1.5,0.004057489,15494,26710,-0.0036556374,0.0010882592,10263.5,-0.0016327901,3203.5,0.0018345773,547,22.5,5612,-0.00054571254,1.5,6095.5,20195.5,6000,10048.5,6256,3.5,0.0041550933,-0.0071763047,-0.01799362,9334.5,9222.5,-0.0041672937,-0.021538971,12287,20330,42,121.5,118.5,559.5,4242,2020,1536.5,18212,1088,2908,5600,8359.5,18.5,9760,10926.5,22391.5,9028.5,5340,7.5,11531,12.5,17.5,16.5,26103.5,3336,2435.5,11.5,3193,19470,32366,27583,24098.5,32040,11409,12744,-0.00094922114,-0.0037093093,-0.0063946135,-0.004324814,17309.5,11055.5,-0.003764191,-0.0038917225,-0.0059971656,19509,-0.006334635,0.00021478278,-0.00024742936,9,17634.5,17697,20580,32488.5,30605,18747,21606,17582.5,20728,23469,25436.5,0.0011469878,30676,0.0006089058,0.009557805,-0.010095558,0.0010845024,-0.027480682,-0.010930799,0.011748045,-0.006755241,0.0055000028,-0.0007910857,-0.0072398917,0.0031394947,0.010973912,-3.2909895e-05,0.001671757,-0.0024036209,0.0027862908,-0.013028179,-0.0009000431,0.0035404207,0.00086577405,0.016383765,-0.011232792,-0.005191355,0.008837528,0.003113114,0.0018491782,-0.0078120413,0.0027803907,0.0045415075,0.009508803,0.0037874512,-0.0034605886,-0.0002869806,0.005927827,0.0014837853,-0.0030488155,0.00022017346,0.0073946523,0.002790382,-0.0016056866,-0.00823228,0.006931163,0.012145249,0.009107882,-0.0012166359,0.005455203,0.009732885,0.008514847,0.0029485237,-0.009695026,-0.003007864,0.0012391509,-0.003904,-0.0077845925,-0.0028359927,0.009216973,0.002664712,-0.01300164,0.002317151,-0.007563084,-0.0020562785,-0.0032809172,0.009389577,0.005821568,0.0007792074,0.00041889522,-0.0042276587,0.0046887263,0.00033246478,-0.0016232021,0.0036826157,-0.0032917417,-0.010685246,0.011065408,0.03620946,0.0011402649,0.02120087,-0.010095808,-0.0018131046,0.00077501126,-0.0026227215,0.00080033066,0.0066320538,-0.0018788286,0.008141198,0.0018771429,-0.005144412,0.009201675,0.0016320319,-0.0003540159,-0.0039265007,0.0037297667,-0.0036460028,-0.0006930365,-0.003448742,-0.0005378068,0.0042659766,-0.007361018,-0.017858302,0.004293861,-0.0030537702,0.0025467216,-0.0007132696,-0.0014343747,0.004013416,-0.0064468808,0.004182243,0.0073230937,0.013861653,-0.0016786531,-0.0033014272,0.0007638659,0.0037849934,-0.006779901,-0.01139841,-0.0035004986,0.0012353387,0.0010021346,-0.003002265,-0.0022576083,-0.0010395023,-0.0001490588,0.0035378828,0.0073628607,0.0126347495,-0.0010428287,0.00859868,-0.0032854967,-0.00032091798,0.0002478787,-0.019606536,0.014668814,-5.3477725e-05,0.00012783553,-0.0019059656,-0.003099502,-0.002091784,0.0014928145,-0.00025806992,-0.0032916688,-0.001923051,-0.007103315,-0.0058330284,-0.00319331,-0.0047069425,-0.0020288716,-0.0030685603,-0.00058046955,-0.0017523573,-0.000505482,-0.0015024006,5.030528e-05,-0.0005050106,-0.002209935,-0.0011644171,-0.0009688001,0.00011270582,-0.0024766717,-0.0016846311,-0.0041124374,-0.002315764,-0.0030670874,-0.004058664,-0.0028382435,-0.004030014,-0.0023218382,-0.0016832644,-0.0010750813,-0.0028893917,0.00011071379,-0.0006440487}, {8,7,0,0,4,3,3,4,8,5,4,8,3,8,8,7,5,0,5,3,4,5,3,0,0,5,0,5,3,3,3,4,8,5,4,0,8,0,0,5,3,5,0,5,8,4,0,5,7,4,4,4,4,7,0,5,3,5,7,3,8,8,7,0,5,8,8,8,5,0,255,255,3,3,3,7,255,3,0,4,255,7,0,255,8,5,255,4,0,255,255,255,5,0,0,7,4,8,4,5,3,5,5,8,3,8,5,8,8,0,5,8,8,3,4,3,255,5,3,8,4,5,7,7,5,8,5,3,5,7,4,4,4,0,4,0,3,0,7,8,3,8,5,8,255,0,0,255,255,4,255,5,255,4,3,0,255,8,7,7,5,3,5,8,255,255,255,4,4,255,255,4,0,7,3,0,0,0,0,4,7,7,7,3,4,8,3,5,4,5,5,8,5,8,8,8,0,4,0,8,0,0,5,4,4,4,3,3,255,255,255,255,7,7,255,255,255,7,255,255,255,8,5,7,3,4,7,5,7,7,7,3,3,255,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,65535,65535,141,143,145,147,65535,149,151,153,65535,155,157,65535,159,161,65535,163,165,65535,65535,65535,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,65535,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,65535,269,271,65535,65535,273,65535,275,65535,277,279,281,65535,283,285,287,289,291,293,295,65535,65535,65535,297,299,65535,65535,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,65535,65535,65535,65535,375,377,65535,65535,65535,379,65535,65535,65535,381,383,385,387,389,391,393,395,397,399,401,403,65535,405,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,65535,65535,142,144,146,148,65535,150,152,154,65535,156,158,65535,160,162,65535,164,166,65535,65535,65535,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,65535,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,65535,270,272,65535,65535,274,65535,276,65535,278,280,282,65535,284,286,288,290,292,294,296,65535,65535,65535,298,300,65535,65535,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,65535,65535,65535,65535,376,378,65535,65535,65535,380,65535,65535,65535,382,384,386,388,390,392,394,396,398,400,402,404,65535,406,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,4506.5,658.5,9809,8005.5,258.5,754,5795,4.5,1.5,17823.5,220.5,262.5,2284.5,30665.5,1011.5,5440.5,14770,8109,8991.5,6207,13815.5,19362,105.5,12.5,0.03863796,1884,661.5,17.5,9840,26037.5,100.5,1899.5,2341,8278,4962,1.5,4962,2694,7390,8595.5,4612,7697,6192.5,8396.5,17519.5,19583.5,33.5,17.5,236.5,228.5,18.5,4060.5,286,18.5,0.0028573032,0.025000421,15.5,14.5,13.5,18812,32.5,40.5,2733.5,3552,4.5,7217.5,3626,5217,3307.5,8991.5,3175.5,3203.5,4311.5,-0.011054553,0.004845237,0.0015327231,5681.5,6171.5,8845.5,11480.5,4.5,6881.5,6638,7039.5,4.5,8326,6868,1.5,14487.5,19195,19572,19884.5,189.5,22.5,1446.5,70,245,408,226.5,268,650,783,-0.01108027,350.5,195,311.5,739,681,1041.5,3498.5,6404.5,9527,0.0017215848,0.0069405786,14.5,17.5,27.5,29.5,116,119,1963,1752,3399.5,4676,2026,3166.5,3.5,1947.5,6686.5,-0.0009979571,1.5,-0.008517672,2.5,3538.5,5613,1.5,-0.0034708164,-0.0065609687,3.5,-0.0013310368,3277,0.0032709688,6227,5780,0.0032340405,7800,-0.019734656,-0.0032770939,11598,-0.003111518,6019.5,5833.5,4974.5,5683,5814.5,5566.5,-0.0102294395,9892,5495.5,5994.5,7016,9015,15013.5,15567.5,11504,13919.5,1.5,16421.5,-0.013235492,0.005058067,-0.006874264,-0.021118736,0.019161526,28996.5,18.5,17.5,33.5,12.5,87.5,5915.5,184,1602.5,180,-0.022177499,262,-0.012115094,164,0.0081801,18.5,-0.00016785106,611,536,622.5,586,356.5,1098.5,12.5,-0.017009817,12.5,591,14.5,12.5,-0.012865803,-0.038613137,1219,1403,688.5,8930.5,6817.5,6488,10757.5,21348.5,3205.5,3205.5,24733,21582.5,0.0009621628,-0.003897812,-0.0005777633,0.009976683,-0.013369637,-0.028594634,-0.0075157285,-0.0025051318,0.0041735526,0.012984729,-0.00238629,0.007814395,-0.0014944429,-0.0060557886,-0.00012115354,0.0062895655,-0.010494911,-0.0059550363,-0.0032356163,-0.010425347,-0.00546965,-0.0028149844,-0.010569084,0.002481034,0.007832789,0.0017863488,0.007697304,0.0014714237,0.0026035418,0.006311358,0.013076672,0.0075506787,0.00028632037,-0.005758818,0.006265886,0.0014441105,0.0038989098,0.0066924356,-0.0012069702,-0.004746593,0.0019769494,-0.008458233,0.0027037605,0.010332951,0.012928574,0.008986992,0.007919738,0.0035367736,-0.0006439795,0.0035582893,0.0010593729,-0.0034301204,0.002937826,0.006844245,0.001966543,-0.010753763,-0.00041458925,-0.011691276,0.0021141376,-0.00092561694,0.011380139,-0.0005869612,0.0020488442,-0.0075531625,-0.0013973311,0.004999596,0.0011434433,0.0062686787,-0.011453416,-8.4778294e-05,0.0001103163,0.0060861646,0.0010703756,-0.005168321,-0.0075559686,0.013370614,-0.004182817,-0.013582395,-0.0027259307,0.005085463,0.021581959,0.015270098,0.00076596736,-0.0005963173,-0.00078320794,0.0023962085,0.0044718655,0.015948849,-0.008489518,-0.02309024,-0.0032433837,-0.0006218536,0.0035923016,0.016981896,-0.0038896222,0.001655632,0.008027239,-0.0021022293,0.041633822,0.0060078334,-0.010179828,-0.002118231,-0.004879327,0.007711035,-0.000695022,-0.0035448242,-0.014432156,-0.0070813545,0.0058330395,0.01860615,-0.0021280437,0.004532873,-0.004173348,0.038142066,0.03822639,0.01693973,0.0052624103,-0.0006023661,-0.0028028202,-0.00037326152,-0.010304167,-0.0009745147,-0.0032724347,0.003238173,-0.0072009214,-0.0012729394,-0.0012015494,-0.014205341,-0.02701864,-0.005341475,0.00048480803,-0.014374049,0.008365742,-0.0019057215,-0.024985418,0.0038324918,-0.0006631922,0.0026090601,-0.003401103,0.00038967282,0.008630287,-0.00080916006,-0.0021926272,-0.0048734564,-7.9542406e-05,-0.0028605582,-0.0021557729,0.00182435,0.00522113,0.0004713329,0.0013604601,-0.00035163594,-0.0040208204,-0.00034959428}, {8,5,6,6,6,7,7,6,8,8,6,6,7,3,1,7,7,6,7,3,1,6,6,7,8,255,5,3,8,6,3,6,7,1,6,7,8,7,1,5,5,1,6,3,1,7,6,6,8,3,5,8,5,7,8,255,255,8,8,8,6,7,7,6,7,8,6,5,1,7,3,7,5,1,255,255,255,3,1,1,7,8,5,1,3,8,7,3,8,3,7,6,6,3,7,1,1,5,3,7,5,1,1,255,3,5,7,7,7,7,6,3,3,255,255,8,8,1,1,6,5,6,7,7,3,1,5,8,5,3,255,8,255,8,3,7,8,255,255,8,255,5,255,1,6,255,1,255,255,3,255,5,6,7,1,7,3,255,1,1,1,5,7,6,6,1,7,8,1,255,255,255,255,255,5,8,8,1,8,1,1,6,3,7,255,3,255,7,255,8,255,1,7,6,6,7,3,8,255,8,7,8,8,255,255,6,6,6,7,5,3,6,6,6,6,6,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,65535,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,65535,65535,65535,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,65535,195,197,199,201,203,205,207,209,211,65535,65535,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,65535,243,65535,245,247,249,251,65535,65535,253,65535,255,65535,257,259,65535,261,65535,65535,263,65535,265,267,269,271,273,275,65535,277,279,281,283,285,287,289,291,293,295,297,65535,65535,65535,65535,65535,299,301,303,305,307,309,311,313,315,317,65535,319,65535,321,65535,323,65535,325,327,329,331,333,335,337,65535,339,341,343,345,65535,65535,347,349,351,353,355,357,359,361,363,365,367,369,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,65535,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,65535,65535,65535,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,65535,196,198,200,202,204,206,208,210,212,65535,65535,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,65535,244,65535,246,248,250,252,65535,65535,254,65535,256,65535,258,260,65535,262,65535,65535,264,65535,266,268,270,272,274,276,65535,278,280,282,284,286,288,290,292,294,296,298,65535,65535,65535,65535,65535,300,302,304,306,308,310,312,314,316,318,65535,320,65535,322,65535,324,65535,326,328,330,332,334,336,338,65535,340,342,344,346,65535,65535,348,350,352,354,356,358,360,362,364,366,368,370,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6825,15.5,3.5,4055.5,3785,31944,4943,372,6535,805.5,18.5,24721.5,29384.5,7233,6465.5,312.5,236.5,6533.5,9603,747.5,1137.5,10794,4150,11616.5,1.5,3269.5,30108.5,17.5,4573,3240,31213,129,430,349,1264,7.5,0.022827206,6900,9621,722.5,4624,1434.5,1195,5188,16724.5,4001.5,10794,11478.5,11584,27591,28135.5,-0.005898773,22965,1.5,30120,1244,0.020817464,9958.5,17.5,-0.029380614,5126.5,6493.5,12.5,65.5,292,0.020924574,0.012692528,4.5,6.5,719.5,1330,4489,4072,6779.5,6850,0.01512598,6609,698,724,-0.028870562,-0.0025795451,18.5,384.5,1816,4980,1674,5587.5,11552.5,7100,4371,-0.021482361,4490.5,6238,739.5,0.018315956,15111.5,1.5,25652.5,31320.5,27752,30868,0.0021038696,1.5,29648.5,29439,2,30164.5,-0.0019241279,0.008674139,3187,9.5,7566.5,0.019504176,16,5427.5,15.5,27166.5,19568,17049.5,1203,2.5,103,1232.5,197.5,6.5,-0.012964425,-0.020159079,1167,1910,6.5,2287,4322.5,8431,3721.5,14065.5,6779,0.0048140218,7258,8078.5,4.5,5703,1167,-0.025278708,-0.0026673242,0.028730124,1249,1194,0.0075636604,18.5,-0.023453891,-0.0036361117,504.5,3228,4928.5,4626.5,5559.5,8688.5,10758,11752,4767.5,3708.5,-0.012449983,0.000522458,4191.5,4538,3217.5,6409.5,2.5,2.5,10309.5,1.5,21223,18831.5,0.0066128196,0.019016968,30418.5,0.0010846747,26096.5,30120,30457.5,30065,24721,24663.5,29501,29558,-0.002435675,29746,0.00021415949,0.00015108839,-0.00042450102,30242.5,17.5,4935,2285.5,18.5,-0.0016369531,5529.5,4656,0.015025238,5644.5,5239.5,12.5,0.013372729,27964,14019,8.5,9.5,15.5,22498.5,-0.00043321121,0.004948668,-0.00996445,-0.0030258622,-1.2277606e-05,0.009800556,-0.0009009584,-0.021316247,-0.016550032,-0.0069962926,-0.0020789886,-0.009583664,-0.0011275683,-0.014014574,0.0044784206,-0.003056009,-0.002969179,-0.01393758,0.0013308703,-0.0025956174,-0.001120329,-0.0043434533,0.0022815403,-0.0011088797,0.0047304346,-0.002757521,-0.002015626,0.00082198734,-0.007570911,-0.0014560599,-0.0135509465,-0.0053781555,-0.017180452,-0.011218349,-0.012578179,-0.004354959,0.0060934154,-0.0006047981,0.00092332653,-0.007389895,-0.0046146372,0.0145732565,0.028310878,-0.0023067298,-0.013511479,-0.029466588,-0.0067765005,0.0075110183,-0.012801892,0.00021007429,-0.013511139,-0.008157343,-0.006612354,-6.419104e-05,0.00086643314,0.013996646,-0.0043406044,0.0010790493,0.000715009,-0.0044916305,0.006697822,-0.0013270992,-0.0018320665,-0.008799746,-0.0065991245,-0.000904339,-0.0024693608,0.003422897,-0.02028392,-0.002808119,-0.004040602,-0.00804893,0.003474891,-0.0030024822,0.010162953,0.0057555996,0.0025868125,0.00041089646,-0.015369269,-0.0063607045,-0.0054820026,0.0015618651,0.0107262535,0.0012957663,-0.0057684784,0.0012977317,0.007947571,0.0046942807,0.00040192972,0.0044299033,-0.014857746,-0.005369011,0.010298521,0.0045771613,-0.0005220975,0.0021068433,-0.0016452924,-7.412861e-05,0.0005355884,-0.0001224367,-0.0018346474,-0.0010572,-0.0010022274,-0.002004173,-0.00070228503,-0.0012850178,-0.0016344801,-0.00070074364,0.0052987332,-0.00411101,-0.0015657808,0.0026202628,0.006880549,-0.001968325,0.0028457562,0.0050427574,0.005281985,0.0020155401,-0.0008477,0.0033690922,-0.011302978,0.009734307,0.0065824366,-0.008462958,0.0033410706,-0.0032242143,-0.0009162756,0.005712598,-0.0053582042,0.00011858364,-0.00090885826,-0.0017430317,-0.0002794724,-0.00080073124,-0.0027076213,-0.004794615,-0.0021500706,-0.00082526944}, {7,8,8,5,2,3,2,2,7,3,8,3,2,7,2,3,3,7,0,3,5,2,2,2,8,2,2,8,2,0,2,3,0,7,2,8,255,5,0,3,0,3,5,2,2,2,2,2,7,0,2,255,0,8,2,0,255,7,8,255,0,2,8,2,2,255,255,8,8,3,3,5,5,7,0,255,7,3,5,255,255,8,7,2,0,7,7,2,5,0,255,7,5,2,255,2,8,0,0,7,0,255,8,0,2,8,2,255,255,5,8,7,255,8,5,8,0,3,5,0,8,5,0,5,8,255,255,0,5,8,0,5,2,7,0,3,255,5,0,8,5,2,255,255,255,2,7,255,8,255,255,0,5,2,0,7,0,0,2,3,7,255,255,3,7,7,5,8,8,0,8,2,0,255,255,5,255,3,7,5,7,0,0,2,2,255,0,255,255,255,2,8,3,2,8,255,3,0,255,0,3,8,255,2,7,8,8,8,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,107,65535,109,111,65535,113,115,117,119,121,65535,65535,123,125,127,129,131,133,135,137,65535,139,141,143,65535,65535,145,147,149,151,153,155,157,159,161,65535,163,165,167,65535,169,171,173,175,177,179,65535,181,183,185,187,189,65535,65535,191,193,195,65535,197,199,201,203,205,207,209,211,213,215,217,219,65535,65535,221,223,225,227,229,231,233,235,237,65535,239,241,243,245,247,65535,65535,65535,249,251,65535,253,65535,65535,255,257,259,261,263,265,267,269,271,273,65535,65535,275,277,279,281,283,285,287,289,291,293,65535,65535,295,65535,297,299,301,303,305,307,309,311,65535,313,65535,65535,65535,315,317,319,321,323,65535,325,327,65535,329,331,333,65535,335,337,339,341,343,345,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,108,65535,110,112,65535,114,116,118,120,122,65535,65535,124,126,128,130,132,134,136,138,65535,140,142,144,65535,65535,146,148,150,152,154,156,158,160,162,65535,164,166,168,65535,170,172,174,176,178,180,65535,182,184,186,188,190,65535,65535,192,194,196,65535,198,200,202,204,206,208,210,212,214,216,218,220,65535,65535,222,224,226,228,230,232,234,236,238,65535,240,242,244,246,248,65535,65535,65535,250,252,65535,254,65535,65535,256,258,260,262,264,266,268,270,272,274,65535,65535,276,278,280,282,284,286,288,290,292,294,65535,65535,296,65535,298,300,302,304,306,308,310,312,65535,314,65535,65535,65535,316,318,320,322,324,65535,326,328,65535,330,332,334,65535,336,338,340,342,344,346,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({34.5,1768.5,2562.5,608,31565.5,586.5,7752.5,419.5,32.5,18234,0.0012710704,230,754,8155,11161.5,30,-0.019047936,154.5,-0.006892626,5211.5,25225.5,235,265,54.5,1100,7652.5,9051.5,17481,10639,106.5,30.5,0.014732885,1010,-0.00476516,-0.001154384,-0.011026988,-0.00413912,107,1234.5,311.5,546.5,-0.02823858,706.5,1109.5,1299.5,7571.5,6951,9035.5,9277.5,7996.5,28892.5,13154.5,13836.5,31.5,0.008655529,20.5,37,0.0071952916,0.010358374,22.5,139,252,-0.015630182,0.03497569,345,411,571,586.5,711,523.5,1128,1687.5,1687.5,5550.5,7563.5,7760,8070,7337.5,0.012673891,9192,2544,7466,10098,0.014471916,0.004234894,11002,9672,8292.5,14546,22,34.5,0.00531844,0.0075378306,-0.020019745,297,33.5,103.5,127.5,22,228.5,0.0053774556,0.011030777,0.0038513455,321.5,512.5,0.017062975,0.011125262,301,597.5,-0.022713661,1042.5,29,1105,0.01705846,0.006653314,1238.5,584,1130,8050,5538.5,9361,7474,0.018560488,-0.013306036,9428.5,7646,7407.5,8349.5,8882.5,8671,9234,3241,2723.5,6392,7496.5,6938.5,10996,10420,13469.5,0.0036004581,0.0061491407,5680.5,13497,12721,17691,-0.0015838338,-9.293741e-05,-0.0011135725,0.00472777,0.0014029224,0.0073379586,-0.016494872,-0.0032050037,-0.00037466284,-0.003935537,0.007886047,0.019617422,0.0070536807,0.00044469442,-0.0046334188,-0.010648317,-4.350644e-05,0.007442187,-0.0025038922,0.0057375147,-0.0040940377,-0.007373678,0.010317321,-0.0011322821,-0.013195052,-0.0049180826,-0.005388321,0.0032409087,-0.007759694,0.0010205858,-0.00985862,0.0010849799,0.0074208803,-0.009563711,-0.010225258,0.00688968,-0.0021521563,0.00065783644,0.00015100106,0.015546131,-0.002799819,0.0042615314,0.005110482,-0.010577856,0.0058513978,-0.007535197,0.00026084943,-0.011760144,-0.022830164,-0.036565688,0.0066920556,0.0016356743,-0.004713487,0.0044505857,0.0014182626,0.0024594623,-0.00034451156,-0.0025311399,0.0005997008,-0.0036714606,0.005242297,0.0020010895,-0.0018593224,-0.00033711255,0.0002573983,0.0060147857,-0.0015904263,-0.007219383,-0.0023274352,9.421584e-06,0.0023142502,-0.015264141,0.000111899666,0.0028992353,-0.0007182599,0.003352491,-0.009066139,-0.0033437877,0.006381526,-0.0063199284,-0.0038583267,-0.00049158366}, {6,1,3,1,3,6,4,1,6,3,255,7,7,5,5,4,255,3,255,1,4,6,7,1,4,5,3,3,4,3,1,255,1,255,255,255,255,7,4,6,7,255,7,5,5,4,6,1,1,5,6,1,4,6,255,1,3,255,255,7,7,1,255,255,6,6,4,7,7,3,1,6,4,5,5,5,3,4,255,3,6,5,3,255,255,3,6,6,4,1,1,255,255,255,1,3,6,7,3,5,255,255,255,7,7,255,255,5,7,255,4,5,7,255,255,6,5,6,5,5,3,5,255,255,3,6,4,3,5,1,1,4,6,1,3,3,3,6,3,255,255,6,3,3,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,65535,31,65535,33,35,37,39,41,43,45,47,49,51,53,55,65535,57,65535,65535,65535,65535,59,61,63,65,65535,67,69,71,73,75,77,79,81,83,85,87,89,65535,91,93,65535,65535,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,65535,65535,137,139,141,143,145,147,65535,65535,65535,149,151,153,155,157,159,65535,65535,65535,161,163,65535,65535,165,167,65535,169,171,173,65535,65535,175,177,179,181,183,185,187,65535,65535,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,65535,219,221,223,225,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,65535,32,65535,34,36,38,40,42,44,46,48,50,52,54,56,65535,58,65535,65535,65535,65535,60,62,64,66,65535,68,70,72,74,76,78,80,82,84,86,88,90,65535,92,94,65535,65535,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,65535,65535,138,140,142,144,146,148,65535,65535,65535,150,152,154,156,158,160,65535,65535,65535,162,164,65535,65535,166,168,65535,170,172,174,65535,65535,176,178,180,182,184,186,188,65535,65535,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,65535,220,222,224,226,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({34.5,28.5,3723,26.5,27,2966,8264.5,34.5,28.5,32.5,33.5,1501.5,350.5,7457,10996,22,22,-0.0057832897,-0.0032863698,0.007200314,0.0061245053,254,264,1769.5,1410.5,-0.019174779,3028,5937.5,7494,14113.5,30365,22,28,-0.0023671282,-0.0045637353,32.5,1475,-0.0189814,389.5,1010.5,2943,436.5,2808,-0.017696083,16574,3706,5321,7509.5,7602,8121.5,18034,31589,18133,22,0.002380723,0.0035054744,-5.7513506e-07,102,48,306,4421.5,788.5,25020,411,1014,798.5,0.017550884,39.5,1257,2415,6335,5119.5,-0.011750232,3467,18300,5969,10526.5,-0.011931068,0.016925832,6351.5,8037.5,7674,10003,9807,14718,21165,14291.5,31063,19177,-0.0013219593,-5.798588e-05,80.5,76,0.0017079177,0.0071806796,275.5,28.5,-0.005501661,0.0048577427,-0.017159421,-0.0005318389,0.010259462,31565.5,230,726.5,960,29,465.5,1363.5,0.0030926864,0.00036726092,1124.5,0.018064268,2352.5,1657,2840.5,2840,899,4229.5,2925.5,5407.5,5561,-0.018872615,0.019569693,4952,4961.5,13524,0.005022741,8085,7687.5,8031.5,9779,8481,9921.5,20832.5,14346.5,15593,0.00010881395,27876.5,19737.5,18979,-0.005367289,-0.012577908,26561,30152,32107.5,18789.5,0.00016705274,0.0037035544,-0.002561683,-0.0016061793,0.005163502,0.00032622486,0.0074606608,0.0029184073,-0.009200563,-0.0010349118,-0.0009434582,0.009371864,-0.0028924514,-0.00816486,0.016783051,0.0032446035,-0.004333587,0.0004030637,-0.008633818,-0.014592637,-0.0014379174,-0.018865341,0.0071270526,0.010101987,0.0012097856,0.005646725,-0.012244215,-0.00059301074,0.011320117,0.006562541,0.004565649,-0.0039937827,0.003002913,-0.0036400624,-0.0016638795,0.00086589897,0.0039176024,0.012503112,0.0027397186,0.006302632,-0.00043415927,0.0010741438,-0.005432757,0.007229984,0.005106324,-0.00554412,0.005669334,-0.016280422,-0.010554822,-0.034412127,-0.009988099,0.0014566703,0.009869241,0.0009385395,-0.001150858,-0.006039584,-0.028589306,0.005912847,-0.017704053,-0.004429802,8.248997e-05,-0.0064902245,0.0009012713,0.0032339876,-0.0026423384,0.00054018514,0.013328063,0.005048955,3.3777476e-05,0.0071553253,0.009494534,-0.0006757311,0.0018720841,-0.007444301,-0.0029026396,-0.0017124768,-0.0005775011,-0.0015177571,-0.0011805838,-0.00031176698}, {6,0,1,0,1,0,2,2,2,0,6,1,7,3,3,2,0,255,255,255,255,0,0,0,3,255,0,3,3,1,2,0,6,255,255,6,0,255,3,7,2,2,0,255,2,0,0,2,3,7,7,6,1,6,255,255,255,2,0,0,0,0,2,6,6,3,255,2,7,0,6,6,255,0,0,7,1,255,255,0,2,7,3,3,1,1,3,2,3,255,255,2,0,255,255,0,6,255,255,255,255,255,3,7,3,0,1,3,1,255,255,2,255,0,7,1,0,6,3,0,3,1,255,255,1,6,0,255,6,3,3,3,2,6,2,2,7,255,0,3,3,255,255,0,0,0,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,65535,65535,35,37,39,41,65535,43,45,47,49,51,53,55,65535,65535,57,59,65535,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,65535,65535,65535,91,93,95,97,99,101,103,105,107,65535,109,111,113,115,117,65535,119,121,123,125,65535,65535,127,129,131,133,135,137,139,141,143,145,65535,65535,147,149,65535,65535,151,153,65535,65535,65535,65535,65535,155,157,159,161,163,165,167,65535,65535,169,65535,171,173,175,177,179,181,183,185,187,65535,65535,189,191,193,65535,195,197,199,201,203,205,207,209,211,65535,213,215,217,65535,65535,219,221,223,225,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,65535,65535,36,38,40,42,65535,44,46,48,50,52,54,56,65535,65535,58,60,65535,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,65535,65535,65535,92,94,96,98,100,102,104,106,108,65535,110,112,114,116,118,65535,120,122,124,126,65535,65535,128,130,132,134,136,138,140,142,144,146,65535,65535,148,150,65535,65535,152,154,65535,65535,65535,65535,65535,156,158,160,162,164,166,168,65535,65535,170,65535,172,174,176,178,180,182,184,186,188,65535,65535,190,192,194,65535,196,198,200,202,204,206,208,210,212,65535,214,216,218,65535,65535,220,222,224,226,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,4489,32020.5,9809,5490.5,670,18812,5330,4.5,39.5,5752.5,19.5,2206.5,14.5,17.5,1078.5,6509,13884.5,2862.5,0.013023804,4423.5,5799.5,5598,122,600.5,12.5,3661.5,3109.5,3278,26994,21608.5,411,4.5,757,8934,4156.5,2.5,1348.5,2612,3774.5,7748.5,4995.5,3175,8702,18076.5,56.5,562.5,514,30,3266.5,2939.5,3607,15283,27873.5,3049,2925,20.5,24693,29652,19,24818,180,1503.5,2.5,5060.5,0.00938617,1652.5,2.5,11303.5,11187.5,-0.0023876939,1.5,3212,0.0053178384,0.003669465,10605,13310.5,1.5,5008,6051.5,13996,6015.5,6028,3066,5573.5,5692.5,6132,11752.5,21305,173,12.5,292,392.5,144.5,-0.022820324,29,539.5,1455.5,821.5,1144,3266.5,904,18.5,13733.5,18076.5,-0.000587046,-0.0029335404,0.00290145,3201,0.0031564215,18,17.5,0.0042379326,19759,16.5,29605,29713,-0.0065990477,20.5,24416.5,30227.5,174.5,381,475.5,2025.5,1218.5,2448.5,6089.5,2627.5,5.5,1990.5,0.012773178,1013.5,-0.008322748,0.0044907406,3134.5,2.5,-0.004484055,-5.2881165e-05,0.005887504,-0.0009742787,10009.5,-0.004820393,6170.5,14995,2034.5,1235,4721.5,2555.5,5691,4970.5,5015.5,17182.5,0.002800603,0.0009056067,6223,-0.0054097334,2544,-0.0076804715,3160.5,6928,5321.5,7006,11449,10535.5,10972.5,10020,17823.5,22600,125,15.5,55,17.5,165.5,124,327,446,87.5,319.5,0.059055418,0.03757778,57,613,1141.5,4162,2657.5,7068.5,861.5,1266.5,3236,41.5,0.012597695,3812,3613,0.027492223,9843,12620,13575.5,15.5,-0.00037581794,20078,0.004381948,0.007252981,0.0026318857,-0.0028462568,-0.00015661771,24367.5,24645,24750.5,29558.5,29646.5,29738.5,29745.5,-0.00361706,-0.0016799842,0.0009157664,24693,25435.5,29965,0.0005261087,-0.0058812904,0.012110443,0.000206849,-0.007441561,0.0008626715,-0.020924406,-0.0017513781,0.011678939,-0.00060336606,0.011222856,0.0010011542,-0.00024305594,-0.006912296,0.0016500552,0.004916472,-0.009210323,0.002544981,0.0019112021,-0.0030628282,0.004145754,0.008375617,0.0044164457,0.009195812,0.0025432792,-7.769079e-06,-0.0028239412,-0.0002760206,0.0024518138,1.7239725e-05,-0.0043256814,-0.00023805737,0.006700174,0.01030381,-9.313774e-06,0.0025249382,-0.0004895058,-0.010153757,-0.0070193075,-0.00070830615,0.0060677887,0.00115434,0.0013029047,0.009940155,0.0035326628,-0.00085924764,0.008748277,0.0025529398,-0.013409016,-0.022977263,-0.0063889246,0.00042094314,-0.0026981046,0.0027888764,-0.008838686,0.0026151463,0.011713597,-0.00746968,0.00703829,0.010959945,0.0034990367,0.0005194371,-0.010650327,0.00047821552,3.2471635e-05,0.005992846,-0.0012107309,-0.0051207705,-0.0059036324,0.004970076,-0.0050232126,0.00033486728,-0.0008672713,-0.010743222,0.003138585,0.012478783,-0.002320894,-0.007795173,-0.0025835705,0.0014159285,0.008344201,-0.0014411213,-1.6384229e-05,0.015548154,-0.003524535,-0.015584669,0.0063914866,-0.00094333565,0.00080785184,-0.0031108244,0.011524294,-0.0029927,-0.013917263,0.0032511265,0.0013975002,0.029775871,-0.0028218,0.011337566,-0.020853965,-0.0017356931,0.0025313867,0.0124737015,-0.0043393825,0.0004785636,-0.0002079008,-0.007917587,-0.0007545725,0.00596707,-0.011711656,-0.019175671,-0.014088404,-0.0024284327,-0.0011202467,0.002924606,0.005846972,0.0034103764,-0.00056275446,-0.0018304101,0.0029891157,-0.0057524717,-0.00023905572,-0.006825551,-0.00021105119,-0.0022539955,0.0015762851,0.0026668871,0.001685139,0.0010502752,0.0011271186,0.00044718516,0.0017413752,0.00075852463,-0.00013968324,-0.0027357922,0.0007978976,-4.098823e-05,-0.0020454326,-0.00024934966,0.00053883024,-0.00033825886,-0.0020698067,-0.0009955432,0.00043899502,-0.00020589259,0.0011629484,0.00043004166}, {8,5,5,6,3,6,6,0,8,2,2,8,3,8,8,3,3,2,0,255,3,3,5,5,0,8,2,2,0,2,2,6,8,2,2,5,8,0,5,2,0,2,6,2,2,3,0,3,6,6,6,2,2,3,0,6,8,6,0,8,6,5,2,8,3,255,3,8,2,3,255,8,3,255,255,6,2,8,5,0,0,5,5,6,2,6,0,2,0,6,8,3,5,5,255,5,6,2,3,6,6,6,8,0,2,255,255,255,6,255,8,8,255,0,8,2,0,255,8,0,6,2,5,5,2,3,3,2,0,8,3,255,5,255,255,5,8,255,255,255,255,0,255,3,0,3,6,5,6,6,6,3,0,255,255,0,255,6,255,2,6,0,6,6,0,0,5,6,0,6,8,6,8,6,0,5,5,2,5,255,255,6,3,3,0,0,0,0,2,6,0,255,5,2,255,6,3,6,8,255,0,255,255,255,255,255,6,0,2,2,6,6,0,255,255,255,6,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,65535,137,139,65535,65535,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,181,183,185,187,189,191,193,195,197,65535,65535,65535,199,65535,201,203,65535,205,207,209,211,65535,213,215,217,219,221,223,225,227,229,231,233,235,237,65535,239,65535,65535,241,243,65535,65535,65535,65535,245,65535,247,249,251,253,255,257,259,261,263,265,65535,65535,267,65535,269,65535,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,65535,65535,311,313,315,317,319,321,323,325,327,329,65535,331,333,65535,335,337,339,341,65535,343,65535,65535,65535,65535,65535,345,347,349,351,353,355,357,65535,65535,65535,359,361,363,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,65535,138,140,65535,65535,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,182,184,186,188,190,192,194,196,198,65535,65535,65535,200,65535,202,204,65535,206,208,210,212,65535,214,216,218,220,222,224,226,228,230,232,234,236,238,65535,240,65535,65535,242,244,65535,65535,65535,65535,246,65535,248,250,252,254,256,258,260,262,264,266,65535,65535,268,65535,270,65535,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,65535,65535,312,314,316,318,320,322,324,326,328,330,65535,332,334,65535,336,338,340,342,65535,344,65535,65535,65535,65535,65535,346,348,350,352,354,356,358,65535,65535,65535,360,362,364,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({33.5,284.5,22.5,28.5,27,84,3783,106.5,31,461.5,71,-0.01669678,-0.010580036,2783.5,3809,29.5,0.006643238,30,32.5,0.0064607784,0.014036479,1668,0.0043454994,486,2585,722,5067,72,32.5,0.0050900998,0.006317516,40.5,-0.001326552,-0.00046865953,0.0032767882,437,871,1305.5,730.5,4471.5,3514,4923.5,6255,22,0.0025845743,49,0.0080964025,0.0018782814,0.00285763,127.5,105.5,642,820,1168,2444.5,0.009441518,1458.5,41.5,252,803,7527,3903.5,5176.5,1937.5,6294.5,22,25,33.5,187.5,125,133.5,-0.027003234,369.5,623.5,755,603.5,870,-0.026167428,3017.5,3196,-0.016354663,1349,1305.5,-0.018503303,4557,7345.5,6087,7811,11191.5,5124.5,8339,3717,4427.5,5415,8003,-0.027531419,5550.5,9107.5,7388.5,-0.0015664513,0.0011042726,-0.0056084706,-0.0015863285,0.0013124819,0.0023353256,-0.00052271184,-0.0030439512,-0.00080818636,-0.0050883214,0.019886447,0.0021085388,-0.0033175014,-0.008030585,0.006051771,0.027829463,0.0019339444,0.010101348,0.0028606143,-0.014414473,0.011328556,-0.00014160671,-0.016286144,-0.009158263,-0.0006416483,-0.0060221716,-0.00491337,-0.0105458,-0.009406746,-0.001252168,-0.000332738,-0.00615336,0.000916162,0.0052989735,-0.0005777893,-0.013179679,0.004808474,0.0013001207,-0.0015212484,-0.008763605,0.0024338455,0.0056828987,-0.0046904287,0.0009780125,0.00013309742,0.004706906,-0.02084264,-0.0024939869,0.008390858,0.020318136,0.0024130424,0.0003414127,-0.00057576434,-0.002464483,0.0028952498,-0.0006372754,-0.00245804,-0.00034380893}, {4,0,5,4,6,0,7,3,3,0,3,255,255,6,3,0,255,0,4,255,255,0,255,7,0,0,4,6,6,255,255,6,255,255,255,6,0,5,3,5,5,7,5,4,255,0,255,255,255,7,0,6,5,7,0,255,7,0,0,3,4,6,7,0,6,3,6,0,0,6,7,255,3,6,0,5,5,255,7,4,255,7,3,255,6,4,4,6,6,7,4,6,6,0,7,255,5,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,65535,29,31,65535,65535,33,65535,35,37,39,41,43,45,65535,65535,47,65535,65535,65535,49,51,53,55,57,59,61,63,65,65535,67,65535,65535,65535,69,71,73,75,77,79,65535,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,113,115,117,119,65535,121,123,65535,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,65535,151,153,155,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,65535,30,32,65535,65535,34,65535,36,38,40,42,44,46,65535,65535,48,65535,65535,65535,50,52,54,56,58,60,62,64,66,65535,68,65535,65535,65535,70,72,74,76,78,80,65535,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,114,116,118,120,65535,122,124,65535,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,65535,152,154,156,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,2357.5,1538.5,6636.5,43,20.5,1659.5,1068,821.5,15866.5,1.5,11.5,742.5,12.5,3640,25.5,1092,1386.5,8550.5,0.016296837,-0.00017364018,6510.5,8375,1501.5,1475,624,889,1144.5,1813,5060.5,3805,196,40.5,0.018513484,2.5,0.012933493,2.5,5.5,2146.5,7076.5,7025,10101.5,17823.5,1291.5,2972,41.5,1502,546,-0.018908396,877,2761.5,-0.024201583,9.5,1574.5,-0.01630079,12.5,9803.5,17.5,4388,27,63.5,67,108.5,3646,1136,0.008337528,866,1.5,1489.5,4.5,1.5,6910,2171,6504,5152,6022.5,7920.5,10802,19362,430.5,555,658,5477.5,25.5,1751,15.5,1102,79,0.026096687,0.0596438,3288,1310,9242,-0.0064392798,-0.003808825,0.014457178,1421.5,2448.5,1296,9132.5,12.5,6233.5,6652.5,16.5,4864.5,2.5,31.5,-0.010764386,2001.5,71,167,359.5,150.5,1734.5,1.5,1457,3544.5,0.0021197747,0.004345821,2135,2118.5,0.0006918385,7969.5,0.013829689,0.0026006738,2330.5,4.5,7951,0.015487892,-0.019828958,6764.5,9344,8155,-0.013982384,6553,3411,6197.5,6952.5,13832,16646.5,12702.5,19087,17316.5,56.5,2993.5,1462.5,1757.5,10.5,3219,1138.5,0.0032485134,22,92.5,1182,1289.5,0.0108331125,1522.5,-0.0116694635,14.5,211,471.5,1045,0.0022072236,1105.5,1747,493.5,-0.00043012455,-0.011298146,0.0014131606,3911,4894.5,1644.5,1996,8978.5,7.5,3509,15.5,5760,3865,5460.5,10245,9802,8880.5,1503.5,30830.5,0.0010745259,-0.00089682976,0.011810555,0.0018575067,-0.0011606886,0.0027081345,-0.0011806971,-0.011317415,-0.023615988,-0.0016319127,0.006653306,-0.0014777508,-0.006013734,-0.0013078151,0.003331525,-0.011832548,0.006861515,0.0014513996,-0.009672751,-0.00128801,0.009271059,0.0002053055,-0.013553199,-0.022222525,-0.0059119943,-0.009049302,0.005122986,0.0017822402,0.002917236,-0.009556316,-0.006323378,-0.002282695,0.0002497017,0.005939217,-0.0013851848,-0.011824502,0.008306948,0.0008225401,0.007104342,0.020913046,-0.008798482,0.0014359098,-0.0013342059,0.0016067106,-0.0051949457,-5.795137e-05,0.0013831075,0.0048156134,0.01369819,0.0077014863,0.0001800699,-0.0027364695,-0.0040544975,-0.009764569,0.0009189754,0.0165935,-0.009579324,0.00020266988,0.00026638052,-0.0031297845,0.005212737,-0.00014566739,0.0003337733,-0.005489673,-0.028216247,-0.010211301,0.004119664,0.0001807596,0.012849027,0.0027974695,-0.0026609683,0.0016356604,-0.0023302766,0.0025495233,-0.002935641,-0.0068561286,0.00055502716,0.007905517,-8.861809e-06,-0.0092153745,0.015507712,0.024619145,0.0016524674,0.013009116,-0.00036606623,-0.007120188,0.005284229,-0.008785498,0.007995752,0.030925719,0.011899697,-0.01708473,0.013377497,0.031582695,-0.0034252757,-0.011876596,-0.014453157,-0.0012439808,0.0029755933,-0.007581004,-0.007418997,-0.03463297,0.0083388705,-0.0010631782,-0.00041926684,-0.007232003,-0.006685149,0.001461979,-0.0007520194,-0.009921756,-0.007044814,-0.0030892908,0.0051756296,0.0036596924,-0.011381646,-0.00040003317,-0.0030718157,0.0011940695,0.008325061,-0.0018687503,-0.0005467177,-0.0069352635,0.005135819,-0.006064643,-0.01565198,-0.0024296534,-0.00042550612,-0.0012200739}, {8,3,4,6,6,8,4,1,3,0,8,8,1,8,3,1,1,4,0,255,255,3,1,1,4,1,6,1,0,4,3,6,1,255,8,255,8,8,1,6,0,0,6,0,0,4,4,1,255,0,6,255,8,4,255,8,6,8,6,4,3,0,0,0,6,255,0,8,3,8,8,6,1,0,4,4,1,6,6,3,1,6,6,3,6,8,1,1,255,255,0,4,3,255,255,255,0,3,6,6,8,0,4,8,3,8,4,255,6,6,6,4,3,0,8,1,0,255,255,1,1,255,4,255,255,1,8,4,255,255,1,3,3,255,1,6,4,1,6,1,1,4,0,6,6,0,6,8,6,4,255,6,3,4,4,255,0,255,8,4,1,0,255,3,0,4,255,255,255,6,0,3,4,6,8,3,8,6,4,1,0,4,4,1,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,65535,39,41,43,45,47,49,51,53,55,57,59,61,65535,63,65535,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,91,65535,93,95,65535,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,65535,65535,161,163,165,65535,65535,65535,167,169,171,173,175,177,179,181,183,185,187,65535,189,191,193,195,197,199,201,203,205,65535,65535,207,209,65535,211,65535,65535,213,215,217,65535,65535,219,221,223,65535,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,65535,257,259,261,263,65535,265,65535,267,269,271,273,65535,275,277,279,65535,65535,65535,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,65535,40,42,44,46,48,50,52,54,56,58,60,62,65535,64,65535,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,92,65535,94,96,65535,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,65535,65535,162,164,166,65535,65535,65535,168,170,172,174,176,178,180,182,184,186,188,65535,190,192,194,196,198,200,202,204,206,65535,65535,208,210,65535,212,65535,65535,214,216,218,65535,65535,220,222,224,65535,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,65535,258,260,262,264,65535,266,65535,268,270,272,274,65535,276,278,280,65535,65535,65535,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4864.5,3641.5,4926,1477.5,2463,4044.5,4997,855,2113,4062,1806.5,2880.5,6453.5,5709,30481,783,877.5,1977,3607,3134,8291,-0.019432692,3342.5,3052,3008,5794,4952.5,-0.023795499,13989.5,31565.5,30507.5,632.5,796.5,719.5,1733.5,1887,1686,25601.5,5718,-0.037603226,4049.5,564.5,-0.016154353,2030.5,3158,3115,3198.5,3001.5,3216,4792.5,0.009374826,-0.0034886121,-0.0014220534,0.0033849587,-0.0020197795,10986,21611.5,-0.017847037,18133,186,826.5,1016.5,828,1462.5,429.5,1599.5,1470,1434.5,0.01571617,-0.00691076,1726,1912,-0.018148093,0.0063362396,0.012273636,-0.008894908,-0.026705971,-0.0063027525,4234,6485,8700,2728,1465.5,0.00643642,2731,-2.1617287e-05,0.0003845852,-0.0035789043,-0.0017009166,3193,2740,4076,4434.5,10982,18775,29669,0.00040890192,28091.5,19177,198,209.5,501,853,631.5,725.5,-0.0013755098,-0.00021926437,783,746,676.5,695.5,969.5,1315,1179.5,1244.5,1649.5,1795,0.010382476,1753.5,26.5,2352,6465,0.0030285118,0.00057700527,-0.0003246469,3732,9782,-0.0030083754,4922,1458.5,4840,-0.0003372022,0.0030514747,3172.5,0.004635449,3301.5,3216.5,6168,0.009637296,5920,5367.5,20158.5,-0.016911771,17589,20790.5,-0.0051065716,32302,30468,32501.5,32029.5,19895,-0.00040099685,-0.005003951,0.027397081,0.0017017972,-0.010312809,-0.0039761276,0.0037366934,0.014503866,0.019385904,0.013874369,0.0077938884,0.004589896,0.00094068766,-0.011839437,-0.006392048,-0.013599952,-0.008514984,0.0056649535,-0.047107156,-0.0075902874,0.00092523126,-0.003927616,-0.00031100612,0.010234487,-0.0010363844,-0.014191222,-0.0037489494,0.007055659,0.007369403,0.0148147885,0.0030297842,-0.0018459455,-0.0017658018,0.002935475,-0.007295187,0.0030088455,-0.0076148896,0.0004181043,-0.00049654295,-0.0018868617,-0.0053410977,-0.016409686,-0.0015108123,-0.00062874187,0.006235831,0.00081443926,-0.003513089,-0.01122381,-0.0009194797,-0.003510351,-0.00030089286,0.0032694289,0.00012884711,0.00056274136,-0.0027280294,-0.00078889186,0.005389562,0.008525452,0.0022866854,0.0063697244,-0.014598726,0.004265307,-0.00048382007,0.008943989,0.00013313962,0.006998428,-0.009299866,-7.795847e-05,-0.003888879,-0.0032488673,-0.0030212165,-0.01066163,-0.0009269807,-0.0017538102,-0.0023835378,-0.00092292746,0.00017595677,-0.00029556509}, {3,2,2,1,6,2,2,0,0,4,0,2,4,0,2,1,4,1,2,1,0,255,4,6,2,0,3,255,1,0,2,0,0,6,6,1,0,0,1,255,3,6,255,4,6,4,0,2,4,0,255,255,255,255,255,1,1,255,1,1,0,4,0,0,1,6,4,0,255,255,0,4,255,255,255,255,255,255,1,0,0,1,3,255,2,255,255,255,255,0,0,0,2,1,3,2,255,4,3,0,0,2,4,6,0,255,255,4,1,2,1,3,0,0,3,1,3,255,0,2,4,0,255,255,255,1,0,255,0,3,3,255,255,6,255,1,2,4,255,1,6,3,255,1,2,255,0,0,2,4,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,73,65535,75,77,65535,79,81,83,85,87,89,91,65535,65535,65535,65535,65535,93,95,65535,97,99,101,103,105,107,109,111,113,115,65535,65535,117,119,65535,65535,65535,65535,65535,65535,121,123,125,127,129,65535,131,65535,65535,65535,65535,133,135,137,139,141,143,145,65535,147,149,151,153,155,157,159,161,65535,65535,163,165,167,169,171,173,175,177,179,181,65535,183,185,187,189,65535,65535,65535,191,193,65535,195,197,199,65535,65535,201,65535,203,205,207,65535,209,211,213,65535,215,217,65535,219,221,223,225,227,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,74,65535,76,78,65535,80,82,84,86,88,90,92,65535,65535,65535,65535,65535,94,96,65535,98,100,102,104,106,108,110,112,114,116,65535,65535,118,120,65535,65535,65535,65535,65535,65535,122,124,126,128,130,65535,132,65535,65535,65535,65535,134,136,138,140,142,144,146,65535,148,150,152,154,156,158,160,162,65535,65535,164,166,168,170,172,174,176,178,180,182,65535,184,186,188,190,65535,65535,65535,192,194,65535,196,198,200,65535,65535,202,65535,204,206,208,65535,210,212,214,65535,216,218,65535,220,222,224,226,228,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5.5,476,1544.5,467.5,5323.5,12.5,1312.5,101.5,-0.03125771,2.5,1952.5,1219,1475,12.5,2202,80,123.5,2610.5,4.5,7099.5,2019.5,467,1145,1219,1747,2427,2403,1647,3613.5,31.5,0.015212188,4.5,216,1580,6539,2370.5,5209,1427.5,1.5,2452,5333.5,651.5,2056,1200,1663,942.5,926.5,848.5,18,996.5,1254.5,1625.5,765.5,1415.5,12.5,18.5,32366,27.5,46.5,66.5,188.5,0.025467336,128.5,2005,1986.5,5242,8018.5,1235,4041.5,4732,6273.5,0.008061185,-0.0009731287,7226.5,1949,0.0097852675,0.022036292,5331.5,2317,122,411.5,305,9500,0.003912708,922,1179,0.014218655,21.5,1137,629.5,1615.5,18.5,-0.0020469136,0.01524498,0.026252273,2119,1065.5,2879.5,4162,-0.026810616,839.5,550,1154.5,10.5,7036.5,4370,1933.5,2245,876.5,9784.5,20364.5,20.5,37,61,55,43,426,-0.00653475,-0.0006473805,0.019090135,372.5,1496,1110.5,2242.5,2504.5,6337.5,-0.0039842464,6961.5,17134.5,848,1595.5,2324.5,5132,1191,6340,-0.008447043,4707,-0.008367189,-0.016452303,2.5,3.5,-0.00059356267,-0.008178807,1241.5,3549,211,216,271,378,1000,433.5,8982.5,7.5,866.5,1873.5,-0.0052321306,1964.5,937,898.5,932,1173,-0.00073336205,14.5,17.5,18.5,15.5,0.021431014,-0.015646458,-0.004209797,-0.029210595,1942.5,0.014220451,0.0027684688,-0.011823743,1409,2030.5,14.5,-0.0061864196,0.0015511796,3731.5,-0.0058268146,-0.0027609332,4754.5,7646.5,8.5,2264,8603,1534.5,1475,17.5,2087,342.5,2304,15.5,14.5,17170.5,27594.5,-0.0028242373,0.0016216807,-0.0008516591,-0.014149012,0.001929876,-0.0086968215,0.016117541,0.0050633857,-0.00791105,0.006200918,-0.011301718,-0.0062964666,0.0010389964,-0.0044145626,-0.00025884694,-0.010830438,0.019010304,0.0036528078,0.0013860817,-0.0039333436,-0.019177632,-0.0016432751,0.0043925922,-0.0003920629,0.0025286018,-0.017330917,0.004636995,-0.0045090206,0.0005852046,-0.005099622,0.008016256,0.023138126,0.001352054,-0.0014346715,0.0073837354,0.0010441052,0.002462673,-0.0025462895,0.0044200877,0.001609239,-0.0045830985,-0.00072916195,-0.0068603097,-0.0037518002,-0.010317321,-0.007196344,0.003920435,-0.0033362594,0.002231952,0.0003007466,-0.0012902461,-0.008526732,0.01852891,0.00028813686,-0.00827759,-0.020412369,-0.0005244816,-0.006991096,-0.004249187,0.0012622944,0.013095473,0.004687047,-0.0018369587,-4.0658353e-05,0.00577466,0.0013021425,-0.020483894,-0.030536467,-0.017834028,-0.008682703,0.0070284563,0.001558767,0.0005885332,0.0119480165,0.0016886402,0.030094767,0.000459835,-0.011370049,-0.0138004795,0.0012569765,0.00016714718,0.022268793,-0.00035669218,-0.014041943,0.0005998776,0.023835905,0.009831081,0.0045856377,-0.020961024,-0.012469165,-0.0049032965,-0.0014250787,0.0007658141,-0.0054353494,0.0013128908,0.01520312,-0.03562957,-0.012924223,-0.006663521,-0.010756753,-0.00025646453,-0.009098117,0.004291383,0.0005865581,0.0026772146,-0.017613716,0.0017851426,-0.0024071988,-0.0024198196,0.005878726,-0.02568659,-0.0033517263,-0.0024239605,-0.014644227,0.00470853,-4.5226778e-05,0.005396416,0.035559148,-0.014536584,0.006458033,-0.00087386137,0.0005765548,-0.00041511297,-0.0016242443,0.0038705326,0.0019513704,0.0002875195,-0.00016842334}, {8,5,4,5,4,8,5,4,255,8,5,4,4,8,5,5,5,3,8,0,5,5,5,4,0,0,4,5,4,5,255,8,4,5,1,3,5,3,8,1,4,4,3,0,5,4,5,1,8,5,1,4,5,3,8,8,5,1,1,3,0,255,5,0,0,5,1,0,4,3,3,255,255,0,1,255,255,4,1,5,0,3,3,255,5,5,255,8,0,3,1,8,255,255,255,4,5,0,0,255,5,3,5,8,4,4,3,3,0,4,4,3,4,4,0,5,0,255,255,255,4,4,1,3,1,0,255,0,5,5,5,5,3,0,1,255,4,255,255,8,8,255,255,1,3,4,4,5,3,4,3,3,8,1,0,255,3,4,1,1,5,255,8,8,8,8,255,255,255,255,0,255,255,255,1,4,8,255,255,0,255,255,0,0,8,4,0,3,0,8,4,0,4,8,8,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,65535,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,65535,119,121,123,125,127,129,131,133,135,65535,65535,137,139,65535,65535,141,143,145,147,149,151,65535,153,155,65535,157,159,161,163,165,65535,65535,65535,167,169,171,173,65535,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,65535,65535,65535,209,211,213,215,217,219,65535,221,223,225,227,229,231,233,235,65535,237,65535,65535,239,241,65535,65535,243,245,247,249,251,253,255,257,259,261,263,265,65535,267,269,271,273,275,65535,277,279,281,283,65535,65535,65535,65535,285,65535,65535,65535,287,289,291,65535,65535,293,65535,65535,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,65535,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,65535,120,122,124,126,128,130,132,134,136,65535,65535,138,140,65535,65535,142,144,146,148,150,152,65535,154,156,65535,158,160,162,164,166,65535,65535,65535,168,170,172,174,65535,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,65535,65535,65535,210,212,214,216,218,220,65535,222,224,226,228,230,232,234,236,65535,238,65535,65535,240,242,65535,65535,244,246,248,250,252,254,256,258,260,262,264,266,65535,268,270,272,274,276,65535,278,280,282,284,65535,65535,65535,65535,286,65535,65535,65535,288,290,292,65535,65535,294,65535,65535,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4.5,595.5,842.5,205,2735.5,812.5,2169,79.5,203.5,2.5,4015.5,780.5,18.5,12.5,2074,67,381,411,1268,2202.5,2190.5,9803,9320.5,710.5,662,414,933,4306,1203,18.5,2013.5,30.5,287.5,96.5,3015.5,284,590,525.5,353.5,1033,2199,1197.5,2805,4542.5,9910.5,1.5,6692.5,620,633,0.00085097953,803.5,0.006794795,933,0.0025625487,0.03517775,1203,11386,999.5,4960,1686,2532,2289,30208.5,28.5,2.5,42,514.5,1.5,141.5,-0.002048327,0.004899483,-0.011461011,3.5,-0.007762489,-0.0152177755,3.5,2.5,651.5,-0.0065841973,1539,1963,2327.5,3553,441.5,1564.5,-0.007000097,8897,2.5,4008.5,0.00939047,9959.5,7691.5,9249,10493,32516.5,113.5,700.5,18.5,342.5,-0.015415053,-0.0031199611,14.5,12.5,856.5,1235,9330,-0.008299095,759,18.5,3687,2614.5,0.013135863,12.5,2086.5,-0.013362641,0.016731568,21.5,26005.5,25989.5,2555.5,-0.014524131,43,38,-0.013355719,72,0.009397108,-0.003894727,0.0007078021,122,0.021613648,0.01068291,-0.0033253662,-0.00596513,330,-0.003670099,575.5,547,-0.010682258,-0.01858724,718,-0.012097576,1774,2491,-0.0021587515,1.5,-0.0015351312,5406.5,0.0020586483,659,1078,2396,3961,821,3814,3544.5,1523.5,1.5,10103.5,2.5,5570.5,9150.5,6018,9339,9037.5,9411.5,24739,28879.5,56,211,638.5,919.5,0.003963705,0.03901163,0.011329969,1095,918,0.0011337757,0.0047287582,-0.0012158912,-0.019155739,1790.5,1194.5,1228,7122,2066,18.5,21.5,1073.5,955,1139,2306.5,18.5,8443.5,6.5,1889,0.01959319,0.04156706,16.5,791.5,30334.5,28571,17.5,26394.5,-0.00035657242,0.012448447,0.008571576,-0.0009962152,-0.00058563217,0.014521146,-0.0034599658,-0.0082604615,0.009635513,0.004170761,0.010720684,0.005487048,-0.007923723,0.0019330907,-0.0010681333,-0.008630148,0.009372804,-0.0017073216,0.0055662342,0.020958126,-0.0018746511,0.004217549,-0.010198315,-0.019718928,0.0014167118,0.0057175993,0.00074325054,-0.0051624193,-0.0032845952,0.007600929,0.026195718,0.010437464,0.00025179225,0.0031274164,-0.0018892417,0.00056523486,-0.0094555495,0.0011918984,0.017955463,0.0007616337,-0.008559254,-0.0025173374,-0.006318132,-0.009454218,-0.0016444828,0.0019516873,0.0019756414,0.005180762,0.0025708254,0.008543471,-0.0005989063,0.009763893,0.0021560164,-0.00012474484,0.014957286,-2.5294721e-05,-0.00034492856,-0.00763874,-0.00504638,0.0025130562,0.00084842276,0.0036616249,0.00021885963,-0.0007524043,0.0005492677,-0.0010181066,0.011487635,0.0001461023,-0.012723582,-0.0050452137,0.0006762894,-0.009378395,-0.0010860439,0.0030376888,-0.0027770323,-0.00037837587,0.0028263382,-0.005959846,-0.007542599,0.015665261,-0.032707337,-0.01130777,-0.0008003308,0.0016227489,-0.0060602766,-0.0019876037,-0.0031857074,-0.017422847,9.198854e-05,0.020745745,-0.017297223,-0.0041853483,-0.040061604,-0.016429147,-0.0064208056,0.005108745,-0.015817722,-0.0010041789,-0.005309108,-0.02038257,-0.0010410825,-0.00642678,-0.003403172,0.0056377347,-0.0043515703,0.0017229831,0.0025854826,-0.002315767,0.02430722,-0.001183874,-0.00037352683,-0.0009768123,-0.0074309357,0.0007853666,0.0008783537,-0.0002623817,-0.008617217,-0.000106099935}, {8,7,4,6,4,4,7,7,7,8,7,4,8,8,6,6,4,4,6,4,7,0,2,4,0,0,0,4,0,8,4,7,4,2,0,4,2,0,7,7,7,6,7,6,0,8,7,4,6,255,4,255,0,255,255,6,4,2,0,6,7,6,7,7,8,7,4,8,4,255,255,255,8,255,255,8,8,4,255,2,6,6,6,4,2,255,7,8,7,255,6,6,2,0,7,4,2,8,0,255,255,8,8,4,0,2,255,6,8,6,4,255,8,0,255,255,8,7,6,4,255,2,0,255,7,255,255,255,6,255,255,255,255,4,255,4,6,255,255,7,255,6,6,255,8,255,7,255,7,2,0,6,4,0,0,7,8,4,8,2,2,7,4,0,2,7,2,4,4,4,0,255,255,255,0,6,255,255,255,255,4,7,6,6,7,8,8,2,6,4,2,8,6,8,0,255,255,8,0,2,6,8,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,65535,99,65535,101,65535,65535,103,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,65535,65535,131,65535,65535,133,135,137,65535,139,141,143,145,147,149,65535,151,153,155,65535,157,159,161,163,165,167,169,171,173,65535,65535,175,177,179,181,183,65535,185,187,189,191,65535,193,195,65535,65535,197,199,201,203,65535,205,207,65535,209,65535,65535,65535,211,65535,65535,65535,65535,213,65535,215,217,65535,65535,219,65535,221,223,65535,225,65535,227,65535,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,65535,65535,65535,275,277,65535,65535,65535,65535,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,65535,65535,309,311,313,315,317,319,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,65535,100,65535,102,65535,65535,104,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,65535,65535,132,65535,65535,134,136,138,65535,140,142,144,146,148,150,65535,152,154,156,65535,158,160,162,164,166,168,170,172,174,65535,65535,176,178,180,182,184,65535,186,188,190,192,65535,194,196,65535,65535,198,200,202,204,65535,206,208,65535,210,65535,65535,65535,212,65535,65535,65535,65535,214,65535,216,218,65535,65535,220,65535,222,224,65535,226,65535,228,65535,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,65535,65535,65535,276,278,65535,65535,65535,65535,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,65535,65535,310,312,314,316,318,320,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2616,12.5,8.5,47,9787,2670.5,2624.5,99.5,4306,3200,9839,2490.5,4887,18.5,6337.5,82,525,1194.5,3504,616.5,1379.5,18.5,2729.5,-0.003637945,4283.5,8982,7733,2191,0.031730704,3813,10317,26.5,3.5,6.5,40,547,6.5,4819.5,9076.5,501.5,19.5,5136,18.5,2256,12499.5,10737,4716.5,10178,-0.0022683246,2.5,5092,7724.5,6116.5,-0.00040190067,0.005013229,41.5,6729,10265,21082,26.5,33.5,-0.012833729,7.5,0.018553043,0.0065707527,16676,0.00782602,455,623.5,933.5,2278,3220.5,1.5,3707.5,9442,843,418.5,1694.5,726.5,2179,4578.5,17.5,9989,982,-0.0059831357,1685,-0.003922436,2399.5,15.5,0.0035378046,11394.5,6.5,0.0016966539,5321.5,6424,4.5,2.5,1.5,7641.5,5849.5,8595,28.5,17.5,5694,18.5,14666,10280,13708.5,22730.5,22,132,32,143.5,0.0024057543,-0.008905311,29.5,-0.0023127839,319.5,1166.5,437.5,5.5,74.5,1934,671.5,3108.5,7035,1921,1128,1103.5,1735,2022,5.5,-0.004166275,63.5,921,-0.018031055,570,1544.5,14.5,0.03672592,754.5,-0.016061602,18.5,2297,-0.0061647217,2041,2501,2983.5,-0.007448964,-0.0048747216,-7.734406e-06,-0.014322489,9914,10160.5,10471.5,-0.008256242,10863,1317,-0.004828894,8813.5,0.005229495,4769.5,3641,6.5,6471.5,9201.5,9024,-0.010356,12409,8174.5,7181,0.018751228,0.0045164856,1.5,9587,12040.5,8307.5,18.5,3007.5,3688,2972,5428,6257.5,15.5,5838,6956.5,12.5,-0.01812562,15.5,17.5,17602,17220,18591.5,-0.0007102434,-0.006430972,0.0032871694,-0.001974732,0.0029151083,0.0072914767,0.0009415106,-0.007347247,-0.0013446292,0.004238699,-0.0018692935,0.0026267204,-0.004451571,0.0019587963,0.010262998,0.004832206,-0.0030523683,0.004159389,0.0036257205,-0.007967561,0.004699074,-0.0010759062,-0.0016906314,-0.013533357,0.0009887965,-0.018729905,0.0018476027,-0.00097306457,-0.0018752984,-0.010803309,0.0053771357,0.007557239,-0.0007373655,0.0021731306,0.0003783097,-0.006797696,-0.0013308101,0.0017934609,-0.022875626,-0.011265591,-0.00068086473,0.001729705,-0.0063453815,0.005507959,8.098414e-05,-0.013570133,0.00070746033,-0.01722788,-0.0016503921,0.0051585073,-0.020759877,0.0074250745,-0.009997424,-0.005212932,0.0009335251,-0.0019245556,-0.0007077092,0.001200723,0.006005745,-0.0010657809,-0.0015696045,0.0013954288,-0.011314838,-0.005752615,-0.0027959635,-0.006156935,0.0009805643,-0.001764882,-0.0046939175,-0.0031516782,-0.0021721723,0.00014232883,0.02092964,0.01190985,0.0018091496,-0.0038540033,-0.0023369754,-0.006189149,-0.0012421955,0.0018905919,-0.01145392,-0.0015449225,0.011096821,0.0037660585,-0.0030495897,0.001098066,-0.0032127225,0.0023624601,0.004424687,-0.0011506546,0.0015351591,-0.00091945706,-0.007170599,0.00026081456,-0.008483561,-0.0032717746,-0.0028241526,0.00888917,0.002024783,9.0300375e-05,0.004640035,-0.005418304,-0.009736367,-0.01808637,4.7978963e-05,0.0039999005,0.0060536815,-0.0031702158,-0.002425449,0.00095810596,-0.005114892,0.007071677,0.0005750183,0.003148211,0.0043264483,0.011594175,-0.002246903,-0.0004860369,-8.435949e-05,-0.004135209,-0.005526788,-0.009704246,-0.0013721542,0.0017992205,0.003353361,-0.0021860048,-0.0028061166,-0.011324564,0.015207002,-0.0005015501}, {7,8,8,4,0,7,7,3,4,4,4,1,7,8,0,3,0,0,3,3,1,8,1,255,1,4,4,3,255,3,1,4,8,8,4,3,8,1,4,3,8,4,8,7,1,4,1,0,255,8,3,4,1,255,255,0,1,1,4,3,4,255,8,255,255,0,255,4,7,3,1,1,8,1,0,4,7,4,3,0,0,8,4,7,255,7,255,3,8,255,0,8,255,4,0,8,8,8,0,1,4,0,8,1,8,4,1,0,4,4,1,7,0,255,255,4,255,4,7,1,8,3,1,1,4,4,3,3,3,7,7,8,255,4,0,255,1,4,8,255,1,255,8,0,255,7,1,1,255,255,255,255,0,4,0,255,4,7,255,0,255,7,3,8,0,4,0,255,4,0,1,255,255,8,4,0,7,8,4,3,1,3,0,8,0,4,8,255,8,8,3,3,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,65535,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,93,95,97,99,65535,65535,101,103,105,107,109,111,65535,113,65535,65535,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,65535,151,65535,153,155,65535,157,159,65535,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,65535,201,65535,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,65535,233,235,65535,237,239,241,65535,243,65535,245,247,65535,249,251,253,65535,65535,65535,65535,255,257,259,65535,261,263,65535,265,65535,267,269,271,273,275,277,65535,279,281,283,65535,65535,285,287,289,291,293,295,297,299,301,303,305,307,309,311,65535,313,315,317,319,321,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,65535,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,94,96,98,100,65535,65535,102,104,106,108,110,112,65535,114,65535,65535,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,65535,152,65535,154,156,65535,158,160,65535,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,65535,202,65535,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,65535,234,236,65535,238,240,242,65535,244,65535,246,248,65535,250,252,254,65535,65535,65535,65535,256,258,260,65535,262,264,65535,266,65535,268,270,272,274,276,278,65535,280,282,284,65535,65535,286,288,290,292,294,296,298,300,302,304,306,308,310,312,65535,314,316,318,320,322,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4566.5,4376.5,4635.5,295,9014.5,7079.5,5067,112.5,236.5,5181.5,9523.5,6397,7632.5,6000,5904,118.5,342,121.5,357,4254,4585.5,-0.012940711,3020.5,0.01933307,0.007588032,-0.0009354831,8530.5,5041.5,8174.5,5893.5,9828,114.5,137,37,504.5,434.5,177,898,1501,-0.00042203354,5438,8153.5,5563,-0.0053859274,21359.5,4505.5,9231,5738.5,6447,5326,6887,5768,5758.5,5562.5,2979.5,101.5,64.5,173.5,317,148,173.5,-0.0024454931,268.5,0.0040858653,-0.00365231,424.5,1527.5,191,740.5,492.5,1552,-0.007140963,-0.0140042,6219.5,4012.5,4952,4855.5,0.000373287,-0.0019086149,0.0077804937,0.0048030443,0.002203894,0.0015607799,4590.5,-0.032660723,5649.5,329,4840,6373,-0.01021634,1001.5,5675.5,7816.5,5245.5,5601,3082,6465.5,-0.017446175,16188,83.5,29.5,0.0029972517,0.012006029,32.5,-0.0037501564,30,0.0035132056,435,202,0.021288041,0.011274571,251,0.0068353857,300,94.5,641,-0.009392879,438.5,324.5,762,167.5,520.5,268,1286.5,3981.5,-0.008076225,6868,-0.0015369854,3966,4773.5,0.008842498,0.0002637028,-0.00087141024,4358.5,4967.5,4279,0.018416075,481,821,-0.0018261977,4213,3999.5,6069,372,9268.5,4708,-0.026829122,5693.5,4690,4942,5320,0.021837236,6051,-0.014228307,5161,7622.5,6537,19797,16931.5,7.485142e-05,0.015974924,0.0031206503,-0.0027623747,-0.01741417,-0.011296418,-0.008027762,-0.002732537,0.005535768,0.011643299,0.0029647318,0.0045395247,0.0032921822,0.00011733162,-0.009876677,-0.012455465,-0.008802737,-0.0061093015,-0.0032324158,-0.0057142456,0.008034556,2.2690549e-05,0.02526789,0.008760686,-0.003249101,0.00500363,-0.02206861,-0.0027448002,-0.00546382,-0.010871541,0.0046265,-0.0019465935,0.00021821876,0.005637591,-0.0008530183,0.00020183086,-0.0032728822,-0.004931044,0.0055297995,0.0018713754,0.004823996,0.0022630144,0.0091154585,-0.0112131005,0.007877121,0.00023010923,0.0064596273,-7.041921e-05,0.011377588,4.479301e-06,-0.0018856236,0.00049904286,0.008683738,0.021335503,0.0024573912,-0.011357444,0.0076618763,0.0037233636,-0.0009380583,-0.008106367,-0.0010682923,0.00097083795,0.01048376,-0.003227202,0.0005494008,0.013876893,-0.0055121365,-6.329683e-05,-0.0019119974,0.023934312,-0.02784803,-0.009700629,-0.007721477,-0.0004517288,0.0012338851,0.0051920707,-0.001295824,-0.014859225,0.003790265,0.00012994319,-0.00086151966,0.010951642,0.0045595835,-0.00033264744}, {3,3,3,2,2,2,4,3,3,4,2,4,2,1,5,2,6,3,6,1,1,255,1,255,255,255,2,6,3,1,4,2,2,6,6,1,4,2,1,255,1,2,1,255,2,1,2,1,6,3,1,2,4,3,1,1,1,6,5,2,2,255,3,255,255,2,6,6,4,6,4,255,255,4,5,1,6,255,255,255,255,255,255,4,255,1,5,3,3,255,4,5,2,3,2,1,2,255,5,1,2,255,255,3,255,1,255,1,2,255,255,3,255,1,1,2,255,3,4,3,6,1,5,5,5,255,4,255,1,1,255,255,255,2,2,5,255,1,4,255,4,4,2,6,1,6,255,3,3,3,6,255,1,255,2,1,3,3,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,65535,65535,65535,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,73,75,65535,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,65535,65535,113,115,117,119,121,123,65535,65535,125,127,129,131,65535,65535,65535,65535,65535,65535,133,65535,135,137,139,141,65535,143,145,147,149,151,153,155,65535,157,159,161,65535,65535,163,65535,165,65535,167,169,65535,65535,171,65535,173,175,177,65535,179,181,183,185,187,189,191,193,65535,195,65535,197,199,65535,65535,65535,201,203,205,65535,207,209,65535,211,213,215,217,219,221,65535,223,225,227,229,65535,231,65535,233,235,237,239,241,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,65535,65535,65535,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,74,76,65535,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,65535,65535,114,116,118,120,122,124,65535,65535,126,128,130,132,65535,65535,65535,65535,65535,65535,134,65535,136,138,140,142,65535,144,146,148,150,152,154,156,65535,158,160,162,65535,65535,164,65535,166,65535,168,170,65535,65535,172,65535,174,176,178,65535,180,182,184,186,188,190,192,194,65535,196,65535,198,200,65535,65535,65535,202,204,206,65535,208,210,65535,212,214,216,218,220,222,65535,224,226,228,230,65535,232,65535,234,236,238,240,242,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1.5,2005,6815.5,7152,7914,6600,6767,7099,1527,2554,11529.5,15.5,9595.5,6836.5,6908.5,3807,8158,880.5,0.013563949,2154.5,7508.5,4510.5,21793,4483,4932,6513.5,9535.5,-0.017467098,9958.5,7366,7030,143.5,1613,-0.011349666,-0.01685792,0.0050216066,0.001024456,1007,1928.5,20195.5,7607.5,8599,12106.5,13833,16124,4261.5,7.5,742,18.5,5910,8178.5,10978.5,6947.5,16.5,3292.5,7244,6895.5,9669.5,7033.5,238.5,33,0.01059787,-0.0013224088,121,2010,-0.013687539,2982.5,5993,-0.005866778,7232,7640,4851,2146.5,6404.5,22757.5,10172.5,18249.5,13288.5,32413,2.5,4314,5887,6465.5,668,796.5,6570,9014.5,0.010579988,6527.5,6529,13,10225.5,-0.00013985056,6085,6.5,12.5,5796,11.5,-0.018080268,-0.0037952473,0.014991022,15.5,13,7609.5,7180,12.5,7072.5,29.5,-0.0062905513,-0.015257168,1526.5,0.0023202377,0.007673222,-0.0014118871,0.0011581336,0.002827238,-0.0066010016,5927,6490,0.0069073476,0.018591681,0.004826821,-0.00062214327,-0.013834881,0.0034994278,3122,8778,7452.5,6395.5,20841.5,32046,10606.5,15501,15729.5,0.018265469,26772.5,16507.5,27448,29738,67.5,4.5,4.5,4317,5864.5,4.5,4511,11618,529,18.5,18.5,617.5,5600,9941,5537.5,9139.5,-0.012478615,0.0002766118,8079,6760,-0.012450186,-0.00062748237,0.016601766,0.008054293,6.5,6710,-0.0033194055,14080,5796,6713.5,-0.013376491,7532,2.5,18.5,6029,7113.5,0.014936864,0.0070544737,6971,10.5,6684,9,0.017217703,0.008186899,6821.5,12.5,-0.0027646993,0.0029973055,-0.0014349258,-0.008091995,0.0034253818,-0.0033451468,0.012325805,0.005399318,0.012729997,0.0036340547,-0.0048158653,0.0030539273,-0.0048356876,-0.02047465,-0.007893792,0.0030693458,-0.0060124784,-0.018444754,-0.0012227382,0.0037007153,0.0062698685,0.0007258317,0.01101122,-0.0022995619,0.015005491,0.009642816,-0.001713969,0.0002968893,-0.005828207,-0.0004594852,0.013049257,0.0021249258,-0.00053944637,-0.0012809347,0.0014521279,-0.0035763548,0.00020602546,-0.001036363,-0.0028154475,-0.010910237,0.007337415,-0.0033531263,0.0018911593,0.016393555,-0.0019753433,0.0014006682,0.0027963775,-0.0014004846,0.003169771,-0.0034447778,8.80722e-05,0.008714798,-0.011805831,-0.027212862,-0.0064762183,0.028343467,0.010114094,0.0017999904,0.00022488173,-0.0049739024,0.002475629,-0.00050576025,-0.0033470073,2.011231e-05,-0.01683793,-0.0020500324,-0.0078592105,-0.0127209565,-0.017294575,-0.02426878,0.008440394,0.0009627755,-0.0036798262,0.00056889205,-0.0074696573,-0.010447809,0.010621174,0.0027003232,-0.002706754,0.006007169,0.0123921065,-0.0062592053,-0.008104285,-0.00076950254,0.002004758,0.0056463773,-0.009425408,0.0025389881,-0.0033821897,0.0015285386,-0.015454707,-0.02152433,-0.013470297,-0.007385194,-0.0039291005,-0.00044500732,0.011625359,-0.0015506751,-0.00036991815,-0.017871806,4.8976544e-05,-0.0005519928}, {8,7,3,1,2,3,2,0,2,3,7,8,0,3,3,0,0,7,255,2,2,1,0,1,0,0,2,255,7,2,3,0,3,255,255,255,255,2,3,7,1,2,2,1,1,1,8,1,8,7,2,0,1,8,0,0,3,0,3,2,7,255,255,0,3,255,7,3,255,0,0,3,1,7,2,0,7,1,1,8,1,1,3,1,0,2,2,255,1,2,8,0,255,1,8,8,2,8,255,255,255,8,8,2,7,8,3,0,255,255,2,255,255,255,255,255,255,2,3,255,255,255,255,255,255,3,0,3,3,2,2,3,2,2,255,0,7,0,0,2,8,8,1,1,8,1,2,1,8,8,7,3,2,0,2,255,255,1,2,255,255,255,255,8,1,255,0,2,2,255,0,8,8,1,7,255,255,2,8,1,8,255,255,1,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,65535,65535,65535,65535,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,65535,111,113,65535,115,117,65535,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,65535,155,157,159,161,65535,163,165,167,169,171,65535,65535,65535,173,175,177,179,181,183,185,65535,65535,187,65535,65535,65535,65535,65535,65535,189,191,65535,65535,65535,65535,65535,65535,193,195,197,199,201,203,205,207,209,65535,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,65535,65535,251,253,65535,65535,65535,65535,255,257,65535,259,261,263,65535,265,267,269,271,273,65535,65535,275,277,279,281,65535,65535,283,285,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,65535,65535,65535,65535,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,65535,112,114,65535,116,118,65535,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,65535,156,158,160,162,65535,164,166,168,170,172,65535,65535,65535,174,176,178,180,182,184,186,65535,65535,188,65535,65535,65535,65535,65535,65535,190,192,65535,65535,65535,65535,65535,65535,194,196,198,200,202,204,206,208,210,65535,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,65535,65535,252,254,65535,65535,65535,65535,256,258,65535,260,262,264,65535,266,268,270,272,274,65535,65535,276,278,280,282,65535,65535,284,286,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7733,8155,7216.5,7969,9029.5,11320.5,6255,7571.5,7727.5,3882.5,2309,6305.5,6652,7221,6512.5,7059,7029.5,-0.0037351903,-0.022314828,111,5993.5,0.006967769,742.5,6067,6052.5,9847.5,6920,7218.5,6157,6486.5,7770.5,7033,8282,6626.5,7370,0.0025460895,-0.003898713,0.010832561,6437.5,0.005297162,7726.5,10261.5,8110,6615.5,7589.5,9328,6170.5,-0.0045718183,-8.878854e-05,0.004714226,0.010921511,28482,9998,6396,0.017304521,9448,6765,6887.5,0.016346024,6680,7223,4896,6567.5,7674.5,6848.5,7722.5,8795.5,2397.5,8617.5,9482,9843,0.010899191,0.01770244,0.014347958,0.006511432,9173,6379,0.0009056722,10164.5,7936.5,6212.5,5815.5,0.007791426,9846,6186,10104,6533,-0.020771204,-0.00019965728,9361,8003,6015.5,7336.5,5983.5,6257.5,-0.023195375,-0.032952275,-0.00093485246,-0.0039721616,-0.019148195,6686,5719.5,7510,7504.5,7532,-0.0006011496,0.0030664082,7032,6912,0.0035295372,2849,0.0038001668,0.00049353036,8546,3411,-0.009250495,-0.0152840335,9089,7245,0.0013383699,6890,5327.5,0.0031182165,7095.5,5320,0.00227561,0.0031211819,4610,9561.5,8739,9907,6035.5,12487.5,6405.5,6412.5,11237,9719.5,8008.5,9615.5,9652,9760,-0.00010371683,-0.0015066623,0.0024523637,5.0315208e-05,-0.0008578851,0.0034314336,0.0039583254,-0.009240537,-0.0038708046,-0.0128990235,0.002724947,0.01481128,-0.009880224,-0.002154096,0.012036703,-0.0052664233,0.02512989,0.014007865,0.004301218,0.007910946,0.002661131,0.0034568978,-0.001943636,0.0005684346,-0.0020084223,-0.008736328,0.0012882279,0.005419774,-0.008305474,0.009929444,-0.024902252,-0.011530272,-1.8359036e-05,-0.00088867964,0.0057048644,0.0044101635,-0.0045004147,-6.2067134e-05,-0.00082015415,0.0028771448,-0.0008608469,0.0005952166,0.0041924194,-0.002772348,-0.0010659454,0.0005026492,-0.0047886665,-0.0027939507,-0.0064144568,-0.0029808925,-0.011148712,-0.0072782673,0.0016625033,-0.0022098518,-0.0019546458,-0.00660827,0.0106300125,0.0077402676,0.006416049,-0.0010612758,0.004459142,-0.0075084656,0.008782029,-0.0019913975,0.0066445484,-0.00022966464,-0.0020116824,-0.00011862632}, {4,5,0,5,5,5,5,4,0,0,2,1,0,0,5,5,0,255,255,0,6,255,0,1,2,4,0,0,5,5,4,5,6,5,5,255,255,255,6,255,2,5,4,0,1,6,0,255,255,255,255,6,4,1,255,0,5,6,255,4,0,0,1,4,2,0,5,4,0,5,4,255,255,255,255,5,0,255,6,2,0,1,255,0,1,6,1,255,255,4,5,2,6,4,6,255,255,255,255,255,1,5,0,0,0,255,255,4,0,255,4,255,255,5,0,255,255,5,2,255,0,0,255,1,0,255,255,1,0,0,0,1,0,5,5,0,2,0,4,4,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,35,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,63,65535,65535,65535,65,65535,67,69,71,73,75,77,79,65535,65535,65535,65535,81,83,85,65535,87,89,91,65535,93,95,97,99,101,103,105,107,109,111,113,115,65535,65535,65535,65535,117,119,65535,121,123,125,127,65535,129,131,133,135,65535,65535,137,139,141,143,145,147,65535,65535,65535,65535,65535,149,151,153,155,157,65535,65535,159,161,65535,163,65535,65535,165,167,65535,65535,169,171,65535,173,175,65535,177,179,65535,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,36,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,64,65535,65535,65535,66,65535,68,70,72,74,76,78,80,65535,65535,65535,65535,82,84,86,65535,88,90,92,65535,94,96,98,100,102,104,106,108,110,112,114,116,65535,65535,65535,65535,118,120,65535,122,124,126,128,65535,130,132,134,136,65535,65535,138,140,142,144,146,148,65535,65535,65535,65535,65535,150,152,154,156,158,65535,65535,160,162,65535,164,65535,65535,166,168,65535,65535,170,172,65535,174,176,65535,178,180,65535,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({34.5,20.5,41.5,412,28.5,102.5,33,30,18.5,306,39,43,13.5,21.5,37,3250,8.5,1081.5,28.5,22,0.032459084,21.5,-0.011736508,12,9.5,0.0106051825,-0.009361743,15.5,22,296.5,7.5,22,13,35,26.5,12788,25020,0.017201697,-0.0050740303,-0.0024862993,21.5,0.0019014201,0.0096577,-0.0016809981,-0.0048141535,-0.020609897,-0.007833733,42,536,-0.0061187553,-0.00044515022,14.5,1483.5,2388.5,363,5.5,28.5,0.010883142,-0.0001635691,3.5,102,-0.0076733865,35,4.5,6.5,9.5,-0.006387374,0.0027145601,0.008193756,201.5,34.5,72,18.5,-0.011997651,-0.01766576,0.012681036,2739,2.5,3210,198.5,491,22,28,-0.006010966,12,32,7.5,38,76,18.5,15.5,287,287,0.003850786,25111,0.008305819,0.003209769,100.5,6.5,0.010066068,283.5,0.001947311,50.5,-0.0016798096,-0.00769472,-0.005652059,-0.010935071,8903.5,2044,2456,4489,12.5,20.5,1072.5,32387,-0.0014438567,0.0004883634,0.00010084687,-0.0014538114,0.0013928137,-0.0023416912,0.0057601314,0.014295816,0.0040845643,0.011204002,-0.005531446,0.0017972154,-0.002397732,0.014181313,0.0039644428,-0.0037048988,-0.0027992928,0.0032101441,-0.0052961367,-0.029314397,-0.0062518786,0.0073128766,-0.0021872954,-0.00050969725,-0.001502406,0.003589606,-0.005986812,-0.0029836276,-0.00015911076,0.005726188,0.01214309,0.0062432713,-0.00353356,0.0010480997,0.00042474244,-0.002739441,6.273796e-05,0.002255246,-0.0012197655,0.0002266876,-0.0023606208,0.00093044987,0.002215723,0.020641029,-0.008596919,-0.00016363412,-0.00050165574,0.000118011805}, {6,8,6,0,6,0,2,2,8,0,0,2,8,8,2,5,8,5,6,0,255,8,255,8,8,255,255,8,2,6,8,5,8,0,0,0,2,255,255,255,8,255,255,255,255,255,255,0,0,255,255,8,6,3,6,8,0,255,255,8,2,255,0,8,8,8,255,255,255,6,5,6,8,255,255,255,6,8,5,5,6,2,6,255,8,6,8,2,0,8,8,5,5,255,2,255,255,6,8,255,5,255,5,255,255,255,255,0,3,5,5,8,8,0,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,65535,43,45,65535,65535,47,49,51,53,55,57,59,61,63,65,65535,65535,65535,67,65535,65535,65535,65535,65535,65535,69,71,65535,65535,73,75,77,79,81,83,65535,65535,85,87,65535,89,91,93,95,65535,65535,65535,97,99,101,103,65535,65535,65535,105,107,109,111,113,115,117,65535,119,121,123,125,127,129,131,133,135,65535,137,65535,65535,139,141,65535,143,65535,145,65535,65535,65535,65535,147,149,151,153,155,157,159,161,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,65535,44,46,65535,65535,48,50,52,54,56,58,60,62,64,66,65535,65535,65535,68,65535,65535,65535,65535,65535,65535,70,72,65535,65535,74,76,78,80,82,84,65535,65535,86,88,65535,90,92,94,96,65535,65535,65535,98,100,102,104,65535,65535,65535,106,108,110,112,114,116,118,65535,120,122,124,126,128,130,132,134,136,65535,138,65535,65535,140,142,65535,144,65535,146,65535,65535,65535,65535,148,150,152,154,156,158,160,162,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5.5,1936,645.5,1455.5,2014.5,626,1338.5,1561,2.5,4.5,2299,597,20.5,3968.5,2028,100.5,1664,1824,3929,2.5,0.005967678,821.5,3586,79.5,2804,18.5,0.036709677,1629.5,4044,2021.5,3768,467.5,230,2.5,1105.5,443,1709.5,2489.5,3803,2146.5,0.024428006,5845.5,1578,3170.5,3938,129,19.5,18.5,4060.5,239,0.014776071,1334,271,0.016023915,1320,1148.5,17,3298.5,3820.5,38.5,-0.012255612,102,464.5,0.0027542568,1350.5,3482,1268,0.0006412535,0.0058171176,6226,2647.5,2272,1692,1474.5,4988.5,0.0062083504,0.01711713,-0.0007177088,2.5,6277,2169.5,2394.5,3173,4.5,8170,123,28.5,597,783,733.5,-0.00662826,-0.020584954,-0.00041178596,0.0077985898,664.5,1468.5,12.5,157.5,1953,1651,14,4947,1766.5,0.0036736596,0.029314218,12.5,3177,3634.5,3832,27.5,51.5,32,4.5,343,475.5,0.010539021,0.025887225,640,785,2.5,1609,1.5,1475,4555.5,8446,1284.5,0.0051741293,0.004785547,0.017015295,-0.01065904,7163,-0.001234536,0.0021972833,0.0072496026,8134.5,7443,3239.5,2.5,1.5,0.009478926,2225,3449,3744.5,5667.5,5868,1.5,18063.5,173,18.5,12,121.5,117,140,446.5,1501,232,0.0059891515,-0.0042308555,975,48,927,762.5,762.5,-0.006671528,18.5,1733.5,3245,8406,4702.5,-0.00794636,-0.0043072104,15.5,7.5,2366.5,2227,2154.5,2049,9803.5,4358.5,14.5,17.5,16.5,9634.5,0.00070957636,-0.003857864,0.010765012,0.001707578,-0.009754666,-0.0012196393,-0.008216209,-0.00039168398,0.0070891418,-0.004946904,-0.02310547,-0.0013703064,-0.005186466,-0.016257772,0.0067368634,0.00014096398,0.02424551,0.003146295,0.0027569954,-0.0008812612,0.0005585559,-0.003405273,-0.002625755,-0.008167393,-0.01874074,-0.010770777,0.0013379116,-0.009024192,-0.00017031001,-0.0054051164,4.890952e-05,-0.0050879824,0.0032562849,0.005317978,-0.003101802,0.0040359474,-0.0063696573,-0.015766481,-0.005214188,0.005660783,0.002532716,-0.003390592,-0.0063319425,0.00092505425,0.0016392639,-0.0012458125,0.007153392,0.0016243464,-0.005348362,0.0005789972,0.001045839,-0.004746413,0.0034481368,0.0008541926,-0.0009338813,0.0005451621,-0.0003629544,0.0028166352,-0.003366987,0.03064127,-0.013834509,-0.0072917864,0.0009217822,-0.0044770986,-0.00036416543,0.0038367144,0.0011134752,-0.0021268162,0.0041378927,-0.01364179,0.032637917,-0.0027644148,-0.0055327136,-0.00055614254,0.0011573659,-0.0009515436,0.0042726123,-0.0024408435,-0.020014491,-0.0056238268,0.0028918048,-0.013298784,0.0010158196,0.012280635,0.0053293854,0.0013783914,-0.007282544,-0.013901479,-0.003685283,-0.013758506,-0.0038007584,0.0004260602,0.0053717806,0.0013136122,0.0030559374,-0.017611897,0.0011180391,-0.0010861518,0.008198462,0.000119118406,-0.009713418,0.0018924105,0.0021918956,-0.0114001995,0.0036611154,-0.0045832577,0.00051405124,-0.001366606,-0.003561139,0.00062256283,-0.001637252,0.0017952388,0.0032282788,-0.0015593399,-7.3343406e-05,0.0062092184,-0.0007743965,-0.00017377459}, {8,5,6,5,5,6,5,6,8,8,1,6,8,6,6,6,6,2,6,8,255,3,3,5,2,8,255,6,6,6,5,5,3,8,3,1,1,6,3,3,255,6,1,3,3,2,8,8,5,5,255,6,5,255,5,3,8,6,3,3,255,1,2,255,2,6,3,255,255,6,3,1,1,3,3,255,255,255,8,6,1,1,1,8,2,2,1,2,1,3,255,255,255,255,2,2,8,2,6,1,8,1,5,255,255,8,5,3,6,1,2,5,8,3,2,255,255,3,5,8,1,8,1,6,2,2,255,255,255,255,2,255,255,255,5,5,5,8,8,255,5,5,1,2,2,8,2,6,8,8,3,3,1,3,5,1,255,255,2,1,1,5,5,255,8,6,6,2,6,255,255,8,8,2,5,2,3,6,1,8,8,8,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,65535,77,79,81,83,85,87,89,91,93,65535,95,97,65535,99,101,103,105,107,109,65535,111,113,65535,115,117,119,65535,65535,121,123,125,127,129,131,65535,65535,65535,133,135,137,139,141,143,145,147,149,151,153,155,65535,65535,65535,65535,157,159,161,163,165,167,169,171,173,65535,65535,175,177,179,181,183,185,187,189,191,193,65535,65535,195,197,199,201,203,205,207,209,211,65535,65535,65535,65535,213,65535,65535,65535,215,217,219,221,223,65535,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,65535,65535,257,259,261,263,265,65535,267,269,271,273,275,65535,65535,277,279,281,283,285,287,289,291,293,295,297,299,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,65535,78,80,82,84,86,88,90,92,94,65535,96,98,65535,100,102,104,106,108,110,65535,112,114,65535,116,118,120,65535,65535,122,124,126,128,130,132,65535,65535,65535,134,136,138,140,142,144,146,148,150,152,154,156,65535,65535,65535,65535,158,160,162,164,166,168,170,172,174,65535,65535,176,178,180,182,184,186,188,190,192,194,65535,65535,196,198,200,202,204,206,208,210,212,65535,65535,65535,65535,214,65535,65535,65535,216,218,220,222,224,65535,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,65535,65535,258,260,262,264,266,65535,268,270,272,274,276,65535,65535,278,280,282,284,286,288,290,292,294,296,298,300,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7.5,362.5,459,100.5,5457.5,85.5,1353,36.5,4.5,2.5,16690.5,175,201,12.5,2066,914,39.5,596,44,3236,4.5,13164,21348.5,130,0.0114248395,18.5,256.5,1203,1892,2532,2169,106,22.5,3.5,53,137,1164.5,-0.01949373,6.5,1579,5509.5,2207.5,4808,5029.5,8759.5,18411,19172.5,76.5,148,96.5,124.5,173,262.5,453.5,2398,1360,1959.5,1732.5,18.5,14.5,2279,28,296.5,0.014946436,0.005070323,22,66.5,41.5,59,240,171,825.5,468.5,1164.5,394,1121.5,3614.5,1.5,8754.5,1363,2442.5,1302.5,5705.5,9803.5,7733,7793,15993,17814,20997.5,28381.5,21630.5,179,168.5,-0.016044423,-0.0047787414,29.5,141.5,42.5,0.032347083,362.5,204,0.02534537,782,782.5,2340,1142.5,4519.5,1641.5,1157.5,2223,1991.5,1034.5,2335,2175.5,-0.014290144,3996.5,4088,9994.5,2226.5,5.5,36,-0.019997332,-0.008191295,0.0069693886,-0.0009222096,-0.0005188837,-0.0038816456,0.005221033,58,-0.0034550044,1554.5,61.5,492,172.5,124.5,1.5,-0.00064223603,-0.009380037,-0.019961556,150.5,561.5,520,537.5,1191,1222,1516.5,5377.5,5083,3979,5843,-0.012398255,420,3996.5,5817.5,6235,686,1676.5,5109,4891,3663.5,4207,7647.5,11596.5,18774.5,14681.5,11460,1.5,15267.5,12764.5,18071.5,17074,0.018290589,0.009801467,-0.0123646315,22740.5,106,534.5,11.5,377,14.5,-0.007022857,0.017801775,173,0.0019277473,0.0130454125,158,-0.0009487575,372,12.5,379.5,1384.5,32.5,336,948.5,9835.5,727.5,1568,3482.5,1227.5,1034.5,897.5,694,9287.5,-0.013389773,-0.022233559,-0.016527796,2398,18.5,18.5,17.5,18.5,13.5,-0.0049608927,12.5,8868,1760.5,8443.5,2362,10187,2199,5468.5,-0.0033976329,-0.00040640892,0.0035537716,-0.00074799743,0.016309312,0.010564063,0.0107287895,0.00013023555,-0.013252611,-0.0030871376,-0.0065327263,-0.010867927,0.0020937005,0.0042096614,-0.0045219124,-2.9503542e-05,-0.0041710944,-0.009006977,-0.00069325557,0.00559837,8.467955e-05,-0.005092716,0.0024665038,-0.0045404495,-0.008164848,-0.0020373478,0.0016254124,-0.019303467,0.0022476912,0.012858033,0.0030178938,-0.009452644,0.005430319,-0.0011116046,0.0040064133,0.009842888,-0.00018642159,0.003058298,-0.005369646,0.0011908343,0.0075718323,-0.0018527623,0.017380645,-0.00045655487,-0.0035935536,0.00011319717,0.0032213423,-4.6542787e-05,-0.0002759851,0.004117449,-0.0066700513,-0.0007260696,0.0021994095,0.0046440563,-0.0014058744,0.001734949,0.0017750133,-0.0015293136,0.0026415477,-0.003443688,0.00093910715,0.0071961666,0.00030563743,-0.002664428,7.707529e-05,-0.006653335,0.010876135,0.0037840642,-0.006196098,0.0029950116,-0.0003143639,-0.0131897405,0.0022119929,-0.011971689,0.001733937,0.014877346,-3.8733386e-05,-0.018139588,0.0048993966,0.0010955714,-0.0024578145,0.0002682852,-0.00015377694,-0.0072407075,0.017619548,0.0069989935,-0.008022725,-0.004159411,0.004523493,-0.0048813084,0.0011165545,0.0062245084,0.0013628097,0.00023009884,0.006749108,0.0021657355,-0.0027757594,0.0043832953,-0.0042979787,-0.011725903,0.00145215,0.009021037,-0.003393697,0.0003790847,0.0063831294,-0.0020223646,-0.0040605366,-0.017725294,0.0017776833,0.0073469654,-0.00082907063,-0.004507856,-0.0030995738,-0.01990832,0.012253429,-0.0060529094,0.014136225,7.949136e-05,-0.0002835431,-0.005235819,-0.0006168312,-0.0077123605,0.0050770743,-0.0066139004,-0.00013940957,0.012000475,-0.006320407,-0.0011715189,0.016167855,-0.005268589,0.011361015,-0.009889674,0.0058703055,0.024579192,0.0009021315,-0.017988151,0.0018570625,0.012144054,0.0053604855,0.0016201305,-0.014832149,-0.0052260756,-3.684013e-05,-0.0057041445,-0.015640378,0.007656344,-0.00022422374,-0.006170918,-0.006637172,0.0019981281,-0.0052574063,-0.0016506426,-0.0037526556,-0.024979977,0.00062485586,-0.0003552705}, {8,7,4,6,4,7,7,7,8,8,4,6,6,8,6,4,0,6,7,6,8,4,6,6,255,8,7,6,6,7,7,4,7,8,2,7,0,255,8,4,0,7,2,7,7,7,4,7,6,2,4,0,7,7,0,6,0,4,8,8,7,2,2,255,255,0,6,6,2,6,7,0,4,0,2,7,0,8,2,6,0,2,0,6,4,7,0,6,7,6,6,4,0,255,255,2,4,0,255,4,7,255,6,6,0,7,4,2,7,6,6,0,4,2,255,0,0,6,6,8,6,255,255,255,255,255,255,255,6,255,0,4,4,0,4,8,255,255,255,2,2,6,4,6,0,6,0,4,0,0,255,4,0,6,7,0,0,0,7,2,7,4,2,2,2,7,8,7,7,6,6,255,255,255,0,4,2,8,2,8,255,255,6,255,255,7,255,4,8,7,6,6,7,4,0,7,6,2,7,6,7,7,0,255,255,255,0,8,8,8,8,8,255,8,6,4,6,4,2,6,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,65535,65535,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,65535,179,181,183,65535,185,187,65535,189,191,193,195,197,199,201,203,205,207,209,211,65535,213,215,217,219,221,223,65535,65535,65535,65535,65535,65535,65535,225,65535,227,229,231,233,235,237,65535,65535,65535,239,241,243,245,247,249,251,253,255,257,259,65535,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,65535,65535,65535,301,303,305,307,309,311,65535,65535,313,65535,65535,315,65535,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,65535,65535,65535,349,351,353,355,357,359,65535,361,363,365,367,369,371,373,375,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,65535,65535,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,65535,180,182,184,65535,186,188,65535,190,192,194,196,198,200,202,204,206,208,210,212,65535,214,216,218,220,222,224,65535,65535,65535,65535,65535,65535,65535,226,65535,228,230,232,234,236,238,65535,65535,65535,240,242,244,246,248,250,252,254,256,258,260,65535,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,65535,65535,65535,302,304,306,308,310,312,65535,65535,314,65535,65535,316,65535,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,65535,65535,65535,350,352,354,356,358,360,65535,362,364,366,368,370,372,374,376,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({9366.5,9363,9119.5,14095,13.5,10595.5,10097.5,14.5,12.5,6.5,-0.013115247,8969,19.5,9850,20641,10720.5,10645,17629.5,13097,-0.004786548,-0.008322121,8911,0.019933334,3262.5,30697,18519.5,7205.5,19757,19530.5,7880.5,6404.5,30,7513,26537,12520.5,27964.5,16240.5,7971,-0.005865394,8.5,6062,20210,3217.5,7183,25755,10027.5,10202,17187,19495,13004.5,22763,7580.5,8182,12644.5,9421.5,26.5,63.5,7106.5,13030,16167.5,-0.013967087,5.5,24228,7952.5,6815,-0.009455721,24453,19.5,9780.5,3204,17.5,0.004740811,4.5,8455,0.0066836784,0.0017836537,-0.0039625554,8769.5,9450.5,25898,23908.5,0.0013528231,0.012290246,7044,17239.5,19062,22085.5,14001,23256,29648.5,21187.5,11192,20858,7540.5,7339,4.5,9794.5,10743,12176.5,11700,10366,123,82.5,216.5,3498.5,7072.5,7199,0.0073113837,6843.5,14700,21206.5,1.5,24305.5,20691,8015,5897,16128,-0.010190927,-0.015264343,0.0047259093,14.5,3.5,7642.5,10257,8346.5,3066,0.00012452214,14.5,18.5,11002,15.5,0.002275828,0.0043502073,9642.5,6085,8604,9560,13.5,26323,12.5,14371.5,9711,9889,-0.008478657,6.5,13844.5,19830,1.5,22124,11667,19717,21778,25893,16597.5,-0.008026989,-0.01598849,26709,21562,19231,14721.5,15180.5,-0.00052152685,-0.005543342,-0.0010759172,0.0048030573,-0.0023821886,-0.00037591986,-0.011658522,-0.003357031,0.008728414,-0.0014020131,-0.0019853946,0.003985594,0.005473075,-0.00027691026,-0.018393038,-0.0037343707,0.00011255506,0.008029512,0.0013027246,0.031878676,-0.0015388088,-0.016593356,0.0011133625,-1.218825e-05,-0.0023977584,0.006243184,-0.005684978,-0.008612028,0.004247445,0.00046113582,-0.003418911,0.0008708366,-0.004996137,0.0044718287,-0.002514649,0.0044841184,-0.0022565962,0.0023818181,0.0044987327,0.0072387704,0.004404366,0.0019659996,-0.0039718817,-0.0005604189,-0.015035535,-0.0041561136,0.004316871,0.0003882559,0.005585699,0.0016738953,-0.008784812,0.0008671102,0.009810998,0.003989629,-0.000113885,0.0049073356,-0.003144441,-0.006321517,0.0006164924,0.003152527,-0.007108591,-0.00083936966,0.0023455012,0.0013509544,-0.0013618153,0.001781407,0.011497508,0.004550099,0.0013542001,-0.0071221455,0.0052310955,-0.0009830672,-0.013584717,-0.004763865,0.003804873,0.0018589834,0.01172281,0.007047628,0.0047097523,0.0025064072,-0.0022528558,0.0019447709,-0.0038680166,-0.015873538,-0.027039224,-0.0187699,0.0006641388,-0.0024175055,0.00066229556,-0.0062795305,0.020236725,0.0074547715,0.012540673,-0.010808259,0.0035553973,-0.0044750283,-0.0013605949,0.006206997,0.009298008,0.023120886,-0.022631686,-0.0140333865,-0.0075255632,0.00173729,0.00018520407,0.004503091,0.021682428,0.0102084465,-0.015230677,-0.009071348,0.017444676,-0.003268441,3.6187623e-05,0.023867968,-0.0016007845,-8.749347e-06}, {3,3,2,6,8,3,3,8,8,8,255,2,8,3,2,6,2,2,5,255,255,2,255,2,5,6,5,2,4,2,3,6,5,4,5,6,2,2,255,8,2,5,4,4,6,3,5,3,3,5,2,2,5,4,5,6,6,5,4,6,255,8,2,3,3,255,4,8,3,6,8,255,8,4,255,255,255,6,3,2,2,255,255,6,2,4,5,3,5,2,2,5,4,2,4,8,4,6,6,2,4,2,2,3,6,5,5,255,3,6,4,8,4,2,3,5,2,255,255,255,8,8,4,6,4,6,255,8,8,3,8,255,255,2,4,5,2,8,2,8,5,2,3,255,8,5,6,8,6,3,6,5,5,3,255,255,2,2,6,5,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,65535,65535,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,113,115,117,65535,119,121,123,125,127,65535,129,131,65535,65535,65535,133,135,137,139,65535,65535,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,65535,189,191,193,195,197,199,201,203,205,65535,65535,65535,207,209,211,213,215,217,65535,219,221,223,225,65535,65535,227,229,231,233,235,237,239,241,243,245,65535,247,249,251,253,255,257,259,261,263,265,65535,65535,267,269,271,273,275,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,65535,65535,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,114,116,118,65535,120,122,124,126,128,65535,130,132,65535,65535,65535,134,136,138,140,65535,65535,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,65535,190,192,194,196,198,200,202,204,206,65535,65535,65535,208,210,212,214,216,218,65535,220,222,224,226,65535,65535,228,230,232,234,236,238,240,242,244,246,65535,248,250,252,254,256,258,260,262,264,266,65535,65535,268,270,272,274,276,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3783,372,4359.5,364.5,804.5,12.5,4540.5,515.5,16.5,703,1687.5,11378.5,8785.5,4501.5,1.5,127,560.5,0.0058401665,0.03102423,219,616,1599.5,879.5,4759,4.5,6749.5,9461.5,7073.5,12.5,32363.5,5659.5,125,150.5,11.5,2.5,106,464.5,600.5,716,18.5,6.5,3639,1494.5,3844.5,8785.5,0.009536507,13322,3891.5,4193.5,-0.012889722,3959,3923.5,9843,6302,4516,24739,30108.5,5509,6052,32.5,173,152,328,-0.011620954,-0.003404621,1227,18.5,68,4.5,360.5,3284,857,-0.02925382,-0.019964326,391,1469.5,1305,0.014645705,14.5,0.018481629,0.0040895543,1247.5,1432.5,0.0003244118,4.5,7791,4139.5,0.0057515334,0.0020571356,17.5,4355.5,8009,7590.5,0.0023348685,5388.5,17,8634,16.5,4.5,5.5,-0.012379157,9070,4531,9631.5,27720.5,29652,30143.5,5496.5,5377,5943.5,5134,27.5,114,36.5,58.5,0.010176172,0.016689423,16.5,254,1158,0.0013624768,354,1072,20.5,17.5,389,197,268.5,450,327,363.5,14.5,753.5,955.5,15.5,6074.5,1191.5,905.5,1145,2132.5,19.5,1042,1588,20.5,1444.5,-0.0027818407,-0.010593012,3886,4.5,-0.0022835925,5,7487.5,3588,4254,0.012521784,4139,8246,6123.5,5109.5,-0.0020600327,-0.0069779526,3194,0.011531577,4652,4,0.007520345,0.0047691283,3.5,11,2.5,8.5,-0.014569183,-0.020284612,18.5,-0.008146792,6346,7882,25688.5,31310.5,24765,29601.5,30030.5,30324.5,4951,-0.0117829135,6040.5,5773,6018,6515.5,8343,7234,0.0005927091,-0.0014435363,0.00074425415,0.0052285837,-0.02220658,-0.010017301,0.008464622,-0.002393043,-0.0020300716,0.0037144243,0.0063273343,-0.00033137738,-0.005367642,-0.01304692,0.0004723149,0.01178529,-0.0006996968,-0.008883813,-0.0010202467,-0.008921287,0.0005859194,0.0085943295,-0.007658051,-0.0019304631,-0.0014476638,-0.0045686294,0.024642274,0.011790077,-0.0017855853,0.0059230253,0.00605615,-0.0005278219,-0.017510714,-0.0043463125,-0.009229282,-0.013300382,0.00031225078,-0.0027037235,0.00012080971,0.0077810655,-0.0016076418,-0.00880112,0.0037308985,-0.00015577638,-0.0052525303,-0.0007773975,0.01727943,-0.008066028,-0.005419464,0.016073659,0.0025211214,-0.0058847344,0.010232441,0.015032073,-0.022731619,-0.014696277,-0.0077443807,-0.0010511223,0.0006777099,0.039638165,-0.012587391,-0.0004710081,0.004474247,-0.0006300592,0.0011289226,-0.0047954596,0.011430714,0.0014204411,0.0036742021,-0.0023769273,0.029278561,0.005510406,0.0010091241,-0.0031125916,0.0037691107,0.007399946,-0.0038942557,0.00070381834,0.009282949,0.014322139,0.0071304603,0.0027287598,-0.003315355,0.0051711556,-0.0010636133,-0.0055660424,0.0028522846,-0.0021880933,-0.0017622067,-0.003331855,0.0023254808,-0.002512825,-0.00027196156,0.010947376,-0.0006306563,-0.005076775,-0.0018150862,-0.0045481916,0.0007055849,0.0044642016,-0.014101605,0.0008967621,0.010928621,0.017310783,0.005589154,-0.00072291,-0.0011892532,-0.0005865422,-0.00073486497,-0.0018232896,0.0002792855,-0.00023990632,-0.0015441461,-0.00093322305,0.0030766262,2.4110099e-05,0.004809222,0.025475273,-0.005460005,0.0038289812,-0.0029767375,-0.010881615,0.005159789,-0.002246971,0.0048492737,-0.00076671934,-0.0013877644,-6.747125e-05}, {7,2,7,2,7,8,7,6,8,6,6,2,6,7,8,7,6,255,255,7,2,6,7,0,8,6,2,1,8,1,1,6,6,8,8,6,0,2,6,8,8,0,7,0,6,255,0,7,7,255,7,1,0,1,7,7,2,1,1,7,6,0,6,255,255,7,8,6,8,6,2,0,255,255,7,2,2,255,8,255,255,0,2,255,8,6,1,255,255,8,7,6,2,255,1,8,0,8,8,8,255,2,7,2,6,0,2,1,2,0,7,1,0,7,1,255,255,8,2,6,255,2,7,8,8,1,1,0,2,6,7,8,6,0,8,0,1,6,6,2,8,0,2,8,2,255,255,7,8,255,8,1,6,7,255,1,6,2,1,255,255,0,255,6,8,255,255,8,8,8,8,255,255,8,255,1,6,6,0,6,2,0,2,6,255,6,2,7,0,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,65535,87,89,91,65535,93,95,97,99,101,103,105,107,109,111,113,115,117,65535,65535,119,121,123,125,127,129,131,65535,65535,133,135,137,65535,139,65535,65535,141,143,65535,145,147,149,65535,65535,151,153,155,157,65535,159,161,163,165,167,169,65535,171,173,175,177,179,181,183,185,187,189,191,193,195,197,65535,65535,199,201,203,65535,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,65535,65535,253,255,65535,257,259,261,263,65535,265,267,269,271,65535,65535,273,65535,275,277,65535,65535,279,281,283,285,65535,65535,287,65535,289,291,293,295,297,299,301,303,305,65535,307,309,311,313,315,317,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,65535,88,90,92,65535,94,96,98,100,102,104,106,108,110,112,114,116,118,65535,65535,120,122,124,126,128,130,132,65535,65535,134,136,138,65535,140,65535,65535,142,144,65535,146,148,150,65535,65535,152,154,156,158,65535,160,162,164,166,168,170,65535,172,174,176,178,180,182,184,186,188,190,192,194,196,198,65535,65535,200,202,204,65535,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,65535,65535,254,256,65535,258,260,262,264,65535,266,268,270,272,65535,65535,274,65535,276,278,65535,65535,280,282,284,286,65535,65535,288,65535,290,292,294,296,298,300,302,304,306,65535,308,310,312,314,316,318,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1.5,6755,31546,7114.5,32389.5,26750,18707,4787,7259.5,24658.5,24657,18240,14080,15.5,3.5,930.5,5123,2015,8730.5,8787,27845,-0.0031269204,29100.5,18245.5,32020.5,13267.5,24109.5,18700,17455.5,18913.5,23135.5,851,1611,4440.5,4813,2202,2277,-0.0031367217,-0.018875783,5947,11534.5,27296,31310,26360.5,29720.5,19746,16237,17519.5,17.5,4767.5,25496,18053.5,26993.5,11019,-0.0041072536,10981.5,17514.5,19020.5,21418,17.5,29899.5,69,-0.018676177,1149,3504,0.0034662504,-0.0031197087,0.010859767,5996,1514.5,-0.014517086,2144.5,8041.5,3363,10793.5,9654.5,22113,0.010254593,0.017246123,30020,-0.00021281275,24764.5,27857,29654,29728.5,17214.5,14501.5,21841.5,25702.5,17826.5,24372,24671,24867,0.013627,4833,11209.5,13641.5,20181,15.5,30417.5,30258,11012.5,20333.5,10924,18690,18821,19030.5,0.00035555975,19153.5,2.5,22141,21694.5,21447,15.5,30602,30,28,0.019409707,1199.5,3534.5,5531.5,5578.5,6144.5,-0.0041849012,-0.009137788,0.009385152,2180.5,7649,2330.5,0.008721781,-0.008417944,6415,8177.5,6909.5,10375,10527,17898,0.005750896,0.0032753297,-0.0008002679,25145.5,0.0023328497,28404,29594,-0.0016942027,0.00083640637,29621.5,16411.5,23299.5,20673.5,18671.5,15512.5,2397.5,18452.5,27180,21043.5,25144,18372,18646,3287.5,7.5,2569.5,24904,12.5,27063,0.0019496076,15.5,13700,27944.5,30319.5,16.5,29099,29403,29562.5,31916,4.5,8.5,6.5,-0.0060909535,2.5,23563.5,-0.0029665362,-0.009071389,17219.5,-0.0054755514,18518.5,19262.5,18368,32515,17711,2.5,19693.5,21224,-0.0014505641,23566.5,16711.5,22201,16711.5,21606,12.5,23545.5,10.5,9.5,-0.002379236,0.0028072097,-0.011151285,-0.0017730423,0.0057649943,0.002123903,-0.0023744937,0.0034252815,-0.0006564943,-0.014091978,0.0073721493,0.0001935629,0.0046484256,0.008196459,-0.0012242798,0.0034718767,0.0020091143,0.008121534,-0.010758999,-0.002259946,0.015240666,0.0062834783,-0.0035717299,0.001272595,0.010197203,-0.00027467258,-0.008437442,-0.0021284588,-0.00017029811,0.013536668,-0.002626755,0.0020508298,1.6904609e-05,-0.0006638399,-9.43196e-05,0.000230155,-0.0013605175,-0.00086867897,0.00016269278,-0.0014518463,-0.00018047867,0.006977014,-0.005536714,-0.02898846,-0.0022435186,0.006982185,0.007722191,0.019821197,-0.01684915,-0.009205072,-0.0005553923,0.009998945,0.010317097,0.019476952,-0.0034493916,0.0076799775,-0.014512609,0.0011659416,0.01940251,0.009212141,-0.002014758,-0.018526854,0.019488124,-0.0045639216,-0.0003507895,0.0017755105,0.00023357039,0.000665978,-0.0046340018,-0.0005217974,0.00013350735,0.0010970755,-0.0010731687,-0.008291079,0.004454031,-0.0002265878,-0.00033820805,-0.0029102855,-0.015812598,-0.023394344,-5.8955724e-05,-0.013378586,-0.00022498211,-0.017336166,0.016200494,0.0066084913,0.014271013,0.008096195,0.0067693056,0.0015890691,-0.0085048415,-0.019539827,-0.0026989782,0.0011485614,0.006587156,0.0009775463,-0.00043839542,8.612948e-05,-0.0019028065,-0.00052919664,0.00055957766,-0.0006372303,-0.0036235028,0.0013411469,-0.002599021,-0.0051263934,0.0014371641,0.0007128071,-0.00043856568,-0.0019483895,-0.0016589061,-0.0027100786,-0.0018365274,-0.0009953275,-0.0011056853,-2.885038e-06,-0.00096843357,-0.0017459998,0.0009950096,0.0027911998,0.0011582285,-0.000458296,0.000493857,0.0011458806,-0.0020867435,-0.00016702518,-0.0035113618,-0.0006837518,-0.0030897579,-0.000996294,-0.008499167,-0.0010001034,4.88546e-06,-0.000684995,4.1886895e-05,0.0004846971,0.00074386486,0.001441719,-0.0010217865,7.9649086e-05}, {8,3,4,6,7,4,7,7,5,7,6,5,5,8,8,5,6,7,6,6,6,255,4,3,5,5,3,7,3,3,7,5,4,3,5,5,7,255,255,7,7,7,4,4,6,7,6,7,8,3,6,5,6,5,255,5,5,7,3,8,7,3,255,5,3,255,255,255,4,3,255,7,6,6,3,6,6,255,255,5,255,4,6,6,6,3,3,3,6,6,7,6,4,255,3,7,5,7,8,5,5,3,5,5,7,3,3,255,5,8,7,5,7,8,5,6,5,255,7,4,5,6,6,255,255,255,3,7,5,255,255,6,4,5,6,4,7,255,255,255,6,255,4,4,255,255,4,3,4,7,4,7,4,4,6,3,4,4,3,4,8,6,6,8,4,255,8,3,6,4,8,4,4,3,3,8,8,8,255,8,3,255,255,3,255,3,3,3,4,5,8,3,7,255,7,3,7,3,7,8,3,8,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,65535,117,119,65535,65535,65535,121,123,65535,125,127,129,131,133,135,65535,65535,137,65535,139,141,143,145,147,149,151,153,155,157,159,161,65535,163,165,167,169,171,173,175,177,179,181,183,185,187,65535,189,191,193,195,197,199,201,203,205,65535,207,209,211,213,215,65535,65535,65535,217,219,221,65535,65535,223,225,227,229,231,233,65535,65535,65535,235,65535,237,239,65535,65535,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,65535,279,281,283,285,287,289,291,293,295,297,299,301,65535,303,305,65535,65535,307,65535,309,311,313,315,317,319,321,323,65535,325,327,329,331,333,335,337,339,341,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,65535,118,120,65535,65535,65535,122,124,65535,126,128,130,132,134,136,65535,65535,138,65535,140,142,144,146,148,150,152,154,156,158,160,162,65535,164,166,168,170,172,174,176,178,180,182,184,186,188,65535,190,192,194,196,198,200,202,204,206,65535,208,210,212,214,216,65535,65535,65535,218,220,222,65535,65535,224,226,228,230,232,234,65535,65535,65535,236,65535,238,240,65535,65535,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,65535,280,282,284,286,288,290,292,294,296,298,300,302,65535,304,306,65535,65535,308,65535,310,312,314,316,318,320,322,324,65535,326,328,330,332,334,336,338,340,342,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({372,326,236.5,129,19.5,437,254,133,209,15,0.026832579,10.5,12.5,248.5,1037.5,128.5,169.5,68,21.5,430,0.0008864578,-0.009565949,-0.005974164,448.5,177,0.019790508,1032.5,1365.5,1107,125,0.022422856,54,74.5,17.5,245.5,324.5,-0.0058428016,7.5,0.0057991063,-0.00057096983,1856.5,197,567,326.5,7184.5,20.5,1002.5,20.5,7996,116.5,304.5,83,0.0028362446,21.5,11.5,7,0.004180875,230.5,18.5,18.5,373.5,0.009520157,0.015692981,2.5,-0.00043030526,-0.007878113,-0.0026160614,204,18.5,13.5,12.5,4476.5,4.5,1568,739.5,17.5,14.5,18.5,0.038021002,15.5,8619.5,32.5,15.5,112.5,-0.008761145,46,-0.0067993687,63.5,-0.0065782457,1972.5,73.5,0.0021402251,-0.0035665173,0.017233657,15.5,3.5,-0.002696913,143.5,302,14,18.5,-0.0100569045,6.5,15.5,0.001987633,-0.0054406635,-0.0022698378,6.5,0.0018053908,-0.0017620102,-0.006280503,0.0068567186,10.5,0.0029522392,16676,217,-0.0141382115,579,873.5,1421,1808,8.5,-0.023546696,1000.5,0.015943302,7551.5,1637.5,7027.5,8813.5,-0.0001438187,0.0015663728,0.002315901,0.0084975315,-0.0031652802,0.0035662192,-0.019818624,-0.010608983,0.000109516106,0.0038568247,-0.0046657054,0.001261062,-0.0066371313,0.00035458987,0.0046381494,0.011078741,-0.00011692698,0.005235974,0.0032665469,-0.0031421252,0.010964717,-0.0016213738,0.0052438104,0.011967294,0.0027864585,-0.004938237,-0.004390139,-0.006128778,-0.0026118706,-0.00032923635,-0.0006486978,-0.0025894314,0.005220572,0.0007523934,0.00031141576,-0.002234569,-0.0046637896,-0.00010059562,0.002106628,-0.011297539,0.04254884,0.0041391803,-0.016905129,-0.0025986994,0.00841743,-0.0034914936,-0.005481253,0.0004471815,-0.0029432748,0.0044790963,-0.0004964216,0.0011620468,-0.004699893,0.0012746712,-0.0031644409,-0.00088742236,0.002686382,-0.00015331569}, {2,3,3,3,8,2,4,0,2,8,255,8,8,0,5,0,0,4,8,0,255,255,255,2,4,255,2,0,4,2,255,3,3,8,4,5,255,8,255,255,4,0,0,3,0,8,5,8,0,0,2,4,255,8,8,8,255,0,8,8,5,255,255,8,255,255,255,3,8,8,8,0,8,4,5,8,8,8,255,8,0,3,8,3,255,2,255,2,255,0,4,255,255,255,8,8,255,3,2,8,8,255,8,8,255,255,255,8,255,255,255,255,8,255,0,0,255,5,4,0,2,8,255,3,255,0,2,2,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,37,65535,65535,65535,39,41,65535,43,45,47,49,65535,51,53,55,57,59,65535,61,65535,65535,63,65,67,69,71,73,75,77,79,81,83,85,65535,87,89,91,65535,93,95,97,99,65535,65535,101,65535,65535,65535,103,105,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,65535,135,65535,137,65535,139,141,65535,65535,65535,143,145,65535,147,149,151,153,65535,155,157,65535,65535,65535,159,65535,65535,65535,65535,161,65535,163,165,65535,167,169,171,173,175,65535,177,65535,179,181,183,185,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,38,65535,65535,65535,40,42,65535,44,46,48,50,65535,52,54,56,58,60,65535,62,65535,65535,64,66,68,70,72,74,76,78,80,82,84,86,65535,88,90,92,65535,94,96,98,100,65535,65535,102,65535,65535,65535,104,106,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,65535,136,65535,138,65535,140,142,65535,65535,65535,144,146,65535,148,150,152,154,65535,156,158,65535,65535,65535,160,65535,65535,65535,65535,162,65535,164,166,65535,168,170,172,174,176,65535,178,65535,180,182,184,186,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1685.5,1666,2119.5,12.5,7175,2971.5,2220,1203,1220.5,16.5,-0.01570305,18.5,5758.5,2199,8040.5,495,1027,1146,2551,3337.5,19.5,15.5,1902.5,18.5,18.5,15.5,-0.020430537,7505.5,9087.5,442.5,3245.5,2430.5,1886,904,2027.5,17.5,2966,-0.011136774,9.5,0.0038996858,-0.007653165,6.5,1753.5,0.0007341109,0.035719298,15.5,-0.019152308,1803.5,7761.5,2191,-0.0130135715,5863,9659.5,12901,9583.5,180,341.5,6.5,1348.5,1074.5,581.5,2079.5,1102,851.5,5081,737.5,2134,1039,1590.5,18.5,1321.5,-0.0007492721,-0.0072194445,1686,1686,-0.012846979,-0.00078719825,2159,-0.0056950734,12.5,2092.5,0.026157213,1943.5,0.009843264,7.5,5798,10031.5,7531.5,11441.5,8939.5,-0.0109625,9573.5,17.5,100.5,428,231,340.5,2.5,920,-0.0073408796,1.5,581.5,4.5,5.5,6.5,859,8176.5,7.5,1729,770,19.5,472,971,668,1082,-0.01823639,1600,1257.5,15.5,1142.5,1638.5,0.006070661,0.010614026,18.5,1268.5,0.0034755208,1889,0.014123723,13.5,-0.0007981796,11.5,6.5,1630.5,7029.5,-0.0032647548,0.0007769565,-0.008464856,-0.0027827735,0.0021826928,5758.5,5720.5,6823,8393,12.5,2808,-0.02051979,5.5,8911,8232,11887,9575.5,17663,9823.5,2.2339691e-05,-0.001975083,0.0057814997,0.00033705565,-0.0034229213,0.0011971338,-0.016669473,-0.0031022981,0.003183762,-0.0005884024,0.0023204598,0.0071524144,0.0028937215,-0.0005717213,-0.004709501,0.0069221086,-0.0005406388,-0.014143698,-0.004527017,0.0009485934,0.0049476894,0.00038601315,0.00062126486,0.008457838,-0.0017298249,0.0015654409,-0.012987862,-0.005250545,-0.00040116446,-0.0032708794,-3.661248e-06,-0.0076938444,0.002072727,0.025744328,-0.0002238748,-0.015738146,0.0017843427,-0.0011587074,0.0015389906,-0.020246297,0.012523176,0.0024854017,-0.0042964625,0.003702695,0.0036476937,0.0074827666,0.00095104094,-0.008311618,-0.009146313,-0.023936916,0.0017375136,-0.010886044,-0.0019959959,-0.0064626248,0.007288812,0.00034070306,-0.00532387,0.00054644275,0.0061849374,0.0011471618,0.003911297,0.00040100096,0.004136044,0.006645412,0.0008148267,0.004135458,-0.0012728566,0.0017358005,0.0004372637,-0.005807396,-0.0008649397,0.010180852,4.6565085e-05,-0.0043817186,-0.00023268333,0.00529737,0.016277365,0.0050857854,-0.00041940907,0.0020806051,0.0019156495,0.0005453284,-0.00048792773,0.00585343,-0.009111659,-0.0019700346,0.00061071396,-0.008312519,0.009273834,0.0011110218,-0.00038292338,0.00018177519,0.0011786552,-0.00090440887}, {7,7,6,8,0,1,6,6,7,8,255,8,1,6,6,7,7,6,0,0,8,8,6,8,8,8,255,7,6,6,1,0,6,6,6,8,0,255,8,255,255,8,0,255,255,8,255,6,1,7,255,7,0,0,6,5,5,8,5,0,7,5,1,7,5,1,0,0,7,8,7,255,255,6,6,255,255,7,255,8,6,255,7,255,8,7,1,7,1,6,255,6,8,6,0,7,7,8,6,255,8,0,8,8,8,1,1,8,5,7,8,1,6,1,5,255,1,5,8,1,7,255,255,8,5,255,0,255,8,255,8,8,6,1,255,255,255,255,255,7,6,1,5,8,0,255,8,6,0,0,6,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,65535,71,65535,65535,73,75,65535,65535,77,65535,79,81,83,65535,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,65535,65535,125,127,65535,65535,129,65535,131,133,65535,135,65535,137,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,65535,195,197,199,201,203,65535,65535,205,207,65535,209,65535,211,65535,213,215,217,219,65535,65535,65535,65535,65535,221,223,225,227,229,231,65535,233,235,237,239,241,243,245,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,65535,72,65535,65535,74,76,65535,65535,78,65535,80,82,84,65535,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,65535,65535,126,128,65535,65535,130,65535,132,134,65535,136,65535,138,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,65535,196,198,200,202,204,65535,65535,206,208,65535,210,65535,212,65535,214,216,218,220,65535,65535,65535,65535,65535,222,224,226,228,230,232,65535,234,236,238,240,242,244,246,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4.5,519,295,467.5,2966,112.5,255.5,228.5,476,2249.5,1952.5,118.5,8.5,52.5,2171.5,114,526.5,-0.025003368,975,2.5,7916,7169.5,2019.5,21.5,99.5,680,21.5,10.5,6.5,999.5,30365,126.5,121.5,183.5,326,-0.0041820537,-0.0002205342,1455,1253.5,5412.5,1021,3725,1.5,8397.5,2372,137.5,53.5,9.5,1386,37,7.5,20.5,37,-0.019959716,-0.0039728233,208,121.5,956.5,1011.5,32041.5,23121.5,32.5,62,36.5,206,74.5,382.5,1508,3222.5,1328.5,1025,449.5,1586.5,33,0.004112922,2.5,3060.5,2054.5,1909.5,7365.5,3555,0.009488903,0.01829545,3667,5760.5,130.5,169.5,31.5,99.5,-0.013025433,36.5,11.5,0.006147833,447.5,217.5,0.002056847,0.0038865374,103,-0.009491894,0.024087125,-0.00429273,5.5,0.005851831,1333.5,11.5,633.5,20.5,-0.017966146,14.5,27171,9.5,30507.5,30371,29.5,46.5,-0.008744351,248,32,0.007622222,0.018324217,0.009375642,1188,933,335.5,61,0.0074664303,2.5,0.0042602257,377,646.5,1062,1239.5,1378,0.0043917676,630.5,1175.5,1684.5,0.002997103,1828.5,0.006123516,0.0035850566,-0.003364451,2.5,-0.014205679,2669.5,1466.5,4085.5,-0.004670139,1505.5,8006.5,0.0009403868,1.5,2204,5738,5770,6.5,0.009179263,28,24,25.5,46,0.018319398,0.00371865,-0.0015130141,-0.0063735084,104.5,15.5,0.00665482,0.0034039475,0.015255736,0.0071619176,18.5,256,-0.002207751,0.0022845147,0.005352442,11.5,236.5,742,618,681.5,985.5,0.0360173,4528.5,5315.5,27964,27639,-0.003413651,17604,30440.5,16.5,0.0039450745,15.5,0.00035233796,-0.0050397976,0.011779734,0.00029301483,0.00042282263,-0.006660069,-0.01359377,0.0010188984,-0.0039689406,0.0038461972,-0.0052351835,-0.01107053,0.00596581,0.010413318,0.0048370524,-0.0041077915,0.004020106,0.0018021237,-0.00040939558,-0.0013373507,0.006121868,0.0011337595,0.014337681,0.008303011,-0.016393214,-0.0012425829,0.011599206,-0.007873587,0.0007526348,-0.0038660516,0.013613681,-0.0049190647,0.013596341,0.023632368,-0.004329223,-0.00024703157,0.0025218525,0.00058959465,-0.0047091627,0.0021539165,0.011005317,0.0026495392,-0.0050942567,0.00063148764,-0.017598085,-0.010112412,-0.0025601133,-0.006828572,0.0034983128,0.0006131194,0.0019282701,-0.0033404853,0.0013513484,0.013052883,-0.01569273,0.00013556115,0.0018928417,0.00012525891,-0.01510378,-0.004032813,0.0055817864,-0.0006009784,0.00045635537,-0.0039092,0.007896288,-0.0027048315,7.715874e-05,-0.0043816264,0.0021274632,-0.0010662072,-0.003418614,0.004310558,0.004496692,-0.00014041652,-0.003624523,-0.005540701,-0.007583315,0.0011220525,-0.0021393285,-0.0062794834,0.0014581968,0.017777745,-0.00799498,-0.0005713731,0.00077387714,0.008517625,-0.0044053807,-0.00022653978,0.0015667164,-0.0017013384,-0.00015639797,0.004899093,0.0033918251,4.4527296e-05,-0.004016911,-0.0058172806,-0.0032382843,-0.015990287,-0.00041512903,-0.0013911173,-2.2553251e-05,0.0005985293}, {8,5,2,5,0,3,3,0,5,7,5,2,8,5,7,0,7,255,7,8,7,0,5,8,0,7,8,8,8,2,2,2,2,3,5,255,255,2,2,3,2,0,8,0,7,0,3,8,0,7,8,8,7,255,255,5,3,3,2,0,3,3,3,5,2,3,2,0,7,0,7,3,7,0,255,8,2,3,7,0,7,255,255,2,5,0,0,5,7,255,5,8,255,0,5,255,255,5,255,255,255,8,255,0,8,0,8,255,8,0,8,2,2,5,5,255,2,3,255,255,255,0,0,2,7,255,8,255,5,7,7,3,7,255,5,7,3,255,0,255,255,255,8,255,3,3,7,255,5,0,255,8,5,5,5,8,255,5,7,5,2,255,255,255,255,3,8,255,255,255,255,8,0,255,255,255,8,3,0,0,0,2,255,0,0,2,2,255,7,2,8,255,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,65535,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,65535,139,141,143,145,147,149,65535,65535,151,153,155,157,159,161,65535,163,165,65535,167,169,65535,65535,171,65535,65535,65535,173,65535,175,177,179,181,65535,183,185,187,189,191,193,195,65535,197,199,65535,65535,65535,201,203,205,207,65535,209,65535,211,213,215,217,219,65535,221,223,225,65535,227,65535,65535,65535,229,65535,231,233,235,65535,237,239,65535,241,243,245,247,249,65535,251,253,255,257,65535,65535,65535,65535,259,261,65535,65535,65535,65535,263,265,65535,65535,65535,267,269,271,273,275,277,65535,279,281,283,285,65535,287,289,291,65535,293,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,65535,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,65535,140,142,144,146,148,150,65535,65535,152,154,156,158,160,162,65535,164,166,65535,168,170,65535,65535,172,65535,65535,65535,174,65535,176,178,180,182,65535,184,186,188,190,192,194,196,65535,198,200,65535,65535,65535,202,204,206,208,65535,210,65535,212,214,216,218,220,65535,222,224,226,65535,228,65535,65535,65535,230,65535,232,234,236,65535,238,240,65535,242,244,246,248,250,65535,252,254,256,258,65535,65535,65535,65535,260,262,65535,65535,65535,65535,264,266,65535,65535,65535,268,270,272,274,276,278,65535,280,282,284,286,65535,288,290,292,65535,294,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({20879.5,22651,23059.5,18831.5,12573,21135,14636,14022.5,18855,18960.5,23186,17529,25460.5,14.5,21790,22262.5,1.5,13866.5,24148.5,15.5,20181.5,16210.5,0.0025903771,16991.5,17752,20334,30801.5,18102,18102,28745.5,29648.5,13809.5,-0.010255877,5761.5,23481,10655.5,3.5,21124.5,22373.5,0.005346244,0.0010608825,-0.0028772035,0.0018875691,0.009769442,26172.5,27606,15.5,21515,18622,-0.023484746,3.5,29582.5,0.0020594753,15714.5,7534,13317.5,6251.5,14321,20703,23721,18360.5,13603,11369.5,16413.5,17121,15311,15361,10595,12107.5,16244,18427.5,18031,-0.010344833,-0.0057575232,19.5,0.019348236,0.013221449,11172.5,15.5,6.5,-0.012037983,0.025207525,0.016405553,0.012369544,-0.0030251981,-0.009857859,22575.5,-0.0071909367,-0.0044747377,-0.0151546225,13317.5,19442,20371,7202,28154.5,32031,16788.5,15.5,20698,15,-0.0013426653,16319.5,32059,30717.5,29713,15.5,11473,11901,14446,0.002184307,-0.00034742855,17552,0.005774421,15499,15177,0.012672584,8.5,19417.5,7703,13.5,12.5,0.008529905,0.012763373,0.020214392,0.013353832,-0.011393611,-0.018369466,2,20.5,23056.5,15.5,22017.5,0.002124733,-0.007136787,17370,21824,-0.01266861,9339.5,28154.5,6.5,2.5,28725.5,27861.5,28153.5,9266,10027,14169.5,29826.5,-0.0029477407,-0.0004630864,19470,0.0032675348,-0.00036128063,0.01831512,15.5,5.5,0.0019914154,20543,22730.5,1.5,6.5,9.5,18618.5,29727.5,28964.5,-0.00019548053,0.00043620795,-0.0036027536,-0.015756825,0.010419876,-1.394519e-05,0.0009975861,0.008765212,0.012208272,0.02040762,-0.0035059645,0.0027371887,0.0077610496,-0.009876299,-0.0012335893,0.0019735869,0.0039252657,-0.00085474376,0.0027060525,-0.014201644,-0.008524447,0.005597631,0.005604224,0.001144891,0.00085667474,0.0016270159,-0.0023650664,-0.0005839394,-0.006192802,0.0030041772,0.0002901499,-0.0023584883,0.0041809063,0.009708277,-0.0053619794,-0.0033694922,-0.015392068,-0.021177541,0.0021327985,-4.769433e-07,-0.000734256,-0.0061675557,0.007142288,0.0032553715,0.0051500495,-0.0018120836,0.0040839347,0.00016278628,0.0093481615,0.0045054783,-0.0063524195,-0.0112715345,0.0031309642,-0.002211435,0.0006234043,-0.0036046528,-0.018961579,-0.0039739474,0.001260537,-0.0009477023,0.006593577,0.0015435497,0.01135379,0.006147162,0.003261093,0.005373914,-0.0008133594,0.007610065,-0.016054852,0.0076361257,0.013567981,-0.0048982147,-0.0002344358,0.00028815088,-0.0027973044,-0.0046035266,-0.0013070664,-0.0003418728,-0.0016908696,-0.00058941415,0.0050398814,2.3166893e-05}, {0,2,0,0,1,1,7,7,1,0,5,1,7,8,2,2,8,1,5,8,0,7,255,1,5,7,7,1,1,0,0,0,255,0,5,1,8,1,1,255,255,255,255,255,2,2,8,0,1,255,8,7,255,2,7,1,7,1,5,1,1,0,5,7,0,0,1,5,5,7,1,2,255,255,8,255,255,1,8,8,255,255,255,255,255,255,2,255,255,255,1,1,1,7,0,2,5,8,1,8,255,1,1,2,0,8,7,2,2,255,255,7,255,1,1,255,8,0,1,8,8,255,255,255,255,255,255,8,8,2,8,0,255,255,1,0,255,7,0,8,8,0,1,0,7,7,1,1,255,255,5,255,255,255,8,8,255,7,2,8,8,8,5,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,65535,45,47,49,51,53,55,57,59,61,65535,63,65,67,69,71,73,65535,65535,65535,65535,65535,75,77,79,81,83,65535,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,65535,127,65535,65535,129,131,133,65535,65535,65535,65535,65535,65535,135,65535,65535,65535,137,139,141,143,145,147,149,151,153,155,65535,157,159,161,163,165,167,169,171,65535,65535,173,65535,175,177,65535,179,181,183,185,187,65535,65535,65535,65535,65535,65535,189,191,193,195,197,65535,65535,199,201,65535,203,205,207,209,211,213,215,217,219,221,223,65535,65535,225,65535,65535,65535,227,229,65535,231,233,235,237,239,241,243,245,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,65535,46,48,50,52,54,56,58,60,62,65535,64,66,68,70,72,74,65535,65535,65535,65535,65535,76,78,80,82,84,65535,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,65535,128,65535,65535,130,132,134,65535,65535,65535,65535,65535,65535,136,65535,65535,65535,138,140,142,144,146,148,150,152,154,156,65535,158,160,162,164,166,168,170,172,65535,65535,174,65535,176,178,65535,180,182,184,186,188,65535,65535,65535,65535,65535,65535,190,192,194,196,198,65535,65535,200,202,65535,204,206,208,210,212,214,216,218,220,222,224,65535,65535,226,65535,65535,65535,228,230,65535,232,234,236,238,240,242,244,246,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8076.5,15.5,8622.5,7511,805.5,9093,8626.5,9431,8386.5,747.5,837.5,6186,9542,8625.5,8816,6252,6284.5,5633,7117,472,18.5,1616.5,5094.5,8580.5,8366.5,0.008442841,17.5,0.005310259,12.5,8742.5,10986,6249,5550.5,2763.5,6915,6749,6199,8005.5,8255.5,444,746.5,-0.00730372,-0.023646599,812,0.026915494,53.5,5123,5779.5,8587.5,7758.5,8757.5,4.5,8457,0.013788669,0.0086612,6088,8748,10982,10655.5,4483,0.013264216,5097,6437.5,2565.5,3906.5,6686.5,6970.5,4254.5,1.5,6878.5,7568.5,7608,-0.0050928947,-0.022779584,8562.5,4123,0.013575599,500.5,0.015384706,0.012829656,0.005341036,-0.017952511,586,-0.012395386,17.5,5617.5,2090,-0.012221213,11.5,8455.5,9188,-0.02046439,7476.5,11050.5,11050.5,0.004060132,0.00096054096,6393.5,4.5,7160.5,12.5,18.5,-0.012266022,15.5,13675,228.5,5123,1.5,7224,6331.5,1.5,-0.0015475348,2821.5,4017.5,10656,12070.5,6785,-0.008651028,3.5,7694,7871,-0.0064500817,6795,4572.5,4.5,6646.5,7809.5,-0.004936737,4.5,-0.007858423,8.5,79.5,296.5,-0.02361589,28.5,20.5,912,5600,7602,8351.5,2.5,350.5,5397,2917,2426.5,8043,0.008072923,-0.020948956,-0.0029411882,-0.0027843358,8912.5,8699,0.0012550647,8457,8400.5,591.5,5.5,8511,8693,11.5,0.004934428,6910.5,8708.5,9361,9069,4.5,18.5,8188,12688,0.0004085423,-0.00088967936,-0.0017146394,0.0012296892,-0.005158087,-0.0007320373,0.015548098,0.0021672451,-0.01368212,-0.0062098135,0.0056872065,-0.0021501505,0.0054001375,0.0014404397,-0.0013858756,-0.013013425,0.0021475896,-0.00039363533,0.019006198,0.003213151,0.00042074537,0.004670952,-0.005543809,0.0010793902,0.0028664162,-0.0009127282,-0.0070075453,-0.0015370569,0.007359778,0.0012745928,0.003212158,0.011276285,0.027682552,0.019796813,0.0016086604,-0.0036125479,0.0096600335,0.0028778668,0.0024649752,-0.0005702361,0.0027973477,0.0006358059,-0.00054244295,0.0022189857,-0.004467807,-0.01308944,0.0040250397,-0.005061385,0.0016934256,0.02346289,0.007619619,0.0017036684,0.0028824909,0.00033875715,-0.0007525025,0.0013246826,-0.014180212,-0.0041291458,-0.0045058117,-8.508059e-05,0.0023731226,-0.0009469648,0.00917594,0.0029703302,0.0065454612,-0.003960837,-0.0127304215,-0.00043990152,-0.0031415783,-0.008107661,-0.019828534,-0.00565748,0.001392939,0.0034840906,0.0012398696,8.169574e-05,-0.0016180888,-0.00059714186,-0.0012300073,0.0005194946,-0.013608241,-0.0022790625,0.008655505,-0.00017268733,-0.0022726557,0.0015419365,0.020950038,0.013301578,0.0014832738,-0.0024944362,0.0067804875,-0.0013615303,-0.0020618683,-1.914441e-05,0.002314573,-0.0018122618,0.0016101145,-0.0006907372,0.0020584296,0.003750116,0.0001737992,-0.006039703,0.001503724,-0.00011028523}, {0,8,0,0,3,1,0,3,6,3,3,3,1,0,0,1,0,5,1,1,8,6,6,0,0,255,8,255,8,0,1,1,3,0,0,6,5,0,5,1,3,255,255,3,255,6,6,5,0,5,1,8,0,255,255,3,0,1,0,1,255,6,3,6,1,1,0,6,8,6,6,0,255,255,1,6,255,1,255,255,255,255,6,255,8,6,3,255,8,1,5,255,3,5,5,255,255,6,8,3,8,8,255,8,0,0,6,8,1,6,8,255,6,0,3,3,0,255,8,0,0,255,6,6,8,6,6,255,8,255,8,1,3,255,6,8,1,3,3,0,8,3,3,1,1,1,255,255,255,255,3,3,255,0,0,6,8,6,0,8,255,6,1,0,0,8,8,3,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,65535,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,65535,79,65535,81,83,85,87,89,91,93,95,65535,65535,97,99,101,103,105,65535,107,109,111,113,115,117,119,121,123,125,127,65535,65535,129,131,65535,133,65535,65535,65535,65535,135,65535,137,139,141,65535,143,145,147,65535,149,151,153,65535,65535,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,65535,181,183,185,187,189,65535,191,193,195,65535,197,199,201,203,205,65535,207,65535,209,211,213,65535,215,217,219,221,223,225,227,229,231,233,235,237,65535,65535,65535,65535,239,241,65535,243,245,247,249,251,253,255,65535,257,259,261,263,265,267,269,271,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,65535,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,65535,80,65535,82,84,86,88,90,92,94,96,65535,65535,98,100,102,104,106,65535,108,110,112,114,116,118,120,122,124,126,128,65535,65535,130,132,65535,134,65535,65535,65535,65535,136,65535,138,140,142,65535,144,146,148,65535,150,152,154,65535,65535,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,65535,182,184,186,188,190,65535,192,194,196,65535,198,200,202,204,206,65535,208,65535,210,212,214,65535,216,218,220,222,224,226,228,230,232,234,236,238,65535,65535,65535,65535,240,242,65535,244,246,248,250,252,254,256,65535,258,260,262,264,266,268,270,272,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({9395.5,14286.5,9119.5,8544.5,12.5,10206,10097.5,8520.5,8157.5,20737,15835.5,9520,-0.011432136,9850,21348.5,12.5,8536.5,4960.5,5978.5,16167.5,27277,26537,27277,8382,10595.5,1.5,7330,19302,21630.5,10534,10645,0.022647155,0.0022070997,12.5,6182.5,5207.5,9410,1.5,5055,4681,27964.5,7952.5,-0.015717188,24550.5,16.5,11.5,0.021623936,4.5,18.5,10011,9350,10027.5,11447,14470.5,20342.5,20085.5,19172.5,9693.5,6809,9132.5,11576.5,2581.5,7349.5,7712.5,4.5,396,5737.5,6945.5,1.5,15583.5,4.5,5.5,7513,0.0016995516,5776.5,7.5,-0.0023710472,15708,-0.013208545,24224,26388,-0.004130956,-0.006911838,0.004496907,-0.00067904784,9510,9810,17.5,3178,-0.015406932,-0.003277599,6914.5,9444,0.00045235935,0.008376819,4.5,15.5,19598.5,1.5,18812,19457.5,15032.5,-0.014929247,18487,22763,7.5,5033.5,4.5,11823.5,8946.5,4193,12575.5,11752,2.5,7661.5,15.5,15.5,0.015123598,17.5,1.5,7679,8722.5,523.5,5.5,12.5,8685,8553,-0.024804195,10643,-0.0034495853,-0.008447288,4438,14579.5,17058,17964,7035,8533,0.008437333,24228,-0.00094479835,0.0017763667,15.5,14430,16676,17.5,15.5,0.006329063,9902.5,7921,15.5,14.5,14.5,-0.0058964374,3217.5,3296.5,9493.5,9877.5,9413,6277.5,-0.007241029,7044,24720,-0.0041810437,13767.5,0.018133946,16257.5,20716,18118.5,-0.00897359,0.017161576,21957.5,14.5,-0.0018706359,17720.5,6.5,17026.5,15180.5,-0.00011657861,-0.00077748706,0.0004940115,-0.0030916343,0.0029799386,-5.7632915e-05,0.0045930604,0.0004228864,0.00029779138,-0.0076086014,-0.013961266,0.001324198,-0.002667641,-0.011854125,0.009115524,-0.00095653255,0.0039818296,0.0016824764,-0.0019899076,0.00028146053,-0.003910759,-0.0022900456,-0.00156885,0.0003865129,0.005391739,0.0011275507,0.00074891024,0.004488596,0.00093559205,-0.0032334568,-0.00026444366,0.0076417546,-0.0021011874,-0.00020284076,0.0033417426,0.008138015,-0.0049124174,0.0022725554,0.007120871,-0.008105249,-0.0028478845,-0.016723994,-0.003110076,0.005945956,0.0013868882,0.0054260134,-0.0061364695,0.00012753023,-0.002621522,0.0026318494,-0.0011797245,-0.005062814,-0.0043740175,-0.010238893,0.0054273917,-0.0065765367,0.00568111,0.0031384216,-0.0038500056,-0.00044573486,-0.0069458345,-0.0028986046,-0.003847853,0.002069476,-0.005279429,-0.007824556,0.003327474,8.649181e-05,0.008169757,0.004660085,0.0012839268,0.0026107866,0.0014187358,0.003344841,0.004536201,0.008147095,-0.000108425294,0.0024743434,0.0031119334,-0.005778385,0.0067257285,0.003357676,0.00613996,-0.0020078043,-0.021446364,-0.007954235,0.004303066,0.0071000517,0.005836082,-0.0003562056,-0.011354502,-0.018092532,-0.00014382793,-0.001865364,2.508655e-05,0.0019664057,0.012764028,0.0060764835,-0.004680998,0.0030362697,-0.009860401,0.011087963,0.0020513346,-0.0016163349,-0.013022633,-0.008034239,0.0053143282,0.00018642245,0.013076792,0.020239016,0.00048925023,-0.008706701,-0.0013310564,6.274087e-05}, {3,6,2,3,8,0,3,3,2,2,2,3,255,3,6,8,3,6,0,6,2,4,2,2,3,8,0,4,6,2,2,255,255,8,6,0,2,8,3,3,6,3,255,4,8,8,255,8,8,6,2,3,4,3,2,3,4,2,3,6,2,6,0,0,8,4,0,6,8,0,8,8,3,255,3,8,255,6,255,0,2,255,255,255,255,4,0,8,2,255,255,0,3,255,255,8,8,0,8,3,4,3,255,4,2,8,3,8,2,6,0,4,2,8,0,8,8,255,8,8,0,3,4,8,8,3,3,255,6,255,255,3,6,6,2,3,3,255,2,255,255,8,2,0,8,8,255,3,2,8,8,8,255,4,2,6,0,3,6,255,6,4,255,2,255,0,3,2,255,255,0,8,255,4,8,3,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,65535,65535,61,63,65,67,69,71,73,75,77,65535,79,81,83,65535,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,65535,137,139,65535,141,65535,143,145,65535,65535,65535,65535,147,149,151,153,65535,65535,155,157,65535,65535,159,161,163,165,167,169,171,65535,173,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,201,203,205,207,209,211,213,215,217,65535,219,65535,65535,221,223,225,227,229,231,65535,233,65535,65535,235,237,239,241,243,65535,245,247,249,251,253,65535,255,257,259,261,263,265,65535,267,269,65535,271,65535,273,275,277,65535,65535,279,281,65535,283,285,287,289,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,65535,65535,62,64,66,68,70,72,74,76,78,65535,80,82,84,65535,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,65535,138,140,65535,142,65535,144,146,65535,65535,65535,65535,148,150,152,154,65535,65535,156,158,65535,65535,160,162,164,166,168,170,172,65535,174,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,202,204,206,208,210,212,214,216,218,65535,220,65535,65535,222,224,226,228,230,232,65535,234,65535,65535,236,238,240,242,244,65535,246,248,250,252,254,65535,256,258,260,262,264,266,65535,268,270,65535,272,65535,274,276,278,65535,65535,280,282,65535,284,286,288,290,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8.5,897.5,15283,600,1473,13816,12069,112.5,443.5,1287.5,2376.5,14.5,14091.5,13862,16463,104.5,216,341.5,556,4.5,1579,11386,3212,1235.5,10435.5,7678.5,14759.5,12.5,9637,17251.5,20183.5,100.5,61.5,136.5,368.5,4.5,3.5,488,960.5,1088,1142.5,6.5,2.5,5134,-0.011618904,2456,4506.5,1234,5197,10831,9852,15167,15091.5,14118,16422,10441,14730,32482.5,9078.5,15190.5,13.5,17001.5,19186,54.5,94.5,-0.019897873,193.5,0.00819726,0.017648743,167,22,147.5,7.5,-0.0029683176,340.5,1705.5,0.010013428,870,1687.5,1011.5,1169.5,1004.5,1517,3.5,1879,0.0060737827,4.5,2.5,2241,2578.5,4.5,9135.5,6531.5,1580.5,1913,2204.5,5608.5,4926,15.5,8989.5,11620.5,7356.5,3192,13209,10478.5,0.0027067286,17055,-0.0065180673,-0.01073218,9684,21878.5,7021.5,21493.5,15.5,21814.5,28758.5,27290,-0.013333268,18675.5,2.7031505e-05,0.0008637599,17745.5,21713.5,18487,23366,333,62,125,187.5,118.5,238,139,358,-0.009845563,68,646,2.5,334,-0.0053030374,-0.01680019,-0.007368216,364.5,-0.0030887423,4.5,917,806,1174,-0.0012475066,2.5,-0.008688757,2196,0.005478934,1590.5,1308,-0.004428147,1375.5,2503.5,0.0062914537,2.7986584e-05,-0.0016992318,6.5,8521,2207.5,1.5,3537.5,4.5,5.5,2689.5,3189.5,4786,14643,6378.5,18076.5,32.5,664.5,3286,11.5,1183.5,3996,5676.5,2333,1604,18.5,13156.5,18.5,5921.5,8182,12107.5,11186,3685.5,7150.5,15.5,-0.007881815,12374.5,11555.5,0.0028475,0.0220439,14412.5,17035,8084.5,18527,11503,12298,15588,0.0032951,20140,4771.5,-0.005864364,-0.0020495853,14.5,0.001337471,27150,30827.5,10594.5,27721,14888.5,-0.011328137,15310.5,12809.5,18358,0.01172538,19924.5,0.017368594,20451,16497.5,0.00040806909,-0.005499234,0.009179181,0.0027147043,-0.006171033,-0.014070505,0.0023511292,-0.0026729072,-0.0028265796,0.002921802,-0.012119986,-0.0028830601,0.0037229196,-0.002920516,0.00730872,0.0031611125,0.009265436,-0.0007541471,-0.005835806,-0.0095838355,-0.00025792068,-0.00709934,-0.0008753938,0.0019357989,-0.00025609904,0.00497049,0.0016820735,-0.004693157,-0.008173244,-0.016190164,6.4773444e-06,-0.005557771,0.00010808008,0.004497012,0.0010841524,0.01836948,0.004980079,0.00010968158,-0.0045468286,-0.013577606,0.004989249,0.0012415465,0.008749022,0.002105735,0.014030337,0.001942227,0.0027693396,0.00033141882,-0.0065624,0.0023170172,0.0010173413,-0.0022002128,0.0035045005,0.0007133338,0.0052720006,0.0027324052,0.0014279628,0.0040534935,-0.0032152191,0.0011347256,0.0064458544,0.0020947522,0.0018157011,-0.0008719328,0.00052804506,-0.0014216373,0.003623385,-0.0023709345,0.0004947601,0.0052636242,-0.00048974314,0.00030586479,-0.0013634361,0.0005193537,-0.003619546,-0.011475512,0.008186515,0.0010521765,0.0031523723,0.0005971198,0.001400907,-0.006950535,0.0006877401,-0.0032012635,0.0028287412,-0.0049553374,0.0010020074,-0.0009032224,7.028e-05,0.0020082402,0.0005247467,-0.0006704972,-0.0020552278,0.0023236978,0.0016737465,0.0035295996,-0.0076112472,-0.0002232696,0.011302895,0.0024654907,-0.0027421084,0.0012146424,-0.016128281,-0.0043409173,-0.00083759613,0.0027338716,-0.0001633826,-0.0062591447,-0.0034777876,-0.00088304345,-0.005906335,-0.0005849483,0.004906352,0.017249987,-0.0048159254,-0.008028972,0.0057650968,-0.0057083187,0.000115655945,-0.003600313,0.0035622858,0.00042768792,-0.0122801615,-0.0052236426,-0.00065895333,-0.003179902,0.0034962893,-0.0020679496,-0.0044090822,-0.012051194,-0.006320398,-0.002590724,-0.0011293535,-0.0025066948,0.0074959206,0.003254667,-0.0022557524,0.0015345098,-0.0044654077,-0.001831944,0.0014642625,0.0056167985,-0.005412915,-0.008025865,0.015237376,-0.01926957,-0.00023162189,0.013962428,0.00015644768,-0.015299998,-0.00026724828,0.0051435926,0.0003948571,-0.0043232325,-0.001462152,-9.917606e-06}, {8,7,2,6,5,2,7,5,7,5,7,8,5,5,6,4,4,5,5,8,7,4,5,2,6,5,2,8,6,7,6,6,6,4,2,8,8,5,5,7,7,8,8,5,255,5,5,7,2,7,4,6,2,4,6,5,4,2,7,5,8,7,4,7,7,255,4,255,255,5,6,5,8,255,7,6,255,5,4,7,7,7,4,8,2,255,8,8,2,4,8,4,5,6,6,5,2,2,8,4,7,7,5,4,5,255,7,255,255,7,4,5,4,8,5,2,4,255,2,255,255,6,4,4,6,2,6,6,6,4,4,5,6,255,6,6,8,4,255,255,255,5,255,8,5,7,6,255,8,255,6,255,6,7,255,5,4,255,255,255,8,6,7,8,2,8,8,7,7,4,6,5,2,6,2,4,8,6,2,7,5,2,8,7,8,2,2,2,5,5,4,8,255,5,5,255,255,2,6,7,4,7,5,2,255,4,5,255,255,8,255,4,2,7,2,6,255,7,5,4,255,7,255,7,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,65535,65535,131,133,135,137,65535,139,141,65535,143,145,147,149,151,153,155,157,65535,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,197,65535,65535,199,201,203,205,207,209,211,213,65535,215,65535,65535,217,219,221,223,225,227,229,231,233,235,237,239,65535,241,243,245,247,65535,65535,65535,249,65535,251,253,255,257,65535,259,65535,261,65535,263,265,65535,267,269,65535,65535,65535,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,65535,335,337,65535,65535,339,341,343,345,347,349,351,65535,353,355,65535,65535,357,65535,359,361,363,365,367,65535,369,371,373,65535,375,65535,377,379,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,65535,65535,132,134,136,138,65535,140,142,65535,144,146,148,150,152,154,156,158,65535,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,198,65535,65535,200,202,204,206,208,210,212,214,65535,216,65535,65535,218,220,222,224,226,228,230,232,234,236,238,240,65535,242,244,246,248,65535,65535,65535,250,65535,252,254,256,258,65535,260,65535,262,65535,264,266,65535,268,270,65535,65535,65535,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,65535,336,338,65535,65535,340,342,344,346,348,350,352,65535,354,356,65535,65535,358,65535,360,362,364,366,368,65535,370,372,374,65535,376,65535,378,380,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({33,28.5,19.5,30.5,17.5,22.5,26.5,4.5,12.5,30,56,29.5,56.5,81,42,22,15.5,0.009102541,-0.0034505043,1377.5,6.5,31.5,1012,31,8.5,103,38.5,58.5,0.020156246,415.5,3486.5,22,22,28,22,201.5,6,0.0059144893,0.0043090642,0.0029794143,40,0.00083241885,-0.0018579904,81,14.5,-0.012058848,-0.0028721907,70.5,311,490,60,0.006689638,0.0022473333,63.5,-0.012248655,750.5,7268.5,2.5,-0.0003513813,-0.0042340923,-0.0022067502,22,72,18.5,39.5,48.5,13.5,0.0020389876,13.5,0.014048445,155.5,14.5,7.5,6.5,-0.0019936778,35,47.5,0.017382495,5.5,-0.01355959,2048,8.5,55.5,80.5,69.5,315.5,866,7201.5,15288,-0.0010713151,-0.0017402051,22,27,7.5,-0.00012743486,16.5,20.5,28,18.5,12.5,4.5,4.5,0.00270294,0.0063610836,0.0025540541,0.005422685,0.010280589,7.5,0.0038243083,-0.003583335,14,0.0047801477,0.0032864574,37,49,0.008735274,27.5,22,2324.5,-0.0039026246,-0.0073882216,-0.0057265335,-0.010719102,37,55.5,28.5,164,24,0.007838483,104.5,1816.5,538.5,739,10017.5,8793,10006.5,15975,0.00040002106,0.0030636322,-0.00583454,0.0005985188,-0.005828764,-0.0029480706,-0.0011544185,-0.00015956847,-0.004882869,-0.0025180457,0.0045329374,0.00784634,0.00013441492,0.0035333813,0.0014205752,-0.003753214,0.008810842,0.0031776961,-0.00025570934,-0.005006428,0.0004589002,-0.0071794353,-0.0086426,-0.0049923444,0.00072623574,-0.0054671033,0.009664586,0.002373872,-0.006979763,-0.0012974383,-0.012193005,0.0063292137,0.00732547,-0.0027124106,-0.018505856,-0.0011407152,0.005104475,-2.813507e-05,-0.0051562437,-0.0153753925,0.0036285303,-0.009363888,0.0007313557,-0.006918756,-0.0011772123,0.009090986,-0.0056235283,0.004312686,0.0019667326,0.022431219,-0.0026024326,0.0026872938,-0.0006701267,-0.0021418012,-0.012188442,-0.0063974033,-0.00026406188,0.002097449,-0.002792537,-0.00037255549}, {2,4,8,2,8,5,4,8,8,2,5,4,6,2,7,6,8,255,255,7,8,4,6,6,8,5,4,2,255,4,6,2,2,6,6,6,8,255,255,255,4,255,255,2,8,255,255,4,4,6,6,255,255,4,255,2,5,8,255,255,255,4,6,8,6,4,8,255,8,255,6,8,8,8,255,7,2,255,8,255,6,8,2,2,5,4,2,5,2,255,255,2,2,8,255,8,8,6,8,8,8,8,255,255,255,255,255,8,255,255,8,255,255,6,6,255,7,6,4,255,255,255,255,5,4,5,2,7,255,5,4,5,5,4,6,5,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,65535,65535,65535,69,65535,65535,71,73,65535,65535,75,77,79,81,65535,65535,83,65535,85,87,89,65535,65535,65535,91,93,95,97,99,101,65535,103,65535,105,107,109,111,65535,113,115,65535,117,65535,119,121,123,125,127,129,131,133,135,65535,65535,137,139,141,65535,143,145,147,149,151,153,155,65535,65535,65535,65535,65535,157,65535,65535,159,65535,65535,161,163,65535,165,167,169,65535,65535,65535,65535,171,173,175,177,179,65535,181,183,185,187,189,191,193,195,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,65535,65535,65535,70,65535,65535,72,74,65535,65535,76,78,80,82,65535,65535,84,65535,86,88,90,65535,65535,65535,92,94,96,98,100,102,65535,104,65535,106,108,110,112,65535,114,116,65535,118,65535,120,122,124,126,128,130,132,134,136,65535,65535,138,140,142,65535,144,146,148,150,152,154,156,65535,65535,65535,65535,65535,158,65535,65535,160,65535,65535,162,164,65535,166,168,170,65535,65535,65535,65535,172,174,176,178,180,65535,182,184,186,188,190,192,194,196,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({495,20.5,552.5,426.5,32.5,17,2066,258.5,369.5,64,79.5,948,0.014101877,1579.5,2064.5,235,265,282.5,371.5,22,132.5,34.5,314,0.007607411,0.0025649953,11231.5,20.5,1646,2225,107,225.5,0.016322525,364,264,368,-0.025125274,7105.5,22,21.5,0.040749397,0.0066877822,21.5,91.5,296,509,1163,-0.012386093,6.5,2374.5,16.5,8250,2199,2276,515.5,124.5,142,268,398,378,11.5,-0.018715983,350.5,821,1862.5,6.5,-0.0032778045,0.0005165046,0.00089537504,0.009193509,-0.007819275,-0.011581804,50.5,88,211,0.03346971,261.5,1131,18.5,15.5,1997,2060,0.02339199,0.005243002,-0.004480907,-0.014156446,14.5,3173,15.5,-0.018924242,18.5,2102,76.5,156.5,177.5,137,130,173,15.5,498,307,342.5,14.5,15.5,174.5,637,1049.5,-0.00097647187,-0.0042195534,17.5,388,363.5,0.002643787,14.5,63.5,0.006435213,-0.005764598,113.5,0.009899591,193,296,384.5,-0.011293487,347.5,713.5,737.5,943,1055,1516.5,2761.5,1726.5,12.5,2613,1695.5,11.5,9174,2253.5,2896,2356.5,0.023031937,2192.5,18.5,-0.0003505097,-0.0020544573,0.009791377,0.00012386336,0.0051207803,0.016680611,0.0066841305,0.0007284669,-0.000503395,0.0059733875,-0.003138822,0.0013721938,-0.010717692,-0.006723692,0.0029118482,-0.0043900535,0.0023554103,-0.0017158128,0.013986036,-0.00085705024,0.0073839584,0.011728826,0.00396423,-0.001981129,-0.01045083,-0.0038015328,-0.0022693237,0.0012213839,0.0071842945,0.00026997714,-0.0002978478,0.0028061233,-7.5475094e-05,-0.005922371,-0.017373266,-0.0054550203,-0.00057112327,0.00040787226,-0.0023943912,0.0008662047,-0.002635423,0.0009775688,-0.0025181056,0.0031323098,0.0020737778,-0.0044333846,0.008523366,-0.0021744883,-0.0062118378,0.0028940898,0.0018389294,-0.0020552455,-0.010094834,0.0052379123,0.0010403086,0.005578307,0.021825919,-0.004754886,0.0002909824,0.002946788,-0.003054862,0.0017169642,0.007275334,0.0018190505,0.002277137,0.019293515,-0.0045634825,-5.58263e-05,-0.0015069249,0.0039317715,0.0010636672,-0.0032943704,-0.010179497,-0.0001454857,0.0057835085,-0.0010366302,-0.018420806,0.00144859,-0.0026950184,0.0035350926,-0.0016340427,0.009692799,2.6457292e-05,-0.00031330445}, {7,8,6,6,6,8,6,7,3,3,5,3,255,7,7,6,7,3,3,6,3,6,4,255,255,4,8,4,6,7,5,255,7,3,5,255,4,3,8,255,255,8,6,4,5,7,255,8,5,8,4,6,6,4,7,3,3,6,6,8,255,3,4,4,8,255,255,255,255,255,255,7,4,4,255,3,5,8,8,7,6,255,255,255,255,8,5,8,255,8,7,6,5,3,6,7,7,8,3,6,7,8,8,7,6,6,255,255,8,7,7,255,8,6,255,255,6,255,3,5,7,255,7,3,5,4,6,6,7,6,8,4,5,8,5,7,5,3,255,3,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,65535,65535,45,47,49,51,53,55,65535,57,59,61,65535,63,65,67,65535,65535,69,71,73,75,77,65535,79,81,83,85,87,89,91,93,95,97,99,101,103,65535,105,107,109,111,65535,65535,65535,65535,65535,65535,113,115,117,65535,119,121,123,125,127,129,65535,65535,65535,65535,131,133,135,65535,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,65535,65535,171,173,175,65535,177,179,65535,65535,181,65535,183,185,187,65535,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,65535,221,223,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,65535,65535,46,48,50,52,54,56,65535,58,60,62,65535,64,66,68,65535,65535,70,72,74,76,78,65535,80,82,84,86,88,90,92,94,96,98,100,102,104,65535,106,108,110,112,65535,65535,65535,65535,65535,65535,114,116,118,65535,120,122,124,126,128,130,65535,65535,65535,65535,132,134,136,65535,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,65535,65535,172,174,176,65535,178,180,65535,65535,182,65535,184,186,188,65535,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,65535,222,224,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3801,20.5,4150,3210,301.5,2246.5,4173,25601.5,6.5,3761,30,6981.5,4071.5,17,6624,12.5,-0.0124051105,3382.5,3629,350.5,5148.5,0.036502056,2730,-0.024782391,-0.011570903,4537,0.011925328,7,0.027483622,6531.5,8042.5,1266.5,5109.5,2.5,4137.5,16.5,3160,707,34,0.021880243,-0.0070049176,720,2463,3965.5,4019.5,-0.0012058684,0.0021759658,6678,6561,6640,9080.5,7055.5,2278,2008,6184.5,3528,4.5,2.5,4.5,2353,3045.5,15,3306,236.5,246,-0.020745603,-0.009840312,506.5,648,-0.014519232,835,3689.5,-0.02803943,3534,2620,5536.5,6694,9202.5,6532.5,7124,10635,9661.5,8582.5,628,886.5,6.5,15692.5,1564.5,1977,17.5,15.5,-0.0045246263,0.008652076,2755,5.5,0.0036940218,5429.5,2812,2733,3191,2550.5,1857,1867.5,-0.0030946878,-0.010632211,13.5,4800,181,846,264,-0.008716077,0.024219409,413.5,0.027315674,751.5,2134.5,3922.5,15,6780,16.5,14.5,15,0.0032596712,5527,5876,0.015229046,5566.5,-0.018375315,-0.0030811143,6.5,7704,6.5,9,9793.5,11711,8946.5,12604,4193,9339,-0.00043341756,0.0015881561,0.0040027625,0.0075903684,0.0007383214,-0.0070445845,0.0014677107,-0.002527691,0.0005076109,0.0038680602,-0.007912668,-8.293284e-05,-0.0023627975,-0.007867701,0.0010277019,0.0046964926,0.022600774,0.005126363,0.004561883,0.008647738,0.000544739,0.001923232,0.0009979605,-0.0009946061,-0.002843681,-0.0012505915,0.008988273,0.0023503606,-0.007175613,0.000434175,0.002443009,0.014042004,0.005071854,-0.0002531268,0.005187931,-0.0009170648,-0.0023626857,-7.1806e-05,-0.00039094593,0.0037825312,0.012207965,0.0019153588,-0.0048457263,0.0009110936,0.0045154993,-0.0071570813,-0.009913902,0.009487693,0.00014977538,0.02239286,-0.01070408,-0.00033690117,-0.0016330585,-0.0067336517,0.0069941445,-0.0008199539,-0.0004070203,0.0011860154,4.9424823e-05,-0.0010759578,0.0004416978,0.002406396,-0.00037419368,0.01343876,-0.005814859,-0.0009372607,0.001948947,-0.0002504828,-0.006959156,0.0021999336,-0.008115004,-0.0030977156,0.0063826903,0.0025232565,0.0042938706,0.012407988,0.00061356486,-0.0026230526,0.0050998605,0.000102928745,-0.0010683559,-0.0035595272,0.0029985665,-0.0069013536,-0.017062748,0.0020387222,0.0022938866,-8.347805e-05}, {2,8,2,2,1,6,2,0,8,6,6,0,2,8,6,8,255,3,2,3,6,255,1,255,255,3,255,8,255,6,6,2,6,8,3,8,3,6,0,255,255,3,0,3,2,255,255,1,6,6,6,6,1,1,0,6,8,8,8,6,1,8,1,3,3,255,255,0,0,255,6,3,255,1,0,1,1,0,2,0,0,2,2,3,2,8,3,2,0,8,8,255,255,3,8,255,0,0,0,3,6,1,6,255,255,8,6,1,2,2,255,255,1,255,0,3,1,8,0,8,8,8,255,1,0,255,3,255,255,8,3,8,8,2,0,6,0,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,65535,33,35,37,39,65535,41,65535,65535,43,65535,45,65535,47,49,51,53,55,57,59,61,63,65,65535,65535,67,69,71,73,65535,65535,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,65535,111,113,65535,115,117,65535,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,65535,65535,155,157,65535,159,161,163,165,167,169,171,65535,65535,173,175,177,179,181,65535,65535,183,65535,185,187,189,191,193,195,197,199,65535,201,203,65535,205,65535,65535,207,209,211,213,215,217,219,221,223,225,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,65535,34,36,38,40,65535,42,65535,65535,44,65535,46,65535,48,50,52,54,56,58,60,62,64,66,65535,65535,68,70,72,74,65535,65535,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,65535,112,114,65535,116,118,65535,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,65535,65535,156,158,65535,160,162,164,166,168,170,172,65535,65535,174,176,178,180,182,65535,65535,184,65535,186,188,190,192,194,196,198,200,65535,202,204,65535,206,65535,65535,208,210,212,214,216,218,220,222,224,226,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8.5,29057.5,10986,22877,25467.5,15317,21298.5,18762,30117.5,3230.5,26724.5,12731.5,10233.5,18683,23059.5,18236,23059.5,15034.5,2.5,3159,24145.5,2.5,31884,12.5,8104.5,13351.5,22211.5,18217.5,22216.5,21325,15036.5,13357.5,21579,1.5,21214,28438,27589.5,19217.5,19237,0.0006449964,2592,18976,2.5,0.0051188553,31610.5,26634.5,29100.5,6456,10108,17904,14208.5,12.5,26352.5,18635.5,12.5,13644.5,14252,17380,17.5,17861,23918.5,19362,31145.5,4553,9973,17665,22144,18141,18079.5,0.01141184,25509,18679,28038,23960,29625.5,29792.5,21290,11475.5,19895,-0.0023976504,-0.005868647,16907.5,23993,24742,24719.5,30301,-0.0007341548,-0.01076658,4.5,27541,29466,1233.5,10634,9146.5,9283,3029.5,-0.01625659,13597.5,14077.5,7495.5,3048,19880.5,0.008972793,21352.5,11069,10792.5,10377,14022,18207,15689.5,17585.5,0.004471798,19109.5,21582.5,20652.5,15.5,0.011699128,20693.5,24668.5,0.006506818,15.5,24877,17384.5,2.5,7514,7920.5,19991,18358,13223,-0.011023498,17116,-0.001312775,0.012130216,23257,22053,-0.0005319339,0.0037263755,1.5,4.5,12849,-0.0110899275,17552.5,22741,1.5,4.5,-0.003371813,19597.5,18848.5,24533.5,31916,19978,19740,18757.5,0.0017539322,0.0042375843,21629,0.0018572888,24693,25145,24705.5,25389,-0.012385371,-0.006864726,31320.5,29722.5,25991.5,25167.5,-0.0022028834,29650.5,540.5,5138.5,9688,11638,8946.5,8116.5,10861.5,10314,12.5,11924,10656.5,10794.5,10193,13991.5,7328,10382.5,-0.006926771,8338,25422,0.005021581,20949.5,-0.006779771,-0.012178882,16.5,10701,-0.000812177,-9.3813396e-05,25326.5,17.5,11586.5,15041,13806.5,-0.010573815,13223,16217.5,19443.5,19196.5,18256.5,30719.5,-0.002905252,3342,18.5,22784.5,23518.5,-0.021705823,-0.01420521,0.00043577174,-0.0047563836,18485.5,13317.5,18243.5,30737,18259,23469,-0.0011060609,0.0001281111,0.00092930096,-0.00033625992,-0.00037033236,0.006546507,-0.0027944015,0.0044713723,0.0055797496,-0.0032140203,0.002647964,0.012560482,0.00039022832,-0.0033521068,0.0006414245,-0.0029534597,-0.016240476,-0.0069785374,-0.0024855442,0.0011245839,0.0072375173,0.011454952,0.00399859,-0.002972092,0.0010592374,-0.0117999455,0.0038060758,1.4273459e-06,0.002621885,0.009678866,0.004112832,7.459224e-05,0.00015894689,0.0030890524,0.0002413522,0.0030507322,0.00086461473,-0.0006659852,0.0042193546,-0.0011963373,-0.0006436314,0.0018395005,0.00029566235,0.0015382717,0.003084019,-2.8632241e-05,0.0013443258,0.00031884393,-0.0011897682,-0.00056574563,-7.922379e-05,-0.0006798725,0.00088691426,0.0014653483,0.00031114017,-7.120042e-05,0.004501619,0.00034472052,-0.0012841696,0.00043641232,-0.002048889,-0.0001624101,0.0011716364,-7.665982e-05,-0.00012943584,-0.0006299898,-0.00055657065,0.0030927043,-0.0035979894,-0.000774972,0.00030207817,-0.0033324421,0.0051364764,-0.000983808,-1.6299979e-05,-0.0060090288,-0.0011718172,0.001413314,-0.00049008755,-0.0022051875,-0.017374035,-0.002534864,-0.00022942491,-0.002701434,-0.0023100225,0.0011562048,0.010279643,0.007611451,0.003950558,0.009493607,0.0018886765,0.0051437686,0.003671432,0.0016547065,-0.0005623139,-0.0082217865,0.0030819536,-0.0023019074,-0.0017206721,-0.0037619085,-0.0015584423,0.0021672815,-0.0012577652,-0.003447496,-0.00588013,-0.010243376,0.00026234935,0.0008713519,-0.0035155974,-0.0018895051,-0.00029467704,0.0016079135,0.0036733747,0.019269543,-0.00081493746,-0.006838832,-0.0047150445,0.009549008,0.001324227,0.007770403,0.015163443,-0.0052750404,0.0120406635,0.01827606,-0.01146506,-0.002847799,-0.00994889,-0.0145169245,0.0029363583,0.0014563316,-0.0006130009,0.0036318407,-0.0049440297,-0.0037310664,-0.0008856657,0.004391425,-0.0070864507,-0.0012499532,-0.00115431,0.001541688,-0.0016826648,-0.00373702,0.00034858962,0.0053041154,-0.0022705572,0.0001915494,-0.0036519528,-0.0014320037,-0.0005361002,0.00025577986}, {8,1,1,4,0,0,0,1,6,0,0,0,1,1,0,4,0,1,8,0,6,8,3,8,1,3,4,4,1,1,1,0,0,8,1,6,6,1,1,255,6,4,8,255,1,4,4,1,6,6,0,8,0,4,8,3,1,0,8,3,1,6,0,3,1,0,6,4,0,255,1,3,0,4,0,0,1,1,1,255,255,0,6,4,6,1,255,255,8,0,4,0,0,6,1,1,255,0,6,3,3,3,255,0,3,1,1,4,6,0,0,255,0,6,0,8,255,6,4,255,8,3,3,8,1,1,6,4,1,255,1,255,255,1,3,255,255,8,8,1,255,3,3,8,8,255,3,3,3,0,3,3,3,255,255,4,255,6,4,6,6,255,255,0,4,4,4,255,4,1,6,6,0,6,4,0,3,8,6,3,1,1,4,1,3,255,1,6,255,0,255,255,8,1,255,255,6,8,3,0,1,255,1,3,6,1,4,1,255,4,8,0,4,255,255,255,255,3,1,1,1,1,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,83,65535,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,65535,135,137,139,141,143,145,147,149,151,65535,65535,153,155,157,159,161,65535,65535,163,165,167,169,171,173,175,177,65535,179,181,183,185,187,65535,189,191,193,195,197,199,201,203,65535,205,207,209,211,65535,213,215,65535,217,219,221,223,225,227,229,231,233,65535,235,65535,65535,237,239,65535,65535,241,243,245,65535,247,249,251,253,65535,255,257,259,261,263,265,267,65535,65535,269,65535,271,273,275,277,65535,65535,279,281,283,285,65535,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,65535,321,323,65535,325,65535,65535,327,329,65535,65535,331,333,335,337,339,65535,341,343,345,347,349,351,65535,353,355,357,359,65535,65535,65535,65535,361,363,365,367,369,371,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,84,65535,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,65535,136,138,140,142,144,146,148,150,152,65535,65535,154,156,158,160,162,65535,65535,164,166,168,170,172,174,176,178,65535,180,182,184,186,188,65535,190,192,194,196,198,200,202,204,65535,206,208,210,212,65535,214,216,65535,218,220,222,224,226,228,230,232,234,65535,236,65535,65535,238,240,65535,65535,242,244,246,65535,248,250,252,254,65535,256,258,260,262,264,266,268,65535,65535,270,65535,272,274,276,278,65535,65535,280,282,284,286,65535,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,65535,322,324,65535,326,65535,65535,328,330,65535,65535,332,334,336,338,340,65535,342,344,346,348,350,352,65535,354,356,358,360,65535,65535,65535,65535,362,364,366,368,370,372,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({42,130,51.5,129,26.5,26.5,105.5,108,137,-0.005381416,-0.0142082935,-0.001777361,45.5,64.5,72,34,28.5,-0.011552553,339.5,183.5,34,54,3281,-0.012015543,23.5,20.5,33.5,363.5,0.0018800646,297,5876.5,58.5,0.0069464096,0.0069230995,0.01173273,29.5,55,52.5,7195.5,25,35.5,61,22.5,1124.5,33,0.0057096807,0.0039448733,128.5,0.018955164,333,25020,7.898633e-05,0.001043791,72,46,-0.003012087,-0.0018114351,0.007912347,793.5,0.0012891537,-0.00059891277,65,0.005325898,25.5,119,22,-0.003326137,0.0039614807,32,74,-0.0070471778,14940,45.5,165.5,258,1010,1712,0.0031753276,31565.5,22,22,0.0053048036,48.5,0.004075538,0.0058361012,45.5,501,196,2739,48.5,150.5,-0.0011161595,0.0021922668,0.00047891642,-0.004641968,-3.033134e-05,0.002539675,-0.0120493155,0.0025152122,-0.0023946355,0.0027084765,-7.301994e-05,-0.002706852,-0.00060907315,0.000110932095,-0.0025619029,-0.0016368013,-0.0062266756,-0.0040215035,-0.004857339,0.002518626,-0.002266702,-4.7442503e-05,0.0012339357,0.00010323592,0.0028018353,0.00422195,0.0026788274,0.004896327,0.00051137886,0.00229723,0.005764255,-0.0006069932,-0.0037551613,-0.01149585,0.0051537524,-0.001382129,0.0038638865,-2.8176864e-05}, {7,6,7,2,5,3,6,2,2,255,255,255,6,1,7,1,5,255,1,1,3,3,1,255,3,5,6,1,255,1,1,1,255,255,255,1,1,2,1,2,1,2,3,1,5,255,255,1,255,2,2,255,255,6,5,255,255,255,2,255,255,5,255,1,5,2,255,255,5,2,255,1,2,2,1,1,1,255,3,1,2,255,3,255,255,5,1,6,6,1,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,65535,19,21,23,25,27,65535,29,31,33,35,37,65535,39,41,43,45,65535,47,49,51,65535,65535,65535,53,55,57,59,61,63,65,67,69,71,65535,65535,73,65535,75,77,65535,65535,79,81,65535,65535,65535,83,65535,65535,85,65535,87,89,91,65535,65535,93,95,65535,97,99,101,103,105,107,65535,109,111,113,65535,115,65535,65535,117,119,121,123,125,127,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,65535,20,22,24,26,28,65535,30,32,34,36,38,65535,40,42,44,46,65535,48,50,52,65535,65535,65535,54,56,58,60,62,64,66,68,70,72,65535,65535,74,65535,76,78,65535,65535,80,82,65535,65535,65535,84,65535,65535,86,65535,88,90,92,65535,65535,94,96,65535,98,100,102,104,106,108,65535,110,112,114,65535,116,65535,65535,118,120,122,124,126,128,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({22.5,33.5,414,27,33.5,374,467.5,29.5,25,28.5,187.5,119,0.015395547,468.5,488.5,62,0.0011541413,0.0036486348,0.0020782307,-0.004675264,-0.011679485,102.5,758.5,211,216,139,497,490.5,1299.5,22,-0.0041874005,-0.0025789284,117,452,0.003209885,103,230,118.5,266.5,0.0071248445,1197.5,-0.029985717,512.5,0.006706138,558,865,1924.5,22,23.5,0.0028344223,122,380.5,-0.00623736,131.5,120.5,-0.0071282224,156.5,0.0037536856,0.013965674,151,466,120.5,-0.0077575976,943,620,-0.0022537566,-0.00043745997,616.5,868,2649.5,2335,-0.0014620045,-0.00021915208,0.008027516,-0.0029632566,0.00038542305,0.0008002043,254,0.0017694926,148,37.5,97,0.020035578,471.5,-0.0031266075,298,597,330,742,353.5,377,-0.00713313,1278,4263.5,888,354,2067,0.013269561,1283,1028,638.5,2113,3963,-0.004872583,-0.0034589586,0.0006470761,-0.0053527905,-0.017410431,-0.00056146574,0.004874239,0.00092273887,-0.0016637108,0.00028047647,0.013321607,0.0016595441,-0.004843787,-0.00037048463,0.012663851,0.005698693,-0.0047243657,0.002389014,-0.0030399708,0.0025467032,0.0011209546,-0.0025105535,-0.0020725487,-0.0038276694,-0.0039564986,-0.0011117704,0.006434484,0.0011462964,-0.0036144478,0.003828552,-0.0025759253,-0.016728869,6.018487e-05,-0.0055708424,-0.0045907698,0.002276746,0.006956577,0.0035642188,0.00077201467,-0.0031047822,0.00072782766,-6.694426e-05}, {7,0,4,4,3,5,5,0,1,3,0,5,255,1,5,3,255,255,255,255,255,0,0,4,4,5,1,3,5,3,255,255,0,0,255,5,4,0,5,255,4,255,4,255,4,7,4,0,0,255,0,0,255,0,4,255,7,255,255,5,7,1,255,0,3,255,255,1,7,0,4,255,255,255,255,255,255,0,255,3,1,4,255,0,255,4,0,4,7,7,3,255,0,0,1,1,4,255,5,7,7,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,65535,65535,65535,65535,65535,31,33,35,37,39,41,43,45,47,65535,65535,49,51,65535,53,55,57,59,65535,61,65535,63,65535,65,67,69,71,73,65535,75,77,65535,79,81,65535,83,65535,65535,85,87,89,65535,91,93,65535,65535,95,97,99,101,65535,65535,65535,65535,65535,65535,103,65535,105,107,109,65535,111,65535,113,115,117,119,121,123,65535,125,127,129,131,133,65535,135,137,139,141,143,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,65535,65535,65535,65535,65535,32,34,36,38,40,42,44,46,48,65535,65535,50,52,65535,54,56,58,60,65535,62,65535,64,65535,66,68,70,72,74,65535,76,78,65535,80,82,65535,84,65535,65535,86,88,90,65535,92,94,65535,65535,96,98,100,102,65535,65535,65535,65535,65535,65535,104,65535,106,108,110,65535,112,65535,114,116,118,120,122,124,65535,126,128,130,132,134,65535,136,138,140,142,144,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4864.5,3813,4972,25601.5,1582.5,4960,4980.5,3792.5,29297,-0.014958562,6410,897.5,6832,5238.5,5600,584.5,600,-0.014623515,0.00022838482,2865.5,6972,222.5,5107.5,0.012934038,0.0010837367,-0.0037579746,-0.009729863,5598.5,6480,230,340.5,7728,4750.5,4302.5,2309.5,4043.5,12822,30882,6926,4125.5,8976,8350.5,0.015034208,5674.5,6528.5,220.5,262.5,336.5,3942.5,1257.5,8134.5,5893,3165,4536.5,2726.5,4777.5,3158,0.0053151464,0.018613165,4066.5,0.0054021957,29826.5,0.0035635463,-0.004224418,-0.0074853837,1984.5,-0.02205614,2510.5,19017,5930,5550,6004.5,5924,9295.5,6769.5,105.5,632,295.5,518,386,-0.03583845,346.5,4340,34,-0.015006803,-0.00077193306,153,2314.5,2926,5080,3780.5,3914.5,0.0019248755,4048,6286,5811,0.001168239,2754,5780.5,-0.0048401314,15096.5,4933,-0.007816653,742.5,-0.0036513023,6673,3435,10946,31078.5,4276,5467.5,4465.5,-0.012037069,2416,5565,5858,6645,6495.5,11249,6321.5,7014.5,-1.68084e-05,0.0032845025,-0.0010950094,-0.005452134,0.014951663,0.0029091004,0.0011551259,0.004200947,-0.00060065923,-0.0072757103,0.007048622,-0.00022227538,-0.004660278,-0.000643324,0.0029651753,-0.0030517224,0.0030172656,0.0012738145,0.0019688006,0.005830326,0.0013766157,-0.0033409037,0.006486546,-0.0045029297,0.0004047562,0.0054136617,-0.0020967163,-0.0052221473,-0.00075556024,0.002010386,0.0050038905,0.0069558597,-0.021551602,-0.009208068,0.00041853078,0.005336261,-0.0028863822,-0.00082689984,-0.0004889638,-0.0018927588,-0.00089973555,0.0016696263,0.0039681643,0.0018726172,0.0058944146,0.0019331241,-0.00052827963,0.0017126476,-0.0042281416,-0.009223412,0.00019579267,-0.0004174561,0.0047585326,-5.5236593e-05,0.01703684,0.0034819355,-0.0074731032,-0.00050978496,0.0030902652,-0.0048358194,-0.028466864,-0.016156306,0.00037804968,0.008432291,-0.008331437,-0.000866683,0.0043789553,-0.010351559,0.0094141895,-0.00072881073,0.005383318,-0.0027442756,0.0006598383,-5.123152e-05}, {3,3,7,0,0,7,7,5,0,255,7,6,0,3,3,6,1,255,255,5,6,7,0,255,255,255,255,3,3,7,7,5,0,1,6,0,1,1,0,0,5,0,255,6,3,6,7,7,1,3,5,6,1,3,5,3,6,255,255,3,255,1,255,255,255,0,255,6,0,1,3,1,1,6,3,7,0,0,6,5,255,7,1,3,255,255,0,7,0,0,3,3,255,3,0,0,255,6,0,255,6,5,255,0,255,0,7,0,0,5,6,1,255,0,6,1,0,3,0,0,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,21,23,25,27,29,31,65535,65535,33,35,37,39,65535,65535,65535,65535,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,65535,65535,99,65535,101,65535,65535,65535,103,65535,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,131,133,135,65535,65535,137,139,141,143,145,147,65535,149,151,153,65535,155,157,65535,159,161,65535,163,65535,165,167,169,171,173,175,177,65535,179,181,183,185,187,189,191,193,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,22,24,26,28,30,32,65535,65535,34,36,38,40,65535,65535,65535,65535,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,65535,65535,100,65535,102,65535,65535,65535,104,65535,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,132,134,136,65535,65535,138,140,142,144,146,148,65535,150,152,154,65535,156,158,65535,160,162,65535,164,65535,166,168,170,172,174,176,178,65535,180,182,184,186,188,190,192,194,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8.5,3959.5,30719.5,3595.5,5937.5,15632,30824.5,2616,4.5,1582.5,5722,13809.5,17638,30801.5,31340.5,2066.5,2619.5,5759,6180.5,-0.01197081,5809,5969,6240,15.5,8104.5,15310,15.5,30352,0.0061479216,25983,29002,1503,9737.5,0.016930087,566,5316,4415,3255,8043.5,2817.5,6252.5,5661.5,6887,5945.5,7502,7912,10667.5,7280,13427,12451,17898,20958.5,15779,0.0018380625,16.5,0.00048406306,26607.5,3060,31320.5,1373.5,2360,4696.5,10403.5,0.009239392,2256.5,4660,6059,3187,6337,-0.006629205,6.5,7349,11826,5889.5,5818,5866,6.5,5567.5,12229.5,8541.5,5614.5,5941.5,4.5,7687.5,7184.5,7369.5,6483,10516.5,5286.5,13250.5,16.5,11586.5,15834,8188.5,0.013858478,18842,16429.5,18683,22527,16501,20652,0.000120036326,0.00056280673,-0.0051473724,31031,-0.0018741764,12.5,15.5,30334.5,1.5,1398,686.5,2049,3468.5,2401,4.5,7969.5,9768,4.5,-0.00068921596,0.0009233079,1.5,3.5,-0.0049671168,3779,4886.5,3780.5,5.5,3614.5,6383,3807,6.5,-0.0018988505,1848,2029.5,4.5,5239.5,-0.005873767,0.0029931057,10183.5,7.5,0.013120882,0.0035616371,5559.5,0.0073880972,5173.5,1.5,9045,1.5,6389.5,-0.016531182,8669,5.5,5709.5,8430.5,6818.5,14874,2124,8142.5,6439,14068,9850,6289,5741,11852.5,6484.5,14028,-0.0037387775,-0.008831227,11309,14776,12272,18759.5,5858,8293,16561.5,-0.015464273,0.005470086,18453,14243,23628.5,20401.5,30463,13317.5,20995.5,18683,26163.5,-0.00023683794,-0.0009950865,0.002183512,29769.5,-0.00089613005,-0.0064284685,29650.5,30157.5,0.0013242962,-0.0006097613,-0.02199915,-0.0009822998,-0.0066579403,0.0052286475,0.00053852197,-0.0059144655,-0.0015717306,-0.0055764136,0.0014620598,0.0064264997,0.004584624,3.773118e-07,-0.0020089212,0.0016449534,-0.0039660293,0.0034802367,0.0024659557,0.00013039073,-0.005136577,-0.007190279,-0.004290789,-0.0062247454,0.0042280294,0.001582448,-0.0035295524,0.0012243687,-0.0044332584,-0.0088338945,0.002377058,0.00044848523,-0.0009498912,0.0035311424,-0.0023068779,-0.0040570013,0.0013696186,-0.0035580322,-0.0050944057,-0.007038478,0.00036627403,-0.004833165,-0.0039594597,0.00027058893,0.0024606804,0.00031994536,0.001797391,-0.0021761411,0.008903928,0.0040147435,0.0027749676,-0.0007063395,0.0027443077,0.0002167417,0.0023231131,0.008435746,0.0026594978,0.0005862486,-0.011677585,-0.0043450603,-0.011806648,0.0016186585,0.0018796657,-0.010732383,0.0035900567,-0.006846942,0.0076132216,0.000114747905,0.0013985605,-0.006109538,0.0016198483,-0.0024995368,7.357479e-06,0.004183694,-0.0007216626,0.00028468823,0.00027396457,-0.00051618594,0.0036741768,-0.003850227,-0.0003263928,0.0110841235,-0.001776142,0.002019067,7.4704585e-05,-0.0031154759,-0.00014665912,0.0021200185,0.0015036192,-0.0013787368,-0.0032656677,0.00041627543,0.0067726993,0.0010074252,-0.009210165,-0.00059082196,0.0031663855,0.0063039265,0.011991241,0.019498426,-0.0019070081,-0.0061000567,0.003100439,0.007930699,-0.0035594308,0.0006579973,-0.0032151684,-0.0075587197,-0.008739516,-0.004567824,-0.005547384,0.0016464817,0.0012357502,0.011889405,-0.009803386,-0.004445348,-0.0011410805,-0.010712176,0.0008306631,-0.00032747118,-0.00202398,-0.0038232189,0.007593289,-2.1045606e-05,0.013615306,-0.008762186,-0.002558451,-0.0004118939,0.00446742,0.0027062001,0.00029862986,2.2597058e-05,0.0010662939,0.0005669663}, {8,3,1,3,3,0,1,3,8,0,1,0,0,1,1,3,3,0,0,255,3,7,1,8,1,1,8,3,255,0,3,0,4,255,0,4,1,1,0,7,4,4,4,0,0,7,4,1,1,1,1,0,1,255,8,255,4,4,3,0,0,1,4,255,1,1,4,1,1,255,8,0,4,4,7,3,8,0,0,3,0,1,8,3,1,7,1,3,7,4,8,3,1,7,255,4,0,1,0,7,0,255,255,255,1,255,8,8,4,8,0,3,3,1,3,8,1,4,8,255,255,8,8,255,3,1,3,8,4,0,3,8,255,7,7,8,3,255,255,4,8,255,255,0,255,0,8,4,8,3,255,0,8,4,4,3,0,4,3,1,1,3,4,1,0,7,0,255,255,7,0,7,3,1,1,1,255,255,1,3,7,1,4,1,0,1,0,255,255,255,0,255,255,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,41,43,45,47,49,51,53,65535,55,57,59,61,65535,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,65535,103,105,107,109,111,113,115,65535,117,119,121,123,125,65535,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,65535,175,177,179,181,183,185,65535,65535,65535,187,65535,189,191,193,195,197,199,201,203,205,207,209,211,213,65535,65535,215,217,65535,219,221,223,225,227,229,231,233,65535,235,237,239,241,65535,65535,243,245,65535,65535,247,65535,249,251,253,255,257,65535,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,65535,65535,291,293,295,297,299,301,303,65535,65535,305,307,309,311,313,315,317,319,321,65535,65535,65535,323,65535,65535,325,327,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,42,44,46,48,50,52,54,65535,56,58,60,62,65535,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,65535,104,106,108,110,112,114,116,65535,118,120,122,124,126,65535,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,65535,176,178,180,182,184,186,65535,65535,65535,188,65535,190,192,194,196,198,200,202,204,206,208,210,212,214,65535,65535,216,218,65535,220,222,224,226,228,230,232,234,65535,236,238,240,242,65535,65535,244,246,65535,65535,248,65535,250,252,254,256,258,65535,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,65535,65535,292,294,296,298,300,302,304,65535,65535,306,308,310,312,314,316,318,320,322,65535,65535,65535,324,65535,65535,326,328,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2793.5,2285,4390.5,2223.5,2359,4217.5,4535,1318.5,3048.5,2355,2361,2208.5,4250,4.5,4014.5,722.5,4432.5,2351.5,7.5,2296.5,8.5,0.008819266,2790.5,134,3342.5,3336,5425.5,8271,4501.5,39,4615,706.5,20.5,6.5,18.5,18.5,16.5,4078,3173,2683,15.5,-0.011415436,-0.019035377,2613.5,3533.5,-0.007393745,21.5,18.5,4423.5,4677.5,11.5,10165.5,9696.5,6719,4556,3396,11.5,-0.010372999,3301,4881.5,4889.5,950,-0.015012707,732,1037.5,2.5,12.5,17.5,2560,2482.5,-0.010274052,6045,3973,1.5,11386,10033,3968.5,-0.0034394187,-0.017488783,2096.5,5417.5,2571,11126.5,16.5,-0.009301878,18.5,0.013425027,3087.5,-0.013389654,4409.5,4543.5,2393.5,0.0036442305,4082.5,4323.5,5211,3925,18.5,8,4491.5,-0.0058041806,0.014111294,0.00614061,17.5,6549.5,8.5,4401,275,17.5,7.5,4930,5382,5221.5,843,425,905,15.5,1015.5,957.5,1657,2809.5,605,2994,11.5,6924.5,7030.5,2566,12.5,6898.5,6.5,6990.5,0.005654111,0.0175494,2060.5,3.5,1.5,-0.0040129153,18.5,2200.5,14.5,4598.5,-0.0036189666,7348.5,-0.009207032,-0.0007095721,2559.5,2839,4375.5,11687,7,-0.008828709,10678.5,-0.0067026177,2304.5,-0.010101224,3435,16,15.5,12417,8,14.5,4359.5,0.006922493,3862,0.006418027,0.0027162337,7.5,10.5,12.5,7328.5,0.01236891,4.5,16,0.002365833,-0.001698063,0.0016062219,0.012142608,3172,8202.5,4511,4511,0.00016835469,9800.5,17.5,725,3947,5282.5,5050.5,18.5,16.5,5289.5,3924,18.5,6907.5,5288.5,-2.2674109e-05,-0.0040564337,-0.0006539092,0.008134349,0.006815646,0.0016891586,0.0016301385,-0.0022629702,-0.0051362608,0.012039591,0.03800198,0.0075668073,-0.001393124,-0.009014121,0.0035680109,-0.008616191,0.007974922,-0.005578246,-0.0009340131,-0.018369915,0.000750174,-0.00095594436,0.011976044,0.0023414285,-0.003893553,-0.00077835884,-0.010317377,-0.0053759436,0.009344764,0.0010383499,-0.0003662974,0.003119434,0.009626258,-7.0399685e-05,-0.0010347085,-0.0024400165,-0.010143716,0.003589419,-0.004046198,-0.0015198815,0.0045645004,0.0008280338,0.0024311058,0.00013816313,-0.0068039717,-0.003201462,-0.0062274593,0.00073930126,0.003398705,-0.0003743542,0.00075797644,-0.0012558728,-0.0011515034,0.0049405363,-0.0044107893,-0.009303963,-0.0027811516,0.0013884584,-0.0047540823,-0.00087165524,-0.002312532,0.002413838,0.0030823261,0.00748302,-0.0008398451,-0.0044933655,0.0034483306,-0.0014346631,-0.0032510676,0.026022507,-0.0026492355,-0.014084741,0.00026001947,-0.0023023223,0.005120307,-0.00021626594,-0.003851438,0.003480601,0.0029737845,0.00011680017,0.00923959,0.014534292,-0.0009352363,-0.004743425,-0.00034911153,-0.0023125226,0.0021640998,0.00443987,0.0042765583,0.0015348024,-0.0014031156,-0.0006045885,0.002733183,-6.8967485e-05,0.0053442577,-0.0034034017,0.004901391,0.0005626117,0.0025989562,-0.00021021471,-0.0058386284,-0.0020670532,-0.016190434,-0.0046739005,0.00385237,-0.0017966729,-0.00054995244,0.0006250117,-0.00055238436,0.0047527463,0.016273074,-0.000901818,-0.0015865967,0.0019507081,-0.008184837,-0.016426397,-0.0019159839,-0.010343197,0.013662904,0.000114683724,0.005443392,0.017538099,-0.0003921305,0.006362988,-0.0034038778,0.002410804,0.005156068,-3.4868626e-05}, {7,7,7,5,7,7,7,4,4,7,7,4,1,8,4,5,4,4,8,7,8,255,7,3,4,1,3,4,7,1,4,5,8,8,8,8,8,5,5,3,8,255,255,3,1,255,8,8,4,3,8,4,1,4,5,3,8,255,4,7,4,4,255,3,5,8,8,8,3,3,255,1,1,8,4,4,5,255,255,4,4,3,4,8,255,8,255,4,255,4,4,3,255,1,3,4,3,8,8,7,255,255,255,8,1,8,3,1,8,8,3,3,4,4,1,5,8,4,4,7,4,5,3,8,4,4,3,8,1,8,1,255,255,7,8,8,255,8,7,8,5,255,4,255,255,3,1,4,4,8,255,1,255,4,255,7,8,8,1,8,8,5,255,3,255,255,8,8,8,1,255,8,8,255,255,255,255,5,1,7,7,255,4,8,5,1,3,5,8,8,3,1,8,3,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,65535,65535,81,83,65535,85,87,89,91,93,95,97,99,101,103,105,65535,107,109,111,113,65535,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,65535,65535,141,143,145,147,149,65535,151,65535,153,65535,155,157,159,65535,161,163,165,167,169,171,173,65535,65535,65535,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,65535,65535,231,233,235,65535,237,239,241,243,65535,245,65535,65535,247,249,251,253,255,65535,257,65535,259,65535,261,263,265,267,269,271,273,65535,275,65535,65535,277,279,281,283,65535,285,287,65535,65535,65535,65535,289,291,293,295,65535,297,299,301,303,305,307,309,311,313,315,317,319,321,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,65535,65535,82,84,65535,86,88,90,92,94,96,98,100,102,104,106,65535,108,110,112,114,65535,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,65535,65535,142,144,146,148,150,65535,152,65535,154,65535,156,158,160,65535,162,164,166,168,170,172,174,65535,65535,65535,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,65535,65535,232,234,236,65535,238,240,242,244,65535,246,65535,65535,248,250,252,254,256,65535,258,65535,260,65535,262,264,266,268,270,272,274,65535,276,65535,65535,278,280,282,284,65535,286,288,65535,65535,65535,65535,290,292,294,296,65535,298,300,302,304,306,308,310,312,314,316,318,320,322,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11286,15923,22068,14434.5,6488,17691,20589.5,14284.5,22697.5,16045.5,23828,14305.5,19939,22495,22740.5,19634,14478.5,19339,27409.5,-6.669785e-05,16214.5,9232.5,23090,14517,13696,16264,24059,19911.5,17720.5,16608,14967.5,16815.5,-0.008576395,14086.5,0.012664439,18956.5,10173.5,4686,31233,0.00068031193,0.00018545121,0.011554605,0.0068419664,19429.5,9074,10603.5,11394,15709,21043.5,28279,18785.5,24963,21315.5,15530,-0.005332373,0.0058065327,25133,16662.5,24515.5,27063,22467,9649.5,6518,11175,0.0058595845,9826.5,19802.5,17088,12746,4588.5,10319,4826,31746.5,0.0041638496,20468,0.006955167,0.0032322046,5753.5,12919.5,0.0010816504,15034,14214,3175,21623.5,15897.5,16027.5,14636.5,18413,19443.5,21011.5,21470,0.0010387357,24028.5,-0.003378254,15315,19269,0.000949673,27546.5,18778.5,17695.5,20151,16752.5,29598.5,28738.5,22568,9363.5,8321,18207.5,8553.5,0.002497941,13178.5,16320,18496.5,-0.012657213,16518,11094.5,22257,18930.5,-0.0042664493,-0.0033636484,-0.0019364462,27285,26007.5,27516,25578,31755.5,11262,-0.00097024784,-0.00030521952,3579,8733.5,14909.5,12790.5,14825,0.023624932,14844,15097,2717,14580.5,16013,0.0052319462,-0.0004398387,16862.5,15622.5,-0.011339587,-0.011137571,29590.5,18025,16482,19045.5,19677,19884,21909.5,0.007954835,28870,0.0047515663,0.009379906,0.007034181,19524,-0.0046054353,-0.0014852002,13631,14620,0.002628021,0.014326665,17388.5,19698,0.0028865186,0.0010040246,10663,13272.5,27760.5,29793.5,26123,9980,-0.013604549,29652,-0.0001011335,0.0011818139,-0.00019044166,-0.002140788,-0.0014600873,0.0002345894,0.0057899207,0.0030439044,0.00067655643,-0.0004807917,-0.00080510165,-0.0029029844,0.0004733352,-0.0010062929,-0.0010368674,-0.0066481354,-0.00358878,-0.015832582,0.0015911919,-0.0023787783,-0.0077162385,-0.009721127,0.0023979011,0.00859691,-0.0016345205,0.0009384298,-0.0006146736,-0.0012103474,-0.0017151047,-0.0038458107,0.00018980975,0.0023060434,-0.0010741472,0.0005344901,0.00078704365,-0.0014502663,0.0034499746,0.00032652644,-0.009563824,-0.0019195464,0.0017339633,-0.0029963967,0.013167691,0.017882813,-0.0010360449,0.004751721,-0.0051658684,0.00035980353,-0.00422137,-0.0007998136,0.0018468325,-0.00029123315,-0.002786337,-0.008272462,0.004984028,0.0021472832,-0.0038657978,0.005257617,-0.000495573,-0.004393851,0.00055012153,-0.014279135,0.011218908,0.0010745425,0.011078912,-0.00028640928,0.015894039,0.02318419,-0.0044107474,-0.011015922,-0.018002711,-0.010951283,0.000896709,0.003371502,0.01160738,0.01782785,-0.0025696391,-0.00052427227,-0.004772387,-0.009623227,-0.014304462,-0.008830278,0.00028280795,-0.007092184,0.002878839,-0.0008574698,0.010819284,0.0014580453,-0.0017305982,-0.012379314,0.0036128287,-0.0011374754,-0.0009208508,0.008929516,0.003380343,-0.001539918,0.000365584,-8.0483886e-05}, {1,3,6,6,0,6,4,6,2,3,6,3,1,0,0,0,4,6,4,255,3,0,0,2,6,1,3,1,4,1,1,0,255,4,255,2,1,1,4,255,255,255,255,0,1,6,3,1,3,0,0,0,0,4,255,255,2,3,1,4,2,0,1,3,255,3,2,2,3,1,1,1,6,255,0,255,255,6,2,255,0,2,6,0,6,1,1,6,6,0,1,255,0,255,1,4,255,6,0,0,0,3,4,0,2,0,3,0,1,255,2,0,2,255,0,0,2,0,255,255,255,0,6,0,0,2,3,255,255,2,2,1,1,2,255,3,4,2,2,0,255,255,6,0,255,255,0,6,1,6,1,0,4,255,0,255,255,255,4,255,255,3,1,255,255,1,2,255,255,3,1,0,2,0,3,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,65535,63,65535,65,67,69,71,65535,65535,65535,65535,73,75,77,79,81,83,85,87,89,91,93,65535,65535,95,97,99,101,103,105,107,109,65535,111,113,115,117,119,121,123,125,65535,127,65535,65535,129,131,65535,133,135,137,139,141,143,145,147,149,151,153,65535,155,65535,157,159,65535,161,163,165,167,169,171,173,175,177,179,181,183,65535,185,187,189,65535,191,193,195,197,65535,65535,65535,199,201,203,205,207,209,65535,65535,211,213,215,217,219,65535,221,223,225,227,229,65535,65535,231,233,65535,65535,235,237,239,241,243,245,247,65535,249,65535,65535,65535,251,65535,65535,253,255,65535,65535,257,259,65535,65535,261,263,265,267,269,271,65535,273,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,65535,64,65535,66,68,70,72,65535,65535,65535,65535,74,76,78,80,82,84,86,88,90,92,94,65535,65535,96,98,100,102,104,106,108,110,65535,112,114,116,118,120,122,124,126,65535,128,65535,65535,130,132,65535,134,136,138,140,142,144,146,148,150,152,154,65535,156,65535,158,160,65535,162,164,166,168,170,172,174,176,178,180,182,184,65535,186,188,190,65535,192,194,196,198,65535,65535,65535,200,202,204,206,208,210,65535,65535,212,214,216,218,220,65535,222,224,226,228,230,65535,65535,232,234,65535,65535,236,238,240,242,244,246,248,65535,250,65535,65535,65535,252,65535,65535,254,256,65535,65535,258,260,65535,65535,262,264,266,268,270,272,65535,274,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8.5,28996.5,10317,18076.5,25474.5,10268.5,21285.5,14495,30440.5,3278,27220,19880.5,10271.5,13708.5,22974,12236,1.5,27171,2.5,2.5,32341,31726.5,30278,5659.5,27573,-0.008522398,15.5,10123.5,18259,21325,18243.5,11405,5869.5,8350,15331.5,20401.5,13844,19294,30152,-0.004058252,27873.5,-0.00449003,18157.5,2.5,26592.5,29587.5,31847.5,5492,6052,0.010065331,0.004004752,-0.0035212894,-0.0061951946,15.5,8206.5,18985.5,24138.5,17529,23918.5,20437.5,17172,7857.5,11584.5,17412.5,11596,-0.003195809,0.014104174,12231,18486,1.5,1.5,28175,31364.5,32501.5,21694.5,20215.5,11063,0.0016348911,3115,5,2.5,0.0022620906,30486.5,3.5,-0.00032702563,4.5,30273.5,4.5,30108.5,10721,5251.5,5943.5,5538,8713.5,18.5,6829,9683,12620,13223,18761.5,18.5,15.5,20213.5,21960.5,22733,20663,13541.5,28334,16920.5,7584,9015.5,6393.5,12198,12741.5,0.009113821,15123.5,12614,19526,15496.5,14505,-0.002085945,18219,19704.5,25723,24561.5,29258.5,13382,16515.5,2.5,18355,19430.5,18891,24723.5,28523,-0.0026511156,4.5,11196.5,-0.004011884,-0.00037274114,0.0035662316,0.0014331642,25396.5,24678.5,-0.012723083,-0.0068991645,-0.00021271057,25865.5,0.006174215,0.0011065578,4.5,3.5,31175,29805,29746.5,30120,9397,2645.5,5556,5580,5991.5,6396,4922.5,6465.5,30719.5,12.5,11821.5,10456,5865,0.008431868,11141.5,12188,12408.5,19059.5,12817.5,20733,18365.5,18371.5,20965,20114.5,11172.5,24608,0.013971115,0.008914762,-0.015171881,-0.009839325,0.0006994212,-0.0045029223,14355.5,15.5,16.5,15.5,10871.5,15.5,29416.5,24237.5,0.00011222442,0.0041782963,-0.0015880831,0.00014992387,0.0008155899,0.011209803,-0.00015885112,0.005477076,0.002652512,0.00041269633,-0.0034762453,7.367686e-05,0.018703528,-0.0032755963,0.0010126283,-0.0040701716,-0.006444224,0.004090454,-0.0033909322,-0.010118818,-0.0036155581,0.0064341608,0.0016886516,0.0057608215,0.012510652,0.006627954,-0.012915059,-0.0014202379,0.0027738563,-0.0016786052,-0.0060360553,-0.011192403,0.0020548387,0.006250067,0.0016910825,-0.0016774824,0.00072531874,0.0029488315,-0.00045975,0.00077348476,0.00045410806,0.002819731,0.0008181184,-0.0015535142,-0.0007640737,-0.002422692,-0.0023814647,-0.00047826135,0.0027083678,-5.6290424e-05,-0.0003373016,0.0023869837,0.0010008614,0.00022138833,0.00043544997,0.00017830654,0.0022224041,0.00087017595,0.00077868014,-0.00036593282,-6.3985317e-06,0.0024213626,-0.0013019,2.9040062e-05,-0.00044090813,-0.0009123074,6.783369e-05,-0.00032582314,-0.00023010401,0.0011713174,-0.0034433585,-0.0009232589,-0.0139501365,0.0031982956,0.016391443,0.0010420941,-0.0019833145,-0.010461991,0.0051440373,-0.0023250272,-0.0005706837,0.004643938,-0.0052640717,-0.00023443213,0.0011997176,-0.0002818371,-0.00042678742,-0.0017512095,0.00062818837,0.0017157352,-0.0005336211,0.0025174513,-0.00061850727,0.0017829962,-0.012698102,0.00034469986,-0.004892547,-0.0004151031,0.0027888007,0.016422229,-0.0031966486,0.010345395,0.0011801668,-0.0019158721,0.012517633,0.00192331,-0.0028032495,0.0044303113,-0.0048246314,-0.010384514,0.0015391939,-0.0030511243,0.0043956763,-0.0018306634,-0.0056990734,1.1961724e-05,-0.0061193923,0.0012841251,-0.001018792,0.01636598,-0.0005223351,-0.0017585413,0.00023555681,-0.0037224833,0.0134763075,0.004552332,0.0035627943,0.011998872,0.0045129335,-0.0011452403,0.0059181014,-0.00069518,-0.008035465,-1.5015605e-05}, {8,5,1,2,2,1,0,3,2,0,2,3,1,0,0,2,8,0,8,8,5,5,5,1,2,255,8,0,1,1,1,2,1,0,0,1,3,3,0,255,3,255,0,8,0,3,5,1,1,255,255,255,255,8,3,2,5,1,1,5,3,2,2,2,1,255,255,0,3,8,8,2,0,2,5,5,5,255,2,8,8,255,5,8,255,8,3,8,2,2,5,0,3,2,8,3,2,3,1,1,8,8,2,5,2,2,1,0,5,2,2,1,2,2,255,2,1,5,1,2,255,3,5,2,0,0,3,1,8,3,1,5,5,0,255,8,5,255,255,255,255,0,2,255,255,255,2,255,255,8,8,5,0,0,2,2,3,1,5,3,0,3,2,1,8,1,1,2,255,5,1,3,0,5,5,0,2,2,0,1,2,255,255,255,255,255,255,1,8,8,8,3,8,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,65535,77,65535,79,81,83,85,87,89,91,65535,65535,65535,65535,93,95,97,99,101,103,105,107,109,111,113,115,65535,65535,117,119,121,123,125,127,129,131,133,135,65535,137,139,141,65535,143,145,65535,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,65535,205,207,209,211,213,65535,215,217,219,221,223,225,227,229,231,233,235,237,239,65535,241,243,65535,65535,65535,65535,245,247,65535,65535,65535,249,65535,65535,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,65535,289,291,293,295,297,299,301,303,305,307,309,311,65535,65535,65535,65535,65535,65535,313,315,317,319,321,323,325,327,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,65535,78,65535,80,82,84,86,88,90,92,65535,65535,65535,65535,94,96,98,100,102,104,106,108,110,112,114,116,65535,65535,118,120,122,124,126,128,130,132,134,136,65535,138,140,142,65535,144,146,65535,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,65535,206,208,210,212,214,65535,216,218,220,222,224,226,228,230,232,234,236,238,240,65535,242,244,65535,65535,65535,65535,246,248,65535,65535,65535,250,65535,65535,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,65535,290,292,294,296,298,300,302,304,306,308,310,312,65535,65535,65535,65535,65535,65535,314,316,318,320,322,324,326,328,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({37,30,41.5,19.5,9.5,6.5,33,66,81,30,34.5,-0.01331517,62.5,20.5,37,2.5,6.5,38,0.019797593,1222.5,173,27,17.5,-0.0012944998,-0.004647141,30,268,106.5,40.5,1.5,12.5,3.5,17.5,22,-0.0038286818,4.5,0.0055050454,7.5,0.014419729,25061.5,12.5,0.00067780446,-0.011318525,16.5,11.5,0.00091320026,-0.007446711,513,0.0057698363,58.5,60.5,22,-0.0032854748,32.5,15.5,-0.0020202538,0.00046569828,107.5,-0.0010544362,20.5,28,465.5,148,1.5,8.5,490,31565.5,0.00032040972,15.5,1377.5,1377.5,0.008346102,0.003392669,-0.012928866,-0.0050226105,6.5,113,871.5,818.5,-0.0012439624,0.00081941806,22,0.0040432443,22,22,13.5,-0.0011421853,0.0008926972,21.5,20.5,-0.0015765837,192,-0.011990746,-0.0003189291,328.5,0.008671249,2.5,0.009607074,0.0064613493,16.5,17.5,-0.004513115,0.0011332848,-0.004532747,-0.0002452664,72,6.5,28.5,-0.0052598035,-0.020594327,-0.012203754,116,11.5,93.5,-0.004058736,645.5,2152.5,0.00075440964,-0.0016647385,-0.0013150221,-0.004653579,-0.000649896,0.0022395912,-0.0058936086,-0.0024203295,-0.0009865399,0.00016199825,0.007972422,0.0024647568,0.001898347,-0.0019101739,0.0025923594,0.0044019544,-0.0030716069,0.0033482313,0.00035497494,0.0033443745,0.0076215765,-0.0025389527,-0.0034762535,0.00015833086,0.0020064923,0.005533108,0.004935567,0.008023872,0.0005974319,-0.00549006,-0.00805662,-0.0013313942,0.0028133437,0.0064226226,0.00020759819,-0.001641538,0.0011630775,-2.257375e-05}, {6,4,6,8,8,8,2,2,2,6,6,255,2,8,2,8,8,2,255,4,4,7,8,255,255,2,6,4,7,8,8,8,8,2,255,8,255,8,255,2,8,255,255,8,8,255,255,6,255,2,7,6,255,6,8,255,255,2,255,8,6,2,2,8,8,2,3,255,8,7,7,255,255,255,255,8,2,2,7,255,255,6,255,6,6,8,255,255,8,8,255,2,255,255,2,255,8,255,255,8,8,255,255,255,255,6,8,4,255,255,255,6,8,2,255,6,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,65535,35,37,39,41,65535,65535,43,45,47,49,51,53,55,57,59,65535,61,65535,63,65535,65,67,65535,65535,69,71,65535,65535,73,65535,75,77,79,65535,81,83,65535,65535,85,65535,87,89,91,93,95,97,99,101,65535,103,105,107,65535,65535,65535,65535,109,111,113,115,65535,65535,117,65535,119,121,123,65535,65535,125,127,65535,129,65535,65535,131,65535,133,65535,65535,135,137,65535,65535,65535,65535,139,141,143,65535,65535,65535,145,147,149,65535,151,153,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,65535,36,38,40,42,65535,65535,44,46,48,50,52,54,56,58,60,65535,62,65535,64,65535,66,68,65535,65535,70,72,65535,65535,74,65535,76,78,80,65535,82,84,65535,65535,86,65535,88,90,92,94,96,98,100,102,65535,104,106,108,65535,65535,65535,65535,110,112,114,116,65535,65535,118,65535,120,122,124,65535,65535,126,128,65535,130,65535,65535,132,65535,134,65535,65535,136,138,65535,65535,65535,65535,140,142,144,65535,65535,65535,146,148,150,65535,152,154,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({18.5,1018.5,4926,671.5,1337.5,5349.5,5836.5,427,22.5,1207,1609,529,11780,6717.5,6019,382.5,273,0.011288753,2315.5,1041,1175,15.5,1056,422,336.5,5250.5,30697,3966.5,6896.5,6743,7602,397,318,318.5,502.5,679.5,349,-0.006486685,17.5,7.5,0.013376403,1049,2582,4.5,909,453.5,439,1371,570.5,0.025947047,4179.5,3002,31034.5,1460.5,5092,5530,-0.01075432,5814.5,0.01836709,5323,7842.5,261.5,603,-0.011652781,339.5,14.5,498,15.5,771.5,-0.011309116,465,10.5,1331.5,41,1488,-0.0004319171,0.0037837785,6.5,1279.5,-0.018800383,-0.0035330893,0.024218662,1025,1020,7744,104.5,613,-0.02553325,-0.0006868879,28,892,650.5,847,0.017261436,0.004759629,0.00527979,0.0033607145,2988,-0.005093522,1616.5,3611,5476,5380.5,0.013050683,5563.5,5528.5,-0.011380613,8557,6043.5,7435,15181.5,321.5,755,220,-0.012793653,-0.0005861597,-0.003562705,573,0.0040422203,11.5,-0.0076008188,400,0.0008389353,3.5,565.5,336.5,12.5,0.0073979497,0.004024391,1078.5,3245.5,5265,1414,241.5,7523,-0.0072122994,-0.003963662,1502,1662.5,1063.5,14.5,-0.014075126,0.0012079122,7505.5,8060.5,99,125,1072,20.5,0.010167743,0.030008674,-0.0022604316,20.5,-0.008010476,0.03850401,1004,912,-0.0011838655,0.0029201154,-0.0125965495,-0.004949396,2956.5,4166,5156.5,-0.0035242995,5331.5,5780,8813.5,-0.007850881,4538,0.012350875,2667.5,9314,5008.5,6421,6045,8279,9686,13827,5.0234998e-05,-0.0020315384,0.008812759,0.00087710965,-0.00656075,0.0025131477,-0.0013743765,0.0021301291,-0.0045124725,0.00016259156,0.0034154174,0.011498175,-0.009743048,0.0014893269,0.0022226803,0.010641969,-0.0035853938,-0.01273075,-0.0027860797,0.0008825026,-0.008261726,-0.0015748609,0.0051595024,-0.00020724277,-0.0036797877,0.0027182326,0.003351976,0.000826813,-0.0047148266,0.0037090592,-0.009662913,-0.0011064856,-0.0001341474,-0.00441652,0.006160565,0.0020178373,-0.008545721,-0.0038991005,-0.000453091,0.0039968425,0.00015807312,0.0038976267,-0.001200382,3.590093e-05,-0.00031673358,-0.0028607429,-0.0013535197,0.0031191106,-0.0024503653,-0.009629928,-0.010363786,0.006438012,0.0073532336,0.014528505,-0.016850477,-0.001446426,0.013041064,0.00010712006,-0.0018496227,0.005334442,-2.0004602e-05,-0.0023911828,-0.009497437,-0.015664315,0.01208019,0.00012831483,-0.0070979297,0.0021234879,0.0062680207,0.0006884934,0.0071137133,-0.0043908986,-0.0018155471,0.0036834606,-0.0048560877,-0.000749665,0.00018894112,-0.0057981303,0.0008076983,-0.00192523,0.004298507,-0.0041740686,0.015130964,0.001055454,-0.0010259477,0.0017032014,-0.0027081107,-0.00017817006}, {8,7,2,1,2,3,2,5,7,3,2,1,1,1,2,5,1,255,1,7,2,8,7,1,7,7,5,3,3,3,3,1,1,7,1,1,2,255,8,8,255,1,5,8,3,5,5,1,1,255,1,2,7,7,7,5,255,3,255,3,3,3,2,255,3,8,5,8,2,255,7,8,5,2,5,255,255,8,3,255,255,255,7,1,7,5,2,255,255,7,3,3,5,255,255,255,255,2,255,1,3,5,7,255,3,1,255,2,7,5,2,2,2,2,255,255,255,5,255,8,255,1,255,8,3,7,8,255,255,3,1,7,5,3,5,255,255,2,7,1,8,255,255,7,3,2,7,7,8,255,255,255,8,255,255,1,1,255,255,255,255,7,1,5,255,3,3,1,255,7,255,5,2,7,5,5,5,3,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,65535,77,79,81,83,85,87,89,91,65535,93,95,97,99,101,103,65535,105,65535,107,109,111,113,65535,115,117,119,121,123,65535,125,127,129,131,133,65535,65535,135,137,65535,65535,65535,139,141,143,145,147,65535,65535,149,151,153,155,65535,65535,65535,65535,157,65535,159,161,163,165,65535,167,169,65535,171,173,175,177,179,181,183,65535,65535,65535,185,65535,187,65535,189,65535,191,193,195,197,65535,65535,199,201,203,205,207,209,65535,65535,211,213,215,217,65535,65535,219,221,223,225,227,229,65535,65535,65535,231,65535,65535,233,235,65535,65535,65535,65535,237,239,241,65535,243,245,247,65535,249,65535,251,253,255,257,259,261,263,265,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,65535,78,80,82,84,86,88,90,92,65535,94,96,98,100,102,104,65535,106,65535,108,110,112,114,65535,116,118,120,122,124,65535,126,128,130,132,134,65535,65535,136,138,65535,65535,65535,140,142,144,146,148,65535,65535,150,152,154,156,65535,65535,65535,65535,158,65535,160,162,164,166,65535,168,170,65535,172,174,176,178,180,182,184,65535,65535,65535,186,65535,188,65535,190,65535,192,194,196,198,65535,65535,200,202,204,206,208,210,65535,65535,212,214,216,218,65535,65535,220,222,224,226,228,230,65535,65535,65535,232,65535,65535,234,236,65535,65535,65535,65535,238,240,242,65535,244,246,248,65535,250,65535,252,254,256,258,260,262,264,266,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1469.5,1400.5,1758.5,295,1720.5,2.5,1806,115,21.5,-0.015714204,1424,1695.5,4.5,2503,1847.5,904,342,15.5,748.5,16.5,5.5,2479.5,2652,3062,1538.5,16,1779,1824,7794.5,142.5,16,18.5,18.5,199.5,1248.5,343,1117.5,-0.009945287,-0.0042494372,1481,878.5,-0.0046425303,6934.5,-0.010469653,7230.5,2471.5,7257,19.5,4448.5,7.5,0.00083078427,8.5,12.5,10.5,1895.5,7695.5,7615.5,125,287.5,54,0.021445561,7.5,463.5,313,177.5,3.5,26.5,624,2059,181.5,536,797,1010.5,-0.010418371,7229.5,12.5,8522,0.0074742585,-0.0033927422,0.00029764694,1.5,0.011065017,0.025290621,1513.5,8259,12.5,0.020581987,15.5,5.5,-0.0026319183,-0.017688647,0.0042481367,13.5,7.5,-0.00044196678,0.0025013862,-0.00078763516,0.011986162,0.003937432,7218.5,6829,6598.5,7692.5,112.5,137,373.5,3.5,1109.5,-0.010367156,2.5,204,20.5,0.03177054,-0.0035680723,16.5,0.0021242655,-0.009085668,1.5,12.5,222.5,824.5,30.5,692.5,1153,1290.5,-0.0017114704,0.0056498325,-0.01069946,-0.01929375,367,0.037159573,1800.5,1174.5,0.0014875714,-0.0064089047,0.003546472,-0.011532498,17.5,15.5,-0.0097324485,-0.0044267657,-0.002098408,0.0019046994,1519.5,-0.004168398,6.5,17.5,1716.5,1716.5,1611.5,4644,-0.0026237045,-6.6035536e-05,-0.0023678634,-0.007942925,1957,7782.5,5982.5,7759,7878.5,8536.5,8010.5,7809,-1.1933067e-05,0.0020636446,-0.0077533247,-0.00058651046,-0.0027681876,-0.01583284,-0.006096988,0.00041541696,0.0036934153,-0.0013969633,0.0005315074,0.011126342,0.007100723,-0.0033617038,0.009794406,-0.002074581,0.0026863758,0.0067024976,-0.0041495897,-0.008369387,-0.0028980856,0.000736243,-0.0015289526,-0.014358888,0.0017236002,-0.00055852643,-0.010308727,-0.0014287089,-0.00072319416,-0.014547634,-0.0067163496,0.0074040256,-0.011261734,-0.00077083235,0.0062201316,-0.001052332,0.005780511,-0.0015504184,-0.0006149026,-0.0091719115,0.00019519357,0.0035403904,3.1110394e-05,-0.0036251713,-0.0016140555,0.00073461613,0.000968568,0.0057063582,-0.0018786433,0.0022807054,0.0007359321,-0.005921451,-0.0076756673,0.0076962323,-0.0020487567,-0.005056101,0.002218077,-0.001628539,0.0060384977,0.00026583273,0.000108870445,-0.0019715447,0.0012598218,-0.0115626445,0.00719115,0.0014633407,-0.010885174,0.00021311594,-0.007186554,0.0011840295,0.011318084,0.0033924603,-0.005010306,-4.4073666e-05}, {1,1,1,2,2,8,1,3,8,255,1,5,8,2,1,1,6,8,2,8,8,2,2,6,2,8,1,1,6,1,8,8,8,3,2,3,2,255,255,3,5,255,2,255,6,6,6,8,6,8,255,8,8,8,3,6,2,2,6,2,255,8,1,5,2,8,6,1,6,5,2,3,1,255,6,8,6,255,255,255,8,255,255,3,2,8,255,8,8,255,255,255,8,8,255,255,255,255,255,2,2,3,2,5,2,1,8,1,255,8,1,8,255,255,8,255,255,8,8,1,2,1,3,6,3,255,255,255,255,3,255,2,5,255,255,255,255,8,8,255,255,255,255,1,255,8,8,5,5,1,3,255,255,255,255,1,5,3,2,6,3,6,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,65535,73,75,65535,77,65535,79,81,83,85,87,89,65535,91,93,95,97,99,101,103,105,107,65535,109,111,113,115,117,119,121,123,125,127,129,131,65535,133,135,137,65535,65535,65535,139,65535,65535,141,143,145,65535,147,149,65535,65535,65535,151,153,65535,65535,65535,65535,65535,155,157,159,161,163,165,167,169,171,65535,173,175,177,65535,65535,179,65535,65535,181,183,185,187,189,191,193,195,65535,65535,65535,65535,197,65535,199,201,65535,65535,65535,65535,203,205,65535,65535,65535,65535,207,65535,209,211,213,215,217,219,65535,65535,65535,65535,221,223,225,227,229,231,233,235,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,65535,74,76,65535,78,65535,80,82,84,86,88,90,65535,92,94,96,98,100,102,104,106,108,65535,110,112,114,116,118,120,122,124,126,128,130,132,65535,134,136,138,65535,65535,65535,140,65535,65535,142,144,146,65535,148,150,65535,65535,65535,152,154,65535,65535,65535,65535,65535,156,158,160,162,164,166,168,170,172,65535,174,176,178,65535,65535,180,65535,65535,182,184,186,188,190,192,194,196,65535,65535,65535,65535,198,65535,200,202,65535,65535,65535,65535,204,206,65535,65535,65535,65535,208,65535,210,212,214,216,218,220,65535,65535,65535,65535,222,224,226,228,230,232,234,236,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8085.5,7479,8482.5,7704.5,7606,5245,8813.5,7077,5538.5,8736,7080.5,9855,7521.5,8808.5,9288.5,6424,6487,4076.5,6627,8327,7941.5,6410.5,3123.5,3640.5,-0.007495258,8178,8490.5,8100,0.01277225,11637,9649.5,5564.5,9292.5,6016.5,6257.5,7113,5590.5,6558.5,9191.5,5329,8643,-0.015001579,-0.02482679,8268,7549.5,8012.5,7763,8371.5,8755,-0.02810294,8363,5955.5,9519,5997.5,8178,9904,7923.5,10844.5,9688.5,5372.5,6850,8179,12746,5142.5,5600.5,7783.5,7075.5,5144.5,3673,6439.5,4147.5,9132.5,7225.5,7194,7903,6046.5,6300.5,0.014436908,6454.5,1865,7597.5,7997.5,-0.018294182,8626,7922.5,8236,8267.5,-0.00837367,0.00046132822,7393,4344.5,6950.5,-0.018957593,0.0013637588,7237,0.007456347,9573,7105.5,9063.5,-0.009288395,6413.5,6034.5,8726,0.012556925,0.00742073,8041,11798.5,9784.5,2216.5,5758.5,6023.5,5253,7013,7554,7165,6147.5,-0.009957087,9008,5596.5,0.0020676784,5816,6885,0.042526778,9012.5,8653,4829.5,1773.5,-0.004135804,1514,2955.5,7344.5,0.0037161894,5400.5,6479,-0.00834983,-0.0121351285,-0.016207574,7128.5,5952,6362,9221.5,6928.5,0.014162937,7806.5,6655,6980.5,5993.5,8001.5,5148.5,-0.005560478,9706,0.0016172497,-0.0036129118,8148,0.0043218657,-1.5629214e-05,-0.004962574,7711,8013,8002.5,9441.5,8347.5,8427.5,8213,8348.5,-0.0036160355,-0.011764946,6315,9842,-0.0045328024,10014,8596.5,8577.5,6854,0.014601158,4176.5,9093,4636.5,8932,6343.5,9216.5,9466,9631.5,9927,9507,8951,7952.5,9726,5795.5,-2.7434753e-05,0.0047156946,-0.0017507706,-0.016320115,-0.001472993,0.0020791295,-0.007818334,0.00020536389,-0.0017287995,0.0031016674,-0.0005647658,-0.018777417,0.0041890987,0.014290305,0.00010189437,-0.013084191,0.008475838,-0.00015118497,-0.01991921,-0.0068690567,-0.009224438,0.014424542,0.0030075973,0.019366188,-0.024953011,-0.0004240074,-0.0010964791,0.00397045,0.0014438108,-0.0038885553,-0.00066610955,0.0012570901,-0.003426642,0.00046702163,0.009089586,-0.00063832797,0.009547729,0.015259767,0.0013311064,-0.0033901806,0.0004661361,0.009172387,0.0029486653,-0.0055963486,-0.001183803,-0.0108482195,0.009309254,0.00071579387,-0.0019236731,0.0015872158,0.023133323,-0.0025936167,-0.019288436,-0.010983243,0.0017017381,-0.0005666471,0.008175608,0.0012521964,0.0023082488,0.004710953,-0.000570313,0.001402116,-0.002419058,0.00076304533,0.0012164966,-0.0004099351,0.009664246,0.0007948596,0.003379531,-0.0016252337,-0.015809331,-0.0076324465,-0.0002108373,0.004069108,0.0021955343,-0.00080389204,-0.00076924753,-0.0039556785,0.0033043565,0.0053226883,-0.0015274911,0.0014537142,-0.000915979,-0.0029000605,-0.009894936,-0.0044696922,0.0021391683,0.00039443868,0.006310753,0.0005427585,-0.0024722423,0.0007241072,-0.0003882492,0.0048204265,0.00037817785,0.008777299,-0.0057733385,0.001072848,-0.0033028685,0.0006350584,-0.021022303,-0.00763653,-0.00055143645,0.0037772686,0.0009745353,0.000107930195,-0.0069731227,0.00038187276,0.0016014889,-0.00014267824,-0.014480561,-0.0049817385,-0.0025020253,-0.0053812205,-0.010455121,-0.0006624711,-0.008852684,-0.00021292323,-0.0045282156,-0.0014532738,0.00045792377,-6.176528e-05}, {0,0,0,4,4,7,0,4,7,7,2,4,6,0,0,0,1,1,6,1,0,7,7,4,255,1,1,1,255,6,0,2,2,1,6,2,6,0,4,7,1,255,255,4,1,0,1,0,4,255,0,1,6,1,1,1,2,6,0,2,2,7,2,1,0,2,0,0,0,1,1,4,1,7,6,1,4,255,4,6,0,0,255,6,6,2,1,255,255,4,1,2,255,255,4,255,1,4,2,255,6,7,4,255,255,2,2,4,1,0,6,4,2,1,2,1,255,6,1,255,0,0,255,2,7,0,7,255,1,6,1,255,7,0,255,255,255,7,2,0,4,4,255,0,4,2,6,0,2,255,4,255,255,4,255,255,255,7,0,1,1,0,0,0,0,255,255,2,2,255,1,0,6,2,255,6,1,1,0,4,2,0,2,1,0,2,1,6,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,65535,55,57,59,61,63,65,67,69,71,73,75,77,65535,65535,79,81,83,85,87,89,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,65535,145,147,149,151,65535,153,155,157,159,65535,65535,161,163,165,65535,65535,167,65535,169,171,173,65535,175,177,179,65535,65535,181,183,185,187,189,191,193,195,197,199,201,65535,203,205,65535,207,209,65535,211,213,215,217,65535,219,221,223,65535,225,227,65535,65535,65535,229,231,233,235,237,65535,239,241,243,245,247,249,65535,251,65535,65535,253,65535,65535,65535,255,257,259,261,263,265,267,269,65535,65535,271,273,65535,275,277,279,281,65535,283,285,287,289,291,293,295,297,299,301,303,305,307,309,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,65535,56,58,60,62,64,66,68,70,72,74,76,78,65535,65535,80,82,84,86,88,90,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,65535,146,148,150,152,65535,154,156,158,160,65535,65535,162,164,166,65535,65535,168,65535,170,172,174,65535,176,178,180,65535,65535,182,184,186,188,190,192,194,196,198,200,202,65535,204,206,65535,208,210,65535,212,214,216,218,65535,220,222,224,65535,226,228,65535,65535,65535,230,232,234,236,238,65535,240,242,244,246,248,250,65535,252,65535,65535,254,65535,65535,65535,256,258,260,262,264,266,268,270,65535,65535,272,274,65535,276,278,280,282,65535,284,286,288,290,292,294,296,298,300,302,304,306,308,310,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({9688,12330,14645.5,11582,8398,15637,17316.5,9596,7699,8187,8164.5,13586.5,15486.5,17584.5,20643.5,25601.5,9597.5,5081.5,0.014629142,7900.5,0.0045495816,-0.010810434,-0.004500862,14318,11471.5,13317.5,24754.5,15993,16429.5,18206.5,19468,10696,-0.00802001,0.0127459755,9961,0.0037703395,6823.5,6138,-0.007192017,12743.5,-0.009108387,14400,12676.5,22679.5,28048.5,18450.5,21707,21083.5,14364,15889,18453,18592.5,22234,18488.5,17900,10635,8362.5,9629.5,10226,6161,-0.0028624735,6212.5,12674.5,13208.5,11206.5,13602,6704,14411.5,14214,20832.5,14544,19359.5,28113,0.0017800821,13743,20872,25854,18090,14705,0.0005086769,18781,0.007017001,0.0047434797,-0.0035380174,17170.5,18730,25726.5,24081.5,26119,25363.5,16454,0.012968103,23421,1800,-0.013178656,6670,10852,2145,9632,-0.005032512,10661.5,12592.5,0.0036448445,5762.5,25111,0.00476953,21361,13772,11390.5,5510.5,15056.5,14083,14952.5,17412.5,7100,11027.5,11596,12908,11741,25852.5,11317,23657.5,10082.5,13479,23126.5,24619,28241.5,0.009201557,0.016474202,9175.5,22205.5,-0.0055576744,24447.5,17107.5,20225,0.0026597816,0.007232848,17096.5,-0.013734817,19317.5,0.00049246656,18051.5,20065.5,20812.5,22901.5,18588,21436,0.011473204,18100.5,-0.00552237,21936.5,0.012960366,0.006548992,20901.5,22467,0.00038133096,1.8741854e-05,0.0005811172,0.0046469085,0.0029385095,-0.011561499,0.0040516434,0.0002910351,0.0105625745,0.0010571686,0.00043886277,-0.0001805258,0.00024467506,-0.0009967668,-0.00078220683,0.0005411753,-0.0040517226,0.0013859767,0.00093000056,-0.00027960804,-0.00039199358,0.0028110133,-0.0072037913,-0.00023612664,-0.0012146836,0.0025938076,-0.010003728,0.00049848546,0.0058132624,0.002987958,0.0003201135,0.0026517252,-0.00038885695,0.002415099,-0.0043071886,-0.0010349178,0.00864281,0.0010303229,0.002791517,0.01603756,-0.003788673,0.0035240909,-0.0019976846,-0.006013648,-0.00057582086,-0.010540327,-0.006777768,-0.0007351681,0.0019967377,-0.00023763823,0.005738986,0.00092438934,-0.0029383681,-0.0092687225,0.007045818,-0.0010101981,-0.00966387,0.00013881577,-0.018531224,-0.010225145,0.00029498315,-0.0014344318,0.0061971974,0.0013685912,0.0066452953,0.0029192304,-0.0031684742,0.0017337872,-0.0073162913,-0.00025562794,-0.008535014,-0.004198974,0.003222176,0.0002941117,-0.005047638,0.0018634957,0.010149883,0.0044556963,0.0104710525,0.015131804,0.0071492353,0.0016494881,-0.0055648405,-0.010370846,0.0020340683,0.0030138127,0.0069984915,0.0015011559,0.005019999,0.0010524848,0.00015409329,-0.0031008436,0.004705263,5.9776132e-05}, {4,2,7,2,4,0,0,4,1,4,1,2,5,1,2,0,4,7,255,4,255,255,255,7,5,1,4,0,0,1,4,0,255,255,0,255,0,5,255,1,255,4,1,2,4,2,1,5,5,0,1,2,0,4,0,0,7,2,0,5,255,0,2,5,2,0,5,0,2,2,5,4,2,255,7,5,4,4,0,255,4,255,255,255,0,4,4,5,0,2,5,255,0,4,255,7,0,7,2,255,0,7,255,4,2,255,0,0,1,7,1,2,0,2,5,1,1,0,7,4,5,0,7,7,0,0,0,255,255,7,5,255,1,7,4,255,255,1,255,4,255,0,0,0,0,4,4,255,2,255,7,255,255,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,65535,65535,65535,39,41,43,45,47,49,51,53,55,65535,65535,57,65535,59,61,65535,63,65535,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,125,65535,127,129,131,133,135,65535,137,65535,65535,65535,139,141,143,145,147,149,151,65535,153,155,65535,157,159,161,163,65535,165,167,65535,169,171,65535,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,65535,65535,215,217,65535,219,221,223,65535,65535,225,65535,227,65535,229,231,233,235,237,239,65535,241,65535,243,65535,65535,245,247,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,65535,65535,65535,40,42,44,46,48,50,52,54,56,65535,65535,58,65535,60,62,65535,64,65535,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,126,65535,128,130,132,134,136,65535,138,65535,65535,65535,140,142,144,146,148,150,152,65535,154,156,65535,158,160,162,164,65535,166,168,65535,170,172,65535,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,65535,65535,216,218,65535,220,222,224,65535,65535,226,65535,228,65535,230,232,234,236,238,240,65535,242,65535,244,65535,65535,246,248,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({38.5,27,5588.5,132.5,26.5,5545.5,5851.5,29.5,608,16.5,12.5,5446.5,5554.5,7735.5,5875,26.5,37,18.5,19.5,12.5,0.02392857,28.5,32.5,4997.5,5155.5,-0.019061135,7690.5,5624.5,4.5,5804,5817.5,60,12.5,29,16.5,7.5,-0.020270297,952,1218,28.5,-0.0040765963,0.0086023975,32,17.5,71,4991,5235.5,6057.5,5732.5,5520,18.5,5514.5,6061.5,0.0017720612,5628,11.5,16,5770,6421.5,28.5,16,-0.0051092724,-0.001555825,20.5,5.5,54.5,-0.0068771797,0.0023092683,26.5,933,24233,0.018109856,-0.00043017213,-0.0011820955,0.0015423323,90,8.5,-0.00069462176,41,17.5,0.0055350377,1544.5,8.5,1438.5,8634.5,4996,6221.5,5277,6055.5,5915.5,-0.019076256,5297.5,0.0107098855,5724.5,5803,6050,5799.5,-0.0010918815,12.5,-9.793694e-05,-0.0006561214,6494,-0.010249833,6341.5,7987,14085.5,6465,22,17.5,22,0.005802152,18.5,0.011363013,98,22,-0.00047829692,1113.5,-0.0045982283,-0.007932426,-0.0005048649,7.5,5883.5,25523.5,0.0018399559,0.0002114503,2.5,35.5,-0.008002157,-0.0041182847,-0.0021094633,-0.0002267866,1497,1694.5,-0.0010388772,-0.009566655,-0.008053612,5064.5,3369,12856,4905,4338.5,0.01065177,6787.5,9347.5,6164,6502,12.5,0.007093299,13.5,4555,0.00557136,5762,6066,15.5,5676.5,5725,6829.5,12.5,16.5,-0.0123040825,17,-0.005073613,-0.0027582047,6026,17.5,5657,6147.5,6724.5,6101.5,6517,7664,-0.0005585132,0.0021991534,-0.0026806889,0.00014158808,0.001944668,-0.0039396384,0.0049178554,-0.0017031214,0.0008641599,0.008401878,0.0011283737,-0.0019453567,-0.0058314237,-0.0030959013,-0.008188415,-0.0036151062,0.0005136623,0.005474159,-0.0028127967,0.0025942426,0.0010564696,0.0048487475,0.0041310634,-0.0012882107,-1.254052e-05,0.0036931403,-0.004400113,-0.00039185514,0.0059498786,0.00036196984,0.0013255364,0.007545508,0.0024335762,-0.00071706873,0.0011084423,0.005150236,-0.018474799,-0.0030931411,-0.001029583,0.00076594186,-0.0009775031,-0.008494583,-0.020627424,-0.00474902,0.010655957,-0.0011595179,0.00047658678,-0.004064539,-0.0050132005,-0.0010942798,0.0012142938,-0.0004978367,0.0007938139,0.008719005,-0.0005917378,-0.0048457314,0.007116283,0.01990794,0.013840623,0.022086965,-0.0027768747,0.0032428484,-0.019467214,-0.0041974816,0.0028837183,-0.00033361895,0.0035949033,0.014603128,-0.004286093,-0.010886244,-0.0004442223,-0.015109176,0.0015829357,0.006654046,0.0017364348,-0.020817088,-0.0043978714,-0.00041851774,0.0009656337,0.004008438,0.00049156393,-0.012551284,-0.00945483,-0.0020940981,0.00043675807,-2.366543e-05}, {4,5,4,0,7,4,4,0,1,8,8,1,4,0,4,0,7,8,8,8,255,5,5,5,4,255,7,5,8,0,0,7,8,1,8,8,255,0,0,4,255,255,7,8,7,5,0,1,5,5,8,1,5,255,4,8,8,0,0,7,8,255,255,8,8,7,255,255,4,0,0,255,255,255,255,0,8,255,7,8,255,4,8,0,7,0,1,5,5,0,255,1,255,4,7,7,4,255,8,255,255,0,255,1,4,7,0,0,8,4,255,8,255,0,4,255,7,255,255,255,8,0,0,255,255,8,5,255,255,255,255,4,4,255,255,255,5,7,7,0,7,255,1,7,7,1,8,255,8,0,255,0,0,8,4,7,7,8,8,255,8,255,255,1,8,1,1,1,1,1,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,67,65535,69,71,73,65535,65535,75,77,79,81,83,85,87,89,91,93,95,65535,97,99,101,103,105,107,109,65535,65535,111,113,115,65535,65535,117,119,121,65535,65535,65535,65535,123,125,65535,127,129,65535,131,133,135,137,139,141,143,145,147,65535,149,65535,151,153,155,157,65535,159,65535,65535,161,65535,163,165,167,169,171,173,175,65535,177,65535,179,181,65535,183,65535,65535,65535,185,187,189,65535,65535,191,193,65535,65535,65535,65535,195,197,65535,65535,65535,199,201,203,205,207,65535,209,211,213,215,217,65535,219,221,65535,223,225,227,229,231,233,235,237,65535,239,65535,65535,241,243,245,247,249,251,253,255,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,68,65535,70,72,74,65535,65535,76,78,80,82,84,86,88,90,92,94,96,65535,98,100,102,104,106,108,110,65535,65535,112,114,116,65535,65535,118,120,122,65535,65535,65535,65535,124,126,65535,128,130,65535,132,134,136,138,140,142,144,146,148,65535,150,65535,152,154,156,158,65535,160,65535,65535,162,65535,164,166,168,170,172,174,176,65535,178,65535,180,182,65535,184,65535,65535,65535,186,188,190,65535,65535,192,194,65535,65535,65535,65535,196,198,65535,65535,65535,200,202,204,206,208,65535,210,212,214,216,218,65535,220,222,65535,224,226,228,230,232,234,236,238,65535,240,65535,65535,242,244,246,248,250,252,254,256,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4823,21.5,5600,2.5,2415,11627.5,6624,3733,4488,212.5,1253,540.5,6492.5,7720.5,6541.5,9408.5,4017,3783,4535,327,1707.5,-0.010048213,4105.5,252,15.5,5077,6601.5,5316.5,6301,9592.5,6683.5,1203,12962.5,3483,4782,3780.5,6072.5,10.5,6161,22,-0.0072072796,1223.5,1992,873.5,4192.5,3811.5,816,3238,5576.5,4.5,-0.010343789,17.5,4493,4958,8473.5,6038.5,8910,6057.5,9690,6839.5,7175.5,200.5,1188,2836,1.5,-3.508363e-05,9445.5,7232.5,5005.5,17.5,-0.0080535235,4.5,7423.5,6.5,4464.5,4595,7013.5,26,29.5,1011.5,-0.009007129,0.032592252,0.0065858415,602.5,2536,7523.5,4354,-0.010542571,5006,-0.003877066,-0.0128853535,5152,5610.5,8639,6731,0.00271743,14860,-0.0014280705,-0.0041302536,10240.5,4742.5,6064,0.014945817,6924,7.5,7983,7178.5,6894,9051.5,5430,9652.5,8.5,4.5,6415,8523.5,7834,7912,91.5,324.5,2576.5,1328.5,1.5,3669,3137,0.00015058859,3845,-0.011915425,4129.5,0.005709379,6989,5118,4.5,3296.5,6749.5,12.5,17.5,4.5,8772,5996,4297,9308,18.5,11.5,6762.5,4.5,-0.0026098865,-0.004586164,0.0059762276,46,646.5,1082,-0.0010968146,0.01257944,1735.5,3714,6336.5,6067.5,3396.5,7145.5,15.5,17.5,5244,11.5,5602.5,7703.5,4007.5,5197.5,5804.5,-0.0018229192,16.5,22549.5,0.0018521606,-0.001420253,12161.5,0.0043458985,3706,17.5,6904,5831,6375.5,10889,15.5,8279.5,0.038215738,-0.003642204,6528.5,6543.5,7767.5,6468.5,13,16.5,7968,12.5,-0.0056550284,-0.010261192,10507.5,5.5,-0.0030420308,-0.014263794,14.5,4.5,6826.5,8432.5,9664,8060.5,0.00075248815,-0.0033386543,0.008400041,0.00045102998,-0.009010318,0.0027327414,0.0073002176,-0.0028868744,0.002097502,-0.00040870727,0.0052547352,0.0022826416,-0.0031603735,-0.004753317,-0.0069974633,-0.00091817864,0.0018662211,-0.0028468033,-0.002988588,0.0012021763,-0.0050546285,-0.008526535,0.0005183918,-0.00043101257,0.00062158,-0.0011572329,0.00080872234,0.005883345,-0.0010327608,0.0008541817,0.002370574,0.019142132,-0.0018167802,0.0018813908,-0.0017837597,0.006035407,0.0010059689,-0.004563274,0.0011827027,-0.0020299607,-0.011844386,-0.0019651856,0.0020802685,-0.0032085404,-0.0012087945,-0.0035526596,0.0031887775,0.006626992,0.0034675293,-0.0008848668,-0.0043141367,-0.00027426443,0.010537458,0.033325642,0.008513746,-0.006519817,-0.00035615842,-0.011509909,0.0049435943,-0.0007900159,0.010027896,0.019098995,-0.0029628717,0.00017799961,-0.0028771348,0.004149564,-0.0068181492,6.88696e-05,-0.0010691765,0.013104975,0.0008186103,-0.0071900613,0.0028173516,0.0077380086,-0.00094232376,0.002343551,-0.0005235785,-0.0105850985,0.0028041948,-1.0000701e-05,0.0036863834,3.7334976e-05,0.00875634,0.001455074,0.023312856,0.01035387,-0.003139713,-0.008176552,0.0016891273,-0.0040404974,0.0015875116,0.0027693955,0.0025890311,-0.008941457,0.0027932825,0.016617915,-0.0045132576,0.019893745,-0.022229265,-0.007779999,0.0069634253,0.0014786887,-0.007828749,0.0007012037,0.007686706,0.019764535,-0.015486732,0.0021225666,0.002427071,-0.0056654224,-0.013788856,-0.004327449,0.009303756,0.005787442,-0.006475585,0.00032348378,0.018410077,0.0053350604,0.0009251279,-0.004344095,0.008879537,0.0016362414,-0.0045245574,0.0016319748,-0.006242165,0.0030010839,0.011000388,0.0002773501,0.00085924,0.005282179,-0.006664857,-0.0017491354,-0.001119499,-0.008317753,0.004447091,0.0008457578,0.0031449143,0.00034706524,-0.0021128582,4.43598e-05}, {7,8,3,8,0,6,6,7,7,0,5,0,7,3,7,0,7,7,7,5,5,255,3,0,8,3,0,0,7,0,7,6,6,3,6,7,3,8,0,0,255,5,3,7,6,5,3,5,3,8,255,8,3,0,0,7,3,7,0,6,6,7,7,3,8,255,0,5,3,8,255,8,0,8,5,7,0,5,6,6,255,255,255,7,6,0,7,255,6,255,255,0,0,6,6,255,0,255,255,0,5,6,255,0,8,3,0,0,3,7,6,8,8,0,6,7,7,6,7,0,5,8,5,5,255,3,255,6,255,0,5,8,7,6,8,8,8,0,0,6,6,8,8,0,8,255,255,255,6,7,5,255,255,3,0,0,5,7,0,8,8,3,8,0,0,0,7,6,255,8,0,255,255,0,255,0,8,0,5,6,0,8,3,255,255,7,7,0,7,8,8,3,8,255,255,0,8,255,255,8,8,0,3,0,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,83,85,87,89,91,93,95,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,65535,133,135,137,139,141,143,145,147,149,65535,65535,65535,151,153,155,157,65535,159,65535,65535,161,163,165,167,65535,169,65535,65535,171,173,175,65535,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,65535,221,65535,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,65535,65535,65535,255,257,259,65535,65535,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,65535,291,293,65535,65535,295,65535,297,299,301,303,305,307,309,311,65535,65535,313,315,317,319,321,323,325,327,65535,65535,329,331,65535,65535,333,335,337,339,341,343,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,84,86,88,90,92,94,96,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,65535,134,136,138,140,142,144,146,148,150,65535,65535,65535,152,154,156,158,65535,160,65535,65535,162,164,166,168,65535,170,65535,65535,172,174,176,65535,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,65535,222,65535,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,65535,65535,65535,256,258,260,65535,65535,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,65535,292,294,65535,65535,296,65535,298,300,302,304,306,308,310,312,65535,65535,314,316,318,320,322,324,326,328,65535,65535,330,332,65535,65535,334,336,338,340,342,344,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({843.5,583.5,868,258.5,726.5,716,2105.5,457,262.5,757,1037.5,0.0138166165,1182,1346,2261.5,271.5,22,0.013087118,537.5,54.5,739,1122.5,922.5,0.0011076472,935.5,1987.5,2021,2152.5,2264,122.5,443,0.0076297927,49.5,26.5,607.5,-0.020520791,669,365,685.5,711,1447.5,-0.00895858,4334,0.0037369386,0.0023785462,807.5,0.0073022335,581,2421.5,2114.5,4336,0.010525794,1204,49,148,123,-0.0016125841,12266,132,23,50,0.009248385,1014,608,1044.5,0.003087074,0.007245378,769,0.0019309052,617.5,747.5,-0.0041811457,0.0007627711,3038.5,781,0.007196636,1850,44,1687.5,1598,8496,-0.0021636419,2178.5,2312.5,11488,2388.5,5185,82.5,62,152,246,315,445,805,0.0010596116,33,129.5,-0.004910478,-0.0021958244,0.011430523,357,0.005071967,0.0024557516,472,594,1263.5,-0.012022643,0.00052068493,8955.5,-0.0054582916,-0.023009656,-0.005001019,-0.0073349276,1842,0.0038759992,4774.5,-0.0047662845,1144,1870,-0.0014357845,179.5,1119.5,1846,-0.008668002,2218.5,2532,1737,0.0018110024,5085.5,4049.5,-0.0010733451,0.0024669243,1.205606e-05,-0.01162536,5564.5,5987,5374.5,0.00049135805,-0.009748924,-0.0018602143,-0.00039333157,0.003470941,0.010504154,-0.0006212104,-0.0066580973,0.0036812646,0.00025355627,0.015286359,0.004482955,-0.015257537,-0.007827963,-0.0018414553,0.00088983815,-0.00017755748,-0.00382539,0.0023144793,-0.00015326327,-0.0005169078,-0.003357137,0.004491785,0.0018999163,-0.0060320576,0.0005683379,-0.0030882938,-0.0006182752,0.0007999992,-0.0027084246,-0.0014486994,4.3107713e-05,-0.0016031255,0.00048214552,-0.005219675,-0.002853464,0.0024267046,0.0010008059,0.0058263605,0.012331886,0.0052466854,0.0026428571,0.0013748523,-0.002314483,0.0050115352,0.0010558439,0.001370866,-0.0012377005,-0.0014951205,0.0009267982,-0.009254453,-0.014454591,-0.0039623035,-0.0011692339,-0.0008449876,0.0005001174,0.0016195131,2.8597185e-06}, {7,6,7,7,3,1,6,0,7,7,5,255,3,7,6,1,6,255,7,1,6,6,0,255,6,6,1,6,6,5,0,255,3,0,5,255,7,0,3,7,1,255,0,255,255,6,255,0,5,6,5,255,7,0,5,5,255,0,6,3,3,255,0,3,6,255,255,7,255,6,7,255,255,0,7,255,6,0,6,7,1,255,7,7,1,0,6,5,6,1,1,0,3,0,255,7,5,255,255,255,6,255,255,1,1,0,255,255,0,255,255,255,255,5,255,1,255,6,0,255,0,3,1,255,5,7,7,255,0,3,255,255,255,255,0,5,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,65535,33,35,37,39,41,65535,43,45,47,49,51,53,55,65535,57,59,61,65535,63,65,67,69,71,65535,73,65535,65535,75,65535,77,79,81,83,65535,85,87,89,91,65535,93,95,97,99,65535,101,103,105,65535,65535,107,65535,109,111,65535,65535,113,115,65535,117,119,121,123,125,65535,127,129,131,133,135,137,139,141,143,145,147,149,65535,151,153,65535,65535,65535,155,65535,65535,157,159,161,65535,65535,163,65535,65535,65535,65535,165,65535,167,65535,169,171,65535,173,175,177,65535,179,181,183,65535,185,187,65535,65535,65535,65535,189,191,193,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,65535,34,36,38,40,42,65535,44,46,48,50,52,54,56,65535,58,60,62,65535,64,66,68,70,72,65535,74,65535,65535,76,65535,78,80,82,84,65535,86,88,90,92,65535,94,96,98,100,65535,102,104,106,65535,65535,108,65535,110,112,65535,65535,114,116,65535,118,120,122,124,126,65535,128,130,132,134,136,138,140,142,144,146,148,150,65535,152,154,65535,65535,65535,156,65535,65535,158,160,162,65535,65535,164,65535,65535,65535,65535,166,65535,168,65535,170,172,65535,174,176,178,65535,180,182,184,65535,186,188,65535,65535,65535,65535,190,192,194,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({51.5,30,60,72,59.5,47.5,41.5,3421.5,201.5,33.5,37,106,43.5,42,211,33.5,0.0032490068,22,27,31.5,40.5,513,5148.5,39,-0.012779067,53,55.5,25.5,412,115.5,101,22,0.0025553808,25.5,-0.00080667326,-0.0015440405,0.0013589648,0.0026552475,28.5,29.5,0.0037108772,-0.009988605,2649.5,112,5917.5,0.0003764069,32.5,0.008733085,0.0035871398,54.5,-0.0033698117,69,33.5,76.5,34.5,107.5,89,-0.012376384,225.5,22,22,0.0044404296,42.5,36,266.5,0.0093042245,0.006171835,-0.0020656625,-0.0066746674,71.5,764,-0.017277544,29.5,-0.006694013,-0.0042115427,53,0.000978791,-0.0010469822,553,12076,-0.0020384945,284.5,26.5,22,0.0024956814,41.5,121.5,-0.007402384,130.5,-0.008846446,305,22,29.5,-0.0016360121,-0.0020710083,0.0023952234,0.0032706198,-0.0003034349,0.0013552521,34.5,-0.0003063253,-0.0020115115,111,237.5,1716,0.0043681175,-0.004548556,-0.0018511125,-0.0005963139,0.0011385323,0.0031829413,-0.013266727,0.0014181699,187.5,-0.00305365,275.5,0.0045992,-0.006111999,264,61,79.5,300.5,258.5,155,152.5,174.5,313.5,-0.0011789196,0.0004365246,0.00075891294,2.3266706e-05,-0.0022994876,-0.0013669286,0.0009784823,-0.0031015675,0.0023705945,0.004299981,0.00060373486,0.0031457269,-0.00067221833,0.0015662815,0.0023990276,-0.0010619648,-0.00016087962,-0.002607946,-0.0076409033,0.000307476,0.0015871797,0.0040713153,-0.00042922198,0.0034231858,-0.003973152,-0.0003981445,0.0053374656,0.007908213,0.015171279,0.009350886,0.00015794576,-0.002609866,0.006394163,-1.3062121e-05}, {0,2,0,6,6,3,6,4,6,6,2,6,4,3,4,0,255,2,2,2,2,6,6,2,255,0,0,3,0,4,0,6,255,4,255,255,255,255,4,0,255,255,7,3,6,255,3,255,255,0,255,0,3,3,6,4,6,255,4,2,0,255,4,0,2,255,255,255,255,7,2,255,0,255,255,0,255,255,0,0,255,0,6,4,255,7,3,255,0,255,4,0,0,255,255,255,255,255,255,0,255,255,2,2,2,255,255,255,255,255,255,255,255,0,255,0,255,255,2,2,4,2,0,4,0,7,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,65535,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,65535,61,65535,65535,65535,65535,63,65,65535,65535,67,69,71,65535,73,65535,65535,75,65535,77,79,81,83,85,87,65535,89,91,93,65535,95,97,99,65535,65535,65535,65535,101,103,65535,105,65535,65535,107,65535,65535,109,111,65535,113,115,117,65535,119,121,65535,123,65535,125,127,129,65535,65535,65535,65535,65535,65535,131,65535,65535,133,135,137,65535,65535,65535,65535,65535,65535,65535,65535,139,65535,141,65535,65535,143,145,147,149,151,153,155,157,159,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,65535,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,65535,62,65535,65535,65535,65535,64,66,65535,65535,68,70,72,65535,74,65535,65535,76,65535,78,80,82,84,86,88,65535,90,92,94,65535,96,98,100,65535,65535,65535,65535,102,104,65535,106,65535,65535,108,65535,65535,110,112,65535,114,116,118,65535,120,122,65535,124,65535,126,128,130,65535,65535,65535,65535,65535,65535,132,65535,65535,134,136,138,65535,65535,65535,65535,65535,65535,65535,65535,140,65535,142,65535,65535,144,146,148,150,152,154,156,158,160,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({42,130,211,515.5,146,116.5,230.5,169.5,49.5,-0.010199511,-0.003629156,101,130.5,-0.0067848177,280.5,137.5,47.5,962,1192.5,79.5,67,32,92,277.5,313.5,86,48,0.009584641,224,115.5,27.5,-0.0013684237,-0.007228035,62,62,25.5,228.5,0.006884485,199,0.0089204535,0.014242654,132,-0.012663237,287,856.5,28.5,179,-0.00916413,-0.002260098,-0.0049285847,29.5,-0.009296997,860.5,32053,0.0019714152,54.5,4387.5,68,0.0025551456,201.5,26.5,168.5,258.5,0.0031039817,0.005158482,92,949.5,0.0022990468,0.00782521,804,738.5,22,22.5,90.5,33,102.5,0.005884692,180.5,-0.0031189253,25432,0.0025265825,29.5,46.5,196,-0.00023665422,0.0038219856,0.005145378,42.5,948.5,1122,42.5,97.5,0.0044619204,234.5,102.5,445,181.5,280.5,2111,826.5,4386,1181,1733.5,-0.00039025952,-0.0021625545,0.0024032057,0.0001199474,-0.010024148,-0.002090143,0.003049947,-0.002437304,0.0011691817,-0.00062042556,-0.0012144789,-0.0002588318,-4.4538803e-05,-0.0038443946,-0.00050610036,0.0020360388,-0.0006848675,-0.0021842222,0.003779402,0.0027759976,-2.6849762e-05,0.0018681005,-0.0010441948,4.1117746e-05,-0.0073252344,-0.0027229923,-0.0030998907,-0.0013686632,0.0018358482,-0.0008457775,-0.003655657,-0.0028027461,-0.00081069366,0.00085999566,0.0022337826,0.007894226,-0.0049981284,0.0011848164,-0.0017783804,0.0010109826,-0.008276786,-0.0022144967,0.00031900167,0.004298908,0.007060571,0.0006831487,-0.007874339,-0.00084903056,0.00068936736,-4.6292873e-05}, {7,6,4,0,6,4,4,0,6,255,255,6,0,255,7,0,1,1,0,6,3,1,1,7,6,4,6,255,0,3,7,255,255,0,4,3,0,255,6,255,255,6,255,6,0,0,4,255,255,255,6,255,1,1,255,0,0,0,255,6,3,0,0,255,255,3,0,255,255,1,4,4,1,0,1,3,255,3,255,0,255,3,6,0,255,255,255,4,0,6,4,3,255,0,3,4,3,3,0,0,6,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,19,21,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,65535,65535,55,57,59,61,65535,63,65535,65535,65,65535,67,69,71,73,65535,65535,65535,75,65535,77,79,65535,81,83,85,65535,87,89,91,93,65535,65535,95,97,65535,65535,99,101,103,105,107,109,111,65535,113,65535,115,65535,117,119,121,65535,65535,65535,123,125,127,129,131,65535,133,135,137,139,141,143,145,147,149,151,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,20,22,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,65535,65535,56,58,60,62,65535,64,65535,65535,66,65535,68,70,72,74,65535,65535,65535,76,65535,78,80,65535,82,84,86,65535,88,90,92,94,65535,65535,96,98,65535,65535,100,102,104,106,108,110,112,65535,114,65535,116,65535,118,120,122,65535,65535,65535,124,126,128,130,132,65535,134,136,138,140,142,144,146,148,150,152,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1037.5,414,1707,266.5,139,1703.5,5257.5,201.5,374,11.5,998,21.5,18.5,16.5,5368,139,547.5,507.5,0.006914966,0.0013907605,0.0125344265,2959.5,18.5,1394,796.5,13.5,1774.5,2107.5,2232.5,5696,5593.5,129,277.5,8.5,7.5,15.5,17.5,11.5,-0.010764209,1196.5,-0.018136142,1371.5,4.5,0.02024214,1201,6.5,-0.0029227019,0.025090301,0.014677405,1260.5,3408,1425.5,3744,4559.5,8380.5,4851,5717.5,123,137,437.5,12.5,-0.0019819192,329.5,3.5,6075.5,327.5,133.5,1279.5,-0.0037441873,1207.5,1203,15.5,-0.011497123,1220,842,1765.5,1643.5,0.0063280226,-0.007553775,1809.5,1600,14.5,5.5,7.5,3649.5,1815.5,2200,3301,4532,0.008539729,5302.5,5316,5501.5,5466.5,5911.5,5556,5763,632.5,17.5,9.5,24.5,189,0.012272919,4.5,377,-0.0057299724,-0.010522565,-0.0064467373,-0.003687957,12.5,-0.0035801635,317.5,724.5,19.5,0.010590159,8.5,0.0016591428,862.5,1836,967,1907,6.5,-0.0023982965,18.5,16.5,7.5,1130,1158,2846,15.5,17.5,1598.5,0.0054834965,0.00912977,0.0047974507,6.5,0.007634935,2052.5,1912,2.5,3056.5,4.5,4501,0.007863681,20.5,863.5,0.009686751,2140.5,3785,3386.5,4961.5,0.012005053,11.5,0.012277017,18.5,9526.5,-0.010188597,0.014676143,4373,5481.5,9762.5,5720,6641.5,6842,5812.5,0.00024081724,-0.0020555991,-0.0013513026,0.01798548,-0.013673264,-0.0019508948,0.0037160926,-0.0005636291,0.0070400178,0.0026748062,0.0018320772,0.004206653,-0.008385563,0.00066971354,-0.0003612728,0.0028820166,-0.0023131815,0.007441617,0.00089263247,-0.0008748902,0.007204766,0.0005008584,0.00062419125,-0.0010741035,-0.0015270562,0.00226673,-0.00733647,0.001108513,-0.00052379095,-0.005889594,0.0043271217,-0.0015377078,-0.0014823426,0.004698382,-0.0013016039,0.007902269,0.004160169,-0.0038617614,0.00032145812,0.0021727076,0.0035232082,0.0074419933,0.0123558,0.002341407,-0.006494832,0.000757604,-0.0016036192,-0.0095943995,-0.00089924736,0.00576256,-0.00042135917,-0.0039719217,-0.00018556086,-0.00832684,-0.0029101402,0.0031418663,0.004345458,0.0022161033,-0.0029610745,0.0018083003,-0.0042252764,-0.00064120156,0.0060324385,0.0005130826,-0.0015841377,-0.00010643552,0.0036914446,0.0004219256,0.0029313632,-0.014501301,0.01081947,0.0014470331,-0.00058533816,0.016950335,0.003296578,-0.009130806,0.00087644433,-0.0013296239,0.012761578,0.019239342,0.0029058398,-0.0015802752,0.0022625488,-0.0013685215,0.005756201,-0.0051427106,-0.0005910888,-0.006998747,0.0019199156,-0.0016519763,0.0007376002,-0.014539781,0.010215704,0.00013949115,-0.011663827,0.0001879724,0.0027469504,1.4440959e-05}, {5,4,4,5,5,5,6,5,5,8,5,8,8,8,6,5,0,0,255,255,255,4,8,4,6,8,0,4,4,5,6,2,4,8,8,8,8,8,255,4,255,5,8,255,5,8,255,255,255,5,5,5,4,4,0,4,6,2,2,2,8,255,2,8,0,5,0,0,255,4,0,8,255,6,2,0,2,255,255,0,4,8,8,8,5,4,6,4,4,255,2,6,2,6,5,4,6,6,8,8,5,4,255,8,4,255,255,255,255,8,255,4,6,8,255,8,255,4,2,0,2,8,255,8,8,8,6,5,0,8,8,4,255,255,255,8,255,0,4,8,5,8,5,255,8,6,255,6,5,6,6,255,8,255,8,4,255,255,4,6,0,0,0,4,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,65535,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,65535,73,75,65535,77,79,65535,65535,65535,81,83,85,87,89,91,93,95,97,99,101,103,65535,105,107,109,111,113,115,65535,117,119,121,65535,123,125,127,129,65535,65535,131,133,135,137,139,141,143,145,147,149,65535,151,153,155,157,159,161,163,165,167,169,171,173,65535,175,177,65535,65535,65535,65535,179,65535,181,183,185,65535,187,65535,189,191,193,195,197,65535,199,201,203,205,207,209,211,213,215,65535,65535,65535,217,65535,219,221,223,225,227,229,65535,231,233,65535,235,237,239,241,65535,243,65535,245,247,65535,65535,249,251,253,255,257,259,261,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,65535,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,65535,74,76,65535,78,80,65535,65535,65535,82,84,86,88,90,92,94,96,98,100,102,104,65535,106,108,110,112,114,116,65535,118,120,122,65535,124,126,128,130,65535,65535,132,134,136,138,140,142,144,146,148,150,65535,152,154,156,158,160,162,164,166,168,170,172,174,65535,176,178,65535,65535,65535,65535,180,65535,182,184,186,65535,188,65535,190,192,194,196,198,65535,200,202,204,206,208,210,212,214,216,65535,65535,65535,218,65535,220,222,224,226,228,230,65535,232,234,65535,236,238,240,242,65535,244,65535,246,248,65535,65535,250,252,254,256,258,260,262,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2673.5,769.5,8194.5,709.5,278.5,7981.5,8741.5,523,19.5,2119,863,7961.5,6656,5730.5,16.5,506,375.5,620.5,749,312,8.5,18.5,897,6692.5,6836,6265,6744.5,2157.5,6513,8645.5,15438,220,17.5,360,18.5,4647,838,-0.008443603,0.0306757,152.5,17.5,0.0032879715,17.5,4.5,963.5,464,379,3794.5,7218.5,15.5,-0.015123585,5119,12.5,0.025308434,7509,415.5,6580.5,-0.018953677,9416,7962.5,9818.5,10399.5,13827,21.5,5.5,729,0.027343858,336,13.5,504,-0.014666359,7.5,8.5,4.5,314,12.5,-0.010426582,394.5,-0.009462862,-0.0034341947,120.5,526,345,0.0005119396,-0.024827905,0.0103358505,0.0017831868,1243,544.5,19.5,4926,11777,7568.5,-0.0027886427,-0.009648307,7.5,4128,4.5,8107,6373.5,15.5,8538,7.5,11.5,7826.5,8172.5,10127,1.5,8307.5,26720.5,1.5,6592.5,13621,19916,22581.5,186,441.5,443.5,439.5,0.0075409114,-0.0038422,20.5,-0.016423183,0.00918168,0.0054303785,464,573,0.0050558033,342,0.0022644836,0.0041060327,-0.0036596004,8.5,0.001298997,0.0055429307,-0.00873252,-0.0029473996,11.5,7.5,-0.0018923797,-0.00052639755,-0.007176358,2.5,14.5,431,18.5,11.5,18.5,1009,6.5,2256,18.5,6858.5,3953,-0.016003512,7544.5,8001.5,7899.5,2163.5,5.5,0.0057690945,4295,7957,8053,8171.5,5.5,7180,2.5,8038,0.0060023004,365.5,1181.5,18.5,4.5,8605,0.008277171,15.5,1.5,2.5,0.00537369,15.5,9636,6400,11224.5,8428,7002,14877,32413,18076.5,4687,11577,6395,12769.5,16946,27369.5,22085,29466,-0.00013489365,-0.0026672762,-0.00020562798,0.032422174,0.00051855,-0.0068588234,0.0009475981,0.004094696,-0.0009918774,0.0046088793,-0.00419886,-0.010832197,-0.0048848516,0.0008027229,0.010145728,0.005399503,-0.00036758548,-0.0026191708,0.0011212113,0.0057398374,-0.003563457,-0.0021472585,-0.00012986234,-0.0041191354,0.00039656958,0.0054979897,-0.011581969,0.0010828446,-0.00024495806,-0.0049238703,-0.007435816,-0.013653296,0.0032509097,0.01233319,-0.0012289006,-0.00013723293,-9.1505804e-05,0.0015818141,-0.016400052,-0.00024058924,-6.1100545e-05,0.003281916,-0.00071673567,0.001744826,-0.00058891595,0.0026067796,-0.00036106043,-0.0073544057,0.0022901935,-0.0009319284,0.00621795,0.0019927477,-0.0037197128,-0.0009369381,0.0033751111,0.0008311718,0.00021894004,-0.0061632623,-0.0070956233,-0.0038335004,0.004504848,-0.006015765,0.004339224,0.007835381,0.00039554207,0.008650504,-0.005260685,-0.015937347,-0.0032121874,0.0038002953,0.014789228,0.0036486879,0.0012983334,-0.001503578,0.00037672932,-0.00045314195,-0.0017534754,-0.0038252503,0.002475506,-0.0017433023,0.0015894832,0.004077089,0.005967341,0.0036807891,-0.013625348,-0.00011419575,0.0025780944,-0.011533744,0.0025236278,0.004101011,0.0009931499,-0.003177619,-1.4722201e-05,0.0008953288,0.012090251,0.003881416,-0.0013688557,0.0043569114,0.00034475498,-0.0035667643,0.0014064043,0.0071655423,0.0017836273,-0.00073148625,-0.000552376,0.0001547499,-0.00093328225,0.00075069204,-0.0032634807,0.0006770864,-0.00020967126,0.001965468,-0.011102392,-0.0018530919,-0.0011123957,-0.0046120775,-0.0008184411,-0.0028594946,-0.0006641478,-0.007824326,-0.0006903405,0.00048761652}, {3,4,2,4,7,2,2,4,8,4,4,2,1,4,8,4,7,2,2,3,8,8,4,2,1,4,1,1,4,7,4,7,8,7,8,1,2,255,255,2,8,255,8,8,2,1,1,3,2,8,255,4,8,255,7,4,3,255,3,7,7,3,3,8,8,1,255,7,8,2,255,8,8,8,1,8,255,1,255,255,1,2,1,255,255,255,255,2,1,8,2,7,2,255,255,8,3,8,2,7,8,3,8,8,7,3,3,8,7,4,8,1,1,2,7,7,1,4,2,255,255,8,255,255,255,2,4,255,1,255,255,255,8,255,255,255,255,8,8,255,255,255,8,8,3,8,8,8,7,8,2,8,3,7,255,2,7,3,1,8,255,3,4,2,2,8,4,8,1,255,4,1,8,8,2,255,8,8,8,255,8,2,1,4,7,4,3,1,2,3,2,4,3,2,2,7,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,65535,65535,75,77,65535,79,81,83,85,87,89,91,93,65535,95,97,65535,99,101,103,65535,105,107,109,111,113,115,117,119,65535,121,123,125,65535,127,129,131,133,135,65535,137,65535,65535,139,141,143,65535,65535,65535,65535,145,147,149,151,153,155,65535,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,65535,65535,205,65535,65535,65535,207,209,65535,211,65535,65535,65535,213,65535,65535,65535,65535,215,217,65535,65535,65535,219,221,223,225,227,229,231,233,235,237,239,241,65535,243,245,247,249,251,65535,253,255,257,259,261,263,265,267,65535,269,271,273,275,277,65535,279,281,283,65535,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,65535,65535,76,78,65535,80,82,84,86,88,90,92,94,65535,96,98,65535,100,102,104,65535,106,108,110,112,114,116,118,120,65535,122,124,126,65535,128,130,132,134,136,65535,138,65535,65535,140,142,144,65535,65535,65535,65535,146,148,150,152,154,156,65535,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,65535,65535,206,65535,65535,65535,208,210,65535,212,65535,65535,65535,214,65535,65535,65535,65535,216,218,65535,65535,65535,220,222,224,226,228,230,232,234,236,238,240,242,65535,244,246,248,250,252,65535,254,256,258,260,262,264,266,268,65535,270,272,274,276,278,65535,280,282,284,65535,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({33.5,65,28.5,59.5,57.5,76,32.5,37,158,-0.009601257,128,27.5,480,26.5,51.5,135.5,91.5,63.5,0.010212786,-0.000643122,-0.0045290175,-0.001235177,-0.00017780463,74,3643.5,494.5,134.5,112.5,21285.5,119.5,761.5,-0.012768413,115.5,-0.00034939704,0.00016071425,284.5,121,0.0034913719,0.0023803127,182,31565.5,44,55,43.5,281,21226,22740.5,296.5,0.009476966,-0.015629256,22,0.004615055,37.5,183.5,0.0047235503,0.003507939,131,154,0.004960417,327.5,0.0027484274,0.0015898753,-0.0018567154,-0.00031288434,-0.006807557,34.5,40,0.007414741,0.0047656097,20021,0.017249094,16997,20663,28.5,2739,2847,1203,-0.011983388,150.5,0.002144826,0.0010582565,-0.0001800262,28.5,-0.00089113944,-0.00013684097,-0.00036895438,25554.5,-0.0022355556,56.5,0.0022854973,0.0009975194,14016.5,18668.5,16271.5,20300.5,10645,21717,-0.0007732875,0.00025502674,-0.003592504,-0.0061388994,-0.00051950285,-0.00860494,-0.0029017234,0.0011276131,0.0049878852,-0.0042231823,0.0014765956,0.00053779536,-0.005725507,-0.0010326797,0.0010075617,-0.0006117883,0.00012783291,-0.0013790549,0.0036840506,1.3478924e-05,-0.0013743119,0.0077727265,0.00932387,-0.00575701,-0.000337441,0.006211956,-0.005515486,-1.4841665e-07}, {3,2,6,2,6,0,7,2,0,255,0,0,2,7,7,0,0,0,255,255,255,255,255,2,0,2,2,0,0,0,0,255,0,255,255,0,0,255,255,2,3,1,0,6,1,0,0,6,255,255,2,255,1,0,255,255,0,2,255,1,255,255,255,255,255,0,0,255,255,2,255,7,2,0,6,0,0,255,0,255,255,255,7,255,255,255,0,255,0,255,255,7,1,3,2,3,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,21,23,25,27,29,31,33,65535,65535,65535,65535,65535,35,37,39,41,43,45,47,49,65535,51,65535,65535,53,55,65535,65535,57,59,61,63,65,67,69,71,73,65535,65535,75,65535,77,79,65535,65535,81,83,65535,85,65535,65535,65535,65535,65535,87,89,65535,65535,91,65535,93,95,97,99,101,103,65535,105,65535,65535,65535,107,65535,65535,65535,109,65535,111,65535,65535,113,115,117,119,121,123,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,22,24,26,28,30,32,34,65535,65535,65535,65535,65535,36,38,40,42,44,46,48,50,65535,52,65535,65535,54,56,65535,65535,58,60,62,64,66,68,70,72,74,65535,65535,76,65535,78,80,65535,65535,82,84,65535,86,65535,65535,65535,65535,65535,88,90,65535,65535,92,65535,94,96,98,100,102,104,65535,106,65535,65535,65535,108,65535,65535,65535,110,65535,112,65535,65535,114,116,118,120,122,124,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,5330.5,5201.5,2016.5,5349.5,11.5,5372.5,1951.5,5201,4.5,1942,1266.5,4993.5,5351,5447.5,40.5,4.5,2266,8086.5,1.5,0.00079535175,5.5,2019.5,467,2204.5,4855.5,5280.5,5148.5,6334.5,4849,5674.5,67.5,446,-0.012919942,-0.005371147,2238,4221,5774,2886.5,-0.0049418057,2.5,7137,1500.5,8488,2323,843,478,1228.5,2304.5,3593.5,4573.5,4731.5,12511.5,4597.5,5594.5,0.01885472,0.0015996384,4138.5,6036.5,14.5,5770.5,29.5,4.5,3.5,549,2.5,0.015965072,4354,8886.5,5358.5,5094.5,3163,3091,-0.008181473,-0.00546563,7302.5,1949,0.0007122091,1575,0.0035271351,0.017128175,739.5,8431.5,41.5,948,0.013403065,8095.5,836,2799.5,2452.5,4963.5,3552.5,4642,-0.011411764,5716.5,4496,15.5,5641.5,-0.005297648,20.5,5306,5348.5,6594.5,3695.5,0.00769392,5797.5,17.5,6190.5,5664.5,4520.5,5775.5,57.5,45.5,35,-0.013790727,290.5,315,467,908,-0.002932838,2234,2434,4677.5,6673,4494,5308,5188.5,-0.0034701999,-0.009651518,-0.0035045538,0.0006443173,0.0049140207,3311.5,0.007319167,-0.00075083575,8329,1.5,0.0050384826,0.0030587697,4.5,9805,10282,8647.5,625.5,223,381.5,-0.0017774565,1205.5,8480.5,793,2947,1171,1683.5,0.0070054135,0.0027851376,4865.5,5440.5,15.5,0.019936554,4420,1943,3096.5,13408,503.5,19,-0.006269011,-0.016454875,7047.5,5069.5,6600.5,3945.5,0.01396322,0.005231941,-0.007957343,-0.02079771,0.014509574,8833,0.0015915864,-0.002270797,15.5,19.5,8541,0.0005565616,5322.5,6385.5,5489,0.0066624098,5757,6005,0.010113099,5954,-0.00050941756,0.0013003995,-0.0013571364,-0.015559884,-0.0018014511,-0.008316844,0.0017025622,-0.001725876,0.0050618597,0.0016730523,-0.0016078542,-0.009116888,-0.0009499383,0.0012226704,0.010967555,-0.0031320725,0.00088409346,0.0039215637,-0.0015412483,0.0010143294,0.0051299487,0.0018013323,-0.003047077,0.0006616961,0.0005534173,-0.0003149089,-0.0036994503,-0.00080629386,-0.0024922544,0.00034401924,-0.0014055462,-0.0058274535,-0.008005346,-0.0049554915,0.004420113,0.0003570201,-0.0019672795,0.002463122,0.00015402379,0.0018211162,-0.0021889354,5.607496e-05,0.00026240386,0.003821876,-0.0016109794,0.00052785093,-0.0065466673,-0.012132934,0.0013583197,0.006168661,-0.0032939797,-0.00046606778,-0.0052202344,-0.00044863182,0.010667526,0.0009220349,-0.012741205,-0.0060246116,0.00033169164,-0.0074372813,-0.00058930065,-0.0066588144,0.002781015,7.506055e-05,0.0009213819,8.067573e-06,-0.005842536,0.0019530262,-0.002988971,0.0005003392,-0.00045334987,0.009934117,-0.0047115306,-0.001364045,-0.00032685965,-0.009703309,0.0030853166,-0.0031969731,0.0051314835,-0.0035982335,-0.0064667957,-0.0002736644,0.0029868975,3.068525e-05,0.002254172,-0.0016493703,0.0047976826,-0.0011876994,-0.0103779165,-0.006177152,-0.0036253687,-0.0094352085,-0.0030018797,-0.0008873963,0.0033460055,-0.0032740594,-0.0035848063,0.00055969734,0.0034772647,-0.0011343024,0.0011812978,0.0075860694,-0.005252383,-0.00083116017,0.0015847905,-6.652183e-05}, {8,4,2,2,4,8,2,2,5,8,5,2,2,2,2,1,8,2,1,8,255,8,5,5,5,2,0,5,5,5,2,0,4,255,255,2,5,1,0,255,8,0,1,4,1,4,5,4,4,4,4,1,4,1,4,255,255,1,5,8,2,5,8,8,4,8,255,0,2,5,4,2,0,255,255,4,1,255,5,255,255,2,1,4,0,255,0,4,0,2,5,4,4,255,1,0,8,1,255,8,2,0,5,1,255,0,8,0,2,0,2,0,0,1,255,0,0,5,0,255,1,4,2,1,5,4,2,255,255,255,255,255,2,255,255,2,8,255,255,8,2,0,5,0,5,5,255,1,4,0,0,1,5,255,255,4,5,8,255,5,1,1,0,0,8,255,255,4,2,0,5,255,255,255,255,255,0,255,255,8,8,0,255,1,1,2,255,2,5,255,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,49,51,53,55,57,59,61,63,65535,65535,65,67,69,71,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,65535,103,105,107,109,111,113,115,117,119,65535,121,123,125,127,129,131,65535,65535,133,135,65535,137,65535,65535,139,141,143,145,65535,147,149,151,153,155,157,159,65535,161,163,165,167,65535,169,171,173,175,177,65535,179,181,183,185,187,189,191,193,195,65535,197,199,201,203,65535,205,207,209,211,213,215,217,65535,65535,65535,65535,65535,219,65535,65535,221,223,65535,65535,225,227,229,231,233,235,237,65535,239,241,243,245,247,249,65535,65535,251,253,255,65535,257,259,261,263,265,267,65535,65535,269,271,273,275,65535,65535,65535,65535,65535,277,65535,65535,279,281,283,65535,285,287,289,65535,291,293,65535,295,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,50,52,54,56,58,60,62,64,65535,65535,66,68,70,72,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,65535,104,106,108,110,112,114,116,118,120,65535,122,124,126,128,130,132,65535,65535,134,136,65535,138,65535,65535,140,142,144,146,65535,148,150,152,154,156,158,160,65535,162,164,166,168,65535,170,172,174,176,178,65535,180,182,184,186,188,190,192,194,196,65535,198,200,202,204,65535,206,208,210,212,214,216,218,65535,65535,65535,65535,65535,220,65535,65535,222,224,65535,65535,226,228,230,232,234,236,238,65535,240,242,244,246,248,250,65535,65535,252,254,256,65535,258,260,262,264,266,268,65535,65535,270,272,274,276,65535,65535,65535,65535,65535,278,65535,65535,280,282,284,65535,286,288,290,65535,292,294,65535,296,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1544.5,1497,1601,283.5,718,1710.5,1494.5,279,7285,-0.0077157984,5352,-0.0037946538,-0.0069465474,11231.5,1666,121.5,-0.013187595,321.5,566.5,1526,-0.002617944,3503.5,11485.5,5123,1686,490,217.5,262,642,31408.5,-0.0065976977,1336,0.008476286,1699.5,4609.5,-0.008625691,25650,1965,2348,3325.5,1685,1522.5,106.5,138,145,214,0.009227321,298.5,748.5,7227,0.00210697,0.0047094496,0.006563008,2955.5,2303,4232.5,6188,-0.0013171249,-0.0003169029,1663.5,-0.0027229795,1497.5,9136.5,0.0062545897,0.0029967956,7500,6964.5,1124.5,821.5,576,232.5,140.5,0.0061755385,183.5,273.5,0.0081082275,696.5,340.5,622,1191,850.5,1051.5,20235,550,2907,3997,1002.5,0.0015329019,0.0023317018,7296.5,7225,1619,2486.5,0.005501576,8587.5,1502.5,-0.00620841,1661.5,1636,6935.5,7021.5,8.2505394e-05,0.0024623377,-0.00275438,-0.00081725715,0.0017196451,-0.001907138,0.002927065,0.0017771015,-0.0038225383,4.993127e-05,-0.0039934563,-0.0014120997,0.0052502616,-0.00089926284,-0.0014535167,0.0026460295,0.0025143751,0.006770186,-0.0019102878,0.00069595565,0.001403964,0.00851768,-0.003943708,0.0006572255,-0.0014299239,0.00024454566,-0.003023966,-0.0044374214,-0.0031209087,0.00014202541,-0.010141867,-0.0055199913,-0.0057084244,-0.0010728076,-0.016943576,-0.008700165,-0.0019308956,0.0012601562,0.00148537,-0.00030195442,0.002778755,0.00077385333,0.004172481,0.00862827,0.00022568302,0.0022540996,0.0016797405,-0.0004176925,0.0006194184,0.006139746,0.00046250186,-0.0015866408,-0.00022041464,-0.007756275,0.004420843,1.6868491e-05}, {4,4,4,3,7,0,7,3,0,255,6,255,255,4,7,3,255,4,4,4,255,4,4,0,6,4,0,4,4,3,255,6,255,3,4,255,0,1,3,0,4,6,3,0,3,0,255,3,7,3,255,255,255,4,4,0,4,255,255,1,255,7,4,255,255,6,4,1,0,4,0,4,255,1,0,255,0,0,3,6,7,6,0,3,6,0,6,255,255,0,4,1,6,255,4,7,255,4,4,4,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,65535,65535,21,23,25,65535,27,29,31,65535,33,35,37,39,41,43,45,47,49,65535,51,65535,53,55,65535,57,59,61,63,65,67,69,71,73,75,65535,77,79,81,65535,65535,65535,83,85,87,89,65535,65535,91,65535,93,95,65535,65535,97,99,101,103,105,107,109,65535,111,113,65535,115,117,119,121,123,125,127,129,131,133,135,65535,65535,137,139,141,143,65535,145,147,65535,149,151,153,155,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,65535,65535,22,24,26,65535,28,30,32,65535,34,36,38,40,42,44,46,48,50,65535,52,65535,54,56,65535,58,60,62,64,66,68,70,72,74,76,65535,78,80,82,65535,65535,65535,84,86,88,90,65535,65535,92,65535,94,96,65535,65535,98,100,102,104,106,108,110,65535,112,114,65535,116,118,120,122,124,126,128,130,132,134,136,65535,65535,138,140,142,144,65535,146,148,65535,150,152,154,156,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8.5,27673,30208.5,18076.5,29705.5,26005.5,29838,12236,30440.5,31848,32312.5,24723.5,28571,29827.5,3160.5,11401,5921,25848,2.5,2.5,29100.5,4.5,29712.5,30334.5,28429,23699,30514.5,2980,31449.5,-0.0032678812,30121.5,4621,11584.5,3970,11444.5,18916,17312.5,18747,30550,0.0030425875,25949.5,3203,29709.5,31449.5,29776.5,1.5,29624.5,28839.5,31233,25872.5,25570,20143,26043.5,29703,28183.5,18.5,28279.5,0.005039393,29709.5,26571.5,18812,3219.5,6514,8007,12198,3203.5,11534.5,7.5,1.5,1.5,1.5,20715.5,29172,11239.5,21694.5,15803.5,31854.5,26640.5,29974.5,-0.0019918117,30943.5,29669.5,29745.5,30813.5,1.5,30752.5,29396,0.001062443,5.5,29862,30105.5,31437.5,31526.5,16007.5,23297,25225.5,19352.5,24750.5,29718,16.5,-0.0017805474,26003.5,26256,0.004026506,27084.5,16.5,16.5,3107.5,0.004763178,-0.0052330964,0.0011801817,29455.5,0.0019675891,-0.006786459,0.00043366724,18.5,30334.5,897.5,5698,2.5,11101.5,5908,-0.0046007535,4781,12341.5,1.5,3230.5,-0.0024548566,4.5,8911,8912,11450,12802,8653,17823.5,0.008882058,24357,28048.5,28054.5,1.5,28441.5,32080,17550,20009,23092.5,23996,32478,11410.5,18490,-0.00443144,-0.008151116,-0.012298431,-0.0075666048,3252.5,19346,29721.5,29630,29622,30133,29800,29770.5,-9.609147e-05,30277,6.5,0.00021567084,0.0029373115,6.5,4.5,0.0008384154,6.5,29584,5.5,29953.5,29745.5,23270,15.5,-0.0045131277,28484,29894.5,20728,15.5,2565.5,-0.0051307958,0.00884496,26388.5,15,5.605451e-05,0.00017249466,27623.5,3227.5,3027.5,-0.008719855,0.0063283327,26970.5,29596,26489.5,30305,29757.5,-0.0027810687,29745.5,-0.0011033312,0.0030476637,-0.00095276826,0.0009954053,0.00017854011,16106.5,0.0032891133,25898.5,15.5,-0.00037895757,0.00044855327,0.0004306356,-0.0013627008,-0.00046168055,0.0017336354,-3.2097283e-05,-0.008431469,0.0034957596,0.011771602,0.0013341504,-0.0018909805,0.0071680136,0.001404811,-0.0018367056,0.0019423029,-0.004494009,-0.0013332338,0.010358061,0.0020814992,-0.0013177845,-0.0047109327,-0.0013485892,0.0035646863,-0.000351881,0.010774228,0.0012209306,-0.0048443,0.0045019854,-0.002855531,-0.00080392876,0.0024089557,-0.010989667,-0.0016929287,0.00084720115,-0.0032565442,0.0025644943,0.008567736,0.0017695811,0.0063844933,0.0055163666,0.0009113787,0.0034954615,0.0005444634,-0.0010948082,0.00021051288,0.001220818,0.0027799818,-0.0007749485,0.00066497776,-0.0006833466,-0.0031181434,-0.0003676893,-0.0019494016,0.0028362402,-0.00010664687,-0.0005632969,6.716656e-05,0.00085678854,-0.0041597667,0.0023515436,6.6666886e-05,-0.001119586,0.0002626887,-0.0028150796,-0.0018480286,0.0010140054,0.00037692973,-0.0007316307,0.0005682265,0.0048639867,0.0070956647,0.0026891897,0.0018451093,0.0011444608,-0.00016840728,-0.0019568913,-0.0009780073,-0.0002717498,0.0007006937,0.0006253267,0.00048507666,0.000563554,0.0010378904,-0.0004936433,0.00019848043,-0.001020743,-0.00049836544,-0.00031820041,-4.5642948e-05,-9.617677e-05,0.004448925,-0.006273003,-0.0029822092,0.006356922,0.0004814704,-0.00394239,-0.0102407085,0.0033578947,-0.0016290527,-0.00031514248,-0.0011745384,-0.00021818723,0.0005299076,-0.00081518426,0.0026902638,0.003809828,0.001876252,0.000553538,0.0013238501,-0.00282934,-0.0015500559,-0.0018977983,0.0017426113,0.0007741148,0.004979946,-0.008439439,-0.0044191927,-0.013391717,-0.006642802,0.00045507392,-0.0015395292,0.0017989333,9.9609715e-05,-0.0018883024,-0.0008368809,-0.00063257816,-0.00022912852,0.0018935408,0.00048545655,0.000404343,6.896548e-05,0.00046622727,0.0009414914}, {8,7,7,2,2,7,5,2,2,7,5,5,6,2,2,2,7,6,8,8,4,8,2,2,2,2,5,4,2,255,5,5,2,7,7,7,7,5,4,255,2,6,4,2,2,8,4,2,4,4,5,2,5,4,7,8,2,255,5,6,6,5,5,5,2,5,6,8,8,8,8,5,4,7,5,5,2,6,7,255,5,4,4,5,8,7,5,255,8,2,4,6,4,7,5,4,2,5,2,8,255,2,2,255,5,8,8,2,255,255,255,5,255,255,255,8,4,7,6,8,2,5,255,5,6,8,7,255,8,7,7,5,5,7,6,255,5,4,2,8,6,6,5,5,5,4,6,5,7,255,255,255,255,6,2,6,2,2,6,6,6,255,5,8,255,255,8,8,255,8,4,8,6,6,2,8,255,4,6,7,8,6,255,255,6,8,255,255,5,4,2,255,255,5,7,5,5,2,255,2,255,255,255,255,255,6,255,2,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,65535,59,61,63,65,67,69,71,73,75,65535,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,65535,153,155,157,159,161,163,165,65535,167,169,171,173,175,177,179,181,183,185,187,189,65535,191,193,65535,195,197,199,201,65535,65535,65535,203,65535,65535,65535,205,207,209,211,213,215,217,65535,219,221,223,225,65535,227,229,231,233,235,237,239,65535,241,243,245,247,249,251,253,255,257,259,261,263,265,65535,65535,65535,65535,267,269,271,273,275,277,279,281,65535,283,285,65535,65535,287,289,65535,291,293,295,297,299,301,303,65535,305,307,309,311,313,65535,65535,315,317,65535,65535,319,321,323,65535,65535,325,327,329,331,333,65535,335,65535,65535,65535,65535,65535,337,65535,339,341,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,65535,60,62,64,66,68,70,72,74,76,65535,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,65535,154,156,158,160,162,164,166,65535,168,170,172,174,176,178,180,182,184,186,188,190,65535,192,194,65535,196,198,200,202,65535,65535,65535,204,65535,65535,65535,206,208,210,212,214,216,218,65535,220,222,224,226,65535,228,230,232,234,236,238,240,65535,242,244,246,248,250,252,254,256,258,260,262,264,266,65535,65535,65535,65535,268,270,272,274,276,278,280,282,65535,284,286,65535,65535,288,290,65535,292,294,296,298,300,302,304,65535,306,308,310,312,314,65535,65535,316,318,65535,65535,320,322,324,65535,65535,326,328,330,332,334,65535,336,65535,65535,65535,65535,65535,338,65535,340,342,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({38.5,18.5,26.5,133,608,25.5,2612.5,107.5,146.5,21.5,1523,18.5,64.5,868.5,2678,30,5.5,1124.5,3.5,123,23.5,0.023663873,20.5,12.5,497,106.5,388,793,876,7772,2883,22,48,0.013732365,11.5,2.5,13.5,0.007356738,2999.5,27,0.008130155,22,30,0.0038942625,-0.0033153498,892.5,6472.5,77.5,958.5,-0.012057173,-0.0035662383,42.5,12,668,18.5,-0.013111613,2.5,19.5,12073.5,2844.5,3049.5,34.5,30,14.5,29,0.0046232534,-0.00023300631,-0.014594284,7.5,29.5,-0.0020249605,12.5,10.5,25.5,-0.004030823,-0.0034289365,0.0008302927,-0.0023109831,-0.0114869755,6.5,6472.5,56,14.5,24,-0.004481209,-0.017606914,-0.00928337,-0.0038470805,194.5,-0.006697811,-0.010256458,2581.5,679.5,772.5,1010.5,8513.5,10782,4.5,0.01603726,18.5,0.00597172,11230.5,2867,3345.5,3146.5,28.5,59.5,28.5,8.5,12.5,17.5,-0.007919519,16.5,608,186.5,0.0042295093,7.5,0.0057110335,-0.0006444726,-0.0030285004,-0.00018946074,22,19.5,66.5,47.5,7.5,4.5,54,15.5,-0.00044388958,-0.0036290404,21,0.0044293054,0.0007367528,-0.0016777862,4.5,12.5,-0.008355893,20.5,10.5,958.5,0.028125564,856.5,1585,2104.5,19.5,4.5,0.009040996,2831.5,2650.5,-0.002898486,12.5,12.5,9.5,11.5,1506.5,4.5,3120.5,3467.5,0.00042119194,-0.0011146836,0.0060703927,-0.00029320232,-0.0032684046,0.00052929035,0.0046103457,-0.002026736,0.0016424669,-0.0016797383,0.0072919503,0.00026352267,0.0006164575,0.0057349945,0.0017041694,0.0043859566,-0.0040484504,-0.007313506,-0.0007267263,0.0016840034,-0.0013595364,0.0034271148,0.008145076,0.0018058444,0.00046990663,-0.004584234,-0.0032001815,0.00067279715,0.0006793453,0.0019857464,0.00435365,0.0026770728,-0.0026832342,0.0020954097,0.0022694652,0.010062008,-0.0028439087,0.00031021363,-0.0006143373,0.00035419568,0.011066392,0.0015598173,-0.0006631328,-0.0053989743,0.009958996,0.0045684227,-0.005060488,0.0016060325,0.007333123,0.0021610286,0.0007218881,-0.0040195454,0.015044458,0.0012354172,-4.7189995e-05,-0.0010670483,0.0032615692,-0.003171239,0.0016841894,0.0063900547,-0.00012410396,0.0022898267,0.000114666356,0.0031449706,0.0014743726,-0.0028296735,0.0027097513,0.005765703,-0.00025790292,0.0016792346,0.0028963233,-0.0004950197,0.0011129874,-0.0032644705,0.00061403017,0.0036090694,-0.000834269,4.058929e-05}, {4,8,1,1,1,1,5,2,2,8,1,8,2,1,5,4,8,1,8,1,5,255,8,8,2,4,2,1,1,2,5,4,1,255,8,8,8,255,2,5,255,2,1,255,255,4,4,2,2,255,255,3,8,1,8,255,8,8,2,5,5,2,1,8,5,255,255,255,8,2,255,8,8,1,255,255,255,255,255,8,4,5,8,3,255,255,255,255,5,255,255,4,1,3,2,4,4,8,255,8,255,2,5,1,5,1,2,5,8,8,8,255,8,1,1,255,8,255,255,255,255,2,8,4,5,8,8,2,8,255,255,1,255,255,255,8,8,255,8,8,4,255,3,2,5,8,8,255,3,3,255,8,8,8,8,3,8,5,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65535,65,67,69,65535,71,73,65535,75,77,65535,65535,79,81,83,85,65535,65535,87,89,91,93,65535,95,97,99,101,103,105,107,109,111,65535,65535,65535,113,115,65535,117,119,121,65535,65535,65535,65535,65535,123,125,127,129,131,65535,65535,65535,65535,133,65535,65535,135,137,139,141,143,145,147,65535,149,65535,151,153,155,157,159,161,163,165,167,169,65535,171,173,175,65535,177,65535,65535,65535,65535,179,181,183,185,187,189,191,193,65535,65535,195,65535,65535,65535,197,199,65535,201,203,205,65535,207,209,211,213,215,65535,217,219,65535,221,223,225,227,229,231,233,235,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,65535,66,68,70,65535,72,74,65535,76,78,65535,65535,80,82,84,86,65535,65535,88,90,92,94,65535,96,98,100,102,104,106,108,110,112,65535,65535,65535,114,116,65535,118,120,122,65535,65535,65535,65535,65535,124,126,128,130,132,65535,65535,65535,65535,134,65535,65535,136,138,140,142,144,146,148,65535,150,65535,152,154,156,158,160,162,164,166,168,170,65535,172,174,176,65535,178,65535,65535,65535,65535,180,182,184,186,188,190,192,194,65535,65535,196,65535,65535,65535,198,200,65535,202,204,206,65535,208,210,212,214,216,65535,218,220,65535,222,224,226,228,230,232,234,236,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({16173.5,27510,17279,16115,28759.5,30271.5,23723.5,27678.5,-0.011539995,28117.5,29065,18162,17049.5,20896.5,23273,15905,14239,28993.5,26308,0.0064211795,29823,15781,20644.5,16356,32436.5,20850,18843,23041,19335,26800.5,15367,16642,15296.5,27800.5,23391.5,0.00054509804,28241.5,-0.011269487,31233,11895.5,17364,19946,26684.5,8.5,27572,15.5,32398,20995,24138.5,0.01067,17917.5,24375,0.014449127,0.0050692074,26229.5,30065,27285,13698,23936,-0.00521549,13531,24487.5,25851.5,12.5,25518.5,-0.0061132493,-0.009065224,-0.016439423,15.5,31603.5,4.5,10856,0.004991315,15962,-0.008180741,16684,20205.5,28611,28260.5,-0.0017656662,-0.0028263011,12.5,32166,0.0018435046,0.0011966964,6.5,-0.0009924957,21829,0.012983987,20996.5,17.5,15.5,23335,-0.0015541282,29579,29763.5,26256.5,27482.5,30316,26978.5,27502,0.0024560785,-0.0007880434,21733,-0.00016777198,27117,24864,0.009298451,27208.5,0.0014613791,-0.0020872073,28153.5,27763,29336,25232,13830.5,-0.012018844,-0.0036878795,15803.5,2.5,7.5,-0.0001892246,-0.002528654,-0.004935102,-0.0027355442,0.0085098855,0.01693762,0.0048115463,6.5,17096.5,0.00887595,26911.5,-0.0019551998,25273,25273,16.5,-0.0021229337,0.0004208303,0.0007446744,20193,0.011738257,14711,19466.5,24399,0.0036628637,4.5,-0.006879218,20284,29997,29725,5.466094e-05,15.5,2.5,-0.00921389,29493.5,-5.316281e-05,0.0020054013,-0.011700186,-0.0010978389,0.003376253,-0.0001226997,0.013188493,0.0028131974,-0.009456339,-0.004903473,0.0028209535,0.00025512266,-0.0011100039,-0.0060440972,0.00058348046,0.006658394,-0.00022511778,-0.0017932513,-0.0029307446,-0.006151652,0.00087318337,-0.0053287703,0.0035513544,0.00075592066,-0.007632623,-0.004780574,-0.0014727974,-0.0009118952,0.0007774373,-0.0027941894,0.0017483527,-0.00020405727,0.0065614604,0.010582415,-0.00015650074,-0.0034805771,0.0055038035,0.012586347,-0.0005407336,-0.0009690257,-0.00071950577,-0.0003916118,-0.00051309017,-0.001190184,-0.002366347,0.0004806714,-0.008045976,-0.00040528184,-0.013264015,-0.0054199183,-0.0007930111,0.0010559148,-0.004726853,-0.0021675124,-0.015447249,-0.010316203,-0.0044277767,0.0017122458,0.006774017,0.00051146175,0.005622427,0.0010231853,0.00081900833,-0.00018334122,-0.00054148637,9.544582e-05}, {5,4,5,5,0,2,4,6,255,2,0,2,5,0,2,5,5,6,0,255,0,4,4,5,0,6,2,2,0,4,4,2,5,4,0,255,0,255,4,2,6,2,0,8,0,8,2,4,5,255,5,4,255,255,5,0,0,0,2,255,5,0,4,8,2,255,255,255,8,0,8,0,255,6,255,5,2,2,4,255,255,8,2,255,255,8,255,2,255,4,8,8,5,255,0,4,5,0,0,4,0,255,255,0,255,2,4,255,2,255,255,0,2,4,6,5,255,255,5,8,8,255,255,255,255,255,255,255,8,5,255,4,255,0,0,8,255,255,255,5,255,0,0,5,255,8,255,6,5,4,255,8,8,255,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,65535,69,71,73,75,77,79,81,83,85,87,89,65535,91,93,65535,65535,95,97,99,101,103,65535,105,107,109,111,113,65535,65535,65535,115,117,119,121,65535,123,65535,125,127,129,131,65535,65535,133,135,65535,65535,137,65535,139,65535,141,143,145,147,65535,149,151,153,155,157,159,161,65535,65535,163,65535,165,167,65535,169,65535,65535,171,173,175,177,179,65535,65535,181,183,185,65535,65535,65535,65535,65535,65535,65535,187,189,65535,191,65535,193,195,197,65535,65535,65535,199,65535,201,203,205,65535,207,65535,209,211,213,65535,215,217,65535,219,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,65535,70,72,74,76,78,80,82,84,86,88,90,65535,92,94,65535,65535,96,98,100,102,104,65535,106,108,110,112,114,65535,65535,65535,116,118,120,122,65535,124,65535,126,128,130,132,65535,65535,134,136,65535,65535,138,65535,140,65535,142,144,146,148,65535,150,152,154,156,158,160,162,65535,65535,164,65535,166,168,65535,170,65535,65535,172,174,176,178,180,65535,65535,182,184,186,65535,65535,65535,65535,65535,65535,65535,188,190,65535,192,65535,194,196,198,65535,65535,65535,200,65535,202,204,206,65535,208,65535,210,212,214,65535,216,218,65535,220,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6265.5,6138.5,6421,7016.5,7614,6416,6437.5,5921,5738,6894,5966,5370.5,0.009469247,6707,6439.5,5488,5995.5,5436.5,5887.5,6162.5,5733,6161,0.004740714,-0.006833389,7108,6504,-0.018586997,0.0075325766,6775.5,5036,7704,5236.5,7996,7735.5,5763,0.015920324,7465,6163,6391,-0.0061916234,-0.009824659,3.8504684e-05,0.0023397955,6377,8195,-0.0002765013,-0.002824077,6580.5,6793.5,4889,1756,5709.5,4956,4876.5,5386.5,6684.5,7668.5,0.0070471163,12065,5892.5,5910,6168,7759,0.00093581696,6618.5,11116,6236,6291.5,-0.0044639497,9408,6936.5,6546,10219.5,6781.5,6814.5,5015,10951.5,-0.014383539,5067.5,5668,5693.5,5769.5,5580.5,-0.006039155,5971,5504.5,5973.5,5793,10038.5,-0.01943169,-0.004176344,1138,17113,-0.024174504,-3.581862e-05,4302,4435,0.004960242,6467.5,0.020888349,9860.5,-0.009268126,-0.0062723667,6211,0.006571624,5887,-0.00025881056,0.015670853,6650.5,-0.018694062,11024.5,9870.5,10415,9328,6572,5703.5,6461,6962,5992,7300.5,7311.5,-0.00018564805,0.00397515,0.002189371,-0.0013994125,0.00034782424,-0.0026147675,0.0020328995,-0.008507502,0.00272316,0.009050838,0.007978766,0.0012361956,-0.0050123427,3.0690695e-05,0.0062135938,0.0016695563,-0.029282754,-0.017671397,-0.0012133977,-0.008520701,-0.00012910702,-0.00800714,0.0014191687,-0.002071814,0.00080515875,-0.00091927854,0.0030996937,0.0012414759,-0.00025946795,-0.018407721,-0.002223125,0.0010435695,-0.0009802845,0.003338225,0.009220498,0.002846786,0.0010779867,-0.0031776347,-0.003192512,-0.006392614,0.0031082707,0.007422493,-0.00035580757,-0.00079655385,-0.00010946738,0.0020003247,0.009768191,0.002281075,-0.0012709752,0.011081328,0.012047666,0.007467363,0.006668579,-0.005012374,0.007233556,-0.0010246905,0.0017911459,-0.0026851196,0.0049045137,0.011076764,0.0021885762,-0.00034779275,-0.0014833809,7.120292e-05}, {5,5,5,1,7,5,5,1,5,7,1,3,255,1,5,3,1,3,2,5,3,5,255,255,2,1,255,255,5,3,2,2,7,1,3,255,7,1,3,255,255,255,255,5,2,255,255,1,5,5,1,2,7,7,5,6,3,255,1,2,6,2,7,255,1,2,5,5,255,1,3,1,6,5,1,3,6,255,1,5,3,3,7,255,1,7,3,3,6,255,255,2,1,255,255,6,5,255,7,255,1,255,255,5,255,1,255,255,2,255,1,2,2,3,1,2,5,3,1,5,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,65535,65535,43,45,65535,65535,47,49,51,53,55,57,59,65535,61,63,65,65535,65535,65535,65535,67,69,65535,65535,71,73,75,77,79,81,83,85,87,89,65535,91,93,95,97,99,65535,101,103,105,107,65535,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,65535,135,137,139,141,143,65535,65535,145,147,65535,65535,149,151,65535,153,65535,155,65535,65535,157,65535,159,65535,65535,161,65535,163,165,167,169,171,173,175,177,179,181,183,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,65535,65535,44,46,65535,65535,48,50,52,54,56,58,60,65535,62,64,66,65535,65535,65535,65535,68,70,65535,65535,72,74,76,78,80,82,84,86,88,90,65535,92,94,96,98,100,65535,102,104,106,108,65535,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,65535,136,138,140,142,144,65535,65535,146,148,65535,65535,150,152,65535,154,65535,156,65535,65535,158,65535,160,65535,65535,162,65535,164,166,168,170,172,174,176,178,180,182,184,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({22,72,8036,14.5,18.5,7526.5,9080.5,62,22,15.5,5412.5,7708,6976,10028.5,9663.5,22,-0.0024984356,22,19,183.5,3201.5,34,0.0060145,7471.5,7899,6861.5,8084,9059,6945.5,9206.5,9672,4.5,5.5,16.5,0.0017749727,0.0026004163,0.00531121,4.5,72.5,34,0.0014548141,20.5,-0.009749572,5863,7163,5417.5,8606.5,7227,7600.5,7001,7480,7742.5,8666.5,5916.5,9854.5,9183,9255.5,9667.5,12827,1.5,12.5,-0.0048214593,8.5,-0.0014397016,-0.0034970492,0.008200975,42.5,4.5,7.5,52,0.010578091,0.004223942,-0.004101774,21.5,5446.5,7300.5,6694.5,0.017678635,17.5,7253.5,4580,6144.5,6248.5,-0.0027773066,-0.00959631,6199,7233,2.5,9264,1.5,6128,-0.022563541,-0.0026969926,5403.5,0.011769613,8434,11783.5,6938,8953,9421,9623.5,9.5,12.5,12268,14554.5,0.0023182572,3.5,10.5,7.348344e-05,-0.0003077895,-0.0001984993,-0.0007963624,22,-0.0028671592,11.5,2.5,13.5,0.008283622,0.0046048136,5854.5,1783.5,17.5,8802.5,3636.5,-0.017151609,-0.007933985,8370,4705,0.011453321,15.5,-0.009606658,17.5,6476.5,6056,6701,6.5,7355.5,4.5,-0.01074781,0.024156068,7582,8996,8097,-0.015274157,6.5,8475,7233.5,7924,8659,0.0017150401,0.0027280303,9207.5,9188,11.5,18.5,6350.5,7346.5,12.5,-0.008999529,5459.5,15.5,11313.5,13726.5,-0.0010511765,0.0005059221,-0.009512083,6177.5,10440.5,13419,7.5,12069,-6.653298e-05,-0.00056715653,0.0013808957,0.0030206253,0.0027496524,0.00088768575,0.00076588395,-0.0022051902,0.0024717448,0.00011232747,0.0022276167,0.0009804497,-2.062283e-05,0.010129943,0.0053670355,-0.00056178565,0.00080434047,0.005880677,-0.0032428894,0.0011516776,-0.0022267913,0.009432532,-0.024471555,-0.016272454,-0.0002612895,0.00555966,0.0014300256,0.006389922,0.00019910473,-0.0026427933,0.005598247,0.00042828318,0.0006183497,0.0060365833,-0.009242663,-0.0011695471,0.0012030223,0.0062695513,-0.010213944,0.0017288141,0.004918812,0.00032498638,0.00804954,0.0021322733,-0.009970174,-0.0007377336,-0.0037706874,0.002541413,-0.0025502294,-0.0005022825,-0.010059333,0.0019852552,-0.00040301887,0.004988281,-0.013238951,0.000846357,-0.009059337,-0.0011079811,0.0020383447,0.0031350858,-0.0032672938,0.00014687245,0.0011882698,0.00069985085,0.002686887,0.0037134804,-7.1548675e-05,0.0025262674,-0.007471212,-0.00036583233,-0.0013852388,3.903566e-05,0.0044870917,0.010917964,-0.0007471888,0.0012538381,0.0012108056,0.014070557,0.00012123449,0.0068084686,-0.0018490714,-0.007637698,-0.00058267865,0.00018836088,-0.0022847166,-0.010166278,-0.0015774405,0.002075622,-0.0007904525,2.0644677e-05}, {0,6,6,8,8,6,6,3,6,8,4,7,0,3,0,6,255,3,8,6,4,3,255,7,7,0,4,6,0,4,0,8,8,8,255,255,255,8,3,3,255,8,255,7,4,3,7,4,6,3,7,7,0,0,4,4,4,0,4,8,8,255,8,255,255,255,4,8,8,4,255,255,255,8,4,6,0,255,8,6,0,4,3,255,255,3,3,8,4,8,4,255,255,0,255,4,3,4,0,0,4,8,8,4,4,255,8,8,255,255,255,255,3,255,8,8,8,255,255,7,0,8,0,3,255,255,3,0,255,8,255,8,0,0,4,8,3,8,255,255,3,4,4,255,8,4,7,7,0,255,255,0,4,8,8,4,4,8,255,0,8,6,3,255,255,255,3,4,7,8,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,65535,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65535,65535,65535,65,67,69,65535,71,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,109,65535,65535,65535,111,113,115,117,65535,65535,65535,119,121,123,125,65535,127,129,131,133,135,65535,65535,137,139,141,143,145,147,65535,65535,149,65535,151,153,155,157,159,161,163,165,167,169,65535,171,173,65535,65535,65535,65535,175,65535,177,179,181,65535,65535,183,185,187,189,191,65535,65535,193,195,65535,197,65535,199,201,203,205,207,209,211,65535,65535,213,215,217,65535,219,221,223,225,227,65535,65535,229,231,233,235,237,239,241,65535,243,245,247,249,65535,65535,65535,251,253,255,257,259,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,65535,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,65535,65535,65535,66,68,70,65535,72,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,110,65535,65535,65535,112,114,116,118,65535,65535,65535,120,122,124,126,65535,128,130,132,134,136,65535,65535,138,140,142,144,146,148,65535,65535,150,65535,152,154,156,158,160,162,164,166,168,170,65535,172,174,65535,65535,65535,65535,176,65535,178,180,182,65535,65535,184,186,188,190,192,65535,65535,194,196,65535,198,65535,200,202,204,206,208,210,212,65535,65535,214,216,218,65535,220,222,224,226,228,65535,65535,230,232,234,236,238,240,242,65535,244,246,248,250,65535,65535,65535,252,254,256,258,260,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4.5,7774.5,5185,7350,10459.5,624,5834.5,1385.5,7855.5,9692,10233.5,576,726.5,5819.5,5927,70.5,1410.5,7611.5,9909.5,2542,10099,1.5,11603.5,614.5,20.5,15.5,17.5,5793,15.5,4149.5,5935,92.5,2420,0.016082877,5305.5,1936.5,8342,6360.5,0.007956467,2.5,2649.5,5463.5,8928.5,9908,10881.5,22154,11696,472,7.5,587,529,1277.5,706.5,6706,2008,17.5,6390.5,0.005501604,0.014584183,4891.5,7853,0.0110479975,6031.5,26.5,132.5,76,297,2.5,5610.5,-0.0032299038,7511,7651.5,0.0041809482,9853,12529,1637.5,2188.5,0.014195084,8943.5,9769,8727.5,1.5,10782.5,-0.010020063,12064,7856,11720.5,11386.5,2.5,0.011726725,32413,2798.5,497,-0.0015046338,621.5,0.011749818,1238.5,2578,0.03389771,1027.5,0.004536486,-0.0105302455,-0.02096205,1189,7247.5,1934,2304,2828,5441,6633,6186,2811,0.009515676,5466.5,6105,5993,6126.5,186.5,46,22,333,660.5,211,0.0054374686,-0.0028999026,3236,733,4061.5,7878,7289,7517.5,0.0076273107,0.015903505,0.0071114763,-0.00021230956,9190,0.0042397757,8316.5,8524.5,8546.5,2287.5,3492,9691.5,3.5,9887,7334.5,-0.0146598695,0.0009423021,8464.5,-0.0055322885,1.5,7118,7920.5,11418.5,9688.5,11320.5,11410.5,10647,11102.5,31782.5,29600.5,2.5,24605,116.5,1299.5,-0.012731765,15.5,0.0030799469,18,619.5,712.5,-0.0049631023,0.019373931,719,-0.0064684474,15.5,1329,7241.5,3556.5,558,0.019937921,584,2415,4183.5,8819,6528,5736.5,5565,16.5,0.0121602,7215,1645,14.5,5878.5,5008,0.000997779,-0.0036828674,5948,5976,6789.5,6135.5,-0.00088651705,-0.0071600215,0.00075770495,0.0046409946,0.006177767,0.011870162,0.0025454236,0.0059194257,-0.006330089,-0.0005365975,0.0006349786,-0.0019701214,-0.002062468,0.002435595,-0.0029902335,0.0040827114,-0.0040374044,0.000111752786,0.0017117638,-0.0007777916,0.0024300714,0.005786144,0.0010020811,0.0054438678,-0.0061300294,0.0011607818,-0.0018275367,-0.0086634895,-0.0052205026,0.0018385657,-0.0027729298,0.0061231065,-0.0049837637,0.00026618072,-0.0061783306,-0.00050069694,0.004233708,-0.0018606595,-0.0028019887,0.0010462429,0.0085665155,0.00234184,-0.006514153,0.0010866834,0.0027544904,0.0041600307,-0.0018607061,0.0014581236,0.0016871948,0.014864114,-0.0031648942,0.0012547546,-0.0034232035,0.0057451436,-0.0045720274,0.0011417096,0.0037073442,0.008820549,-0.0058804518,0.0027594273,-0.0006191898,-0.005108386,0.009716774,-0.0030625283,0.0034297612,0.00027913894,0.0009944153,-0.0025127255,0.0010945993,-9.0650676e-05,0.0008788006,-0.0004055324,-0.00042002584,0.00068870315,-0.003684479,-0.0064936266,0.0009758926,-0.0063031763,0.013526178,0.0063532065,-0.0033483978,0.005457113,0.0038580603,0.00029996486,0.00080115924,-0.0014524263,0.0016251801,-0.0053690993,-0.0049426802,-0.001380943,-0.00021824478,0.006739524,0.0003384502,-0.0005609669,0.010305857,0.0010303624,-0.001542265,-0.01221447,0.014115701,0.00025123954,-0.0046720984,-0.0015629604,0.002563902,-0.0011704469,-0.0019835054,0.006205146,0.0016800404,0.010556125,-0.017823264,-0.01012078,-0.00022571468,-0.00677427,-0.011975968,-0.00033167232,0.0023523995,0.0042697284,-0.003590804,0.0017488294,0.0002905387,-0.004546785,-0.0026612065,-0.014715451,-0.0062021865,-0.00017073697,-0.0023462754,-0.013614944,0.013572824,-0.0012720356,-0.008589681,-5.600769e-05}, {8,4,6,4,4,1,6,6,2,6,1,3,1,6,6,4,6,2,6,1,1,8,1,1,8,8,8,3,8,1,6,3,4,255,2,3,1,6,255,8,1,1,4,6,2,4,1,1,8,3,1,6,1,1,1,8,3,255,255,3,4,255,6,4,3,6,6,8,2,255,4,4,255,2,2,1,3,255,6,4,1,8,3,255,2,2,4,3,8,255,1,6,1,255,1,255,6,4,255,6,255,255,255,4,1,1,4,1,1,2,1,1,255,4,2,6,6,1,1,4,2,1,4,255,255,6,1,3,2,6,2,255,255,255,255,3,255,4,4,2,1,1,2,8,4,1,255,255,4,255,8,3,1,4,2,4,6,3,1,6,2,8,2,4,4,255,8,255,8,3,2,255,255,2,255,8,4,4,2,6,255,6,4,4,1,4,2,6,8,255,3,1,8,6,2,255,255,6,3,1,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,65535,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,65535,111,113,65535,115,117,119,121,123,125,127,65535,129,131,65535,133,135,137,139,65535,141,143,145,147,149,65535,151,153,155,157,159,65535,161,163,165,65535,167,65535,169,171,65535,173,65535,65535,65535,175,177,179,181,183,185,187,189,191,65535,193,195,197,199,201,203,205,207,209,211,65535,65535,213,215,217,219,221,223,65535,65535,65535,65535,225,65535,227,229,231,233,235,237,239,241,243,65535,65535,245,65535,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,65535,277,65535,279,281,283,65535,65535,285,65535,287,289,291,293,295,65535,297,299,301,303,305,307,309,311,65535,313,315,317,319,321,65535,65535,323,325,327,329,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,65535,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,65535,112,114,65535,116,118,120,122,124,126,128,65535,130,132,65535,134,136,138,140,65535,142,144,146,148,150,65535,152,154,156,158,160,65535,162,164,166,65535,168,65535,170,172,65535,174,65535,65535,65535,176,178,180,182,184,186,188,190,192,65535,194,196,198,200,202,204,206,208,210,212,65535,65535,214,216,218,220,222,224,65535,65535,65535,65535,226,65535,228,230,232,234,236,238,240,242,244,65535,65535,246,65535,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,65535,278,65535,280,282,284,65535,65535,286,65535,288,290,292,294,296,65535,298,300,302,304,306,308,310,312,65535,314,316,318,320,322,65535,65535,324,326,328,330,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({51.5,27,2653.5,32.5,30.5,25601.5,3092.5,22,7.5,29.5,18.5,2637,-0.009221195,6691.5,3104.5,62,23.5,2.5,10.5,52,186,28.5,5412.5,850.5,-0.004863943,17.5,3171.5,9668,821,22,14.5,27,29.5,-0.0017541727,3.5,-0.0016835548,16.5,18.5,15.5,56.5,17.5,11.5,40.5,426.5,0.007553904,826.5,873.5,2236,789.5,11.5,12.5,10.5,12.5,20.5,2462,18.5,0.0071341614,-0.005814089,0.0014147098,14.5,25,15,10.5,0.005319881,0.012176884,12.5,19.5,22,21.5,61,18.5,-0.010526527,-0.005796493,2649.5,0.000505201,6.5,0.00119972,-0.0050398684,15.5,39,749.5,252.5,853,389.5,2513,11.5,7571,0.015233655,3035,7756,2925,3080,7837.5,-0.009713748,-0.004836846,0.0007110053,16.5,415.5,1266.5,3207.5,1405.5,22,21.5,0.0051600058,0.0090056425,7,6.5,26.5,-0.0007251588,0.0020511642,0.00025726797,0.0058860406,14.5,0.008782113,0.0009826113,22,11.5,28.5,-0.00341719,7,-0.0038931437,0.0064743133,0.00407144,36.5,-0.0050546727,0.0033436082,0.007132611,3050.5,3954,-0.0047138105,107.5,-0.007829613,-0.014450624,12.5,20.5,835,0.009834989,7.5,-0.016740909,2410.5,2629,-0.002597657,-0.0052617667,2808,-0.005351311,2966.5,5408,7.5,8235.5,2670.5,13640.5,2878.5,6.5,7678,3946,-0.0029387476,0.0009230488,404.5,8602,-0.00073042506,-0.010778261,10.5,8541.5,935.5,2079.5,0.00019361459,-0.002261171,-0.0020247628,-0.0033059032,0.0026346932,0.0018959548,-0.0010028002,0.00048729847,-0.0013894144,-0.004769012,-0.0010296776,0.0010561459,0.0013538253,-0.001376864,-0.0013213343,-0.0036042947,0.0042813173,-7.607386e-05,0.0028867568,0.0013886088,-0.0009822081,-0.0035708148,0.0005473005,0.003066158,0.005138371,-0.0021326488,0.0064882063,-0.0020829525,-0.0006627753,0.00029808382,0.00023786137,0.008598833,0.003625334,0.00198547,0.00062963885,-0.0024619692,-0.0005727406,-0.006801358,0.0045340178,-0.00018546623,6.5027736e-05,0.0025018193,-0.0099105975,-4.331709e-05,0.01024806,0.0035968218,0.0070407963,0.002561527,-0.0036779523,0.0015759167,0.0030582761,-0.0017559903,0.003210088,-0.0018919194,-0.004235116,-0.006429425,0.00010278835,-0.003029646,0.0012699369,0.005017613,-0.003922764,-0.0007686012,0.0068101855,-6.2943254e-06,-0.003662676,-0.0008419743,-0.0020461867,-0.00902111,0.0028715932,0.00052515016,0.00015564423,-0.018821796,-0.0013880673,1.9104458e-05}, {0,7,3,0,3,0,3,0,8,0,8,3,255,0,3,3,3,8,8,4,7,4,4,0,255,8,1,0,4,3,8,0,0,255,8,255,8,8,8,7,8,8,3,4,255,0,0,1,7,8,8,8,8,8,4,8,255,255,255,8,1,8,8,255,255,8,8,3,8,4,8,255,255,7,255,8,255,255,8,4,3,1,4,3,4,8,4,255,7,4,3,7,0,255,255,255,8,4,0,3,1,7,8,255,255,8,8,0,255,255,255,255,8,255,255,0,8,4,255,8,255,255,255,0,255,255,255,3,7,255,4,255,255,8,8,0,255,8,255,4,4,255,255,3,255,3,4,8,4,3,0,3,8,0,1,255,255,1,7,255,255,8,3,0,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,65535,63,65535,65,67,69,71,73,75,77,79,65535,81,83,85,87,89,91,93,95,97,99,101,65535,65535,65535,103,105,107,109,65535,65535,111,113,115,117,119,121,65535,65535,123,65535,125,65535,65535,127,129,131,133,135,137,139,141,143,65535,145,147,149,151,153,65535,65535,65535,155,157,159,161,163,165,167,65535,65535,169,171,173,65535,65535,65535,65535,175,65535,65535,177,179,181,65535,183,65535,65535,65535,185,65535,65535,65535,187,189,65535,191,65535,65535,193,195,197,65535,199,65535,201,203,65535,65535,205,65535,207,209,211,213,215,217,219,221,223,225,65535,65535,227,229,65535,65535,231,233,235,237,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,65535,64,65535,66,68,70,72,74,76,78,80,65535,82,84,86,88,90,92,94,96,98,100,102,65535,65535,65535,104,106,108,110,65535,65535,112,114,116,118,120,122,65535,65535,124,65535,126,65535,65535,128,130,132,134,136,138,140,142,144,65535,146,148,150,152,154,65535,65535,65535,156,158,160,162,164,166,168,65535,65535,170,172,174,65535,65535,65535,65535,176,65535,65535,178,180,182,65535,184,65535,65535,65535,186,65535,65535,65535,188,190,65535,192,65535,65535,194,196,198,65535,200,65535,202,204,65535,65535,206,65535,208,210,212,214,216,218,220,222,224,226,65535,65535,228,230,65535,65535,232,234,236,238,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8264.5,12619.5,8283.5,9359.5,13116.5,8425,11312,8620.5,1.5,13.5,16.5,6.5,-0.01572851,7014.5,11407.5,6841,6199.5,7263.5,8176,-0.0059699053,-0.011553719,16549,15563,0.005885244,8266,6986,11010.5,11384.5,11016,7213,9714,4411,8938.5,-0.009708728,0.0024534706,7552,15.5,11.5,0.003013488,-0.0031294425,-0.005339603,14.5,0.0012355011,9336.5,7012.5,9495.5,14373,8.5,11566,13328.5,14517,7153,7704,8084,7135.5,1464.5,6813.5,8346.5,7378,6692,-0.014515934,8063.5,4614,15043.5,-0.0002516596,-0.0013423038,-0.0042076604,8289.5,5810.5,11.5,0.0028608304,10580.5,10277,2.5,22926,10721.5,12496,4.5,0.010635632,10602.5,10244,1.5,14849.5,17.5,6450.5,6018,8798.5,7029.5,7705,8690,10273.5,11.5,2.5,15.5,9,7017,9.5,-0.010284719,9018,14.5,6.5,9709,8774,10491.5,6341.5,-0.004179313,-0.0025993506,0.010838565,6805.5,5670.5,7379.5,0.013705089,0.0075489865,9210.5,9412,9608,3.5,7145,8125,10677.5,15925,9212,14212.5,11168,15.5,-0.0011055813,11389,16.5,9566,0.006175422,0.002726658,8365,6468.5,14242,15014,-7.903223e-05,0.0004186076,0.00023290345,0.007663317,-0.0013934447,-0.01024489,0.0020115315,-0.010987236,0.00047559827,0.0021301245,-0.00042869625,-0.011897303,0.017439654,0.0050894446,0.005670214,-0.0027864627,-0.0014237155,-0.007255015,-0.00792067,0.00070142787,0.0044567506,0.012214135,0.0056938455,-0.0028065273,-0.016693858,-0.025786936,-0.010989583,-0.006993635,0.0035637156,-0.0018039899,0.0010669427,-0.0041666334,0.0070315204,0.0029181843,0.0035216238,-0.00020621899,0.008025706,0.0024143707,0.009064708,0.005377754,0.00059803476,0.00502085,-0.00029890033,0.0011169709,0.00085132784,-0.0017514288,0.014099403,0.0018368106,-0.00051482226,-0.009945643,0.00023177627,-0.008352469,-0.014179135,-0.0018251603,-0.0026473058,-0.012904102,0.0077368864,-0.004129756,6.540963e-05,0.0023518163,-0.00074391183,-0.003803333,-0.0065538245,0.00072254543,0.0018886112,0.0009830941,-0.00486204,-0.0014962143,0.00076356076,-0.0027555004,0.0032918893,0.0060194684,0.007763844,0.0029604295,-0.00017732638,0.001604169,0.011389437,0.002360476,0.00018217921,0.012229594,-9.689177e-05,-0.0026600924,0.009100131,-0.0010548894,-0.0092815,1.7978517e-06}, {2,6,2,6,6,3,3,6,8,8,8,8,255,1,3,6,3,3,4,255,255,4,6,255,2,1,2,3,2,2,1,3,6,255,255,4,8,8,255,255,255,8,255,3,1,2,4,8,1,1,6,2,3,4,2,3,1,1,3,2,255,1,3,6,255,255,255,2,1,8,255,1,1,8,4,4,2,8,255,2,2,8,6,8,6,1,4,3,1,4,1,8,8,8,8,2,8,255,6,8,8,6,1,6,1,255,255,255,1,4,4,255,255,1,2,2,8,1,3,3,2,6,2,6,8,255,3,8,6,255,255,1,1,3,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,65535,65535,37,39,65535,41,43,45,47,49,51,53,55,57,65535,65535,59,61,63,65535,65535,65535,65,65535,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,65535,65535,65535,107,109,111,65535,113,115,117,119,121,123,125,65535,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,163,165,167,169,171,173,175,65535,65535,65535,177,179,181,65535,65535,183,185,187,189,191,193,195,197,199,201,203,205,65535,207,209,211,65535,65535,213,215,217,219,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,65535,65535,38,40,65535,42,44,46,48,50,52,54,56,58,65535,65535,60,62,64,65535,65535,65535,66,65535,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,65535,65535,65535,108,110,112,65535,114,116,118,120,122,124,126,65535,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,164,166,168,170,172,174,176,65535,65535,65535,178,180,182,65535,65535,184,186,188,190,192,194,196,198,200,202,204,206,65535,208,210,212,65535,65535,214,216,218,220,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({15036.5,28114,18831.5,28051.5,13037.5,15280,20045.5,28020,0.007258199,27374.5,14169.5,17123.5,15177,18855,20643.5,29233,24161.5,26944,31233,28241.5,29906.5,15233,14292.5,0.011630629,1.5,20217,20376.5,20383,20790.5,28189,29700,29082.5,28453.5,12.5,0.005873482,13,12.5,-0.015325791,20488.5,28496,8.5,3008,0.006027033,0.009702814,15830.5,17123.5,19981,20892.5,3.5,18031,-0.00263273,15841,22785.5,-0.012044898,24260,15532,21717.5,8.5,26812.5,10210,16.5,29028,2.5,0.0035132517,0.0011692288,-0.0014064766,-0.0073516755,4.5,12102.5,0.00015911003,12.5,14497.5,-0.009640198,0.0023443436,16,2.5,1.5,-0.0028567223,19189.5,0.01101977,0.0023196824,5.5,27220,19370.5,0.01259639,0.0069526928,16638,-0.0064354287,-0.012105885,17.5,19286.5,21228.5,16.5,20832.5,23374.5,14274.5,18063.5,0.0054639387,15.5,-0.0050521484,-0.008054125,-0.0022567445,9.9417775e-05,0.004326145,0.008522878,22978.5,-0.00068902166,28318,0.009328156,0.0004865219,12892,2.5,32158.5,31486,12737.5,28567,28567,0.0019320343,14815,10.5,0.0011958608,-0.006556131,2528.5,0.00730624,15650,0.0065104538,0.0031715934,19280,19305.5,-0.0011892931,17224,19665.5,7.5,0.014480676,0.010973855,16,20.5,19354.5,19527,19294.5,21312.5,21108,21568.5,21555.5,22148.5,23971.5,29652,-2.9157367e-05,0.0013319576,-0.0017987093,-1.5231567e-05,0.0024798696,0.00013579939,0.0057754265,0.0014928164,-0.0012324743,0.00062690483,-0.0024752459,-0.0010093693,0.00016661422,-0.0020797865,0.0017236414,0.00054553815,0.00037242626,-0.0010628626,0.0010125601,-0.0019011004,-0.0067222565,-0.004267338,-0.010679826,-0.007661061,-0.0036175938,-0.0015892789,0.0011108493,0.0018095523,-0.0031790894,-3.7822243e-05,-0.0020155099,0.0009430162,-0.009552207,-0.0034510083,-0.0043864707,-0.00032328255,0.00069447997,0.0025210553,0.009658587,0.006578043,0.0014969073,0.0047530155,0.001239139,0.0060161524,-0.00060019875,-0.00033548108,0.006787096,0.011655065,0.0044439193,0.008338281,-0.0073591718,-0.012098151,-0.004554432,0.0009507467,0.0010317,0.0041851657,-0.00028419634,-0.0018563111,0.00875546,-0.00025040444,-0.007703759,-0.0014788068,-0.008667787,0.0047667464,0.00038917552,-4.39363e-05}, {1,0,0,0,1,0,0,2,255,2,1,6,1,1,2,4,0,4,4,0,6,0,0,255,8,2,1,1,2,4,4,2,6,8,255,8,8,255,4,6,8,2,255,255,1,0,1,4,8,2,255,4,0,255,0,6,6,8,6,1,8,4,8,255,255,255,255,8,1,255,8,1,255,255,8,8,8,255,6,255,255,8,1,4,255,255,1,255,255,8,1,1,8,4,2,4,2,255,8,255,255,255,255,255,255,0,255,2,255,255,1,8,0,0,1,4,4,255,1,8,255,255,6,255,1,255,255,4,4,255,2,0,8,255,255,8,8,6,2,4,4,6,4,1,6,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,43,65535,45,47,49,51,53,55,57,59,61,63,65535,65,67,65535,69,71,73,75,65535,65535,77,79,81,83,85,87,65535,89,91,65535,93,95,97,99,101,103,105,107,109,65535,65535,65535,65535,111,113,65535,115,117,65535,65535,119,121,123,65535,125,65535,65535,127,129,131,65535,65535,133,65535,65535,135,137,139,141,143,145,147,149,65535,151,65535,65535,65535,65535,65535,65535,153,65535,155,65535,65535,157,159,161,163,165,167,169,65535,171,173,65535,65535,175,65535,177,65535,65535,179,181,65535,183,185,187,65535,65535,189,191,193,195,197,199,201,203,205,207,209,211,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,44,65535,46,48,50,52,54,56,58,60,62,64,65535,66,68,65535,70,72,74,76,65535,65535,78,80,82,84,86,88,65535,90,92,65535,94,96,98,100,102,104,106,108,110,65535,65535,65535,65535,112,114,65535,116,118,65535,65535,120,122,124,65535,126,65535,65535,128,130,132,65535,65535,134,65535,65535,136,138,140,142,144,146,148,150,65535,152,65535,65535,65535,65535,65535,65535,154,65535,156,65535,65535,158,160,162,164,166,168,170,65535,172,174,65535,65535,176,65535,178,65535,65535,180,182,65535,184,186,188,65535,65535,190,192,194,196,198,200,202,204,206,208,210,212,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({59.5,135.5,372,120,583.5,368.5,199.5,123,125.5,161,181,169.5,0.010926971,187,797,55.5,42.5,0.0030912042,0.00830165,145.5,-0.015358037,13006,772,165,313.5,-0.003956165,288,706.5,1808,40.5,31,84,61,-0.00991856,0.0014500106,-0.0036574155,-0.0005682542,-0.0018548729,1201.5,343,-0.0056295707,315.5,0.004220555,197,143.5,595.5,1071.5,3307.5,2459.5,28.5,43,-0.006838436,-0.0020537786,-0.009058099,-0.005701599,82.5,0.0031178747,0.0013847534,125.5,313,168.5,883.5,644,-0.0007266361,0.00032383323,-0.0011448938,312,232.5,743,914.5,939.5,1687.5,6042.5,1004.5,755.5,72,48.5,40.5,45.5,46.5,-0.00596775,1668,1951.5,150.5,173,0.0024188969,0.0037426618,251,1669.5,354.5,285,-0.002484078,-0.0035678258,494.5,283.5,650.5,650,1041.5,1285,1443.5,-0.0025688892,1724.5,4208,5683.5,847.5,2107,2420,0.008229774,2466.5,-0.0007673571,0.0014765579,0.00097316067,-0.0011454788,0.005477716,0.0030557045,-0.0021956868,0.00300376,-0.0030137082,-0.0010107143,0.00137987,0.0006375529,-0.0010042837,-0.00035910588,0.00014569364,0.0020966788,-0.0047253706,-0.0019325897,0.0019108087,0.00012203156,0.004928903,0.003414973,-0.004568241,-0.001279129,0.003073199,-9.602625e-05,0.0044529787,-7.2264695e-05,-0.004174497,-0.0006098732,-0.0038236347,0.00028073846,0.003989813,0.001912586,-0.007123185,-0.0020025414,-0.00970991,-0.0067296117,-0.00013160317,0.0006218762,0.0017834051,-0.00086661754,0.0042500016,0.00028183422,-0.00034915068,0.003704824,-0.0008987514,-0.00959142,-0.00947212,-0.006335252,-0.0005897032,-0.0047979127,0.0040045553,5.799321e-06}, {2,0,2,0,0,2,3,6,0,0,6,3,255,6,7,2,7,255,255,0,255,0,0,3,3,255,0,7,2,3,7,0,0,255,255,255,255,255,0,2,255,2,255,0,5,7,5,5,2,0,2,255,255,255,255,5,255,255,5,2,0,0,0,255,255,255,0,5,2,5,6,5,6,3,3,6,0,2,0,5,255,0,0,3,0,255,255,3,0,2,3,255,255,2,3,0,7,2,3,2,255,6,6,7,2,2,2,255,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,65535,65535,33,65535,35,37,39,41,65535,43,45,47,49,51,53,55,65535,65535,65535,65535,65535,57,59,65535,61,65535,63,65,67,69,71,73,75,77,65535,65535,65535,65535,79,65535,65535,81,83,85,87,89,65535,65535,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,65535,119,121,123,125,65535,65535,127,129,131,133,65535,65535,135,137,139,141,143,145,147,65535,149,151,153,155,157,159,65535,161,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,65535,65535,34,65535,36,38,40,42,65535,44,46,48,50,52,54,56,65535,65535,65535,65535,65535,58,60,65535,62,65535,64,66,68,70,72,74,76,78,65535,65535,65535,65535,80,65535,65535,82,84,86,88,90,65535,65535,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,65535,120,122,124,126,65535,65535,128,130,132,134,65535,65535,136,138,140,142,144,146,148,65535,150,152,154,156,158,160,65535,162,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1158,1132.5,1273.5,745,1141.5,19.5,1233.5,737.5,980,15.5,15.5,1170.5,1176.5,1179,1308,25601.5,15.5,12.5,18.5,6.5,-0.013820851,660,-0.006586344,16.5,1522.5,0.0154696,-0.004541245,1501,18.5,16.5,1787,614.5,-0.0071789287,6.5,0.02818258,933.5,1150.5,1225.5,516.5,-0.008321636,-0.0043892567,-0.0021678703,0.005714103,967,0.009733588,1232,2.5,-0.006807366,2003.5,12.5,0.021330897,1515.5,-0.012273111,1777.5,4696.5,600.5,747.5,-0.0047004162,-0.002787651,1226.5,5.5,19.5,926.5,3.5,1283.5,5166,593.5,12.5,10.5,0.01248403,12.5,0.009979927,5.5,19.5,2763.5,6.5,-0.0031115601,5.5,-0.006849851,1886,15.5,4966.5,4719.5,2832.5,-0.010210443,444,398.5,808,964.5,0.007401362,0.003129939,-0.0026805836,-0.022601133,14.5,-0.0085244225,842,6.5,0.0052623632,2931.5,1336.5,-0.0011698173,0.019294519,1119.5,2060.5,-0.0029303068,1251,0.0019211624,0.0025275813,0.009647746,1188,16.5,14.5,0.009709034,15.5,2.5,-0.0005077459,0.004336829,-0.0044704555,5021.5,15.5,2845.5,0.0068143117,0.011359832,15.5,7973.5,16.5,4974.5,-0.00025900465,0.0023342576,0.008780607,0.00308803,0.0017862115,-0.006792246,0.003019734,-0.003973194,-0.016134351,-0.0057562753,-0.0008323357,0.011993944,-0.0007064921,-0.011509922,0.0033717162,-0.0014264239,-0.00017237493,0.0012780082,-0.005262694,-0.01299647,0.011207439,-0.003756816,-0.011054589,-0.0032617317,0.00047563674,-0.004473127,-0.008002703,-0.0019028037,0.002297512,-0.0021962747,0.0024932667,-0.003262824,-0.0016367602,-0.008948402,0.0032476305,0.00012263407,0.0031406581,-0.0011751314,0.00050051574,-0.0034279225,0.0052851755,0.0010291118,-0.0014855317,0.00032005325,0.0015761879,-0.00015993357,-0.0005532081,0.019480044,0.0014324448,1.0006881e-05}, {3,3,3,5,3,8,0,5,5,8,8,7,5,0,0,0,8,8,8,8,255,0,255,8,4,255,255,3,8,8,0,3,255,8,255,3,0,5,0,255,255,255,255,5,255,3,8,255,3,8,255,4,255,0,4,3,3,255,255,4,8,8,5,8,4,4,0,8,8,255,8,255,8,8,3,8,255,8,255,4,8,7,4,0,255,0,7,7,7,255,255,255,255,8,255,3,8,255,7,4,255,255,5,0,255,3,255,255,255,3,8,8,255,8,8,255,255,255,3,8,7,255,255,8,7,8,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,65535,43,45,65535,65535,47,49,51,53,55,65535,57,65535,59,61,63,65,65535,65535,65535,65535,67,65535,69,71,65535,73,75,65535,77,65535,79,81,83,85,65535,65535,87,89,91,93,95,97,99,101,103,105,65535,107,65535,109,111,113,115,65535,117,65535,119,121,123,125,127,65535,129,131,133,135,65535,65535,65535,65535,137,65535,139,141,65535,143,145,65535,65535,147,149,65535,151,65535,65535,65535,153,155,157,65535,159,161,65535,65535,65535,163,165,167,65535,65535,169,171,173,175,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,65535,44,46,65535,65535,48,50,52,54,56,65535,58,65535,60,62,64,66,65535,65535,65535,65535,68,65535,70,72,65535,74,76,65535,78,65535,80,82,84,86,65535,65535,88,90,92,94,96,98,100,102,104,106,65535,108,65535,110,112,114,116,65535,118,65535,120,122,124,126,128,65535,130,132,134,136,65535,65535,65535,65535,138,65535,140,142,65535,144,146,65535,65535,148,150,65535,152,65535,65535,65535,154,156,158,65535,160,162,65535,65535,65535,164,166,168,65535,65535,170,172,174,176,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8085.5,7857.5,8198,7840,8481.5,5337.5,18.5,1.5,3461.5,7878.5,9210,1980,8163,8482.5,8535,4997.5,14.5,4.5,7.5,15.5,6994,7749,12.5,-0.0071118036,8087,-0.021281049,7572,12.5,8502,5795.5,15345,4786,24762.5,7.5,63.5,-0.006328728,13.5,-0.0042908927,-0.011191281,5815,0.011199247,5528.5,7073,5.5,-0.018102035,8356.5,5361,12.5,6.5,-0.009327356,0.00042094276,8492.5,5955.5,5379.5,8450,4610,4053,13208.5,22732,7099,-0.006629883,6990,-0.0060948636,6313,1200,2966,5421.5,0.0014519009,-0.0001569243,8.5,8,8058,9129,10.5,3651.5,-0.009441229,13.5,7916.5,0.0013890365,0.00579711,8541.5,8.5,1019,-0.00503387,17.5,2143.5,8569,4174,8918,0.003924691,0.00715081,7938,8677.5,4496.5,9859.5,13455.5,7934.5,12754.5,15496.5,11041.5,27747.5,112,2481.5,6078.5,7073.5,5393.5,7138.5,466.5,1175,25.5,-0.013671276,6043.5,121,0.0071733217,0.003519694,0.0026396448,0.004545557,4927,10.5,7472,12.5,0.016458053,0.0055803754,2141.5,15.5,0.0005265112,-0.00021219908,-0.0023930229,7,-0.0034547527,18.5,2.5,1627,-0.0013474447,5862,8133,-0.002939873,5.5,8288,0.0062960065,8918,8222,0.006778963,8337.5,8428,6322,9257.5,6826,8695,2109.5,4519,5197.5,4397,2396,0.000116371426,11736.5,10105,9968.5,13812,10610.5,5964.5,21914.5,20653,31068.5,18288,-0.00043204913,0.001278215,-0.0069367923,0.0010625956,0.0015024113,0.0054763746,-0.015660241,0.0058643245,0.00014242753,0.0025308146,-0.0027571584,0.00044719313,-0.00033699974,0.001716963,-0.00421692,-0.00029200953,0.0004255035,-0.0016680968,0.00064583,0.004000719,-0.0066133747,-1.5972757e-05,-0.0008388894,0.0019054519,0.0042238245,0.007113828,-0.0016464181,-0.007998116,0.0031096786,-0.0021376216,0.0007511874,-0.00124326,0.0022584815,0.006952345,-0.00721622,-0.0039496133,0.00238113,0.004664629,0.0022663914,0.0006229925,0.0019449424,-0.004555893,0.0058295447,0.0018948423,0.0011675899,-0.00026349627,-0.0027029866,0.0018801152,-0.003744859,-0.011287187,-0.002257621,0.0013397033,0.0052052718,0.0015810522,0.00011106986,-0.004497415,0.00021176417,0.0031630301,-0.00011600667,0.0005599308,0.0058426983,-0.0016999763,-0.0015232378,-0.008392334,0.008293438,-7.642314e-06,-0.004017255,-7.5319644e-05,-0.012979311,-0.001058017,0.006730014,0.0024124484,-0.008799886,0.0002271994,-0.0041657314,-0.009515732,-0.0015497992,0.0004974442,-0.0075978623,0.00023698283,0.001730183,-0.0005971379,0.0056343977,0.0024233311,0.0006501001,-0.0036694668,0.0013668091,0.0058636456,-0.0039697494,-0.00010402273,0.0011191767,-0.001003282,-0.002498945,-0.00033405394,0.0066076266,0.0003223304}, {0,0,0,0,6,7,8,8,5,0,6,1,1,0,5,1,8,8,8,8,6,1,8,255,6,255,6,8,0,1,0,1,1,8,6,255,8,255,255,6,255,7,6,8,255,1,5,8,8,255,255,1,1,7,1,1,5,5,7,0,255,0,255,1,0,1,7,255,255,8,8,0,1,8,5,255,8,0,255,255,5,8,6,255,8,7,1,7,1,255,255,1,1,7,6,1,5,6,1,1,6,5,1,7,1,1,5,5,1,5,255,1,0,255,255,255,255,5,8,1,8,255,255,1,8,255,255,255,8,255,8,8,7,255,6,0,255,8,1,255,1,0,255,0,0,7,5,7,1,7,7,7,7,5,255,6,1,0,6,6,7,0,0,5,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,65535,49,51,53,55,57,59,61,63,65,65535,67,65535,65535,69,65535,71,73,75,65535,77,79,81,83,65535,65535,85,87,89,91,93,95,97,99,101,65535,103,65535,105,107,109,111,65535,65535,113,115,117,119,121,123,65535,125,127,65535,65535,129,131,133,65535,135,137,139,141,143,65535,65535,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,65535,183,185,65535,65535,65535,65535,187,189,191,193,65535,65535,195,197,65535,65535,65535,199,65535,201,203,205,65535,207,209,65535,211,213,65535,215,217,65535,219,221,223,225,227,229,231,233,235,237,239,65535,241,243,245,247,249,251,253,255,257,259,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,65535,50,52,54,56,58,60,62,64,66,65535,68,65535,65535,70,65535,72,74,76,65535,78,80,82,84,65535,65535,86,88,90,92,94,96,98,100,102,65535,104,65535,106,108,110,112,65535,65535,114,116,118,120,122,124,65535,126,128,65535,65535,130,132,134,65535,136,138,140,142,144,65535,65535,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,65535,184,186,65535,65535,65535,65535,188,190,192,194,65535,65535,196,198,65535,65535,65535,200,65535,202,204,206,65535,208,210,65535,212,214,65535,216,218,65535,220,222,224,226,228,230,232,234,236,238,240,65535,242,244,246,248,250,252,254,256,258,260,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({18.5,7912,4932,7890.5,7951,5159.5,5836.5,4809.5,6095,7470,9624,559.5,3517,6242.5,6008.5,3996,15.5,0.013190443,12.5,-0.012937306,12.5,9966.5,8307.5,374.5,25.5,2766.5,5961,4708,7365,7119,6342.5,7.5,5473,6348.5,5682,5845.5,0.0027702001,-0.0027215027,-0.004503795,8777.5,7799.5,11137,8356.5,309,2919,0.01843654,2880.5,18117,26849,0.01793859,0.008573954,7086,6170,4204,5789.5,6403.5,5872,5075.5,6288.5,2007,561.5,4046.5,5610.5,5921,6586,5142.5,6813.5,0.0008171233,0.0021589794,6166.5,9728,0.0069011333,11034.5,9.5,13.5,16518,29556.5,26,0.0077453144,1165,6068,3252,5463.5,0.00023985929,0.0066264006,-0.0052325297,31913,1460.5,3185.5,4971,5639.5,6063,5870,5185,7511.5,5942.5,0.014861971,0.003305499,-0.003650965,6144.5,8933,5042.5,2745,2322,2368.5,559.5,1806,-0.014937827,1515.5,15.5,0.014155069,5866,5995.5,6635,6638,3908.5,5199,5758.5,10281,8460.5,7677.5,7488.5,10187.5,9327.5,11799,0.015498248,0.007231716,6.5,16034.5,-0.0021088652,-0.006046939,27166.5,29384,37.5,213,4576,-0.019925172,0.0038032848,352.5,1235,1618,5151.5,8653.5,0.00308812,-0.0024148652,-0.008052581,3660.5,2671.5,7919.5,5543.5,5648.5,-0.0065884315,5950,0.021661384,0.012307069,5537.5,5608.5,-0.007994349,-0.005196885,5437,7959,-0.002718677,0.010380525,0.008563686,0.0002139444,6220.5,0.0009027134,-0.0043189316,6850,6994.5,5197.5,-0.00011353074,0.0084396275,0.0055209375,0.0010401626,0.00030125893,0.011825964,-0.0013815786,8.114485e-05,-0.009016945,-0.0018579712,-7.591757e-05,0.0040976764,6.880084e-05,0.0041558924,-0.007143929,-0.00062110246,-0.0040705684,0.003276697,-0.0047178585,0.00044947225,-0.0004607717,0.009323803,-0.0068852007,0.0014698245,-0.0087152785,-0.0026613749,0.0012545866,-0.00119361,0.00067789055,-0.006016278,-0.0065375133,-0.0013495925,0.0025814984,-0.0005067705,-0.0010493917,0.00016905107,-0.0055220653,-0.015818259,-0.0005716616,-0.0020671817,0.0062170825,0.0031106353,-0.0051455083,-0.0006605807,4.151351e-05,0.00077300327,0.0014214392,-8.113146e-05,0.00018605324,0.0093609085,-0.0009494121,0.0016863596,-0.0038220999,-0.008389257,-0.0012270964,0.0009714222,-0.00075355807,0.003801512,0.0049638553,0.014381746,-0.006746811,-0.0007396657,0.007384182,-0.0015494968,-0.00024073965,-0.0024384772,0.004062922,-1.5732036e-05,0.0067208507,0.0022484742,-0.013526118,-0.008793251,-0.0038004143,-0.0089101,0.009580232,-0.005482246,-0.00292417,-0.009112455,0.008569158,-8.728113e-05,0.0075701037,-0.0024168598,-0.0042045745,-7.4500053e-06,-0.01117667,-0.0030145906,0.0065679685,0.001865224,-0.009746488,-0.0012403474,0.0011556675,-0.00023084057}, {8,7,0,7,7,1,2,2,5,2,2,0,2,1,2,2,8,255,8,255,8,0,7,5,5,2,5,1,0,0,2,8,7,1,1,0,255,255,255,7,1,0,7,1,2,255,2,7,7,255,255,0,7,7,5,0,2,1,0,0,0,2,0,1,1,2,0,255,255,0,7,255,5,8,8,0,0,2,255,2,7,5,5,255,255,255,1,7,5,1,0,0,0,7,5,2,255,255,255,2,5,0,5,1,0,0,1,255,7,8,255,1,1,0,1,1,2,0,2,2,1,2,1,7,7,255,255,8,0,255,255,0,2,0,7,7,255,255,1,1,2,2,7,255,255,255,1,5,0,0,2,255,1,255,255,0,7,255,255,2,0,255,255,255,255,7,255,255,2,0,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,65535,65535,69,71,73,75,77,79,65535,81,83,85,65535,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,65535,65535,119,121,65535,123,125,127,129,131,133,65535,135,137,139,141,65535,65535,65535,143,145,147,149,151,153,155,157,159,161,65535,65535,65535,163,165,167,169,171,173,175,177,65535,179,181,65535,183,185,187,189,191,193,195,197,199,201,203,205,207,209,65535,65535,211,213,65535,65535,215,217,219,221,223,65535,65535,225,227,229,231,233,65535,65535,65535,235,237,239,241,243,65535,245,65535,65535,247,249,65535,65535,251,253,65535,65535,65535,65535,255,65535,65535,257,259,261,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,65535,65535,70,72,74,76,78,80,65535,82,84,86,65535,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,65535,65535,120,122,65535,124,126,128,130,132,134,65535,136,138,140,142,65535,65535,65535,144,146,148,150,152,154,156,158,160,162,65535,65535,65535,164,166,168,170,172,174,176,178,65535,180,182,65535,184,186,188,190,192,194,196,198,200,202,204,206,208,210,65535,65535,212,214,65535,65535,216,218,220,222,224,65535,65535,226,228,230,232,234,65535,65535,65535,236,238,240,242,244,65535,246,65535,65535,248,250,65535,65535,252,254,65535,65535,65535,65535,256,65535,65535,258,260,262,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1625.5,1062,1652,2943,3193,3345,621.5,1699.5,4188.5,1760.5,3238,-0.0070894845,7584,584,1697,969,946,0.00929545,0.0010656299,1238.5,1341.5,1458.5,223,6418.5,-8.199215e-05,114,-0.011505672,1683.5,2146.5,1111.5,780,2238,1480.5,918.5,1037.5,1907,2461.5,3285.5,1732,0.00030362644,7124.5,-0.0023115946,-0.003724485,25061.5,233,1817,0.0067693028,2421.5,2375,999.5,1369,742.5,1093.5,-0.004553241,1944,-0.005503896,-0.014283973,0.0038992267,1147.5,1457.5,6352.5,0.0050689704,2996,5151,0.0015204368,-0.0035139557,1729,1080.5,2863.5,-0.008937613,-0.005031179,17064,31565.5,5018.5,-0.0028417732,-0.00052914285,0.0029589485,1939,1833.5,2328,329,983,8177.5,1558.5,1897.5,0.00015250458,-0.0010448326,1018,9885,-0.0018533701,-0.0009825352,1136,1164,0.0033355728,-0.0023280892,2850,1935,1849,0.001488227,0.0010059982,0.00041426983,7143.5,0.00078508194,-0.002190599,4231,1487,3126,70,0.0039206543,-0.0037172902,0.0014700033,-0.00063022884,-0.0025617788,1928.5,1887.5,3576.5,3009.5,2315.5,3918.5,404.5,5185,-1.858506e-05,0.0035867908,-0.005477524,-0.0008129089,0.0016171066,0.0078028194,-0.0013560911,0.0028973075,-0.009550002,-0.004213213,-0.0030449063,-0.0007262213,-0.00046033147,-0.008128877,0.0064318883,4.5521443e-05,0.003872734,0.01032825,0.0021070426,-0.0005702905,0.0030465557,0.0038852617,-0.00075541995,-0.0022549622,0.0041837147,0.0016153957,-0.0023665258,0.00039307112,-0.003194858,-0.00083267485,-0.000104909195,0.0026261914,-0.002075279,0.0024122063,-0.0037637171,-0.009512712,0.002025295,3.8611448e-05,-0.0016230565,0.0033154145,0.0014460897,-0.00577559,0.004546749,0.0013558869,0.015028811,0.0008815735,-0.0003825171,-4.7194026e-06}, {3,3,3,2,6,0,6,2,0,2,5,255,2,6,2,3,5,255,255,3,3,3,0,2,255,6,255,2,2,2,0,2,0,2,5,2,2,2,1,255,0,255,255,2,6,3,255,5,2,2,2,0,2,255,0,255,255,255,3,0,0,255,2,0,255,255,5,5,1,255,255,0,3,0,255,255,255,2,2,2,5,2,1,6,0,255,255,3,0,255,255,3,3,255,255,0,6,0,255,255,255,2,255,255,0,5,1,6,255,255,255,255,255,2,5,5,3,2,0,1,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,65535,65535,33,35,37,39,41,65535,43,65535,45,47,49,51,53,55,57,59,61,63,65,67,65535,69,65535,65535,71,73,75,65535,77,79,81,83,85,87,65535,89,65535,65535,65535,91,93,95,65535,97,99,65535,65535,101,103,105,65535,65535,107,109,111,65535,65535,65535,113,115,117,119,121,123,125,127,65535,65535,129,131,65535,65535,133,135,65535,65535,137,139,141,65535,65535,65535,143,65535,65535,145,147,149,151,65535,65535,65535,65535,65535,153,155,157,159,161,163,165,167,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,65535,65535,34,36,38,40,42,65535,44,65535,46,48,50,52,54,56,58,60,62,64,66,68,65535,70,65535,65535,72,74,76,65535,78,80,82,84,86,88,65535,90,65535,65535,65535,92,94,96,65535,98,100,65535,65535,102,104,106,65535,65535,108,110,112,65535,65535,65535,114,116,118,120,122,124,126,128,65535,65535,130,132,65535,65535,134,136,65535,65535,138,140,142,65535,65535,65535,144,65535,65535,146,148,150,152,65535,65535,65535,65535,65535,154,156,158,160,162,164,166,168,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11286,16103.5,21677,14487.5,25495,21468,21987,14478.5,1.5,20158.5,0.0061673666,19383.5,17972,15837.5,20407,21000,11.5,21450,10.5,16412,15.5,19103,19809,0.011038407,0.0025015452,11.5,7.5,20127.5,22740.5,12731.5,6.5,0.013182727,0.004341758,6737.5,31967,10405,14933,0.0028866779,16531,6.5,6.4356704e-05,1.5,-0.012312241,16823,21190.5,0.0007746196,-0.0014715063,-0.014546302,21885,22719,16759.5,17257.5,15036.5,12053.5,7.5,-0.001661315,21761.5,3415.5,7948.5,25690.5,0.0007756002,7920.5,21462,16079.5,26727.5,-0.0013454561,10599.5,0.0028428498,0.0059132893,11151.5,13581,0.00037515903,20047,28793,23732.5,-0.0032045336,-0.009745243,22146,29422.5,0.005658875,0.009829177,18147,24515.5,10686,23374.5,12330,13683,13189,7483.5,-0.0033168797,-0.0055470564,-0.0031984746,-0.00053141004,-0.0121701835,18573,0.00028711904,-0.0026926035,6964,23085.5,9877.5,31967,13321.5,5511.5,7920.5,27177,0.0009474821,-8.863319e-05,6965.5,14210.5,14517,20376,0.005149505,2.5,14101,22640,24963,25523.5,-0.0012606746,-0.0047082943,13881,10.5,12.5,0.0072655655,20433,10.5,25824,18485.5,18255.5,22345.5,-6.841372e-05,-0.0011294208,-0.001783249,0.003053312,0.001576625,-0.0035149471,-9.126612e-05,0.0031413075,-0.0012217492,-0.012631567,0.0010044196,-0.0011767762,0.0046012565,-0.0008312819,-0.0014253657,-0.0042621014,0.0016518116,-0.00069617544,0.0042165704,0.0010414977,0.0027369328,-0.004812216,-0.0011627919,-0.0030030904,0.003414966,-0.0013602297,0.0036909133,-0.0013389703,0.015870497,0.0070285867,0.0002413525,0.0114826625,-0.0015905891,0.008064257,0.0048660575,0.011023944,0.0006778505,0.006391277,-0.007996465,-0.00071222865,-0.008354524,-0.000749722,8.706032e-05,0.008421182,0.0021721933,0.006354322,-0.001166974,-0.0055333874,0.00029326306,-0.0026195797,-0.009330734,-0.003995342,0.00015711969,0.0020455867,0.0036218357,0.0008075912,-0.0014601903,0.00070303836,0.0013652912,0.018612167,0.008151858,2.6358315e-05}, {1,3,4,4,0,4,4,4,8,3,255,2,1,1,2,0,8,4,8,3,8,2,0,255,255,8,8,2,0,0,8,255,255,3,2,3,2,255,3,8,255,8,255,0,1,255,255,255,4,4,3,1,1,4,8,255,0,1,1,2,255,1,4,4,4,255,1,255,255,2,3,255,2,0,3,255,255,4,4,255,255,3,1,3,2,2,2,4,3,255,255,255,255,255,4,255,255,1,4,1,2,2,1,1,2,255,255,2,4,2,0,255,8,1,2,0,0,255,255,3,8,8,255,0,8,4,3,3,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,37,39,41,43,65535,65535,45,47,49,51,53,55,65535,65535,57,59,61,63,65535,65,67,65535,69,65535,71,73,65535,65535,65535,75,77,79,81,83,85,87,65535,89,91,93,95,65535,97,99,101,103,65535,105,65535,65535,107,109,65535,111,113,115,65535,65535,117,119,65535,65535,121,123,125,127,129,131,133,135,65535,65535,65535,65535,65535,137,65535,65535,139,141,143,145,147,149,151,153,65535,65535,155,157,159,161,65535,163,165,167,169,171,65535,65535,173,175,177,65535,179,181,183,185,187,189,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,38,40,42,44,65535,65535,46,48,50,52,54,56,65535,65535,58,60,62,64,65535,66,68,65535,70,65535,72,74,65535,65535,65535,76,78,80,82,84,86,88,65535,90,92,94,96,65535,98,100,102,104,65535,106,65535,65535,108,110,65535,112,114,116,65535,65535,118,120,65535,65535,122,124,126,128,130,132,134,136,65535,65535,65535,65535,65535,138,65535,65535,140,142,144,146,148,150,152,154,65535,65535,156,158,160,162,65535,164,166,168,170,172,65535,65535,174,176,178,65535,180,182,184,186,188,190,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({32.5,28.5,41.5,28.5,57,65.5,22,32,23.5,97,289,48,116.5,61,1652.5,26.5,32.5,0.0014923074,0.00060093333,23.5,798,71,774.5,39,43,499,987.5,0.004047091,235.5,722.5,1700,22,-0.001942456,22,40.5,69,30,-0.0011961183,0.00018571438,0.0023164104,121,0.0038720008,0.0027636907,0.00038125034,0.0018911142,65.5,25523.5,-0.008564488,-0.0024891591,-7.1077716e-06,-0.00014114656,-5.3436215e-05,4439,609.5,1519.5,2565.5,1537.5,22,22,-0.0013518556,-0.0017955361,-0.0021260385,0.0022250111,22,0.0009109496,0.0019374893,0.0033943902,0.0010092434,0.0014123501,0.0006157001,763,44.5,0.00435584,0.0016062016,0.002448739,584,639.5,1224.5,2990,2427,1985.5,1436,2127.5,22,59,0.0031605375,27,0.0020107229,35.5,-0.0115020145,12266,25287.5,0.00073113,238,577,943.5,706.5,1207.5,1369,1615,4752.5,-0.0034967677,-0.010482383,1676.5,0.000465995,-0.00026278902,0.004818719,3265,1501.5,-0.0008386814,-0.00025900733,0.008574307,-2.9945746e-05,-0.00028140095,-0.0012885592,0.0013142911,0.0021313203,-0.0042008087,-0.00017487693,-0.0022049905,-0.00014960852,0.0002807645,-0.0004332155,0.0024501916,0.006679162,-0.004849247,-0.011597157,-0.00021081696,-0.005691378,0.0008549156,0.008939116,-0.0043896227,-2.7522638e-05,0.0069696456,0.0016978445,-0.0034287658,0.0004842978,-0.00078984955,-0.0024207642,-0.0019707521,6.46342e-05,-0.0007696398,-6.033856e-06}, {4,0,4,5,2,6,2,6,0,0,1,0,0,4,5,0,2,255,255,5,0,2,0,0,2,6,0,255,4,5,5,0,255,2,6,0,0,255,255,255,0,255,255,255,255,0,0,255,255,255,255,255,6,5,0,6,4,2,2,255,255,255,255,6,255,255,255,255,255,255,0,6,255,255,255,5,5,4,2,0,1,4,5,6,2,255,2,255,2,255,0,2,255,2,1,4,5,5,6,0,2,255,255,1,255,255,255,2,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,35,37,39,41,43,45,47,49,65535,51,53,55,57,65535,59,61,63,65,65535,65535,65535,67,65535,65535,65535,65535,69,71,65535,65535,65535,65535,65535,73,75,77,79,81,83,85,65535,65535,65535,65535,87,65535,65535,65535,65535,65535,65535,89,91,65535,65535,65535,93,95,97,99,101,103,105,107,109,111,65535,113,65535,115,65535,117,119,65535,121,123,125,127,129,131,133,135,65535,65535,137,65535,65535,65535,139,141,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,36,38,40,42,44,46,48,50,65535,52,54,56,58,65535,60,62,64,66,65535,65535,65535,68,65535,65535,65535,65535,70,72,65535,65535,65535,65535,65535,74,76,78,80,82,84,86,65535,65535,65535,65535,88,65535,65535,65535,65535,65535,65535,90,92,65535,65535,65535,94,96,98,100,102,104,106,108,110,112,65535,114,65535,116,65535,118,120,65535,122,124,126,128,130,132,134,136,65535,65535,138,65535,65535,65535,140,142,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3177,2612.5,1510,2333,2681.5,1172.5,4411,28.5,5568,7772,3049.5,5148.5,7173,3992.5,5687,70.5,213.5,1726,6418,2621,10998.5,2883,14932.5,722,6006,-0.01296706,7205.5,4223,4003.5,5051.5,6360,25.5,-0.005670556,88.5,232.5,0.0016372275,2556,5799,2330.5,0.0084864525,2831.5,10237.5,11397,5503.5,3345.5,3143,3155.5,2038,4386,6263,89.5,-0.0064325095,-0.004160836,4186,4264,-0.016448395,4955.5,4851,5290.5,5819,6587,202,71,133,165.5,121.5,52,4580.5,-0.0056615127,6142.5,0.0064417208,8762.5,8010,5655.5,0.0059659774,8269.5,11366,5928.5,-0.00017894016,2796.5,12698.5,2069,14436.5,3757,7852,3125.5,15796,1113,25.5,0.0008608868,0.00287098,201.5,-0.010271828,78,1060.5,2287,-0.012019407,0.008253116,5595.5,4257.5,4985,5492.5,5413,5127,4773,5487.5,9361.5,6618,6639.5,44,22,25.5,43.5,128.5,28.5,159,883.5,322,137.5,-0.005050254,1964.5,2524,-0.00427521,0.0008474998,0.0029886023,7683,2253,2543.5,2573,0.0028792857,0.004120792,0.0014594625,0.00039449692,0.003082284,0.0051310803,-0.00089976605,-0.0017939874,-0.002909934,3506,6955,2845.5,1496.5,2873.5,7683,0.0006610926,3154,-7.185464e-06,3412.5,-5.6834706e-06,15297.5,15711,0.00056974665,0.0011592046,6876,363.5,-4.2847136e-05,73.5,-0.007812982,0.0008486652,0.0009839335,0.003863419,866,-0.0057202703,3754.5,3411,5450.5,5803,3046,-0.011527891,0.006210974,3300,5147,5381.5,5536.5,3998.5,5198.5,5994.5,5758.5,5768,-0.022054417,6758,6320.5,5704,6381,7210,10243,6652.5,-3.3378336e-05,-0.0023437047,0.0007456683,0.0012149623,-0.0028786294,-0.00010671789,-0.004321184,0.0004299154,0.0010070604,0.011306468,0.0020369543,-0.0010471691,0.003133715,0.005536943,0.0012841152,-0.0010393278,-0.00076345063,0.0032319226,-0.0038709983,-0.0014950762,0.0006730173,1.2473914e-05,-0.0016385627,-0.0027107373,0.0009198223,-0.0012166076,0.0030796647,0.0015266796,-0.0035492969,-0.005041068,-0.0016279649,0.0009728213,0.0006785171,-0.00078596035,0.0056179403,0.0016163938,-0.00016885599,-0.003141921,-0.0025026936,-0.0011899314,0.0014435829,-0.0003401445,-0.0012174223,-0.002804212,0.0043647615,0.0004661129,0.0007409464,0.0022756064,-0.00091621774,-0.0006362851,-0.000109762805,0.0008936043,0.00044430917,-0.00034360957,-0.0015433313,-0.0010603543,0.0005424128,0.0009882548,-0.0017082226,-0.0001622949,-0.0024911265,-0.012246252,-0.0014771903,0.00016838849,0.0077380775,0.0017819023,-0.0017690434,0.00092237396,0.004638255,-0.0048902617,-0.0040062503,-0.0005591823,0.00041877662,0.0037186572,0.002580827,0.011110797,0.009601839,0.015959581,0.005689884,0.0032952402,0.0036904307,-0.0038271328,-0.024797665,-0.014499067,0.0037416671,-0.00080162345,-0.0011039955,0.0011091442,-0.0014468804,-0.01186388,0.0014517258,-0.0066207,-0.005432829,-0.00089108833,0.00038949584,-0.007869779,0.012513679,0.0016596009,-0.00280806,-0.009208642,0.0073535293,1.7556528e-06}, {5,5,1,5,5,0,5,1,6,2,5,6,2,5,1,0,2,0,2,1,6,5,6,0,5,255,0,3,5,2,1,1,255,3,3,255,3,6,1,255,3,0,0,6,1,3,3,2,6,6,1,255,255,3,3,255,2,2,2,0,1,5,6,0,2,3,1,0,255,0,255,0,2,0,255,2,0,0,255,1,0,0,0,1,0,5,0,2,0,255,255,0,255,0,2,6,255,255,2,5,2,1,3,3,1,5,0,0,1,3,0,5,3,0,6,0,0,2,3,255,3,3,255,255,255,2,1,5,5,255,255,255,255,255,255,255,255,255,0,6,1,0,0,0,255,5,255,1,255,2,0,255,255,5,0,255,0,255,255,255,255,0,255,0,5,1,6,6,255,255,3,3,6,0,0,5,5,2,2,255,3,1,3,0,0,3,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,65535,63,65,65535,67,69,71,65535,73,75,77,79,81,83,85,87,89,91,93,65535,65535,95,97,65535,99,101,103,105,107,109,111,113,115,117,119,121,65535,123,65535,125,127,129,65535,131,133,135,65535,137,139,141,143,145,147,149,151,153,155,65535,65535,157,65535,159,161,163,65535,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,65535,207,209,65535,65535,65535,211,213,215,217,65535,65535,65535,65535,65535,65535,65535,65535,65535,219,221,223,225,227,229,65535,231,65535,233,65535,235,237,65535,65535,239,241,65535,243,65535,65535,65535,65535,245,65535,247,249,251,253,255,65535,65535,257,259,261,263,265,267,269,271,273,65535,275,277,279,281,283,285,287,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,65535,64,66,65535,68,70,72,65535,74,76,78,80,82,84,86,88,90,92,94,65535,65535,96,98,65535,100,102,104,106,108,110,112,114,116,118,120,122,65535,124,65535,126,128,130,65535,132,134,136,65535,138,140,142,144,146,148,150,152,154,156,65535,65535,158,65535,160,162,164,65535,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,65535,208,210,65535,65535,65535,212,214,216,218,65535,65535,65535,65535,65535,65535,65535,65535,65535,220,222,224,226,228,230,65535,232,65535,234,65535,236,238,65535,65535,240,242,65535,244,65535,65535,65535,65535,246,65535,248,250,252,254,256,65535,65535,258,260,262,264,266,268,270,272,274,65535,276,278,280,282,284,286,288,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({20.5,21.5,51.5,117,22,15.5,53,13.5,15.5,-0.002934052,-0.013321173,30,27,6.5,850,76,33.5,13.5,17.5,52,28.5,32.5,51,-0.005883787,34.5,20.5,2601.5,26.5,0.0060354746,22,-0.005165377,2.5,-0.009852664,0.0065550515,0.0015182483,3.5,61,0.0056538223,33,22,17.5,26.5,283.5,0.0010686492,35,804.5,676,867,2462,59,6.5,30,18.5,-0.008055672,380.5,22,13.5,4.5,-0.0025768878,31.5,1.5,0.003959243,18,0.011290766,19.5,18.5,-0.0059126965,28.5,38.5,-0.00164166,-0.00641151,546.5,1064.5,506.5,1117.5,856.5,2273,2679,2498.5,6.5,-0.0009874749,27,22,20.5,0.0010548552,-0.0013310442,0.005900902,6.5,0.0035521637,-0.004935635,-0.0017336498,5.5,60,0.0039392854,22,7428.5,0.004129818,52.5,34.5,0.0008823326,-0.0004028195,0.0008101272,0.00746369,-0.005010631,-0.0005443665,20.5,36.5,5965.5,0.004117507,114,559.5,341.5,9066.5,352,812,516.5,1988.5,13.5,-0.008044725,15.5,2359,17.5,2401.5,7.5,5164,-0.00021285962,0.002056881,-0.00055526703,0.0034165313,-1.6299207e-05,-0.0023080416,-0.0013920303,-0.0036774722,0.0022458034,-0.005769048,0.00052408624,-0.0010132897,-0.0020807383,-0.0047182213,0.0024845477,-0.0024904315,0.00060712936,0.0039924253,-0.009842574,0.0015469394,0.0019511798,-0.0014077234,0.00731551,0.0010238985,-0.0060652383,0.0045008673,-0.0007362333,-0.0070327655,-0.00019368519,0.0005199637,-0.0062471568,-0.00059301744,0.0030664417,0.0058422345,-0.0003853307,0.0011972033,-0.00043865532,0.01321947,-0.011835827,-0.0036491111,0.0073394664,0.03132132,-0.00026401872,0.009500041,-0.00075234106,-0.0048647407,0.00014737104,-0.0014954589,-0.0026429964,0.00027732228,-0.00026586113,0.00193832,0.009779337,0.0015893637,0.0004534621,-0.005203131,-0.0003496206,6.047293e-06}, {7,8,0,0,0,8,0,8,8,255,255,2,7,8,0,0,0,8,8,4,4,2,7,255,7,8,0,0,255,2,255,8,255,255,255,8,4,255,0,0,8,0,7,255,2,0,3,0,4,2,8,0,8,255,0,0,8,8,255,0,8,255,8,255,8,8,255,0,0,255,255,0,2,7,2,0,0,3,4,8,255,4,2,8,255,255,255,8,255,255,255,8,7,255,2,4,255,4,7,255,255,255,255,255,255,8,0,7,255,0,0,7,2,3,7,0,4,8,255,8,7,8,2,8,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,65535,51,65535,53,65535,65535,65535,55,57,65535,59,61,63,65,67,65535,69,71,73,75,77,79,81,83,85,65535,87,89,91,93,65535,95,97,65535,99,65535,101,103,65535,105,107,65535,65535,109,111,113,115,117,119,121,123,125,65535,127,129,131,65535,65535,65535,133,65535,65535,65535,135,137,65535,139,141,65535,143,145,65535,65535,65535,65535,65535,65535,147,149,151,65535,153,155,157,159,161,163,165,167,169,65535,171,173,175,177,179,181,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,65535,52,65535,54,65535,65535,65535,56,58,65535,60,62,64,66,68,65535,70,72,74,76,78,80,82,84,86,65535,88,90,92,94,65535,96,98,65535,100,65535,102,104,65535,106,108,65535,65535,110,112,114,116,118,120,122,124,126,65535,128,130,132,65535,65535,65535,134,65535,65535,65535,136,138,65535,140,142,65535,144,146,65535,65535,65535,65535,65535,65535,148,150,152,65535,154,156,158,160,162,164,166,168,170,65535,172,174,176,178,180,182,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5185,5156.5,5374.5,4262.5,5733.5,7148.5,6651,4150,5060,5050.5,-0.008192005,8833,-0.011041371,8645,5720.5,3996,20.5,4954.5,5868.5,-0.0023166507,-0.00023189098,6200,2.5,6168,6702.5,6052,5902.5,2429.5,4300,3.5,0.010569399,3341,5158,5939,4710,5260.5,5306.5,0.0012138373,18.5,7464.5,8743.5,6948,10052.5,5659,6923,5871,5935,1728,2113,-0.022974271,14.5,3386,17.5,4799.5,8.5,4906.5,13605,-0.01833359,-0.008446892,18.5,17.5,4158.5,5363,7425,7025,5380.5,5291,1811.5,5597.5,5923,-0.016485905,5727,2.5,7911.5,5680.5,3958.5,5761,0.009326371,8541.5,7284.5,7350,0.008021319,7230,11.5,5.5,18.5,2271,-0.00088334124,-0.004617102,0.001067665,0.008689403,14.5,0.0036971734,2748.5,4916,4407,4608,3491,0.014761129,6491,13613.5,12.5,0.00618518,5524.5,-0.004622083,-0.004493769,18.5,4140,-2.2704906e-05,0.015499291,0.011016341,0.011800748,9.5,5217.5,-0.0005759561,-0.00048325924,0.00046257643,14.5,4787.5,8499.5,5707,6188.5,6215.5,0.009550053,0.0043348107,-0.00317727,8312.5,-0.00711653,6.5,9898,8262.5,13.5,5636,0.0010670985,-0.010968251,5.5,0.007213832,7297.5,3.5,-0.013068229,-0.004140735,9097,7236.5,-0.00036678303,0.00036335379,0.0014498481,-0.0021844818,0.00056642893,0.0074389987,-0.0022071525,0.00033769524,0.0006117286,-0.0024035422,-0.0051903343,0.0004628364,0.0019357909,-0.0003377242,0.0019948012,-0.0057886685,-0.012345233,-0.002180091,0.0017373188,0.0065436563,-0.0014024194,0.0006267006,-0.010869484,0.0005270869,0.0007403641,-0.0019089839,-0.0007901988,-0.004335834,0.0017659042,-0.0016716952,0.0056003546,0.010157804,0.004849217,-0.0009689441,-0.0026186272,-0.0015757083,0.00026173095,-0.006690383,0.0008573031,-0.00028393543,0.0011306851,-0.003573234,-0.003457003,-0.011680711,-0.003999995,-0.015749762,0.0008529709,-0.0028168303,0.0034616848,-7.8110825e-05,-0.003760187,0.0011806114,0.0010528849,-0.001499561,0.0018091099,-0.00025324157,-0.0039284094,0.0014676986,0.00739958,0.0010928608,0.004077188,0.0028034549,-0.0062273587,-0.0012351506,-0.00056564604,0.004109745,0.0013429439,-0.0031290927,-0.0067050057,-6.0638913e-06}, {6,6,6,2,2,2,2,2,7,2,255,0,255,5,6,2,8,5,5,255,255,0,8,2,0,7,6,5,5,8,255,7,5,2,6,6,6,255,8,5,6,6,5,7,0,7,6,6,0,255,8,6,8,2,8,6,0,255,255,8,8,0,5,0,0,2,2,0,0,6,255,6,8,0,6,5,0,255,0,5,5,255,2,8,8,8,0,255,255,255,255,8,255,7,0,7,6,6,255,0,0,8,255,7,255,255,8,5,255,255,255,255,8,6,255,255,255,8,0,6,2,2,0,255,255,255,7,255,8,0,6,8,6,255,255,8,255,2,8,255,255,5,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,65535,23,25,27,29,31,33,65535,65535,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65535,65,67,69,71,73,75,77,79,81,83,85,65535,87,89,91,93,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,119,121,65535,123,125,127,129,131,133,65535,135,137,139,65535,141,143,145,147,149,65535,65535,65535,65535,151,65535,153,155,157,159,161,65535,163,165,167,65535,169,65535,65535,171,173,65535,65535,65535,65535,175,177,65535,65535,65535,179,181,183,185,187,189,65535,65535,65535,191,65535,193,195,197,199,201,65535,65535,203,65535,205,207,65535,65535,209,211,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,65535,24,26,28,30,32,34,65535,65535,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,65535,66,68,70,72,74,76,78,80,82,84,86,65535,88,90,92,94,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,120,122,65535,124,126,128,130,132,134,65535,136,138,140,65535,142,144,146,148,150,65535,65535,65535,65535,152,65535,154,156,158,160,162,65535,164,166,168,65535,170,65535,65535,172,174,65535,65535,65535,65535,176,178,65535,65535,65535,180,182,184,186,188,190,65535,65535,65535,192,65535,194,196,198,200,202,65535,65535,204,65535,206,208,65535,65535,210,212,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6294.5,6289,6301.5,5185,0.010703492,7192.5,6624,7464,8520.5,-0.0067700366,-0.01110453,6370,6640,5778.5,5084,5878,8685,6549.5,7753,6936.5,6684.5,5035,4601,3746.5,-0.008960667,7393,6556.5,6766.5,9439,6134.5,5958.5,6769.5,6168,0.0033753586,0.0050180396,6821.5,6692,4901,4938,9043,5150,-0.0073722512,8346.5,4984.5,7921,5569,7194,0.0013103549,0.023991706,7916,9538.5,5024,0.007626956,6492.5,0.001397741,6715,8692.5,8640.5,6781,5854.5,7730.5,0.011917385,6741.5,3938,5149.5,5202.5,5154.5,8097.5,-0.011474318,5882,-0.0064088725,3834.5,1048,5675,5092.5,0.01718033,0.0027665729,5552,5796.5,4985,7466,6950.5,-0.008985628,0.00725049,10121,5523.5,6354,-0.0076793144,7407.5,-0.0041069407,0.00087178015,-0.015066077,-0.0068340437,-0.0023895253,0.0032758687,0.0024220385,6510,3888,6733,-0.0048502753,-0.010972851,7752,6765,0.00014509769,-0.00093595026,0.0020389515,0.009837159,-0.003886442,0.0013640629,-0.0129658505,-0.0023421403,0.0021086102,8.235741e-05,0.0013533104,0.013431961,-0.003205847,-0.00093918684,-0.0012413752,0.00045590178,0.00046041375,-0.001391836,0.0057877153,0.000745491,-0.0008637186,0.011026465,-0.013084702,-0.003374514,0.0017948952,0.00565735,0.0002835256,-0.0037823615,0.0016143991,0.0064185597,0.0043187914,0.0014042987,-9.4987176e-05,0.003398429,0.00037404452,-0.009309573,-0.0034051721,-0.0050204014,-0.007418498,-0.0025535913,-0.0013740999,-0.0075997985,0.017656738,-0.0022596854,-0.005067255,0.0012065832,0.002681805,-2.7078195e-05}, {6,6,6,6,255,2,6,2,3,255,255,3,6,3,7,7,3,6,2,3,6,3,6,3,255,3,7,4,2,3,3,4,7,255,255,7,6,3,2,4,7,255,2,3,2,5,3,255,255,2,2,2,255,2,255,7,4,2,4,3,3,255,6,2,2,3,2,3,255,2,255,6,6,2,3,255,255,4,2,2,3,4,255,255,3,4,7,255,2,255,255,255,255,255,255,255,7,3,4,255,255,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,65535,9,11,13,15,65535,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,65535,65535,59,61,63,65,67,69,65535,71,73,75,77,79,65535,65535,81,83,85,65535,87,65535,89,91,93,95,97,99,65535,101,103,105,107,109,111,65535,113,65535,115,117,119,121,65535,65535,123,125,127,129,131,65535,65535,133,135,137,65535,139,65535,65535,65535,65535,65535,65535,65535,141,143,145,65535,65535,147,149,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,65535,10,12,14,16,65535,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,65535,65535,60,62,64,66,68,70,65535,72,74,76,78,80,65535,65535,82,84,86,65535,88,65535,90,92,94,96,98,100,65535,102,104,106,108,110,112,65535,114,65535,116,118,120,122,65535,65535,124,126,128,130,132,65535,65535,134,136,138,65535,140,65535,65535,65535,65535,65535,65535,65535,142,144,146,65535,65535,148,150,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({33.5,30,35,26.5,1215.5,56.5,1318.5,22,40.5,44.5,1668,-0.0012125513,12268.5,1042.5,1443,27,23.5,28.5,0.003759342,40,284.5,-0.0005418815,0.00010616606,580.5,25432,1051.5,891.5,1284,1502,22,22,-0.0012715408,-0.0023286769,22,-5.1183557e-05,33.5,0.004660049,58,391,-0.009407406,-0.0046050465,0.0019853015,-0.0012065482,836.5,1020,1253,1257.5,1410,5629.5,1367.5,1659.5,22,22,-0.0015576859,-0.00092020724,0.0010683563,0.0016258361,27,0.0011004986,41.5,84,0.004361573,0.0018680337,26,276,870,0.008370686,1179.5,1079,1153,829.5,715,-0.007469509,1496,-0.004040025,1283.5,-0.0060909013,770,1685,-0.0005248102,0.00056038686,0.0057977154,-0.00049722655,0.0015631758,0.0021608516,69,146.5,0.00217852,0.0012639615,61,22.5,651,318.5,0.0015936468,0.0037947022,319.5,-0.00598181,0.012255884,854,986,1089.5,1018,1244.5,-0.0052502532,1156.5,1356,0.0019557988,0.00095284247,1225.5,-0.013033449,1784.5,709.5,6404,7.3329924e-05,0.0011011332,-0.0012329987,-0.00057548983,0.0023413145,0.00031207872,-0.005612871,9.8628436e-05,-0.002303029,-0.015277641,-0.009919669,0.0005026685,0.0013514404,0.0042063105,0.0057195295,0.0024384884,-0.0015490496,-0.0026889776,0.0030896103,0.00012591881,0.0007383865,0.0024664444,0.003341765,0.004272572,0.0027385,-0.0030171347,-0.00058354053,0.0008632349,0.004025364,0.0056101973,-0.00048031865,-0.0043042055,-0.00032467148,0.0036474117,-0.00019668123,3.590468e-05}, {4,0,4,4,0,0,4,4,3,1,0,255,0,4,4,2,0,0,255,0,0,255,255,0,0,5,5,3,4,2,0,255,255,0,255,0,255,3,0,255,255,255,255,4,3,0,5,4,0,5,4,0,0,255,255,255,255,1,255,2,0,255,255,2,1,0,255,0,2,3,0,0,255,5,255,0,255,3,4,255,255,255,255,255,255,0,0,255,255,4,3,2,5,255,255,1,255,255,1,1,4,2,4,255,0,4,255,255,3,255,0,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,65535,35,37,65535,65535,39,41,43,45,47,49,51,53,65535,65535,55,65535,57,65535,59,61,65535,65535,65535,65535,63,65,67,69,71,73,75,77,79,81,65535,65535,65535,65535,83,65535,85,87,65535,65535,89,91,93,65535,95,97,99,101,103,65535,105,65535,107,65535,109,111,65535,65535,65535,65535,65535,65535,113,115,65535,65535,117,119,121,123,65535,65535,125,65535,65535,127,129,131,133,135,65535,137,139,65535,65535,141,65535,143,145,147,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,65535,36,38,65535,65535,40,42,44,46,48,50,52,54,65535,65535,56,65535,58,65535,60,62,65535,65535,65535,65535,64,66,68,70,72,74,76,78,80,82,65535,65535,65535,65535,84,65535,86,88,65535,65535,90,92,94,65535,96,98,100,102,104,65535,106,65535,108,65535,110,112,65535,65535,65535,65535,65535,65535,114,116,65535,65535,118,120,122,124,65535,65535,126,65535,65535,128,130,132,134,136,65535,138,140,65535,65535,142,65535,144,146,148,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3629,3426.5,4721.5,1052,4372.5,4935,5372.5,1782.5,2026.5,5820.5,-0.0011928244,3961,6987,5160.5,5447.5,1033,2943,1967,2064,5189,3556.5,3356.5,2524.5,4044.5,-0.0034270182,5334.5,4949,6995.5,5005,1609,-0.0069815004,593.5,0.004427275,1925,2007,1061,2873.5,1297,0.0066435495,3900,-0.0011599913,4128.5,-0.008067616,-0.0072956085,4551.5,2632,5588.5,5213.5,0.011579483,6124,5503.5,5150,-0.01060577,6984,5184,645.5,1421,2847,-0.008655749,1892,1200,1984,0.00086326955,593,2364,2415,2318,5236.5,3544.5,0.0015368789,0.0031925885,3929,4181.5,6151.5,6489.5,-3.0885978e-05,-0.0004652748,4403.5,2796,2460.5,9302.5,5558,0.005205967,5444.5,7244.5,5525,5045.5,5079,7959,5720.5,5596.5,622.5,973.5,0.0017074626,0.0033991698,-0.0038755864,0.0010254955,1670.5,0.009727139,1974,1747.5,0.002988563,0.0059409416,3186.5,1320,1142.5,1204,2304,2437.5,2165.5,3219,0.0021656563,0.00089786184,0.0042619864,0.0029532218,3422.5,-0.016082725,0.002138999,3719,5691,3655,5534.5,10091.5,5329.5,4736.5,0.0023646373,0.005176579,4982,3499,4543.5,8556,0.0068561966,5113.5,-0.01935761,6080.5,5651,5514,5417.5,4769.5,5287,6246.5,5604,4357,2153,7161,5534,6939,8370.5,5812.5,0.00024849462,0.0037072287,-0.0014230678,0.0001527168,0.0004888154,0.0029239396,-0.0050599575,0.0021055725,0.0034437699,-0.00043560928,-0.00062860124,-0.0030182586,0.0051837317,0.002389181,0.0017955698,-0.0030278843,-0.008419092,-0.0051159407,0.00037461508,0.0033666943,-0.00827537,0.00068620587,-0.00043251558,-0.0089397235,-0.0010219353,0.0007155412,-0.0013524618,-0.00309536,7.0890186e-05,-0.0013813314,-7.83794e-05,0.009851002,-0.003351882,-0.0011721671,-0.003332225,-0.008562221,0.00084348343,-0.00058574515,0.0025233524,0.004193997,0.00082753814,0.00056997134,0.00059705944,-0.0011088309,-0.009052261,-0.0016763365,0.0008434143,0.004540011,-0.0031230196,-0.0012535554,0.0010476677,-0.0018059195,-0.006240052,-0.017453158,-0.00066946534,-0.015431324,-0.00048112014,0.013814518,-0.004255157,-0.005734175,-0.00023725694,-0.0022478474,0.006051776,0.001389933,-0.0009828577,0.0029532858,-0.0032737849,0.001197246,0.001584499,0.0060660047,-0.005729571,-2.9263718e-05,-0.008685942,-0.002572712,-0.0057439622,-0.013628773,-0.0038715103,-0.0009292219,-0.00067462644,-0.009440093,0.0016668119,-3.4989258e-05}, {2,2,2,3,3,3,2,2,0,0,255,4,4,3,2,3,2,0,4,4,2,7,0,2,255,2,2,7,6,2,255,3,255,3,0,7,2,7,255,6,255,2,255,255,2,0,4,0,255,0,4,3,255,2,6,6,0,0,255,3,6,0,255,6,2,0,4,0,2,255,255,2,2,0,0,255,255,2,0,3,4,3,255,3,7,6,4,4,4,4,6,6,6,255,255,255,255,4,255,2,6,255,255,0,4,4,6,4,0,4,2,255,255,255,255,4,255,255,3,0,7,0,0,0,0,255,255,2,7,3,0,255,0,255,0,7,0,2,4,3,6,0,7,3,2,3,0,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,65535,57,65535,59,61,63,65,67,65535,69,65535,71,65535,65535,73,75,77,79,65535,81,83,85,65535,87,89,91,93,95,65535,97,99,101,65535,103,105,107,109,111,113,65535,65535,115,117,119,121,65535,65535,123,125,127,129,131,65535,133,135,137,139,141,143,145,147,149,151,65535,65535,65535,65535,153,65535,155,157,65535,65535,159,161,163,165,167,169,171,173,65535,65535,65535,65535,175,65535,65535,177,179,181,183,185,187,189,65535,65535,191,193,195,197,65535,199,65535,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,65535,58,65535,60,62,64,66,68,65535,70,65535,72,65535,65535,74,76,78,80,65535,82,84,86,65535,88,90,92,94,96,65535,98,100,102,65535,104,106,108,110,112,114,65535,65535,116,118,120,122,65535,65535,124,126,128,130,132,65535,134,136,138,140,142,144,146,148,150,152,65535,65535,65535,65535,154,65535,156,158,65535,65535,160,162,164,166,168,170,172,174,65535,65535,65535,65535,176,65535,65535,178,180,182,184,186,188,190,65535,65535,192,194,196,198,65535,200,65535,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27.5,419.5,56.5,79,580.5,52.5,35,374,-0.007880334,-0.015509776,15212.5,36.5,64,6073.5,211,68,339.5,67,24973,899.5,22,0.0035312108,0.010114281,64,0.003422644,116.5,230.5,306,36.5,0.0042657717,0.00088113983,608,4421.5,0.0045882505,32053,40,0.003636943,-0.0017120689,48.5,-0.0067111054,72,101,250,-0.0057534045,1345.5,25.5,-0.0035946628,112,24.5,-0.002705167,974,-0.0011425465,-0.0029790213,12504.5,0.0025688957,32.5,439,35,88,0.00024105197,110,62,71,42.5,0.00919728,645.5,1088.5,34,71,-0.0083857495,-0.002899966,33,-0.005889991,-0.0049487436,-0.0034541308,-0.0033029504,0.0007921971,106,48,-0.0016103005,-0.0025152324,0.008055482,0.005165241,79.5,0.0031684898,-0.0033289602,970,53,40.5,125,102,134.5,39.5,626,683.5,823.5,5719,-0.0001380543,0.0010874987,-0.00026946372,-0.005552668,0.00095375365,-0.00084425305,-0.0017445987,0.00084144203,0.00016640227,0.0022438553,0.0012879712,-0.00032267938,-0.0010249494,-0.0018029573,-0.002659772,0.00022359304,0.0013663385,0.0035381943,5.310117e-05,-0.0046079047,0.00046572235,-0.0004749534,0.004912802,-0.0008916783,0.005975801,0.0037127447,-5.954294e-05,0.0033147011,-0.0021538073,-0.00061561645,-0.00042625485,0.0026248442,0.00013544444,-3.2670338e-05}, {7,1,6,6,0,7,4,0,255,255,0,7,0,0,4,4,1,4,0,0,4,255,255,7,255,4,4,0,5,255,255,1,0,255,1,4,255,255,0,255,6,6,6,255,6,7,255,0,7,255,1,255,255,4,255,6,0,0,4,255,6,6,7,5,255,6,7,1,0,255,255,1,255,255,255,255,255,0,0,255,255,255,255,4,255,255,0,0,0,6,4,4,1,6,4,7,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,65535,17,19,21,23,25,27,29,31,33,35,37,65535,65535,39,65535,41,43,45,47,65535,65535,49,51,65535,53,55,65535,65535,57,65535,59,61,63,65535,65,67,65535,69,71,65535,73,65535,65535,75,65535,77,79,81,83,65535,85,87,89,91,65535,93,95,97,99,65535,65535,101,65535,65535,65535,65535,65535,103,105,65535,65535,65535,65535,107,65535,65535,109,111,113,115,117,119,121,123,125,127,129,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,65535,18,20,22,24,26,28,30,32,34,36,38,65535,65535,40,65535,42,44,46,48,65535,65535,50,52,65535,54,56,65535,65535,58,65535,60,62,64,65535,66,68,65535,70,72,65535,74,65535,65535,76,65535,78,80,82,84,65535,86,88,90,92,65535,94,96,98,100,65535,65535,102,65535,65535,65535,65535,65535,104,106,65535,65535,65535,65535,108,65535,65535,110,112,114,116,118,120,122,124,126,128,130,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5687,5475.5,6072.5,5462,5177.5,6374,6088.5,5406.5,6087,5527,5580,16.5,5945.5,0.0083393315,26.5,5117.5,4948,10,-0.008423986,5488.5,8099.5,5377,5886,5921,6101,8613,7781,-0.007130263,12.5,5096,5160,4935,5287.5,0.00020949752,-0.0039434633,-7.097961e-05,-0.017538246,4503,0.0060809166,4349.5,6.5,5510,1.5,5699,5294,6391,6576.5,5800,-0.00014560162,4.5,12758,6348.5,19753,12.5,11.5,8034.5,5839.5,18.5,17.5,7577,1.5,15.5,7.5,5544,0.015689526,5722.5,5594,16.5,5527,-0.008028021,7138.5,5191.5,8641.5,7.5,5271,5828.5,5561,0.005472531,-0.003535229,5895.5,5893.5,9895.5,5.5,5799.5,6.5,6179.5,28925.5,15323.5,19844,9.5,9807.5,4572,5101.5,4080.5,10.5,5421.5,5911.5,3701.5,5475.5,6527,2808,5552.5,4.5,8418,3313.5,5593,0.005273649,5088.5,14.5,0.007892615,0.0033557718,-0.006110668,0.0032936798,17.5,16.5,8.5,18.5,-0.012034312,9247.5,6.5,10041,5750.5,5804.5,5804,5693.5,5939.5,6686,6023,12.5,4241,0.008324773,5793,5460.5,-0.018526701,-0.0075355726,-0.004704464,-0.011437412,-0.009862913,-0.0033614081,0.008711749,6438,11.5,6289.5,0.0021992368,11.5,8700,5008,18312.5,29285.5,13576.5,20764.5,29841.5,27099.5,8.471495e-05,-0.0005913697,0.00040863952,-0.0011108445,-0.0048413663,0.0029334333,-0.008644797,-0.0030989142,0.002238472,0.008759489,0.0005146078,0.0061195428,0.0013458774,0.010239962,-0.0054388065,-0.00072626414,0.0006771141,-0.0011769439,-0.01027782,-0.0007323262,-0.0021691972,0.0007120988,0.002298631,0.013595886,-0.017235091,-0.0014675057,0.0026475326,-0.0021867524,-0.0039766566,-0.015780432,-0.0031493336,-0.00012613524,0.0019835653,-0.001372638,9.630836e-05,0.0036798173,-0.0070249285,-0.0027006723,0.0065899477,0.015902316,0.0018427911,-0.0032954488,0.0067818775,0.0026633544,-0.0014961076,-0.004132314,-0.00028318024,-0.005250558,0.005596263,0.0030606966,-0.0047194227,0.0015162007,-0.00070748356,0.0023151438,-0.008090894,-0.0017640375,0.0015929155,0.009377987,-0.005671404,0.0015403185,0.0003803258,0.0081620645,0.0019197956,-0.003175127,-0.023606254,-0.0026939574,-0.0026613837,0.0023685074,0.0020723776,-0.0037267357,-0.005672797,-0.009309896,-0.005993072,-0.0009961339,-0.0057308483,-0.0015687466,0.0010663344,-0.0010740755,0.0020166987,0.007206853,-0.0010314449,0.00024598744,0.004326007,-0.0014883045,0.0005763601,-0.0028501449,4.3773365e-05,0.00048768806,-0.0037872442,-0.00019784614,-0.00026633384,0.0019446692,-0.0007912395,0.0027913607,0.0037341279,0.00033432335,-0.00058235024,0.00012833826}, {1,1,1,1,5,3,1,5,5,1,5,8,0,255,2,1,2,8,255,1,0,2,3,1,3,5,3,255,8,1,1,3,2,255,255,255,255,2,255,2,8,1,8,2,3,0,5,1,255,8,2,1,5,8,8,2,0,8,8,5,8,8,8,1,255,0,1,8,1,255,3,3,2,8,5,0,3,255,255,0,1,2,8,1,8,1,5,2,1,8,0,5,1,2,8,1,0,2,5,5,0,0,8,3,0,1,255,3,8,255,255,255,255,8,8,8,8,255,2,8,2,0,0,0,3,0,0,1,8,3,255,2,5,255,255,255,255,255,255,255,3,8,0,255,8,0,5,0,5,2,3,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,65535,27,29,31,33,65535,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,65535,65535,65535,65535,61,65535,63,65,67,69,71,73,75,77,79,65535,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,113,115,117,65535,119,121,123,125,127,129,131,65535,65535,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,65535,187,189,65535,65535,65535,65535,191,193,195,197,65535,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,65535,65535,65535,65535,65535,65535,65535,227,229,231,65535,233,235,237,239,241,243,245,247,249,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,65535,28,30,32,34,65535,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,65535,65535,65535,65535,62,65535,64,66,68,70,72,74,76,78,80,65535,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,114,116,118,65535,120,122,124,126,128,130,132,65535,65535,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,65535,188,190,65535,65535,65535,65535,192,194,196,198,65535,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,65535,65535,65535,65535,65535,65535,65535,228,230,232,65535,234,236,238,240,242,244,246,248,250,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2064.5,1695.5,2102,1687,1848.5,9095,41.5,25813.5,0.009048865,1000,8483,1825.5,9846.5,28.5,2744.5,104.5,-0.006980441,-0.012133113,1505.5,2550.5,8547.5,4630,0.0063533247,-9.612543e-05,-0.0015064044,5627,2544,2696,5201.5,65.5,368.5,1183.5,11030,3184,2879.5,7209.5,9124.5,0.0016729292,0.001190378,2716.5,22,863.5,6166,128,2605.5,1490,5225.5,141,608,506,206.5,-0.0016994454,-0.0056836125,-8.2039245e-05,-0.000931518,1813.5,1479,2728.5,4173.5,-0.0054243146,2671.5,8651.5,25650,0.00045062756,0.0010346819,-0.0014387899,0.00036985773,-0.0025059807,-0.0015608916,-0.00875094,-0.0010897468,1944.5,516.5,0.0055323257,0.003091159,-0.011453804,5064.5,6757,5372.5,81,24.5,230,1387.5,315,101.5,192,261,2464,1678.5,0.0065364228,0.0004364037,1767.5,2688,1548,4943,3050,0.0013965857,-0.0049795914,-0.009307451,9696,-0.00010060823,-0.0005570723,130.5,873,603.5,2756.5,5118,0.008654359,7324,5362,5381.5,0.00014012711,0.0019119474,0.0012447633,-0.0032474697,-0.0011593514,0.0033985141,-0.0034940564,-0.0048791706,0.0019267027,0.0070747673,0.0015090188,-0.0023695861,-0.0008231599,-0.0038257563,0.002314262,7.992729e-05,-0.0010340746,-0.0033288316,-0.0039176005,-0.005854673,0.004543833,0.0020840939,-0.00010960462,-0.0028707832,-0.00035995038,-0.0023521439,0.0012777601,3.2271168e-05,0.00019057076,-0.0018705232,-0.0011608998,-0.0036624072,0.0031322755,0.0063304417,-0.00048472933,-0.008845571,0.0028811647,0.0003655243,-0.0021131171,7.61902e-05,-0.015247482,-0.0016540996,0.0041457573,0.0015796627,0.0006532531,0.010661175,-0.004059148,-1.505999e-05}, {7,2,7,2,2,0,0,0,255,1,4,1,0,0,2,5,255,255,4,0,0,0,255,255,255,7,4,2,2,2,4,1,4,2,0,0,0,255,255,2,0,4,7,1,0,0,2,0,1,2,1,255,255,255,255,5,1,4,0,255,1,0,0,255,255,255,255,255,255,255,255,4,0,255,255,255,2,4,2,0,5,4,0,1,7,1,5,2,1,255,255,1,0,7,2,5,255,255,255,0,255,255,0,2,0,7,0,255,0,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,25,27,29,65535,65535,31,33,35,37,65535,65535,65535,39,41,43,45,47,49,51,53,55,57,59,61,65535,65535,63,65,67,69,71,73,75,77,79,81,83,85,65535,65535,65535,65535,87,89,91,93,65535,95,97,99,65535,65535,65535,65535,65535,65535,65535,65535,101,103,65535,65535,65535,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,65535,131,133,135,137,139,65535,65535,65535,141,65535,65535,143,145,147,149,151,65535,153,155,157,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,26,28,30,65535,65535,32,34,36,38,65535,65535,65535,40,42,44,46,48,50,52,54,56,58,60,62,65535,65535,64,66,68,70,72,74,76,78,80,82,84,86,65535,65535,65535,65535,88,90,92,94,65535,96,98,100,65535,65535,65535,65535,65535,65535,65535,65535,102,104,65535,65535,65535,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,65535,132,134,136,138,140,65535,65535,65535,142,65535,65535,144,146,148,150,152,65535,154,156,158,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8076.5,7173.5,8619.5,6189,8182,8545,8626.5,6136.5,9438.5,7417.5,8532.5,6186,8200,10.5,16.5,6850,8050,5550.5,11333,7022,6968,6999,12.5,8580.5,7792.5,0.016451651,9093,0.0005107,13.5,9363.5,9076.5,6712,7070.5,0.0074239,15.5,6043.5,7582,6965,13267,6989.5,7303.5,5291.5,8278,7453,7261,4.5,15.5,12.5,2426.5,6674,2.5,7908,9887,0.00694292,0.004432538,10045.5,9364.5,8714.5,11082,5564.5,9416.5,6892.5,7077,8118.5,7420.5,5130.5,4986,1.5,15.5,6614,9694.5,3.5,6289.5,6470.5,15.5,7736.5,9502,10.5,-0.0074960375,7714.5,7962.5,11,6.5,12.5,10506,7902.5,9572,14.5,17.5,2120.5,8171,-0.011052004,7.5,-0.0055740885,7141,-0.015587713,8289,8398.5,8443,16.5,12374.5,6536.5,4.5,10.5,29400.5,8711,9374.5,6719.5,10734.5,5888,9958.5,5591.5,-0.00018171512,16.5,-0.015436353,0.008771077,4171,9.5,6153.5,0.0063768947,0.0019418504,13.5,5263.5,7078,3.5,6549,7178,7946.5,6751,6445,7436.5,13.5,7656,-0.014848545,11679.5,10.5,0.0056494223,4162,7203.5,7.5,0.0084034735,6548.5,-0.016438818,8.5,12,-0.0035103296,7752,15.5,0.019682288,13.5,0.0005331903,0.006266586,0.0016413812,-0.0026290838,11.5,-0.0037269068,-0.00066312955,7414,-0.0063947435,9033,0.0067592436,7505.5,0.0038032555,7754,-0.0063360515,7902.5,7328,1994.5,5244.5,5571.5,3911,-0.00970332,8604.5,-0.012675672,-0.019949114,8270.5,7471.5,5397,8797.5,-0.015235162,-0.0026958648,10.5,0.0047325958,12104,0.0019333031,6476,6.5,13692.5,10556,0.016545061,0.004468886,28854,18097.5,7888,3939,6992.5,9055,9288.5,11577,8609.5,19733,3.5109344e-05,0.004581762,0.0010221303,-0.004580557,0.010934453,0.007263104,-0.0035260997,0.003375296,-0.0025214702,4.497224e-05,0.0034037721,0.0008463875,0.00029534203,-0.001245744,-0.0052799624,0.00061204535,0.003282452,-3.5021192e-05,-0.0032172315,0.001048013,-0.0031764058,0.010141347,0.0018175598,0.010629362,-0.0030111114,-0.010813202,-0.0046782955,0.0003437765,0.011469869,0.0016396694,0.004963392,0.009135877,0.0182508,0.011590174,0.0017727802,-0.0054368223,0.0052201166,0.0011059918,0.0011744958,-0.00440825,0.002778967,0.0007505382,0.00035859898,0.0018050822,0.0009810086,-0.009089961,0.005859962,0.0037699328,-0.0072105858,-0.011838556,-0.00041965078,-0.001123234,0.0021634258,-0.00057244726,-0.0027902145,0.002071884,0.0046472917,0.008342238,-0.007966734,-0.004589323,0.0014366395,0.0031931282,-0.011985116,-0.019921416,0.0028586062,0.004311576,-0.0001287847,0.0018141806,-0.003588941,-0.0011365821,0.0056036306,0.002954942,0.00048523612,-0.0034939665,-0.00048299186,0.007829792,0.004390941,-0.0025732145,9.36338e-05,-0.006460238,0.0003502008,0.0048932214,-0.0031549674,0.0020167544,-0.0055389754,-0.002384389,0.0011501109,-0.0010022748,0.0013539802,-0.006953437,0.0003210952,0.010317519,0.0029376834,0.001622696,0.0006693099,-0.00082783,-0.00012148965,0.009238712,-0.009104217,-0.0022618293,0.00153546,0.0035602269,0.0029879732,-0.0003659791,0.00012174334,0.0023492149,-0.00066915597,6.819038e-06,-0.00023477442,-0.0036145195,-0.00026626742,0.006505616,0.0009928899,-0.012433292,0.0012133702,0.0035010644,-0.0035258539,0.00034836735,-0.0030670322,-0.0008663431,0.0038444884,0.0012625465,-0.0005932718,7.431726e-05}, {0,0,0,0,7,1,0,0,3,7,1,3,0,8,8,2,7,3,2,7,2,1,8,0,2,255,1,255,8,0,0,2,2,255,8,1,1,1,3,7,7,2,3,0,0,8,8,8,1,2,8,7,1,255,255,1,0,1,1,2,7,2,2,3,2,2,2,8,8,0,3,8,0,7,8,0,1,8,255,1,0,8,8,8,7,2,1,8,8,7,2,255,8,255,7,255,7,0,2,8,7,3,8,8,2,0,1,1,0,0,7,0,255,8,255,255,3,8,0,255,255,8,2,0,8,1,1,1,0,0,7,8,1,255,3,8,255,7,1,8,255,3,255,8,8,255,0,8,255,8,255,255,255,255,8,255,255,2,255,1,255,2,255,0,255,2,0,7,2,3,1,255,0,255,255,0,1,3,1,255,255,8,255,7,255,3,8,7,1,255,255,0,3,2,1,7,0,0,2,2,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,65535,53,55,57,59,61,65535,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,65535,147,149,151,153,155,157,159,161,163,165,167,169,65535,171,65535,173,65535,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,65535,207,65535,65535,209,211,213,65535,65535,215,217,219,221,223,225,227,229,231,233,235,237,65535,239,241,65535,243,245,247,65535,249,65535,251,253,65535,255,257,65535,259,65535,65535,65535,65535,261,65535,65535,263,65535,265,65535,267,65535,269,65535,271,273,275,277,279,281,65535,283,65535,65535,285,287,289,291,65535,65535,293,65535,295,65535,297,299,301,303,65535,65535,305,307,309,311,313,315,317,319,321,323,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,65535,54,56,58,60,62,65535,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,65535,148,150,152,154,156,158,160,162,164,166,168,170,65535,172,65535,174,65535,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,65535,208,65535,65535,210,212,214,65535,65535,216,218,220,222,224,226,228,230,232,234,236,238,65535,240,242,65535,244,246,248,65535,250,65535,252,254,65535,256,258,65535,260,65535,65535,65535,65535,262,65535,65535,264,65535,266,65535,268,65535,270,65535,272,274,276,278,280,282,65535,284,65535,65535,286,288,290,292,65535,65535,294,65535,296,65535,298,300,302,304,65535,65535,306,308,310,312,314,316,318,320,322,324,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8085.5,283.5,8482.5,276.5,15.5,8942.5,8813.5,228.5,373.5,1678,1593,5571.5,9542,8742.5,9275.5,169.5,20.5,-0.011429637,-0.0068863216,14.5,1720.5,1088,2062,11.5,7896.5,0.008323524,8457,7927,8760,8750.5,9319.5,78.5,48.5,6.5,33,533,1511.5,11.5,7.5,1004.5,2018.5,1695.5,2638.5,5498,3244.5,5.5,8133,17.5,12,7320.5,9461,6534.5,6.5,9282.5,8793,6373.5,9363.5,18.5,131,0.008977135,146,4.5,221.5,868,74.5,293.5,1036.5,1178.5,1389,7.5,-0.0021598367,4314,3805,897.5,1137.5,3725,5459.5,1415.5,3377.5,1935.5,4240.5,4761,8.5,2101,5338.5,-0.007214413,8337,-0.018892108,7515,4.5,0.0029377795,0.00044709543,16.5,10014.5,14,-0.009578531,3.5,11.5,7.5,8521,8808.5,8585,-0.014591987,0.009822504,9143,6103,7244,6211,9364.5,11.5,49,21.5,147.5,6.5,7,481.5,74.5,8.5,247.5,0.0011233841,0.022893647,-0.006490635,208,169,425,1010.5,1366.5,562.5,1841.5,2860,2337.5,-0.0035694563,-0.010702707,4226,6193,3642.5,5092.5,805,862.5,1020,1071.5,996.5,17.5,1220,-0.0017939939,18.5,1605,3759,19.5,3626.5,2977,4110.5,2273,4469.5,-0.008547728,340.5,8294.5,1950,18.5,4387.5,8223.5,6494,6982.5,8349.5,12.5,8400.5,15.5,-0.0008621498,-0.0022771927,6012,-0.004015781,0.01386734,0.0051275296,0.0016650787,17.5,0.011531278,0.005751132,0.004495361,0.0065011396,3.5,0.00026758018,8953.5,0.008621584,7259,-0.0114031425,-0.0048399633,10712.5,9,0.008280779,-0.005702374,17.5,7.5,9071,14,8645.5,-0.0004682459,0.0008913109,0.0002341429,-0.0021025897,-0.0001398976,0.008299746,0.0106049655,0.00080031547,-0.0076158196,0.0020634423,0.0058010495,0.002752413,-0.0019914347,0.005073915,-0.0017648081,0.0044972626,-0.0028185253,-0.000599042,-0.0015906002,-0.0084926495,-0.00039919544,0.0037140795,0.00044477187,-0.0026331132,0.008095434,0.0029494602,0.0002178233,-0.003366454,0.0023344064,0.00038790834,0.0028650535,-0.0011191414,0.011631408,0.0028258588,-0.0014602178,-0.0040682126,-0.0005304772,0.0018827835,5.2201416e-05,-0.0031236517,0.0013592916,-0.00013514543,-0.00069789164,0.0024920735,-0.0014807422,-0.0003612295,-0.0005666606,0.006910009,-0.0021188238,-0.017484102,0.015118559,0.0061183865,0.006088834,-0.0048339725,0.0025366608,-0.0077549643,-0.002791558,0.0020401364,-0.014280358,-0.022903375,-0.0008136683,-0.0073407516,0.0018482975,-0.0037496642,0.008959301,0.00073735096,-0.0026271606,0.0045466837,0.0033374752,-0.00035534299,-0.006583912,0.00040773294,0.0016277767,0.0066540088,0.006487891,0.00010326272,-0.0010514649,-0.006298569,-0.0008074,0.0022433966,0.00083241327,-0.0033989125,-8.706338e-05,0.0038726479,0.0003523613,-0.004930253,0.0015253284,0.004944809,0.0016165484,-0.0028623352,0.003397854,0.00014944597,-0.005052234,-0.00042373856,-0.0077031786,-0.011645265,0.0011333355,-0.0015429112,0.0013528612,0.0025280355,1.9924144e-05,0.000984351,-0.0005818335,0.0010120928,-0.00033312218,0.000984779,-0.006537019,-0.002289958,0.0027371424,-0.000663082,-0.0021903957,0.006618902,0.0014261171,-0.00013138782,0.005266772,-0.0008866938,0.00012481245,0.0030997281,-0.0010999555,0.0023478917,-0.007395332,0.00032603208,0.011818616,0.0038383768,0.00016919522,-5.2936968e-05}, {0,3,0,3,8,1,0,0,0,7,7,3,1,0,0,0,8,255,255,8,7,7,3,8,1,255,0,7,0,5,0,1,1,8,7,0,3,8,8,7,1,5,5,1,7,8,1,8,8,7,5,5,8,3,1,1,0,8,7,255,1,8,5,1,3,0,7,0,5,8,255,1,3,7,5,0,0,3,5,5,1,5,8,7,3,255,0,255,7,8,255,255,8,5,8,255,8,8,8,1,0,5,255,255,5,1,1,5,0,8,0,8,0,8,8,7,3,8,3,255,255,255,7,0,0,7,7,0,0,1,5,255,255,1,1,3,7,7,5,7,1,0,8,5,255,8,5,0,8,7,7,1,7,1,255,7,0,7,8,1,0,1,1,0,8,0,8,255,255,1,255,255,255,255,8,255,255,255,255,8,255,1,255,7,255,255,5,8,255,255,8,8,5,8,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,65535,113,115,117,119,121,123,125,127,129,131,65535,133,135,137,139,141,143,145,147,149,151,153,155,157,159,65535,161,65535,163,165,65535,65535,167,169,171,65535,173,175,177,179,181,183,65535,65535,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,65535,65535,65535,215,217,219,221,223,225,227,229,231,65535,65535,233,235,237,239,241,243,245,247,249,251,253,65535,255,257,259,261,263,265,267,269,271,65535,273,275,277,279,281,283,285,287,289,291,293,295,65535,65535,297,65535,65535,65535,65535,299,65535,65535,65535,65535,301,65535,303,65535,305,65535,65535,307,309,65535,65535,311,313,315,317,319,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,65535,114,116,118,120,122,124,126,128,130,132,65535,134,136,138,140,142,144,146,148,150,152,154,156,158,160,65535,162,65535,164,166,65535,65535,168,170,172,65535,174,176,178,180,182,184,65535,65535,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,65535,65535,65535,216,218,220,222,224,226,228,230,232,65535,65535,234,236,238,240,242,244,246,248,250,252,254,65535,256,258,260,262,264,266,268,270,272,65535,274,276,278,280,282,284,286,288,290,292,294,296,65535,65535,298,65535,65535,65535,65535,300,65535,65535,65535,65535,302,65535,304,65535,306,65535,65535,308,310,65535,65535,312,314,316,318,320,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({228.5,114,349,6.5,51.5,722.5,422.5,184,5720,5.5,177,74,20.5,273.5,5813,52.5,220.5,18.5,29.5,117,59.5,94,289.5,284.5,305,33,31.5,-0.0056616585,20.5,5372.5,5954,105,62,403,601.5,85,102,15.5,-0.0027590168,0.010681734,3.5,24,121,55.5,12.5,58,18.5,-0.0031716104,13.5,262,15.5,48.5,18.5,0.023978947,797,412.5,0.008742626,5329.5,4951.5,15.5,5972,67.5,137,0.011681333,67,-0.0069849864,-0.0043890933,304.5,33,89,235.5,50.5,1638,0.00093361514,0.008259732,-0.0020917126,-6.5872824e-05,-0.0029393786,-0.008017571,-0.0061707743,15.5,10.5,-0.005141651,775.5,524.5,-0.0064609176,200.5,15.5,1983.5,-0.0040686824,-0.009573192,2.5,310.5,326,-0.01082394,26,6,43.5,109,-0.007840194,-0.003838228,15.5,0.0077034305,7320.5,5999,5787.5,16.5,5849.5,6931,-0.016339129,5042.5,22,-0.0052248174,-0.011540559,-0.0005084965,-0.002984327,385.5,179.5,506.5,3.5,73,50.5,0.0055608884,524,11.5,26.5,22,78,264,27,27,6.5,0.0025832767,130.5,7.5,20.5,18.5,0.007620836,3.5,3059.5,0.0051816492,-0.0038537309,-0.009588423,411,6.5,8.5,17.5,5.5,0.0020915584,-0.002885036,24233,-0.0012901638,9.5,0.005971603,172.5,-0.005707733,-0.0010079746,187,693.5,1.5,1.5,5038.5,9365,5641.5,5689,2.5,3910,6042,5960,5927,5361.5,4077.5,5330.5,-0.00034365436,0.0016892649,0.003934517,-0.0013275308,-0.0034466907,0.00014702011,-0.0020021226,-0.004839143,0.0031418565,0.0003666973,-0.0009330716,0.00043198813,-4.9856586e-05,-0.0015428301,0.0013659403,0.0060306746,-0.0023316848,0.00094119244,-2.5205825e-06,-0.0025656985,-0.0011851812,0.003408163,-0.0059650037,-0.0021831363,-0.0015569418,0.0033016775,0.0001333487,-0.0032131355,-0.0011340276,0.0062078796,0.0027893062,-0.002398819,0.0023829055,0.0065617063,-0.0016402983,-2.1182837e-05,0.008112788,0.0028553936,0.0012363994,0.007054513,0.001508606,0.003242526,-0.0025613662,0.0032372833,-0.004943601,7.253811e-05,0.0008153504,-0.0014907714,0.0034278107,-0.0036431563,0.0035997143,0.001977761,-0.004956049,-0.0010558496,0.0044372,-0.0004731752,-0.012135663,-0.005480033,0.0012968451,-0.00051792833,0.004948113,0.001568838,-0.0038843655,0.002044325,0.0018790445,-1.6823587e-05,-0.0069337036,-0.0007457364,0.003114217,0.011850011,0.0027113003,-0.00113997,0.00029009054,0.0059223925,0.007848319,0.0010497395,-0.0027349468,-0.0004970857,0.011072085,-0.0028660372,0.002042197,0.008734413,0.0011288424,-0.0019601353,0.005063006,0.011765414,-0.0042037037,0.00082437706,-1.6178736e-06,-0.0021091218,0.0028325093,-9.665101e-06}, {0,0,4,8,6,0,4,6,7,8,0,2,8,6,2,7,6,8,0,0,2,4,4,0,4,7,6,255,8,2,2,2,6,2,2,2,4,8,255,255,8,7,0,2,8,2,8,255,8,4,8,4,8,255,2,4,255,2,0,8,2,0,2,255,7,255,255,2,0,0,2,7,6,255,255,255,255,255,255,255,8,8,255,2,4,255,0,8,7,255,255,8,2,4,255,4,8,6,4,255,255,8,255,6,4,6,8,2,0,255,0,2,255,255,255,255,4,7,4,8,0,7,255,4,8,7,2,0,2,7,7,8,255,0,8,8,8,255,8,7,255,255,255,2,8,8,8,8,255,255,0,255,8,255,4,255,255,7,6,8,8,4,0,4,7,8,6,7,0,2,4,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,55,57,59,61,63,65,67,69,71,73,65535,65535,75,77,79,81,83,85,87,65535,89,91,93,95,97,65535,99,101,65535,103,105,107,109,111,113,65535,115,65535,65535,117,119,121,123,125,127,65535,65535,65535,65535,65535,65535,65535,129,131,65535,133,135,65535,137,139,141,65535,65535,143,145,147,65535,149,151,153,155,65535,65535,157,65535,159,161,163,165,167,169,65535,171,173,65535,65535,65535,65535,175,177,179,181,183,185,65535,187,189,191,193,195,197,199,201,203,65535,205,207,209,211,65535,213,215,65535,65535,65535,217,219,221,223,225,65535,65535,227,65535,229,65535,231,65535,65535,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,56,58,60,62,64,66,68,70,72,74,65535,65535,76,78,80,82,84,86,88,65535,90,92,94,96,98,65535,100,102,65535,104,106,108,110,112,114,65535,116,65535,65535,118,120,122,124,126,128,65535,65535,65535,65535,65535,65535,65535,130,132,65535,134,136,65535,138,140,142,65535,65535,144,146,148,65535,150,152,154,156,65535,65535,158,65535,160,162,164,166,168,170,65535,172,174,65535,65535,65535,65535,176,178,180,182,184,186,65535,188,190,192,194,196,198,200,202,204,65535,206,208,210,212,65535,214,216,65535,65535,65535,218,220,222,224,226,65535,65535,228,65535,230,65535,232,65535,65535,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({18.5,8078,388,8014,18341,368.5,30,7912,8015.5,15862,21305,22,2575,0.009856324,57,7483.5,5353,12.5,7942.5,1.5,16788.5,21196.5,22527,22,25.5,1331.5,5965.5,5449,456.5,6301.5,6825.5,0.004999862,6781,0.014940265,0.006063742,7734.5,4.5,10305,15.5,12840,16677,17682,21226,18498,9113.5,-0.0039816345,100.5,20.5,27.5,932,305.5,20.5,121,-0.02134866,-0.000328275,425,3673,6678.5,10408.5,7137.5,9673,6919,8439.5,-0.0007443839,0.004546098,-0.00050735445,-0.002168847,9491,11460,6501.5,8172,-0.00018495959,9901.5,16234.5,18273.5,12760,18033.5,0.0068272874,0.012409849,13578.5,22557.5,13450,13659.5,0.0039914856,20.5,28,30,38.5,24,-0.0062848167,-0.00048981846,-0.008001461,-0.017950794,2942,664.5,-0.007370318,-0.0035543602,-0.00086182094,0.022302315,719.5,7514,6243,6088.5,6293,8186,7759,7360,9361,15.5,-0.01570963,-0.001811053,13.5,-0.008521183,11139,9818.5,13918.5,14305.5,6491,7611.5,6194.5,11529,-0.0020917167,15244,16105,18038.5,12474.5,18312.5,9.5,19654,18928,20151.5,10911,13853.5,22055.5,6.5,26387,27844.5,12572,21346.5,-0.0007242191,-0.0055766744,0.0017994998,0.008671587,22.5,0.0050134966,27.5,24,0.0044438527,34,-0.0037822395,5.1563275e-05,0.0041401805,0.014077516,504,632,7468.5,10495.5,2.25982e-05,0.0053010248,0.0006710691,0.0067906077,0.0006799854,-0.0034333493,0.00021775962,0.0037312463,8.3049716e-05,-0.010057726,0.008434698,0.0005475134,0.0021825728,0.008769689,0.0012721841,-0.0010177552,0.0018248605,-0.0015374691,0.0036603827,-0.00032250266,-0.024841819,0.0011464459,0.009694585,-0.0027051547,0.017440327,0.009542374,0.00040132707,0.010157244,-0.0054660006,-0.0004822978,-6.92954e-05,-0.00359757,0.0017601465,0.00018550821,-0.006338814,-0.0034162886,-0.004400686,0.004465762,-0.0035529875,-0.012064405,-0.0012730373,0.0024056232,-0.010573799,-0.0003684126,-0.000720615,0.0028472627,-0.00786624,-3.745916e-05,0.011831517,0.0058225314,0.0020449606,0.0006382722,-0.0013374507,-0.0059588645,0.0048481887,-0.0001640962,-0.0059165237,-0.011485077,0.0015107192,-0.0010350735,0.006559867,0.003877879,0.0013850593,0.005518618,0.00027057203,-0.0018900167,0.0041249613,6.623391e-05,-0.0008334761,0.000405049,-0.0034973864,0.004356548,-0.0019663284,-0.011664693,-0.0038491765,4.733055e-06,0.00041579487,-0.005953418,0.012864947,0.0014547125,-0.00054490037,-0.0072577703,0.001116779,-0.0001632691}, {8,7,0,7,0,5,6,7,7,0,0,0,6,255,6,6,5,8,5,8,6,0,0,6,3,6,7,0,0,7,3,255,5,255,255,3,8,0,8,6,0,6,0,7,7,255,6,5,5,6,3,8,0,255,255,0,0,6,0,5,0,0,5,255,255,255,255,6,7,3,5,255,3,0,0,3,6,255,255,5,3,3,7,255,8,0,7,3,7,255,255,255,255,5,3,255,255,255,255,3,7,7,7,6,5,7,5,0,8,255,255,8,255,5,7,0,5,3,3,0,7,255,7,0,3,3,0,8,3,0,0,5,7,0,8,0,0,5,6,255,255,255,255,3,255,3,5,255,7,255,255,255,255,7,0,7,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,65535,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,65535,61,65535,65535,63,65,67,69,71,73,75,77,79,81,65535,83,85,87,89,91,93,95,65535,65535,97,99,101,103,105,107,109,111,65535,65535,65535,65535,113,115,117,119,65535,121,123,125,127,129,65535,65535,131,133,135,137,65535,139,141,143,145,147,65535,65535,65535,65535,149,151,65535,65535,65535,65535,153,155,157,159,161,163,165,167,169,171,65535,65535,173,65535,175,177,179,181,183,185,187,189,65535,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,65535,65535,65535,225,65535,227,229,65535,231,65535,65535,65535,65535,233,235,237,239,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,65535,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,65535,62,65535,65535,64,66,68,70,72,74,76,78,80,82,65535,84,86,88,90,92,94,96,65535,65535,98,100,102,104,106,108,110,112,65535,65535,65535,65535,114,116,118,120,65535,122,124,126,128,130,65535,65535,132,134,136,138,65535,140,142,144,146,148,65535,65535,65535,65535,150,152,65535,65535,65535,65535,154,156,158,160,162,164,166,168,170,172,65535,65535,174,65535,176,178,180,182,184,186,188,190,65535,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,65535,65535,65535,226,65535,228,230,65535,232,65535,65535,65535,65535,234,236,238,240,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1695.5,1609,2459.5,15.5,18.5,16.5,2464,443.5,1432.5,4.5,1651,897.5,897.5,13,403.5,668.5,791.5,1260.5,3571.5,0.007836774,10.5,0.0068300827,0.018605411,2399,2688,18.5,1393,0.004859699,0.0020995017,18.5,705,1299,422.5,6.5,4667.5,1184,18.5,1637,0.00028288682,981,1139,14.5,14.5,1528,2452.5,788.5,1284.5,-0.018694093,1795.5,16.5,16363,544,2497,62.5,4.5,341.5,-0.015054612,516,531.5,1536.5,1738,366,5628,1334.5,834,2748.5,-0.013369647,-0.012164167,0.0033672776,15.5,15.5,6.5,0.007709122,6.5,-0.0049475036,1172,1766,4.5,3405,-0.0024349573,0.0073828595,1332.5,0.01789311,3576.5,2515.5,3511.5,106.5,5253.5,0.0016706669,18.5,17,5.5,2655,55.5,30,-0.0062079853,12.5,4.5,402.5,-0.014904995,705.5,537.5,874,1264,2.5,8570.5,379.5,443,641,1161.5,0.0009288814,0.004909903,-0.005822075,-0.00038499033,6246,1183,-0.00753098,0.0023674942,0.006380343,13.5,-0.010964199,997.5,1372.5,2.5,1284.5,0.0066619474,3.5,7,2349,2.5,13.5,11111,2174,0.0072297156,0.0017771336,0.012282189,-0.00024779947,1643,2885.5,-0.0037320275,1.5,0.006616828,0.0005700939,-0.002518619,-0.008045532,7.5,-0.0028523414,12.5,0.006783253,-0.006235629,2486,15.5,17.5,7.0312976e-06,-0.0031606448,-0.0008132115,0.00080901553,-0.0020960825,-0.00038217445,-0.0027668509,0.00044874504,-0.011807379,-0.0023475767,9.1864335e-05,-0.0028392158,0.009531859,0.0049933386,-0.0012345916,0.0012724118,0.0028365385,-0.0009035555,0.013402985,0.0031889752,-0.004644239,-0.0002337155,0.00020441336,0.0018635897,-1.0494239e-05,0.0016461415,0.00089949305,-0.0025116547,-0.0056308764,-0.018412117,0.01477949,0.000746417,-0.0021620074,0.0016995261,0.0022451447,-0.0014755811,-0.014830126,0.0038643584,-0.012996142,-0.005078628,0.00013159188,-0.0043233274,0.0016644428,-0.0010397858,-3.8543672e-05,0.00333054,-0.0038677647,-0.00018828364,0.0010326072,-0.0010410221,-0.01054065,0.010630782,-0.012362996,-0.0005424271,0.0020376493,0.0009297849,-0.0011567536,-0.0057492745,0.0030410686,-0.006574303,0.0059046163,-0.0008398394,0.0036283766,-0.0006456484,-0.0012347122,0.0042382753,0.0026488206,-0.0025755225,-0.0004454833,-0.0035506175,0.00047900193,0.003622346,3.754974e-05,-0.00012788817}, {2,2,2,8,8,8,2,7,2,8,2,7,7,8,7,6,0,2,0,255,8,255,255,0,6,8,6,255,255,8,7,2,7,8,0,2,8,0,255,5,5,8,8,6,7,7,5,255,2,8,0,7,2,0,8,5,255,6,7,0,6,7,0,2,0,6,255,255,255,8,8,8,255,8,255,5,2,8,6,255,255,6,255,5,6,0,7,0,255,8,8,8,2,0,6,255,8,8,5,255,2,2,6,2,8,5,2,0,0,5,255,255,255,255,0,6,255,255,255,8,255,5,6,8,5,255,8,8,2,8,8,0,2,255,255,255,255,5,0,255,8,255,255,255,255,8,255,8,255,255,2,8,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,65535,65535,41,43,45,47,65535,65535,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,75,77,79,81,65535,83,85,87,89,91,93,95,97,65535,99,101,103,105,107,109,111,113,115,65535,65535,65535,117,119,121,65535,123,65535,125,127,129,131,65535,65535,133,65535,135,137,139,141,143,65535,145,147,149,151,153,155,65535,157,159,161,65535,163,165,167,169,171,173,175,177,179,181,65535,65535,65535,65535,183,185,65535,65535,65535,187,65535,189,191,193,195,65535,197,199,201,203,205,207,209,65535,65535,65535,65535,211,213,65535,215,65535,65535,65535,65535,217,65535,219,65535,65535,221,223,225,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,65535,65535,42,44,46,48,65535,65535,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,76,78,80,82,65535,84,86,88,90,92,94,96,98,65535,100,102,104,106,108,110,112,114,116,65535,65535,65535,118,120,122,65535,124,65535,126,128,130,132,65535,65535,134,65535,136,138,140,142,144,65535,146,148,150,152,154,156,65535,158,160,162,65535,164,166,168,170,172,174,176,178,180,182,65535,65535,65535,65535,184,186,65535,65535,65535,188,65535,190,192,194,196,65535,198,200,202,204,206,208,210,65535,65535,65535,65535,212,214,65535,216,65535,65535,65535,65535,218,65535,220,65535,65535,222,224,226,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11312,2883,11644.5,2596,7097.5,6919.5,11068,10782,12035,7070.5,7190.5,9949,12633,10384,14898.5,2158.5,11397,2552.5,2879,7601,7078,8554.5,7254.5,0.0061925496,0.0036793598,13147,11602.5,10443.5,10244,9235,14908.5,2002,1726,11335.5,-0.0031399261,2220,10639,11776,2894.5,5949,2753,-0.014462016,7002,8703,10317,7066,7664,12051,-0.004543492,14017.5,0.0081090545,2309,10347.5,0.0047976384,0.0025686116,8635,13497,0.013441232,15331.5,1995,1900,0.0040434166,2179.5,2459.5,0.00024371513,2700.5,2670,11760,10536.5,-0.0036397453,13568,12699,0.002880953,6413.5,7428.5,1424.5,7484.5,6323.5,0.0059371083,6662,0.015212133,-0.0061509223,-0.00075181405,7112.5,5373,6368,7674.5,10860.5,7353,0.0062550306,24264,0.0047021853,10959.5,0.0089535,10075.5,11350.5,0.005444121,13061.5,14438,13084,16506.5,2410.5,0.005005229,7187,9454,2160,3267.5,2415,10986.5,0.0017773317,-0.00045523673,9850.5,-0.0018503892,2328.5,-0.0023735466,11599.5,11998,12642.5,-0.0033115153,0.00048063157,-0.00030832188,4885,6048,7152,9061.5,-0.0005068745,-0.001228166,8236,7722.5,-0.004015343,-0.0012757895,-0.0028716016,7159.5,0.0044124792,7241.5,-0.0018440118,7343,7875,8512.5,-0.014036648,8346,7731.5,11505.5,0.002131207,9367.5,11606,13910,12506.5,11801,10476.5,10177.5,12288,6406.5,12788.5,13677,15458,15210.5,0.014518722,18434.5,4175.5,20591,8.517503e-05,-0.00043597692,0.0006011717,-0.0010255529,-0.0044501647,-0.0013500854,-0.0009390921,0.0032103292,0.00012892041,0.0013658638,-0.0017492779,-0.0024230476,-0.002310075,-0.0012465941,0.00012810055,-0.0013097383,-0.00047240016,0.0018172901,0.0026412508,0.0010457069,0.005576286,0.0038833425,7.195206e-05,-0.00093805307,0.00049233926,-0.0009208711,-3.7518757e-07,0.0032631014,-0.000507635,0.004330789,-0.0066313283,0.00086839154,0.0032674656,0.0012476916,-9.095602e-05,-0.0005359844,0.005657992,-0.00048725223,-0.0010354255,-0.0049529728,-0.009258605,-0.015811596,0.0014563749,0.026577806,-0.0024664337,0.0016273949,-2.3140099e-05,-0.00056521007,0.004623162,0.0005226695,-0.001358702,0.00025876806,-0.00027983205,-0.0017479595,0.0012264694,0.0069166124,0.00012873785,-0.0021380926,0.00039414363,0.002722253,-0.0004549394,0.00010449551,0.0005027233,0.0023609349,0.0050368584,0.002589918,-0.0003161232,-0.004105777,-0.00028808005,0.002268523,-0.00589041,0.0054450314,-0.01636373,-0.0075570317,-7.396138e-05,0.00788704,-0.005221316,-0.0006146106,-0.002171671,0.0051615904,-0.00016382811,-0.0046299645,0.0018558943,-9.096642e-06}, {3,5,3,5,4,7,2,4,4,4,4,0,0,0,2,5,0,3,7,5,4,0,4,255,255,4,3,2,2,0,2,5,0,0,255,3,0,0,3,4,0,255,7,2,0,5,4,7,255,0,255,2,7,255,255,0,3,255,0,5,3,255,5,5,255,5,5,2,4,255,0,2,255,7,3,0,2,0,255,0,255,255,255,0,0,7,4,2,0,255,2,255,5,255,0,7,255,7,4,3,4,4,255,0,0,7,3,5,0,255,255,0,255,7,255,0,4,4,255,255,255,0,3,5,3,255,255,5,0,255,255,255,2,255,4,255,5,3,5,255,3,4,7,255,4,7,5,7,5,4,0,2,4,7,7,3,3,255,3,5,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,65535,47,49,51,53,55,57,59,61,63,65535,65,67,69,71,73,75,65535,77,79,81,83,85,87,65535,89,65535,91,93,65535,65535,95,97,65535,99,101,103,65535,105,107,65535,109,111,113,115,65535,117,119,65535,121,123,125,127,129,65535,131,65535,65535,65535,133,135,137,139,141,143,65535,145,65535,147,65535,149,151,65535,153,155,157,159,161,65535,163,165,167,169,171,173,65535,65535,175,65535,177,65535,179,181,183,65535,65535,65535,185,187,189,191,65535,65535,193,195,65535,65535,65535,197,65535,199,65535,201,203,205,65535,207,209,211,65535,213,215,217,219,221,223,225,227,229,231,233,235,237,65535,239,241,243,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,65535,48,50,52,54,56,58,60,62,64,65535,66,68,70,72,74,76,65535,78,80,82,84,86,88,65535,90,65535,92,94,65535,65535,96,98,65535,100,102,104,65535,106,108,65535,110,112,114,116,65535,118,120,65535,122,124,126,128,130,65535,132,65535,65535,65535,134,136,138,140,142,144,65535,146,65535,148,65535,150,152,65535,154,156,158,160,162,65535,164,166,168,170,172,174,65535,65535,176,65535,178,65535,180,182,184,65535,65535,65535,186,188,190,192,65535,65535,194,196,65535,65535,65535,198,65535,200,65535,202,204,206,65535,208,210,212,65535,214,216,218,220,222,224,226,228,230,232,234,236,238,65535,240,242,244,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11504.5,9664.5,13231.5,9206.5,9671.5,13577.5,13681,8848.5,9208,5874,11478.5,10752,19312.5,27804.5,13889,8565,9410,0.011343861,6155,-0.0025285585,-0.0065321526,11449,11031.5,8769,16113,11596,19924.5,21554,28241.5,14620,16506.5,8110,8617,10047.5,9448.5,6209.5,8900,13618.5,14150.5,9252.5,10806.5,9971.5,9803,13066.5,14540,0.0012110758,14731.5,19269,26740,19414.5,22036.5,-0.013291798,-0.0072625624,13309,13788,15317,21711.5,6964.5,6346.5,4869,8101,9843,10639,9439,5782,4287,10085.5,9694,6411.5,18606.5,7906,0.013351917,0.0002566432,-0.01958383,10628,20841.5,13042,7075.5,9812,11474.5,11927.5,12772.5,11876,12952.5,25523.5,0.007838556,12526.5,25437,11839,0.009896968,0.0020226508,12898.5,0.007319908,-0.0063615376,25524.5,14345.5,13807.5,0.0008257269,0.012624688,13285.5,19011.5,17331,23914,6935.5,9749.5,8717.5,7568,8583,8783.5,-0.0041502398,8696.5,5491.5,-0.017223032,0.011446525,9111,9248,0.0050790706,9644.5,9565,2565,4763,10700.5,6559,8372,9212.5,10366.5,6513,11392,27116.5,0.0054971296,26205,13196,13439.5,20974,13226,11106.5,24051.5,-0.004509656,8844.5,9560.5,0.004746539,0.002239882,13268,10756,12029.5,12414,12307,0.0029227,13302.5,0.00023185169,0.0053441925,-0.0023514659,0.0023685752,0.013205783,0.00923742,-0.0030175939,-0.00424737,10027,11231.5,13256.5,13411.5,12413,13580.5,13250,6224,0.0033413458,0.0012539877,14066.5,5733.5,15171,0.0025435474,16421.5,20896.5,17257.5,23155,-8.098393e-05,-0.004970704,0.0006953943,-0.008320775,-0.0005815262,0.0017908997,-0.006434483,-0.0003636506,0.0049843458,0.0002963906,0.002741915,0.008139876,-0.0030718406,0.0007865891,-0.0018117306,-0.0059272363,0.00082001986,-0.0010282065,0.0010072509,0.0026012824,0.0019002497,-0.0010288734,0.00017046198,-0.0014320592,0.00041737064,-0.0014360946,0.0005623693,0.0026565485,-0.0027887675,-0.0069609717,-0.001963077,0.0015193991,-8.840642e-05,0.0068778805,0.0042584483,8.941573e-05,0.0022662773,0.0062111206,-0.006104363,0.00015870381,-0.00040947643,0.00037782718,-0.0022541673,-8.861599e-06,0.0013858345,0.003240047,-0.0013321317,-0.004487293,-0.0062912838,-0.012404534,0.0010941423,0.0003384468,5.030565e-05,0.003472538,-0.00472575,6.0272734e-05,0.002351518,3.4064267e-06,0.0021902714,0.00065301004,0.0030181555,-7.0826085e-05,-0.0121641215,-0.005419728,-0.004749712,-0.00016834648,0.0006508776,-0.0006483059,-0.006678467,-0.0017681936,-0.013232432,-0.0056777904,0.002384665,-0.0033821084,0.0010259898,-0.0019945265,0.001639173,0.00016528978,0.0047532152,0.0007286518,-0.005882648,-0.001401399,0.00015921246,-0.0018210266,-0.0026380531,-0.007380052,0.00020476947,-0.0016030766,0.0016916257,0.0008385085,-0.0014466149,-0.0068859975,-0.00039223526,0.001206593,-0.006296745,-0.0035126635,0.010498605,0.0067804516,0.000112538975,-0.0067435703,0.00023571179,-0.004832729,0.002232284,2.3672728e-05}, {1,0,5,4,0,4,5,0,4,5,7,2,0,4,5,0,2,255,1,255,255,7,0,4,1,1,7,2,0,7,4,4,2,1,2,5,5,5,0,2,5,5,5,2,2,255,2,4,0,2,2,255,255,7,5,0,4,4,7,7,4,7,1,2,5,7,4,4,1,2,1,255,255,255,0,0,5,0,0,0,1,7,0,2,0,255,5,0,7,255,255,4,255,255,0,1,5,255,255,1,7,5,4,4,7,4,2,0,0,255,0,7,255,255,0,0,255,0,2,5,5,5,7,0,0,4,1,2,4,255,2,4,4,2,7,1,4,255,2,0,255,255,0,5,0,1,5,255,2,255,255,255,255,255,255,255,255,7,5,5,5,7,5,1,2,255,255,2,2,5,255,1,0,1,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,65535,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,87,89,91,93,65535,65535,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,65535,65535,131,133,135,137,139,141,143,145,147,149,151,65535,153,155,157,65535,65535,159,65535,65535,161,163,165,65535,65535,167,169,171,173,175,177,179,181,183,185,65535,187,189,65535,65535,191,193,65535,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,223,225,227,229,231,65535,233,235,65535,65535,237,239,241,243,245,65535,247,65535,65535,65535,65535,65535,65535,65535,65535,249,251,253,255,257,259,261,263,65535,65535,265,267,269,65535,271,273,275,277,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,65535,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,88,90,92,94,65535,65535,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,65535,65535,132,134,136,138,140,142,144,146,148,150,152,65535,154,156,158,65535,65535,160,65535,65535,162,164,166,65535,65535,168,170,172,174,176,178,180,182,184,186,65535,188,190,65535,65535,192,194,65535,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,224,226,228,230,232,65535,234,236,65535,65535,238,240,242,244,246,65535,248,65535,65535,65535,65535,65535,65535,65535,65535,250,252,254,256,258,260,262,264,65535,65535,266,268,270,65535,272,274,276,278,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5614.5,5335.5,5615.5,5255,8612,0.010606415,5999,6516,5350.5,5870.5,10332,5068.5,6023.5,5229.5,8555.5,4426,-0.004868427,5339,5440,5179,12999.5,6310.5,6767.5,-0.008039073,6642,4730.5,5092,5038.5,8605.5,2490.5,8640.5,-0.010205667,5534,6458.5,5774,0.005680434,10568,9645.5,5375.5,5775.5,0.011339052,7864,5287.5,9190,6645.5,4455,4907.5,4975.5,6597.5,711.5,5228,1962,7514.5,5288.5,3270.5,4738.5,5062,5668.5,5598.5,6076.5,5919.5,5482,-0.004811171,5337.5,0.003612826,0.00010575104,10946.5,15887.5,5469.5,4505,3404,6113,0.01224146,5814.5,5890,8304,6504,0.010569841,7677,6687,0.007809376,4853,5281,5666.5,-0.00680348,4978,0.0013236922,-0.0054981853,7646.5,-0.01838185,8161,380,4772,5825.5,8425,0.0011648983,0.0028101509,0.0008872451,5319.5,5701,0.007268948,0.0022429447,5228.5,4659.5,7129,6328.5,6440.5,-0.011508239,-0.004826498,-0.0015538,8912.5,-0.008890047,-0.0138991205,7254,5434.5,-0.0033473705,13008.5,-0.00019554145,-0.00040740447,0.00014395428,4.78458e-05,4948.5,5756.5,0.002674532,0.007019186,5935.5,6660,-0.0051934887,-0.000984181,6056,6873.5,8616.5,7369.5,6502.5,0.007694345,8162,7747,-9.748424e-05,0.0022671062,-0.0026263378,0.00052815245,-0.009225241,-0.0031636364,0.0018827266,-0.00027072945,0.005634266,0.010355709,-0.0015067243,0.00040831053,-0.0030473236,0.0009180912,-0.000106268635,-0.0011277756,0.0028239323,0.00556964,-0.00029466316,-0.012473971,0.0015109328,-0.0001196165,-0.00042072317,-0.0013654979,0.005054747,0.0013063396,0.00036670454,-0.00050339143,-0.0015518889,0.0017341174,-0.008369238,-0.0021192022,-0.003024315,0.002338112,0.0034436502,0.0019923453,0.005369011,0.0024828312,0.0048942794,0.0015467195,0.0012219896,-0.0008851626,-0.0016995907,-0.0007948698,0.0011554237,0.0040056948,-0.0023813501,-4.0428884e-05,-0.0018143669,0.008150564,-0.011294837,-0.004532048,0.0016619737,-5.2405063e-05,0.00528723,-0.0013512586,-0.0003791245,-0.007915957,-0.001683942,-0.015247921,0.001455678,-0.0038832903,0.0006750654,-0.0010203038,-0.0016095665,-2.478939e-05}, {0,0,0,0,7,255,0,6,5,6,2,2,0,3,7,3,255,0,0,5,2,7,6,255,0,3,0,3,7,5,2,255,7,6,3,255,5,6,5,0,255,5,2,3,0,3,0,0,5,0,2,0,2,0,6,6,5,2,6,2,2,0,255,5,255,255,2,7,5,2,2,7,255,0,0,2,0,255,0,7,255,3,6,3,255,6,255,255,6,255,5,5,0,2,2,255,255,255,0,2,255,255,5,2,2,2,3,255,255,255,2,255,255,2,0,255,3,255,255,255,255,6,0,255,255,0,7,255,255,2,2,6,7,0,255,7,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,21,23,25,27,29,65535,31,33,35,37,39,41,65535,43,45,47,49,51,53,55,65535,57,59,61,65535,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,65535,113,65535,65535,115,117,119,121,123,125,65535,127,129,131,133,65535,135,137,65535,139,141,143,65535,145,65535,65535,147,65535,149,151,153,155,157,65535,65535,65535,159,161,65535,65535,163,165,167,169,171,65535,65535,65535,173,65535,65535,175,177,65535,179,65535,65535,65535,65535,181,183,65535,65535,185,187,65535,65535,189,191,193,195,197,65535,199,201,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,22,24,26,28,30,65535,32,34,36,38,40,42,65535,44,46,48,50,52,54,56,65535,58,60,62,65535,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,65535,114,65535,65535,116,118,120,122,124,126,65535,128,130,132,134,65535,136,138,65535,140,142,144,65535,146,65535,65535,148,65535,150,152,154,156,158,65535,65535,65535,160,162,65535,65535,164,166,168,170,172,65535,65535,65535,174,65535,65535,176,178,65535,180,65535,65535,65535,65535,182,184,65535,65535,186,188,65535,65535,190,192,194,196,198,65535,200,202,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19.5,24877,2227.5,19753,30101,251.5,42,20722.5,18549,27181,25646,252.5,742.5,2509.5,942,20715.5,30195,19014,24439,27916.5,29792.5,17.5,27220,212,25.5,444,999.5,-0.01020968,-0.003209887,3952,1480,19727.5,20444,21825,21195,14054,30071.5,1.5,30381,26101.5,14085,3.5,31362,8.5,21608.5,31573.5,29126,20.5,0.004466585,0.01443015,26.5,165.5,585.5,980,1108,0.01353471,7449,-0.0064209937,2221.5,27996.5,20066.5,15625,21710,-0.0037810083,2.5,19520,23406.5,-0.0059141493,17804,1.5,-0.0009613787,0.014929569,18505,24035.5,3.5,3.5,26687,0.00043587582,29974.5,0.0031127238,22077.5,4.5,28353,3288,24678.5,19346,24965,3.5,2.5,4.5,7.5,22,57,-0.010170808,1068,0.0014634419,501.5,466.5,-0.01752693,634,0.033051148,-0.014396991,283,0.003529115,-0.00540758,3341,2358,19772,28638.5,-0.010514642,0.00010374442,0.0005578504,30941,9.5,13.5,0.0017079999,15.5,19417.5,0.0019621577,-0.009288262,11.5,20548.5,-0.003049881,-0.002702181,10916.5,18914.5,23452,15.5,25658,19015,19913.5,26320.5,26970.5,26096.5,-0.0054324525,26605.5,26641.5,0.0031056416,26309.5,29857,29877,-0.0026032687,30700.5,27667.5,17241,30719.5,16.5,3207.5,-0.0047357767,24848.5,25462,0.00064105255,30544.5,0.0024268867,32501.5,0.005297869,29957,30306,29705.5,-0.0030653486,71,42.5,63.5,21.5,21.5,297.5,-0.00024988852,1125,-0.0015805656,509.5,-0.016161727,-0.007638972,897.5,3056.5,9584.5,0.011618782,3148.5,-1.2871271e-05,0.007771708,-0.0033603378,-0.0002728833,0.006140259,0.0006169057,-0.005148877,-0.0029723253,0.0011019865,-0.0019820898,0.009131554,0.0030809692,0.0003711356,0.00092349836,0.00052840076,0.0010550403,0.00401022,0.000387311,0.0024281002,0.0076673515,-0.0049345084,0.0035085564,-0.009620132,-0.0029322102,0.008110438,0.0011199486,-0.0007414531,0.0022611907,-0.0015503218,0.00093496946,0.00057204725,-0.00014870544,0.0010154791,0.005924178,-0.008250877,-0.0024992682,0.0007969835,0.0039188457,-0.008709076,-0.013616745,-0.007648626,-0.0025098224,-7.4212e-05,-0.0019225763,0.005234912,0.00184842,0.00086378277,0.0041105454,0.00049856625,0.0015122821,-0.004711793,-0.001123477,0.0027766484,0.0002920332,0.003158375,0.0013024831,0.00037198415,0.001307344,-0.00081384694,0.00058461813,-0.00017390166,0.0004619488,0.0012924658,0.0021834285,-0.009074954,-0.0035287775,-0.002004537,0.00016705248,0.00050907274,0.0051603103,0.0009150316,-0.0004704041,-0.00014419366,0.00018375121,0.0021937774,-0.0032774028,0.0008023156,0.005212679,-0.0028303184,-0.00040286942,0.000396905,0.011428297,-0.00020422973,-0.0050595715,-0.0039414405,-0.008038117,-0.013101841,-0.0024825206,0.0008592866,0.022636345,0.003315589,-0.0016071635,-0.0039382866,-0.01540474,0.0010193309,-0.001581048,0.0009635629,-0.00014222553}, {8,3,5,7,3,5,1,3,3,2,2,1,2,3,1,5,2,2,2,3,2,8,2,5,7,1,2,255,255,5,1,7,1,2,1,1,2,8,2,2,2,8,2,8,2,3,5,7,255,255,7,2,2,3,2,255,7,255,2,2,1,7,2,255,8,7,1,255,2,8,255,255,2,5,8,8,1,255,7,255,1,8,1,2,2,2,2,8,8,8,8,2,2,255,1,255,2,2,255,1,255,255,7,255,255,5,2,5,2,255,255,255,2,8,8,255,8,7,255,255,8,5,255,255,3,3,7,8,5,3,1,3,5,3,255,2,2,255,3,1,2,255,1,5,7,1,8,2,255,2,2,255,5,255,1,255,2,1,2,255,2,3,2,8,8,3,255,5,255,1,255,255,7,1,1,255,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,65535,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,65535,93,95,97,99,101,65535,103,65535,105,107,109,111,113,65535,115,117,119,65535,121,123,65535,65535,125,127,129,131,133,65535,135,65535,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,163,65535,165,167,65535,169,65535,65535,171,65535,65535,173,175,177,179,65535,65535,65535,181,183,185,65535,187,189,65535,65535,191,193,65535,65535,195,197,199,201,203,205,207,209,211,213,65535,215,217,65535,219,221,223,65535,225,227,229,231,233,235,65535,237,239,65535,241,65535,243,65535,245,247,249,65535,251,253,255,257,259,261,65535,263,65535,265,65535,65535,267,269,271,65535,273,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,65535,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,65535,94,96,98,100,102,65535,104,65535,106,108,110,112,114,65535,116,118,120,65535,122,124,65535,65535,126,128,130,132,134,65535,136,65535,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,164,65535,166,168,65535,170,65535,65535,172,65535,65535,174,176,178,180,65535,65535,65535,182,184,186,65535,188,190,65535,65535,192,194,65535,65535,196,198,200,202,204,206,208,210,212,214,65535,216,218,65535,220,222,224,65535,226,228,230,232,234,236,65535,238,240,65535,242,65535,244,65535,246,248,250,65535,252,254,256,258,260,262,65535,264,65535,266,65535,65535,268,270,272,65535,274,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({372,343,25.5,321,20.5,16.5,433.5,123,17.5,368.5,0.009892952,2966,19.5,7.5,51.5,133,300,173,0.0010728281,383,15.5,6.5,0.0037097433,-0.010384946,-0.0031064542,155.5,4383.5,339.5,127.5,127,41.5,18.5,7.5,6.5,-0.0016896811,18.5,14.5,10.5,-0.010134943,504.5,504.5,-0.0042201164,2.5,333.5,8421.5,0.009921744,30882,2327,273.5,116.5,13.5,6.5,48.5,17.5,519.5,99.5,20.5,-0.0015333516,-0.005242027,437.5,-0.0017216718,283.5,549.5,0.0017565488,-0.002811715,-0.0127051715,0.00087936874,0.0029382,13.5,0.0066735754,409.5,382.5,15.5,0.0011693727,16.5,25061.5,0.0023031528,20.5,20.5,20.5,54.5,26.5,15.5,0.010015014,0.0048206165,-0.009682168,145.5,8.5,111.5,171,317.5,412.5,0.001515803,29.5,4.5,209,214,4.5,7,-0.0059321853,8509.5,0.007005553,-0.0004576076,1282.5,-0.0061788103,0.0028336325,0.00020408999,13.5,18.5,-0.002055096,-0.009769466,-0.0013511973,6.030546e-05,-0.0038104386,12.5,58.5,-0.008266225,18.5,0.006308769,1573.5,0.009845502,-0.0035042667,642,0.00047356868,-0.00015584331,0.00071555725,0.0044860602,-0.0051110084,0.0020812252,0.0025793063,0.006134933,-0.0073974873,-0.000220586,0.0017124225,-9.2760165e-05,-0.0013843243,0.008848888,-0.00079823605,-0.00698165,0.004679007,0.007660953,0.0008841048,0.003345073,-0.0010211138,0.0013416838,0.012312116,-0.0051828073,-0.0033377719,0.0032584209,0.003814409,0.008387423,0.0019027848,-6.4266285e-05,-0.0025983052,-0.0006253343,-0.0013538464,0.0009183913,-0.004726772,-0.0014304469,-0.0016807405,0.0012030577,0.0008007873,-0.0020849577,0.00016113826,-0.007156511,0.0029911322,-0.00068677537,-0.000507096,-1.289218e-07}, {2,2,7,2,8,8,2,2,8,2,255,1,8,8,7,0,1,0,255,1,8,8,255,255,255,1,0,1,0,0,1,8,8,8,255,8,8,8,255,0,0,255,8,0,0,255,1,7,0,0,8,8,1,8,4,4,8,255,255,4,255,4,4,255,255,255,255,255,8,255,2,2,8,255,8,2,255,8,8,8,7,7,8,255,255,255,0,8,1,4,4,4,255,4,8,2,2,8,8,255,1,255,255,0,255,255,255,8,8,255,255,255,255,255,8,0,255,8,255,7,255,255,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,65535,35,37,39,65535,65535,65535,41,43,45,47,49,51,53,55,57,65535,59,61,63,65535,65,67,65535,69,71,73,65535,75,77,79,81,83,85,87,89,91,93,95,65535,65535,97,65535,99,101,65535,65535,65535,65535,65535,103,65535,105,107,109,65535,111,113,65535,115,117,119,121,123,125,65535,65535,65535,127,129,131,133,135,137,65535,139,141,143,145,147,149,65535,151,65535,65535,153,65535,65535,65535,155,157,65535,65535,65535,65535,65535,159,161,65535,163,65535,165,65535,65535,167,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,65535,36,38,40,65535,65535,65535,42,44,46,48,50,52,54,56,58,65535,60,62,64,65535,66,68,65535,70,72,74,65535,76,78,80,82,84,86,88,90,92,94,96,65535,65535,98,65535,100,102,65535,65535,65535,65535,65535,104,65535,106,108,110,65535,112,114,65535,116,118,120,122,124,126,65535,65535,65535,128,130,132,134,136,138,65535,140,142,144,146,148,150,65535,152,65535,65535,154,65535,65535,65535,156,158,65535,65535,65535,65535,65535,160,162,65535,164,65535,166,65535,65535,168,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2556.5,10634,2648.5,9397,11491,1800,8220,1664,11808,11108.5,-5.7163423e-05,-0.005927636,2635.5,9092.5,9165.5,2111,1967,9746.5,-0.002704884,2401.5,11611,10839,9678.5,8977,10110.5,10580.5,9177,1119.5,2450,683.5,328,2117.5,10263.5,-0.0012095249,2487,11153.5,-0.0024259067,3448.5,-0.0022598344,0.00433276,0.0059217107,8909.5,-0.019695807,10887.5,10809,9296.5,10614.5,9185.5,9351.5,976,1977,2293,-0.009994071,221,2293.5,313.5,10343,8208,2153,2479.5,2517.5,-0.0032481123,11077.5,-0.00053735706,11397,0.004117892,2582,8722.5,9339,6956,7167,6886.5,13097.5,9946.5,11124.5,0.0066320435,8763,0.00079723366,0.0064193048,9322,9535,788,1039.5,1818,1868,-0.004962554,-0.002672997,0.00056129514,-0.0012021315,1733.5,0.0010741863,8793.5,0.010419814,787.5,-0.0057971696,-0.00017052544,0.0051966864,8937.5,9527.5,10019.5,-0.0042447248,10511,10353.5,-0.0023542861,-0.0012634483,-0.0011793921,-0.0017271204,10746,3638,7258,5474.5,0.008840077,0.0027690928,5232.5,6535,6299.5,7723.5,10179.5,-0.013322027,11587,7757.5,7194,10352.5,10985,-0.020746691,8289,8733.5,9495,9418,9506.5,9358,-0.00012464415,-0.0028122962,0.0027268631,0.00024481377,0.0016632926,0.0067708725,0.0015323721,-0.0031304609,-0.0021064521,-0.004240938,-0.00069719285,0.0017212036,-0.0030909693,-0.00037081583,-0.0048676054,-0.00087093125,0.00067258114,0.0001803661,-0.00015225426,-0.0034163562,0.0016458131,-0.00035271488,0.0031246187,0.0019676897,0.002776634,0.001221113,0.00091600016,0.0003536767,2.4544954e-05,0.0007124388,0.0004311929,-0.011532668,0.0027627267,0.0014613272,0.0014126371,0.0054298756,-0.0014551023,-0.0005166726,0.0014806914,0.002562364,-0.0019398154,0.00177483,0.00073929015,0.0054587554,-0.008681863,-0.00063004607,-0.00035526988,-0.0055536516,0.0016631741,-0.0015496213,-0.008154518,-0.0011697615,-0.0012627608,-0.0058434377,0.0028415793,4.2455602e-05,0.0010464388,-1.9050522e-05,0.007189156,0.00030146856,-0.0011328621,-0.00831284,-0.0056098877,-7.945682e-06}, {1,0,1,2,0,6,2,6,2,2,255,255,1,6,2,0,6,0,255,7,2,0,0,6,7,1,2,1,0,0,5,7,2,255,5,2,255,2,255,255,255,6,255,6,7,1,1,0,6,6,1,1,255,0,7,5,6,6,7,1,1,255,0,255,0,255,1,6,0,7,0,5,7,6,6,255,6,255,255,6,2,6,6,1,0,255,255,255,255,6,255,6,255,7,255,255,255,0,0,0,255,6,0,255,255,255,255,2,0,7,2,255,255,1,2,0,0,7,255,6,2,7,0,5,255,6,2,2,1,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,65535,21,23,25,27,29,31,65535,33,35,37,39,41,43,45,47,49,51,53,55,57,59,65535,61,63,65535,65,65535,65535,65535,67,65535,69,71,73,75,77,79,81,83,85,65535,87,89,91,93,95,97,99,101,65535,103,65535,105,65535,107,109,111,113,115,117,119,121,123,65535,125,65535,65535,127,129,131,133,135,137,65535,65535,65535,65535,139,65535,141,65535,143,65535,65535,65535,145,147,149,65535,151,153,65535,65535,65535,65535,155,157,159,161,65535,65535,163,165,167,169,171,65535,173,175,177,179,181,65535,183,185,187,189,191,193,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,65535,22,24,26,28,30,32,65535,34,36,38,40,42,44,46,48,50,52,54,56,58,60,65535,62,64,65535,66,65535,65535,65535,68,65535,70,72,74,76,78,80,82,84,86,65535,88,90,92,94,96,98,100,102,65535,104,65535,106,65535,108,110,112,114,116,118,120,122,124,65535,126,65535,65535,128,130,132,134,136,138,65535,65535,65535,65535,140,65535,142,65535,144,65535,65535,65535,146,148,150,65535,152,154,65535,65535,65535,65535,156,158,160,162,65535,65535,164,166,168,170,172,65535,174,176,178,180,182,65535,184,186,188,190,192,194,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2178,1227.5,2568,1333,1299,1696,879.5,1053,1625,19.5,12.5,2755.5,2220,2677.5,2783.5,1039,4.5,4.5,1707,2.5,1428.5,2379,1767.5,16.5,6181,12.5,18.5,0.0101393275,4263.5,15.5,2915,17.5,-0.0055509657,2.5,11.5,1029.5,1902.5,14.5,13.5,-0.006454306,5.5,0.014714057,0.008342098,1399.5,3555.5,1364,2958,2.5,-0.014727834,14.5,-0.0039260066,0.00020058481,-0.010774127,2260.5,1021,-0.00081349455,0.000525807,4.5,3356.5,2.5,6841.5,15.5,886,707,1369.5,1030.5,933.5,902.5,0.011460672,1105,-0.011070222,0.007151019,0.0012133265,2227.5,1511,0.0072400467,1170.5,6,6.5,5.5,1.5,16.5,18.5,2320,18.5,-0.010848011,12.5,6.5,0.005187544,13.5,2264,-0.008108668,4240,2.5,2331.5,1161.5,4714.5,-0.0079643885,4.5,1.5,6853,30,850.5,739.5,544,0.010613009,-0.0053230897,0.008558224,0.019361418,1301,0.0067188577,1268,15.5,-0.008005471,-0.0012203052,16.5,12.5,1702,2.5,726,2407,10.5,1472.5,0.0033125386,-0.013133532,2262.5,2262.5,1.5,3322,6009.5,22792.5,-0.0018030712,918.5,15.5,0.007297107,1783.5,17.5,2113,-0.01065814,2471.5,0.00064653973,0.004374188,-0.0052444343,6.5,0.007889178,-0.0059546926,2861.5,3051.5,-0.00093154516,1986,2331.5,12.5,4502.5,0.0005334322,2629,18.5,5445,0.010007246,14.5,6195.5,2.5,0.008980703,8036,-0.0007652221,0.00016995639,-0.000637219,-0.00517835,0.00047976823,-0.018514354,0.018722465,-3.9409624e-05,0.00220782,-0.0118999025,-0.0003082873,0.007249092,0.004819885,-0.010961254,0.000115179435,-0.018189525,-0.00573483,0.001238186,-0.0024853095,-0.007020104,0.0021317266,-0.0004452539,0.00031692718,-0.002278906,0.004981003,-0.0012718346,-0.0023231406,0.0009147713,0.0052521355,0.00083825114,0.0005700374,0.016152091,0.0066687376,-0.0012510768,0.0014883736,-0.003767283,0.0019329867,-0.0022032112,0.00597012,0.0028691224,0.0012008135,-0.003071552,-0.0066843606,-0.019412259,0.0011712875,-0.010235175,0.011232533,0.00024900932,-0.00053671334,0.017221844,7.104626e-05,-0.0044464082,0.0020045706,-0.0056643467,0.0042657433,-0.004358066,-0.00015905489,-0.0027022576,0.013368365,0.0025557315,-0.0077124843,0.0027607407,0.015893938,-0.0008286933,-0.004637113,0.0013341372,0.0015212806,-0.0004674491,0.0045143343,0.009944574,0.0072708013,-0.0020144398,-0.007954832,-0.0012095058,-0.004763441,0.00028283458,0.0008096634,0.0058276164,-0.0020645096,-0.00015006872,0.00038739454,-7.200843e-06}, {6,3,6,4,3,7,7,4,4,8,8,0,6,4,6,4,8,8,4,8,6,0,0,8,0,8,8,255,0,8,6,8,255,8,8,7,0,8,8,255,8,255,255,3,0,7,7,8,255,8,255,255,255,6,3,255,255,8,4,8,6,8,3,3,0,7,3,3,255,6,255,255,255,4,6,255,7,8,8,8,8,8,8,7,8,255,8,8,255,8,6,255,4,8,7,0,0,255,8,8,6,6,0,3,4,255,255,255,255,0,255,0,8,255,255,8,8,0,8,3,4,8,4,255,255,0,0,8,0,0,0,255,6,8,255,0,8,0,255,6,255,255,255,8,255,255,7,7,255,7,7,8,3,255,6,8,0,255,8,7,8,255,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,55,57,59,61,65535,63,65,67,69,71,73,65535,75,65535,65535,77,79,81,83,85,65535,87,65535,65535,65535,89,91,65535,65535,93,95,97,99,101,103,105,107,109,111,113,65535,115,65535,65535,65535,117,119,65535,121,123,125,127,129,131,133,135,137,65535,139,141,65535,143,145,65535,147,149,151,153,155,65535,157,159,161,163,165,167,169,65535,65535,65535,65535,171,65535,173,175,65535,65535,177,179,181,183,185,187,189,191,65535,65535,193,195,197,199,201,203,65535,205,207,65535,209,211,213,65535,215,65535,65535,65535,217,65535,65535,219,221,65535,223,225,227,229,65535,231,233,235,65535,237,239,241,65535,243,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,56,58,60,62,65535,64,66,68,70,72,74,65535,76,65535,65535,78,80,82,84,86,65535,88,65535,65535,65535,90,92,65535,65535,94,96,98,100,102,104,106,108,110,112,114,65535,116,65535,65535,65535,118,120,65535,122,124,126,128,130,132,134,136,138,65535,140,142,65535,144,146,65535,148,150,152,154,156,65535,158,160,162,164,166,168,170,65535,65535,65535,65535,172,65535,174,176,65535,65535,178,180,182,184,186,188,190,192,65535,65535,194,196,198,200,202,204,65535,206,208,65535,210,212,214,65535,216,65535,65535,65535,218,65535,65535,220,222,65535,224,226,228,230,65535,232,234,236,65535,238,240,242,65535,244,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({34.5,30,6655,16.5,10.5,6579,7664,132,132,28.5,30.5,6551,6592.5,7657,7674.5,106.5,2.5,54,0.014615952,488,29334,18.5,29,6460.5,6365,7023.5,6652,9053.5,4.5,10442.5,281.5,54,0.0041133636,-0.009403952,8,28,19.5,7.5,4266,24,-0.00072756835,15.5,24,13057.5,49,5686,6.5,0.0044554635,0.011191817,4759,-0.01535693,5869.5,-0.012103823,9428,9087,0.013670705,16.5,-0.0072967405,11.5,14.5,9291,34,101,4.5,14.5,22,-0.004305582,0.004411014,0.002107331,6.5,106,-0.004109893,0.002482733,3.5,1.5,32.5,0.0015610381,0.000540658,20.5,17.5,15.5,16,18.5,4997.5,5207.5,6898,7048.5,-0.008500038,-0.0041997954,13.5,6351,6140,7364,-0.021450484,1.5,5719.5,0.0016246338,-0.0004984564,-0.0002177961,0.0020101925,0.0042320904,8867,9335,32,0.0032361827,72,8.5,0.0012194688,0.0049873195,469.5,-0.0017370062,22,0.0009046848,22,0.0052036643,0.0012357666,-0.0032511149,0.0010383026,0.001620148,0.009034905,8.5,0.0015039551,11.5,0.0112889595,0.0046362546,-0.0035027768,-0.01932731,-0.00095080445,0.00046697917,-0.0014091524,-0.0032348935,185.5,483.5,4615,1734.5,5015.5,7090,-0.00222471,0.003982522,6719,7100.5,5.5,6105.5,0.008250501,6.5,6061.5,6651,5804,9562.5,-0.011687345,10914,0.0040390035,0.009655945,1.5,9023.5,8887.5,8116.5,0.00011958187,-0.003388834,-0.002366944,-0.00447279,-0.0011159786,0.0018004187,-0.007229054,-0.0020409669,-0.0021945855,0.0010636632,0.003912151,0.0009348741,0.004458256,0.00738149,0.0014838823,-0.0019470286,-0.0020688667,0.0049343533,0.008941884,-0.004093669,-6.6022396e-05,-0.0014483338,-0.0022605292,0.0011392577,3.085212e-05,0.008426006,-0.0023753077,-0.00029430943,-0.0046520163,0.0027008508,-0.011140758,-0.0056969817,0.000112978254,-0.00678147,0.0008923001,-0.0021920272,0.0051186276,-0.0006101837,0.0015379199,0.018403338,0.00082353567,-0.0010575795,0.0003558382,0.010512415,-0.0049793785,0.0014849594,-0.0016036554,0.003439903,-0.0016371217,7.797058e-05,-0.002930739,-0.00046159426,0.0057307705,-7.932518e-05,-0.0025497428,4.4167224e-05}, {6,4,4,8,8,4,4,1,1,6,1,4,4,4,4,3,8,1,255,3,1,8,5,4,1,1,4,6,8,1,3,1,255,255,8,6,8,8,1,1,255,8,1,1,1,1,8,255,255,1,255,1,255,3,6,255,8,255,8,8,6,1,1,8,8,6,255,255,255,8,3,255,255,8,8,4,255,255,8,8,8,8,8,5,3,3,1,255,255,8,3,6,1,255,8,5,255,255,255,255,255,6,6,6,255,1,8,255,255,1,255,3,255,6,255,255,255,255,255,255,8,255,8,255,255,255,255,255,255,255,255,4,3,5,1,3,1,255,255,3,1,8,6,255,8,6,5,1,1,255,3,255,255,8,6,1,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,65535,65535,63,65,67,69,71,73,65535,75,77,79,81,83,85,65535,65535,87,65535,89,65535,91,93,65535,95,65535,97,99,101,103,105,107,109,111,65535,65535,65535,113,115,65535,65535,117,119,121,65535,65535,123,125,127,129,131,133,135,137,139,65535,65535,141,143,145,147,65535,149,151,65535,65535,65535,65535,65535,153,155,157,65535,159,161,65535,65535,163,65535,165,65535,167,65535,65535,65535,65535,65535,65535,169,65535,171,65535,65535,65535,65535,65535,65535,65535,65535,173,175,177,179,181,183,65535,65535,185,187,189,191,65535,193,195,197,199,201,65535,203,65535,65535,205,207,209,211,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,65535,65535,64,66,68,70,72,74,65535,76,78,80,82,84,86,65535,65535,88,65535,90,65535,92,94,65535,96,65535,98,100,102,104,106,108,110,112,65535,65535,65535,114,116,65535,65535,118,120,122,65535,65535,124,126,128,130,132,134,136,138,140,65535,65535,142,144,146,148,65535,150,152,65535,65535,65535,65535,65535,154,156,158,65535,160,162,65535,65535,164,65535,166,65535,168,65535,65535,65535,65535,65535,65535,170,65535,172,65535,65535,65535,65535,65535,65535,65535,65535,174,176,178,180,182,184,65535,65535,186,188,190,192,65535,194,196,198,200,202,65535,204,65535,65535,206,208,210,212,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({35,30,35,49.5,154,27,248,34.5,61,101,-0.003273328,117,186,78,283.5,1405.5,84.5,22,283.5,27.5,0.0075859646,22,317,40.5,-0.005999792,67.5,771.5,275,414,33.5,0.0025776138,45.5,-0.0037091528,0.0014907966,27,2381.5,1201.5,39.5,106.5,-0.001537093,-0.0034895018,56.5,25111,-0.006746574,34.5,112,-0.008461902,136.5,3709,261.5,802.5,282,637.5,26.5,49,-0.0015550762,-0.0020535712,0.0030537187,0.0016347939,-0.001576953,-0.00088250585,484.5,0.001083371,32.5,-0.0028332905,-0.0056590834,6.988591e-06,1067.5,187.5,-0.004972193,0.0014487893,0.0014130791,48,134.5,52.5,193.5,168,1059.5,755.5,257.5,654.5,-0.003135055,-0.013385601,339.5,762.5,609,892,27,28.5,0.00254558,69,0.000121991376,0.00019599889,0.0010676326,0.0024661885,-0.0006922593,-0.0004915664,4.284056e-05,188,-0.0015677636,-0.0009063987,62.5,-0.0035935477,133.5,0.00038406966,176,256.5,383,-0.0026509948,776,-0.0016836437,0.00032347225,0.00054506626,943.5,-0.005609756,0.008798005,0.0008964788,341.5,902,395.5,-0.00071304146,359,771.5,606,933.5,0.00029268532,-0.0021277636,-0.0022166593,0.00021792464,0.0009841532,0.000113515875,0.0010334698,0.0020465397,-0.00097238476,4.624797e-05,0.0020364826,0.0014291815,0.0009116147,0.007313865,-0.005590713,0.00033030807,0.006209128,0.0016918107,-0.0007540482,-0.0010924811,-0.00052256783,-0.0049680406,0.00089479,0.010795312,-0.003295201,4.660711e-05,0.0011239578,0.0064008655,-0.022869043,-0.0016243088,0.0029718557,-0.0008348267,0.00404147,0.0004949662,-0.0011999706,-3.3448006e-05}, {2,2,4,4,0,5,2,4,4,0,255,0,0,0,3,0,0,2,5,5,255,4,2,3,255,0,4,3,4,0,255,0,255,255,2,0,0,0,4,255,255,3,2,255,0,3,255,5,4,3,2,5,4,0,0,255,255,255,255,255,255,0,255,0,255,255,255,0,0,255,255,255,0,2,0,4,3,0,0,3,0,255,255,1,0,2,2,2,0,255,0,255,255,255,255,255,255,255,2,255,255,2,255,2,255,4,4,4,255,0,255,255,255,1,255,255,255,0,2,0,255,5,2,5,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,37,65535,39,41,43,65535,45,47,49,51,53,65535,55,65535,65535,57,59,61,63,65,65535,65535,67,69,65535,71,73,65535,75,77,79,81,83,85,87,89,65535,65535,65535,65535,65535,65535,91,65535,93,65535,65535,65535,95,97,65535,65535,65535,99,101,103,105,107,109,111,113,115,65535,65535,117,119,121,123,125,127,65535,129,65535,65535,65535,65535,65535,65535,65535,131,65535,65535,133,65535,135,65535,137,139,141,65535,143,65535,65535,65535,145,65535,65535,65535,147,149,151,65535,153,155,157,159,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,38,65535,40,42,44,65535,46,48,50,52,54,65535,56,65535,65535,58,60,62,64,66,65535,65535,68,70,65535,72,74,65535,76,78,80,82,84,86,88,90,65535,65535,65535,65535,65535,65535,92,65535,94,65535,65535,65535,96,98,65535,65535,65535,100,102,104,106,108,110,112,114,116,65535,65535,118,120,122,124,126,128,65535,130,65535,65535,65535,65535,65535,65535,65535,132,65535,65535,134,65535,136,65535,138,140,142,65535,144,65535,65535,65535,146,65535,65535,65535,148,150,152,65535,154,156,158,160,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({52.5,48.5,1651,40.5,65.5,20.5,1660,25.5,44.5,8.5,-0.011181015,1184,1629.5,13,11286,21.5,26.5,7.5,4.5,0.0008661505,50.5,1263.5,4.5,444,2071,-0.016030502,0.008663002,1.5,21348.5,72,88,6.5,17.5,-0.0015384754,13.5,0.0077418345,50,-0.0021084114,-0.0043570553,1167,1340,716,1320.5,401,633.5,-0.011015226,355,6751.5,11275,17691,18578.5,20.5,15.5,24,-0.0041735084,1.5,16.5,61,30.5,0.005391399,-0.0005704925,14.5,17.5,561.5,876.5,0.0076936297,349,2.5,1367,582,1742,77.5,-0.009230521,651,1169.5,-0.00555937,1003,1061,11480.5,6.5,-0.0073793433,13977,18411,23728.5,20847.5,24,28.5,958.5,958.5,22.5,0.0032658707,0.0026479491,54.5,14.5,21.5,56.5,128.5,20.5,34,0.0044969837,0.002590192,-0.001206743,0.0020689347,237,15.5,272.5,12.5,318.5,1331.5,0.0009118435,300.5,1390.5,1238,6.5,1404,1288.5,13.5,65.5,643.5,0.029361842,0.010518013,1360,1200.5,853,1275.5,2588.5,1606,4907,11219.5,10188.5,15671.5,14549,17179,12860,20997.5,24137,22152.5,18795,23812.5,9.662441e-05,-0.000982867,-0.00013029073,0.0050830687,-8.8852736e-05,0.0016870272,0.003265472,-0.0038966672,-0.002174028,-0.00013702895,-0.00819112,-0.0018064262,-0.00170484,0.0040470995,-0.004102047,-0.00016051621,-0.0006920746,-0.007919523,0.0010153396,-0.004092227,0.0034636469,0.00046399035,-0.007903687,-0.0023307917,-0.00020517081,0.0010514276,3.1714648e-05,-0.0028658474,-0.0033798718,-0.009678684,0.0016611383,-0.004325891,0.0011143592,0.0041535995,-0.00034593014,0.0026398776,-0.0029102045,-0.0045668124,0.0026082492,0.012498062,-0.007297752,0.0007213564,0.0050158994,-0.00076977466,0.005656143,0.0012415996,-0.010686806,-0.002175674,0.003780173,-0.0003568999,0.0030263774,0.014462495,-0.0011095075,0.0038065964,-0.00967329,0.006534539,0.02304503,0.0025386084,0.0002323326,0.003339175,-0.004965132,-0.0010227779,-0.011623089,-0.0018110333,0.010310131,0.0009833273,-0.010355993,-0.0018393822,0.0037723004,-0.0037535771,0.0003771178,-0.00089832937,-7.540284e-05,-0.0007994389,0.000143975,0.00886199,-0.0037537885,0.00026797442,-0.0013478125,0.0048381677,-0.005609439,0.0012940113,-0.009600066,0.0035977028,0.0017744126,-0.0028126799,0.003975361,-0.00031106145,-0.0011021615,1.7936269e-05}, {1,1,2,1,0,8,2,1,0,8,255,2,0,8,1,8,1,8,8,255,0,0,8,1,0,255,255,8,6,6,6,8,8,255,8,255,7,255,255,0,0,1,0,1,0,255,2,6,1,6,0,8,8,7,255,8,8,6,2,255,255,8,8,0,1,255,2,8,7,0,1,2,255,6,1,255,6,7,7,8,255,7,7,7,2,7,7,2,2,1,255,255,7,8,8,6,0,8,0,255,255,255,255,7,8,1,8,2,7,255,0,6,1,8,6,2,8,2,2,255,255,6,0,2,6,0,1,2,0,7,0,6,7,7,7,6,6,1,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,65535,65535,47,49,51,53,55,57,65535,59,65535,61,65535,65535,63,65,67,69,71,73,65535,75,77,79,81,83,85,87,89,65535,91,93,95,97,65535,65535,99,101,103,105,65535,107,109,111,113,115,117,65535,119,121,65535,123,125,127,129,65535,131,133,135,137,139,141,143,145,147,65535,65535,149,151,153,155,157,159,161,65535,65535,65535,65535,163,165,167,169,171,173,65535,175,177,179,181,183,185,187,189,191,65535,65535,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,65535,65535,48,50,52,54,56,58,65535,60,65535,62,65535,65535,64,66,68,70,72,74,65535,76,78,80,82,84,86,88,90,65535,92,94,96,98,65535,65535,100,102,104,106,65535,108,110,112,114,116,118,65535,120,122,65535,124,126,128,130,65535,132,134,136,138,140,142,144,146,148,65535,65535,150,152,154,156,158,160,162,65535,65535,65535,65535,164,166,168,170,172,174,65535,176,178,180,182,184,186,188,190,192,65535,65535,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8264.5,8909.5,2027.5,8722.5,8977,5.5,6389.5,7054.5,5245,4.5,9092.5,0.019144785,-0.0013842582,6374,8283.5,6988,8475,16.5,8840.5,0.008175909,1411.5,-0.018565718,12341,6693.5,5280,-0.009517816,6408,6255,7278.5,7187.5,-0.01835761,5.5,-0.00058606005,-0.016441291,-0.005265893,-0.0049646017,12.5,15.5,12872,15.5,11633.5,11.5,-0.0087375995,6454,6428.5,5648.5,9275,7863.5,-0.019885907,7523.5,8820.5,-0.0004737726,0.0013574649,7412,8960,8249.5,8176,-0.008377408,7.5,6320.5,18.5,10190.5,16365,-0.002515099,-0.0066988217,9940.5,12.5,5881,6528.5,6507,5652.5,5289,6583,-0.007894447,0.0045862403,6941.5,7534,7734.5,9757,0.005055507,-0.0003375916,0.009793882,17.5,7437,7046.5,7437,7142,3.5,17.5,3509,7.5,8946.5,8185,4.5,7.5,12.5,0.003442213,11.5,12.5,0.011477978,0.0025264237,11.5,13.5,6514,6813,-1.3703978e-05,-0.002486183,0.005514099,0.0002311006,0.0026724602,-0.003353047,-0.006929246,0.0050680544,0.004516179,-0.0064701224,0.0039524804,0.01942501,0.00025010805,0.0023624229,-0.008716018,0.0004934486,0.003398363,0.0054835062,0.0018037948,-0.00037181945,0.004338377,0.00043590032,0.0006087358,-0.00627323,0.0055977115,0.002312283,-6.906377e-05,0.003799779,-0.00089904474,-0.0030887667,-0.00012492575,-0.0008801493,0.0042447597,-0.00063346623,0.0026613881,0.0007819389,0.0017190803,-0.00079882453,-0.007471677,-0.002042924,-0.011494423,-0.006302899,8.866555e-05,0.0013494266,0.004331182,0.001444325,-0.005319416,0.0013413698,-0.0020200845,-0.0009930494,-0.00862551,-0.004849038,0.00035341436,0.0048318147,-0.0012718582,1.529049e-05}, {2,6,3,6,6,8,3,3,3,8,6,255,255,3,2,3,6,8,6,255,1,255,6,1,1,255,3,3,2,3,255,8,255,255,255,255,8,8,6,8,2,8,255,1,3,4,1,4,255,6,4,255,255,4,6,1,4,255,8,3,8,2,2,255,255,2,8,1,3,2,4,6,6,255,255,2,1,6,4,255,255,255,8,4,3,4,3,8,8,3,8,6,4,8,8,8,255,8,8,255,255,8,8,3,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,31,33,65535,35,65535,37,39,41,65535,43,45,47,49,65535,51,65535,65535,65535,65535,53,55,57,59,61,63,65535,65,67,69,71,73,65535,75,77,65535,65535,79,81,83,85,65535,87,89,91,93,95,65535,65535,97,99,101,103,105,107,109,111,65535,65535,113,115,117,119,65535,65535,65535,121,123,125,127,129,131,133,135,137,139,141,143,145,147,65535,149,151,65535,65535,153,155,157,159,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,32,34,65535,36,65535,38,40,42,65535,44,46,48,50,65535,52,65535,65535,65535,65535,54,56,58,60,62,64,65535,66,68,70,72,74,65535,76,78,65535,65535,80,82,84,86,65535,88,90,92,94,96,65535,65535,98,100,102,104,106,108,110,112,65535,65535,114,116,118,120,65535,65535,65535,122,124,126,128,130,132,134,136,138,140,142,144,146,148,65535,150,152,65535,65535,154,156,158,160,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1707,1478.5,1843,15.5,18.5,3963,1923.5,1018.5,1116,15.5,1703.5,2.5,15.5,6.5,5.5,1228.5,1052.5,1111,2051.5,6.5,1627,1541.5,1537.5,2513,6.5,5.5,943.5,1811.5,18.5,2114,2092.5,478,14.5,384,1526.5,1219,0.013149551,1139.5,905.5,5497,12.5,-0.0002196796,-0.0099313175,0.011080182,-0.0034303837,0.025098313,0.0068996185,1446,-0.00998656,2581.5,12.5,1427.5,7099.5,-0.0064794826,2542.5,-0.0028321638,5.078817e-05,2234.5,-0.0019308347,8488,11527.5,8488,2337.5,843,1005,4.5,0.008484589,87,7.5,2.5,5372,860.5,1225,0.0076585817,1531,3147,8351,2.5,0.0036369872,1641,1200.5,-0.007952107,-0.00021699203,4.5,980.5,2410.5,2410.5,2.5,7137,1283.5,6938.5,982.5,1328.5,14.5,12.5,7521.5,0.01416007,11478,11847,1378,12.5,7.5,2347.5,2429,443.5,859.5,-0.00421752,2.5,1142,7.5,5289,1050,1142.5,0.01561594,1109,1274,-0.0023530675,996,1169.5,1502,-0.0084440345,1526.5,0.0016855717,0.0005776403,0.008038187,-0.006624978,1237.5,1.5,797,1551.5,2266,0.0026270796,1735,1686.5,1139,-0.008547795,0.00033814312,3848,1716.5,18.5,1716.5,4242,5128.5,1867.5,8300.5,0.0043132096,1414,8380,11.5,0.00057504786,-0.008377458,0.0043603866,6990.5,0.004577811,0.0078039104,0.004138614,15.5,2.5,1916,4095,7079,6715.5,7167,-0.010447583,15.5,8939.5,9512,8678,2169,12.5,6435,0.00010023136,0.0057843323,-0.0038120125,0.005640225,0.0006283476,0.0036873247,-0.0036546986,0.005481835,0.0024748011,-0.005533702,-0.001578878,0.0017408365,0.0038993824,-0.00064760447,0.008297364,8.824336e-05,-0.006424445,-0.00019666266,-0.00078967394,0.0069572725,0.0005620536,0.0027302045,-0.00017865332,0.014795328,-0.0009354912,-0.014869514,0.008495983,-0.00048325057,-0.015386874,-0.004539136,0.00065636396,-0.00034982857,0.0012698967,0.0005056761,-0.0012711064,-0.0051851626,0.0014536988,0.0054849903,0.007148094,0.0032199186,0.00085080473,-0.00078199955,0.0026413514,0.013446559,-0.0019310156,0.004905309,-0.008644774,0.0012626308,0.005975771,-0.0076351524,0.0053512543,-0.0015224331,-0.007139874,0.0037308016,0.01146168,0.004803895,-0.0016306827,0.00409241,0.0034689382,-0.00096927845,-0.002640706,-0.00569169,-0.0026888964,0.00028992968,-0.0024962956,0.0008376177,0.0029347872,0.0009703153,-0.0019601812,0.00011216403,0.00073255383,0.0028729266,-0.0010325919,0.010034761,-0.0029075283,-0.0067852265,-0.00040750517,0.0006439908,0.005934836,0.010669013,-0.0008462852,-0.009281223,-0.00214257,-3.0784235e-05,-0.0025840101,0.003077654,0.00080911967,-0.0055397972,-0.01023038,-0.004781981,0.002800252,-0.0039770757,-0.0010108114,0.0013364579,-0.0019060451,-0.0058554523,-0.0002160741,2.2139346e-05}, {4,5,5,8,8,0,4,7,5,8,5,8,8,8,8,4,5,5,3,8,5,5,4,0,8,8,7,4,8,5,5,3,8,3,7,4,255,4,7,3,8,255,255,255,255,255,255,5,255,4,8,5,0,255,4,255,255,7,255,4,0,4,5,4,7,8,255,0,8,8,0,4,7,255,4,0,7,8,255,5,0,255,255,8,3,4,4,8,0,3,4,5,5,8,8,4,255,0,0,7,8,8,5,0,7,4,255,8,0,8,7,7,7,255,7,0,255,5,0,4,255,7,255,255,255,255,5,8,7,4,7,255,5,0,7,255,255,3,7,8,7,0,0,7,0,255,5,0,8,255,255,255,4,255,255,255,8,8,5,5,3,7,4,255,8,0,0,4,7,8,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,77,79,65535,65535,65535,65535,65535,65535,81,65535,83,85,87,89,65535,91,65535,65535,93,65535,95,97,99,101,103,105,107,65535,109,111,113,115,117,119,65535,121,123,125,127,65535,129,131,65535,65535,133,135,137,139,141,143,145,147,149,151,153,155,157,65535,159,161,163,165,167,169,171,173,175,65535,177,179,181,183,185,187,65535,189,191,65535,193,195,197,65535,199,65535,65535,65535,65535,201,203,205,207,209,65535,211,213,215,65535,65535,217,219,221,223,225,227,229,231,65535,233,235,237,65535,65535,65535,239,65535,65535,65535,241,243,245,247,249,251,253,65535,255,257,259,261,263,265,267,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,78,80,65535,65535,65535,65535,65535,65535,82,65535,84,86,88,90,65535,92,65535,65535,94,65535,96,98,100,102,104,106,108,65535,110,112,114,116,118,120,65535,122,124,126,128,65535,130,132,65535,65535,134,136,138,140,142,144,146,148,150,152,154,156,158,65535,160,162,164,166,168,170,172,174,176,65535,178,180,182,184,186,188,65535,190,192,65535,194,196,198,65535,200,65535,65535,65535,65535,202,204,206,208,210,65535,212,214,216,65535,65535,218,220,222,224,226,228,230,232,65535,234,236,238,65535,65535,65535,240,65535,65535,65535,242,244,246,248,250,252,254,65535,256,258,260,262,264,266,268,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({33.5,22,6684.5,59,32.5,6662.5,6692,22,-0.0029680436,26.5,27,6657,7148,0.009284839,8040.5,49.5,22,22,28.5,0.008612785,951,6652,0.0106686875,6830.5,-0.008225852,5003.5,8084,22,25.5,0.004640099,0.00042277254,0.00410876,40.5,28.5,44.5,-0.00057414226,0.00012949377,6301.5,8203,-0.004060972,-0.0011379694,8136,7662,5219.5,8096,-0.0006475176,7.402091e-05,0.001800238,0.00097465975,32,0.004083344,-0.0018669193,0.00036511777,25,74,6243,6563.5,6662.5,-0.0065923794,6749.5,3198.5,9428,7195.5,-0.0089578815,5929,0.005988182,2043,0.00024314442,29.5,0.0010783086,0.0019498852,57,121,6221.5,6256,5948,6527.5,0.010748693,3960,6946.5,4703,5788.5,0.0030484593,6741.5,7432,7053,7584,1981,0.0031024707,1993,8289,-0.00073523464,-0.0013836693,0.00046034684,-0.0005472305,0.00039351016,0.0014910577,-0.00015785955,-0.0065737627,6.906128e-06,0.012034017,0.0012905906,-0.005871371,0.0011233028,-0.007509563,5.503871e-05,0.0020735522,-0.0025777703,0.0014952376,-0.006058323,-0.01654475,0.0006771874,-0.0007428785,-0.0032157474,0.00089420745,0.009009074,-0.00013512888,0.00025324718,0.0058903075,-0.0026514183,0.00036958785,-0.00013028258,-0.00402099,0.00021218008,0.00403809,-0.0010220536,-1.8711757e-05}, {4,0,6,2,4,6,6,2,255,0,6,6,0,255,6,6,4,6,0,255,0,7,255,7,255,0,6,6,4,255,255,255,3,2,0,255,255,7,4,255,255,7,4,0,6,255,255,255,255,6,255,255,255,3,2,7,7,7,255,7,0,3,7,255,3,255,7,255,2,255,255,2,0,7,3,6,6,255,2,6,4,4,255,6,0,7,6,3,255,7,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,65535,25,27,29,31,33,65535,35,37,65535,39,65535,41,43,45,47,65535,65535,65535,49,51,53,65535,65535,55,57,65535,65535,59,61,63,65,65535,65535,65535,65535,67,65535,65535,65535,69,71,73,75,77,65535,79,81,83,85,65535,87,65535,89,65535,91,65535,65535,93,95,97,99,101,103,65535,105,107,109,111,65535,113,115,117,119,121,65535,123,125,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,65535,26,28,30,32,34,65535,36,38,65535,40,65535,42,44,46,48,65535,65535,65535,50,52,54,65535,65535,56,58,65535,65535,60,62,64,66,65535,65535,65535,65535,68,65535,65535,65535,70,72,74,76,78,65535,80,82,84,86,65535,88,65535,90,65535,92,65535,65535,94,96,98,100,102,104,65535,106,108,110,112,65535,114,116,118,120,122,65535,124,126,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1498.5,472,7670.5,804.5,15.5,7610.5,8618,36,485,497,719.5,1911.5,11.5,9093,8813.5,25.5,42,284,-0.004037255,745.5,3121.5,29,632,15.5,2026.5,7480.5,7080,7809,11.5,8714,2070.5,148,196,9.5,757.5,17.5,837,0.0021468445,-0.021817645,1216.5,952.5,0.004019109,48.5,20.5,1121,1646.5,1252,12.5,1504.5,7701.5,5.5,3708,8327.5,7719,8252,7937.5,8033.5,6027,2.5,8,8932,132.5,0.0041298023,68,-0.010272939,27,76,700,784.5,256.5,286,17.5,985.5,1113.5,1393,3669.5,4476.5,-0.015562236,1711.5,18.5,0.0143115735,8259,1082,2591,7.5,854.5,1732.5,2146.5,2146.5,3414,7452.5,4127,0.0059075947,7656.5,7628,-0.000513428,15.5,7666,-0.008743481,5795,15.5,7154,7739,7852.5,8483,17.5,18.5,11.5,5060.5,8747,9160,0.006786581,9339.5,8842,9076.5,96.5,-0.0045186,28,0.0055310666,-0.00024364748,29.5,18.5,-0.0033698454,18.5,726.5,-0.004760296,10,15,4.5,1181.5,0.0062255766,759,-7.5568794e-05,421.5,0.0011835096,1829,1769.5,5.5,6.5,6.5,1019.5,-0.001508607,8870.5,372.5,332.5,-0.004103269,0.0015133871,1170.5,821,2403,1245,1580,5953.5,1820,1822.5,806.5,1262.5,1414,3236,3078.5,0.008250256,15.5,-0.012553692,-0.00065931893,1522,5365,6715.5,7633,0.0022013548,0.007903124,0.014404793,0.0098478915,5120,0.0029525133,5851,7909.5,-0.0034128272,5252,8085.5,0.0008783064,0.013598735,6502.5,-0.020208634,10.5,8544.5,7679,7893.5,7984,0.0026229527,15.5,7144,10069,5813,8690,8658.5,7,1.5,0.0036361446,0.0008511752,3961.5,10144.5,-0.012725054,-0.004022044,7935,8840.5,8807.5,9097.5,-0.00012503132,0.0016058084,-0.0004589875,-0.0023426635,0.0032785926,0.01233852,-5.361193e-05,0.0033067246,0.00017351568,-0.0005620796,0.008380105,0.0024344346,-0.0025822984,-0.0010246987,0.0038484873,-0.003445007,-0.003888854,8.999444e-05,-0.0007483079,0.0017849881,0.00449362,0.00060148834,0.008636645,0.0017341197,5.131116e-05,0.004718385,-0.00021543748,-0.0064524687,6.9627065e-05,0.0067297006,-0.0002540378,0.0012952288,-0.0035510787,-0.0013427605,0.0014038724,-0.00012029398,-0.013622995,-0.0052490565,-0.01307667,-0.004572303,0.003665107,-0.003649338,-0.014870136,0.0007685793,-0.0007116866,0.0013893576,0.0042710975,-0.010395827,-0.006624911,-0.0010878565,0.00044647945,0.004992998,0.00736586,0.0019862512,0.00040024737,0.0053887363,-0.0051426156,4.411533e-05,-0.00012432813,0.0064903456,-0.013949198,-0.002429433,0.0067692935,-0.0010194714,0.009272321,0.0007449059,-0.008710142,-0.003722594,-0.0018638388,0.005000887,0.0025916777,0.010181058,0.00021052724,-0.00018018992,6.633152e-05,0.0023049316,-0.0015276553,-0.0004439104,0.00038368432,0.0017646408,0.005473531,0.00854555,0.00056545966,-0.0021981616,-0.00178939,-0.013705839,0.0005783494,-0.0010001509,-0.011992418,-0.0035297056,-0.00010041782,0.005776996,-0.0033679863,-0.009370151,0.00061888463,0.0020648849,0.0034638362,0.006464381,-0.00086264097,0.00093752996,-0.0026832712,0.0039256406,-0.0004116553,-0.004387967,0.0009786253,-0.0004184907,0.0010368678,0.002955619,-0.0055951793,-0.0011484235,0.004634921,0.0014632953,-0.0023144258,0.0021218194,-0.0008369158,0.0051746992,-0.00035033526,-0.0051214225,0.0030601358,-0.00012242595,-0.0010122096,-0.020077841,-0.0007409285,0.00086692936,0.003395219,0.00057175354,-0.0049927444,1.8128392e-05}, {1,1,0,0,8,0,0,3,3,1,3,5,8,1,0,3,3,5,255,0,5,4,0,8,5,4,4,3,8,1,1,0,0,8,0,8,4,255,255,5,0,255,4,8,4,3,5,8,3,1,8,1,4,3,3,0,0,5,8,8,0,0,255,1,255,5,4,0,0,1,3,8,4,1,4,4,4,255,0,8,255,3,5,1,8,4,1,3,3,0,0,1,255,0,0,255,8,0,255,4,8,5,0,0,0,8,8,8,3,0,1,255,0,5,0,0,255,5,255,255,1,8,255,8,0,255,8,8,8,0,255,4,255,3,255,0,0,8,8,8,3,255,4,5,3,255,255,1,4,4,3,3,0,5,3,5,4,5,3,4,255,8,255,255,1,3,3,0,255,255,255,255,1,255,1,1,255,5,0,255,255,4,255,8,0,0,0,0,255,8,4,1,4,0,0,8,8,255,255,3,1,255,255,5,0,1,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,65535,73,75,65535,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,117,65535,119,121,123,125,127,129,131,133,135,137,139,141,65535,143,145,65535,147,149,151,153,155,157,159,161,163,165,167,65535,169,171,65535,173,175,65535,177,179,181,183,185,187,189,191,193,195,197,199,65535,201,203,205,207,65535,209,65535,65535,211,213,65535,215,217,65535,219,221,223,225,65535,227,65535,229,65535,231,233,235,237,239,241,65535,243,245,247,65535,65535,249,251,253,255,257,259,261,263,265,267,269,271,273,65535,275,65535,65535,277,279,281,283,65535,65535,65535,65535,285,65535,287,289,65535,291,293,65535,65535,295,65535,297,299,301,303,305,65535,307,309,311,313,315,317,319,321,65535,65535,323,325,65535,65535,327,329,331,333,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,65535,74,76,65535,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,118,65535,120,122,124,126,128,130,132,134,136,138,140,142,65535,144,146,65535,148,150,152,154,156,158,160,162,164,166,168,65535,170,172,65535,174,176,65535,178,180,182,184,186,188,190,192,194,196,198,200,65535,202,204,206,208,65535,210,65535,65535,212,214,65535,216,218,65535,220,222,224,226,65535,228,65535,230,65535,232,234,236,238,240,242,65535,244,246,248,65535,65535,250,252,254,256,258,260,262,264,266,268,270,272,274,65535,276,65535,65535,278,280,282,284,65535,65535,65535,65535,286,65535,288,290,65535,292,294,65535,65535,296,65535,298,300,302,304,306,65535,308,310,312,314,316,318,320,322,65535,65535,324,326,65535,65535,328,330,332,334,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1.5,1458,6769.5,1567,1608.5,6660.5,8175,561.5,1953,1791.5,8191.5,9043,9008,7394,7688,257.5,802.5,0.020472473,3838.5,-0.0037941278,-0.0074126194,7162.5,16477.5,2.5,9178,8151,11879.5,6293,7414.5,7135,10124.5,139.5,852.5,-0.007976719,2.53523e-06,5837.5,0.005837184,7068,7817,15054.5,16677.5,11221.5,6648,5675,7997.5,6693.5,0.00047779066,6688,15765,7424.5,7187.5,15.5,10301,21988.5,6194,9846,10160.5,30.5,-0.005367207,177.5,-0.0013639743,755.5,971.5,1982,0.007624694,7544.5,9878.5,10787,18267,18312.5,32501.5,5566.5,11627.5,6950.5,12894.5,7750,6.5,9896,3173,-0.0063718013,-0.012894899,6.5,6968.5,6582.5,-0.0021080095,6218.5,7722,6577.5,7880,6839.5,11834.5,9332,10597,8176,22066.5,5298.5,8563,21322,9741,13.5,10166.5,27.5,128.5,-0.0005331912,281,-0.0005987892,-0.00308945,0.0034648352,0.0017720422,6069.5,3527,6363.5,0.010393893,7703.5,7381.5,9163,14778.5,0.004705176,0.013708043,-0.008106326,12678,27323,24665,5970.5,9579,0.0054143183,6210,12.5,6519,3.6087356e-05,0.0063321474,0.0030203795,0.00014695288,0.0035870539,0.0086320825,12.5,16.5,748,6427.5,-0.008490469,17.5,10403,0.0028014628,11963,0.005008058,6851,0.019024925,4510.5,5727,6510.5,7005.5,6911.5,6921,4.5,7182.5,8744,7146,7150,0.019178214,9654.5,8070,10.5,6990.5,-0.009831446,0.0015244609,-0.00919334,0.005643628,7212.5,-0.007994769,14110.5,25755,8956.5,9862,10135.5,10376.5,-0.007861008,9692,0.00023046811,-0.004552873,0.0034667943,-0.0023614897,0.009542241,0.0049085184,-0.0012388517,-0.006380958,0.0017670499,-0.00055402104,-0.005658301,0.0015622779,-0.004690113,-0.021548748,-0.0035233584,9.6478994e-05,0.0023842158,0.007508161,-0.00019928883,0.007873661,-0.00036851433,-0.0034237206,0.006644177,0.00076003367,-0.0026401456,-0.00048471938,-0.0009919207,0.00215373,-0.0012850984,-0.005203802,0.0015618792,-0.0026608626,-0.0001951804,8.686055e-05,0.001556082,-0.0011646824,-0.0008392893,-0.0015317765,-1.2766853e-05,0.0005142834,0.00097165303,-0.0060589327,0.0023260654,0.00052293716,-0.0038403433,-0.005436868,-0.002034293,-0.0003280334,0.0025827545,0.0010646166,-0.005085455,0.0038859283,0.0002699415,-0.006666624,-0.000174353,0.0029684564,-0.010378681,-0.00089098,1.9047586e-05,0.004178221,-0.00753471,-0.01828414,-0.0007970603,-0.0059942706,-0.0024758081,0.00052349706,0.0028257659,-0.0037983605,-0.0020852045,0.0031563153,0.0031731229,0.00036302386,-0.005006403,0.0064678066,-0.0040141507,-0.0073892632,-0.0020098058,0.001516702,-0.001673862,-0.0011063698,0.002787962,0.006148355,-0.022244275,-0.01413776,-0.00045387694,-0.0076364176,0.0043544364,0.0011217934,-0.008619024,-0.016344443,-0.010246143,-0.00077637937,0.0027818256,0.0040936023,-0.0016015631,0.0036168837,0.0004129354,-6.595811e-05}, {8,1,3,6,1,3,7,1,6,7,1,7,0,6,3,0,1,255,0,255,255,1,0,8,7,7,0,6,1,3,3,0,0,255,255,7,255,1,0,6,3,6,3,3,6,3,255,1,0,3,1,8,0,6,0,3,3,3,255,1,255,0,0,7,255,0,0,3,7,0,1,3,6,7,6,0,8,7,1,255,255,8,7,1,255,6,3,6,1,1,6,1,0,6,0,0,0,6,6,8,3,1,3,255,1,255,255,255,255,0,3,0,255,6,3,7,0,255,255,255,7,6,0,7,6,255,7,8,6,255,255,255,255,255,255,8,8,3,1,255,8,6,255,0,255,3,255,6,6,7,1,6,6,8,1,3,7,3,255,1,1,8,3,255,255,255,255,0,255,7,6,6,3,3,1,255,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,65535,65535,37,39,41,43,45,47,49,51,53,55,57,59,65535,65535,61,65535,63,65,67,69,71,73,75,77,79,65535,81,83,85,87,89,91,93,95,97,99,101,65535,103,65535,105,107,109,65535,111,113,115,117,119,121,123,125,127,129,131,133,135,137,65535,65535,139,141,143,65535,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,65535,181,65535,65535,65535,65535,183,185,187,65535,189,191,193,195,65535,65535,65535,197,199,201,203,205,65535,207,209,211,65535,65535,65535,65535,65535,65535,213,215,217,219,65535,221,223,65535,225,65535,227,65535,229,231,233,235,237,239,241,243,245,247,249,65535,251,253,255,257,65535,65535,65535,65535,259,65535,261,263,265,267,269,271,65535,273,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,65535,65535,38,40,42,44,46,48,50,52,54,56,58,60,65535,65535,62,65535,64,66,68,70,72,74,76,78,80,65535,82,84,86,88,90,92,94,96,98,100,102,65535,104,65535,106,108,110,65535,112,114,116,118,120,122,124,126,128,130,132,134,136,138,65535,65535,140,142,144,65535,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,65535,182,65535,65535,65535,65535,184,186,188,65535,190,192,194,196,65535,65535,65535,198,200,202,204,206,65535,208,210,212,65535,65535,65535,65535,65535,65535,214,216,218,220,65535,222,224,65535,226,65535,228,65535,230,232,234,236,238,240,242,244,246,248,250,65535,252,254,256,258,65535,65535,65535,65535,260,65535,262,264,266,268,270,272,65535,274,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({34.5,22.5,46,11.5,35,29,367,2.5,522,31,21.5,5.5,7.5,303,370.5,187.5,73,23.5,-0.010861146,22,12.5,20.5,0.00766116,-0.010921085,-0.0010330637,128,386.5,12.5,379,-0.0109448,3763.5,22,-0.0059567373,4.5,6.5,28,20.5,16,4.5,4.5,15.5,33.5,-0.010227898,4.5,0.009935158,15.5,-0.014227914,56.5,6453,20.5,18.5,3733,4343.5,0.0027521446,26.5,20.5,30,156,488,15.5,17.5,380.5,-0.009836341,10.5,0.0031907891,0.002288888,11.5,2.5,9.5,0.009200505,19.5,18.5,15.5,44,-0.005696545,36.5,87,53.5,60,15.5,1054,304,0.014276402,1620,607,4451.5,9.5,4337.5,4535,-0.002273832,0.002938465,3.5,0.00086696644,22,7.5,0.0043451,-0.006928404,8.5,0.01241904,13.5,18.5,78.5,19.5,15.5,0.0062320293,-1.278848e-05,0.0011794408,0.0003211865,26.5,0.004135528,0.011070135,7.5,-0.0005028861,17.5,0.00786287,57,572.5,24233,12268.5,0.00024059454,-0.0016802965,0.0005412935,185.5,20.5,0.006483342,51,0.006762302,-0.0060421447,6453,58.5,28.5,7671.5,-0.005804847,6.5,710.5,314.5,0.006067605,0.0012659348,-0.0066455374,4200,5038.5,-0.0073119267,12617,10.5,12.5,4501.5,6448,-0.00013187986,-0.0014897817,0.0014168182,0.0031137562,0.0022473186,-0.0020088456,0.0043984316,-0.0016436788,0.000747166,-0.0002292778,-0.0025750424,-0.0016138315,-0.0004078905,-0.0036142238,0.004791314,0.002190774,-0.0037978783,-0.0014160324,-0.0003655553,-0.0017137505,0.00084461924,0.0028952246,0.0048336918,0.0005376264,0.0029583084,0.00041630855,-0.0005645476,0.016471654,0.0039145825,-0.001418302,-0.0101764435,0.002332548,-0.0032522257,-0.0056849658,7.532012e-05,0.004055004,0.0034028178,-0.0020000094,-0.00024576174,0.0019434387,-0.0015499713,0.0020368048,0.0027232252,-5.2723255e-05,-0.0031556804,0.0019830174,0.0040309946,-0.0009592545,0.009374726,0.0040760003,0.00198031,-0.0009626257,-0.00020873685,-0.0032417388,0.001629106,-0.00021109286,0.0002920242,-0.002033867,-0.00017066153,0.0010581639,0.005941622,0.010646214,-0.00051467214,-0.0027382036,0.00023444326,-2.5813146e-05}, {6,7,6,8,0,5,3,8,0,0,8,8,8,3,3,0,3,5,255,0,8,8,255,255,255,0,0,8,7,255,7,0,255,8,8,0,8,8,8,8,8,6,255,8,255,8,255,6,6,8,8,7,7,255,3,5,0,3,3,8,8,0,255,8,255,255,8,8,8,255,8,8,8,3,255,7,0,6,6,8,0,7,255,7,7,3,8,7,7,255,255,8,255,0,8,255,255,8,255,8,8,0,8,8,255,255,255,255,3,255,255,8,255,8,255,0,0,0,0,255,255,255,0,8,255,0,255,255,6,0,0,6,255,8,0,3,255,255,255,3,3,255,0,8,8,7,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,65535,65535,65535,43,45,47,49,65535,51,53,65535,55,57,59,61,63,65,67,69,71,65535,73,65535,75,65535,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,65535,105,65535,65535,107,109,111,65535,113,115,117,119,65535,121,123,125,127,129,131,133,65535,135,137,139,141,143,145,65535,65535,147,65535,149,151,65535,65535,153,65535,155,157,159,161,163,65535,65535,65535,65535,165,65535,65535,167,65535,169,65535,171,173,175,177,65535,65535,65535,179,181,65535,183,65535,65535,185,187,189,191,65535,193,195,197,65535,65535,65535,199,201,65535,203,205,207,209,211,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,65535,65535,65535,44,46,48,50,65535,52,54,65535,56,58,60,62,64,66,68,70,72,65535,74,65535,76,65535,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,65535,106,65535,65535,108,110,112,65535,114,116,118,120,65535,122,124,126,128,130,132,134,65535,136,138,140,142,144,146,65535,65535,148,65535,150,152,65535,65535,154,65535,156,158,160,162,164,65535,65535,65535,65535,166,65535,65535,168,65535,170,65535,172,174,176,178,65535,65535,65535,180,182,65535,184,65535,65535,186,188,190,192,65535,194,196,198,65535,65535,65535,200,202,65535,204,206,208,210,212,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({22.5,33,34.5,289.5,86.5,35,82,107.5,158,55.5,128,31,111.5,3597,206.5,86,76,461.5,677.5,-0.004039168,-0.0074547813,0.00079575414,-0.0031933289,27,0.0030433093,77.5,29.5,62,-0.0059960214,38.5,51.5,187.5,-0.0031631594,0.00242633,0.0013542492,-0.00271761,-0.0041975784,-0.00023441714,0.0014536631,22,26.5,43.5,-0.005937801,0.0072204196,412,33,47.5,128.5,121,597,1131,26.5,0.0013964508,0.0002891854,0.0013686912,-0.0009253393,0.0010362556,32.5,-0.0030201084,26.5,618,47.5,35,-0.0033141088,53,92.5,0.00309154,0.003473597,168.5,0.0015088175,0.0046723504,1307.5,1144,23.5,122,22,0.0021821389,-0.0009722351,0.0037935656,-0.0039113713,25201,-0.0016274339,59.5,64,63,111.5,58.5,0.0010848738,-0.0003047523,0.0019317365,0.001231676,1055,1531.5,0.006166389,1711.5,-4.644479e-05,0.0054892437,-0.0010581586,0.00044941326,-0.001145813,0.00021351529,0.00012608634,-0.0011667799,0.0026889278,0.00023503174,-0.005101422,-0.0019331623,-0.00030852164,-0.0022994187,0.004602926,0.00013600213,-0.0024332441,-9.116041e-05,-6.802477e-05,-0.0035127203,-0.003069386,-0.00046240617,0.0004427179,-2.7129367e-05}, {7,6,6,0,0,0,3,2,2,0,0,0,1,0,2,2,0,0,0,255,255,255,255,2,255,0,2,0,255,0,7,0,255,255,255,255,255,255,255,0,0,2,255,255,0,0,6,2,2,0,1,1,255,255,255,255,255,2,255,6,0,6,1,255,2,2,255,255,3,255,255,0,1,3,0,2,255,255,255,255,2,255,6,7,3,1,2,255,255,255,255,1,0,255,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,65535,65535,65535,39,65535,41,43,45,65535,47,49,51,65535,65535,65535,65535,65535,65535,65535,53,55,57,65535,65535,59,61,63,65,67,69,71,73,65535,65535,65535,65535,65535,75,65535,77,79,81,83,65535,85,87,65535,65535,89,65535,65535,91,93,95,97,99,65535,65535,65535,65535,101,65535,103,105,107,109,111,65535,65535,65535,65535,113,115,65535,117,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,65535,65535,65535,40,65535,42,44,46,65535,48,50,52,65535,65535,65535,65535,65535,65535,65535,54,56,58,65535,65535,60,62,64,66,68,70,72,74,65535,65535,65535,65535,65535,76,65535,78,80,82,84,65535,86,88,65535,65535,90,65535,65535,92,94,96,98,100,65535,65535,65535,65535,102,65535,104,106,108,110,112,65535,65535,65535,65535,114,116,65535,118,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({100.5,129,5563.5,63.5,514,4188,5657,28,51.5,1187,742,4009,4786.5,5763.5,5811,22,41.5,30.5,79.5,25.5,-0.0015882358,-0.0018193912,25523.5,5196.5,4342.5,3498,5351.5,5413.5,6071,5675.5,5849.5,22,26.5,52,45,82.5,615,-0.0003093017,79,28.5,215.5,24973,25705.5,111,4054,3849,3130.5,4795,5529.5,5758.5,4947,5586,5626,-0.009575861,-0.00033366715,5617.5,5918.5,6042,6404,22,22,33,22,33.5,-0.0016074808,45.5,55.5,284.5,431,24,49.5,102,0.0007099438,-0.00052252464,197.5,236,0.0002729188,32.5,-0.0023553113,0.0025348081,0.0006076463,99.5,134.5,6624,3537.5,0.0050413967,4100.5,0.0016555603,-0.0012476357,3769,4171.5,5493.5,3820,596.5,7205,5782,5916.5,6617.5,5614,0.00050940056,0.00731103,4878,6666.5,5509.5,6928,5839,0.0107226325,6033.5,7094,3245,49.5,0.0054327887,39.5,22,23,24,-0.0020727662,22,29.5,-0.0005426588,26.5,62.5,60,131,636.5,187.5,774.5,42.5,79.5,0.0013424321,-0.0019783482,0.002610291,0.0046670246,69.5,480,187.5,0.005622907,0.0025929345,7655.5,63,80,106.5,316.5,0.0011999086,-0.0002937171,0.004036483,0.0056189797,0.002155918,0.0030351437,743.5,2411.5,5291.5,0.004852162,3505.5,4316,3702,3969.5,5853,5189.5,5344.5,5508.5,0.0061828787,5439,5531.5,6891,5434.5,0.00070823455,5911,5881.5,4988.5,7043.5,-0.015021413,-0.0026482341,3157,3424,6373,6947,5901.5,0.0035025706,6311,6149.5,9030,5361.5,-0.00020955536,0.001083156,0.0010386497,0.0018057422,-0.0006235005,0.0016887538,0.00048686974,0.00024343083,-0.0015730001,-0.0005758195,-0.0006513285,5.6470373e-05,0.0025433942,0.00040422642,0.005299291,0.0026809361,-0.0011218423,-0.00166525,0.0009199547,0.0017405244,-0.0018181788,0.00051779894,-0.0004760983,0.0005717682,0.0047576274,0.0010987289,-0.0018224627,-0.0010750416,-0.0033641674,-0.0016537862,-0.0006893863,-0.0059977095,-0.00964916,-0.0054445486,0.00252065,0.003883705,0.0007268106,0.0017589744,0.0042962814,0.0021837177,0.000862543,-0.0006415651,-0.0058187903,4.5032506e-05,0.0018318763,0.009503524,-0.0016576026,-4.7310492e-05,0.0008294081,-0.00015585212,0.0010321435,-0.0024712943,0.0017066215,-0.00085943047,0.00030211575,-0.0021224357,-0.012633166,-0.0038878971,-0.0026052683,0.0031011384,-0.0031403922,-0.0015516952,-0.0006926825,0.00018656476,-0.0038507488,-0.00068811746,-0.0008082706,0.00015488312,0.0067719813,0.0022081558,-0.00043769475,0.0034318627,-0.0033779119,0.0009915681,-0.0034923952,-0.013023652,0.0008017169,-0.007433001,0.0034718278,0.0057304827,7.236891e-05,0.000513122,0.0009128217,0.0021374563,-0.00090234383,-0.003926358,0.003939371,-0.00069512386,-0.0022827869,0.0026069588,0.004760619,0.012332421,-0.0076897303,-0.0008051161,0.0102440035,-0.0005172674,0.0014521102,-0.00047712424,1.8837365e-05,0.0029971923,-0.00045704516,-0.0045177536,0.00028551553,0.003490582,-0.0009014906,-3.0282579e-06}, {6,2,2,0,3,6,2,2,6,5,0,6,7,7,2,0,2,6,0,7,255,255,0,2,0,3,3,3,5,6,2,2,0,6,0,2,0,255,6,5,5,0,0,2,5,0,2,2,5,0,0,2,6,255,255,3,6,7,2,6,5,6,2,6,255,2,0,0,0,3,3,0,255,255,0,3,255,5,255,255,255,0,0,0,6,255,0,255,255,7,5,2,3,0,5,5,5,0,6,255,255,5,3,3,6,2,255,2,2,5,6,255,5,2,2,5,255,6,0,255,0,5,0,0,0,0,0,6,0,255,255,255,255,0,2,2,255,255,0,7,5,7,6,255,255,255,255,255,255,5,3,2,255,7,5,3,2,5,7,6,2,255,3,5,6,6,255,0,6,6,0,255,255,0,0,0,6,6,255,3,3,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,65535,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,65535,119,121,123,125,127,129,131,65535,65535,133,135,65535,137,65535,65535,65535,139,141,143,145,65535,147,65535,65535,149,151,153,155,157,159,161,163,165,167,65535,65535,169,171,173,175,177,65535,179,181,183,185,65535,187,189,191,193,65535,195,197,65535,199,201,203,205,207,209,211,213,215,65535,65535,65535,65535,217,219,221,65535,65535,223,225,227,229,231,65535,65535,65535,65535,65535,65535,233,235,237,65535,239,241,243,245,247,249,251,253,65535,255,257,259,261,65535,263,265,267,269,65535,65535,271,273,275,277,279,65535,281,283,285,287,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,65535,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,65535,120,122,124,126,128,130,132,65535,65535,134,136,65535,138,65535,65535,65535,140,142,144,146,65535,148,65535,65535,150,152,154,156,158,160,162,164,166,168,65535,65535,170,172,174,176,178,65535,180,182,184,186,65535,188,190,192,194,65535,196,198,65535,200,202,204,206,208,210,212,214,216,65535,65535,65535,65535,218,220,222,65535,65535,224,226,228,230,232,65535,65535,65535,65535,65535,65535,234,236,238,65535,240,242,244,246,248,250,252,254,65535,256,258,260,262,65535,264,266,268,270,65535,65535,272,274,276,278,280,65535,282,284,286,288,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({26.5,928.5,924,329,1768.5,812.5,1344,7.5,6,-0.011623044,8.5,599.5,20.5,1347,2066,86,27,-0.0057351924,222.5,0.00055399566,-0.0006664963,565,841,7.5,1540,1170.5,1177.5,2057.5,3880,4.5,271.5,11.5,469.5,0.001080505,15.5,5431,18.5,18.5,12.5,990,18.5,0.013826414,-0.0011209591,19.5,912.5,18.5,1402,12.5,18.5,15.5,4188,22,50,4,0.0007449048,26.5,30,19.5,15.5,0.013091526,0.0018151643,569,5683.5,520.5,0.014507303,6.5,671.5,775.5,728.5,2.5,6597,879,878.5,1434.5,748.5,15.5,15.5,990,2464.5,15.5,10.5,3245.5,2031,8.5,0.02216737,2826,2826,5981,5229.5,49.5,-0.0034789497,5.5,-0.0018086078,0.0067929863,0.0044206963,9.5,-0.00070851034,22,18.5,15.5,240,-0.0011826605,0.0066207363,472,278,-0.0071968683,12.5,0.0065401206,570.5,484.5,624,-0.0027759736,-0.015523623,4.5,930,1041.5,5003.5,-0.0008184636,0.011575897,-0.0015353176,10210,1588,6500.5,-0.0040430394,0.0069730715,2.5,9.5,0.0010986268,-0.017155318,10,0.016971916,6.5,-0.011858925,5722.5,6.5,1209,9364,1230.5,-0.012238926,1197,1540,5.5,42.5,1447.5,18.5,-0.0026871013,-0.00076979573,7.5,4128,1540,4566.5,4087,6115,6978.5,5328.5,-0.0008486585,0.00110602,0.00044909125,0.002525179,0.0017956361,0.0010117983,-0.0010905889,0.0011636609,-0.0013634113,0.0039585372,-0.0037271627,0.001998562,-0.0034735177,-0.011412501,0.00016786547,-0.0027798444,0.00016976144,0.0027235816,0.00019116235,-0.0011305178,-0.0055974284,0.0012902927,-0.016105583,-0.000742923,0.0093343025,-0.00014656829,0.0028820133,-0.0016407656,-0.00907794,-0.0018760938,-0.0065460103,0.0011440798,0.0048192195,0.0004079969,0.0037023749,0.0015984344,0.003926532,0.0001576066,-0.0026968007,0.00065149926,-0.0077747977,-0.0022275466,0.0051146355,0.0013030787,0.000324677,-0.0036862988,-0.0013426997,0.0049073524,-0.004244462,0.00041783552,0.003427563,-0.00029993945,0.004854544,0.011919763,-0.0040310747,8.547448e-05,-0.0044748113,-0.00029983657,0.0054732813,-0.0011710739,-0.00013521926,-0.003920251,0.00011955919,0.004178576,-0.003803306,0.00026834063,-0.0051387167,5.6444074e-05,-0.0021841784,-0.009918572,0.00019703673,-0.005650307,0.0011847063,-0.0011286631,-0.0042438684,0.00488557,-0.0026340801,0.0014910002,0.0016236475,0.0048533618,-0.004939675,0.0003817713,-0.00020061476,-0.0026497634,0.0020091839,2.38632e-05}, {6,1,1,2,1,1,1,8,8,255,8,1,8,6,6,2,2,255,1,255,255,1,7,8,2,1,1,6,6,8,1,8,1,255,8,7,8,8,8,3,8,255,255,8,6,8,2,8,8,8,6,6,1,8,255,1,1,8,8,255,255,3,7,7,255,8,1,1,1,8,2,1,1,3,7,8,8,1,2,8,8,1,6,8,255,1,1,1,6,2,255,8,255,255,255,8,255,6,8,8,1,255,255,1,1,255,8,255,1,2,1,255,255,8,3,2,2,255,255,255,3,2,6,255,255,8,8,255,255,8,255,8,255,6,8,3,2,1,255,1,7,8,2,1,8,255,255,8,3,7,3,3,1,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,21,23,25,27,29,31,65535,33,65535,65535,35,37,39,41,43,45,47,49,51,53,55,57,65535,59,61,63,65,67,69,71,65535,65535,73,75,77,79,81,83,85,87,89,91,93,65535,95,97,99,101,65535,65535,103,105,107,65535,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,65535,147,149,151,153,155,65535,157,65535,65535,65535,159,65535,161,163,165,167,65535,65535,169,171,65535,173,65535,175,177,179,65535,65535,181,183,185,187,65535,65535,65535,189,191,193,65535,65535,195,197,65535,65535,199,65535,201,65535,203,205,207,209,211,65535,213,215,217,219,221,223,65535,65535,225,227,229,231,233,235,237,239,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,22,24,26,28,30,32,65535,34,65535,65535,36,38,40,42,44,46,48,50,52,54,56,58,65535,60,62,64,66,68,70,72,65535,65535,74,76,78,80,82,84,86,88,90,92,94,65535,96,98,100,102,65535,65535,104,106,108,65535,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,65535,148,150,152,154,156,65535,158,65535,65535,65535,160,65535,162,164,166,168,65535,65535,170,172,65535,174,65535,176,178,180,65535,65535,182,184,186,188,65535,65535,65535,190,192,194,65535,65535,196,198,65535,65535,200,65535,202,65535,204,206,208,210,212,65535,214,216,218,220,222,224,65535,65535,226,228,230,232,234,236,238,240,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({22.5,500.5,36.5,21.5,14.5,21.5,1500,132,67.5,0.0151265785,-0.003545458,18.5,27,1497,817.5,14.5,18.5,0.0036189228,-0.010721183,11.5,37,-0.008940083,-0.0009891263,1394,12.5,1044.5,1198,72,86,7.5,0.0111934375,9.5,246.5,20.5,817.5,1299.5,1172,6.7976794e-06,0.012805303,934,20.5,16.5,1470.5,49.5,114,20.5,55.5,2.5,15.5,126,10.5,35,0.0019307235,27,33,-0.0077116126,0.0046648677,21.5,19.5,-0.006290247,1443,651.5,2067,6.5,4555.5,719.5,20.5,5634,973,26.5,83.5,8.5,-0.0004886883,19.5,19.5,-0.0067707873,0.00091963523,-0.0016665874,4.5,469.5,240,30,0.0029810013,55,27,710,12.5,22,19.5,-0.003023376,0.0033946752,230,1166,1411,1254.5,3.5,6.5,15.5,12.5,8.5,-0.012198426,4555.5,562.5,-0.011615389,8457.5,1.5,5.5,6403.5,3558,1349,10514,18.5,6655,0.0013006174,-0.00021833638,-0.000527418,-0.004102317,0.0061908946,0.0040288675,-0.001994291,-0.0012709828,0.0010609169,-0.0010791023,0.0032074053,0.004980806,-0.0059705833,0.0018248238,0.007538507,-0.0008738185,-0.0021596865,0.0003213774,0.009648048,0.0002566574,-0.0024362172,0.0030357146,-0.0011338771,-0.004625218,0.00019314938,-0.0038970977,0.003531808,0.011870569,-0.0006677672,0.0032050237,-6.945448e-05,0.00040391722,0.0003062803,0.007994383,0.00200129,-0.0013810714,0.014911401,-0.0012767389,0.003708908,-0.0022279364,0.004759578,0.0006433954,-0.0014199044,-0.008264294,-0.005250939,0.0039485577,0.00029906104,-0.005332937,0.002387054,0.00027610094,0.003031357,-0.00045331434,-0.0027058327,0.001210562,0.003929047,0.00076337997,-0.0018919787,3.9669318e-05,-0.00737322,0.0003668801,0.013591602,-0.003002563,0.0071587944,0.0020702973,-0.0027832917,0.00042519227,0.0026471214,-0.0026470178,-0.00011981253,7.467495e-05}, {7,2,4,8,8,8,4,1,2,255,255,8,7,4,7,8,8,255,255,8,2,255,255,4,8,5,2,1,2,8,255,8,2,8,1,5,2,255,255,5,8,8,2,2,1,1,4,8,8,2,8,7,255,2,2,255,255,8,8,255,4,5,4,8,5,2,8,4,5,1,4,8,255,8,8,255,255,255,8,1,1,7,255,1,1,1,8,2,8,255,255,7,1,1,4,8,8,8,8,8,255,5,1,255,4,8,8,4,4,2,1,8,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,19,21,23,25,27,29,65535,65535,31,33,65535,65535,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,65535,65535,61,63,65,67,69,71,73,75,77,79,81,83,85,65535,87,89,65535,65535,91,93,65535,95,97,99,101,103,105,107,109,111,113,115,117,65535,119,121,65535,65535,65535,123,125,127,129,65535,131,133,135,137,139,141,65535,65535,143,145,147,149,151,153,155,157,159,65535,161,163,65535,165,167,169,171,173,175,177,179,181,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,20,22,24,26,28,30,65535,65535,32,34,65535,65535,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,65535,65535,62,64,66,68,70,72,74,76,78,80,82,84,86,65535,88,90,65535,65535,92,94,65535,96,98,100,102,104,106,108,110,112,114,116,118,65535,120,122,65535,65535,65535,124,126,128,130,65535,132,134,136,138,140,142,65535,65535,144,146,148,150,152,154,156,158,160,65535,162,164,65535,166,168,170,172,174,176,178,180,182,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3201.5,269.5,4381,256.5,317,4226,4429,1259.5,324,21.5,15.5,3962.5,4935.5,15.5,3215,908.5,16.5,7.5,-0.0061327512,18.5,432.5,2264,1609,15.5,4.5,2.5,9919.5,9.5,19.5,0.0051265806,5550.5,248,6.5,139.5,0.00035881714,-0.003741622,0.0010160723,419.5,220.5,0.02139645,0.00020429467,870,3169,1483,1799,6204.5,5365,8776,16.5,4407,3900.5,13,-0.0017854654,4407.5,-0.00048301165,0.007970876,0.00065088406,5549.5,5696,64.5,11.5,175,949,87,0.00012366202,350,3553.5,3553.5,0.015751485,1268,984,7.5,3687.5,1256.5,1225,18.5,879,3670,4.5,3587,7053.5,6864.5,9486,6271.5,9101,4360.5,0.0046572806,12,9187.5,-0.0075117387,-0.013057438,-0.00013647623,0.0051986547,4986.5,12.5,5777.5,5750.5,35,6.5,175,847.5,4.5,3.5,15.5,18.5,-0.0026223043,8.5,7.5,389,14.5,2.5,868,-0.007646911,861.5,1427.5,14.5,1999,2.5,12.5,4.5,651,778,1712.5,-0.020807475,-0.0025617315,922,1316.5,18.5,1268.5,2435.5,4.5,1695.5,12.5,3790.5,4015.5,1733.5,6004,4079.5,-0.0006336325,0.01149596,0.0024866327,5932.5,9486,4750,9309.5,-0.00480492,-0.006836974,8.5,3698,14.5,10975,4192,9394.5,-7.129103e-06,0.013915575,5490.5,5534.5,5738,5887,-1.2929752e-05,-0.0010123061,0.0018399482,6.0367987e-05,-0.0024722565,-0.0005967032,-0.00018577257,0.0023556757,0.0034392872,0.006713271,0.002539583,0.0014270548,0.0041910815,0.00019499681,-4.2776424e-05,-0.0024141094,-0.0033533636,-0.005056461,0.0037643127,0.00016577754,0.012373888,0.0033473969,-0.001314467,-0.006042272,0.0059449417,0.001496411,-0.0010415327,0.009080361,0.00067927904,0.0037914612,-0.004228897,-0.00036866026,0.0025486795,0.009680567,0.0004225792,0.0021586868,-0.0040987497,0.003605101,-0.006080448,0.0007767588,0.008652609,0.0032568201,0.006450206,0.00029883938,-0.0032962486,0.0005130581,-0.01087661,-0.0020234927,0.0061019133,-0.0033553366,0.00043209744,0.013859837,-0.002371647,0.010401079,-0.013110093,-0.000105452586,-0.0014651488,0.004496373,-0.0018029176,4.1613774e-05,-0.0073054405,0.0007648853,-0.0035942595,-0.0007793245,0.0031214838,-0.0015414597,-0.013350098,-0.0011794771,-0.0020259332,0.0027347712,0.005329264,-0.0025561338,0.0057932725,0.0018116989,0.0029407903,-0.0028343853,-1.0144677e-05,0.0021996065,0.002537785,0.007636124,-0.009857929,-0.0011226834,-0.0056838836,-0.010590143,0.00037364932,-9.727221e-05,-0.00044782582,-0.0027988988,0.003484663,0.00023817823,3.460419e-05,-0.0020145483,0.00074921973,-0.0004897734,-0.0045048995,-0.013120509,0.005175823,-0.001030327,0.0004778478,0.008749719,-0.001806446,1.2626364e-05}, {5,1,1,1,6,1,1,2,2,8,8,1,5,8,5,2,8,8,255,8,2,4,2,8,8,8,5,8,8,255,5,2,8,1,255,255,255,1,6,255,255,5,6,2,2,2,4,4,8,5,5,8,255,1,255,255,255,5,5,1,8,6,2,1,255,5,1,1,255,6,5,8,6,5,6,8,6,5,8,1,5,2,4,2,4,5,255,8,6,255,255,255,255,6,8,4,5,1,8,5,5,8,8,8,8,255,8,8,1,8,8,1,255,4,6,8,1,8,8,8,1,6,6,255,255,5,4,8,6,1,8,1,8,2,5,1,6,1,255,255,255,6,4,5,4,255,255,8,5,8,2,6,6,255,255,4,6,5,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,65535,57,59,61,63,65535,65535,65535,65,67,65535,65535,69,71,73,75,77,79,81,83,85,87,89,65535,91,65535,65535,65535,93,95,97,99,101,103,105,65535,107,109,111,65535,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,65535,147,149,65535,65535,65535,65535,151,153,155,157,159,161,163,165,167,169,171,173,65535,175,177,179,181,183,185,65535,187,189,191,193,195,197,199,201,203,205,65535,65535,207,209,211,213,215,217,219,221,223,225,227,229,231,65535,65535,65535,233,235,237,239,65535,65535,241,243,245,247,249,251,65535,65535,253,255,257,259,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,65535,58,60,62,64,65535,65535,65535,66,68,65535,65535,70,72,74,76,78,80,82,84,86,88,90,65535,92,65535,65535,65535,94,96,98,100,102,104,106,65535,108,110,112,65535,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,65535,148,150,65535,65535,65535,65535,152,154,156,158,160,162,164,166,168,170,172,174,65535,176,178,180,182,184,186,65535,188,190,192,194,196,198,200,202,204,206,65535,65535,208,210,212,214,216,218,220,222,224,226,228,230,232,65535,65535,65535,234,236,238,240,65535,65535,242,244,246,248,250,252,65535,65535,254,256,258,260,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5770.5,5767,5775.5,3761.5,-0.010351624,6851.5,6008.5,12.5,3763.5,0.00431975,0.010084028,5717,6404,63.5,1243.5,5,1582.5,5528.5,6095.5,6149.5,7137.5,67.5,88.5,1125.5,1259.5,2.5,16.5,458.5,4786.5,18.5,6931,5524.5,5641,5782.5,6671,9030,7145,1.5,79.5,115,26.5,1052,142,727.5,1331,-0.0061575724,3.5,10.5,20,-0.0011012169,-0.011552048,4616,5596.5,15.5,4431,5870.5,8.5,0.0012960568,5924.5,1567.5,17.5,6144.5,6265.5,6333.5,5825,8064,6689,4341,7620.5,26.5,34,0.009912462,35,1.5,6.5,490,28,991.5,18.5,-0.011247385,15.5,515,1175.5,-0.012649027,1496,-0.0037412157,-0.005217656,-0.00032602923,0.0026341458,-0.004530059,-0.0011739172,4402.5,4761.5,5589,5780,5582.5,5815.5,0.004156217,4331,15.5,0.010935138,5550.5,8558,-0.012834909,5861.5,0.00016825528,14.5,7427,6731.5,7014,5551.5,0.011748702,9708.5,5512,6959.5,9572.5,16.5,6198.5,6815.5,6405.5,6990,-0.0016881091,-0.009496228,6901.5,7771.5,-0.005175855,0.0014973046,0.000870277,-0.00055661355,-8.7707755e-05,0.0021187076,0.0011977577,-0.0013517457,-0.007331858,0.0016918302,0.001167084,0.0070879236,-0.010328538,-0.00022018624,-0.00010770103,-0.009236522,-0.0038621041,0.018221019,0.0016199325,-0.0041242754,8.514902e-05,-0.007936577,0.0056491983,-0.0008273865,-0.0011350204,0.00058811565,-0.00062968064,-0.009918776,-0.0006360524,-0.00342585,0.00022411851,0.0056877057,-0.0052905036,-0.0001592179,-0.0015529932,0.0024464987,0.00021295021,0.008128855,-0.0027099743,-0.005148039,0.0020368027,0.009861955,0.007665773,8.1573984e-05,-0.00625904,0.0006083103,-0.002429841,-0.006766221,-0.002170809,-0.009020936,0.005570975,-0.0023383102,0.003204877,0.012399259,0.0048059514,-0.00028314118,-0.0032753653,-0.0005784671,-0.009581036,0.0016745733,-0.002235188,-0.011552874,0.0005206204,-0.004747115,-0.0053531392,0.0012768222,0.0009972556,0.0053002564,0.0016275963,-0.00016232721,-0.00077600306,-0.0070416178,0.0008267285,-0.008657104,0.0031907477,0.013461597,-0.001855487,-7.5573844e-05,0.0013427921,-1.8513738e-06}, {2,2,2,3,255,0,2,8,3,255,255,3,2,2,2,8,0,1,3,3,2,1,3,2,3,8,8,0,7,8,0,7,0,3,3,0,2,8,1,2,7,3,7,7,2,255,8,8,8,255,255,0,3,8,7,0,8,255,7,0,8,2,0,7,7,0,7,1,2,1,7,255,7,8,8,2,7,3,8,255,8,7,7,255,7,255,255,255,255,255,255,0,7,3,3,3,2,255,1,8,255,7,0,255,2,255,8,1,3,0,1,255,0,7,7,1,8,1,7,3,2,255,255,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,65535,9,11,13,15,65535,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,87,89,65535,65535,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,141,65535,143,145,147,65535,149,65535,65535,65535,65535,65535,65535,151,153,155,157,159,161,65535,163,165,65535,167,169,65535,171,65535,173,175,177,179,181,65535,183,185,187,189,191,193,195,197,199,65535,65535,201,203,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,65535,10,12,14,16,65535,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,88,90,65535,65535,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,142,65535,144,146,148,65535,150,65535,65535,65535,65535,65535,65535,152,154,156,158,160,162,65535,164,166,65535,168,170,65535,172,65535,174,176,178,180,182,65535,184,186,188,190,192,194,196,198,200,65535,65535,202,204,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({15985.5,20037.5,16100.5,13199,16125.5,21610,17591.5,12083.5,27637.5,7419.5,23352.5,16056,13629.5,19626,15547.5,15040.5,9997.5,15671.5,14948.5,31041.5,11726.5,19149.5,21102,-0.0003703518,-0.0029617408,0.010942624,0.015622163,19984,18459,30111,16173.5,13208.5,21462,9339,8833.5,11436,25663.5,26003,30964,23089.5,-0.0014148834,3264,-0.0052745505,0.007891716,18396,0.0108120255,0.0065678186,13215,12298,20553.5,16643,22782,18039,17995.5,17151.5,12644.5,9513.5,18960.5,11968.5,9955,-0.009943903,0.004399016,10324,11650.5,16504,19306.5,16293,0.0007191324,15581.5,25415.5,-0.0049539334,-0.0005593967,29777.5,-0.0017990886,0.0004836913,23742.5,21707,15114.5,18070.5,-0.0024243898,27556,16685,23638,21831,22000,18090,-0.0026269814,-0.0057755536,31484.5,17702,-0.020945966,19329.5,27008,12541.5,11460,0.003061151,11697,10126,6952,27177,14342.5,8183,17744,3579,19929,5585.5,11997.5,12531,18624,17745.5,0.007642937,11384,28586.5,14404,-0.0020019452,0.0023004233,18058.5,24901.5,32053,-0.0013673216,0.0016078338,0.0030809653,0.0046385704,17088.5,0.008805666,17731.5,21610,13472,0.009740351,0.0055796667,0.010026007,0.005243925,0.003727706,16243.5,21476,0.0015222364,-0.009077884,18614,19932.5,0.00012218537,-0.0011863153,-0.0011888166,-0.00046587462,18723,21980,32516.5,26238.5,-7.5785465e-05,-0.0030325276,0.0005263381,0.004834044,-0.0010836548,-0.0074927197,0.0026459694,-0.0005266181,-8.592614e-05,-0.0058209775,0.0012993809,-0.0001688258,-0.0014073609,-0.0045496305,-0.0007379611,-0.0026062613,0.0023616124,-0.000465458,0.0023251912,7.176422e-06,0.0034391717,-1.864499e-05,-0.0005807461,0.0007108289,0.0022862074,0.0046421727,-0.0015308042,-0.0049037146,0.008460313,-0.0008795055,-0.0023846035,0.001964908,0.00089314906,-0.0021673783,0.0049071116,3.0719824e-05,-0.0067509497,-0.010739255,-0.0006983847,2.506937e-05,0.0015920693,0.0024230604,-0.001119417,0.002948593,0.0015634336,-0.0016997174,-0.0011706824,-0.0071631405,0.006900241,-0.00033782548,0.00838744,0.0036954393,-0.0036413644,0.0009632045,0.009077344,0.0021086512,0.0035712495,-0.0017838344,0.007835085,0.004290756,0.001284374,-0.0014053758,0.006958598,0.0034221744,-0.0023511946,0.00034349234,0.0034865846,6.5436024e-07}, {7,1,7,1,6,2,1,1,6,7,6,7,5,5,5,6,5,5,1,5,2,6,1,255,255,255,255,7,7,6,5,5,4,5,4,6,4,4,6,1,255,2,255,255,5,255,255,2,1,5,1,1,1,1,5,4,1,6,1,2,255,255,6,7,4,5,1,255,5,2,255,255,1,255,255,4,1,1,2,255,4,1,5,5,7,4,255,255,2,1,255,7,4,4,7,255,6,2,5,2,5,4,2,2,4,7,7,6,6,6,255,7,2,1,255,255,1,1,1,255,255,255,255,6,255,6,6,1,255,255,255,255,255,2,7,255,255,1,1,255,255,255,255,7,1,7,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,65535,65535,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,65535,65535,75,65535,65535,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,65535,103,105,107,109,111,65535,113,115,65535,65535,117,65535,65535,119,121,123,125,65535,127,129,131,133,135,137,65535,65535,139,141,65535,143,145,147,149,65535,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,181,183,65535,65535,185,187,189,65535,65535,65535,65535,191,65535,193,195,197,65535,65535,65535,65535,65535,199,201,65535,65535,203,205,65535,65535,65535,65535,207,209,211,213,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,65535,65535,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,65535,65535,76,65535,65535,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,65535,104,106,108,110,112,65535,114,116,65535,65535,118,65535,65535,120,122,124,126,65535,128,130,132,134,136,138,65535,65535,140,142,65535,144,146,148,150,65535,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,182,184,65535,65535,186,188,190,65535,65535,65535,65535,192,65535,194,196,198,65535,65535,65535,65535,65535,200,202,65535,65535,204,206,65535,65535,65535,65535,208,210,212,214,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({37,574,22,339.5,22.5,6478,50.5,309,-0.0038076197,0.0040826625,29.5,60.5,0.004195521,37.5,309.5,22,0.004693145,0.006314523,67,-0.00028778543,61,100,48,284.5,39.5,26.5,39.5,32053,25020,42.5,501,26,-0.00050013507,58.5,61.5,276.5,422.5,-0.007911894,465,22,32.5,25.5,32.5,29777.5,0.0035449087,26.5,-0.001534759,25.5,0.0010488757,-0.0009072344,0.00082689937,-0.002296793,-0.004739975,36,183.5,-0.0018560182,0.0012318726,269,802.5,258.5,5148.5,770.5,522,3409,-0.0024209095,34,-0.0012486706,26.5,27,58,271.5,26.5,-0.0020473504,5211.5,0.0010303514,0.001449841,0.0021178636,0.00019494069,0.0029731719,-0.0001765776,-0.0014459642,61.5,794,0.00059495046,-0.012172598,184,350.5,3279,6042.5,458.5,987.5,1350,591,-0.00028105674,0.00049466704,0.0011214782,0.000781716,0.0011367507,-0.00024573586,-7.973946e-05,0.0019592775,-0.00031823036,0.0020575507,-0.0022734061,0.0011472988,0.0002531861,0.0024066889,6.46864e-05,-0.00013877667,0.00048698104,-0.00036835574,0.0030034492,-6.202944e-05,0.0008796314,0.0035288904,0.006203251,0.0014296401,-0.00036611973,0.0021393762,-0.0062670694,-0.00047621928,-0.0002744873,-0.006730818,-0.011308839,0.0006139921,0.0038144328,-0.00031770382,-0.002137088,-1.824029e-05}, {6,1,2,1,7,1,6,1,255,255,2,6,255,1,1,2,255,255,4,255,4,2,6,3,7,1,1,1,2,4,1,1,255,1,1,3,7,255,7,1,4,1,4,1,255,6,255,4,255,255,255,255,255,2,1,255,255,7,2,7,6,6,7,4,255,1,255,3,2,3,1,4,255,1,255,255,255,255,255,255,255,7,6,255,255,1,3,6,6,7,6,4,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,65535,17,19,65535,21,23,25,65535,65535,27,65535,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,65535,61,63,65,67,69,71,65535,73,65535,75,65535,65535,65535,65535,65535,77,79,65535,65535,81,83,85,87,89,91,93,65535,95,65535,97,99,101,103,105,65535,107,65535,65535,65535,65535,65535,65535,65535,109,111,65535,65535,113,115,117,119,121,123,125,127,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,65535,18,20,65535,22,24,26,65535,65535,28,65535,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,65535,62,64,66,68,70,72,65535,74,65535,76,65535,65535,65535,65535,65535,78,80,65535,65535,82,84,86,88,90,92,94,65535,96,65535,98,100,102,104,106,65535,108,65535,65535,65535,65535,65535,65535,65535,110,112,65535,65535,114,116,118,120,122,124,126,128,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({20.5,522,5164,3.5,13.5,4885,5322,33.5,15.5,0.00029784004,0.012995625,4698,4927,5487.5,5383,22,22,132,22,4543.5,18.5,4909,4.5,5008,6654.5,16.5,5390.5,2.5,-0.0022092012,0.0019738097,0.0074285427,76,380.5,20.5,20.5,4325.5,4566.5,4640.5,4719,7.5,-0.012649195,5331.5,4958.5,17.5,7148,5476,13.5,3.5,6133.5,0.0048152264,5052.5,0.0010142807,0.0015716063,26.5,0.0027925353,7.5,9.5,19.5,21.5,22,21.5,504,4530,-0.00817499,4594.5,0.0026524572,5602,0.016818264,5342.5,0.0014573018,15.5,4985,2982,4993,5697.5,5293.5,6322,4661.5,5076.5,7.5,-0.006958884,5223.5,5188,5237.5,5494,5377.5,0.0016565531,4930.5,5401.5,22,5.5,0.004169483,12.5,-0.011874858,0.01113907,18.5,-0.0027812107,0.001139983,0.00042807846,0.006005407,49.5,-0.0035126468,0.0016957325,378,1116,3353.5,17.5,4630,3797,4752.5,15.5,-0.0001429852,0.006730026,-0.004681927,0.0006210383,4998,2781.5,0.0053165723,5569.5,7.5,4904,5303,4980,12.5,-0.002749294,0.0056221858,-0.00096165325,3009,8.5,7.5,16.5,5254,3846,4.5,4.5,0.0012814183,5550,0.005177565,0.00092268764,5389.5,-0.0045401193,5382.5,-0.009724819,5535,5263.5,6349.5,5432.5,0.00023663252,0.002187331,0.0017881107,-0.001383475,-0.0044866763,-0.007400952,-0.0009737471,-0.0014689472,0.00036067818,0.0055186297,1.652582e-05,0.0028497349,-0.0008935296,0.00010998733,-0.0006657852,0.007167241,-0.00083375344,0.0033176558,0.002301746,-0.0008499279,-0.0046074064,-0.0009748703,-0.0012709642,-0.00025373432,0.00047851593,0.0020318134,0.003472913,0.0008692294,0.00096297794,-0.0017380212,-0.0048773917,-0.0020198894,0.0024796587,-0.0039735115,0.0009503546,0.008550902,-0.0024833556,-0.009453023,0.0035012194,-0.00023445315,0.0005744879,-0.0012570266,0.0011872741,0.0042425864,0.0046870965,0.008702817,0.004119254,0.0007900297,-0.0007190152,0.00019735475,0.003956633,-0.00014124997,-0.0002714731,-0.003764315,0.0031974488,0.00024690785,-0.00019619439,-0.0025818013,0.0055369223,0.0024706745,0.0013994306,-0.002546235,-0.0035803616,-0.00605475,-0.0041798316,0.00014502846,0.0063446234,0.0012732433,-0.0037606624,-0.00029066598,0.00419753,3.9408693e-05}, {7,0,0,8,8,0,0,0,8,255,255,0,0,4,0,0,4,1,0,0,8,0,8,4,4,8,0,8,255,255,255,0,0,8,8,0,0,1,0,8,255,4,1,8,7,5,8,8,7,255,4,255,255,0,255,8,8,8,8,4,8,0,4,255,0,255,1,255,1,255,8,1,1,0,1,0,1,7,5,8,255,0,0,7,1,0,255,7,4,0,8,255,8,255,255,8,255,255,255,255,4,255,255,1,7,5,8,4,7,0,8,255,255,255,255,0,4,255,4,8,1,1,0,8,255,255,255,7,8,8,8,0,7,8,8,255,1,255,255,4,255,7,255,0,7,0,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,65535,65535,53,55,57,59,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,65535,87,65535,65535,89,65535,91,93,95,97,99,101,103,105,65535,107,65535,109,65535,111,65535,113,115,117,119,121,123,125,127,129,131,65535,133,135,137,139,141,65535,143,145,147,149,65535,151,65535,65535,153,65535,65535,65535,65535,155,65535,65535,157,159,161,163,165,167,169,171,65535,65535,65535,65535,173,175,65535,177,179,181,183,185,187,65535,65535,65535,189,191,193,195,197,199,201,203,65535,205,65535,65535,207,65535,209,65535,211,213,215,217,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,65535,65535,54,56,58,60,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,65535,88,65535,65535,90,65535,92,94,96,98,100,102,104,106,65535,108,65535,110,65535,112,65535,114,116,118,120,122,124,126,128,130,132,65535,134,136,138,140,142,65535,144,146,148,150,65535,152,65535,65535,154,65535,65535,65535,65535,156,65535,65535,158,160,162,164,166,168,170,172,65535,65535,65535,65535,174,176,65535,178,180,182,184,186,188,65535,65535,65535,190,192,194,196,198,200,202,204,65535,206,65535,65535,208,65535,210,65535,212,214,216,218,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31.5,25.5,74.5,32.5,26.5,51.5,22,24,34.5,65.5,61,22,26,238.5,8042.5,41,46,486,268,158.5,127.5,128,136.5,0.0033464886,39,22,33,0.0010757162,-0.012729458,8012,8084,70,22,943.5,-0.0046557537,0.0014222513,0.0055298572,93,5461,79.5,12076,44,499,42,-0.0076608807,128,130.5,44,652.5,-0.0020548399,1144.5,0.0010021516,63.5,14109,5435.5,5219.5,8096,24,0.0010541133,-0.0004060332,-0.0014997488,23.5,-0.0001598697,99,78,1522,0.00067190285,43,0.0013055891,-0.008376349,0.0014431685,-0.0050417897,-0.008529035,-0.0022628622,2048,-0.00044127248,-0.0023279467,26.5,-0.00488451,74.5,0.0068586194,26.5,-0.0027558745,284.5,27.5,197.5,0.0018423923,30.5,0.005239418,5937.5,25705.5,8029.5,7049.5,-0.009077174,1987.5,7178,9091.5,22,43.5,-0.00086039753,-0.0012200838,-0.00096285995,0.0010875583,0.0021822534,0.00156133,22,-0.0010912858,32.5,-0.0053328346,0.0005922566,-0.00093798107,-0.0027544973,83.5,-0.0012143474,0.0006320194,-0.00031385545,-0.0007747954,53,595.5,25496.5,71,0.00027280033,0.00060033944,0.002579454,0.0039386363,5782.5,5058,5736.5,27616,5114.5,5050,0.008262931,0.0032484233,-0.0079674525,6502.5,0.0066113146,0.0032695439,10822,2188.5,-0.0002297338,6.884802e-05,0.0011152417,-7.5073964e-05,-0.00052299857,-0.00034754476,-0.000392807,-0.00089719484,-0.00013880696,-0.0013547594,0.001502575,-0.00022089249,0.0014553842,0.002974344,-0.00278722,0.001423323,0.0015583878,0.00013922765,0.00013979441,0.0025834588,0.001877929,-0.0003828413,0.0010689616,0.002261585,-0.0030149336,0.0003003535,-0.000102010265,0.003166773,-0.0018682532,-0.0003307529,-0.0011732698,0.003693856,-0.0002771668,-0.0026650326,-0.0013427889,2.1527978e-05}, {3,3,4,5,5,4,6,5,4,6,6,0,7,0,6,7,4,0,6,0,6,4,4,255,0,6,0,255,255,6,6,0,0,0,255,255,255,6,4,0,0,7,6,0,255,0,0,3,0,255,0,255,4,0,3,0,6,3,255,255,255,0,255,4,0,4,255,0,255,255,255,255,255,255,6,255,255,3,255,0,255,0,255,0,7,0,255,5,255,3,0,6,3,255,7,0,6,0,0,255,255,255,255,255,255,3,255,0,255,255,255,255,0,255,255,255,255,0,0,0,3,255,255,255,255,3,5,7,0,0,4,255,255,255,3,255,255,0,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,65535,65535,53,55,57,59,61,65535,65535,65535,63,65,67,69,71,73,75,65535,77,79,81,83,65535,85,65535,87,89,91,93,95,97,65535,65535,65535,99,65535,101,103,105,65535,107,65535,65535,65535,65535,65535,65535,109,65535,65535,111,65535,113,65535,115,65535,117,119,121,65535,123,65535,125,127,129,131,65535,133,135,137,139,141,65535,65535,65535,65535,65535,65535,143,65535,145,65535,65535,65535,65535,147,65535,65535,65535,65535,149,151,153,155,65535,65535,65535,65535,157,159,161,163,165,167,65535,65535,65535,169,65535,65535,171,173,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,65535,65535,54,56,58,60,62,65535,65535,65535,64,66,68,70,72,74,76,65535,78,80,82,84,65535,86,65535,88,90,92,94,96,98,65535,65535,65535,100,65535,102,104,106,65535,108,65535,65535,65535,65535,65535,65535,110,65535,65535,112,65535,114,65535,116,65535,118,120,122,65535,124,65535,126,128,130,132,65535,134,136,138,140,142,65535,65535,65535,65535,65535,65535,144,65535,146,65535,65535,65535,65535,148,65535,65535,65535,65535,150,152,154,156,65535,65535,65535,65535,158,160,162,164,166,168,65535,65535,65535,170,65535,65535,172,174,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({62,33,4375.5,30.5,28.5,4151.5,4535,56,36.5,180.5,33.5,4443,6793.5,3172,8643.5,26,0.0024882162,40.5,28.5,23.5,12922.5,36.5,30.5,4021.5,4551.5,4671.5,5099.5,3558,7232.5,8553.5,8763,22,28,28.5,0.0045355586,-0.0010942327,0.00044718361,28,25.5,0.003446669,0.00048044338,0.002212819,57.5,144.5,35.5,4076.5,4672,4451.5,3597,8354.5,6200,6902,7371,-0.0029034112,0.005532359,9541.5,0.0048276563,8643,8595,8043,9195,22,72,31.5,-0.0009756164,0.0023555383,-0.00029819083,0.00044213055,187.5,-0.00465357,12249.5,761,106.5,55.5,1122,0.002261777,39.5,3678.5,3578,-0.0139021175,3686.5,7279,0.002955779,2937.5,4050,4281.5,3820,7304.5,4455,0.0075269216,6555.5,-0.0031899426,-0.0020757883,4118.5,5677.5,7866,7202,8956.5,6055.5,6044.5,8726,7324,9253.5,22,-0.0014615001,23.5,100.5,-0.0003493146,-0.0006417073,-0.0024044835,-0.0005198296,30,0.00050103397,-0.0008136686,-0.0018291333,499,4.749591e-05,-0.006409161,-0.0006569576,-0.002053051,-3.4596498e-05,-0.0013158385,60,3499.5,3747,-0.00041074282,-0.002803202,7682.5,3073,0.0007825104,0.00036072682,2299.5,5120.5,-0.012071809,5451.5,7033.5,5323.5,-0.001995866,10588.5,-0.002227864,-0.000954863,-0.0026034648,-0.0044182944,5025,6180.5,2651.5,6243,20552.5,-0.0007054282,7333.5,7160,6864.5,10176.5,-0.005927754,-0.009829014,-0.0048517752,6854.5,0.001009331,9459.5,8579,0.0037309749,9102,12344.5,6537.5,9176,-0.00027758448,0.0017946057,0.0004664119,-0.00014903181,0.00082855916,0.0014763358,-0.0027591751,-0.0015717605,0.0021049595,0.0011947273,-0.0009640008,0.0007873885,6.429114e-05,-0.0012287383,0.0035109993,0.00035615402,0.0022936792,-0.0019720267,0.0011407447,-0.0035765495,0.00075431535,-0.004955831,0.0036188145,0.0019411931,0.0017420922,0.00012926084,0.0025174364,0.00096630136,0.001782758,0.0067400793,-0.00039259213,-9.909877e-05,-0.000120889505,0.00057505595,0.0009058809,0.003289962,-0.0010296222,4.7580565e-05,-0.0049112975,-0.0022024938,0.001775243,-0.0010520042,-0.00029342136,0.00067704375,0.0010878901,-0.0052862572,0.0025145847,0.012292989,0.00045400145,-0.0042857663,-0.0014181597,0.0012758811,0.0052973945,0.008333265,0.0016228013,-0.0012605161,-0.007199128,0.00089735305,8.532132e-05,-0.0057305577,0.004197153,2.5496001e-06,0.00054351566,-4.8437505e-05}, {4,0,7,3,7,7,7,5,4,3,4,3,6,5,4,3,255,6,0,5,0,3,5,3,3,6,5,0,5,4,4,6,0,4,255,255,255,3,3,255,255,255,3,6,5,7,0,3,4,0,6,6,0,255,255,0,255,5,4,5,4,4,6,4,255,255,255,255,0,255,0,0,3,0,6,255,4,3,3,255,5,0,255,4,4,6,3,0,3,255,4,255,255,6,3,5,7,5,5,5,4,0,4,0,255,5,6,255,255,255,255,3,255,255,255,0,255,255,255,255,255,255,6,3,3,255,255,0,7,255,255,7,0,255,0,0,4,255,0,255,255,255,255,4,0,4,4,0,255,4,4,6,0,255,255,255,3,255,0,5,255,3,7,3,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,65535,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,65535,65535,67,69,65535,65535,65535,71,73,75,77,79,81,83,85,87,89,91,65535,65535,93,65535,95,97,99,101,103,105,107,65535,65535,65535,65535,109,65535,111,113,115,117,119,65535,121,123,125,65535,127,129,65535,131,133,135,137,139,141,65535,143,65535,65535,145,147,149,151,153,155,157,159,161,163,165,65535,167,169,65535,65535,65535,65535,171,65535,65535,65535,173,65535,65535,65535,65535,65535,65535,175,177,179,65535,65535,181,183,65535,65535,185,187,65535,189,191,193,65535,195,65535,65535,65535,65535,197,199,201,203,205,65535,207,209,211,213,65535,65535,65535,215,65535,217,219,65535,221,223,225,227,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,65535,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,65535,65535,68,70,65535,65535,65535,72,74,76,78,80,82,84,86,88,90,92,65535,65535,94,65535,96,98,100,102,104,106,108,65535,65535,65535,65535,110,65535,112,114,116,118,120,65535,122,124,126,65535,128,130,65535,132,134,136,138,140,142,65535,144,65535,65535,146,148,150,152,154,156,158,160,162,164,166,65535,168,170,65535,65535,65535,65535,172,65535,65535,65535,174,65535,65535,65535,65535,65535,65535,176,178,180,65535,65535,182,184,65535,65535,186,188,65535,190,192,194,65535,196,65535,65535,65535,65535,198,200,202,204,206,65535,208,210,212,214,65535,65535,65535,216,65535,218,220,65535,222,224,226,228,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({355.5,343,377,35,18.5,436,22.5,106.5,317,12.5,351.5,10.5,15.5,14,1791.5,31.5,283.5,63.5,11.5,88,88,0.0022501647,-0.002328866,-0.0044207103,-0.0065984637,0.0021375902,-0.005218375,500.5,-0.0017266925,1469.5,2152.5,17.5,9.5,12.5,3.5,11.5,12.5,-0.0030347107,333.5,-0.0050291135,239.5,0.011346004,351.5,6.5,0.008203891,1331.5,1697,1.5,2437,12.5,22,6.5,27.5,0.0038188582,0.007466126,0.0026603935,6.5,103.5,28.5,58,18.5,16.5,0.0003694392,0.0073092594,539,0.0013423213,0.0062470743,0.0046697343,-0.002715628,1266.5,1337.5,2.5,2264.5,1442,3895.5,1908,2450.5,27,23.5,93,20.5,5.5,7.5,11.5,-0.0069225663,-0.002071802,32.5,35,37,38,67,4.5,4.5,3294.5,139.5,-0.0013972323,-0.0036550448,-0.00040956467,7,21.5,3.5,0.0061390246,5.5,-0.013417295,1683.5,9988,1834,0.012555629,0.0014186254,20.5,17,2250.5,2.5,13.5,26746,-0.00054850354,0.00078981835,-0.00032929823,-0.0021921955,0.00041055479,-0.0032810594,0.0033239615,0.0003519672,0.0007772894,-0.0031563148,0.008424631,0.0006912208,-0.005629327,-0.0018383792,0.0005786299,-0.0019542684,0.0016203594,0.0045266063,0.0014918493,-0.004949615,0.003450371,-0.00054487557,0.00075327134,0.0032079946,0.0006349189,-0.0023203718,-0.0010747595,0.0009111726,0.0017885264,-0.0024002565,0.0011522034,-0.0017647542,0.0015773935,0.004405808,-5.1226594e-05,0.0023348536,-0.008618735,-0.0010154218,-0.003148259,0.0019331839,-0.00078190875,-0.009574023,-0.0003849501,-0.002905813,0.0003287033,-0.006276773,0.00085672335,-0.004790687,-0.00042963048,0.010379746,0.0004801553,-0.005322524,0.00397229,-0.00049851293,0.0010245983,0.010662626,-6.848165e-05,6.320773e-05}, {2,2,2,2,8,4,7,4,2,8,2,8,8,8,6,2,5,4,8,4,4,255,255,255,255,255,255,2,255,2,6,8,8,8,8,8,8,255,2,255,6,255,2,8,255,2,2,8,6,8,2,8,5,255,255,255,8,6,5,5,8,8,255,255,6,255,255,255,255,2,2,8,7,5,2,5,6,4,5,6,8,8,8,8,255,255,2,7,4,2,2,8,8,6,4,255,255,255,8,8,8,255,8,255,2,5,2,255,255,8,8,6,8,8,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,65535,65535,65535,65535,65535,43,65535,45,47,49,51,53,55,57,59,65535,61,65535,63,65535,65,67,65535,69,71,73,75,77,79,81,83,65535,65535,65535,85,87,89,91,93,95,65535,65535,97,65535,65535,65535,65535,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,65535,129,131,133,135,137,139,141,143,145,65535,65535,65535,147,149,151,65535,153,65535,155,157,159,65535,65535,161,163,165,167,169,171,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,65535,65535,65535,65535,65535,44,65535,46,48,50,52,54,56,58,60,65535,62,65535,64,65535,66,68,65535,70,72,74,76,78,80,82,84,65535,65535,65535,86,88,90,92,94,96,65535,65535,98,65535,65535,65535,65535,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,65535,130,132,134,136,138,140,142,144,146,65535,65535,65535,148,150,152,65535,154,65535,156,158,160,65535,65535,162,164,166,168,170,172,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({58.5,31.5,63.5,201.5,54.5,22,62,34,1522,55.5,2649.5,71,33,139,26.5,23.5,66,60,529.5,41,118,363,295,-0.0025827363,636.5,95.5,49,0.0012017511,0.0038017947,352,8036,72,30,26,-0.0015486459,250.5,22,-0.00018509703,0.0007886975,49,57,-0.0071258456,-0.002861637,37,0.004349923,-0.0018300823,-0.00041407376,70.5,6786.5,0.005632085,363.5,41.5,37,142,480,8012,1475.5,23.5,25.5,41,24,22,0.002502881,-0.0007941965,1092,-0.0016927948,-0.0011039625,28.5,0.002355199,-0.0029455142,-0.002005233,-0.0028186694,79,0.00021329541,0.0018617479,-0.00033811538,0.00063345395,0.0015416263,0.0024698072,-0.0024991012,25111,165.5,664,-0.00068718137,271.5,-0.004007473,4266,3772,7919.5,7208.5,8084,22,22,0.0018643605,146.5,22,-0.0011381053,-0.0014493093,-0.0006004958,0.001489418,0.0010415204,-9.787727e-06,0.0004171175,38,91.5,47.5,948.5,817.5,0.0010534757,60,0.00013970183,0.0042331954,0.002487939,0.00034489762,0.00024964171,-0.001571495,-0.0010621672,5094.5,7729,5822.5,3960,1168,1487,7808.5,8096,-0.0001827,0.00058783544,0.004719749,-0.00044047218,0.00014686077,0.0010920335,0.00010978318,-0.0002069495,-1.6147646e-05,-0.00034229676,-0.0013690591,-0.004186623,5.5259356e-05,0.0010396149,-0.0005840937,-0.000380369,0.00030799684,-0.0006755704,0.0019512048,0.0012050275,7.8612495e-05,-0.00040888312,0.0004065999,-0.00023073958,-0.00013964248,0.00025494222,0.0035625428,0.0070911134,-0.0012487216,-0.0049636876,-0.0013516266,-0.0002528098,-0.004522697,-0.00024234153,0.0037907404,-9.227412e-06}, {2,2,4,6,7,4,2,1,4,6,7,2,4,4,6,1,6,4,1,7,6,6,1,255,1,2,4,255,255,1,6,6,1,4,255,6,2,255,255,2,1,255,255,2,255,255,255,1,1,255,1,1,1,1,2,6,3,3,4,6,2,2,255,255,1,255,255,4,255,255,255,255,1,255,255,255,255,255,255,255,2,2,1,255,1,255,1,3,2,2,6,6,4,255,6,6,255,255,255,255,255,255,255,2,1,4,1,1,255,6,255,255,255,255,255,255,255,6,4,2,1,2,1,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,65535,65535,53,55,57,59,61,65535,63,65,65535,65535,67,69,65535,65535,71,65535,65535,65535,73,75,65535,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,65535,65535,103,65535,65535,65535,65535,105,65535,65535,65535,65535,65535,65535,65535,107,109,111,65535,113,65535,115,117,119,121,123,125,127,65535,129,131,65535,65535,65535,65535,65535,65535,65535,133,135,137,139,141,65535,143,65535,65535,65535,65535,65535,65535,65535,145,147,149,151,153,155,157,159,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,65535,65535,54,56,58,60,62,65535,64,66,65535,65535,68,70,65535,65535,72,65535,65535,65535,74,76,65535,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,65535,65535,104,65535,65535,65535,65535,106,65535,65535,65535,65535,65535,65535,65535,108,110,112,65535,114,65535,116,118,120,122,124,126,128,65535,130,132,65535,65535,65535,65535,65535,65535,65535,134,136,138,140,142,65535,144,65535,65535,65535,65535,65535,65535,65535,146,148,150,152,154,156,158,160,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({26.5,25.5,235,22.5,5.5,20.5,260,18.5,47.5,88,8.5,27,312,158.5,15707,15.5,20.5,20.5,12.5,2.5,2.5,58.5,128.5,16.5,219.5,57,469.5,5,6.5,18641.5,17214.5,23.5,60.5,49.5,0.00091761566,2.5,0.0030887264,958.5,799,-0.0054962556,-0.009626125,0.0010066484,-0.0022674424,0.0044902125,-0.0022408809,1122,388,12.5,26,150.5,327.5,42,63.5,30,517.5,-0.0019651575,18.5,-0.0017920167,293,27308.5,29245,30052,17394,6.5,8.5,28,0.0059587695,20.5,-0.0032871754,0.0024588266,40.5,34.5,7.5,24,16.5,19.5,2739,14.5,-0.0037725766,2.5,22,0.005847132,0.003123656,4.5,36.5,10.5,10,22,0.006186429,96,318.5,0.02404198,0.00370625,0.0005385469,-0.005113914,132.5,-0.0006275856,15.5,-0.007469459,26634.5,13237,24921.5,21596.5,13798,16711.5,18861.5,26927.5,2.5,146.5,5.5,33,22,-0.0010845738,-0.0020116398,-0.00023147486,22,15.5,7.5,6.5,2156,0.0022799852,15.5,17.5,0.0011275219,2156,15.5,21.5,0.00041885325,-0.001263206,0.002406424,0.0005035712,32.5,6.5,-0.0009336271,-0.0056260726,51.5,640.5,7.5,2.5,0.005377842,0.0026085686,0.0017890403,-4.418504e-05,0.0033008251,-0.0023270645,31.5,-0.0055368054,118.5,279,0.002022948,0.00080387184,-0.004411324,-0.0028038057,29350.5,5891.5,24082,13842,0.011210778,16.5,19015.5,14.5,16120.5,17164,22091,18217.5,16967,15.5,32335,28548,0.0006276287,-0.00038305376,0.00040395255,0.0018245187,0.0015054941,-0.0028839498,0.0066002547,0.0006371096,0.00030118384,0.0038417582,0.0027869109,-0.0014294909,-0.0060178894,0.00013253266,0.005615554,-0.0008054948,-0.00012573715,-0.0016901735,0.00142181,0.0007056599,0.0017416955,0.00034247228,-0.001416399,0.005759859,-0.00784057,0.0007757841,-0.00400117,-0.00077224284,-0.0073132957,-0.0016492741,-0.0026370378,-0.004943938,0.0014921741,-0.0013652988,0.0059467754,0.00090403354,0.00021454813,-0.001096085,-0.0012947046,0.0043638796,-0.007686785,-0.0016151473,-0.0031253838,-0.00055322534,-0.0010380119,0.0033393353,-0.003915456,0.00050272915,-4.8985643e-05,0.002114787,0.009037454,0.0011108643,0.0022242663,-3.3112974e-05,-0.004939074,-0.0018026814,0.0055908323,0.0023858435,0.0013587283,-0.000969391,0.0033113533,0.0003575134,-0.0019155428,0.00084870553,-0.0007470249,0.0038202663,0.002212534,-0.002447438,0.0002724926,-0.0005055303,-0.0017736981,-0.007614825,-0.0013727072,-0.0031242918,-0.0019578391,0.000277069,0.0016952811,5.858912e-05}, {1,1,6,3,8,8,6,8,4,6,8,2,1,1,1,8,1,8,8,8,8,6,2,8,6,2,2,8,8,3,3,1,6,6,255,8,255,2,3,255,255,255,255,255,255,6,2,8,4,6,1,6,6,6,4,255,8,255,2,2,2,6,3,8,8,6,255,8,255,255,3,2,8,1,8,8,6,8,255,8,4,255,255,8,1,8,8,2,255,3,4,255,255,255,255,1,255,8,255,2,1,2,3,3,3,2,2,8,6,8,6,6,255,255,255,6,8,8,8,2,255,8,8,255,2,8,8,255,255,255,255,4,8,255,255,2,4,8,8,255,255,255,255,255,255,3,255,4,3,255,255,255,255,6,1,4,1,255,8,3,8,1,4,2,1,2,8,3,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,69,65535,71,73,65535,65535,65535,65535,65535,65535,75,77,79,81,83,85,87,89,91,93,65535,95,65535,97,99,101,103,105,107,109,111,65535,113,65535,65535,115,117,119,121,123,125,127,129,65535,131,133,65535,65535,135,137,139,141,143,65535,145,147,65535,65535,65535,65535,149,65535,151,65535,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,65535,65535,179,181,183,185,187,65535,189,191,65535,193,195,197,65535,65535,65535,65535,199,201,65535,65535,203,205,207,209,65535,65535,65535,65535,65535,65535,211,65535,213,215,65535,65535,65535,65535,217,219,221,223,65535,225,227,229,231,233,235,237,239,241,243,245,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,70,65535,72,74,65535,65535,65535,65535,65535,65535,76,78,80,82,84,86,88,90,92,94,65535,96,65535,98,100,102,104,106,108,110,112,65535,114,65535,65535,116,118,120,122,124,126,128,130,65535,132,134,65535,65535,136,138,140,142,144,65535,146,148,65535,65535,65535,65535,150,65535,152,65535,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,65535,65535,180,182,184,186,188,65535,190,192,65535,194,196,198,65535,65535,65535,65535,200,202,65535,65535,204,206,208,210,65535,65535,65535,65535,65535,65535,212,65535,214,216,65535,65535,65535,65535,218,220,222,224,65535,226,228,230,232,234,236,238,240,242,244,246,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19.5,26043.5,2622,25912,26147,26.5,2304.5,2.5,25954.5,-0.008102708,25719,81,32.5,-0.008243392,3590,11553.5,30334.5,0.0037846498,0.0059258905,26683,27113.5,28,0.008545711,-0.008384113,1720.5,3239.5,5836.5,12867.5,18007.5,26750,31233,0.0045023,31163.5,1.5,30258,27,0.0013529912,1215,2471.5,3187.5,3203,5450,10017.5,6853,22528.5,11226,18094,18240,17602.5,16385,30578,23183.5,24079,0.0068351314,26285.5,4.5,15.5,20.5,0.0012317154,1123.5,1609,1571.5,1361.5,0.0017578459,0.011814662,4087,3589,6583.5,5113.5,6007,23145.5,1.5,7148,10037,24331,13864.5,1.5,1.5,1.5,18245.5,23723.5,16163.5,29244.5,11.5,30465,22234,12687,20239.5,2.5,1.5,25465,32335,30572.5,31449.5,29788,29705.5,29497.5,-0.0027686304,21.5,980,951,944,1215.5,1945.5,2296,3482.5,3004,3185.5,0.011582918,2727,3406,5005,8018.5,0.0102766445,7151,5942.5,9928,6094.5,19594,6.205474e-05,-0.0014503876,0.0045939954,0.0004728819,-0.012223547,-0.0024772878,0.005748751,0.0014556835,0.0012452938,-0.0033713505,0.012143701,0.0009126055,-0.0026753794,0.00084746786,0.0013173795,0.00019397479,9.846224e-05,0.003196322,-0.0030361132,0.002172542,-0.0008521338,0.0021430294,0.0073557184,0.0028768464,-0.0013558654,-0.005254378,0.0027165164,-0.00090510136,-0.0009692224,0.0007412806,0.00045762755,-7.60586e-05,0.0046688044,0.0010508442,0.0027544177,-0.0029566262,-0.0024978432,0.0008243573,0.00022638282,0.0018596419,-0.0038443625,9.255442e-05,-0.009580782,-0.002642887,0.005167556,-9.1799935e-05,-0.000521517,0.001289054,-0.0004714869,-0.00013608097,-0.00033827135,0.0002885788,0.001419911,-0.0012028711,-0.0008282504,0.018125338,-0.0012769046,-0.013747811,0.0029155286,-0.015560031,0.014722034,0.0018886182,-0.0025089132,0.003582981,-0.012919811,-0.003736122,-0.008244985,-0.0024146398,0.0056150123,-0.0009286729,0.0030840628,-0.0025869312,-0.0034650706,-0.0054011773,-0.00043593082,-0.0023230824,-0.0060334876,-0.0014746006,0.005350324,-0.0007684107,1.8758263e-05,-0.0078844065,0.0011146552,0.008965036,0.0002763556,0.0014148406,-0.0046323896,-0.00042240773,0.00489151,0.00022787332}, {8,5,5,5,5,4,4,8,5,255,2,2,4,255,4,5,2,255,255,5,2,6,255,255,4,3,2,2,2,4,4,255,5,8,5,2,255,4,6,5,6,5,4,3,2,6,3,5,3,3,6,3,4,255,4,8,8,8,255,2,2,3,3,255,255,2,6,4,4,2,3,8,3,6,6,4,8,8,8,3,4,5,4,8,2,3,5,2,8,8,2,3,5,2,4,2,4,255,8,3,5,3,6,4,5,2,2,4,255,4,5,6,4,255,3,2,5,6,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,21,23,65535,25,27,29,65535,65535,31,33,35,65535,65535,37,39,41,43,45,47,49,65535,51,53,55,57,65535,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,65535,91,93,95,97,65535,99,101,103,105,65535,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,65535,171,173,175,177,179,181,183,185,187,189,65535,191,193,195,197,65535,199,201,203,205,207,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,22,24,65535,26,28,30,65535,65535,32,34,36,65535,65535,38,40,42,44,46,48,50,65535,52,54,56,58,65535,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,65535,92,94,96,98,65535,100,102,104,106,65535,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,65535,172,174,176,178,180,182,184,186,188,190,65535,192,194,196,198,65535,200,202,204,206,208,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({180.5,74,217.5,99,5473,400.5,5719,179,93.5,88.5,6166,0.0043912274,207,5556,5995.5,25.5,0.0041427677,333,0.0075123096,548,95.5,26.5,77,0.0020699347,0.0027828508,5543.5,4724.5,6374,6801.5,173.5,131.5,26.5,-0.0023661444,513,-0.0030372175,0.0033812814,101,-0.0033008063,86.5,29.5,-0.0012569523,5406.5,5393.5,0.0062231817,6736.5,6009,9210,6778,6845,32.5,0.0050839745,64.5,83,0.0010147032,0.0029969313,119.5,0.0014653265,-0.0035178233,1044.5,-0.009082923,-0.0033680499,-0.0005851445,-0.00013215422,5309,5416.5,-0.0044007814,-0.0006025052,4773.5,5897.5,6064,6219.5,5805.5,10559.5,9190,6783.5,6731,6857.5,51,30,105,99.5,40.5,-0.0006509563,226.5,123,749.5,2421.5,5488.5,5422,-0.0051340456,5559,5655,9840.5,0.011253799,5653,5706.5,5887.5,5778.5,5850.5,6955.5,5858.5,13267,14079.5,5550.5,6528,-0.018545283,-0.0058371085,0.015598968,6175.5,7077.5,6455,0.00018985286,-0.0013652064,0.00071938557,0.0028730757,-0.0004245592,0.0017987144,0.0044871178,0.00058630574,-0.0071570366,-0.0022014983,-0.0021620654,-0.001096032,-0.0005822065,-0.0010448305,-0.00035075578,-0.00299009,0.001691002,-0.00072295446,0.00010841856,-0.010246426,0.0007952165,0.0064238706,-0.0008186437,0.0004975455,-0.0010347039,-0.0039355042,0.0012685859,-0.0024206766,0.00047977673,0.0026138525,-0.0013618335,0.0031784107,-0.009378413,-0.0028990912,-0.0007940189,0.0028760133,0.01317236,0.005073069,-0.0096213715,-0.01553025,-0.00040472305,-0.005532289,-0.0005384937,0.00093754067,0.0061429394,-0.00068682316,0.0013454653,-0.0017842873,-0.00049754156,0.0024961072,0.010218405,-0.0035039994,-0.015970908,-0.0020553223,0.00047266862,-2.3928207e-05}, {1,3,0,5,7,3,1,4,0,3,7,255,0,1,1,5,255,7,255,0,3,0,0,255,255,1,0,3,0,0,0,0,255,4,255,255,3,255,0,0,255,5,4,255,7,5,3,0,0,7,255,1,4,255,255,1,255,255,4,255,255,255,255,5,5,255,255,7,4,7,7,1,5,3,0,1,0,1,3,0,0,1,255,4,7,4,4,1,1,255,0,1,0,255,1,5,4,1,1,7,1,3,0,3,4,255,255,255,4,1,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,65535,31,65535,33,35,37,39,65535,65535,41,43,45,47,49,51,53,65535,55,65535,65535,57,65535,59,61,65535,63,65,65535,67,69,71,73,75,77,65535,79,81,65535,65535,83,65535,65535,85,65535,65535,65535,65535,87,89,65535,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,65535,121,123,125,127,129,131,65535,133,135,137,65535,139,141,143,145,147,149,151,153,155,157,159,65535,65535,65535,161,163,165,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,65535,32,65535,34,36,38,40,65535,65535,42,44,46,48,50,52,54,65535,56,65535,65535,58,65535,60,62,65535,64,66,65535,68,70,72,74,76,78,65535,80,82,65535,65535,84,65535,65535,86,65535,65535,65535,65535,88,90,65535,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,65535,122,124,126,128,130,132,65535,134,136,138,65535,140,142,144,146,148,150,152,154,156,158,160,65535,65535,65535,162,164,166,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6421.5,6412,6465,4997.5,0.0077414885,6448,6499,4989,5077.5,6428,6370,6494,6504,3389.5,-0.004643479,7803.5,5227.5,3198,6407,-0.008336995,-0.0028837868,6249.5,0.007214473,6367.5,6825.5,3353.5,1608.5,6596,5068,5576.5,5655.5,-0.005824316,-0.0041142786,0.00200903,6596,6686.5,7480,-0.0032353364,-0.0085193245,8153.5,6881,1279.5,4224,0.0064959996,4741,4092,0.007490703,-0.0014104414,0.0005821051,5506.5,3517,3654.5,6761,0.00047719837,-0.0018303272,6488.5,6488.5,0.0029905199,0.005699409,7495,6270,7309,6989,1140.5,3608,0.00084553484,0.0018659082,3427.5,6417.5,0.0009811134,5029.5,4868.5,7502.5,2092.5,5818.5,-0.009153291,9701.5,8969,6301.5,-0.002825125,-0.0013253237,0.0021355795,0.00077221345,6655,7480,8527.5,8814,7187.5,6033,7555,6994.5,3.5796944e-05,-0.0018241064,0.0009294675,-0.00023386428,-0.00071232335,-0.0043008905,-7.898866e-05,-0.0015309433,0.00505828,0.0028804578,-0.0017616845,-0.01091184,0.00684116,-0.0017064214,-0.0031536096,4.2971424e-05,0.00047523863,0.0037471899,0.0022758252,-0.00031805655,-0.0008388401,0.0019831771,0.0011543559,0.008890397,-0.00028615922,-0.0028246245,-0.0029901725,0.007971927,-0.004636972,0.0006765808,-0.012496516,-0.0015480368,0.004655349,0.019318195,0.0049883598,-0.0009705943,0.002416572,-0.004570026,0.007958219,-2.9196439e-05}, {0,0,0,1,255,0,0,1,1,0,1,0,0,1,255,2,0,1,2,255,255,7,255,1,4,1,2,2,0,1,1,255,255,255,1,1,6,255,255,7,0,1,0,255,6,2,255,255,255,2,2,4,1,255,255,0,0,255,255,7,4,4,0,1,2,255,255,7,4,255,1,0,6,6,1,255,2,2,0,255,255,255,255,7,1,7,7,4,2,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,65535,9,11,13,15,17,19,21,23,25,65535,27,29,31,33,65535,65535,35,65535,37,39,41,43,45,47,49,51,65535,65535,65535,53,55,57,65535,65535,59,61,63,65,65535,67,69,65535,65535,65535,71,73,75,77,65535,65535,79,81,65535,65535,83,85,87,89,91,93,65535,65535,95,97,65535,99,101,103,105,107,65535,109,111,113,65535,65535,65535,65535,115,117,119,121,123,125,127,129,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,65535,10,12,14,16,18,20,22,24,26,65535,28,30,32,34,65535,65535,36,65535,38,40,42,44,46,48,50,52,65535,65535,65535,54,56,58,65535,65535,60,62,64,66,65535,68,70,65535,65535,65535,72,74,76,78,65535,65535,80,82,65535,65535,84,86,88,90,92,94,65535,65535,96,98,65535,100,102,104,106,108,65535,110,112,114,65535,65535,65535,65535,116,118,120,122,124,126,128,130,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({26714,25393.5,4767.5,27678.5,25949,0.00874102,27089,27091.5,20064,19976,25723,25648.5,16746,27020.5,16200.5,18447.5,18487,27549.5,26279.5,19565.5,25776.5,15605,29802,-0.005754428,22528,27404.5,14559,27688.5,-0.0055957576,18254.5,0.0029173817,26799,13651.5,10778.5,14224,26359.5,-0.0030516635,0.006572532,25154.5,30530.5,27533.5,27417.5,17278,-0.006259882,30355,13881,22752.5,27179.5,10355,0.0123441,28888.5,24050,28202.5,12187.5,24370.5,0.002384918,-0.00056820066,0.0012551788,28991,24011,12651,11143,15544.5,25976,28933,32059,25591.5,25571.5,32335,25945,30722.5,8799.5,-0.0014672208,14570.5,26755.5,-0.0024184973,27258.5,28358.5,17236,-0.0049563753,16171.5,7912,23708,0.0026578603,22887.5,0.00084389345,-5.0345418e-05,-1.985492e-05,24932,0.0010899286,0.00055445,21117,14968,-9.470563e-05,-0.0020991159,23073.5,0.002401328,0.0039187656,24823,14202.5,16192.5,-0.0059237587,-0.003942043,24607,16900.5,25842,0.004109654,0.003442016,0.0048063467,-0.004833993,9.267968e-05,29710,0.0022402427,-0.012002151,-0.007142958,-0.0019747342,28515.5,-0.006954378,26500.5,26379.5,31589,0.005866784,23302,0.0049157552,0.00065669365,0.011699538,0.007122919,1.365194e-05,-0.00042214166,26648.5,20920.5,0.0025066673,0.007174842,18301,16267.5,2.5395193e-05,-0.0001201303,0.0025006686,0.0049496633,-0.001970306,0.001128815,-0.002406363,-0.0012246524,0.00065018947,0.0019781948,0.0004321213,-0.00059442595,0.0073864395,0.004417756,0.0028392242,4.7058415e-06,-0.002073598,-0.003770553,-0.0008135668,0.0015937841,0.0034668536,-0.0003182829,-0.0020222338,-0.0050952374,0.0014424962,-0.00017325825,-0.0012798904,-1.322729e-05,1.2083971e-05,-0.00059056026,0.0037768818,0.00024012929,-0.007860419,-0.0048469966,0.001895943,-0.004078291,0.0022364776,0.001162493,0.001083027,-0.0013194757,0.0009723357,0.0045343353,-0.00080191577,0.0044560595,0.00923441,5.51614e-05}, {4,4,3,6,7,255,4,6,7,7,2,1,2,6,7,3,4,6,3,1,6,7,7,255,2,2,3,2,255,7,255,2,3,3,7,2,255,255,2,1,3,6,1,255,3,3,2,2,1,255,1,2,2,1,4,255,255,255,2,6,3,1,1,1,2,1,6,6,3,3,3,7,255,1,2,255,2,6,7,255,3,7,4,255,3,255,255,255,2,255,255,2,3,255,255,7,255,255,2,7,7,255,255,2,1,1,255,255,255,255,255,1,255,255,255,255,2,255,1,2,7,255,2,255,255,255,255,255,255,6,2,255,255,1,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,65535,45,47,49,51,65535,53,65535,55,57,59,61,63,65535,65535,65,67,69,71,73,65535,75,77,79,81,83,65535,85,87,89,91,93,65535,65535,65535,95,97,99,101,103,105,107,109,111,113,115,117,119,121,65535,123,125,65535,127,129,131,65535,133,135,137,65535,139,65535,65535,65535,141,65535,65535,143,145,65535,65535,147,65535,65535,149,151,153,65535,65535,155,157,159,65535,65535,65535,65535,65535,161,65535,65535,65535,65535,163,65535,165,167,169,65535,171,65535,65535,65535,65535,65535,65535,173,175,65535,65535,177,179,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,65535,46,48,50,52,65535,54,65535,56,58,60,62,64,65535,65535,66,68,70,72,74,65535,76,78,80,82,84,65535,86,88,90,92,94,65535,65535,65535,96,98,100,102,104,106,108,110,112,114,116,118,120,122,65535,124,126,65535,128,130,132,65535,134,136,138,65535,140,65535,65535,65535,142,65535,65535,144,146,65535,65535,148,65535,65535,150,152,154,65535,65535,156,158,160,65535,65535,65535,65535,65535,162,65535,65535,65535,65535,164,65535,166,168,170,65535,172,65535,65535,65535,65535,65535,65535,174,176,65535,65535,178,180,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2156.5,20.5,2437,15.5,184,2193.5,2701.5,10.5,17.5,322,2008,2379,2220,4.5,3924.5,2016.5,3829.5,353,1322,62,165.5,298.5,2326.5,16.5,14.5,15.5,19.5,2.5,12.5,3817.5,6109,2002,1334,938.5,826.5,304.5,1657.5,984,1442.5,33.5,704.5,-0.0016627632,-0.008811062,441.5,1256.5,611.5,2706.5,98,2306.5,0.0009656818,-0.022301069,3181.5,-0.010240639,1766.5,2098.5,3208.5,3948,2728,4305,3711,3849,6096,6135.5,63.5,-0.008978323,4.5,1479,148.5,1167.5,4790.5,6244.5,227,670.5,1526,2029.5,736,1547.5,878.5,2254,38,71,58.5,0.00254322,167,115,710,1784,3624.5,5150,0.013186346,2275.5,-5.830856e-05,2127,-0.004970582,0.005346183,0.0027884156,-0.0010370439,5,9413,0.008625326,0.00053173414,2436,0.002280614,2351.5,5157.5,1326.5,2340,2460,28257.5,18.5,9.5,17,6.5,6060.5,0.012831561,7003.5,5824.5,2966,184,0.010731948,6.5,-0.006352601,2187,58.5,14.5,12.5,311,-0.0038549907,8338,0.002932823,11714.5,180,243,0.0021226874,883.5,1443.5,-0.016188866,16.5,2823.5,1073,844,745.5,7343.5,18.5,18.5,2085,3073.5,48,-0.004414082,34.5,0.00059558416,-0.003635785,513,0.0079350835,-0.0020802098,0.008060934,0.04069636,365,854,1027,0.0010129953,0.0096574295,8497,-0.015398656,957,-0.005439158,3708,-0.008948062,-0.004715442,-0.005213314,11.5,6.5,4.5,0.00056486897,-0.0050320695,0.004318371,0.017606793,0.0006840654,-0.0008167978,6.5,7.5,0.0041862074,3861.5,20.5,17.5,16.5,0.0034513592,16.5,3694.5,-0.007074227,-0.004223383,-0.00084514526,0.014366995,7798,3520.5,5987,6067.5,-0.007616212,0.0021616793,6144.5,5844,0.00070592266,0.008468738,-0.0008277286,0.00032258878,0.004594165,0.0011706641,0.0023130558,-0.00028088092,0.0004107134,0.0018106453,-0.00089859293,0.0018523474,-7.420385e-05,0.00732287,-0.0027453352,0.0020752763,0.00016602472,-0.0013504695,-0.0004605414,0.0026395207,-0.00070594053,-0.0035979275,0.0075417394,-0.0022579238,0.008870363,0.003990232,-0.0038432747,0.005710743,0.00036098214,0.005251613,-0.0058812946,5.814294e-06,-0.00019019953,0.0043344027,0.018279513,0.0018365504,0.00019072872,-0.011716841,-0.0018145079,0.001241859,0.0048422143,-0.0019557239,0.001353798,0.0071194167,-0.0029761938,-0.009865644,0.011055281,-0.0013378712,-0.00064453395,0.004828173,0.011849845,0.0019090958,-0.0005299674,0.0018304441,0.0011731712,-0.0068405257,0.016695965,-0.0014274874,0.01935777,0.010439373,-0.008394899,6.9447815e-05,0.0010791904,-0.0012774832,0.009770314,-0.001376297,0.0013339084,-0.004901325,0.0062485533,0.0017561587,-0.0019424408,0.0005562629,-0.0019318437,0.0015441179,0.00017346088,-0.008265201,-0.0018455118,0.0006821577,0.00043441268,0.0048904656,0.0015431247,0.0067207413,-0.00012395489,-0.0023380986,-0.0009968972,0.0033238225,-0.0012927947,-0.0062221196,-0.0011198506,-0.006749888,0.00016324712,0.0013769409,0.0003316346,-0.001978641,0.016020542,-0.00071213226,0.0042762933,-0.0005034384,0.0074347975,9.173763e-06}, {6,8,6,8,1,5,6,8,8,5,1,4,6,8,6,2,1,1,6,4,2,6,2,8,8,8,8,8,8,5,6,2,1,1,6,5,4,5,1,4,6,255,255,1,1,6,2,1,2,255,255,5,255,2,2,4,5,1,5,5,5,6,6,6,255,8,1,1,1,1,1,1,6,4,4,5,1,2,4,2,6,2,255,2,6,2,2,1,1,255,5,255,1,255,255,255,255,8,1,255,255,4,255,2,5,1,2,4,5,8,8,8,8,6,255,4,2,1,1,255,8,255,4,2,8,8,6,255,1,255,1,5,6,255,6,4,255,8,5,1,5,1,5,8,8,4,4,1,255,1,255,255,4,255,255,255,255,1,2,4,255,255,4,255,6,255,5,255,255,255,8,8,8,255,255,255,255,255,255,8,8,255,4,8,8,8,255,8,2,255,255,255,255,2,6,6,6,255,255,6,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,65535,65535,83,85,87,89,91,93,65535,65535,95,65535,97,99,101,103,105,107,109,111,113,115,117,65535,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,65535,153,155,157,159,161,163,65535,165,65535,167,65535,65535,65535,65535,169,171,65535,65535,173,65535,175,177,179,181,183,185,187,189,191,193,195,65535,197,199,201,203,65535,205,65535,207,209,211,213,215,65535,217,65535,219,221,223,65535,225,227,65535,229,231,233,235,237,239,241,243,245,247,249,65535,251,65535,65535,253,65535,65535,65535,65535,255,257,259,65535,65535,261,65535,263,65535,265,65535,65535,65535,267,269,271,65535,65535,65535,65535,65535,65535,273,275,65535,277,279,281,283,65535,285,287,65535,65535,65535,65535,289,291,293,295,65535,65535,297,299,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,65535,65535,84,86,88,90,92,94,65535,65535,96,65535,98,100,102,104,106,108,110,112,114,116,118,65535,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,65535,154,156,158,160,162,164,65535,166,65535,168,65535,65535,65535,65535,170,172,65535,65535,174,65535,176,178,180,182,184,186,188,190,192,194,196,65535,198,200,202,204,65535,206,65535,208,210,212,214,216,65535,218,65535,220,222,224,65535,226,228,65535,230,232,234,236,238,240,242,244,246,248,250,65535,252,65535,65535,254,65535,65535,65535,65535,256,258,260,65535,65535,262,65535,264,65535,266,65535,65535,65535,268,270,272,65535,65535,65535,65535,65535,65535,274,276,65535,278,280,282,284,65535,286,288,65535,65535,65535,65535,290,292,294,296,65535,65535,298,300,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({22,44,47,26.5,1522,27,32.5,22,34,6026.5,-0.00075393415,44.5,36.5,271.5,53.5,3434,33,0.0008040405,0.0002819757,-0.0029404731,-0.0018971956,25.5,608,33.5,60.5,142,22,106.5,8170.5,42.5,0.00018112174,-0.0013547004,-0.0006895654,30,32,31,29777.5,59,49.5,29,94.5,0.0013811992,3.4615656e-05,-0.007457251,724,46.5,243,8014,8264,25.5,61,27,0.0018723448,0.0025513975,0.0015097781,186.5,91.5,79,31299,40,130.5,75,127.5,-9.493503e-05,42.5,0.00271094,4181.5,-0.002286852,4615.5,31.5,37,0.0057527944,4363.5,7920,6728.5,6681.5,8277.5,49.5,0.0009536923,-0.00092401885,-0.0005364995,23.5,23.5,114,274.5,-0.00035560815,-0.003949063,0.002762643,817.5,-0.002904913,0.0010014141,36,34.5,914.5,-0.0011465378,-0.0035419457,-0.0017298091,-0.0019500789,2649.5,0.0007491446,0.000304827,0.0017200176,0.0012490978,-0.00104349,-0.00027749757,-0.0063721747,-0.003629248,52,67,844,0.0010774228,7505.5,7951,6881,8095,5623,6616,0.004462686,8427,-0.00046556053,-0.001202102,0.0027944169,0.000266455,0.00020703777,-0.0010533364,-0.00019378822,0.0017258667,-0.0009915812,0.00034948275,0.0019147954,0.0003024665,-0.00028306604,0.00046793115,0.0020892303,0.0012694867,-0.0010486076,0.00014914953,0.0007952472,-0.0017933458,-0.0013751707,-0.0032299783,-0.0012685347,-0.000551964,-0.0007131283,3.01417e-05,2.098501e-05,0.0009685848,-0.005255367,-0.00043966933,0.00025865293,-0.0075257844,0.0054661403,0.0002541105,-0.004025907,0.005747884,-0.0020044474,-0.010496219,-0.0016081845,-3.192089e-05}, {2,1,4,1,4,7,6,1,1,1,255,1,5,1,2,4,6,255,255,255,255,7,1,4,1,1,6,4,7,4,255,255,255,1,1,4,1,6,7,1,1,255,255,255,4,5,4,7,7,4,4,2,255,255,255,1,1,2,1,6,2,1,6,255,1,255,1,255,1,1,2,255,4,7,1,1,7,6,255,255,255,1,1,1,1,255,255,255,1,255,255,2,1,1,255,255,255,255,7,255,255,255,255,255,255,255,255,4,4,1,255,7,7,4,5,1,2,255,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,65535,65535,65535,65535,33,35,37,39,41,43,45,47,49,65535,65535,65535,51,53,55,57,59,61,63,65,65535,65535,65535,67,69,71,73,75,77,79,81,65535,65535,65535,83,85,87,89,91,93,95,97,65535,99,65535,101,65535,103,105,107,65535,109,111,113,115,117,119,65535,65535,65535,121,123,125,127,65535,65535,65535,129,65535,65535,131,133,135,65535,65535,65535,65535,137,65535,65535,65535,65535,65535,65535,65535,65535,139,141,143,65535,145,147,149,151,153,155,65535,157,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,65535,65535,65535,65535,34,36,38,40,42,44,46,48,50,65535,65535,65535,52,54,56,58,60,62,64,66,65535,65535,65535,68,70,72,74,76,78,80,82,65535,65535,65535,84,86,88,90,92,94,96,98,65535,100,65535,102,65535,104,106,108,65535,110,112,114,116,118,120,65535,65535,65535,122,124,126,128,65535,65535,65535,130,65535,65535,132,134,136,65535,65535,65535,65535,138,65535,65535,65535,65535,65535,65535,65535,65535,140,142,144,65535,146,148,150,152,154,156,65535,158,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({28.5,306,7664,122,168,7644.5,2092.5,89,68,461.5,647,7628.5,8324,8163.5,7681.5,30,0.0010175804,80.5,0.00014958125,-0.0035385066,-0.00478734,-0.0027092851,87.5,8155,6668.5,4162.5,0.001619311,1857.5,7788,8547.5,7209.5,22,22,-0.0015352531,214,0.0003499453,-0.00031911765,7477,3230.5,-0.0063343244,-0.0010835095,0.00027583475,7208.5,1829,7771.5,7465,9240.5,-0.0047914623,4761,6766,7249,22,22,33.5,33.5,-0.0005701768,-0.0009975627,7305.5,7534,2399.5,8795.5,0.0069023236,0.0046076137,7252,7245,8015.5,8743.5,-0.0012897978,-0.0029206495,-0.0071525774,9471.5,-0.0018179754,-0.00057166343,6731.5,6979.5,8530,7693.5,3409,0.001407921,27,26.5,-0.0017924143,-0.0003646475,0.00014479774,49,7062,7103,7528,6951,111,19251.5,6967,7328,-0.000105292886,7227.5,0.0030106239,7285.5,0.0012835984,0.00065386033,8263.5,-0.0035061121,-0.0036286921,-0.0017546021,8267.5,0.0059090434,6051.5,7266,7850.5,2810.5,-0.00288514,7708.5,-0.00044170138,0.00014170096,0.0024096773,0.0008635833,-0.0004226429,-0.0007629537,-0.00054060266,-0.0003979866,8.909121e-05,-0.0012913593,0.0004643006,0.005191132,-0.008930142,0.00045663165,0.00037757802,-0.014822147,3.441622e-05,0.00083797594,-0.006783282,-0.00037693596,0.0009294967,0.0042022876,0.0009086663,-0.0002253281,0.0011999446,0.00063635135,0.00086239877,0.0015910447,-0.0005332937,-0.0014814928,-0.0013285357,0.00020095745,-0.0010461974,-0.006543254,-0.0038068853,0.00013587683,-0.00059860543,0.0020942946,0.0020945272,0.0036553144,0.0058451784,1.0357712e-05}, {6,0,4,0,2,4,5,0,4,0,0,4,1,4,4,0,255,2,255,255,255,255,4,5,0,1,255,1,0,5,0,0,2,255,0,255,255,5,0,255,255,255,1,5,4,0,6,255,0,0,0,2,2,0,0,255,255,4,2,0,5,255,255,6,6,2,2,255,255,255,0,255,255,0,0,4,4,4,255,0,0,255,255,255,0,5,5,5,6,0,1,4,0,255,0,255,2,255,255,0,255,255,255,4,255,2,2,6,1,255,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,65535,33,65535,65535,65535,65535,35,37,39,41,65535,43,45,47,49,51,53,65535,55,65535,65535,57,59,65535,65535,65535,61,63,65,67,69,65535,71,73,75,77,79,81,83,65535,65535,85,87,89,91,65535,65535,93,95,97,99,65535,65535,65535,101,65535,65535,103,105,107,109,111,65535,113,115,65535,65535,65535,117,119,121,123,125,127,129,131,133,65535,135,65535,137,65535,65535,139,65535,65535,65535,141,65535,143,145,147,149,65535,151,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,65535,34,65535,65535,65535,65535,36,38,40,42,65535,44,46,48,50,52,54,65535,56,65535,65535,58,60,65535,65535,65535,62,64,66,68,70,65535,72,74,76,78,80,82,84,65535,65535,86,88,90,92,65535,65535,94,96,98,100,65535,65535,65535,102,65535,65535,104,106,108,110,112,65535,114,116,65535,65535,65535,118,120,122,124,126,128,130,132,134,65535,136,65535,138,65535,65535,140,65535,65535,65535,142,65535,144,146,148,150,65535,152,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({26.5,517.5,368.5,78,625.5,326,377,24,32,-0.0051174583,1218,34,0.0050334088,-0.0042173467,236.5,24,63.5,-0.0019840628,112.5,817.5,24233,933.5,23,242.5,383,24,-0.0013673091,143.5,0.0023648099,48,114,-0.0012979312,-0.0019892938,5883.5,32053,36,-0.0038877267,34,646,225.5,-0.0053387512,0.0066000344,43,28,0.0028284013,71.5,184,0.0012241908,1.0776553e-06,0.0027950553,0.0010679242,-0.00032927058,0.0023033442,25432,0.0012763068,25.5,30.5,-0.0035867242,2847,290,314,393.5,0.0025889704,478,19753,22,47.5,70.5,111,-0.0053666183,-0.002224667,-0.00079381,-0.0029118985,0.0007871236,-7.1818045e-05,172.5,883.5,65,0.00164769,175,108.5,134.5,-0.0030664,-0.0027090157,175,0.003784708,438,20764.5,19916,-0.000282991,-0.00054989685,0.00041033752,-4.0807787e-05,-0.00070702145,-0.0026912212,0.0017406353,0.0005278897,-0.0014965486,-0.0027056688,-0.00051581283,0.00073767605,-1.6997301e-06,-0.0014262572,0.0004371631,-0.0029553894,0.008271909,0.00084339234,-0.0010034654,0.00026004904,-0.0012310462,-0.00013924255,-0.0011173536,0.0014041887,-6.2660365e-05,0.0024273,0.0011571968,-3.9563394e-05}, {5,0,2,2,0,3,2,1,3,255,0,6,255,255,3,5,2,255,0,1,0,0,3,1,2,3,255,0,255,3,1,255,255,0,1,2,255,5,6,1,255,255,6,6,255,1,0,255,255,255,255,255,255,0,255,2,5,255,0,6,2,2,255,3,5,6,0,0,1,255,255,255,255,255,255,0,0,5,255,5,2,5,255,255,5,255,0,3,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,21,65535,65535,23,25,27,65535,29,31,33,35,37,39,41,43,65535,45,65535,47,49,65535,65535,51,53,55,65535,57,59,61,65535,65535,63,65,65535,67,69,65535,65535,65535,65535,65535,65535,71,65535,73,75,65535,77,79,81,83,65535,85,87,89,91,93,95,65535,65535,65535,65535,65535,65535,97,99,101,65535,103,105,107,65535,65535,109,65535,111,113,115,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,22,65535,65535,24,26,28,65535,30,32,34,36,38,40,42,44,65535,46,65535,48,50,65535,65535,52,54,56,65535,58,60,62,65535,65535,64,66,65535,68,70,65535,65535,65535,65535,65535,65535,72,65535,74,76,65535,78,80,82,84,65535,86,88,90,92,94,96,65535,65535,65535,65535,65535,65535,98,100,102,65535,104,106,108,65535,65535,110,65535,112,114,116,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4534,17.5,4554,1.5,121,-0.008285156,17.5,3642,3647,57,30,15.5,5836.5,1693.5,5792.5,15.5,2725,20.5,33,289.5,38,10549,6744.5,5882,6019,1490,1868,4703.5,-0.00039396537,3617,204,2565.5,16.5,23.5,43,-0.009862747,35,0.000518698,20.5,-0.013044399,298.5,12872,11765.5,3539.5,7711.5,1918.5,5999,5156.5,2962,1661.5,0.009245682,1889.5,3188.5,0.010741495,0.0048531382,3080.5,0.005647953,327,2471.5,5514.5,3054.5,739.5,7299.5,22,41.5,72,0.0047850385,2919,564,728,0.015746213,290.5,192,10463,4.5,11397.5,15093.5,2034,5584,7937,18562.5,0.005824722,1414,0.011116332,5531,0.009881549,5731,1618.5,10019.5,439.5,8460.5,-0.0023241215,-0.008531383,2137.5,3014.5,1641.5,7.5,27.5,52.5,2352,2923.5,14.5,3.5,0.004838456,0.001644946,316,9950,6825.5,-9.086732e-05,19.5,27,45,70.5,28,-0.0034550794,3688.5,0.0025460038,58,18.5,-0.0011165611,0.011674569,273.5,0.016816663,542,1311,3.5,9067.5,8690,11732,11250.5,5849,7.5,15195,7340.5,5840.5,7709.5,10894,6266.5,7891,13528.5,24050,20,4205,4616,5907.5,0.0047753616,5870,20.5,-0.007953345,10001.5,23029,0.0012542891,-0.0014030235,0.004667602,0.00216117,-0.0013969665,0.002260555,0.001078334,-0.003877477,0.00027588752,-0.0007988604,0.0018506866,2.6809488e-05,-0.0009360847,0.0010607197,0.0054111066,0.0016866549,-0.0020900057,-0.011353724,0.007855526,-0.0011156712,0.0004631973,0.004295172,0.0023082516,-0.0009707583,0.00035284233,0.0020492391,-0.0010700307,0.0009837658,0.00093042245,0.0034768537,-0.0019454269,-0.00027993295,0.0032427558,-0.0014035567,0.0064041573,0.002611385,-0.0049629617,0.0022296512,0.0010788679,-0.0021066251,-0.005025659,-0.01223901,0.0015178688,-0.0013592214,0.0038160514,0.0013902597,0.0013469689,0.0064274888,0.0057386467,0.013448554,-0.0012088532,0.001361293,-0.0005550671,-5.1894032e-05,0.00059372507,-0.00463169,0.0015633997,0.005832831,0.0013689339,-0.0021901282,0.0010085677,-0.0023559183,0.00011143567,0.005172723,-0.0014448267,0.00020287612,0.0053098197,0.000109970504,0.006335052,0.0012889769,-0.0027111834,-0.0002545203,0.0004998639,-0.0015205563,0.0020419916,0.00012976312,0.0025763798,-0.0037140723,0.0052903565,-8.809956e-05,-0.00020401704,-0.001139072,-0.0022040072,0.00019931998,0.00780794,-0.0025761293,-0.00093023555,-0.0030078387,0.0022765067,7.802412e-05,-0.0050812135,-0.0011509693,0.0031313312,-0.0030899162,-0.00014767224,-0.0041059493,4.8903727e-05,0.0013659943,-0.0005603324,9.083552e-05}, {0,8,0,8,0,255,8,0,5,2,6,8,2,0,2,8,6,8,4,0,6,2,5,0,2,0,0,6,255,5,0,6,8,5,2,255,0,255,8,255,6,6,2,5,4,6,0,4,4,2,255,2,0,255,255,2,255,5,6,4,0,2,6,6,0,6,255,2,2,0,255,6,0,6,8,2,2,4,0,5,5,255,5,255,2,255,0,5,4,5,2,255,255,0,6,2,8,5,0,4,6,8,8,255,255,2,4,5,255,8,2,6,6,2,255,4,255,6,8,255,255,5,255,2,6,8,0,4,0,4,5,8,2,0,2,6,2,6,0,5,4,8,2,5,4,255,2,8,255,5,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,55,57,59,61,63,65,65535,67,65535,69,65535,71,73,75,77,79,81,83,85,87,89,65535,91,93,65535,65535,95,65535,97,99,101,103,105,107,109,111,113,65535,115,117,119,65535,121,123,125,127,129,131,133,135,137,139,65535,141,65535,143,65535,145,147,149,151,153,65535,65535,155,157,159,161,163,165,167,169,171,173,65535,65535,175,177,179,65535,181,183,185,187,189,65535,191,65535,193,195,65535,65535,197,65535,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,65535,243,245,65535,247,249,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,56,58,60,62,64,66,65535,68,65535,70,65535,72,74,76,78,80,82,84,86,88,90,65535,92,94,65535,65535,96,65535,98,100,102,104,106,108,110,112,114,65535,116,118,120,65535,122,124,126,128,130,132,134,136,138,140,65535,142,65535,144,65535,146,148,150,152,154,65535,65535,156,158,160,162,164,166,168,170,172,174,65535,65535,176,178,180,65535,182,184,186,188,190,65535,192,65535,194,196,65535,65535,198,65535,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,65535,244,246,65535,248,250,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({41.5,13.5,999.5,2.5,26.5,20.5,1016,44,35,17.5,27,11216.5,367,13.5,1411,33.5,30.5,26.5,34.5,69,532.5,44.5,116.5,319.5,-0.0063497485,53.5,382.5,-0.001054564,-0.012967065,1379,5766.5,187.5,1.5,0.010711661,-9.321e-05,22,6.5,6.5,117,33.5,73,38,0.0068372847,20.5,20.5,15.5,121.5,12.5,90.5,61,57,0.023590526,1007.5,1284,7,5682,6614.5,20.5,-0.0050349603,0.0016983169,0.00466468,22,5.5,4.5,9.5,-0.00752324,22,48,391,28.5,0.0029505843,-0.002604807,-0.0064415126,22,86,24,21.5,955.5,-0.01754608,-0.00017381574,32.5,0.0034016576,987.5,6.5,297.5,349,18.5,0.0002752799,32.5,0.0059347553,319,783,1142,1285,18.5,-0.0076461793,14.5,5487.5,17.5,8926,6952.5,1.5,5.450807e-05,22,7,22,11.5,85.5,27,27,12.5,-0.005228753,0.0019062255,0.00068551296,0.0036121008,7.5,1218,22,15.5,22,22,-0.0013614363,-0.004466444,1.9115316e-05,18.5,0.0043463483,-0.0031293947,16.5,-1.318025e-06,-0.0045636515,19.5,5.215386e-05,-0.0009999067,162,61,1907,157,0.010451603,6.5,4.5,1685,-0.0024073082,-0.006208367,348,885,486,725.5,749.5,0.0011015943,783.5,4.5,1525.5,1383.5,0.0025351,-0.008215074,5350.5,15.5,5834.5,6716,7077,9604.5,6690,6968,0.0024088852,0.0006882272,0.00026355483,-0.001570192,0.0017170588,0.0027572203,-0.005195103,-0.00082823465,-0.00014396595,-0.0025240646,8.595728e-05,0.005184402,0.00859063,0.0033222816,-0.006717372,-0.0016599831,0.0014336114,0.005543768,-0.0013259383,-0.0029790013,0.003229382,-0.0017530725,-0.001288929,7.7810415e-05,-0.0029734087,-0.0015843809,-0.00164939,0.0028247198,0.0049172947,0.0016782231,-0.003314887,-0.009084399,-0.00248912,-0.011833407,-0.0030164353,-6.184787e-06,-0.00029684306,0.0017913962,0.00080365705,-0.001620414,0.00057727256,-0.004374156,-9.305117e-05,-0.006783062,-0.0015897242,0.0022109302,-0.00042414034,0.0006118577,0.0005161621,-0.0059571243,-0.00017698963,0.0023755094,-0.0034875951,-0.0010491691,0.0010941599,-0.010990218,0.02701647,-0.0025715048,0.010260229,0.022000624,0.0023864722,-0.0008592006,-0.0142121855,-0.0041268566,0.00012762238,-0.00096355326,0.009887819,0.0003515313,0.00024062463,0.0019446068,-0.0008237296,0.00095750234,0.0022694983,-0.0016894815,-0.001398248,0.0023725324,-0.00027509223,-0.0022892086,0.004967398,0.00044888371,0.002530176,-0.0014875391,-0.0060744705,1.546162e-05}, {4,8,2,8,4,8,2,7,2,8,7,1,2,8,1,4,4,4,1,0,0,1,0,4,255,2,2,255,255,1,0,0,8,255,255,7,8,8,0,0,2,2,255,8,8,8,1,8,7,4,2,255,7,2,8,0,0,7,255,255,255,2,8,8,8,255,0,0,0,7,255,255,255,0,2,7,8,0,255,255,4,255,0,8,4,4,8,255,2,255,7,1,0,0,8,255,8,4,8,7,0,8,255,0,8,0,8,7,1,1,8,255,255,255,255,8,0,7,8,7,7,255,255,255,8,255,255,8,255,255,8,255,255,1,2,0,1,255,8,8,7,255,255,4,4,1,4,0,255,4,8,4,2,255,255,4,8,1,7,2,7,1,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,65535,65535,53,55,57,59,65535,65535,61,63,65,67,69,71,73,65535,75,77,79,81,83,85,87,89,65535,91,93,95,97,99,101,65535,65535,65535,103,105,107,109,65535,111,113,115,117,65535,65535,65535,119,121,123,125,127,65535,65535,129,65535,131,133,135,137,139,65535,141,65535,143,145,147,149,151,65535,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,65535,65535,65535,65535,181,183,185,187,189,191,65535,65535,65535,193,65535,65535,195,65535,65535,197,65535,65535,199,201,203,205,65535,207,209,211,65535,65535,213,215,217,219,221,65535,223,225,227,229,65535,65535,231,233,235,237,239,241,243,245,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,65535,65535,54,56,58,60,65535,65535,62,64,66,68,70,72,74,65535,76,78,80,82,84,86,88,90,65535,92,94,96,98,100,102,65535,65535,65535,104,106,108,110,65535,112,114,116,118,65535,65535,65535,120,122,124,126,128,65535,65535,130,65535,132,134,136,138,140,65535,142,65535,144,146,148,150,152,65535,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,65535,65535,65535,65535,182,184,186,188,190,192,65535,65535,65535,194,65535,65535,196,65535,65535,198,65535,65535,200,202,204,206,65535,208,210,212,65535,65535,214,216,218,220,222,65535,224,226,228,230,65535,65535,232,234,236,238,240,242,244,246,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7183,7135,7326,2.5,6989,6716,6847.5,10619,5.5,0.00938823,13.5,6335,5167,5162,8006,9791,6456.5,1590.5,7034.5,7143.5,7903,14,7244,0.007315518,7282.5,3292.5,17.5,7205,8056,7055.5,6394,2664,11667.5,1724.5,2106.5,6988.5,7053,0.0068781944,3.5,0.0027282143,9163,-0.0026254116,0.00750267,-0.0051346626,7231,7061,7442,7.5,13,5822,7110.5,7507,7738,3.5,8141.5,6857.5,-0.007162314,2937,6151,2524.5,11184,10992,12889.5,1228.5,4044,4.5,2317,3903,8715,9009,6027.5,-0.0034608357,8881.5,-0.0036503375,-0.00094829965,-0.012506107,-0.01984732,-0.006668392,15.5,-0.010343164,-0.00033339983,3178.5,17.5,-0.0064167003,-0.002338004,11.5,6510,0.012706916,5822,6769.5,7039,1.5,7933.5,0.009485871,8012.5,6480.5,8374,565.5,6789,2349.5,4424.5,9713,1.5,-0.003815601,-0.0015734278,3719.5,5838.5,1.5,0.007909692,-0.0055333925,0.001991825,4.5,1183.5,779.5,1402,1555.5,8180,4.5,6545.5,2377,1942.5,7916,-0.0016242856,-0.011549019,16.5,7334.5,12.5,0.0033050727,-0.00033907066,12423.5,9565.5,2.5,4.5,30719.5,18.5,5.5,-0.0031599186,6494.5,15.5,-0.007733567,6223,-0.00044959923,7080,-0.0036210516,-0.015013943,7910,7504,7435,1.5,0.006764274,15.5,8060.5,8515.5,10186.5,8544,0.00054111663,-0.0009544367,0.00088269386,0.010206066,-0.0009744029,0.0028822967,-0.007815148,-0.001818491,-0.001265456,-0.0045495806,-0.009080834,-0.004958467,0.0033038133,-0.00052414025,0.0022674254,-0.0021711101,0.0010738907,0.0061473865,-0.0012509972,0.0011446767,-0.0012001673,0.008626964,-0.0028376754,-0.0075818687,-0.00031110653,-0.0031119473,-0.0032952824,0.009445199,-0.0014903327,0.0022005714,-0.0035309752,0.00201058,0.001495524,-0.00051423063,-3.3152948e-05,-0.0008693707,0.00084587204,8.992172e-05,0.001401239,0.010208217,-0.0006562343,-0.005969662,0.010393611,0.0011596375,0.001027672,-0.002064765,-0.00025599753,-0.0026984136,0.003951163,0.0014948115,-0.0045903684,-0.001267076,0.00086951983,-0.0017926743,0.002377549,-9.082669e-05,-0.0071302573,0.0016724803,0.0024215512,0.009275007,-0.0006169754,-0.0038708118,0.0015710378,0.005295828,0.0040856297,0.0020070332,-0.0070811226,-0.0019821671,0.0024933997,-0.01261612,-0.0021226304,0.0021645695,-0.0024029873,-0.008516333,-0.007460739,-0.0006197621,0.0029467526,-0.0007048982,-0.0012805517,0.0051557655,-0.01358202,-0.0012534404,6.208314e-05,0.0039535067,-0.0016953212,-2.4967094e-05}, {1,1,1,8,3,4,0,6,8,255,8,0,6,0,1,4,1,1,1,1,4,8,1,255,1,0,8,0,1,1,3,3,0,6,1,1,1,255,8,255,3,255,255,255,3,6,3,8,8,0,3,1,1,8,1,3,255,3,1,1,0,4,4,4,6,8,1,6,3,4,6,255,3,255,255,255,255,255,8,255,255,4,8,255,255,8,0,255,0,3,0,8,0,255,1,3,1,1,1,3,1,0,8,255,255,3,1,8,255,255,255,8,6,1,1,3,6,8,3,6,3,3,255,255,8,0,8,255,255,0,4,8,8,1,8,8,255,0,8,255,0,255,0,255,255,0,6,3,8,255,8,0,4,0,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,19,21,23,25,27,29,31,33,35,37,39,41,43,65535,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,65535,73,65535,65535,65535,75,77,79,81,83,85,87,89,91,93,95,97,65535,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,127,65535,65535,65535,65535,65535,129,65535,65535,131,133,65535,65535,135,137,65535,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,165,65535,65535,167,169,171,65535,65535,65535,173,175,177,179,181,183,185,187,189,191,193,65535,65535,195,197,199,65535,65535,201,203,205,207,209,211,213,65535,215,217,65535,219,65535,221,65535,65535,223,225,227,229,65535,231,233,235,237,239,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,20,22,24,26,28,30,32,34,36,38,40,42,44,65535,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,65535,74,65535,65535,65535,76,78,80,82,84,86,88,90,92,94,96,98,65535,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,128,65535,65535,65535,65535,65535,130,65535,65535,132,134,65535,65535,136,138,65535,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,166,65535,65535,168,170,172,65535,65535,65535,174,176,178,180,182,184,186,188,190,192,194,65535,65535,196,198,200,65535,65535,202,204,206,208,210,212,214,65535,216,218,65535,220,65535,222,65535,65535,224,226,228,230,65535,232,234,236,238,240,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4008.5,3984.5,9845.5,3402,8093,11828,10164.5,3388.5,4947,7726,-9.832408e-05,11570.5,7718,7518.5,13178.5,10782,7154.5,6215.5,6871,-0.0097371545,-0.0034119391,7183,6678.5,7874.5,5979.5,7656.5,8968,9283,21135,9463,2665,2396.5,0.0027825884,4657,4671.5,5258.5,3899.5,7070.5,7201,0.0020090586,0.006004183,0.0014500524,29130.5,-0.0057327966,7054.5,6861.5,-0.010664276,7561.5,6087.5,7967.5,12568,19383.5,21376.5,9458.5,2486.5,10918.5,13005,-0.0003637705,0.0013263271,6576.5,7736,1495.5,3373.5,0.0054337583,3395.5,3505.5,8914.5,7036.5,6478,-0.008710938,10182.5,0.0006231797,0.0012349574,6768,14532.5,-0.0005113189,-0.0013176375,0.0031473301,11124.5,9838,11429,11318.5,8269,11720.5,12294.5,13844.5,11159.5,21756,21677,1516.5,2121.5,2423,3163,6434.5,1737,3300.5,3064,3443,-0.004792796,-0.013482575,-0.00049760187,-0.004922499,3562.5,-0.0015398547,4802.5,3173.5,7654,6328,6741.5,-4.506482e-05,0.0042804955,6282,7901.5,0.010565671,6124.5,9484.5,10175,-0.003099906,-0.004205189,-0.001507711,-0.0025810187,12458,0.0022567962,4549.5,6169.5,10433.5,12008.5,11094.5,11902.5,8159.5,8558.5,10462.5,11525.5,12435.5,13336,19092.5,20978,10595,18096,21593,-0.0003182747,9509,21717.5,8.880013e-05,-0.00019630187,-0.009792276,-0.00031668486,0.000384175,-0.0019518512,0.0026572838,0.00010385412,-0.001731634,-0.0046034846,0.0009306725,-0.00056303386,0.001432882,-0.0034012669,-0.0009922596,-4.0002724e-05,-0.0043433695,-0.0011404041,-0.0008750128,0.00037344758,-0.0042925184,-0.003006906,0.00030104266,-0.00033482895,0.0035636805,0.0019873613,0.0027974097,-0.00033393022,-0.00013410031,-0.001761753,0.00011319506,0.000933576,-0.0018461393,-0.016440092,0.006118141,0.0014872908,-0.00018508738,-0.016424628,0.00023906333,0.0012887724,0.0005969183,0.001558055,-0.0017476382,4.9009366e-05,0.0026410413,0.0018421228,-0.0015247859,-0.0117669245,-0.00049996056,0.00019128186,-3.0237094e-05,0.0028682533,-0.0007860467,0.0036831002,0.0040432066,0.0026871895,-0.0014715405,0.0020961978,-0.013892229,-0.0057736808,0.00037461732,-0.0044515207,0.0003149421,0.0032522639,-0.007210663,0.001764253,0.0007130852,-0.0032149542,-0.0021556835,0.0015095827,-0.00041188972,-0.004546599,0.004130985,0.00021999693,-0.005854512,-0.0037435151,-0.0074133347,0.004475733,-0.009138538,-2.487638e-05}, {7,7,6,7,1,2,6,7,5,2,255,2,6,2,2,4,4,6,2,255,255,1,1,4,7,4,2,1,4,6,7,1,255,1,5,1,7,1,1,255,255,255,2,255,1,1,255,2,7,1,7,2,4,6,7,5,2,255,255,2,1,1,1,255,2,7,2,1,2,255,7,255,255,1,1,255,255,255,1,4,7,6,5,2,6,5,5,5,4,6,1,7,1,1,7,7,5,7,255,255,255,255,7,255,5,2,1,5,1,255,255,5,2,255,6,6,2,255,255,255,255,7,255,1,1,7,5,6,5,1,1,4,5,1,5,6,7,5,5,2,255,7,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,65535,65535,37,39,41,43,45,47,49,51,53,55,57,65535,59,61,63,65,67,69,65535,65535,65535,71,65535,73,75,65535,77,79,81,83,85,87,89,91,93,95,65535,65535,97,99,101,103,65535,105,107,109,111,113,65535,115,65535,65535,117,119,65535,65535,65535,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,65535,65535,65535,65535,161,65535,163,165,167,169,171,65535,65535,173,175,65535,177,179,181,65535,65535,65535,65535,183,65535,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,65535,65535,38,40,42,44,46,48,50,52,54,56,58,65535,60,62,64,66,68,70,65535,65535,65535,72,65535,74,76,65535,78,80,82,84,86,88,90,92,94,96,65535,65535,98,100,102,104,65535,106,108,110,112,114,65535,116,65535,65535,118,120,65535,65535,65535,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,65535,65535,65535,65535,162,65535,164,166,168,170,172,65535,65535,174,176,65535,178,180,182,65535,65535,65535,65535,184,65535,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({62.5,3597,20.5,3.5,14161.5,17.5,63.5,31.5,7.5,-0.008668311,0.0021121318,7.5,88,21.5,384.5,65,35,36,61,4.5,81,0.005293919,0.0017215138,18.5,2285.5,294.5,391.5,104.5,0.002924134,2.5,55.5,31.5,105.5,14.5,-0.0070162714,0.0036972414,0.0018277884,0.0009116915,13.5,28.5,2500.5,-8.251791e-05,0.01152313,12.5,346.5,0.00824058,369.5,22,-0.0032690966,1.5,0.0028889407,46.5,55.5,20.5,4.5,49.5,72.5,125.5,161,-0.0010210032,-0.0018946553,6.5,60,724.5,2489,254,6476,19.5,350.5,303,371.5,22,1.5,0.0034032282,0.007546687,-0.0008321255,0.004760913,-0.0027459373,9.532728e-05,22,23.5,44.5,49,-1.2169361e-05,39,22,127,36,150.5,32.5,65,0.004906985,0.0007509021,4.5,4245,45.5,544,-0.012457184,-0.0020881312,232.5,333.5,3279,18,15.5,315,0.005171837,11.5,1.5,20.5,-0.0072708554,1153,-0.00028330364,-0.0022840018,-0.0008099756,0.001212087,-0.0019991489,0.00023464454,0.0010827276,-0.00033151472,-0.0030156104,0.001277693,-0.005116564,-0.012591076,0.00023261421,0.008281889,-0.0028314542,-0.001751332,-0.0008507905,0.00019680362,0.00047393606,-0.0014223554,0.007381167,0.0032770545,-0.0010362582,0.0013200513,-0.010881028,-0.002908251,0.0026459128,-0.0016631595,0.00087201776,-0.0002563952,-0.0009823658,0.0013160012,-0.0038335882,-0.0017291391,-0.00022867804,-0.0013440156,0.0034109147,-0.000604849,0.00046891105,0.009528234,-0.00029556427,-0.0076489286,-0.0023625602,0.001637267,0.00021189688,-0.00765892,-3.5731573e-05,-0.0021019408,0.0032575724,-0.00021430636,0.0014262563,0.0135114705,-0.0004377348,1.8559773e-05}, {2,0,5,8,0,8,0,2,8,255,255,8,2,8,0,5,2,5,2,8,2,255,255,8,6,0,0,6,255,8,0,2,6,8,255,255,255,255,8,6,5,255,255,8,0,255,3,2,255,8,255,0,6,5,8,6,5,0,0,255,255,8,6,6,2,0,6,8,0,3,3,6,8,255,255,255,255,255,255,2,3,0,2,255,0,2,0,5,0,5,6,255,255,8,6,3,5,255,255,2,6,6,8,8,0,255,8,8,8,255,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,19,21,23,25,27,29,31,33,35,37,65535,65535,39,41,43,45,47,65535,49,51,53,55,57,65535,65535,65535,65535,59,61,63,65535,65535,65,67,65535,69,71,65535,73,65535,75,77,79,81,83,85,87,89,65535,65535,91,93,95,97,99,101,103,105,107,109,111,113,65535,65535,65535,65535,65535,65535,115,117,119,121,65535,123,125,127,129,131,133,135,65535,65535,137,139,141,143,65535,65535,145,147,149,151,153,155,65535,157,159,161,65535,163,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,20,22,24,26,28,30,32,34,36,38,65535,65535,40,42,44,46,48,65535,50,52,54,56,58,65535,65535,65535,65535,60,62,64,65535,65535,66,68,65535,70,72,65535,74,65535,76,78,80,82,84,86,88,90,65535,65535,92,94,96,98,100,102,104,106,108,110,112,114,65535,65535,65535,65535,65535,65535,116,118,120,122,65535,124,126,128,130,132,134,136,65535,65535,138,140,142,144,65535,65535,146,148,150,152,154,156,65535,158,160,162,65535,164,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1470.5,1542.5,1038.5,1212.5,1571,856.5,420,1167,1340,0.00651105,0.004177296,510.5,2516.5,3050.5,428.5,1408,1203,1366,25601.5,1679.5,1272,1717.5,-0.005266188,-0.00337746,351.5,0.00475035,7744,283.5,1030.5,751.5,-0.0013228876,1264,1299.5,8162.5,-0.004327791,0.00066924695,2373,0.00304508,2357.5,-0.001074095,-0.0027294913,4680,390.5,7680,7790,275,404,2209,1020,-0.0114415055,-0.0005124581,1237.5,0.0066003734,-0.0038729087,0.00071403896,1409.5,271,-0.0024605575,-0.0012010427,1716.5,4758,28.5,224.5,426,8780.5,7670.5,8220,5748,26746,261.5,-0.007383217,633.5,861.5,1588,316,-0.0048598894,-0.00804951,0.0048706075,0.001657484,1284,-0.0017894245,0.0026512078,329.5,-0.0010787195,-0.002330584,2832.5,-0.00043324518,-0.0011557721,-0.0005861653,74.5,0.0006873374,-0.0023062758,-0.0014787031,-0.00050992816,-0.0014477574,9363.5,-0.008978608,7827.5,-0.003327372,-0.0057700775,-0.002209859,25393.5,28068,3.4799123e-05,0.0025730513,0.0050366926,-0.0017816009,-9.2670285e-05,0.0016896259,-0.0021469393,0.0024703117,5.1151415e-05,-0.0013589072,0.0008294649,0.0026364187,-0.0019097647,9.850944e-05,0.000994946,0.0021939555,-0.0002286107,-7.695795e-05,-8.490361e-05,0.00024698948,0.002982157,0.0056432956,-7.3239295e-05,-0.000924471,0.0008550095,-1.2366355e-05}, {2,3,3,0,3,3,0,0,0,255,255,3,0,3,0,4,0,4,0,2,4,0,255,255,0,255,7,3,0,3,255,0,0,0,255,255,0,255,0,255,255,3,5,7,7,3,4,4,3,255,255,0,255,255,255,3,3,255,255,2,0,0,0,4,2,7,5,2,4,3,255,2,4,5,2,255,255,255,255,2,255,255,7,255,255,0,255,255,255,0,255,255,255,255,255,0,255,3,255,255,255,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,19,21,23,25,27,29,31,33,35,37,39,65535,65535,41,65535,43,45,47,49,65535,51,53,55,65535,65535,57,65535,59,65535,65535,61,63,65,67,69,71,73,75,65535,65535,77,65535,65535,65535,79,81,65535,65535,83,85,87,89,91,93,95,97,99,101,103,65535,105,107,109,111,65535,65535,65535,65535,113,65535,65535,115,65535,65535,117,65535,65535,65535,119,65535,65535,65535,65535,65535,121,65535,123,65535,65535,65535,125,127,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,20,22,24,26,28,30,32,34,36,38,40,65535,65535,42,65535,44,46,48,50,65535,52,54,56,65535,65535,58,65535,60,65535,65535,62,64,66,68,70,72,74,76,65535,65535,78,65535,65535,65535,80,82,65535,65535,84,86,88,90,92,94,96,98,100,102,104,65535,106,108,110,112,65535,65535,65535,65535,114,65535,65535,116,65535,65535,118,65535,65535,65535,120,65535,65535,65535,65535,65535,122,65535,124,65535,65535,65535,126,128,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({26.5,22,35,5627,22,44.5,686,34.5,0.0021453125,0.004212655,42.5,32.5,949.5,473,687.5,56,45,24,42,27,1113.5,52,1218,69.5,476,0.0059130094,313.5,52,61,-0.0035231882,170.5,27,-0.0012318968,29.5,67.5,33.5,30,33.5,0.00033129242,-0.004120605,79.5,0.0019632338,32053,65,44,-0.005655916,354,151,498.5,22,-0.0009605701,0.0023027663,3434,67,941.5,0.00011220083,-0.00049016083,0.0006190797,0.005849168,2.9134642e-07,0.0013692128,27,0.0006754319,0.0008972863,36,-0.00063397276,-0.0027431736,71,74,25432,0.0014914782,165.5,99.5,0.005454026,51.5,2945.5,533,205,1076.5,472,603.5,48,22,0.00019725555,0.0008051986,-0.0002752952,7.718597e-05,0.0011100064,3161,29.5,6.3467705e-05,29.5,0.0006314471,57,0.003656871,143.5,81,16934,-0.0022859054,95.5,-0.002390171,93.5,155,374,286.5,471.5,4363.5,549.5,771.5,0.0009849146,957.5,858.5,256.5,421.5,-0.017481918,1128,346,0.00023506799,0.0008392891,0.0029400706,0.00090811617,-5.338278e-06,6.859295e-05,-0.00076860713,-0.0013796644,0.00048981764,0.00019032204,-0.00013441277,-0.0017707549,-0.0017619048,-0.0033088818,0.0011884641,-0.0018611694,-0.00115972,0.0009338899,-0.00010574813,0.002559992,-0.0055410503,0.0003526365,-0.0013785555,0.0046364437,0.0017065544,0.008039857,0.00021449574,-0.0005117772,0.0017777408,0.00027541604,-0.0009210554,8.9123394e-05,0.00041013845,-0.0011506921,-0.0056981803,-0.0009881869,-0.002091452,-0.0015579419,0.00320431,0.00791877,0.0020372237,-0.00092540664,-0.00094589154,0.0023195425,0.006673789,0.0025357977,0.0011373821,-1.1245604e-05}, {0,0,4,7,7,1,0,2,255,255,7,4,0,5,0,5,4,4,2,2,7,1,0,5,5,255,1,4,4,255,2,2,255,2,2,0,2,7,255,255,1,255,1,4,2,255,2,5,1,2,255,255,4,2,2,255,255,255,255,255,255,4,255,255,2,255,255,0,2,0,255,2,0,255,7,7,1,4,0,1,1,7,4,255,255,255,255,255,2,0,255,0,255,0,255,0,2,0,255,2,255,2,4,0,5,0,4,7,2,255,0,4,1,1,255,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,65535,53,55,65535,57,59,61,63,65,65535,65535,67,65535,69,71,73,65535,75,77,79,81,65535,65535,83,85,87,65535,65535,65535,65535,65535,65535,89,65535,65535,91,65535,65535,93,95,97,65535,99,101,65535,103,105,107,109,111,113,115,117,119,65535,65535,65535,65535,65535,121,123,65535,125,65535,127,65535,129,131,133,65535,135,65535,137,139,141,143,145,147,149,151,65535,153,155,157,159,65535,161,163,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,65535,54,56,65535,58,60,62,64,66,65535,65535,68,65535,70,72,74,65535,76,78,80,82,65535,65535,84,86,88,65535,65535,65535,65535,65535,65535,90,65535,65535,92,65535,65535,94,96,98,65535,100,102,65535,104,106,108,110,112,114,116,118,120,65535,65535,65535,65535,65535,122,124,65535,126,65535,128,65535,130,132,134,65535,136,65535,138,140,142,144,146,148,150,152,65535,154,156,158,160,65535,162,164,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1.5,4961.5,2456.5,4725.5,9343.5,2455.5,1611,8968,-0.0073631317,9290,17379,888.5,10.5,18.5,1625.5,5060.5,10274.5,8902.5,10556,17823.5,28022.5,862.5,1204,-0.009277071,-0.004074227,17.5,1681.5,-0.0037896074,2873.5,4480,1529,8997,4919.5,8526,9601.5,6459,11286,13126,22764,32059.5,32413,857.5,17.5,6.5,20.5,1580,1601.5,2252.5,6984.5,16.5,3160.5,339.5,5158.5,1502.5,2019.5,0.000617418,2469.5,4162.5,0.00562571,8064.5,-0.0036153689,0.014508915,0.004439924,6514.5,-0.01721753,0.007716723,10376.5,12265.5,14647.5,10326.5,11077.5,19061.5,24639.5,29581,29712.5,879.5,-0.0058693564,677,0.012306465,1782.5,570,1331.5,1925,15.5,4510,6233.5,-0.00016993533,0.004601357,1454,-0.0088725295,7209.5,2.5,2926,17.5,5.5,187.5,458,5537.5,5542.5,-0.0029568896,-0.005779482,7379.5,2543.5,9903,0.009092917,3328,-0.0031078837,7155,0.011396276,-0.0032458548,0.0031302464,11005,5385,15408.5,10975,0.010276945,0.003004113,9702,12946,23587.5,13151.5,21930.5,29016.5,-0.003557092,24812,-0.0031594378,29830,29711.5,30175.5,752.5,18.5,6.5,0.0036780674,1250.5,-0.006257175,512,1724,1421,12.5,1887,2335.5,6.5,6233.5,0.008322111,10.5,0.008707174,0.002381021,20.5,7285.5,-0.0031376358,2123,4504.5,6.5,1698.5,2778,8.5,3070.5,10233.5,5201.5,-0.00014039129,0.004235074,-0.009107562,-0.0004957844,0.0064346157,0.0031839763,-0.00434087,0.0035677447,0.0056145755,-0.0011352698,-0.006536641,-0.001584519,0.0035353028,0.0011118108,-0.0008369246,0.002845968,0.004315201,0.0007653342,0.0007351563,-0.00094147056,0.0024537132,0.006338313,-0.0007342435,0.005789276,-0.0015806968,0.010939744,-0.0059607765,-0.0004798856,-0.010223629,-0.0044482886,0.00057373097,0.0025601613,-0.000237697,-0.002464395,0.005987681,-0.0015515003,0.010742453,0.015992427,-0.00072080817,-0.000120158926,0.0031140244,0.0006914784,-0.000498051,0.0011224652,-0.0009269745,-0.00042352753,-4.489732e-05,0.0013581738,-0.00082885934,-0.0076705897,0.00013107888,-0.0024231605,0.0017778957,-0.0013203816,-0.0007792278,0.003248638,-0.0032026246,-3.990955e-05,-0.00031246615,0.0027023654,0.00020716204,-0.0013662189,0.0016559769,0.012573684,-0.011922429,0.0025332368,-0.00038242232,0.0015238777,-0.004520851,0.00029682386,0.00080813374,0.0014033259,-0.0004315842,-0.0038168617,0.0003617034,0.0029993046,-0.0010819944,0.0019265618,-0.007431108,-0.0002701612,0.001472735,-0.0004410545,-0.0014707028,0.008287187,0.0014240497,-0.003044948,-0.0012937024,0.0006164399,-0.0011151158,-0.0077270726,0.00056455523,-0.0001550218,-0.000367344,5.2732466e-06}, {8,5,2,5,2,2,3,2,255,4,5,2,8,8,3,4,2,2,5,2,2,2,3,255,255,8,1,255,2,2,5,4,1,2,3,3,5,1,2,1,1,2,8,8,8,3,1,4,4,8,2,1,3,5,5,255,3,5,255,2,255,255,255,1,255,255,4,5,2,3,5,3,4,4,2,3,255,4,255,2,1,3,5,8,4,4,255,255,1,255,2,8,1,8,8,1,1,2,2,255,255,2,5,4,255,1,255,3,255,255,255,3,3,4,4,255,255,1,3,4,1,4,5,255,2,255,4,2,4,2,8,8,255,5,255,1,4,4,8,1,4,8,4,255,8,255,255,8,2,255,1,1,8,1,2,8,2,1,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,43,65535,65535,45,47,65535,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,65535,107,65535,65535,65535,109,65535,65535,111,113,115,117,119,121,123,125,127,129,65535,131,65535,133,135,137,139,141,143,145,65535,65535,147,65535,149,151,153,155,157,159,161,163,165,65535,65535,167,169,171,65535,173,65535,175,65535,65535,65535,177,179,181,183,65535,65535,185,187,189,191,193,195,65535,197,65535,199,201,203,205,207,209,65535,211,65535,213,215,217,219,221,223,225,227,65535,229,65535,65535,231,233,65535,235,237,239,241,243,245,247,249,251,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,44,65535,65535,46,48,65535,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,65535,108,65535,65535,65535,110,65535,65535,112,114,116,118,120,122,124,126,128,130,65535,132,65535,134,136,138,140,142,144,146,65535,65535,148,65535,150,152,154,156,158,160,162,164,166,65535,65535,168,170,172,65535,174,65535,176,65535,65535,65535,178,180,182,184,65535,65535,186,188,190,192,194,196,65535,198,65535,200,202,204,206,208,210,65535,212,65535,214,216,218,220,222,224,226,228,65535,230,65535,65535,232,234,65535,236,238,240,242,244,246,248,250,252,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31.5,41.5,4566.5,689,515.5,4553,4635.5,30,0.003515178,306,28.5,3224,4650.5,4676,5059.5,31.5,103,75.5,0.0055132657,766,1061,3019.5,3549.5,-0.006129364,4118.5,4075,6397,4934,5060.5,23.5,0.00189805,27,-0.00017545787,0.0023531304,71,-0.0012836432,1606,0.002909518,0.0019682904,2969.5,13628,3537.5,3567.5,-0.0011781554,0.00034210636,3494.5,-4.83202e-05,0.008714239,0.003980703,3788.5,5146,-0.0036813964,5750,23.5,22,34,0.0012596237,0.0025030575,271.5,0.0004658865,5211.5,4006,8706,10270.5,3203.5,4168.5,3546,7477,4201,0.0009985229,0.0024937089,2990.5,4119.5,4352,5170,5726,5769.5,20.5,0.002525868,26.5,-0.0015764015,-2.325039e-05,50,112.5,0.0018217368,0.0006582359,0.00089877716,3604,9393,2984.5,2998,6252,3166.5,15145,-0.0026485638,1139,6057.5,-0.0030626007,-0.0058791195,0.0026830935,0.0071259686,4104,4226,-0.0040930943,5000.5,-0.005258061,6726.5,0.0017948877,5264,-0.0036804804,7252,9360,5849.5,0.0048284614,6077,-0.00022624728,0.00032999853,0.000111081776,-0.00028819215,0.0014832387,0.00068946125,0.00024656308,0.0007029189,-2.2874307e-05,-0.0024002206,0.0026854423,-0.0027307735,8.465966e-05,-0.0017986266,-0.0075265095,-0.00015121695,0.0020808338,-0.0010063634,0.0040163733,0.0025980393,-0.0006003575,0.00034728934,0.0011155488,-0.0011887071,-0.0011090335,0.00225336,-0.00015782064,0.0013342865,-0.0066082585,-0.0006984246,0.0016093099,0.005484185,-0.0003413121,0.0009876428,0.01138373,0.006169711,0.0016252702,-0.0011707462,8.017362e-05,-0.002133827,-0.009738627,-0.0028072554,0.0004104167,-1.4704317e-05}, {6,2,3,1,1,3,3,1,255,1,6,1,5,1,3,2,1,1,255,1,1,1,1,255,1,1,4,3,3,1,255,2,255,255,2,255,1,255,255,1,2,1,1,255,255,1,255,255,255,6,4,255,3,3,2,1,255,255,1,255,1,3,2,2,5,5,1,2,3,255,255,4,4,4,4,3,3,1,255,1,255,255,1,1,255,255,255,3,2,1,1,2,1,4,255,5,2,255,255,255,255,3,3,255,4,255,1,255,6,255,5,6,2,255,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,65535,43,45,47,49,51,53,65535,55,65535,65535,57,65535,59,65535,65535,61,63,65,67,65535,65535,69,65535,65535,65535,71,73,65535,75,77,79,81,65535,65535,83,65535,85,87,89,91,93,95,97,99,101,65535,65535,103,105,107,109,111,113,115,65535,117,65535,65535,119,121,65535,65535,65535,123,125,127,129,131,133,135,65535,137,139,65535,65535,65535,65535,141,143,65535,145,65535,147,65535,149,65535,151,153,155,65535,157,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,65535,44,46,48,50,52,54,65535,56,65535,65535,58,65535,60,65535,65535,62,64,66,68,65535,65535,70,65535,65535,65535,72,74,65535,76,78,80,82,65535,65535,84,65535,86,88,90,92,94,96,98,100,102,65535,65535,104,106,108,110,112,114,116,65535,118,65535,65535,120,122,65535,65535,65535,124,126,128,130,132,134,136,65535,138,140,65535,65535,65535,65535,142,144,65535,146,65535,148,65535,150,65535,152,154,156,65535,158,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({56,26.5,63.5,60,26.5,61,6973,27,22,446.5,32.5,-0.0031308755,2125,6582,7026.5,22,60.5,-0.00063837087,130.5,32.5,24973,40.5,41.5,123,0.0012228637,6538,7104,7229,7034,71,73.5,22,0.0017122685,-0.0012153598,-0.0016704707,30,43,955.5,25523.5,22,0.003933314,38,610,-0.0009517681,-0.0027982437,5791,0.0070672603,6558,8170.5,6531.5,0.011690454,-0.010323157,7664,155.5,72.5,-0.0009879128,117,-0.00031711528,36,0.0007692857,0.00020187262,0.0050658467,244.5,56.5,0.002476025,-0.0021583035,0.00041189743,0.0010713966,26.5,64,126.5,128,0.002292025,5727.5,7293.5,6510,5473,7668.5,8518.5,4638.5,-0.006017264,6673,7944.5,22,-0.001380545,0.00027430893,0.0012196127,-0.00012290735,360.5,0.00064761133,0.00010178599,44.5,0.008307434,-0.0010149896,0.00031999647,0.00023809132,8.305076e-05,-0.0035086111,1113.5,0.00089783967,53.5,27,29,6453,5613.5,8595.5,6920,7151,0.0074148485,6981,6843,6106.5,6754.5,8045,8718.5,1750,0.0082841925,6495.5,6999.5,8097,9663.5,-8.535225e-05,0.0005276361,-0.00049090304,-0.00080740725,0.001647626,-0.0023364595,-0.0014234224,0.00014806185,2.724881e-05,-0.00031968727,-0.0003127755,0.0005098615,0.00090067025,0.0005182194,-0.00013449957,-0.0028033801,-0.00047881977,-0.011235382,0.0013600594,0.012209223,0.00011856604,-0.0029822157,-0.0016993912,0.0013184465,0.011460933,-0.0014592041,-0.010365657,-0.0028925992,0.0005099904,-0.0006349686,0.00042924477,0.008683228,-0.007026199,-0.0005525945,0.0022125454,-0.0005688345,-0.0032274544,0.0021005992,-0.0008264307,-0.0058090445,0.0046125585,0.00033092295,-2.546658e-05,-0.0017145266,0.00017839417,-3.1493095e-05}, {4,4,4,7,7,0,4,7,2,0,4,255,0,0,4,4,0,255,2,0,0,3,4,0,255,0,0,7,4,2,0,2,255,255,255,0,0,0,0,0,255,1,0,255,255,3,255,1,7,3,255,255,4,0,0,255,0,255,2,255,255,255,0,2,255,255,255,255,0,7,0,7,255,3,3,1,3,7,1,1,255,0,4,2,255,255,255,255,0,255,255,1,255,255,255,255,255,255,7,255,2,3,0,0,4,7,4,2,255,0,1,3,2,0,1,1,255,0,0,3,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,65535,33,35,37,39,41,43,65535,45,47,49,51,53,55,57,65535,65535,65535,59,61,63,65,67,65535,69,71,65535,65535,73,65535,75,77,79,65535,65535,81,83,85,65535,87,65535,89,65535,65535,65535,91,93,65535,65535,65535,65535,95,97,99,101,65535,103,105,107,109,111,113,115,65535,117,119,121,65535,65535,65535,65535,123,65535,65535,125,65535,65535,65535,65535,65535,65535,127,65535,129,131,133,135,137,139,141,143,65535,145,147,149,151,153,155,157,65535,159,161,163,165,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,65535,34,36,38,40,42,44,65535,46,48,50,52,54,56,58,65535,65535,65535,60,62,64,66,68,65535,70,72,65535,65535,74,65535,76,78,80,65535,65535,82,84,86,65535,88,65535,90,65535,65535,65535,92,94,65535,65535,65535,65535,96,98,100,102,65535,104,106,108,110,112,114,116,65535,118,120,122,65535,65535,65535,65535,124,65535,65535,126,65535,65535,65535,65535,65535,65535,128,65535,130,132,134,136,138,140,142,144,65535,146,148,150,152,154,156,158,65535,160,162,164,166,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({58.5,33,7495,7069,30.5,7442.5,7496.5,23.5,0.005684539,47.5,41.5,7383.5,7758.5,-0.012800531,7568.5,23.5,31.5,33.5,-0.004895033,31,50.5,5365,7389,7469,7224.5,7555.5,7708.5,23.5,26.5,93,36,0.0012317073,1122,31.5,55.5,26.5,1086.5,5362,5413.5,-0.005340879,7882,2753.5,6316,0.0025200767,0.0077817254,9780.5,8616,6212.5,7980,20.5,0.0031971259,0.0023274494,30,72,22,0.002471208,0.00042340174,100.5,2649.5,14857,93,0.0021679152,0.0062879506,-0.0038670723,49,57,-0.0016994587,5189.5,0.0035467178,7413,9107,3813,-0.0041190377,0.0006181053,4180.5,7484.5,6934.5,7540.5,-0.007015945,-0.014207303,0.0013405775,4641,7624,5968.5,7986.5,3245,0.00036614254,22,0.0009846094,58,22,45.5,50.5,27,-0.002884537,0.00165503,-0.0010883868,68,0.00048607244,-3.3772052e-05,0.00040981933,-0.0012421383,-0.002273689,52,948.5,3801,5375.5,7317.5,10929,6189,7324,0.0009472676,7421.5,0.0019406459,0.0035169187,5944,0.0016127343,-0.0031225455,6552.5,7528,7551,0.0019559443,0.01066807,4584,8795,6163.5,8369,0.0046759206,2162.5,0.0001607781,3.738361e-05,-0.00024134033,-0.0008044505,-0.0002436313,-0.0011230403,-0.0012837258,-0.0025249636,-0.00017758104,0.00063754217,3.845125e-05,-0.0004977598,-0.002186426,-0.0004220708,-0.0015122326,-0.0034143687,-7.412981e-05,0.0018621305,-0.00047452204,-0.00033967049,0.00020535754,-0.00028261734,0.0011716014,0.00026407206,-0.0049368995,0.00041513026,0.002331837,-0.00076235266,0.00066404877,-0.0008478958,0.00036976396,0.006474603,-0.002374982,-0.00033327553,-0.00017721114,0.00071001664,-0.00018834106,2.6416605e-05,-7.877668e-05,0.003846552,-0.0034266685,0.0012752328,-0.0010473734,0.003246504,-0.010832018,0.000597931,-0.00043699774,0.003395369,-0.0032218278,0.0003205482,-0.0010486214,2.353697e-05}, {2,2,2,1,1,2,2,7,255,2,2,2,6,255,2,1,2,6,255,5,7,3,2,2,3,2,2,3,1,6,1,255,6,3,6,3,5,3,3,255,1,5,6,255,255,1,1,6,2,1,255,255,1,6,2,255,255,7,7,1,1,255,255,255,2,1,255,2,255,5,1,1,255,255,1,2,6,2,255,255,255,1,3,5,2,5,255,2,255,1,2,5,5,5,255,255,255,1,255,255,255,255,255,1,1,2,2,7,1,1,6,255,2,255,255,1,255,255,1,2,2,255,255,3,3,1,3,255,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,65535,25,27,29,31,65535,33,35,37,39,41,43,45,47,49,51,53,55,65535,57,59,61,63,65,67,69,65535,71,73,75,65535,65535,77,79,81,83,85,65535,65535,87,89,91,65535,65535,93,95,97,99,65535,65535,65535,101,103,65535,105,65535,107,109,111,65535,65535,113,115,117,119,65535,65535,65535,121,123,125,127,129,65535,131,65535,133,135,137,139,141,65535,65535,65535,143,65535,65535,65535,65535,65535,145,147,149,151,153,155,157,159,65535,161,65535,65535,163,65535,65535,165,167,169,65535,65535,171,173,175,177,65535,179,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,65535,26,28,30,32,65535,34,36,38,40,42,44,46,48,50,52,54,56,65535,58,60,62,64,66,68,70,65535,72,74,76,65535,65535,78,80,82,84,86,65535,65535,88,90,92,65535,65535,94,96,98,100,65535,65535,65535,102,104,65535,106,65535,108,110,112,65535,65535,114,116,118,120,65535,65535,65535,122,124,126,128,130,65535,132,65535,134,136,138,140,142,65535,65535,65535,144,65535,65535,65535,65535,65535,146,148,150,152,154,156,158,160,65535,162,65535,65535,164,65535,65535,166,168,170,65535,65535,172,174,176,178,65535,180,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({38,11.5,3473,100.5,951.5,868.5,3545,48.5,2.5,101.5,1377.5,775.5,2.5,16.5,5322,40.5,7,36.5,4.5,25.5,133,16.5,16.5,417,17.5,1657.5,969,4.5,3712,5883,5338,1.5,57,0.006205942,0.0002474518,-0.0018059955,-0.004752769,1227,1201.5,134.5,35,-0.003946603,16.5,0.004250106,0.012219951,0.000986768,-0.0019321358,409.5,637.5,4.5,797.5,1221.5,2531,850.5,1144,2984.5,4760.5,0.0032859948,0.008724695,2.5,8410,5335.5,5345.5,29,23.5,0.005631069,7.5,0.0048923553,-0.0023338823,80.5,-0.0038560182,17.5,15.5,27,186,0.00022598662,-0.002425785,404.5,7.5,17.5,2.5,1215,859,1051,1327,1312,1999.5,1.5,11140.5,16.5,13.5,1136.5,3508.5,0.010205045,0.0007020854,11,8.5,1799,5273.5,5527,8819,5325.5,-0.0067091966,7.5,5359.5,28.5,0.0062612756,6.5,3.5,3.5,29,6.5,0.0026004051,48.5,38,-0.00069686334,18.5,15.5,15.5,-0.0032823738,608.5,927.5,-0.0063030617,-0.0061966134,410.5,4.5,379,1058,5.5,-0.00072613586,0.01445743,11.5,12.5,0.022302514,0.0064934725,-0.0031914439,0.0027006783,1300.5,617.5,943,0.013761207,1763.5,2783.5,2684,3010,826.5,912.5,1144,1144,2036.5,12.5,3097.5,20.5,-0.0010586941,-0.002544783,-0.001353138,0.0013248534,3455.5,2971,20.5,5001,5015.5,5126.5,17.5,10059,-0.0023393582,0.00060979923,0.0065925545,15.5,5217.5,5377.5,-0.0007115355,0.0015208077,-0.00024827462,0.001468592,-0.0037755754,-0.0002736258,-0.0015942287,0.0024933608,-0.0023483858,-0.00064366846,0.00082347816,-0.0006766488,0.00059323275,-0.0023704362,-0.00060102175,0.0013913618,0.0049967295,-0.00015582764,0.007824222,0.0017449998,-0.00011931602,0.0025010935,0.0058564898,-0.0005601102,-0.00018442594,0.00050963287,0.0077517326,0.0014314291,-0.006449919,-1.9032337e-05,-0.012559459,-0.0040759007,0.0014877729,0.0077106166,-0.002058326,0.00025692477,0.010079535,0.001749046,-0.0037314694,0.002404335,0.0014917464,-0.011839616,-0.0012105498,0.0031317857,-0.0019236284,0.0019979624,0.003410895,-0.004848777,-0.0075579085,-0.015282507,-0.00011932213,0.001492083,-0.0063642818,-0.0011781984,0.00079394813,-0.0052827275,-0.0034665733,-0.012907549,-0.005721507,0.00066473434,0.0048154886,-0.0005486002,0.0007441882,-0.0016928777,0.005721289,0.010789234,-0.00034486759,-0.0016943952,0.00013033916,0.0028769413,0.010343838,0.0057925326,-0.0015868804,0.0027121832,0.00010802544,-0.0030601316,0.0005963998,0.0027621204,-0.0018703772,0.0032562155,-0.0021838376,-0.01134578,0.0017970931,0.006499305,-0.0041948645,-3.8568036e-05,-0.002338968,0.0024068316,-0.00095900195,-0.006392758,0.0031149224,-7.1688314e-06}, {2,8,0,7,0,1,0,4,8,1,7,1,8,8,0,0,8,0,8,1,1,8,8,1,8,4,1,8,1,7,0,8,0,255,255,255,255,7,0,7,7,255,8,255,255,255,255,1,4,8,1,7,7,7,1,1,2,255,255,8,7,0,0,2,1,255,8,255,255,0,255,8,8,1,7,255,255,1,8,8,8,4,7,0,2,1,0,8,1,8,8,1,1,255,255,8,8,1,2,4,7,0,255,8,0,7,255,8,8,8,4,8,255,4,4,255,8,8,8,255,7,2,255,255,1,8,7,0,8,255,255,8,8,255,255,255,255,0,7,4,255,0,4,0,2,7,0,7,7,2,8,0,8,255,255,255,255,4,1,8,0,4,0,8,7,255,255,255,8,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,65535,65535,65535,67,69,71,73,65535,75,65535,65535,65535,65535,77,79,81,83,85,87,89,91,93,95,65535,65535,97,99,101,103,105,107,65535,109,65535,65535,111,65535,113,115,117,119,65535,65535,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,65535,65535,153,155,157,159,161,163,165,65535,167,169,171,65535,173,175,177,179,181,65535,183,185,65535,187,189,191,65535,193,195,65535,65535,197,199,201,203,205,65535,65535,207,209,65535,65535,65535,65535,211,213,215,65535,217,219,221,223,225,227,229,231,233,235,237,239,65535,65535,65535,65535,241,243,245,247,249,251,253,255,65535,65535,65535,257,259,261,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,65535,65535,65535,68,70,72,74,65535,76,65535,65535,65535,65535,78,80,82,84,86,88,90,92,94,96,65535,65535,98,100,102,104,106,108,65535,110,65535,65535,112,65535,114,116,118,120,65535,65535,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,65535,65535,154,156,158,160,162,164,166,65535,168,170,172,65535,174,176,178,180,182,65535,184,186,65535,188,190,192,65535,194,196,65535,65535,198,200,202,204,206,65535,65535,208,210,65535,65535,65535,65535,212,214,216,65535,218,220,222,224,226,228,230,232,234,236,238,240,65535,65535,65535,65535,242,244,246,248,250,252,254,256,65535,65535,65535,258,260,262,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({22,21.5,1795.5,22,-0.004176834,1609,1884,7.5,27,26.5,18.5,1021.5,10552.5,22,22,9.5,18.5,15.5,15.5,4.5,1166.5,-0.008400534,1726,10502.5,8663,4.5,2.5,14.5,15.5,5.5,33,15.5,-0.0022434755,55.5,22,1410,1561.5,1197,9.5,1665.5,1695.5,0.0030753843,15.5,15.5,10530,12.5,12853,2.5,5.5,0.00018385926,93,11.5,18.5,12,18.5,0.0005434078,-0.0018014119,16.5,-0.0009635996,2847,64,11.5,92.5,20.5,34.5,12.5,1492.5,327.5,-0.0073665637,3.5,2.5,1337.5,1740.5,0.005678631,-0.002611606,0.013255029,0.007607917,1296,2349.5,7987.5,1454,-0.01260104,-0.007089078,7122,10665.5,9186.5,8910,1.5,0.0010722996,-0.0014992546,6.5,-0.004126074,-0.0017074663,8.5,12.5,-0.001620904,20.5,93,93,0.0049455557,93,-0.007590989,-0.0028654963,513,-0.004531126,-0.0004942887,0.004712356,34.5,-0.0017512143,2.5,6.5,712,66.5,-0.0010724923,0.0007993532,26.5,117.5,822.5,2.5,113.5,1360,0.0033357383,0.016454648,-0.0007788062,-0.0053368392,0.0020621852,1640.5,2288,13.5,-0.007770096,4.5,0.00486073,19.5,4.5,9957.5,17.5,3970,9887,12720,5124.5,5771,14085.5,1.5,6.5,15862,0.0005847116,0.00026308355,0.0003677123,-8.166275e-05,-0.0002379117,0.00011102145,0.0011942046,0.00034457166,-0.00032470483,-0.001283089,0.00031476453,0.0018249648,-0.0028085143,0.000216912,0.0027156032,-0.0028624746,-0.0006596408,0.0019479775,0.0009917975,0.0068091042,-0.0042399387,-0.000938404,-0.0001890545,0.00065959233,0.0037987889,-0.00029352537,0.0024735366,0.007277394,-0.00090728153,0.00015587818,0.0019018211,-0.00031983122,0.0014353284,0.007053332,0.00492885,-0.00013395546,-0.00035839033,0.0013030993,-0.0020789532,0.0017039186,-0.007108323,-0.00028968495,0.0001969006,-0.00344499,-0.00027606785,0.005975041,0.0018762546,-0.002634736,-0.00031587863,-0.0065675937,0.0004228361,-0.00024388677,-0.00024060886,-0.0010123827,-0.003634657,-0.00037317153,0.0015657087,0.000112781396,-0.0027058697,0.0007722559,0.006157135,0.001237383,0.0020712984,-0.00068410643,-0.0013508291,-8.3378334e-05,0.00035576083,-0.007370589,0.011545601,-0.0033525096,-0.00013375358,-0.0030104646,0.00054871175,-2.8960547e-05}, {2,8,2,0,255,2,2,8,0,0,8,1,6,6,6,8,8,8,8,8,7,255,0,6,7,8,8,8,8,8,6,8,255,6,0,2,2,7,8,2,2,255,8,8,6,8,6,8,8,255,6,8,8,8,8,255,255,8,255,0,0,8,2,8,2,8,6,1,255,8,8,0,2,255,255,255,255,6,1,6,1,255,255,7,0,0,7,8,255,255,8,255,255,8,8,255,8,6,6,255,6,255,255,0,255,255,255,2,255,8,8,6,2,255,255,1,1,1,8,1,6,255,255,255,255,255,1,6,8,255,8,255,8,8,0,8,0,2,6,1,7,7,8,8,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,65535,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,49,51,53,55,57,59,65535,61,63,65,67,69,71,73,75,65535,77,79,81,83,85,87,89,65535,91,93,95,97,99,65535,65535,101,65535,103,105,107,109,111,113,115,117,119,65535,121,123,125,127,65535,65535,65535,65535,129,131,133,135,65535,65535,137,139,141,143,145,65535,65535,147,65535,65535,149,151,65535,153,155,157,65535,159,65535,65535,161,65535,65535,65535,163,65535,165,167,169,171,65535,65535,173,175,177,179,181,183,65535,65535,65535,65535,65535,185,187,189,65535,191,65535,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,65535,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,50,52,54,56,58,60,65535,62,64,66,68,70,72,74,76,65535,78,80,82,84,86,88,90,65535,92,94,96,98,100,65535,65535,102,65535,104,106,108,110,112,114,116,118,120,65535,122,124,126,128,65535,65535,65535,65535,130,132,134,136,65535,65535,138,140,142,144,146,65535,65535,148,65535,65535,150,152,65535,154,156,158,65535,160,65535,65535,162,65535,65535,65535,164,65535,166,168,170,172,65535,65535,174,176,178,180,182,184,65535,65535,65535,65535,65535,186,188,190,65535,192,65535,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3193,1001.5,3236,747.5,17.5,10.5,13798.5,717.5,1536.5,1073.5,1094.5,2548,4747,13749.5,13996.5,18.5,18.5,399.5,4.5,1367,1515,1264.5,18.5,-0.0059412853,6.5,6866,-0.0046926658,19657.5,27059.5,16108.5,17683,5.5,1723,749,726.5,17.5,20.5,2729.5,1513.5,862,6.5,1094.5,8.5,0.0043406556,0.018578975,1791.5,584.5,3.5,0.0018580813,2861,15.5,12965,15.5,16353,-0.011587472,13860.5,20044.5,1.5,20664,138.5,6.5,28.5,620.5,0.0031033356,1056.5,0.031326417,0.0014606277,12.5,0.013599222,1.5,-0.0077842656,838,1049.5,6448,15.5,-0.004019491,1598.5,0.013167505,12.5,6.5,2.5,2136.5,3766.5,1657,2502.5,2100.5,1239.5,0.0008191792,-0.0008015345,-0.0013466108,-0.0049171657,-0.0025107649,-6.580819e-05,15.5,28252.5,11180.5,27956,13758.5,-0.0056339907,13809,9168.5,24196.5,0.0022726664,3181.5,14150,17958.5,20205.5,303,462.5,54.5,432.5,289,384,123,-0.014135075,11.5,0.0019128522,1339,-0.0037154518,-0.008607952,796.5,0.003116,0.011840363,334.5,-0.006162011,960.5,15.5,11.5,-0.0013709486,0.003743369,10.5,-0.0027328792,0.0071481573,-0.0039032982,12.5,1275.5,4.5,8602,2303,12.5,9741.5,-0.001668316,-0.0102794105,6307,2673.5,0.0030046978,0.009649123,2006.5,1280.5,10722,15488.5,29333,13953.5,5.5,21340.5,0.001085308,28374,-0.0030379507,12968,0.0015324503,12611.5,13237,24417,0.0063509145,0.011931619,-0.00455381,5689.5,13992,18023,23225.5,20876.5,18775,24566,0.000739736,-0.0020712926,-0.002083826,2.6326748e-05,-0.0011993562,0.00325522,3.2741664e-06,0.0011686004,0.0007950095,0.0075057815,-0.00020633893,-0.0019891977,0.0004849367,-0.0035795576,-0.0043467623,-0.00029350613,-0.0019402007,0.0009189186,0.0004345593,-0.002261195,0.0030156474,-0.00039263334,-0.00021219955,-0.0026202302,-0.00039165426,-0.006539743,0.0003395446,0.006617152,1.287504e-05,-0.0013563059,0.0009522291,-0.0042658327,0.011760211,0.0014382168,-0.0040292903,0.0017789444,0.0007668727,0.005312038,-0.0014358124,0.00043532375,-0.0029441302,-0.00011236075,0.00037412925,-0.00090814725,0.008208211,0.002969679,-0.0014947014,0.0014430307,-0.015760025,-0.007176734,0.0039157113,-2.151805e-05,-0.0003127818,0.0002927969,0.00031201722,-0.0010535264,-0.00025992183,-0.0026756802,-0.0049644923,-0.00021647522,-0.0011751741,0.0019076596,0.009252771,0.0045341672,-0.002014293,-0.0036519212,0.001089163,-0.00082435005,-0.00046420415,-0.0032443702,0.00056879217,-0.00035983688,0.0031210913,0.00037240086,0.0010131792,0.007821652,-0.00018358642,0.0070736594,-0.0028707255,0.0021084752,0.006535427,-0.00024337701,-0.0027011072,0.0026868114,0.0036819358,-0.001238631,-0.0006910164,6.302419e-05}, {3,3,3,3,8,8,3,3,4,3,2,1,1,3,3,8,8,6,8,2,2,6,8,255,8,6,255,1,2,1,2,8,6,2,3,8,8,4,2,2,8,2,8,255,255,2,6,8,255,1,8,1,8,1,255,3,1,8,4,6,8,4,3,255,1,255,255,8,255,8,255,3,2,6,8,255,4,255,8,8,8,1,4,6,1,3,4,255,255,255,255,255,255,8,2,3,6,3,255,3,1,2,255,2,4,3,2,1,4,1,3,1,1,1,255,8,255,1,255,255,6,255,255,1,255,3,8,8,255,255,8,255,255,255,8,1,8,2,1,8,4,255,255,4,1,255,255,3,1,6,2,4,1,8,1,255,4,255,2,255,1,2,6,255,255,255,1,4,3,2,2,3,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,65535,65535,83,85,87,65535,89,91,93,95,97,65535,99,101,103,105,107,109,111,113,65535,115,65535,65535,117,65535,119,65535,121,123,125,127,65535,129,65535,131,133,135,137,139,141,143,145,147,65535,65535,65535,65535,65535,65535,149,151,153,155,157,65535,159,161,163,65535,165,167,169,171,173,175,177,179,181,183,185,65535,187,65535,189,65535,65535,191,65535,65535,193,65535,195,197,199,65535,65535,201,65535,65535,65535,203,205,207,209,211,213,215,65535,65535,217,219,65535,65535,221,223,225,227,229,231,233,235,65535,237,65535,239,65535,241,243,245,65535,65535,65535,247,249,251,253,255,257,259,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,65535,65535,84,86,88,65535,90,92,94,96,98,65535,100,102,104,106,108,110,112,114,65535,116,65535,65535,118,65535,120,65535,122,124,126,128,65535,130,65535,132,134,136,138,140,142,144,146,148,65535,65535,65535,65535,65535,65535,150,152,154,156,158,65535,160,162,164,65535,166,168,170,172,174,176,178,180,182,184,186,65535,188,65535,190,65535,65535,192,65535,65535,194,65535,196,198,200,65535,65535,202,65535,65535,65535,204,206,208,210,212,214,216,65535,65535,218,220,65535,65535,222,224,226,228,230,232,234,236,65535,238,65535,240,65535,242,244,246,65535,65535,65535,248,250,252,254,256,258,260,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({12666.5,12376.5,14546,12104,13376,14473,18445.5,7514,31998,9534,9656.5,11722,11540,22563,19966.5,6270,7575.5,12746.5,2781,10534,11494.5,-0.009700872,-0.003503443,2947.5,12769.5,14194.5,13155.5,15990.5,17452,19841.5,20641,6120,9356.5,5578.5,10969,14038.5,2860,-0.0030270643,30444.5,0.0013510375,13042.5,-0.008697593,12463,13801.5,6669,14114,14766.5,14631.5,10829,0.010865539,-0.0035967168,16264,20316.5,0.0018490233,0.007295448,19413.5,22765.5,18181.5,22941.5,12000.5,6063.5,8794.5,7205,-0.015497814,7457.5,7726.5,5402.5,13381,-0.005462493,2886,13175,3179.5,3217.5,12940,0.0005298373,-0.0038741813,12633,25601.5,-0.0034560028,6559.5,7468,-0.011223253,11940.5,16113,13942.5,0.003906875,0.0016189782,-0.0015251904,-0.0009792041,12927,19002,18987.5,12748,19610,20751.5,21021,7573,12818,22507,27722.5,11196.5,10654,2959,6987,6235.5,8623,6473.5,6641.5,10911.5,4.4827128e-05,8611,6486,7962.5,11009.5,10783,8792,0.0074586496,0.00097552873,3163,12782.5,13506.5,-0.0008094962,-0.002451089,3105,-0.001616372,-0.0011525376,-9.7668344e-05,2753,-0.0021615443,12768,-0.0036