% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rSDR.R
\name{plot_rSDR}
\alias{plot_rSDR}
\title{Projected data plotting}
\usage{
plot_rSDR(projected_data,Y,Y.name,colors=NULL)
}
\arguments{
\item{projected_data}{projected data from rSDR results.}

\item{Y}{an \eqn{n \times 1} numeric matrix.}

\item{Y.name}{label for y-axis}

\item{colors}{Assign specific colors to each level of the response variable.}
}
\value{
No return value, visualizing reduced-dimensional data using 1D, 2D, or 3D projections. When the reduced dimension exceeds three, pairwise scatter plots are automatically generated.
}
\description{
Function for plotting of projected_data from rSDR results.
}
\examples{

library(ManifoldOptim)
library(rSDR)
utils::data("ionosphere", package = "fdm2id")
X<-as.matrix(ionosphere[,c(1:33)])
Y<-ifelse(ionosphere[,34]=='b',0,1)
Y<-matrix(Y,length(Y),1)
ionosphere$V35<-factor(ionosphere$V35,levels=c('b','g'),labels=c('Bad','Good'))
set.seed(2435)
\donttest{
sdr_result<-rSDR(X=X, Y=Y, d=3, alpha=0.3,maxiter=1000,tol=1e-7)
plot_rSDR(projected_data=sdr_result$projected_data,Y=ionosphere$V35,
Y.name='group',colors=c("#374E55FF", "#DF8F44FF"))
}
}
