% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_checks.R
\name{refdb_check_tax_conflict}
\alias{refdb_check_tax_conflict}
\title{Check for conflicts in taxonomy}
\usage{
refdb_check_tax_conflict(x)
}
\arguments{
\item{x}{a reference database.}
}
\value{
A list of two-columns tibbles reporting for each taxonomic level
the taxa with identical names but different upstream taxonomy.
}
\description{
Check for conflicts in taxonomy
}
\examples{
lib <- read.csv(system.file("extdata", "ephem.csv", package = "refdb"))
lib <- refdb_set_fields(lib,
                        taxonomy = c(family = "family_name",
                            genus = "genus_name",
                            species = "species_name"),
                        sequence = "DNA_seq",
                        marker = "marker")
refdb_check_tax_conflict(lib)

}
