% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_labels.R
\name{ru_labels}
\alias{ru_labels}
\title{Assign labels to variables in a data frame}
\usage{
ru_labels(dsetin, varlabels = list(), style = c("base", "Hmisc"))
}
\arguments{
\item{dsetin}{Incoming data frame to have labels added to columns.}

\item{varlabels}{List of variables and their labels.}

\item{style}{Type of method used to add labels.}
}
\value{
The incoming data frame with labels added.
}
\description{
Pass in a data frame along with a named list of columns with their corresponding labels.
}
\examples{
library(repfun)
df_with_labels <- ru_labels(mtcars,varlabels=list(mpg='Miles per gallon',
                                                  cyl='Number of cylinders'))

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
