% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regions.R
\name{gd_bbox}
\alias{gd_bbox}
\title{Prepare Bounding Box Region from X/Y Limits}
\usage{
gd_bbox(...)
}
\arguments{
\item{...}{One or more \code{SpatRaster}, \code{SpatRasterCollection}, \code{SpatVector}, \code{SpatVectorProxy} or \code{SpatExtent} objects (whose combined bounding box extent will be returned); or the following \emph{named} numeric arguments: \code{xmin}/\code{ymax}/\code{xmax}/\code{ymin}. If these four limit arguments are not named they should be in the stated order.}
}
\value{
a \emph{list} object describing a GeoJSON bounding rectangular polygon suitable for use as \code{regions} argument to \code{gd_download()} or \code{gd_search()}
}
\description{
Create a bounding box polygon Python object for use with \code{gd_download()}. The coordinates of the bounding box are expressed in WGS84 decimal degrees (\code{"OGC:CRS84"}).
}
\details{
Expecting total of 4 bounding box arguments, If arguments are unnamed they should be in the following order: "xmin", "ymax", "xmax", "ymin".
}
\examples{
gd_bbox(
  xmin = 5.744140,
  ymax = 50.18162,
  xmax = 6.528252,
  ymin = 49.44781
)
}
