% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{relevelsByNotNamedVec}
\alias{relevelsByNotNamedVec}
\title{Relevel a factor by a unnamed vector.}
\usage{
relevelsByNotNamedVec(
  x,
  refs,
  missingLevels = c("pass", "warning", "error"),
  unrecognisedLevels = c("warning", "pass", "error")
)
}
\arguments{
\item{x}{A factor}

\item{refs}{A unnamed vector. The values of the vector are levels of
\code{x}.}

\item{missingLevels}{Actions taken in case existing levels are missing:
'pass', 'warning', or 'error'.}

\item{unrecognisedLevels}{Actions taken in case unrecognised levels are
found: 'pass', 'warning', or 'error'.}
}
\value{
A vector of factor
}
\description{
If names contain character strings other than the levels in the old factor
and warning is set to \code{TRUE}, a warning will be raised
}
\examples{

oldFactor <- factor(c("A", "B", "A", "C", "B"), levels=LETTERS[1:3])
refLevels <- c("B", "C", "A")
newFactor <- relevelsByNotNamedVec(oldFactor, refLevels)
stopifnot(identical(newFactor, factor(c("A", "B", "A", "C", "B"), levels=c("B", "C", "A"))))
## TODO: test warning and error


}
