% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramo_outliers.R
\name{tramo_outliers}
\alias{tramo_outliers}
\title{Outlier Detection with a Tramo Model}
\usage{
tramo_outliers(
  y,
  order = c(0L, 1L, 1L),
  seasonal = c(0L, 1L, 1L),
  mean = FALSE,
  X = NULL,
  X.td = NULL,
  ao = TRUE,
  ls = TRUE,
  tc = FALSE,
  so = FALSE,
  cv = 0,
  ml = FALSE,
  clean = FALSE
)
}
\arguments{
\item{y}{the dependent variable (a \code{ts} object).}

\item{order, seasonal}{the orders of the ARIMA model.}

\item{mean}{Boolean to include or not the mean.}

\item{X}{user defined regressors (other than calendar).}

\item{X.td}{calendar regressors.}

\item{ao, ls, so, tc}{Boolean to indicate which type of outliers should be detected.}

\item{cv}{\code{numeric}. The entered critical value for the outliers' detection procedure.
If equal to 0 the critical value for the outliers' detection procedure is automatically determined
by the number of observations.}

\item{ml}{Use of maximum likelihood (otherwise approximation by means of Hannan-Rissanen).}

\item{clean}{Clean missing values at the beginning/end of the series. Regression variables are automatically resized, if need be.}
}
\value{
a \code{"JD3_REGARIMA_OUTLIERS"} object.
}
\description{
Tramo is a particular regarima model estimation algorithm, mainly used to linearized the series before performing a decomposition with Seats
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
tramo_outliers(rjd3toolkit::ABS$X0.2.09.10.M)
\dontshow{\}) # examplesIf}
}
