% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{load.NoiseKriging}
\alias{load.NoiseKriging}
\title{Load a NoiseKriging Model from a file storage}
\usage{
load.NoiseKriging(filename, ...)
}
\arguments{
\item{filename}{File name to load from.}

\item{...}{Not used.}
}
\value{
The loaded NoiseKriging object.
}
\description{
Load a NoiseKriging Model from a file storage
}
\examples{
f <- function(x) 1- 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x)*x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X))
points(X, y, col = "blue")

k <- NoiseKriging(y, (X/10)^2, X, "matern3_2")
print(k)

outfile = tempfile("k.json")
save(k,outfile)

print(load.NoiseKriging(outfile)) 
unlink(outfile)
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
