% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_get_form_metadata.R
\name{scto_unnest_form_definitions}
\alias{scto_unnest_form_definitions}
\title{Unnest previously fetched form definitions}
\usage{
scto_unnest_form_definitions(form_metadata, by_form_id = TRUE)
}
\arguments{
\item{form_metadata}{\code{data.table} returned by \code{\link[=scto_get_form_metadata]{scto_get_form_metadata()}}.}

\item{by_form_id}{Logical indicating whether to unnest definitions of
multiple versions of a given form (default), or to unnest definitions of
all forms together.}
}
\value{
If \code{by_form_id} is \code{TRUE}, a \code{data.table} of \code{data.table}s for the
survey, choices, and settings components of the form definitions. Otherwise
a list of \code{data.table}s.
}
\description{
This function unnests form definitions, e.g., from multiple versions of a
form, which can make it easier to map values to labels in a later step.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
form_metadata = scto_get_form_metadata(auth, 'my_form')
form_defs = scto_unnest_form_definitions(form_metadata)
}

}
