% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotThreeFactor.r
\name{plotThreeFactor}
\alias{plotThreeFactor}
\title{Bar plot of gene expression from an expression table of a three-factorial experiment data}
\usage{
plotThreeFactor(
  data,
  x_col,
  y_col,
  group_col,
  facet_col,
  Lower.se_col,
  Upper.se_col,
  letters_col = NULL,
  show.groupingLetters = TRUE
)
}
\arguments{
\item{data}{A data.frame such as the expression result of \code{ANOVA_DDCt(x)} or \code{ANOVA_DCt(x)}, etc. functions.}

\item{x_col}{column number of the x-axis factor.}

\item{y_col}{column number of the y-axis factor.}

\item{group_col}{column number of the grouping factor.}

\item{facet_col}{column number of the faceting factor.}

\item{Lower.se_col}{The column number of the data.frame used for the lower error bar.}

\item{Upper.se_col}{The column number of the data.frame used for the upper error bar.}

\item{letters_col}{The column number of the data.frame used as the result of statistical comparing and grouping.}

\item{show.groupingLetters}{a logical variable. If TRUE, mean grouping letters (the results of statistical comparison) are added to the bars.}
}
\value{
Bar plot of the average fold change for target genes along with the standard error or 95\% confidence interval as error bars.
}
\description{
Bar plot of the relative expression (\eqn{\Delta C_T} method) of a gene along with the confidence interval and significance
}
\details{
The \code{plotThreeFactor} function generates the bar plot of the average fold change for target genes along with the significance, standard error (se) and the 95\% confidence interval (ci).
}
\examples{



res <- ANOVA_DCt(data_3factor, 
      numberOfrefGenes = 1, 
      block = NULL)
      
data <- res$Results

plotThreeFactor(data, 
                3,   # x-axis factor
                5,   # bar height
                1,   # fill groups
                2,   # facet grid
                11,   # lower SE column
                12,   # upper SE column
                letters_col = 13,
                show.groupingLetters = TRUE)



}
\author{
Ghader Mirzaghaderi
}
