% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rush.R
\name{Rush}
\alias{Rush}
\title{Rush Controller}
\value{
Object of class \link[R6:R6Class]{R6::R6Class} and \code{Rush} with controller methods.
}
\description{
The \code{Rush} controller manages workers in a rush network.
}
\section{Local Workers}{

A local worker runs on the same machine as the controller.
Local workers are spawned with the `$start_local_workers() method via the \CRANpkg{processx} package.
}

\section{Remote Workers}{

A remote worker runs on a different machine than the controller.
Remote workers are spawned with the `$start_remote_workers() method via the \CRANpkg{mirai} package.
}

\section{Script Workers}{

Workers can be started with a script anywhere.
The only requirement is that the worker can connect to the Redis database.
The script is created with the \verb{$worker_script()} method.
}

\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()
   rush = rsh(network_id = "test_network", config = config_local)
   rush
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{network_id}}{(\code{character(1)})\cr
Identifier of the rush network.}

\item{\code{config}}{(\link[redux:redis_config]{redux::redis_config})\cr
Redis configuration options.}

\item{\code{connector}}{(\link[redux:redis_api]{redux::redis_api})\cr
Returns a connection to Redis.}

\item{\code{processes_processx}}{(\link[processx:process]{processx::process})\cr
List of processes started with \verb{$start_local_workers()}.}

\item{\code{processes_mirai}}{(\link[mirai:mirai]{mirai::mirai})\cr
List of mirai processes started with \verb{$start_remote_workers()}.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{n_workers}}{(\code{integer(1)})\cr
Number of workers.}

\item{\code{n_running_workers}}{(\code{integer(1)})\cr
Number of running workers.}

\item{\code{n_terminated_workers}}{(\code{integer(1)})\cr
Number of terminated workers.}

\item{\code{n_killed_workers}}{(\code{integer(1)})\cr
Number of killed workers.}

\item{\code{n_lost_workers}}{(\code{integer(1)})\cr
Number of lost workers.
Run \verb{$detect_lost_workers()} to update the number of lost workers.}

\item{\code{n_pre_workers}}{(\code{integer(1)})\cr
Number of workers that are not yet completely started.}

\item{\code{worker_ids}}{(\code{character()})\cr
Ids of workers.}

\item{\code{running_worker_ids}}{(\code{character()})\cr
Ids of running workers.}

\item{\code{terminated_worker_ids}}{(\code{character()})\cr
Ids of terminated workers.}

\item{\code{killed_worker_ids}}{(\code{character()})\cr
Ids of killed workers.}

\item{\code{lost_worker_ids}}{(\code{character()})\cr
Ids of lost workers.}

\item{\code{pre_worker_ids}}{(\code{character()})\cr
Ids of workers that are not yet completely started.}

\item{\code{tasks}}{(\code{character()})\cr
Keys of all tasks.}

\item{\code{queued_tasks}}{(\code{character()})\cr
Keys of queued tasks.}

\item{\code{running_tasks}}{(\code{character()})\cr
Keys of running tasks.}

\item{\code{finished_tasks}}{(\code{character()})\cr
Keys of finished tasks.}

\item{\code{failed_tasks}}{(\code{character()})\cr
Keys of failed tasks.}

\item{\code{n_queued_tasks}}{(\code{integer(1)})\cr
Number of queued tasks.}

\item{\code{n_queued_priority_tasks}}{(\code{integer(1)})\cr
Number of queued priority tasks.}

\item{\code{n_running_tasks}}{(\code{integer(1)})\cr
Number of running tasks.}

\item{\code{n_finished_tasks}}{(\code{integer(1)})\cr
Number of finished tasks.}

\item{\code{n_failed_tasks}}{(\code{integer(1)})\cr
Number of failed tasks.}

\item{\code{n_tasks}}{(\code{integer(1)})\cr
Number of all tasks.}

\item{\code{worker_info}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Contains information about the workers.}

\item{\code{worker_states}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Contains the states of the workers.}

\item{\code{all_workers_terminated}}{(\code{logical(1)})\cr
Whether all workers are terminated.}

\item{\code{all_workers_lost}}{(\code{logical(1)})\cr
Whether all workers are lost.
Runs \verb{$detect_lost_workers()} to detect lost workers.}

\item{\code{priority_info}}{(\link[data.table:data.table]{data.table::data.table})\cr
Contains the number of tasks in the priority queues.}

\item{\code{snapshot_schedule}}{(\code{character()})\cr
Set a snapshot schedule to periodically save the data base on disk.
For example, \code{c(60, 1000)} saves the data base every 60 seconds if there are at least 1000 changes.
Overwrites the redis configuration file.
Set to \code{NULL} to disable snapshots.
For more details see \href{https://redis.io/docs/latest/operate/oss_and_stack/management/persistence/}{redis.io}.}

\item{\code{redis_info}}{(\code{list()})\cr
Information about the Redis server.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Rush-new}{\code{Rush$new()}}
\item \href{#method-Rush-format}{\code{Rush$format()}}
\item \href{#method-Rush-print}{\code{Rush$print()}}
\item \href{#method-Rush-reconnect}{\code{Rush$reconnect()}}
\item \href{#method-Rush-start_local_workers}{\code{Rush$start_local_workers()}}
\item \href{#method-Rush-start_remote_workers}{\code{Rush$start_remote_workers()}}
\item \href{#method-Rush-worker_script}{\code{Rush$worker_script()}}
\item \href{#method-Rush-restart_workers}{\code{Rush$restart_workers()}}
\item \href{#method-Rush-wait_for_workers}{\code{Rush$wait_for_workers()}}
\item \href{#method-Rush-stop_workers}{\code{Rush$stop_workers()}}
\item \href{#method-Rush-detect_lost_workers}{\code{Rush$detect_lost_workers()}}
\item \href{#method-Rush-reset}{\code{Rush$reset()}}
\item \href{#method-Rush-read_log}{\code{Rush$read_log()}}
\item \href{#method-Rush-print_log}{\code{Rush$print_log()}}
\item \href{#method-Rush-push_tasks}{\code{Rush$push_tasks()}}
\item \href{#method-Rush-push_priority_tasks}{\code{Rush$push_priority_tasks()}}
\item \href{#method-Rush-push_failed}{\code{Rush$push_failed()}}
\item \href{#method-Rush-empty_queue}{\code{Rush$empty_queue()}}
\item \href{#method-Rush-fetch_queued_tasks}{\code{Rush$fetch_queued_tasks()}}
\item \href{#method-Rush-fetch_priority_tasks}{\code{Rush$fetch_priority_tasks()}}
\item \href{#method-Rush-fetch_running_tasks}{\code{Rush$fetch_running_tasks()}}
\item \href{#method-Rush-fetch_finished_tasks}{\code{Rush$fetch_finished_tasks()}}
\item \href{#method-Rush-wait_for_finished_tasks}{\code{Rush$wait_for_finished_tasks()}}
\item \href{#method-Rush-fetch_new_tasks}{\code{Rush$fetch_new_tasks()}}
\item \href{#method-Rush-wait_for_new_tasks}{\code{Rush$wait_for_new_tasks()}}
\item \href{#method-Rush-fetch_failed_tasks}{\code{Rush$fetch_failed_tasks()}}
\item \href{#method-Rush-fetch_tasks}{\code{Rush$fetch_tasks()}}
\item \href{#method-Rush-fetch_tasks_with_state}{\code{Rush$fetch_tasks_with_state()}}
\item \href{#method-Rush-wait_for_tasks}{\code{Rush$wait_for_tasks()}}
\item \href{#method-Rush-write_hashes}{\code{Rush$write_hashes()}}
\item \href{#method-Rush-read_hashes}{\code{Rush$read_hashes()}}
\item \href{#method-Rush-read_hash}{\code{Rush$read_hash()}}
\item \href{#method-Rush-is_running_task}{\code{Rush$is_running_task()}}
\item \href{#method-Rush-is_failed_task}{\code{Rush$is_failed_task()}}
\item \href{#method-Rush-tasks_with_state}{\code{Rush$tasks_with_state()}}
\item \href{#method-Rush-clone}{\code{Rush$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-new"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$new(network_id = NULL, config = NULL, seed = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_id}}{(\code{character(1)})\cr
Identifier of the rush network.
Controller and workers must have the same instance id.
Keys in Redis are prefixed with the instance id.}

\item{\code{config}}{(\link[redux:redis_config]{redux::redis_config})\cr
Redis configuration options.
If \code{NULL}, configuration set by \code{\link[=rush_plan]{rush_plan()}} is used.
If \code{rush_plan()} has not been called, the \code{REDIS_URL} environment variable is parsed.
If \code{REDIS_URL} is not set, a default configuration is used.
See \link[redux:redis_config]{redux::redis_config} for details.}

\item{\code{seed}}{(\code{integer()})\cr
Initial seed for the random number generator.
Either a L'Ecuyer-CMRG seed (\code{integer(7)}) or a regular RNG seed (\code{integer(1)}).
The later is converted to a L'Ecuyer-CMRG seed.
If \code{NULL}, no seed is used for the random number generator.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-format"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-print"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-reconnect"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-reconnect}{}}}
\subsection{Method \code{reconnect()}}{
Reconnect to Redis.
The connection breaks when the Rush object is saved to disk.
Call this method to reconnect after loading the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$reconnect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-start_local_workers"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-start_local_workers}{}}}
\subsection{Method \code{start_local_workers()}}{
Start workers locally with \code{processx}.
The \link[processx:process]{processx::process} are stored in \verb{$processes_processx}.
Alternatively, use \verb{$start_remote_workers()} to start workers on remote machines with \code{mirai}.
Parameters set by \code{\link[=rush_plan]{rush_plan()}} have precedence over the parameters set here.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$start_local_workers(
  worker_loop = NULL,
  ...,
  n_workers = NULL,
  globals = NULL,
  packages = NULL,
  lgr_thresholds = NULL,
  lgr_buffer_size = NULL,
  supervise = TRUE,
  message_log = NULL,
  output_log = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{worker_loop}}{(\code{function})\cr
Loop run on the workers.}

\item{\code{...}}{(\code{any})\cr
Arguments passed to \code{worker_loop}.}

\item{\code{n_workers}}{(\code{integer(1)})\cr
Number of workers to be started.
Default is \code{NULL}, which means the number of workers is set by \code{\link[=rush_plan]{rush_plan()}}.
If \code{rush_plan()} is not called, the default is \code{1}.}

\item{\code{globals}}{(\code{character()})\cr
Global variables to be loaded to the workers global environment.}

\item{\code{packages}}{(\code{character()})\cr
Packages to be loaded by the workers.}

\item{\code{lgr_thresholds}}{(named \code{character()} | named \code{numeric()})\cr
Logger threshold on the workers e.g. \code{c("mlr3/rush" = "debug")}.}

\item{\code{lgr_buffer_size}}{(\code{integer(1)})\cr
By default (\code{lgr_buffer_size = 0}), the log messages are directly saved in the Redis data store.
If \code{lgr_buffer_size > 0}, the log messages are buffered and saved in the Redis data store when the buffer is full.
This improves the performance of the logging.}

\item{\code{supervise}}{(\code{logical(1)})\cr
Whether to kill the workers when the main R process is shut down.}

\item{\code{message_log}}{(\code{character(1)})\cr
Path to the message log files e.g. \verb{/tmp/message_logs/}
The message log files are named \verb{message_<worker_id>.log}.
If \code{NULL}, no messages, warnings or errors are stored.}

\item{\code{output_log}}{(\code{character(1)})\cr
Path to the output log files e.g. \verb{/tmp/output_logs/}
The output log files are named \verb{output_<worker_id>.log}.
If \code{NULL}, no output is stored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-start_remote_workers"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-start_remote_workers}{}}}
\subsection{Method \code{start_remote_workers()}}{
Start workers on remote machines with \code{mirai}.
The \link[mirai:mirai]{mirai::mirai} are stored in \verb{$processes_mirai}.
Parameters set by \code{\link[=rush_plan]{rush_plan()}} have precedence over the parameters set here.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$start_remote_workers(
  worker_loop,
  ...,
  n_workers = NULL,
  globals = NULL,
  packages = NULL,
  lgr_thresholds = NULL,
  lgr_buffer_size = NULL,
  message_log = NULL,
  output_log = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{worker_loop}}{(\code{function})\cr
Loop run on the workers.}

\item{\code{...}}{(\code{any})\cr
Arguments passed to \code{worker_loop}.}

\item{\code{n_workers}}{(\code{integer(1)})\cr
Number of workers to be started.
Default is \code{NULL}, which means the number of workers is set by \code{\link[=rush_plan]{rush_plan()}}.
If \code{rush_plan()} is not called, the default is \code{1}.}

\item{\code{globals}}{(\code{character()})\cr
Global variables to be loaded to the workers global environment.}

\item{\code{packages}}{(\code{character()})\cr
Packages to be loaded by the workers.}

\item{\code{lgr_thresholds}}{(named \code{character()} | named \code{numeric()})\cr
Logger threshold on the workers e.g. \code{c("mlr3/rush" = "debug")}.}

\item{\code{lgr_buffer_size}}{(\code{integer(1)})\cr
By default (\code{lgr_buffer_size = 0}), the log messages are directly saved in the Redis data store.
If \code{lgr_buffer_size > 0}, the log messages are buffered and saved in the Redis data store when the buffer is full.
This improves the performance of the logging.}

\item{\code{message_log}}{(\code{character(1)})\cr
Path to the message log files e.g. \verb{/tmp/message_logs/}
The message log files are named \verb{message_<worker_id>.log}.
If \code{NULL}, no messages, warnings or errors are stored.}

\item{\code{output_log}}{(\code{character(1)})\cr
Path to the output log files e.g. \verb{/tmp/output_logs/}
The output log files are named \verb{output_<worker_id>.log}.
If \code{NULL}, no output is stored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-worker_script"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-worker_script}{}}}
\subsection{Method \code{worker_script()}}{
Generate a script to start workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$worker_script(
  worker_loop,
  ...,
  globals = NULL,
  packages = NULL,
  lgr_thresholds = NULL,
  lgr_buffer_size = NULL,
  heartbeat_period = NULL,
  heartbeat_expire = NULL,
  message_log = NULL,
  output_log = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{worker_loop}}{(\code{function})\cr
Loop run on the workers.}

\item{\code{...}}{(\code{any})\cr
Arguments passed to \code{worker_loop}.}

\item{\code{globals}}{(\code{character()})\cr
Global variables to be loaded to the workers global environment.}

\item{\code{packages}}{(\code{character()})\cr
Packages to be loaded by the workers.}

\item{\code{lgr_thresholds}}{(named \code{character()} | named \code{numeric()})\cr
Logger threshold on the workers e.g. \code{c("mlr3/rush" = "debug")}.}

\item{\code{lgr_buffer_size}}{(\code{integer(1)})\cr
By default (\code{lgr_buffer_size = 0}), the log messages are directly saved in the Redis data store.
If \code{lgr_buffer_size > 0}, the log messages are buffered and saved in the Redis data store when the buffer is full.
This improves the performance of the logging.}

\item{\code{heartbeat_period}}{(\code{integer(1)})\cr
Period of the heartbeat in seconds.
The heartbeat is updated every \code{heartbeat_period} seconds.}

\item{\code{heartbeat_expire}}{(\code{integer(1)})\cr
Time to live of the heartbeat in seconds.
The heartbeat key is set to expire after \code{heartbeat_expire} seconds.}

\item{\code{message_log}}{(\code{character(1)})\cr
Path to the message log files e.g. \verb{/tmp/message_logs/}
The message log files are named \verb{message_<worker_id>.log}.
If \code{NULL}, no messages, warnings or errors are stored.}

\item{\code{output_log}}{(\code{character(1)})\cr
Path to the output log files e.g. \verb{/tmp/output_logs/}
The output log files are named \verb{output_<worker_id>.log}.
If \code{NULL}, no output is stored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-restart_workers"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-restart_workers}{}}}
\subsection{Method \code{restart_workers()}}{
Restart workers.
If the worker is is still running, it is killed and restarted.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$restart_workers(worker_ids, supervise = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{worker_ids}}{(\code{character()})\cr
Worker ids to be restarted.}

\item{\code{supervise}}{(\code{logical(1)})\cr
Whether to kill the workers when the main R process is shut down.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-wait_for_workers"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-wait_for_workers}{}}}
\subsection{Method \code{wait_for_workers()}}{
Wait until workers are registered in the network.
Either \code{n}, \code{worker_ids} or both must be provided.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$wait_for_workers(n = NULL, worker_ids = NULL, timeout = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of workers to wait for.
If \code{NULL}, wait for all workers in \code{worker_ids}.}

\item{\code{worker_ids}}{(\code{character()})\cr
Worker ids to wait for.
If \code{NULL}, wait for any \code{n} workers to be registered.}

\item{\code{timeout}}{(\code{numeric(1)})\cr
Timeout in seconds.
Default is \code{Inf}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-stop_workers"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-stop_workers}{}}}
\subsection{Method \code{stop_workers()}}{
Stop workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$stop_workers(type = "kill", worker_ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{(\code{character(1)})\cr
Type of stopping.
Either \code{"terminate"} or \code{"kill"}.
If \code{"kill"} the workers are stopped immediately.
If \code{"terminate"} the workers evaluate the currently running task and then terminate.
The \code{"terminate"} option must be implemented in the worker loop.}

\item{\code{worker_ids}}{(\code{character()})\cr
Worker ids to be stopped.
Remote workers must all be killed together.
If \code{NULL} all workers are stopped.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-detect_lost_workers"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-detect_lost_workers}{}}}
\subsection{Method \code{detect_lost_workers()}}{
Detect lost workers.
The state of the worker is changed to \code{"lost"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$detect_lost_workers(restart_local_workers = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{restart_local_workers}}{(\code{logical(1)})\cr
Whether to restart lost workers.
Ignored for remote workers.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-reset}{}}}
\subsection{Method \code{reset()}}{
Stop workers and delete data stored in redis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$reset(type = "kill")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{(\code{character(1)})\cr
Type of stopping.
Either \code{"terminate"} or \code{"kill"}.
If \code{"terminate"} the workers evaluate the currently running task and then terminate.
If \code{"kill"} the workers are stopped immediately.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-read_log"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-read_log}{}}}
\subsection{Method \code{read_log()}}{
Read log messages written with the \code{lgr} package from a worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$read_log(worker_ids = NULL, time_difference = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{worker_ids}}{(\code{character(1)})\cr
Worker ids.
If \code{NULL} all worker ids are used.}

\item{\code{time_difference}}{(\code{logical(1)})\cr
Whether to calculate the time difference between log messages.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{\link[data.table:data.table]{data.table::data.table()}}) with level, timestamp, logger, caller and message, and optionally time difference.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-print_log"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-print_log}{}}}
\subsection{Method \code{print_log()}}{
Print log messages written with the \code{lgr} package from a worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$print_log()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-push_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-push_tasks}{}}}
\subsection{Method \code{push_tasks()}}{
Pushes a task to the queue.
Task is added to queued tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$push_tasks(
  xss,
  extra = NULL,
  seeds = NULL,
  timeouts = NULL,
  max_retries = NULL,
  terminate_workers = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xss}}{(list of named \code{list()})\cr
Lists of arguments for the function e.g. \verb{list(list(x1, x2), list(x1, x2)))}.}

\item{\code{extra}}{(\code{list()})\cr
List of additional information stored along with the task e.g. \verb{list(list(timestamp), list(timestamp)))}.}

\item{\code{seeds}}{(\code{list()})\cr
List of L'Ecuyer-CMRG seeds for each task e.g \code{list(list(c(104071, 490840688, 1690070564, -495119766, 503491950, 1801530932, -1629447803)))}.
If \code{NULL} but an initial seed is set, L'Ecuyer-CMRG seeds are generated from the initial seed.
If \code{NULL} and no initial seed is set, no seeds are used for the random number generator.}

\item{\code{timeouts}}{(\code{integer()})\cr
Timeouts for each task in seconds e.g. \code{c(10, 15)}.
A single number is used as the timeout for all tasks.
If \code{NULL} no timeout is set.}

\item{\code{max_retries}}{(\code{integer()})\cr
Number of retries for each task.
A single number is used as the number of retries for all tasks.
If \code{NULL} tasks are not retried.}

\item{\code{terminate_workers}}{(\code{logical(1)})\cr
Whether to stop the workers after evaluating the tasks.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character()})\cr
Keys of the tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-push_priority_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-push_priority_tasks}{}}}
\subsection{Method \code{push_priority_tasks()}}{
Pushes a task to the queue of a specific worker.
Task is added to queued priority tasks.
A worker evaluates the tasks in the priority queue before the shared queue.
If \code{priority} is \code{NA} the task is added to the shared queue.
If the worker is lost or worker id is not known, the task is added to the shared queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$push_priority_tasks(xss, extra = NULL, priority = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xss}}{(list of named \code{list()})\cr
Lists of arguments for the function e.g. \verb{list(list(x1, x2), list(x1, x2)))}.}

\item{\code{extra}}{(\code{list})\cr
List of additional information stored along with the task e.g. \verb{list(list(timestamp), list(timestamp)))}.}

\item{\code{priority}}{(\code{character()})\cr
Worker ids to which the tasks should be pushed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character()})\cr
Keys of the tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-push_failed"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-push_failed}{}}}
\subsection{Method \code{push_failed()}}{
Pushes failed tasks to the data base.
Tasks are moved from queued and running to failed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$push_failed(keys, conditions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{(\code{character(1)})\cr
Keys of the associated tasks.}

\item{\code{conditions}}{(named \code{list()})\cr
List of lists of conditions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-empty_queue"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-empty_queue}{}}}
\subsection{Method \code{empty_queue()}}{
Empty the queue of tasks.
Moves tasks from queued to failed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$empty_queue(keys = NULL, conditions = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{(\code{character()})\cr
Keys of the tasks to be moved.
Defaults to all queued tasks.}

\item{\code{conditions}}{(named \code{list()})\cr
List of lists of conditions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_queued_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_queued_tasks}{}}}
\subsection{Method \code{fetch_queued_tasks()}}{
Fetch queued tasks from the data base.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_queued_tasks(
  fields = c("xs", "xs_extra"),
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "xs_extra")}.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Table of queued tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_priority_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_priority_tasks}{}}}
\subsection{Method \code{fetch_priority_tasks()}}{
Fetch queued priority tasks from the data base.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_priority_tasks(
  fields = c("xs", "xs_extra"),
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "xs_extra")}.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Table of queued priority tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_running_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_running_tasks}{}}}
\subsection{Method \code{fetch_running_tasks()}}{
Fetch running tasks from the data base.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_running_tasks(
  fields = c("xs", "xs_extra", "worker_extra"),
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "xs_extra", "worker_extra")}.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Table of running tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_finished_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_finished_tasks}{}}}
\subsection{Method \code{fetch_finished_tasks()}}{
Fetch finished tasks from the data base.
Finished tasks are cached.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_finished_tasks(
  fields = c("xs", "ys", "xs_extra", "worker_extra", "ys_extra", "condition"),
  reset_cache = FALSE,
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "xs_extra", "worker_extra", "ys", "ys_extra")}.}

\item{\code{reset_cache}}{(\code{logical(1)})\cr
Whether to reset the cache.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Table of finished tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-wait_for_finished_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-wait_for_finished_tasks}{}}}
\subsection{Method \code{wait_for_finished_tasks()}}{
Block process until a new finished task is available.
Returns all finished tasks or \code{NULL} if no new task is available after \code{timeout} seconds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$wait_for_finished_tasks(
  fields = c("xs", "ys", "xs_extra", "worker_extra", "ys_extra"),
  timeout = Inf,
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "xs_extra", "worker_extra", "ys", "ys_extra")}.}

\item{\code{timeout}}{(\code{numeric(1)})\cr
Time to wait for a result in seconds.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Table of finished tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_new_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_new_tasks}{}}}
\subsection{Method \code{fetch_new_tasks()}}{
Fetch finished tasks from the data base that finished after the last fetch.
Updates the cache of the finished tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_new_tasks(
  fields = c("xs", "ys", "xs_extra", "worker_extra", "ys_extra", "condition"),
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Latest results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-wait_for_new_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-wait_for_new_tasks}{}}}
\subsection{Method \code{wait_for_new_tasks()}}{
Block process until a new finished task is available.
Returns new tasks or \code{NULL} if no new task is available after \code{timeout} seconds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$wait_for_new_tasks(
  fields = c("xs", "ys", "xs_extra", "worker_extra", "ys_extra", "condition"),
  timeout = Inf,
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "xs_extra", "worker_extra", "ys", "ys_extra")}.}

\item{\code{timeout}}{(\code{numeric(1)})\cr
Time to wait for new result in seconds.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table() | list()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_failed_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_failed_tasks}{}}}
\subsection{Method \code{fetch_failed_tasks()}}{
Fetch failed tasks from the data base.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_failed_tasks(
  fields = c("xs", "worker_extra", "condition"),
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \verb{c("xs", "xs_extra", "worker_extra", "condition"}.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Table of failed tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_tasks}{}}}
\subsection{Method \code{fetch_tasks()}}{
Fetch all tasks from the data base.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_tasks(
  fields = c("xs", "ys", "xs_extra", "worker_extra", "ys_extra", "condition"),
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "xs_extra", "worker_extra", "ys", "ys_extra", "condition", "state")}.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data.table()}\cr
Table of all tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-fetch_tasks_with_state"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-fetch_tasks_with_state}{}}}
\subsection{Method \code{fetch_tasks_with_state()}}{
Fetch tasks with different states from the data base.
If tasks with different states are to be queried at the same time, this function prevents tasks from appearing twice.
This could be the case if a worker changes the state of a task while the tasks are being fetched.
Finished tasks are cached.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$fetch_tasks_with_state(
  fields = c("xs", "ys", "xs_extra", "worker_extra", "ys_extra", "condition"),
  states = c("queued", "running", "finished", "failed"),
  reset_cache = FALSE,
  data_format = "data.table"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.
Defaults to \code{c("xs", "ys", "xs_extra", "worker_extra", "ys_extra")}.}

\item{\code{states}}{(\code{character()})\cr
States of the tasks to be fetched.
Defaults to \code{c("queued", "running", "finished", "failed")}.}

\item{\code{reset_cache}}{(\code{logical(1)})\cr
Whether to reset the cache of the finished tasks.}

\item{\code{data_format}}{(\code{character()})\cr
Returned data format.
Choose \code{"data.table"} or "list".
The default is \code{"data.table"} but \code{"list"} is easier when list columns are present.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-wait_for_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-wait_for_tasks}{}}}
\subsection{Method \code{wait_for_tasks()}}{
Wait until tasks are finished.
The function also unblocks when no worker is running or all tasks failed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$wait_for_tasks(keys, detect_lost_workers = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{(\code{character()})\cr
Keys of the tasks to wait for.}

\item{\code{detect_lost_workers}}{(\code{logical(1)})\cr
Whether to detect failed tasks.
Comes with an overhead.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-write_hashes"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-write_hashes}{}}}
\subsection{Method \code{write_hashes()}}{
Writes R objects to Redis hashes.
The function takes the vectors in \code{...} as input and writes each element as a field-value pair to a new hash.
The name of the argument defines the field into which the serialized element is written.
For example, \code{xs = list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4))} writes \code{serialize(list(x1 = 1, x2 = 2))} at field \code{xs} into a hash and \code{serialize(list(x1 = 3, x2 = 4))} at field \code{xs} into another hash.
The function can iterate over multiple vectors simultaneously.
For example, \verb{xs = list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4)), ys = list(list(y = 3), list(y = 7))} creates two hashes with the fields \code{xs} and \code{ys}.
The vectors are recycled to the length of the longest vector.
Both lists and atomic vectors are supported.
Arguments that are \code{NULL} are ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$write_hashes(..., .values = list(), keys = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(named \code{list()})\cr
Lists to be written to the hashes.
The names of the arguments are used as fields.}

\item{\code{.values}}{(named \code{list()})\cr
Lists to be written to the hashes.
The names of the list are used as fields.}

\item{\code{keys}}{(character())\cr
Keys of the hashes.
If \code{NULL} new keys are generated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character()})\cr
Keys of the hashes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-read_hashes"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-read_hashes}{}}}
\subsection{Method \code{read_hashes()}}{
Reads R Objects from Redis hashes.
The function reads the field-value pairs of the hashes stored at \code{keys}.
The values of a hash are deserialized and combined to a list.
If \code{flatten} is \code{TRUE}, the values are flattened to a single list e.g. list(xs = list(x1 = 1, x2 = 2), ys = list(y = 3)) becomes list(x1 = 1, x2 = 2, y = 3).
The reading functions combine the hashes to a table where the names of the inner lists are the column names.
For example, \verb{xs = list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4)), ys = list(list(y = 3), list(y = 7))} becomes \code{data.table(x1 = c(1, 3), x2 = c(2, 4), y = c(3, 7))}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$read_hashes(keys, fields, flatten = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{(\code{character()})\cr
Keys of the hashes.}

\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hashes.}

\item{\code{flatten}}{(\code{logical(1)})\cr
Whether to flatten the list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(list of \code{list()})\cr
The outer list contains one element for each key.
The inner list is the combination of the lists stored at the different fields.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-read_hash"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-read_hash}{}}}
\subsection{Method \code{read_hash()}}{
Reads a single Redis hash and returns the values as a list named by the fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$read_hash(key, fields)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(\code{character(1)})\cr
Key of the hash.}

\item{\code{fields}}{(\code{character()})\cr
Fields to be read from the hash.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(list of \code{list()})\cr
The outer list contains one element for each key.
The inner list is the combination of the lists stored at the different fields.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-is_running_task"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-is_running_task}{}}}
\subsection{Method \code{is_running_task()}}{
Checks whether tasks have the status \code{"running"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$is_running_task(keys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{(\code{character()})\cr
Keys of the tasks.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-is_failed_task"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-is_failed_task}{}}}
\subsection{Method \code{is_failed_task()}}{
Checks whether tasks have the status \code{"failed"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$is_failed_task(keys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{(\code{character()})\cr
Keys of the tasks.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-tasks_with_state"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-tasks_with_state}{}}}
\subsection{Method \code{tasks_with_state()}}{
Returns keys of requested states.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$tasks_with_state(states)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{states}}{(\code{character()})\cr
States of the tasks.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(Named list of \code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rush-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Rush-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rush$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
