% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{calculate_discrepancy}
\alias{calculate_discrepancy}
\title{Function to calculate the relative distance between the target distribution and the selected perimeters}
\usage{
calculate_discrepancy(selected_surfaces, target_hist, bins, logaritmic = TRUE)
}
\arguments{
\item{selected_surfaces}{Numeric vector of surface values for the selected events.}

\item{target_hist}{Numeric vector representing the density values of the target histogram.}

\item{bins}{Numeric vector of bin breakpoints used for both histograms.}

\item{logaritmic}{Logical. If `TRUE`, a logarithmic transformation (`log(selected_surfaces + 1e-6)`)
is applied to `selected_surfaces` before calculating its histogram density.}
}
\value{
A numeric value representing the relative discrepancy. A value of 0 indicates a perfect match.
}
\description{
Calculates the relative absolute discrepancy between the density histogram of
a set of `selected_surfaces` and a `target_hist`. This metric quantifies
how well the distribution of the selected surfaces matches the target distribution.
It can optionally apply a logarithmic transformation to the selected surfaces.
}
\examples{
# Example target histogram and bins (from build_target_hist)
historical_sizes_ex <- c(10, 50, 100, 200, 500, 1000)
# Dummy 'event_surfaces' for example context (replace with actual data)
event_surfaces <- c(5, 15, 25, 35, 45, 55)
target_info_ex <- build_target_hist(event_surfaces = event_surfaces,
                                    num_bins = 5,
                                    logaritmic = TRUE,
                                    sizes = historical_sizes_ex)
target_hist_ex <- target_info_ex$target_hist
bins_ex <- target_info_ex$bins

# Example selected surfaces
simulated_surfaces_ex <- c(20, 80, 450, 900)

# Calculate discrepancy with logarithmic transformation
discrepancy_log <- calculate_discrepancy(selected_surfaces = simulated_surfaces_ex,
                                         target_hist = target_hist_ex,
                                         bins = bins_ex,
                                         logaritmic = TRUE)
print(paste("Discrepancy (log):", discrepancy_log))

# Example selected surfaces for linear transformation
simulated_surfaces_linear_ex <- c(15, 60, 110, 210, 480, 950)
target_info_linear_ex <- build_target_hist(event_surfaces = event_surfaces,
                                           num_bins = 5,
                                           logaritmic = FALSE,
                                           sizes = historical_sizes_ex)
target_hist_linear_ex <- target_info_linear_ex$target_hist
bins_linear_ex <- target_info_linear_ex$bins

# Calculate discrepancy with linear transformation
discrepancy_linear <- calculate_discrepancy(selected_surfaces = simulated_surfaces_linear_ex,
                                            target_hist = target_hist_linear_ex,
                                            bins = bins_linear_ex,
                                            logaritmic = FALSE)
print(paste("Discrepancy (linear):", discrepancy_linear))
}
